var queryParam;
var winurlobj = getNeProperty(self);

var destNESet = [];
/*
 Get neid from url param
 */
function getNeID()
{
    return queryParam["neid"];
}

function setButtonStatus(btnStatus)
{
    $("printbtn").disabled = !btnStatus;
    $("saveasfilebtn").disabled = !btnStatus;
    $("querybtn").disabled = !btnStatus;
}

/*
 Get neid from url param
 */
window.onload = function()
{
    queryParam = getNeProperty(top);
    setButtonText();
    setButtonHandler();
    createTable();
    
    sendRightInfo();
    if ($("querybtn").disabled == false) 
    {
        refreshTable();
    }
}

/*
 set button and title text
 */
function setButtonText()
{
    $("title").innerHTML = RESOURCE["oppositenelist"];
    $("countrows").innerHTML = RESOURCE["countrows"];
    $("seleterows").innerHTML = RESOURCE["seleterows"];
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("printbtn").value = RESOURCE["printbutton"];
    $("saveasfilebtn").value = RESOURCE["saveasfilebtn"];
}

/*
 Set button click event handler
 */
function setButtonHandler()
{
    $("querybtn").onclick = refreshTable;
}

function tableSelectHandler(rows)
{
}

/**
 * table selection change
 */
function rowSelected(rows)
{
    refreshCountDiv();
}

function clearTable()
{
    for (var i = 0; i < st0.getDataRowLength(); ++i) 
    {
        st0.deleteRow(i);
    }
    st0.adjustDataRows();
}

/**
 * refresh the count label
 */
function refreshCountDiv()
{
    document.getElementById("countrowsnum").innerHTML = st0.getDataRowLength();
    document.getElementById("seleterowsnum").innerHTML = st0.getSelectedRowCount();
}

/*
 create ecc link table
 */
function createTable()
{
    st0 = new SortTable();
    st0.setImage("../../../../images/");
    st0.setOnRowSelectHandler(rowSelected);
    createTableHead(st0, window.tableconf[0]);
    $("tablecontainer").appendChild(st0.getTable());
    $("tablecontainer").appendChild(st0.getTable());
    st0.setBodyHeight(getTableHeight($("tablecontainer"), st0) + "px");
}

/*
 refresh table data
 */
function refreshTable()
{
    setButtonStatus(false);
    var xml = createRequestData();
    if (null == xml) 
    {
        setButtonStatus(true);
        return;
    }
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_FIBERSEARCH + "&flag=1&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(urlreq, "POST", true, refreshTableCallBack, null, "inputdata=" + xml);
}

/*
 create request data
 */
function createRequestData()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    var neid = getNeID();
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

/*
 Handler response data,construct table data
 */
function refreshTableCallBack(doc)
{
    
    clearTable();
    var dinterface = EncapsulateData(doc);
    setButtonStatus(true);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", dinterface.getError(), errArr)
    }  
    createTableBody(st0, window.tableconf[0], dinterface, RESOURCE);    
    rowSelected();   
    
    destNESet.length = 0;    
    var destLogicID = -1; 
	for(var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
    {		
		destLogicID = dinterface.getDataRowParam(i,"DES_NE_LOGICID");
		if( "/" == dinterface.getDataRowParam(i,"DES_NE_GATEPORT")  && 
			dinterface.getDataRowParam(i,"DES_NE_LOGICID") != undefined 
			&& "-1" != dinterface.getDataRowParam(i,"DES_NE_LOGICID"))
		{
			var farNeObj = new Object();
			farNeObj.neID =  destLogicID;
			farNeObj.soltID =  dinterface.getDataRowParam(i,"DES_NE_SOLT");
			farNeObj.port =  dinterface.getDataRowParam(i,"DES_NE_PORTID");		
			destNESet.push(farNeObj);
		}    	
    }
	
	getFarNEInfo();
	
}


 function getFarNEInfo()
 {	 
	 if(destNESet.length == 0)
	 {
		 return;
	 }	
	 	
	 for(var i = 0; i < destNESet.length; i++)
	 {	 
		 var xml = creategGetFarNEData(i);
		 var farNE = destNESet[i];
		 var urlreq = getRootPath(farNE.neID)+"/neExlorerServlet?sfid=" + TECMDCODE_QUERY_NE_INFO + "&flag=1&nmUser=" + winurlobj["nmUser"]; 
		 loadXMLdoc(urlreq, "POST", true, getFarNeInfoCallBack, null, "inputdata=" + xml);
	 }
 } 
 
 /*
 create request data
 */
function creategGetFarNEData(index)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    
	  var farNE = destNESet[index];	  
	  
	  var row = new tagElement("row-params");
	  var param = new tagElement("param");
	  param.setAttribute("name", "neid");    	  
	  param.setAttribute("value", farNE.neID);
	  row.appendChild(param);
	  
	  var param = new tagElement("param");
	  param.setAttribute("name", "soltid");    	  
	  param.setAttribute("value", farNE.soltID);
	  row.appendChild(param);
	  
	  var param = new tagElement("param");
	  param.setAttribute("name", "portid");    	  
	  param.setAttribute("value", farNE.port);
	  row.appendChild(param);
	  
	  business.appendChild(row);  
      root.getRoot().appendChild(business);  
    
    return root.toString();
}

function getFarNeInfoCallBack(doc)
{
	var data = EncapsulateData(doc);
	 for(var i = 0, len = st0.getDataRowLength(); i < len; i++)
	 {
		   var farNEID = st0.getCellStoreValue(i,"DES_NE_LOGICID","DES_NE_LOGICID");
		   var farSolt = st0.getCellStoreValue(i,"DES_NE_SOLT","DES_NE_SOLT");
		   var farPortID = st0.getCellStoreValue(i,"DES_NE_PORTID","DES_NE_PORTID");
		   
		   for(var j = 0, size = data.getDataRowLength(); j < size; j++)
			{
			   if(farNEID == data.getDataRowParam(j,"DES_NE_LOGICID") &&
				  farSolt == data.getDataRowParam(j,"DES_NE_SOLT") &&
				  farPortID == data.getDataRowParam(j,"DES_NE_PORTID"))
				{
				   var neGatePort = data.getDataRowParam(j,"DES_NE_GATEPORT");
				   var gateAddr = data.getDataRowParam(j,"DES_NE_GATEADDR");
				   var neName = data.getDataRowParam(j,"DES_NE_NAME");
				   var nePort= data.getDataRowParam(j,"DES_NE_PORT");
				   
				   st0.getCellShow(i, "DES_NE_GATEPORT").setValue(neGatePort);
				   st0.getCellShow(i, "DES_NE_GATEADDR").setValue(gateAddr);
				   st0.getCellShow(i, "DES_NE_NAME").setValue(neName);
				   st0.getCellShow(i, "DES_NE_PORT").setValue(nePort);
				   
				   st0.setCellValue(st0.getCell(i, "DES_NE_GATEPORT"), "DES_NE_GATEPORT", neGatePort);
				   st0.setCellValue(st0.getCell(i, "DES_NE_GATEADDR"), "DES_NE_GATEADDR", gateAddr);
				   st0.setCellValue(st0.getCell(i, "DES_NE_NAME"), "DES_NE_NAME", neName);
				   st0.setCellValue(st0.getCell(i, "DES_NE_PORT"), "DES_NE_PORT", nePort);
				}  
			} 
	  }
}
 
 

/**
         
 **/
function printInfo()
{
    if (0 == st0.getDataRowLength()) 
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    openPrintPage('../../../../page/', RESOURCE["oppositenelist"], 'st0', true);
}

function SaveAsInfo()
{
    if (0 == st0.getDataRowLength()) 
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    openSaveAsPage('../../../../page/', "Remote_NE_List", 'st0', RESOURCE["oppositenelist"],true);
}

/**
 *       
 * @param  
 * @return  
 */
function sendRightInfo()
{
    var url = "../../../../securityServlet?neID=" + winurlobj["neid"] + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

/**
 *           XML
 * @param  
 * @return  
 */
function createRightXML()
{
    var root = new inputxml("datainterface");//Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    
    var secondlevel = null;
    ;
    var thirdlevel = null;
    
    secondlevel = new tagElement("row-params"); //bean         	
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "btnID");
    thirdlevel.setAttribute("value", "querybtn");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "sfid");
    thirdlevel.setAttribute("value", TECMDCODE_GET_FIBERSEARCH);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
}

/**
 *           
 * @param  
 * @return  
 */
function rightHandleBack(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0; i < data.getDataRowLength(); i++) //       
     {
        var right = data.getDataRowParam(i, "right");
        
        rightArray[i] = right;
        
        if (0 == right) 
        {
            $(data.getDataRowParam(i, "btnID")).disabled = true;
        }
        else 
        {
            $(data.getDataRowParam(i, "btnID")).disabled = false;
        }
    }
}
