var winurlobj = getNeProperty(self);

var ids = null;

var hasApplyRight = true;

var loopBack = [];
loopBack[0] = RESOURCE["notLoopBack"];
loopBack[1] = RESOURCE["inLoopBack"];
loopBack[2] = RESOURCE["outLoopBack"];

var ENUM_NOT_LOOPBACK = 0;
var ENUM_IN_LOOPBACK = 1;

var backupWorkStatus = null;

var workStatus = [];
workStatus[0] = RESOURCE["notWork"];
workStatus[1] = RESOURCE["Work"];

var switchStatus = [];
switchStatus[0] = RESOURCE["closed"];
switchStatus[1] = RESOURCE["opened"];

var antennapolarweid = [];
antennapolarweid[0] = RESOURCE["h_weid"];
antennapolarweid[1] = RESOURCE["v_weid"];

var quipType = [];
quipType[5] = RESOURCE["sdh"];
quipType[10] = RESOURCE["pdh"];
var hlStation = [];
hlStation[5] = RESOURCE["lStation"];
hlStation[10] = RESOURCE["hStation"];

var powerGrade = [];
powerGrade[5] = RESOURCE["Standard"];
powerGrade[10] = RESOURCE["High"];

var BDTpye = [];
BDTpye[0] = RESOURCE["fixed"];
BDTpye[1] = RESOURCE["max"];

var userRightObject = [];


var bandWidth = -1;
var revPowerMin = "-90.0";
var revPowerMax = "25.5";
var rfLoopRange = null;
var trintervalList = [];


/**
 * TAB         
 * @param   
 * @return  
 */
function tabSelectHandler()
{
    st.setBodyHeight(getComponetHeight($("tablecomponent"), 100) + "px");
    if (userRightObject["querybtn"])
    {
        sendQueryInfo();
    }
}

function initpage()
{
    st = new SortTable();
    st.setImage("../../../../images/");
    
    tc = window.tableconf[0];
    var attrArr = getNeProperty(self)["supportAttr"].split(",");
    
    filterAttrCol(tc, attrArr);
    ids = getIDs();
    createTableHead(st, tc);
    
    st.setOnCellEditHandler(cellEditHandler);//         
    if (isIE) 
    {
        $("tablecomponent").style.width = "100%";
        $("buttons").style.width = "100%";
    }
    else 
    {
        $("tablecomponent").style.width = "98%";
        $("buttons").style.width = "98%";
    }
    
    document.getElementById("tablecomponent").appendChild(st.getTable());
    
    window.onresize = function()
    {
        st.setBodyHeight(getTableHeight($("tablecomponent"), st) + "px");
    }
    $("tablecomponent").oncontextmenu = popupMenuHandler;
    
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    sendRightInfo();
}

function sendQueryInfo()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var neid = winurlobj.neid;
    var slotid = winurlobj.slotid;
    var xmlstr = createQueryXML(neid, slotid, tc);
    
    var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
    if(isRFIterface)
    {
        urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_RF_INTERFACE + "&nmUser=" + winurlobj["nmUser"];
    }
    else
    {
        urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE + "&nmUser=" + winurlobj["nmUser"];
    }
    loadXMLdoc(urlreq, "POST", true, queryCallBack, null, "inputdata=" + xmlstr);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = false;
    
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 2) 
    {
        showErrorDialog(data);
        return;
    }
    for (var i = 0; i < data.getDataRowLength(); i++) 
    {
        var diobj = data.rows[i];
        
        if (null != diobj["LOWFRE"] && "/" != diobj["LOWFRE"].value) 
        {
            var value = diobj["LOWFRE"].value;
            if ("-1" != value && "/" != value) 
            {
                var hightrfe = diobj["W32BRD_ATTR_WORKRANGE"].value;
                value = "[" + value + "," + hightrfe + "]";
            }
            diobj["LOWFRE"].value = value;
        }
        
        if (null != diobj["LOWPOWER"] && "/" != diobj["LOWPOWER"].value) 
        {
            var value = diobj["LOWPOWER"].value;
            if ("-1" != value && "/" != value) 
            {
                var hightrfe = diobj["W32BRD_ATTR_ACTRANGEOFPOWER"].value;
                value = "[" + value + "," + hightrfe + "]";
            }
            diobj["LOWPOWER"].value = value;
        }
        
        if (null != diobj["W32BRD_ATTR_TRINTERVALP"]) 
        {
            var value = diobj["W32BRD_ATTR_TRINTERVALP"].value;
            diobj["W32BRD_ATTR_TRINTERVALP"].value = value / 1000;
        }
        
        if (null != diobj["W32BRD_ATTR_ACTRECEIVEPOWER"]) 
        {//      
            var value = diobj["W32BRD_ATTR_ACTRECEIVEPOWER"].value;
            if (null != diobj["ifBandwidth"]) 
            {//        -1              RSSI    
                bandWidth = diobj["ifBandwidth"].value;
                if (null != repairValue[bandWidth]) 
                {
                    diobj["W32BRD_ATTR_ACTRECEIVEPOWER"].value = ((value * 10) - (repairValue[bandWidth] * 10)) / 10;
                }
            }
        }
		
        if(null != diobj["W32BRD_ATTR_ACTTRANSMITPOWER"] && "/" != diobj["W32BRD_ATTR_ACTTRANSMITPOWER"].value)
        {
            var value = diobj["W32BRD_ATTR_ACTTRANSMITPOWER"].value;
            if("-55" == value )
            {
                diobj["W32BRD_ATTR_ACTTRANSMITPOWER"].value = RESOURCE["closed"];
            }
        }
        
		if(null != diobj["W32BRD_ATTR_RECEIVEPOWER"] && null != diobj["W32BRD_ATTR_RECEIVEPOWER"].options)
        {
        	revPowerMin = diobj["W32BRD_ATTR_RECEIVEPOWER"].options[0];
			revPowerMax = diobj["W32BRD_ATTR_RECEIVEPOWER"].options[1];
        }
		
		if(null != diobj["W32BRD_ATTR_RFLOOPBACK"] && null != diobj["W32BRD_ATTR_RFLOOPBACK"].options)
        {
			rfLoopRange = diobj["W32BRD_ATTR_RFLOOPBACK"].options;
        }
		
		if(null != diobj["W32BRD_ATTR_TRINTERVAL_LIST"] && null != diobj["W32BRD_ATTR_TRINTERVAL_LIST"].options)
        {
			trintervalList = diobj["W32BRD_ATTR_TRINTERVAL_LIST"].options;
        }
    }
    
    createGenCfgTableBody(st, tc, data, RESOURCE);
    
    addListener();
    
    if (data.getSErrorCode() == 0) 
    {
        return;
    }
    
    showErrorDialog(data);
}

function addListener()
{
	var cell;
    var cellEdit;
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
    	var range = ["0.000", "4294967.295"];
    	if (ids.contains("W32BRD_ATTR_WORKRANGE")) 
        {
            var actcellrange = st.getCell(i, "W32BRD_ATTR_WORKRANGE").element.showElement.getValue();
            if ((null != actcellrange) && ("/" != actcellrange)) 
            {
                actcellrange = actcellrange.substring(1, actcellrange.length - 1);
                range = actcellrange.split(",");
            }
        }
    	
        if (ids.contains("W32BRD_ATTR_TRANSMITFRE")) 
        {
            var radioLinkid = st.getCellEdit(i, "W32BRD_ATTR_TRANSMITFRE");
            
            textCheck(radioLinkid.element, range[0], range[1], 3);
        }
        
        if (ids.contains("W32BRD_ATTR_TRINTERVAL")) 
        {
			var trinterval = st.getCellEdit(i, "W32BRD_ATTR_TRINTERVAL");
        	textCheck(trinterval.element, "0.000", "4294967.295", 3);
        }
        
        if (ids.contains("W32BRD_ATTR_MAXTRANSMITPOWER")) 
        {
            var trinterval = st.getCellEdit(i, "W32BRD_ATTR_MAXTRANSMITPOWER");
            textCheck(trinterval.element, "-10.0", "35.0");
            
            if (ids.contains("W32BRD_ATTR_ACTRANGEOFPOWER")) 
            {
                var actcellrange = st.getCell(i, "W32BRD_ATTR_ACTRANGEOFPOWER").element.showElement.getValue();
                if ((null != actcellrange) && ("/" != actcellrange)) 
                {
                    actcellrange = actcellrange.substring(1, actcellrange.length - 1);
                    var range = actcellrange.split(",");
                    textCheck(trinterval.element, range[0], range[1]);
                }
                else 
                {
                    textCheck(trinterval.element, "-10.0", "35.0");
                }
            }
            else 
            {
                textCheck(trinterval.element, "-10.0", "35.0");
            }
        }
        
        if (ids.contains("W32BRD_ATTR_TRANSMITPOWER")) 
        {
            var trinterval = st.getCellEdit(i, "W32BRD_ATTR_TRANSMITPOWER");
            var cellShow = st.getCellShow(i, "W32BRD_ATTR_TRANSMITPOWER");
            if (trinterval.value == "/") 
            {
                trinterval.element.ondblclick = function()
                {
                    cellShow.setValue("0");
                    st.setCellValue(trinterval, "W32PORT_ATTR_WAYSIDEINPUT", "0");
                }
            }
            if (ids.contains("W32BRD_ATTR_ACTRANGEOFPOWER")) 
            {
                var actcellrange = st.getCell(i, "W32BRD_ATTR_ACTRANGEOFPOWER").element.showElement.getValue();
                if ((null != actcellrange) && ("/" != actcellrange)) 
                {
                    actcellrange = actcellrange.substring(1, actcellrange.length - 1);
                    var range = actcellrange.split(",");
                    textCheck(trinterval.element, range[0], range[1]);
                }
                else 
                {
                    textCheck(trinterval.element, "-10.0", "35.0");
                }
            }
            else 
            {
                textCheck(trinterval.element, "-10.0", "35.0");
            }
        }
		if(ids.contains("W32BRD_ATTR_TXTHRESHOLDHIGH"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_TXTHRESHOLDHIGH");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_TXTHRESHOLDHIGH");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			textCheck(trinterval.element,"-10.0","35.0");
		}
		
		
		
		if(ids.contains("W32BRD_ATTR_TXTHRESHOLDLOW"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_TXTHRESHOLDLOW");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_TXTHRESHOLDLOW");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			textCheck(trinterval.element,"-10.0","35.0");
		}
		if(ids.contains("W32BRD_ATTR_RXTHRESHOLDHIGH"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_RXTHRESHOLDHIGH");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_RXTHRESHOLDHIGH");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			
			if(winurlobj.neType == "115")
            {
			 textCheck(trinterval.element,"-78.0","-23.0");
            }else{
            	textCheck(trinterval.element,"-90.0","-20.0");
            }   		 			 			
		}
		
		if(ids.contains("W32BRD_ATTR_RXTHRESHOLDLOW"))
		{
			var trinterval = st.getCellEdit(i,"W32BRD_ATTR_RXTHRESHOLDLOW");
			var cellShow = st.getCellShow(i,"W32BRD_ATTR_RXTHRESHOLDLOW");
			if(trinterval.value == "/")
			{
				trinterval.element.ondblclick = function()
				{
					cellShow.setValue("0");
	        		st.setCellValue(trinterval,"W32PORT_ATTR_WAYSIDEINPUT","0");
				}
			}
			
			if(winurlobj.neType == "115")
            {
			 textCheck(trinterval.element,"-78.0","-23.0");
            }else{
            	textCheck(trinterval.element,"-90.0","-20.0");
            }  
		}

        if (ids.contains("W32BRD_ATTR_RECEIVEPOWER")) 
        {
            var trinterval = st.getCellEdit(i, "W32BRD_ATTR_RECEIVEPOWER");

            if((winurlobj.neType == "92") || (winurlobj.neType == "115"))
            {
            	textCheck(trinterval.element,revPowerMin,revPowerMax);
            }else{
            	textCheck(trinterval.element, revPowerMin, revPowerMax,1,"-10.0");
            }    
        }
        if (ids.contains("W32BRD_ATTR_ACTRECEIVEPOWER")) 
        {
            initautoquery(winurlobj.slotid);
        }
        
        if (ids.contains("W32BRD_ATTR_WORKSTATUS")) 
        {
        	backupWorkStatus = st.getCellStoreValue(i, "W32BRD_ATTR_WORKSTATUS", "W32BRD_ATTR_WORKSTATUS");
        }  
        
        if (ids.contains("W32BRD_ATTR_REMARK")) 
        {     
	    	if(SYSTEMCONF.getStatus() == '1')
		    {
	          var remarkCell = st.getCell(i, "W32BRD_ATTR_REMARK");
	          if(remarkCell != null)
	          {
	            st.setCellIsEdit(remarkCell, 0);
	          }
		    }
        }
        if (ids.contains("W32BRD_ATTR_RFLOOPBACK")) 
        {        	
            var rfLoopback = st.getCellEdit(i, "W32BRD_ATTR_RFLOOPBACK");            
              
            var rfLoopbackValue = st.getCellStoreValue(i, "W32BRD_ATTR_RFLOOPBACK", "W32BRD_ATTR_RFLOOPBACK");
           
            rfLoopkbackCellEditHandler(i, rfLoopbackValue);
            rfLoopkbackCellEvent(st.getCell(i,"W32BRD_ATTR_RFLOOPBACK"));   
           
            
            var rfLoopbackShow = st.getCellShow(i, "W32BRD_ATTR_RFLOOPBACK");
			if (rfLoopRange)
			{
				rfLoopback.clearOptions();
				for (var j = 0, m = rfLoopRange.length; j < m; j++) 
				{
					rfLoopback.addOption(loopBack[rfLoopRange[j]], rfLoopRange[j]);
				}
			}
            
            if ("/" == rfLoopbackValue || null == rfLoopbackValue || "-" == rfLoopbackValue) 
            {
                cell = st.getCell(i, "W32BRD_ATTR_RFLOOPBACK");
                st.setCellIsEdit(cell, 0);
                cell.element.style.backgroundColor = "";
                cell.element.ondblclick = null;
            }			
        }
    }
}

/**
 *     : TRANSV1R5-1741  
 *    : f00177546
 *     : add the cell change event,When in Loopback, then work status can not edit
 * @param cell
 * @return
 */

function rfLoopkbackCellEvent(editCell)
{
	var atom = editCell.element.editElement;
	if(null != atom)
	{
		atom.element["onchange"] = function()
		{
			rfLoopkbackCellChangeHandler(this);
		}
	}
} 

/**
 *     : TRANSV1R5-1741  
 *    : f00177546
 *     : add the cell change event,When in Loopback, then work status can not edit
 * @param cell
 * @return
 */
function rfLoopkbackCellChangeHandler(atom)
{
	var rowindex = atom.parentNode.parentNode.rowIndex;
	var value = atom.value;
	 
	var rfLoopValue = st.getCellStoreValue(rowindex,"W32BRD_ATTR_RFLOOPBACK","W32BRD_ATTR_RFLOOPBACK");
	if(typeof(value) != "undefined" && value != null)
	{
		rfLoopValue = value;
	}
	
	rfLoopkbackCellEditHandler(rowindex, rfLoopValue);
		
}

/**
 *     : TRANSV1R5-1741  
 *    : f00177546
 *     : add the cell change event,When in Loopback, then work status can not edit
 * @param cell
 * @return
 */
function rfLoopkbackCellEditHandler(rowindex, rfLoopValue)
{	
	var workStatusCell = st.getCell(rowindex, "W32BRD_ATTR_WORKSTATUS");	
	var workStatusValue = st.getCellStoreValue(rowindex, "W32BRD_ATTR_WORKSTATUS", "W32BRD_ATTR_WORKSTATUS");
	if(rfLoopValue == ENUM_IN_LOOPBACK)// in Loopback
	{	
		if(workStatusValue  != backupWorkStatus)
		{
			workStatusCell.element.showElement.setValue(workStatus[backupWorkStatus]);
			st.setCellValue(workStatusCell, "W32BRD_ATTR_WORKSTATUS", backupWorkStatus);
			st.setCellModify(rowindex, "W32BRD_ATTR_WORKSTATUS", false);
		}
		if(workStatusCell.element.isEdit != "0")
		{
			st.setCellIsEdit(workStatusCell,"0");			
		}
	}
	else
	{
		if(workStatusCell.element.isEdit != "1")
		{
			st.setCellIsEdit(workStatusCell,"1");
		}
	}
}



/**
 *         
 */
function updataPower(power)
{
    var receivePowerCellShow = st.getCellShow(0, "W32BRD_ATTR_ACTRECEIVEPOWER");
    receivePowerCellShow.setValue(power);
}

function sendSetInfo()
{
	var cell = null;
	var isNeedAlert = false;
	for (var i = 0, size = st.getDataRowLength(); i < size; i++)
    {
    	if (st.getModify(i))
    	{
    		cell = st.getCell(i, "W32BRD_ATTR_TRANSMITFRE");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_TRANSMITFRE")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "W32BRD_ATTR_TRINTERVAL");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_TRINTERVAL")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "W32BRD_ATTR_MAXTRANSMITPOWER");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_MAXTRANSMITPOWER")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "W32BRD_ATTR_TRANSMITPOWER");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_TRANSMITPOWER")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "W32BRD_ATTR_RECEIVEPOWER");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_RECEIVEPOWER")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "W32BRD_ATTR_TXTHRESHOLDHIGH");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_TXTHRESHOLDHIGH")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "W32BRD_ATTR_TXTHRESHOLDLOW");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_TXTHRESHOLDLOW")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "W32BRD_ATTR_RXTHRESHOLDHIGH");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_RXTHRESHOLDHIGH")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	cell = st.getCell(i, "W32BRD_ATTR_RXTHRESHOLDLOW");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_RXTHRESHOLDLOW")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
        	
        	cell = st.getCell(i, "W32BRD_ATTR_ANTENNA_POLAR_WBID");
        	if (typeof(cell) != 'undefined' && st.getCellModify(i, "W32BRD_ATTR_ANTENNA_POLAR_WBID")) 
        	{
        		isNeedAlert = true;
        		break;
        	}
    	}
    }
    
    if (isNeedAlert)
    {
    	if (!confirm(RESOURCE["DANGER_ALARM"])) 
	    {
	        return;
	    }
    }
	if(!verifyBeforeSend())
	{
		return;
	}
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var ids = getIDs();
    
    
    if (ids.contains("W32BRD_ATTR_MAXTRANSMITPOWER")) 
    {
       var cell = st.getCell(0, "W32BRD_ATTR_MAXTRANSMITPOWER");
        var storeValue = st.getCellStoreValue(0, "W32BRD_ATTR_MAXTRANSMITPOWER", "W32BRD_ATTR_MAXTRANSMITPOWER");
        st.setCellValue(cell, "W32BRD_ATTR_MAXTRANSMITPOWER", Math.round(storeValue * 10));
    }
    if(ids.contains("W32BRD_ATTR_TXTHRESHOLDHIGH") || ids.contains("W32BRD_ATTR_TXTHRESHOLDLOW"))
    {
    	var cell = st.getCell(0,"W32BRD_ATTR_TXTHRESHOLDHIGH");
    	var storeValue = st.getCell(0,"W32BRD_ATTR_TXTHRESHOLDHIGH").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_TXTHRESHOLDHIGH",storeValue.replace(".", ""));
    	
    	cell = st.getCell(0,"W32BRD_ATTR_TXTHRESHOLDLOW");
      storeValue = st.getCell(0,"W32BRD_ATTR_TXTHRESHOLDLOW").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_TXTHRESHOLDLOW",storeValue.replace(".", ""));
    }    
    
    if(ids.contains("W32BRD_ATTR_RXTHRESHOLDHIGH") || ids.contains("W32BRD_ATTR_RXTHRESHOLDLOW"))
    {
    	var cell = st.getCell(0,"W32BRD_ATTR_RXTHRESHOLDHIGH");
    	var storeValue = st.getCell(0,"W32BRD_ATTR_RXTHRESHOLDHIGH").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_RXTHRESHOLDHIGH",storeValue.replace(".", ""));
    	
    	cell = st.getCell(0,"W32BRD_ATTR_RXTHRESHOLDLOW");
    	storeValue = st.getCell(0,"W32BRD_ATTR_RXTHRESHOLDLOW").element.showElement.getValue();
    	st.setCellValue(cell,"W32BRD_ATTR_RXTHRESHOLDLOW",storeValue.replace(".", ""));
    }
    
    if (ids.contains("W32BRD_ATTR_TRANSMITPOWER")) 
    {
        var cell = st.getCell(0, "W32BRD_ATTR_TRANSMITPOWER");
        var storeValue = st.getCellStoreValue(0, "W32BRD_ATTR_TRANSMITPOWER", "W32BRD_ATTR_TRANSMITPOWER");
        st.setCellValue(cell, "W32BRD_ATTR_TRANSMITPOWER", Math.round(storeValue * 10));
    }
    if (ids.contains("W32BRD_ATTR_RECEIVEPOWER")) 
    {
        var cell = st.getCell(0, "W32BRD_ATTR_RECEIVEPOWER");
        var storeValue = st.getCellStoreValue(0, "W32BRD_ATTR_RECEIVEPOWER", "W32BRD_ATTR_RECEIVEPOWER");
        st.setCellValue(cell, "W32BRD_ATTR_RECEIVEPOWER", Math.round(storeValue * 10));
    }

    if (ids.contains("W32BRD_ATTR_TRANSMITFRE")) 
    {
        var cell = st.getCell(0, "W32BRD_ATTR_TRANSMITFRE");
        var storeValue = st.getCellStoreValue(0, "W32BRD_ATTR_TRANSMITFRE", "W32BRD_ATTR_TRANSMITFRE");
        st.setCellValue(cell, "W32BRD_ATTR_TRANSMITFRE", Math.round(storeValue * 1000));
    }
    
    if (ids.contains("W32BRD_ATTR_TRINTERVAL")) 
    {
        var cell = st.getCell(0, "W32BRD_ATTR_TRINTERVAL");
        var storeValue = st.getCellStoreValue(0, "W32BRD_ATTR_TRINTERVAL", "W32BRD_ATTR_TRINTERVAL");
        st.setCellValue(cell, "W32BRD_ATTR_TRINTERVAL", Math.round(storeValue * 1000));
    }
    
    if (ids.contains("W32BRD_ATTR_TRANSMITFRE")) 
    {
        for (var i = 0, size = st.getDataRowLength(); i < size; i++) 
        {
            if (!event) 
            {
                event = window.event;
            }
        }
    }
    
    var neid = winurlobj.neid;

    var xmlStr = createSetXML(neid, st, tc);
    if (null == xmlStr) 
    {
        $("querybtn").disabled = false;
        $("applybtn").disabled = false;
        return;
    }
    
    var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
    if(isRFIterface)
    {
        urlreq = "../../../../neExlorerServlet?sfid=" + SET_RF_INTERFACE + "&nmUser=" + winurlobj["nmUser"];
    }
    else
    {
        urlreq = "../../../../neExlorerServlet?sfid=" + SET_ODU_INTERFACE + "&nmUser=" + winurlobj["nmUser"];
    }
    loadXMLdoc(urlreq, "POST", true, setCallBack, null, "inputdata=" + xmlStr);
}

function setCallBack(doc)
{
    var data = EncapsulateData(doc);
    $("querybtn").disabled = false;
    if (data.getSErrorCode() != 0) 
    {
        showErrorDialog(data);
        $("applybtn").disabled = false;
    }
    refreshTableState(st, tc, data);
}

function getIDs()
{
    var ids = new Array();
    for (var i = 0, len = tc.getColsLength(); i < len; i++) 
    {
        ids[ids.length] = tc.getColId(i);
    }
    return ids;
}


function showErrorDialog(data)
{
    var errArr = [];
    var errorObj = null;
    var tmpName = null;
    for (var i = data.getBErrLength() - 1; i >= 0; i--) 
    {
        errorObj = data.getError().rowErrors[i].errorObj;
        if (errorObj["attrId"] == "W32BRD_ATTR_WORKRANGE") 
        {
            errorObj["attrId"] = RESOURCE["W32BRD_ATTR_WORKRANGE"];
        }
        else if (errorObj["attrId"] == "W32BRD_ATTR_ACTRANGEOFPOWER") 
        {
            errorObj["attrId"] = RESOURCE["W32BRD_ATTR_ACTRANGEOFPOWER"];
        }
        else 
        {
            tmpName = data.getError().getRowKey(i, "attrId");
            errorObj["attrId"] = getAttrName(tc, tmpName);
            if (errorObj["attrId"] == tmpName) 
            {
                data.getError().rowErrors.removeAt(i);
                continue;
            }
        }
        
        errorObj["operationObj"] = errorObj["nename"] + "-" + errorObj["slotid"] + "-" + errorObj["boardname"] +
        "-" +
        errorObj["attrId"];
        
    }
    
    errArr[0] = "operationObj";
    openErrPage("../../../../page/", data.getError(), errArr);
    errArr = null;
}

/**
 *               
 * @param  
 * @return  
 */
function cellEditHandler(param)
{
	var i = param.rowindex;
	var element;
	if(param.stage == TABLE_CONSTANT.BEFOREEDIT && param.colid == "W32BRD_ATTR_TRINTERVAL")
	{
		var cell = param.st.getCell(i, "W32BRD_ATTR_TRINTERVAL");
	    var atom = null;
	    if(trintervalList && trintervalList.length > 0 && cell.element.editElement.type != "select")
	    {
	        atom = param.st.createAtom("select");
	        for (var j = 0, m = trintervalList.length; j < m; j++) 
			{
				atom.addOption(trintervalList[j],trintervalList[j]);
			}
	        cell.element.editElement.type = "select";
	        atom.element.onblur= cellonblur;	        
	    }
	    
	    if(atom != null)
	    {
	    	var value = cell.element.storeValue["W32BRD_ATTR_TRINTERVAL"];
	    	atom.setValue(value);
	    	param.st.replaceCellEdit("W32BRD_ATTR_TRINTERVAL",atom);
	    	cell.element.style.backgroundColor = "#d0f946";
	        cell.element.modify = true;  
	        cell.element.parentNode.modify = true; 
	    }
	}
	
	if( param.colid == "W32BRD_ATTR_TRANSMITPOWER" )
	{
		var txPowerCellEdit = st.getCellEdit(i, "W32BRD_ATTR_TRANSMITPOWER", "W32BRD_ATTR_TRANSMITPOWER");

		if( ids.contains("W32BRD_ATTR_ACTRANGEOFPOWER") )
		{
			var actcellrange = st.getCell(i, "W32BRD_ATTR_ACTRANGEOFPOWER").element.showElement.getValue();
            
	        if( (null != actcellrange) && ("/" != actcellrange) ) 
	        {
	        	actcellrange = actcellrange.substring(1, actcellrange.length - 1);
	            var range = actcellrange.split(",");
	            
	            if( ids.contains("W32BRD_ATTR_MAXTRANSMITPOWER") )
	            {
	            	var maxTxCellShow = st.getCellShow(i, "W32BRD_ATTR_MAXTRANSMITPOWER");

	            	textCheck(txPowerCellEdit.element, range[0], maxTxCellShow.getValue());
	            }
	            else
	            {
	            	textCheck(txPowerCellEdit.element, range[0], range[1]);
	            }
	        }
	        else 
	        {
	            textCheck(txPowerCellEdit.element, "-10.0", "35.0");
	        }	
		}
	}
	
	
	if( param.colid == "W32BRD_ATTR_MAXTRANSMITPOWER" )
	{
        var trinterval = st.getCellEdit(i, "W32BRD_ATTR_MAXTRANSMITPOWER");
        textCheck(trinterval.element, "-10.0", "35.0");
        
        if (ids.contains("W32BRD_ATTR_ACTRANGEOFPOWER")) 
        {
            var actcellrange = st.getCell(i, "W32BRD_ATTR_ACTRANGEOFPOWER").element.showElement.getValue();
            if ((null != actcellrange) && ("/" != actcellrange)) 
            {
                actcellrange = actcellrange.substring(1, actcellrange.length - 1);
                var range = actcellrange.split(",");
                
	            if( ids.contains("W32BRD_ATTR_TRANSMITPOWER") )
	            {
	            	var txCellShow = st.getCellShow(i, "W32BRD_ATTR_TRANSMITPOWER");
                    var min = txCellShow.getValue();
                    var max = range[1];

	            	if(parseFloat(min) > parseFloat(max))
	            	{
	            		min = range[0];
	            	}
	            	
	            	textCheck(trinterval.element, min,max);
	            }
	            else
	            {
	            	textCheck(trinterval.element, range[0], range[1]);
	            }
            }
            else 
            {
                textCheck(trinterval.element, "-10.0", "35.0");
            }
        }
        else 
        {
            textCheck(trinterval.element, "-10.0", "35.0");
        }
	}
	
    if (userRightObject["applybtn"]) 
    {
        $("applybtn").disabled = false;
    }
}


function lowpowerConvert(value)
{
    if ("-1" == value || "/" == value) 
    {
        value = null;
    }
    else 
    {
        var tmpvalue = (parseInt(value) - 65536) / 10;
        value = "[" + tmpvalue + ",";
    }
    return value;
}

function higpowerConvert(value)
{
    if ("-1" == value || "/" == value) 
    {
        value = null;
    }
    else 
    {
        var tmpvalue = parseInt(value) / 10;
        value = tmpvalue + "]";
    }
    return value;
}

function lowfreConvert(value)
{
    if ("-1" == value || "/" == value) 
    {
        value = null;
    }
    else 
    {
        var tmpvalue = parseInt(value) / 10;
        value = "[" + tmpvalue + ",";
    }
    return value;
}

function higfreConvert(value)
{
    if ("-1" == value || "/" == value) 
    {
        value = null;
    }
    else 
    {
        var tmpvalue = parseInt(value) / 10;
        value = tmpvalue + "]";
    }
    return value;
}

/**
 *       
 * @param  
 * @return  
 */
function sendRightInfo()
{
    var url = "../../../../securityServlet?neID=" + winurlobj["neid"] + "&nmUser=" + winurlobj["nmUser"];
    loadXMLdoc(url, "POST", false, rightHandleBack, null, "inputdata=" + createRightXML());
}

/**
 *           XML
 * @param  
 * @return  
 */
function createRightXML()
{
    var root = new inputxml("datainterface");//Create the root of a xml file
    var firstlevel = new tagElement("bussiness-params");
    
    var secondlevel = null;
    ;
    var thirdlevel = null;
    
    secondlevel = new tagElement("row-params"); //bean         	
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "btnID");
    thirdlevel.setAttribute("value", "querybtn");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "sfid");
    thirdlevel.setAttribute("value", QUERY_ODU_INTERFACE);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    
    
    secondlevel = new tagElement("row-params"); //bean         	
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "btnID");
    thirdlevel.setAttribute("value", "applybtn");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "sfid");
    thirdlevel.setAttribute("value", SET_ODU_INTERFACE);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    
    root.getRoot().appendChild(firstlevel);
    
    return root.toString();
}

/**
 *           
 * @param  
 * @return  
 */
function rightHandleBack(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0; i < data.getDataRowLength(); i++) //       
     {
        var right = data.getDataRowParam(i, "right");
        
        if (0 == right) 
        {
            $(data.getDataRowParam(i, "btnID")).disabled = true;
        }
        else 
        {
            $(data.getDataRowParam(i, "btnID")).disabled = false;
        }
        userRightObject[data.getDataRowParam(i, "btnID")] = (0==right?false:true);
    }
}

function trIntervalCellondbclick()
{
}

/*
 * Add table popupmenu handler
 */

function popupMenuHandler(evt)
{
	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent
			|| elem.editElement == null)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if( colid == "W32BRD_ATTR_TRINTERVAL" && winurlobj.neType == "92" )
	{
		return;
	}
	
	var isColNotShowMenu = ((null != this.popupMenuExcludeCells) && (this.popupMenuExcludeCells.contains(colid)));

	if (rows.contains(rowid))
	{
		if (null != elem.editElement && 
			 	elem.isEdit == 1 && !isColNotShowMenu)
		{
			createTablePopupMenu(elem, evt);
			return;
		}

		for ( var i = 0; i < rows.length; i++)
		{
			var tmpElem = elem.parent.getCellElement(rows[i], colid);
			if (null != tmpElem.editElement && tmpElem.isEdit == 1 && !isColNotShowMenu)
			{
				createTablePopupMenu(tmpElem, evt);
				return;
			}
		}
	}
}
