var winobj = getNeProperty(self);
var parentWin = getParentWindow();
var linePGTable; //          
var newLineMspDataXML; //         XML  
var availablePortList = []; //           
var workUnitList = []; //             
var protectUnitList = []; //             
var MIN_DELAYTIME = 300; //       
var MAX_DELAYTIME = 720; //       
var DEFAULT_DELAYTIME = 600; //       
var WEST_WORK_UNIT = 1; //       
var WEST_PROTECT_UNIT = 2; //       
var groupID = 1;

loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);

getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/nplus1/nplus1_" + SYSTEMCONF.getLanguage() + ".xml");
document.title = RESOURCE["createPGTitle"];

var NETYPE_RTN950 = "77";
var NETYPE_RTN950A = "114";

/**
 *      
 * 
 * @param  
 * @return  
 */
function initBody()
{
	$("boardMapTableTitle").appendChild(
			document.createTextNode(RESOURCE["boardMapTitle"]));
	$("selectMapDirectTitle").appendChild(
			document.createTextNode(RESOURCE["selectMapDirectTitle"]));
	$("selectMapBoardTitle").appendChild(
			document.createTextNode(RESOURCE["selectMapBoardTitle"]));
	$("selectedMapBoardTitle").appendChild(
			document.createTextNode(RESOURCE["selectedMapBoardTitle"]));

	$("okBtn").value = RESOURCE["okbutton"];
	$("cancleBtn").value = RESOURCE["cancelbutton"];
	$("applyBtn").value = RESOURCE["applybutton"];

	$("selectMapDirect").options[0] = new Option(RESOURCE["westWorkUnit"],
			WEST_WORK_UNIT);
	$("selectMapDirect").options[1] = new Option(RESOURCE["westProtectUnit"],
			WEST_PROTECT_UNIT);

	initTable();
	initBoardMap();
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	linePGTable = new CTable();

	linePGTable.addHead(RESOURCE["attrCol"], RESOURCE["valueCol"]);

	var cTableAtom = null;
	var cTableAtomEle = null;

	cTableAtom = new Atom("text");
	cTableAtomEle = cTableAtom.element;
	cTableAtom.setValue(DEFAULT_DELAYTIME);

	checkDataCellEvent(cTableAtomEle, MIN_DELAYTIME, MAX_DELAYTIME,
			DEFAULT_DELAYTIME);

	linePGTable.addAttrRow("revertiveTime", RESOURCE["revertiveTime"],
			cTableAtom);

	cTableAtom = new Atom("select");
	cTableAtomEle = cTableAtom.element;
	cTableAtomEle.options[cTableAtomEle.options.length] = new Option(
			RESOURCE["Disabled"], 0);
	cTableAtomEle.options[cTableAtomEle.options.length] = new Option(
			RESOURCE["Enabled"], 1);
	cTableAtomEle.options[1].selected = true; //     
	cTableAtomEle.onchange = setApplyEnabled;
	linePGTable.addAttrRow("sdEnable", RESOURCE["sdEnable"], cTableAtom);

	$("linePGTableArea").appendChild(linePGTable.getTable());
}

/**
 *           
 * 
 * @param  
 * @return  
 */
function initBoardMap()
{
	clearSelectOptions($("availableport"));
	clearSelectOptions($("selectedport"));
	workUnitList = []; //             
	protectUnitList = []; //             
	var availableportObj = $("availableport");
	for ( var i = 0; i < parentWin.aviablePort.length; i++)
	{
		var tmpPort = parentWin.aviablePort[i];
		if(!boardMapIsUsed(tmpPort.slotid,tmpPort.port))
		{
			insertSelectOption(availableportObj, tmpPort.slotid + ":"
					+ tmpPort.port + ":" + tmpPort.boardname + ":"
					+ tmpPort.portname, tmpPort.toString());
		}
	}
}

/*
 *          
 * slotid,portid
 */
function boardMapIsUsed(slotid,portid)
{
	var result = false;
	var objBoard = null;
	if(parentWin.usedBoard != null)
	{
		for(var i = 0,m = parentWin.usedBoard.length;i < m;i++)
		{
			objBoard = parentWin.usedBoard[i].split("-")
			if(objBoard.length >= 2 && slotid == objBoard[0] && portid == objBoard[1])
			{
				result = true;
				break;
			}
		}
	}
	return result;
}

/**
 *            
 */
function doCreateLineMsp(isApply)
{
	if ($("applyBtn").disabled)
	{
		xcloseDialog();
	}

	if (workUnitList.length == 0)
	{
		alert(RESOURCE["INFO_WEST_WORK_NOT_SELECTED"]);
		return;
	}
	else if (protectUnitList.length == 0)
	{
		alert(RESOURCE["INFO_WEST_PROTECT_NOT_SELECTED"]);
		return;
	}

	$("okBtn").disabled = true;
	$("cancleBtn").disabled = true;
	$("applyBtn").disabled = true;

	var url = "../../../../neExlorerServlet?sfid=" + create_nplus1 + "&nmUser="
			+ parentWin.winobj["nmUser"];

	loadXMLdoc(url, "POST", true, callbackCreateLineMsp, isApply, "inputdata="
			+ createCreateLineMspXMLInfo());

}

/**
 *             XML  
 * 
 * @param  
 * @return  
 */
function createCreateLineMspXMLInfo()
{
	newLineMspDataXML = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", parentWin.winobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "groupID");
	var groupIds = new Array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
	for (var i = 0, m = parentWin.linePGTable.getDataRowLength(); i < m; i++)
	{
		var groupId = parseInt(parentWin.linePGTable.getCellStoreValue(i, "groupID", "groupID"));
		groupIds.remove(groupId);
	}
	param.setAttribute("value", groupIds[0]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "revertiveTime");

	param.setAttribute("value", linePGTable.getAttrValue("revertiveTime"));

	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "sdEnable");
	param.setAttribute("value", linePGTable.getAttrValue("sdEnable"));
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "worknum");
	param.setAttribute("value", workUnitList.length);
	row.appendChild(param);
	for ( var i = 0; i < workUnitList.length; i++)
	{
		param = new tagElement("param");
		param.setAttribute("name", "protectUnit" + i);
		param.setAttribute("value", 1);
		row.appendChild(param);

		var workUnit = workUnitList[i].split(":");
		param = new tagElement("param");
		param.setAttribute("name", "slotid" + i);
		param.setAttribute("value", workUnit[0]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "port" + i);
		param.setAttribute("value", workUnit[1]);
		row.appendChild(param);
	}

	var protectUnit = protectUnitList[0].split(":");
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", protectUnit[0]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "port");
	param.setAttribute("value", protectUnit[1]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "protectUnit");
	param.setAttribute("value", 0);
	row.appendChild(param);

	bussiness.appendChild(row);
	newLineMspDataXML.getRoot().appendChild(bussiness);
	return newLineMspDataXML.toString();
}

/**
 *               
 * 
 * @param doc:          
 * @return  
 */
function callbackCreateLineMsp(doc, isApply)
{
	var data = EncapsulateData(doc);

	var errorCode = data.getSErrorCode();

	$("okBtn").disabled = false;
	$("cancleBtn").disabled = false;
	if (errorCode == -10)
	{
		$("applyBtn").disabled = false;
		alert(RESOURCE["noifboard"]);
		return;
	}
	showOperResult(data);

	if(0 == errorCode)
	{
		parentWin.queryPG();
		if (!isApply) //                
		{
			xcloseDialog();
		}
		else
		{
			$("selectedport").options.length = 0;
			workUnitList = [];
			protectUnitList = [];
		}
	}
	else
	{
		$("applyBtn").disabled = false;
	}
}

/**
 *    rightFlag = true    rightflag = false;
 */
function removeSelectListData(rightFlag)
{
	$("applyBtn").disabled = false;

	var srcObj;
	var sinkObj;

	if (rightFlag)
	{
		srcObj = $("availableport");
		sinkObj = $("selectedport");
	}
	else
	{
		srcObj = $("selectedport");
		sinkObj = $("availableport");
	}

	if (srcObj.selectedIndex == -1)
	{
		alert(RESOURCE["ID_SELECT"]);
		return;
	}

	var option = null;

	for ( var i = 0; i < srcObj.options.length; i++)
	{
		var showText = srcObj.options[i].innerText;
		if (srcObj.options[i].selected)
		{
			if (rightFlag)
			{
				if ($("selectMapDirect").value == WEST_WORK_UNIT)
				{
					var supportWorkUnit4 = SpecialAttrMgr.isNESupport(parentWin.winobj["neid"], "TE_FUNC_RTN_LINKCONFIG", "TE_ATTR_RTN_NJ1_WORKUNIT4");

					if(parentWin.winobj["neType"] == NETYPE_RTN950 || parentWin.winobj["neType"] == NETYPE_RTN950A ||
					   supportWorkUnit4	)
					{
						if (workUnitList.length == 4)
						{
							alert(RESOURCE["INFO_WORK_UNIT_FOUR"]);
							break;
						}
					}
					else
					{
						if (workUnitList.length == 7)
						{
							alert(RESOURCE["INFO_WORK_UNIT_SEVEN"]);
							break;
						}
					}
					

					showText = RESOURCE["westWorkUnit"] + ":" + showText;
					workUnitList.push(srcObj.options[i].value);
				}
				else
				{
					if (protectUnitList.length == 1)
					{
						alert(RESOURCE["INFO_PROTECT_UNIT_ONE"]);
						break;
					}
					showText = RESOURCE["westProtectUnit"] + ":" + showText;
					protectUnitList.push(srcObj.options[i].value);
				}
			}
			else
			{
				var workUnit = showText.substring(0, showText.indexOf(":"));
				showText = showText.substring(showText.indexOf(":") + 1);
				if (workUnit == RESOURCE["westWorkUnit"])
				{
					workUnitList.remove(srcObj.options[i].value);
				}
				else
				{
					protectUnitList.remove(srcObj.options[i].value);
				}
			}

			insertSelectOption(sinkObj, srcObj.options[i].value, showText);

			srcObj.remove(i);
			i--;
		}
	}
}

function insertSelectOption(selectObj, insertValue, insertText)
{
	var option = new Option();
	addOptionToSelect(selectObj, option);
	if (null == insertText)
	{
		insertText = insertValue;
	}
	option.innerText = insertText;
	option.value = insertValue;
}

function getInsertIndex(selectObj, insertValue)
{
	var optionObjArr = insertValue.split(":");
	var slotid = parseInt(optionObjArr[0]);
	var port = parseInt(optionObjArr[1]);

	var otherOptionObjArr
	var otherSlotid;
	var otherPort;
	for ( var i = 0; i < selectObj.options.length; i++)
	{
		otherOptionObjArr = selectObj.options[i].value.split(":");
		otherSlotid = parseInt(otherOptionObjArr[0]);
		otherPort = parseInt(otherOptionObjArr[1]);
		if (slotid < otherSlotid)
		{
			return i;
		}
		else if (slotid == otherSlotid && port <= otherPort)
		{
			return i;
		}
	}
	return selectObj.options.length;
}

function clearSelectOptions(selectObj)
{
	for ( var i = selectObj.options.length; i >= 0; i--)
	{
		selectObj.remove(selectObj.options[i]);
	}
}

function setApplyEnabled()
{
	$("applyBtn").disabled = false;
}

/**
 *       
 * 
 * @param data:           
 *            errArr:       
 * @return  
 */
function showOperResult(data)
{
	var errArr = [];//            
	errArr[0] = "groupID";//            

	for ( var i = 0, len = data.getBErrLength(); i < len; i++)
	{
		data.getError().rowErrors[i].errorObj["groupID"] = RESOURCE["Line_MSP_ID"]
				+ data.getError().rowErrors[i].errorObj["groupID"];
	}
	openErrPage("../../../../page/", data.getError(), errArr);
}
