var winobj = getNeProperty(self);
if(null == winobj)
{
	winobj = getNeProperty(parent);
}
var linePGTable;
var boardMapTable;
var boardMapData = null;

var ALL_CLEAR = 16; //     
var LOCKED = 15; //       
var FOCUS_SW = 14; //     
var MANUAL_SW = 8; //     
var EXERCISE_SW = 4; //     
var usedPort = []; //      
var aviablePort = []; //      

var MIN_GROUP_ID = 1;
var MAX_GROUP_ID = 5;
var REVERTIVE_MODE0 = 0; //     
var REVERTIVE_MODE1 = 1; //      
var PROTECT_TYPE0 = 0; // 1+1
var PROTECT_TYPE1 = 1; // 1:N

var MAX_GROUP_NUM = 1;
var NETYPE_RTN910 = "76";
var NETYPE_RTN950 = "77";
var NETYPE_RTN980 = "83";
var NETYPE_RTN950A = "114";

var btnRightArr = new Object();
loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);

getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/nplus1/nplus1_" + SYSTEMCONF.getLanguage() + ".xml");

loadXMLdoc("../../conf/nplus1/nplus1pgtable_" + SYSTEMCONF.getLanguage()
		+ ".xml", "GET", false, EncapsulateTable);
loadXMLdoc("../../conf/nplus1/nplus1maptable_" + SYSTEMCONF.getLanguage()
		+ ".xml", "GET", false, EncapsulateTable);

/**
 *      
 * 
 * @param  
 * @return  
 */
function initBody()
{
	if(winobj["neType"] == NETYPE_RTN910)
	{
		MAX_GROUP_NUM = 2;
	}
	else if(winobj["neType"] == NETYPE_RTN950 || winobj["neType"] == NETYPE_RTN950A)
	{
		MAX_GROUP_NUM = 3;
	}
	else if(winobj["neType"] == NETYPE_RTN980)
	{
		MAX_GROUP_NUM = 7;
	}
	else
	{
		var maxGroupNum = SpecialAttrMgr.getNEAttrIntValue(winobj["neid"], "TE_FUNC_RTN_LINKCONFIG", "TE_ATTR_RTN_NJ1_MAXGROUPNUM");
		if( maxGroupNum != null && maxGroupNum != "" )
		{
			MAX_GROUP_NUM = maxGroupNum;
		}
	}
	
	$("pgTableTitle").appendChild(document.createTextNode(RESOURCE["PGTitle"]));
	$("boardMapTableTitle").appendChild(
			document.createTextNode(RESOURCE["boardMapTitle"]));

	initTable();
	initButton();

}

window.onload = function()
{
	if (SYSTEMCONF.getStatus() == 1)
	{
		if (!isSolaris)
		{
			initBody();
		}
	}
	else
	{
		tabSelectHandler();
	}
}

var firstQuery = true;
function tabSelectHandler()
{
	if (linePGTable == null)
	{
		initBody();
	}
	if(firstQuery)
	{
		queryPG();
		firstQuery = false;
	}
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	linePGTable = new SortTable();
	linePGTable.isUsedForSelectList = true;
	linePGTable.setImage("../../../../images/");

	linePGTable.setOnCellEditHandler(cellEditHandler);

	createTableHead(linePGTable, window.tableconf[0]);

	linePGTable.setBodyWidth(window.tableconf[0].width,
			window.tableconf[0].percent, 0);
	linePGTable.setOnRowSelectHandler(rowSelectHandler);

	var linePGTableArea = document.createElement("div");
	linePGTableArea.setAttribute("id", "protectGroupTable");
	linePGTableArea.appendChild(linePGTable.getTable());
	$("protectGroup").appendChild(linePGTableArea);

	adjustTableLayout(linePGTable, window.tableconf[0], 0);

	boardMapTable = new SortTable();
	boardMapTable.isUsedForSelectList = true;
	boardMapTable.setImage("../../../../images/");

	boardMapTable.setSingleChoiceFlg(true);

	createTableHead(boardMapTable, window.tableconf[1]);

	boardMapTable.setBodyWidth(window.tableconf[1].width,
			window.tableconf[1].percent, 0);
	var boardMapTableArea = document.createElement("div");
	boardMapTableArea.setAttribute("id", "boardMapTable");
	boardMapTableArea.appendChild(boardMapTable.getTable());
	$("boardMap").appendChild(boardMapTableArea);
	boardMapTableArea.oncontextmenu = popupMenuHandler;

	var totalHeight = getComponetHeight($("tablecomponent"), 200);
	linePGTable.setBodyHeight(totalHeight * 0.6 + "px");
	boardMapTable.setBodyHeight(totalHeight * 0.38 + "px");
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initButton()
{
	if (SYSTEMCONF.getLanguage() == "en")
	{
		$("startBtn").className = "buttonstyle3";
		$("endBtn").className = "buttonstyle3";
	}

	btnRightArr.startBtn = new BtnRightObj("startBtn", "9388");
	btnRightArr.endBtn = new BtnRightObj("endBtn", "9388");
	btnRightArr.createBtn = new BtnRightObj("createBtn", "9384");
	btnRightArr.querybtn = new BtnRightObj("querybtn", "9383");
	btnRightArr.applyBtn = new BtnRightObj("applyBtn", "9386");
	btnRightArr.delBtn = new BtnRightObj("delBtn", "9385");

	getRightInfo(winobj, btnRightArr);
	$("startBtn").value = RESOURCE["startBtn"];
	$("endBtn").value = RESOURCE["endBtn"];
	$("createBtn").value = RESOURCE["createBtn"];
	$("queryBtn").value = RESOURCE["queryBtn"];
	$("querySwitchStateBtn").value = RESOURCE["querySwitchStatus"];
	$("applyBtn").value = RESOURCE["applyBtn"];
	$("delBtn").value = RESOURCE["delBtn"];
}

/**
 *            
 * 
 * @param  
 * @return  
 */
function initButtonStatus()
{

	var len = linePGTable.getDataRowLength();
	if (len >= MAX_GROUP_NUM)
	{
		setBtnStatus(true, [ "createBtn" ]);
	}
	else
	{
		setBtnStatus(!btnRightArr.createBtn.right, [ "createBtn" ]);
	}
	setBtnStatus(false, [ "queryBtn" ]);

	if (linePGTable.getSelectedRowCount() > 0)
	{
		setBtnStatus(!btnRightArr.startBtn.right, [ "startBtn" ]);
		setBtnStatus(!btnRightArr.endBtn.right, [ "endBtn" ]);
		setBtnStatus(!btnRightArr.delBtn.right, [ "delBtn" ]);
	}
	else
	{
		setBtnStatus(true, [ "startBtn" ]);
		setBtnStatus(true, [ "endBtn" ]);
		setBtnStatus(true, [ "delBtn" ]);
	}
	setBtnStatus(true, [ "applyBtn" ]);
	for ( var rowindex = 0, rowlen = linePGTable.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (linePGTable.getModify(rowindex))
		{
			setBtnStatus(!btnRightArr.applyBtn.right, [ "applyBtn" ]);
			break;
		}
	}
}

/**
 *             
 * 
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	if (rows.length == 0)
	{
		$("startBtn").disabled = true;
		$("endBtn").disabled = true;
		$("delBtn").disabled = true;
		boardMapTable.clearTableData();
	}
	else
	{
		$("startBtn").disabled = !btnRightArr.startBtn.right;
		$("endBtn").disabled = !btnRightArr.endBtn.right;
		$("delBtn").disabled = !btnRightArr.delBtn.right;
		var groupID = linePGTable.getCellStoreValue(rows[0],"groupID","groupID");
		var downDinterface = null;
		for(var i = 0,m = downDinterfaces.length;i < m;i++)
		{
			if(downDinterfaces[i]["groupID"] == groupID)
			{
				downDinterface = downDinterfaces[i]["data"];
				break;
			}
		}
		if(downDinterface != null)
		{
			boardMapTable.clearTableData();
			createTableBody(boardMapTable, window.tableconf[1], downDinterface,
				RESOURCE);
		}
	}
}

/**
 *             
 * 
 * @param  
 * @return  
 */
function cellEditHandler()
{
	$("applyBtn").disabled = !btnRightArr.applyBtn.right;
}

/**
 *      
 * 
 * @param  
 * @return  
 */
function queryPG()
{
	usedBoard = [];
	setBtnStatus(true);

	var url = "../../../../neExlorerServlet?sfid=" + query_nplus1 + "&nmUser="
			+ winobj["nmUser"];

	loadXMLdoc(url, "POST", true, callbackQueryPG, null, "inputdata="
			+ createQueryPGXMLInfo());
}

/**
 *             XML  
 * 
 * @param  
 * @return  
 */
function createQueryPGXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "groupID");
	param.setAttribute("value", 1);
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             
 * 
 * @param doc:          
 * @return  
 */
function callbackQueryPG(doc)
{
	setBtnStatus(false);
	var data = EncapsulateData(doc);
	var errObj = null;
	if (0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		linePGTable.clearTableData();
		boardMapTable.clearTableData();

		if (data.getDataRowLength() > 0)
		{
			fillTableData(data, true);
		}
	}
	else
	{
		errObj = [];
		errObj.push("nename");
	}

	initButtonStatus();
	showOperResult(data, errObj);
}

var downDinterfaces = null;
var usedBoard = [];
/**
 *         
 * 
 * @param data:      
 *            isQuery        
 * @return  
 */
function fillTableData(data, isQuery)
{
	downDinterfaces = [];
	
	for(var i = 0,m = data.rows.length;i < m;i++)
	{
		var downDinterface = new DataInterface();//             
		var objdata = data.rows[i];
		var worknum = data.getDataRowParam(i, "worknum");
		for ( var t = 0; t < worknum; t++)
		{
			var unitid = t + 1;
	
			var downObj = new Object();
	
			var tempObj = new Object();
			tempObj.value = RESOURCE["WorkUnit"] + unitid;//           
			downObj["unit"] = tempObj;
	
			tempObj = new Object();
			tempObj.value = unitid;//           
			downObj["protectUnit"] = tempObj;
	
			downObj["line"] = objdata["line" + unitid];
	
			downObj["protocolStatus"] = objdata["switchStatue" + unitid];
			downObj["endIndication"] = objdata["endIndication" + unitid];
			downObj["protectedunit"] = objdata["protectedunit" + unitid];
			downDinterface.rows[downDinterface.rows.length] = downObj;
			
			usedBoard[usedBoard.length] = objdata["slot" + unitid].value + "-" + objdata["port" + unitid].value;
		}
		var unitid = 0;
		var objdata = data.rows[i];
		var downObj = new Object();
		var tempObj = new Object();
		tempObj.value = RESOURCE["ProtectUnit"];//           
		downObj["unit"] = tempObj;
	
		tempObj = new Object();
		tempObj.value = unitid;//           
		downObj["protectUnit"] = tempObj;
	
		downObj["line"] = objdata["line" + unitid];
		downObj["protocolStatus"] = objdata["switchStatue" + unitid];
		downObj["endIndication"] = objdata["endIndication" + unitid];
		downDinterface.rows[downDinterface.rows.length] = downObj;
		
		usedBoard[usedBoard.length] = objdata["slot" + unitid].value + "-" + objdata["port" + unitid].value;
		var tmpObject = new Object();
		
		tmpObject["groupID"] = objdata["groupID"].value;
		tmpObject["data"] = downDinterface;
		downDinterfaces[downDinterfaces.length] = tmpObject;
	}


	createTableBody(linePGTable, window.tableconf[0], data, RESOURCE);

	linePGTable.element.colsArray.selectedId = "groupID";
	var tdsort = linePGTable.element.headRow.element.cols["groupID"].element;
	linePGTable.sortRows(tdsort, 1);

	createTableBody(boardMapTable, window.tableconf[1], downDinterfaces[0]["data"],
			RESOURCE);

	boardMapTable.element.colsArray.selectedId = "protectUnit";
	var tdsort = boardMapTable.element.headRow.element.cols["protectUnit"].element;
	boardMapTable.sortRows(tdsort, 1);

	linePGTable.setRowSelect(0); //       stSelectFun()   

}

/**
 *       
 * 
 * @param  
 * @return  
 */
function openCreateDialog()
{
	var url = "../../../../neExlorerServlet?sfid=" + query_nplus1_resboard
			+ "&nmUser=" + winobj["nmUser"];

	loadXMLdoc(url, "POST", false, callbackQueryRes, null, "inputdata="
			+ createQueryResXMLInfo());
	var dialogHeight = "500";
	var dialogWidth = "550";
	if (SYSTEMCONF.getLanguage() == "en")
	{
		dialogHeight = "600";
		dialogWidth = "700";

	}
	xshowModalDialog("createnplus1.html", RESOURCE["createPGTitle"],
			dialogWidth, dialogHeight, "../../../../images/");
}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryResXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);
	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function callbackQueryRes(doc)
{
	var data = EncapsulateData(doc);

	var errorCode = data.getSErrorCode();

	aviablePort = [];

	if (0 != errorCode)
	{
		return;
	}
	var tmpPort = 0;
	for ( var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		tmpPort = new TEPort(data.getDataRowParam(i, "slotid"), data
				.getDataRowParam(i, "boardname"), data.getDataRowParam(i,
				"port"), data.getDataRowParam(i, "portname"));
		if (!usedPort.containsPort(tmpPort))
		{
			aviablePort.push(tmpPort);
		}
	}
}

/**
 *         
 * 
 * @param  
 * @return  
 */
function startProtocol(isStart)
{
	if (isStart)
	{
		setBtnStatus(true, [ "startBtn" ]);
	}
	else
	{
		setBtnStatus(true, [ "endBtn" ]);
	}
	var url = "../../../../neExlorerServlet?sfid=" + start_stop_nplus1
			+ "&nmUser=" + winobj["nmUser"];

	loadXMLdoc(url, "POST", true, callbackStartProtocol, isStart, "inputdata="
			+ createStartProtocolXMLInfo(isStart));

}

/**
 *          XML  
 * 
 * @param  
 * @return  
 */
function createStartProtocolXMLInfo(isStart)
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	var selectedRow = linePGTable.getSelectedRows();

	for ( var i = 0, len = selectedRow.length; i < len; i++)
	{
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "startFlag");
		if (isStart)
		{
			param.setAttribute("value", 1);
		}
		else
		{
			param.setAttribute("value", 0);
		}
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "groupID");
		param.setAttribute("value", linePGTable.getCellStoreValue(selectedRow[i],"groupID","groupID"));
		row.appendChild(param);
		bussiness.appendChild(row);
	}

	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function callbackStartProtocol(doc, isStart)
{
	var data = EncapsulateData(doc);

	if (0 == data.getSErrorCode())
	{
		alert(RESOURCE["queryProtocolAlert"]);
	}
	else
	{
		showOperResult(data);
	}
}

/**
 *            
 * 
 * @param  
 * @return  
 */
function delLineMsp()
{
	if (!confirm(RESOURCE["ID_BELMSP_PROL"]))
	{
		return;
	}

	setBtnStatus(true, [ "delBtn" ]);
	var url = "../../../../neExlorerServlet?sfid=" + del_nplus1 + "&nmUser="
			+ winobj["nmUser"];

	loadXMLdoc(url, "POST", true, callbackDelLineMsp, null, "inputdata="
			+ createDelLineMspXMLInfo());
}

/**
 *             XML  
 * 
 * @param  
 * @return  
 */
function createDelLineMspXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	delPGList = [];

	var selectedRow = linePGTable.getSelectedRows();

	for ( var i = 0; i < selectedRow.length; i++)
	{
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "groupID");
		param.setAttribute("value", linePGTable.getCellStoreValue(
				selectedRow[i], "groupID", "groupID"));
		row.appendChild(param);
		bussiness.appendChild(row);
		delPGList.push(linePGTable.getCellStoreValue(selectedRow[i], "groupID",
				"groupID"));
	}

	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *               
 * 
 * @param doc:          
 * @return  
 */
function callbackDelLineMsp(doc)
{
	var dinterface = EncapsulateData(doc);
	if (0 != dinterface.getSErrorCode())
	{
		showOperResult(dinterface);
		initButtonStatus();
		return;
	}
	queryPG();
	initButtonStatus();
}

/**
 *              
 * 
 * @param  
 * @return  
 */
function setLineMsp()
{
	setBtnStatus(true, [ "applyBtn" ]);
	var url = "../../../../neExlorerServlet?sfid=" + set_nplus1 + "&nmUser="
			+ winobj["nmUser"];

	var xmlData = createSetLineMspXMLInfo();
	if (null == xmlData)
	{
		return;
	}

	loadXMLdoc(url, "POST", true, callbackSetLineMsp, null, "inputdata="
			+ xmlData);

}

/**
 *               XML  
 * 
 * @param  
 * @return  
 */
function createSetLineMspXMLInfo()
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var isModify = false;
	for ( var rowindex = 0, rowlen = linePGTable.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (!linePGTable.getModify(rowindex))
		{
			continue;
		}
		isModify = true;
		rowData = linePGTable.getRow();
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", winobj["neid"]);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "groupID");
		param.setAttribute("value", linePGTable.getCellStoreValue(rowindex,
				"groupID", "groupID"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "sdEnable");
		param.setAttribute("value", linePGTable.getCellStoreValue(rowindex,
				"sdEnable", "sdEnable"));
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "revertiveTime");
		param.setAttribute("value", linePGTable.getCellStoreValue(rowindex,
				"revertiveTime", "revertiveTime"));
		row.appendChild(param);

		bussiness.appendChild(row);
	}
	if (!isModify)
	{
		return null;
	}
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *                 
 * 
 * @param doc:          
 * @return  
 */
function callbackSetLineMsp(doc)
{
	var data = EncapsulateData(doc);
	refreshTableState(linePGTable, window.tableconf[0], data);
	if (0 != data.getSErrorCode())
	{
		setBtnStatus(!btnRightArr.applyBtn.right, [ "applyBtn" ]);
	}
	showOperResult(data);
}

/**
 *       
 * 
 * @param  
 * @return  
 */
function switchLineMsp(switchType)
{
	if (switchType == 15)
	{
		if (!confirm(RESOURCE["LockAlarm"]))
			return;
	}
	var url = "../../../../neExlorerServlet?sfid=" + modify_nplus1 + "&nmUser="
			+ winobj["nmUser"];

	loadXMLdoc(url, "POST", true, callbackSwitchLineMsp, switchType,
			"inputdata=" + createSwitchLineMspXMLInfo(switchType));
}

/**
 *        XML  
 * 
 * @param  
 * @return  
 */
function createSwitchLineMspXMLInfo(switchType)
{

	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	var selectedRow = boardMapTable.getSelectedRows();
	row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "groupID");
	param.setAttribute("value", 1);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "protectUnit");
	param.setAttribute("value", selectedRow[0]);

	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "switchType");
	param.setAttribute("value", switchType);
	row.appendChild(param);
	bussiness.appendChild(row);

	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function callbackSwitchLineMsp(doc, switchType)
{
	var data = EncapsulateData(doc);
	if (0 == data.getSErrorCode())
	{
		alert(RESOURCE["querySWStatus"]);
	}
	showOperResult(data);
}

/**
 *             
 * 
 * @param data: 
 * @return  
 */
function createjsDOMenu()
{
	removejsDOMmenu();
	var menuSize = 150;
	if (SYSTEMCONF.getLanguage() == "en")
	{
		menuSize = 200;
	}
	var cursorMenu1 = new jsDOMenu(menuSize);
	cursorMenu1
			.addMenuItem(new menuItem(RESOURCE["queryPG"], "", queryPG, null));
	cursorMenu1.addMenuItem(new menuItem(RESOURCE["querySwitchStatus"], "",
			querySWStatus, true));
	setPopUpMenu(cursorMenu1);
}

/**
 *           
 * 
 * @param data: 
 * @return  
 */
function popupMenuHandler(evt)
{

	if (!evt)
	{
		evt = window.event;
	}

	var elem = (evt.target) ? evt.target : evt.srcElement;

	if (elem != null && elem.blur)
	{
		elem.blur();
	}

	while (elem != null)
	{
		if (elem.tagName == 'TD')
		{
			break;
		}
		else
		{
			elem = elem.parentNode;
		}
	}

	if (elem == null || elem.tagName != 'TD' || null == elem.parent)
	{
		return;
	}

	var rowid = elem.parentNode.rowIndex;
	var rows = elem.parent.getSelectedRows();
	var colid = elem.colid;
	if (rows.contains(rowid))
	{
		createFuncPopupMenu(rows, evt);
	}
}

/**
 *           
 * 
 * @param data: 
 * @return  
 */
function createFuncPopupMenu(rows, evt)
{
	removejsDOMmenu();
	var menuSize = 150;
	var cursorMenu1 = new jsDOMenu(menuSize);
	var isClear = true;
	var protectUnit = boardMapTable.getCellStoreValue(rows[0], "protectUnit",
			"protectUnit"); //    0     1     
	var protectionType; //     

	cursorMenu1.addMenuItem(new menuItem(RESOURCE["clearSW"], "",
			switchLineMsp, [ ALL_CLEAR ]));

	if (protectUnit > 0)
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["foceSWToProtect"], "",
				switchLineMsp, [ FOCUS_SW ]));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["manualSWToProtect"], "",
				switchLineMsp, [ MANUAL_SW ]));
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["exerciseSW"], "",
				switchLineMsp, [ EXERCISE_SW ]));
	}
	else
	{
		cursorMenu1.addMenuItem(new menuItem(RESOURCE["lockProtect"], "",
				switchLineMsp, [ LOCKED ]));
	}
	setPopUpMenu(cursorMenu1);
	showMenu(evt);
}

function setBtnStatus(disabledState, btnIDArr)
{

	if (null == btnIDArr || btnIDArr.length == 0)
	{
		btnIDArr = [];
		btnIDArr.push("startBtn");
		btnIDArr.push("endBtn");
		btnIDArr.push("createBtn");
		btnIDArr.push("queryBtn");
		btnIDArr.push("applyBtn");
		btnIDArr.push("delBtn");
	}

	for ( var i = 0; i < btnIDArr.length; i++)
	{
		$(btnIDArr[i]).disabled = disabledState;
	}
}

/**
 *   common.js               
 * 
 * @param res:    
 *            obj     /   key:     
 * @return String      
 */
function convertMsg(res, obj, key)
{
	if ("function" == (typeof obj))
	{
		return obj(key);
	}
	else
	{
		if (null == obj)
		{
			return key;
		}
		var resValue = obj[key];
		if (null == resValue)
		{
			resValue = "/";
		}
		return resValue;
	}
}

/**
 *       
 * 
 * @param data:           
 *            errArr:       
 * @return  
 */
function showOperResult(data, errArr)
{
	if (null == errArr)
	{
		errArr = [];//            
		errArr[0] = "groupID";//            

		for ( var i = 0, len = data.getBErrLength(); i < len; i++)
		{
			var groupIDobj = data.getError().rowErrors[i].errorObj["groupID"];
			if(typeof(groupIDobj) != 'undefined')
			{
				groupIDobj = RESOURCE["Line_MSP_ID"]
						+ groupIDobj;
			}else{
				groupIDobj = data.getError().rowErrors[i].errorObj["nename"];
			}
		}
	}
	openErrPage("../../../../page/", data.getError(), errArr);
}

/**
 *               
 * 
 * @param data: 
 * @return  
 */
window.onresize = function()
{
	var totalHeight = getComponetHeight($("tablecomponent"),200);
	linePGTable.setBodyHeight(totalHeight*0.6+"px");
	boardMapTable.setBodyHeight(totalHeight*0.38+"px");
}

function removeAviaPort(slotid, port)
{
	for ( var i = aviablePort.length - 1; i >= 0; i--)
	{
		if (aviablePort[i].slotid == slotid && aviablePort[i].port == port)
		{
			aviablePort.removeAt(i);
		}
	}
}

Array.prototype.containsPort = function(portObj)
{
	for ( var i = 0, len = this.length; i < len; i++)
	{
		if (this[i].equals(portObj))
		{
			return true;
		}
	}
	return false;
}

Array.prototype.removePort = function(groupID)
{
	for ( var i = this.length - 1; i >= 0; i--)
	{
		if (this[i].groupID == groupID)
		{
			this.removeAt(i);
		}
	}
}

function TEPort(slotid, boardname, port, portname, groupID)
{
	this.slotid = slotid;
	this.boardname = boardname;
	this.port = port;
	this.portname = portname;
	this.groupID = groupID;
}

TEPort.prototype.equals = function(otherPort)
{
	if (this.slotid == otherPort.slotid && this.port == otherPort.port)
	{
		return true;
	}
	return false;
}

TEPort.prototype.compare = function(otherPort)
{
	if (this.slotid > otherPort.slotid)
	{
		return 1;
	}
	else if (this.slotid < otherPort.slotid)
	{
		return -1;
	}
	else
	{
		if (this.port > otherPort.port)
		{
			return 1;
		}
		else if (this.port <= otherPort.port)
		{
			return -1;
		}
	}
}

TEPort.prototype.toString = function()
{
	var str = this.slotid + "-" + this.boardname + "-" + this.portname;
	return str;
}
