function PeerNESearchModule() {
	var _this = this;

	this.m_peerNEID = "";
	this.m_peerRealNEID = "";
	this.m_peerNEName = "";
	this.m_peerNEType = "";
	this.m_peerNEUser = "";
	this.m_peerNEVersion = "";
	this.m_peerNEState = "";
	this.m_peerIFSlotId = "";
	this.m_peerODUSlotId = "";
	this.m_peerGatewayIP = "";
	this.m_peerProcID = null;	
	this.m_peerProcHandle = null;

	this.clearData = function() {
		_this.m_peerNEID = "";
		_this.m_peerRealNEID = "";
		_this.m_peerNEName = "";
		_this.m_peerNEType = "";
		_this.m_peerNEUser = "";
		_this.m_peerNEVersion = "";
		_this.m_peerNEState = "";
		_this.m_peerIFSlotId = "";
		_this.m_peerODUSlotId = "";
		_this.m_peerProcID = null;	
		_this.m_peerProcHandle = null;
	}

	/**
	 *   IF            
	 */
	this.processWhenIFBoardSelectChanged = function(event) {
		_this.queryPeerNE(event.getNeId(), event.getSlotId());
	}

	/**
	 *             t_neid     ID ifslotid     ID
	 */
	this.queryPeerNE = function(t_neid, ifslotid) {
		var xml = _this.createPeerXML(t_neid, ifslotid);

		var urlreq = "../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_RTN_HOP_QUERY_ALL_OPPOSITENE; //          

		if (getNeProperty(self).sysStatus != "independent") {
			urlreq = "../../../../../neExlorerServlet?sfid="
					+ TECMDCODE_RTN_HOP_QUEERY_PEERNE; //      
		}

		loadXMLdoc(urlreq, "POST", true, this.queryPeerNeCallback, t_neid,
				"inputdata=" + xml);
	}

	this.createPeerXML = function(t_neid, slotid) {
		var di = new inputxml("datainterface");
		bussiness = new tagElement("bussiness-params");
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", t_neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param.setAttribute("value", slotid);
		row.appendChild(param);

		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);

		return di.toString();
	}

	this.queryPeerNeCallback = function(doc, param) {
		var data = EncapsulateData(doc);
		var sErrCode = data.getSErrorCode();

		if (sErrCode == OPERATION_SUCCESS || sErrCode == OPERATION_PART_SUCCESS) {
			if (getNeProperty(self).sysStatus != "independent") //        
			{
				var pLogicNeID = data.getDataRowParam(0, "peerNEID");
				var pPhyNeID = data.getDataRowParam(0, "peerRealNEID");
				var pIFSlotID = data.getDataRowParam(0, "peerIFSlotId");
				
				
				var procID = data.getDataRowParam(0, "procID");
		       var procHandle = data.getDataRowParam(0, "procHandle");
		        _this.m_peerProcID = procID;	
	            _this.m_peerProcHandle = procHandle;
		
	        	if(procID && procHandle)
	        	{
	            	    terminalStruct.OppositeEnd.PROC_OBJ[pLogicNeID] = [procID, procHandle];
	            	    PROC_OBJ[pLogicNeID] = [procID, procHandle];
	        	}              
				
				if (!HopTookit.isDataValid(pLogicNeID) || 
					!HopTookit.isDataValid(pPhyNeID) || 
					!HopTookit.isDataValid(pIFSlotID)) 
                { 
                        if (isLocalQueryFinshed) 
                        { 
                        	  isPeerNeQueryFinshed = true;
                        	isQueryFinished = true;
                            LoadingProcess.removeWaitStatus(); 
                        } 
                        return; 
                } 
                
                _this.m_peerNEID = pLogicNeID; 
				
				_this.queryRemoteNeDetailInfor(param, pLogicNeID, pPhyNeID,
						pIFSlotID);
			} else //        
			{
				_this.afterGetRemoteNeDetailInfor(param, data);
			}
		} else {
			_this.clearData();
			_this.getOppositeEnd().fillAllDataWhenOppositeNeNotExist();
			isPeerNeQueryFinshed = true;
			if (isLocalQueryFinshed) {
				LoadingProcess.removeWaitStatus();
			}

		}
	}

	/**
	 *             
	 */
	this.getPeerInfor = function(data) {
		_this.m_peerNEID = data.getDataRowParam(0, "peerNEID");
		_this.m_peerRealNEID = data.getDataRowParam(0, "peerRealNEID");
		_this.m_peerNEName = data.getDataRowParam(0, "peerNEName");
		_this.m_peerNEType = data.getDataRowParam(0, "peerNEType");
		_this.m_peerNEUser = data.getDataRowParam(0, "peerNEUser");
		_this.m_peerNEVersion = data.getDataRowParam(0, "peerNEVersion");
		_this.m_peerNEState = data.getDataRowParam(0, "peerNEState");
		_this.m_peerIFSlotId = data.getDataRowParam(0, "peerIFSlotId");
		_this.m_peerODUSlotId = data.getDataRowParam(0, "peerODUSlotId");
		_this.m_peerGatewayIP = data.getDataRowParam(0, "peerGatewayIP");
		if (typeof (_this.m_peerGatewayIP) == "undefined"
				|| _this.m_peerGatewayIP == null) {
			_this.m_peerGatewayIP = data.getDataRowParam(0, "peerNEIP")
		}
	}

	this.getPeerNEID = function() {
		return _this.m_peerNEID;
	}

	this.getPeerRealNEID = function() {
		return _this.m_peerRealNEID;
	}

	this.getPeerNEName = function() {
		return _this.m_peerNEName;
	}

	this.getPeerIFSlotId = function() {
		return _this.m_peerIFSlotId;
	}

	this.getPeerGatewayIP = function() {
		return _this.m_peerGatewayIP;
	}

	this.getPeerNEType = function() {
		return _this.m_peerNEType;
	}

	this.getPeerNEVersion = function() {
		return _this.m_peerNEVersion;
	}

	this.getOppositeEnd = function() {
		return terminalStruct.OppositeEnd;
	}

	this.doDemo = function() {
		_this.m_peerNEID = 2;
		_this.m_peerNEName = "NE232";
		_this.m_peerIFSlotId = 4;

		_this.getOppositeEnd().fillFarNeAllData();
	}

	/**
	 *         
	 */
	this.queryLinkStatus = function(t_neid, ifslotid) {
		var xml = _this.createPeerXML(t_neid, ifslotid);

		urlreq = "../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_RTN_HOP_QUEERY_PEERNE; //    

		loadXMLdoc(urlreq, "POST", true, this.queryPeerNeCallback_forLink,
				t_neid, "inputdata=" + xml);
	}

	/**
	 *          
	 */
	this.queryPeerNeCallback_forLink = function(doc, param) {
		buttonStruct.refreshLinkButton.disabled = !btnRightArr.refreshLinkbtn.right;
		buttonStruct.queryButton.disabled = !btnRightArr.querybtn.right;
		buttonStruct.applyButton.disabled = !btnRightArr.applybtn.right;

		var data = EncapsulateData(doc);
		var sErrCode = data.getSErrorCode();
		if (sErrCode == OPERATION_SUCCESS || sErrCode == OPERATION_PART_SUCCESS) 
		{
			if (getNeProperty(self).sysStatus != "independent") //        
			{
				var pLogicNeID = data.getDataRowParam(0, "peerNEID");
				var pPhyNeID = data.getDataRowParam(0, "peerRealNEID");
				var pIFSlotID = data.getDataRowParam(0, "peerIFSlotId");
				
				var procID = data.getDataRowParam(0, "procID");
		        var procHandle = data.getDataRowParam(0, "procHandle");
        	    _this.m_peerProcID = procID;	
	            _this.m_peerProcHandle = procHandle;
				
		        	if(procID && procHandle)
		        	{
		            	    terminalStruct.OppositeEnd.PROC_OBJ[pLogicNeID] = [procID, procHandle];
		            	    PROC_OBJ[pLogicNeID] = [procID, procHandle];
		       		}

				 isPeerNeQueryFinshed = true;
					
					if (!HopTookit.isDataValid(pLogicNeID) || 
						!HopTookit.isDataValid(pPhyNeID) || 
						!HopTookit.isDataValid(pIFSlotID)) 
	                { 
	                        if (isLocalQueryFinshed) 
	                        { 
	                        	isQueryFinished = true;
	                            LoadingProcess.removeWaitStatus(); 
	                        } 
	                        return; 
	                } 
	                
	                _this.m_peerNEID = pLogicNeID; 
				
				_this.queryRemoteNeDetailInfor(param, pLogicNeID, pPhyNeID,
						pIFSlotID);
			} 
			else //        
			{
				_this.afterGetRemoteNeDetailInfor(param, data);
			}
		} 
		else 
		{
			_this.clearData();
			_this.getOppositeEnd().fillAllDataWhenOppositeNeNotExist();
			isPeerNeQueryFinshed = true;
			if (isLocalQueryFinshed) {
				LoadingProcess.removeWaitStatus();
			}

		}
	}

	/**
	 *            
	 */
	this.queryRemoteNeDetailInfor = function(param, pLogicNeID, pPhyNeID,
			pIFSlotID) {
		var xml = _this.createQueryRemoteNeDetailInforXML(pLogicNeID, pPhyNeID,
				pIFSlotID);

		var urlreq = "../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_RTN_QUERY_REMOTE_NE_INFOR;

		loadXMLdoc(urlreq, "POST", true,
				_this.queryRemoteNeDetailInforCallback, param, "inputdata="
						+ xml);
	}

	/**
	 *              XML
	 */
	this.createQueryRemoteNeDetailInforXML = function(pLogicNeID, pPhyNeID,
			pIFSlotID) {
		var di = new inputxml("datainterface");
		bussiness = new tagElement("bussiness-params");
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", pLogicNeID);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "peerNEID");
		param.setAttribute("value", pLogicNeID);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "peerRealNEID");
		param.setAttribute("value", pPhyNeID);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "peerIFSlotId");
		param.setAttribute("value", pIFSlotID);
		row.appendChild(param);

		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);

		return di.toString();
	}

	/**
	 *            
	 */
	this.queryRemoteNeDetailInforCallback = function(doc, param) {
		var data = EncapsulateData(doc);
		var sErrCode = data.getSErrorCode();

		if (sErrCode == OPERATION_SUCCESS || sErrCode == OPERATION_PART_SUCCESS) {
			_this.afterGetRemoteNeDetailInfor(param, data);
		} else {
			_this.clearData();
			_this.getOppositeEnd().fillAllDataWhenOppositeNeNotExist();
			if (isLocalQueryFinshed) {
				LoadingProcess.removeWaitStatus();
			}
		}
	}

	/**
	 *                  
	 */
	this.afterGetRemoteNeDetailInfor = function(param, data) {
		_this.getPeerInfor(data);
		isPeerNeQueryFinshed = true;

		var nearfarDetector = new NearFarDetectorModule();
		nearfarDetector.queryNearFarEndFlag(param, _this.m_peerNEID);
		_this.getOppositeEnd().fillFarNeAllData();
	}

}
