
/**
 * 01.The IF Board Select Component, which is placed on the top of the page
 * 
 * @return
 */
function IFODUBoardSelectModule() {
	var _this = this;

	this.listenerList = new Array();

	this.addListener = function(obj) {
		_this.listenerList.push(obj);
	}

	this.notifyAll = function(event) {
		for ( var i = 0; i < _this.listenerList.length; i++) {
			var obj = _this.listenerList[i];
			obj.response(event);
		}
	}

	/**
	 *         
	 */
	this.queryIFODUBdList = function() {
		var xmlstr = createCommonQueryXML(neid);
		var urlreq = "../../../../../neExlorerServlet?sfid="
				+ get_iduodu_protectgroup + "&nmUser=" + nmUser;
		loadXMLdoc(urlreq, "POST", true, _this.queryIFODUBdListCallback, null,
				"inputdata=" + xmlstr);
	}

	/**
	 *        
	 */
	this.queryIFODUBdListCallback = function(doc) {
		var data = EncapsulateData(doc);
		_this.getIFODUBoardSelectElement().options.length = 0;
		HopTookit.addOptionToSelectElement(_this.getIFODUBoardSelectElement(),
				RESOURCE["selifbd"], "-1");
		g_commonData.getIFODUInforArray().clear();
		for ( var i = 0; i < data.getDataRowLength(); i++) {
			_this.addSlotToIFODUBoardSelectElement(data, i, "workingSlotId");
			_this.addSlotToIFODUBoardSelectElement(data, i, "protectionSlotId");
		}
		doSomethingAfterQueryIFODUBdList();
	}

	/**
	 *  IF             
	 */
	this.addSlotToIFODUBoardSelectElement = function(data, i, flag) {
		var tSlotId = data.getDataRowParam(i, flag);
		if (!HopTookit.isDataValid(tSlotId)) {
			return;
		}
		var tBoardName = flag == "workingSlotId" ? "workingbdname"
				: "protectbdname";
		var tOduId = flag == "workingSlotId" ? "workoduid" : "protectoduid";
		var ifoduObj = new IFODUBoardInfoStruct();
		ifoduObj.setIFSlotId(data.getDataRowParam(i, flag));
		ifoduObj.setIFBdName(data.getDataRowParam(i, tBoardName));
		ifoduObj.setODUSlotId(data.getDataRowParam(i, tOduId));
		g_commonData.getIFODUInforArray().push(ifoduObj);
		HopTookit.addOptionToSelectElement(_this.getIFODUBoardSelectElement(),
				ifoduObj.getIFBoardDescription(), ifoduObj.getIFSlotId());
	}

	/**
	 *                                       
	 */
	this.setIFODUSelectAtomEditHandler = function() {
		_this.getIFODUBoardSelectElement().onchange = function() {
			var eleCurValue = this.value;
			if (HopTookit.isDataInBusinessValid(eleCurValue)) {
				var bdName = this.options[this.options.selectedIndex].innerText;
				bdName = bdName.toUpperCase();
				_this.getIFODUBoardSelectElement().options.length = 0;
				var tmpArray = g_commonData.getIFODUInforArray();
				for ( var i = 0; i < tmpArray.length; i++) {
					var ifoduObj = tmpArray[i];
					HopTookit.addOptionToSelectElement(_this
							.getIFODUBoardSelectElement(), ifoduObj
							.getIFBoardDescription(), ifoduObj.getIFSlotId());
				}
				_this.getIFODUBoardSelectElement().value = eleCurValue;
				var event = new IFODUBoardSelectChangedEvent();
				event.initData(neid, eleCurValue);

				if (terminalType == TERMINAL_TYPE.LOCAL_END) //      
				{
					parent.isOppositeQueryFinshed = false;
					parent.isLocalQueryFinshed = false;
					parent.isPeerNeQueryFinshed = false;
					parent.LoadingProcess.removeWaitStatus();
					parent.LoadingProcess.showWaitStatus(
							"../../../../../images/", RESOURCE["loadingtitle"]);
				}

				queryAllAttributes(); //               
				/**
				 * TRANSV1R9C00-1098 
				 *                
				 */
				parent.buttonStruct.applyButton.disabled = true;
				_this.notifyAll(event);
			}
		}
	}

	this.initCurrentDomain = function() {
		_this.setIFODUSelectAtomEditHandler();
	}

	this.changeIFODUSelectAtomValue = function(newValue) {
		_this.getIFODUBoardSelectElement().value = newValue;
		_this.getIFODUBoardSelectElement().onchange();
	}

}

/**
 *   $("ifoduboardEle")   element
 */
IFODUBoardSelectModule.prototype.getIFODUBoardSelectElement = function() {
	return $("ifoduboardEle");
}

/**
 *   $("ifoduboardEle")   Value
 */
IFODUBoardSelectModule.prototype.getIFODUBoardSelectElementValue = function() {
	return $("ifoduboardEle").value;
}

/**
 *           ODU        
 */
function IFODUBoardInfoStruct() {
	this.ifSlotId = null;
	this.ifBdName = null;
	this.oduSlotId = null;
}

IFODUBoardInfoStruct.prototype.setIFSlotId = function(value) {
	this.ifSlotId = value;
}

IFODUBoardInfoStruct.prototype.setIFBdName = function(value) {
	this.ifBdName = value;
}

IFODUBoardInfoStruct.prototype.setODUSlotId = function(value) {
	this.oduSlotId = value;
}

IFODUBoardInfoStruct.prototype.getIFSlotId = function() {
	return this.ifSlotId;
}

IFODUBoardInfoStruct.prototype.getIFBdName = function() {
	return this.ifBdName;
}

IFODUBoardInfoStruct.prototype.getODUSlotId = function() {
	return this.oduSlotId;
}

IFODUBoardInfoStruct.prototype.getIFBoardDescription = function() {
	return this.ifSlotId + "-" + this.ifBdName;
}

function IFODUBoardSelectChangedEvent() {
	var _this = this;

	this.eventType = EVENT_TYPE.IFODUCHANGE_EVENT;

	this.neid = "-1";

	this.slotId = "-1";

	this.initData = function(tNeId, tSlotId) {
		_this.neid = tNeId;
		_this.slotId = tSlotId;
	}

	this.getEventType = function() {
		return _this.eventType;
	}

	this.getNeId = function() {
		return _this.neid;
	}

	this.getSlotId = function() {
		return _this.slotId;
	}
}
