
var HopTookit = new Object();

/**
 *                   
 * 
 * @param obj
 * @return
 */
HopTookit.setElementModified = function(obj)
{
	obj.style.backgroundColor = CELL_MODIFIED_BGCOLOR;	//       ,        
}

/**
 *                
 * 
 * @param obj
 * @return
 */
HopTookit.isElementModified = function(obj)
{
	var result = false;
	if(isIE)
	{
		result = obj.style.backgroundColor == CELL_MODIFIED_BGCOLOR ? true : false; 	
	}
	else
	{
		result = obj.style.backgroundColor == CELL_MODIFIED_BGCOLOR_SOLARIS ? true : false;
	}
	
	return result; 
}

/**
 *  Parameter   Row 
 * 
 * @param row
 * @param attriName
 * @param attriVal
 * @return
 */
HopTookit.addParam = function(row, attriName, attriVal)
{
    var param = new tagElement("param");
    param.setAttribute("name", attriName);
    param.setAttribute("value", attriVal );
    row.appendChild(param);
}

/**
 *         
 * 
 * @param val
 * @return
 */
HopTookit.isDataValid = function(val)
{
	if( val == null || val == "" || val == "undefined" )
	{
		return false; 
	}
	else
	{
		return true;
	}
}


/**
 *               
 * 
 * @param val
 * @return
 */
HopTookit.isDataInBusinessValid = function(val)
{
	if( val == null || val == "" || val == "undefined" || val == "-1" )
	{
		return false; 
	}
	else
	{
		return true;
	}
}

/**
 *   checkbox     
 * 
 * @param obj
 * @return
 */
HopTookit.getCheckboxEleValue = function(obj)
{
	return obj.checked == true ? "1" : "0";
}

/**
 *                 
 * 
 * @param flag
 * @param ifEditElement    input text  
 * @return
 */
HopTookit.setElementDisalbed = function(eleStr, flag, ifEditElement)
{
	$(eleStr).disabled = flag;

	var destinationColor = ifEditElement ? 
			CELL_ORIGINAL_EDIT_BGCOLOR : CELL_ORIGINAL_BGCOLOR;
	
	$(eleStr).style.backgroundColor = flag ? 
			CELL_DISABLED_BGCOLOR : destinationColor;
}

/**
 *    Option   Select   
 * 
 * @param element
 * @param optionName
 * @param optionId
 * @return
 */
HopTookit.addOptionToSelectElement = function(element, optionName, optionId)
{
	element.options[element.options.length] = new Option(optionName, optionId);
}


HopTookit.isContainOptionElement = function(element,  optionId)
{
	var size=element.options.length;
    var i=0;
	for(i=0;i<size;i++){
	   if(element.options[i].value ==optionId){
	   return true;
	   }
	}
	return false;
}

HopTookit.showErrorDialog = function(data)
{
    var errArr = [];
    errArr[0] = "nename";
    errArr[0] = "slotid";
    errArr[0] = "boardtype";
    openErrPage("../../../../../page/", data.getError(), errArr);
}


/**
 *            
 * 
 * @param obj
 * @return
 */
HopTookit.setFocusOnElement = function(obj)
{
	if( obj == null )
	{
		return;
	}
	
	try{
		obj.focus();
	}catch(e)
	{
		
	}
}

/**
 *           
 * 
 * @param obj
 * @return
 */
HopTookit.replaceNegativeWithEmptyStr = function(value)
{
	return value == "-1" ? "" : value;
}

/**
 *            
 */
HopTookit.getPairIFBoard = function(ifslotid)
{
	var flag = ifslotid % 2;
	var pairslotid = flag == 0 ? ifslotid-1 : ifslotid +1;

	return pairslotid;
}

HopTookit.processCellOnchange = function(cache)
{
	cache.updateElementBgColor();
	
	HopTookit.setFocusOnElement(document.body);
	
	parent.buttonStruct.applyButton.disabled = !parent.btnRightArr.applybtn.right;
    

}

/**
 *       Event
 */
function UnionEvent()
{
	var _this = this;
	
	this.eventType = EVENT_TYPE.LOCALOPPOSITEUNIONCHNANGE_EVENT;
	
	this.terminalType = ""; 
	
	this.elementID = "";
	
	this.flodStatus = "";
	
	this.init = function(pTerminalType, pElementID)
	{
		_this.terminalType = pTerminalType;
		
		_this.elementID = pElementID;
	}
	
	this.getEventType = function()
	{
		return _this.eventType;
	}
	
	this.getTermialType = function()
	{
		return _this.terminalType;
	}
	
	this.getElementID = function()
	{
		return _this.elementID;
	}
	
	this.getElementValue = function()
	{
		return $(_this.elementID).value;
	}
	
	this.getElementChecked = function()
	{
		return $(_this.elementID).checked;
	}

	this.setElementDisplay = function(status)
	{
		_this.flodStatus = status;
	}
	
	this.getElementDisplay = function()
	{
		return _this.flodStatus;
	}
}

/**
 *     
 */
HopTookit.sendUnionEvent = function(terminalType, eleId, obj)
{
	var event = new UnionEvent();
	event.init(terminalType, eleId);
	obj.notifyAll(event);
}

HopTookit.sendUnionFoldEvent = function(terminalType, eleId, obj, advStyle)
{
	var event = new UnionEvent();
	event.init(terminalType, eleId);
	event.setElementDisplay(advStyle);
	obj.notifyAll(event);
}

/**
 *      
 */
HopTookit.checkDataRange = function(ele, minVal, maxVal, decimal, exceptval)
{
	ele.minValue = minVal;
		
	ele.maxValue = maxVal;
		
	ele.exceptValue = exceptval;
	
	if( decimal )			//      
	{
		if( exceptval )		//        
		{
			textCheck(ele, minVal, maxVal, decimal, exceptval);
		}
		else
		{
			checkText( ele, minVal, maxVal, decimal );
		}
	}
	else
	{
		if( exceptval )
		{
			textCheck(ele, minVal, maxVal, 0, exceptval);
		}
		else
		{
			checkText( ele, minVal, maxVal, 0);	
		}
	}
    
    HopTookit.setDataRangeTip(ele, minVal, maxVal, exceptval);
}

/**
 * val                                   
 */
HopTookit.adjustIntValueAccordingToRange = function(tmpTerminalType, ele, objVal)
{
	var minVal = ele.minValue;
	
	var maxVal = ele.maxValue;

	if( parseInt(objVal) > parseInt(maxVal) )
	{
		ele.value = maxVal;
		
		if( tmpTerminalType == TERMINAL_TYPE.LOCAL_END )
		{
			setTimeout(HopTookit.alertFarLater,500);	
		}
		else
		{
			setTimeout(HopTookit.alertLocalLater,500);
		}
	}
	else if( parseInt(objVal) < parseInt(minVal) )
	{
		ele.value = minVal;
		
		if( tmpTerminalType == TERMINAL_TYPE.LOCAL_END )
		{
			setTimeout(HopTookit.alertFarLater,500);	
		}
		else
		{
			setTimeout(HopTookit.alertLocalLater,500);
		}
	}
	else
	{
		ele.value = objVal;
	}
}

HopTookit.adjustFloatValueAccordingToRange = function(tmpTerminalType, ele, objVal)
{
	var minVal = ele.minValue;
	
	var maxVal = ele.maxValue;

	if( parseFloat(objVal) > parseFloat(maxVal) )
	{
		ele.value = maxVal;
		
		if( tmpTerminalType == TERMINAL_TYPE.LOCAL_END )
		{
			setTimeout(HopTookit.alertFarLater,500);	
		}
		else
		{
			setTimeout(HopTookit.alertLocalLater,500);
		}
	}
	else if( parseFloat(objVal) < parseFloat(minVal) )
	{
		ele.value = minVal;
		
		if( tmpTerminalType == TERMINAL_TYPE.LOCAL_END )
		{
			setTimeout(HopTookit.alertFarLater,500);	
		}
		else
		{
			setTimeout(HopTookit.alertLocalLater,500);
		}
	}
	else
	{
		ele.value = objVal;
	}
}

HopTookit.alertLocalLater = function()
{
	var alertMsg = RESOURCE["cannotmodifylocal"];
	alert(alertMsg);
}

HopTookit.alertFarLater = function()
{
	var alertMsg = RESOURCE["cannotmodifyfar"];
	alert(alertMsg);
}


/**
 * 
 */
HopTookit.setDataRangeTip = function(ele, minVal, maxVal, exceptval)
{
	if( exceptval == null )
	{
		ele.title = minVal + " ~ " + maxVal;
	}
	else
	{
		ele.title = exceptval + " , " + minVal + " ~ " + maxVal;
	}
}

/**
 *                   
 */
HopTookit.getProtectionModeDescription = function(modeval)
{
	var returnString = "-";
	
	if( modeval == wModeStru.SDVal )
	{
		returnString = wModeStru.SD;
	}
	if( modeval == wModeStru.FDVal )
	{
		returnString = wModeStru.FD;
	}
	if( modeval == wModeStru.HSBVal )
	{
		returnString = wModeStru.HSB;
	}	

	return returnString;
}

/**
 *        
 * 
 * @return
 */
function BoardInforStruct()
{
	var _this = this;
	
	this.slotID = -1;
	
	this.portID = -1;

	this.init = function(slotid, portid)
	{
		_this.slotID = slotid;
		_this.portID = portid;
	}
	
	this.getSlotID = function()
	{
		return _this.slotID;
	}
	
	this.getPortID = function()
	{
		return _this.portID;
	}
}

/**
 *            
 */
HopTookit.getBoardInforStruct = function(slotid, portid)
{
	var bdInforStruct = new BoardInforStruct();
	
	bdInforStruct.init(slotid, portid);
	
	return bdInforStruct;
}

HopTookit.isRTN900_AND_VERSION_ABOVE_05760220 = function(tNeType, tNeVersion)
{
	if( tNeType == NETYPE_RTN610 || tNeType == NETYPE_RTN620 || tNeType == NETYPE_RTN605 ) 
	{
		return false;
	}
	else if( tNeType == NETYPE_RTNSMART || tNeType == NETYPE_RTN905 )
	{
		return true;
	}
	else
	{
		var versionArray = tNeVersion.split(".");
		if( versionArray[2] > "02" || (versionArray[2] == "02" && versionArray[3] >= "20") )
		{
			return true;
		}
		else
		{
			return false;
		}
	}	
}

/**
 *       1+1  
 */
HopTookit.isSupportEditIF1Plus1 = function()
{
	if( neType == NETYPE_RTN610  || neType == NETYPE_RTN605 ) 
	{
		return false;
	}
	else
	{	
		return true;
	}	
}
HopTookit.isRTN900_AND_VERSION_ABOVE_05760310 = function(tNeType, tNeVersion)
{
	if( tNeType == NETYPE_RTN610 || tNeType == NETYPE_RTN620 || tNeType == NETYPE_RTN605 ) 
	{
		return false;
	}
	else if( tNeType == NETYPE_RTNSMART || tNeType == NETYPE_RTN905 )
	{
		return true;
	}
	else
	{
		var versionArray = tNeVersion.split(".");
		if( versionArray[2] > "03" || (versionArray[2] == "03" && versionArray[3] >= "10") )
		{
			return true;
		}
		else
		{
			return false;
		}
	}	
}
HopTookit.isRTN900NA = function()
{
	if( neType == NETYPE_RTN910NA || neType == NETYPE_RTN950NA )  
	{
		return true;
	}
	else
	{
		return false;
	}
}
HopTookit.isRTNSmart = function()
{
	if( neobject.neType == NETYPE_RTNSMART)  
	{
		return true;
	}
	else
	{
		return false;
	}
}

/**
 *             
 */
HopTookit.isSupportHighLevelModulation = function()
{
	var boardName = $("ifoduboardEle").options[$("ifoduboardEle").selectedIndex].text;	//           

	if( boardName.indexOf("SHXA2") >= 0 ||
		boardName.indexOf("ISU3") >= 0 ||
		boardName.indexOf("ISV3") >= 0 )
	{
		return true;
	}
	else
	{
		return false;
	}
}

/**
 * modulation1     1 modulation2     2                 
 */
HopTookit.compareModulations = function(modulation1, modulation2)
{
	var priority1 = priorityMap[modulation1];
	var priority2 = priorityMap[modulation2];
	
	if( priority1 > priority2 )
	{
		return 1;
	}
	else if( priority1 == priority2 )
	{
		return 0;
	}
	else
	{
		return -1;
	}
}

/**
 *     XPIC
 */
HopTookit.isSupportXPIC = function()
{
	if( neobject.neType == NETYPE_RTN610 || neobject.neType == NETYPE_RTN605 || neobject.neType == NETYPE_RTNSMART) 
	{
		return false;
	}
	else
	{
		return true;
	}
}
/**
 *     1j1
 */
HopTookit.isSupport1J1 = function()
{
	if(neobject.neType == NETYPE_RTNSMART) 
	{
		return false;
	}
	else
	{
		return true;
	}
}

/**
 *          
 */
HopTookit.isPairingBoard = function(ifSlotID1, ifSlotID2)
{
	var pairingBoard = HopTookit.getPairingBoard(ifSlotID1)

	var result = pairingBoard == ifSlotID2 ? true : false;

	return result;
}

/**
 *       
 */
HopTookit.getPairingBoard = function(ifSlotID1)
{
	var netype = neType;
	var pairingBoard = "";
	
	if( netype == NETYPE_RTN610 )
	{
		pairingBoard = PAIRING_RELATION_610[ifSlotID1];
	}
	if( netype == NETYPE_RTN620 )
	{
		pairingBoard = PAIRING_RELATION_620[ifSlotID1];
	}
	if( netype == NETYPE_RTN605 )
	{
		pairingBoard = PAIRING_RELATION_605[ifSlotID1];
	}
	if( netype == NETYPE_RTN910 || netype == NETYPE_RTN910NA )
	{
		pairingBoard = PAIRING_RELATION_910[ifSlotID1];
	}
	if( netype == NETYPE_RTN950 || netype == NETYPE_RTN950NA || netype == NETYPE_RTN950A)
	{
		pairingBoard = PAIRING_RELATION_950[ifSlotID1];
	}
	if( netype == NETYPE_RTN980 )
	{
		pairingBoard = PAIRING_RELATION_980[ifSlotID1];
	}
	
	return pairingBoard;
}

/**
 *     Element
 * 
 * @return
 */
function DecoratedElement()
{
	var _this = this;
	
	this.mElementID = null;
	
	this.mType = null;
	
	this.cacheValue = "";
	
	this.getElement = function()
	{
		return $(_this.mElementID);
	}
	
	this.getElementType = function()
	{
		return _this.mType;
	}
	
	this.getElementID = function()
	{
		return _this.mElementID;
	}
	
	this.bindElement = function(elementId, type)
	{
		_this.mElementID = elementId;
		
		_this.mType = type;
		
		_this.initCacheValue();		 
	}

	/* Setters and Getters Start */
	this.setCacheValue = function(val)
	{
		_this.cacheValue = val;
	}
	
	this.getCacheValue = function()
	{
		return _this.cacheValue;
	}
	
	this.setElementValue = function(val)
	{
		if( _this.isCheckTypeElement() )
		{
			_this.getElement().checked = val;
		}
		else
		{
			_this.getElement().value = val;
		}
	}
	
	this.getElementValue = function()
	{
		var retValue = "";
		
		if( _this.isCheckTypeElement() )
		{
			retValue = _this.getElement().checked;
		}
		else
		{
			retValue = _this.getElement().value;
		}
		
		return retValue;
	}
	
	this.setElementDisabled = function(flag)
	{
		_this.getElement().disabled = flag;
		
		_this.updateElementBgColor();
	}
	
	this.getElementDisabled = function()
	{
		return _this.getElement().disabled;
	}	
	
	/* Setters and Getters End */
	
	this.isElementModified = function()
	{
		var retValue = _this.getElementValue() == _this.getCacheValue() ? false : true;
		
		return retValue;
	}
	
	this.modifyElementValue = function(val)
	{
		if( _this.isCheckTypeElement() )
		{
			_this.getElement().checked = val;
		}
		else
		{
			_this.getElement().value = val;
		}
		
		_this.updateElementBgColor();
	}
	
	/**
	 *        
	 */
	this.updateElementBgColor = function()
	{
		if( _this.getElementDisabled() )							//         disabled          disabled     
		{
			_this.getElement().style.backgroundColor = CELL_DISABLED_BGCOLOR;
		}
		else
		{
			if( _this.isElementModified() )							//                     
			{
				_this.getElement().style.backgroundColor = CELL_MODIFIED_BGCOLOR;	//          ,             
			}
			else													//                    
			{
				if( _this.isCheckTypeElement() )
				{
					_this.getElement().style.backgroundColor = CELL_ORIGINAL_BGCOLOR;	//          ,             
				}
				else
				{
					_this.getElement().style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;	//          ,             
				}
			}
		}
	}
	
	/**
	 *    check box radio     
	 */
	this.isCheckTypeElement = function()
	{
		var retValue = false;
		
		if( _this.mType == DECORATED_ELEMENT_TYPE.CHECKBOX || 
			_this.mType == DECORATED_ELEMENT_TYPE.RADIO )
		{
			retValue = true;
		}
		
		return retValue;
	}
	
	this.updateElementValueToCacheValue = function()
	{
		_this.setCacheValue(_this.getElementValue());
	}
	
	this.updateCacheValueToElementValue = function()
	{
		_this.setElementValue(_this.getCacheValue());
	}
	
	/**
	 *                 
	 */
	this.initAllValue = function()
	{
		_this.initElementValue();
		_this.initCacheValue();
	}
	
	/**
	 *        
	 */
	this.initCacheValue = function()
	{
		if(  _this.isCheckTypeElement() )
		{
			_this.cacheValue = false;		
		}
		else
		{
			_this.cacheValue = "";
		}
	}
	
	/**
	 *         
	 */
	this.initElementValue = function()
	{
		if(  _this.isCheckTypeElement() )
		{
			_this.getElement().checked = false;		
		}
		else
		{
			_this.getElement().value = "";
		}
	}
}


function OperationStateMapping()
{	
	var _this = this;
	
	this.obj = null;
	
	this.type = null;
	
	this.init = function(_obj, _type)
	{
		_this.obj = _obj;
		
		_this.type = _type
	}
	
	this.getOperationType = function()
	{
		return _this.type;
	}
	
	this.excute = function()
	{
		if( _this.type == NEOPERATION_TYPE.CREATE )
		{
			_this.obj.createProtection();
			_this.obj.modifyProtection();
		}
		else if( _this.type == NEOPERATION_TYPE.DELETE )
		{
			_this.obj.deleteProtection();
		}
		else if( _this.type == NEOPERATION_TYPE.RECREATE )
		{
			_this.obj.recreateProtection();
			_this.obj.modifyProtection();
		}
		else if( _this.type == NEOPERATION_TYPE.MODIFY )
		{
			_this.obj.modifyProtection();
		}
		else if( _this.type == NEOPERATION_TYPE.DONOTING )
		{
		}
		else
		{
		}
	}
}

function OperationExecutor()
{
	this.excuteOperations = function( ifOperation, xpicOperation )
	{
		
		var ifOperationType = ifOperation.getOperationType();
		
		var xpicOperationType = xpicOperation.getOperationType();
		
		if( ifOperationType == NEOPERATION_TYPE.CREATE && xpicOperationType == NEOPERATION_TYPE.DELETE )
		{
			xpicOperation.excute();
			
			ifOperation.excute();
		}
		else if( ifOperationType == NEOPERATION_TYPE.DELETE && xpicOperationType == NEOPERATION_TYPE.CREATE )
		{
			ifOperation.excute();
			
			xpicOperation.excute();		
		}
		else
		{
			ifOperation.excute();
			
			xpicOperation.excute();
		}
	}
}
