var g_commonData = new CommonData();
var ifBdSelectModule = new IFODUBoardSelectModule();
var evtDispatchCenter = new EventDispatchCenter();
var peerNESearchModule = parent.peerNESearchModule;
var basicParamModule = new BasicParamModule();

/**
 *       
 * 
 * @return
 */
function bindModules() {
	ifBdSelectModule.addListener(evtDispatchCenter);
	basicParamModule.addListener(evtDispatchCenter);
}

/**
 *          
 * 
 * @return
 */
function initUI() {
	ifBdSelectModule.initCurrentDomain();
	basicParamModule.initCurrentDomain();
}

/**
 *         
 * 
 * @return
 */
function queryAllAttributes() {
	basicParamModule.queryLoopback();
}

/**
 *         
 * 
 * @return
 */
function applyAllAttributes() {
	basicParamModule.applyLoopback();
	parent.closeWindowFlg = basicParamModule.getSuccFlag();
}

/**
 * 
 * @param neid
 * @param ifslotid
 * @param oduslotid             ODU     
 * @param anotheroduslotid    1+1                       ODU     
 * @return
 */
function createCommonQueryXML(neid, ifslotid, rfslotid, flag) {
	var isRefresh = 0;
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;

	if (ifslotid) //       
	{
		row = new tagElement("row-params");
		addParam(row, newParam("neid", neid));
		addParam(row, newParam("ifslotid", ifslotid));
		addParam(row, newParam("rfslotid", rfslotid));
		bussiness.appendChild(row);
	} else //       
	{
		row = new tagElement("row-params");
		addParam(row, newParam("neid", neid));
		bussiness.appendChild(row);
	}

	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *                        
 * 
 * @return
 */
function isAnyElementModified() {
	return basicParamModule.isAnyElementInBasicParamFieldModified();
}

/**
 *     
 * 
 * @return
 */
function drawRect(x1, y1, x2, y2, color, size, style) {
	drawLine(x1, y1, x2, y1, color, size, style);
	drawLine(x1, y2, x2, y2, color, size, style);
	drawLine(x1, y1, x1, y2, color, size, style);
	drawLine(x2, y1, x2, y2, color, size, style);
}

/**
 *     
 * 
 * @return
 */
function drawLine(x1, y1, x2, y2, color, size, style) {
	var i;
	var r = Math
			.floor(Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
	var theta = Math.atan((x2 - x1) / (y2 - y1));
	if (((y2 - y1) < 0 && (x2 - x1) > 0) || ((y2 - y1) < 0 && (x2 - x1) < 0)) {
		theta = Math.PI + theta;
	}
	var dx = Math.sin(theta);
	var dy = Math.cos(theta);
	for (i = 0; i < r; i++) {
		switch (style) {
		case 0:
			drawDot(x1 + i * dx, y1 + i * dy, color, size);
			break;
		case 1:
			i += size * 2;
			drawDot(x1 + i * dx, y1 + i * dy, color, size);
			break;
		case 2:
			if (Math.floor(i / 4 / size) % 2 == 0) {
				drawDot(x1 + i * dx, y1 + i * dy, color, size);
			} else {
				i += size * 2;
				drawDot(x1 + i * dx, y1 + i * dy, color, size);
			}
			break;
		default:
			drawDot(x1 + i * dx, y1 + i * dy, color, size);
			break;
		}
	}
}

/**
 *     
 * 
 * @return
 */
function drawDot(x, y, color, size) {
	document
			.write("<table border='0' cellspacing=0 cellpadding=0><tbody><tr><td style='position: absolute; left: "
					+ x
					+ ";top:"
					+ y
					+ ";background-color: "
					+ color
					+ "' width="
					+ size
					+ " height="
					+ size
					+ " ></td></tr></tbody></table>");
}
