
/**
 *          
 * @return
 */
function CommonData()
{
	var _this = this;
	
	this.m_ifoduInforArray = new Array();
	
	this.m_exsistingIF1plus1GroupArray = new Array();
	
	this.m_exsistingXpicGroupArray = new Array();
	
	this.getCurrentIFODUSelectBoard = function()
	{
		return $("ifoduboardEle").value;
	}
	
	/**
	 *              (IFODUBoardInfoStruct)   
	 */
	this.getIFODUInforArray = function()
	{
		return _this.m_ifoduInforArray;
	}
	
	
	/**
	 *               
	 */
	this.addProtectionGroupToIF1PlusGroupArray = function(tmpGroupId, tmpWorkBoardSlotId, tmpProtectBoardSlotId)
	{
		var if1plus1GrouObjcet = new Object();
		if1plus1GrouObjcet.groupId = tmpGroupId;
		if1plus1GrouObjcet.workboardSlotId = tmpWorkBoardSlotId;
		if1plus1GrouObjcet.protectboardSlotId = tmpProtectBoardSlotId;
		
		_this.m_exsistingIF1plus1GroupArray.push(if1plus1GrouObjcet);
	}
	
	/**
	 *             
	 */
	this.deleteProtectionGroupFromIF1PlusGroupArray = function(groupid)
	{
		for( var i = _this.m_exsistingIF1plus1GroupArray.length-1; i >= 0 ; i--)
		{
			var if1plus1GrouObjcet = _this.m_exsistingIF1plus1GroupArray[i];
			
			if( if1plus1GrouObjcet.groupId == groupid )
			{
				_this.m_exsistingIF1plus1GroupArray.removeAt(i);
			}
		}
	}
	
	/**
	 *           1+1  
	 */
	this.isRelatedIF1Plus1GroupExist = function()
	{
		var isExist = false;
		
		for( var i = 0; i < _this.m_exsistingIF1plus1GroupArray.length; i++)
		{
			var if1plus1GrouObjcet = _this.m_exsistingIF1plus1GroupArray[i];
			var tmpWorkBoardSlotId = if1plus1GrouObjcet.workboardSlotId;
			var tmpProtectBoardSlotId = if1plus1GrouObjcet.protectboardSlotId;
			
			if( tmpWorkBoardSlotId == _this.getCurrentIFODUSelectBoard() || 
				tmpProtectBoardSlotId == _this.getCurrentIFODUSelectBoard() )
			{
				isExist = true;
				break;
			}
		}
		
		return isExist;
	}
	
	/**
	 *        1+1  
	 */
	this.getRelatedIF1Plus1Group = function()
	{	
		var if1plus1Objcet = null;
		for( var i = 0; i < _this.m_exsistingIF1plus1GroupArray.length; i++)
		{
			var if1plus1GrouObjcet = _this.m_exsistingIF1plus1GroupArray[i];
			var tmpWorkBoardSlotId = if1plus1GrouObjcet.workboardSlotId;
			var tmpProtectBoardSlotId = if1plus1GrouObjcet.protectboardSlotId;
			
			if( tmpWorkBoardSlotId == _this.getCurrentIFODUSelectBoard() || 
				tmpProtectBoardSlotId == _this.getCurrentIFODUSelectBoard() )
			{
				if1plus1Objcet = if1plus1GrouObjcet;
				break;
			}
		}
		
		return if1plus1Objcet;
		
	}
	
	
	
	/**
	 *  XPIC          XPIC   
	 */
	this.addProtectionGroupToXpicGroupArray = function(tmpGroupId, tmpWorkBoardSlotId, tmpProtectBoardSlotId)
	{
		var xpicGrouObjcet = new Object();
		xpicGrouObjcet.groupId = tmpGroupId;
		xpicGrouObjcet.workboardSlotId = tmpWorkBoardSlotId;
		xpicGrouObjcet.protectboardSlotId = tmpProtectBoardSlotId;
		
		_this.m_exsistingXpicGroupArray.push(xpicGrouObjcet);
	}
	
	/**
	 *  XPIC        XPIC   
	 */
	this.deleteProtectionGroupFromXpicArray = function(groupid)
	{
		for( var i = _this.m_exsistingXpicGroupArray.length-1; i >= 0 ; i--)
		{
			var xpicGrouObjcet = _this.m_exsistingXpicGroupArray[i];
			
			if( xpicGrouObjcet.groupId == groupid )
			{
				_this.m_exsistingXpicGroupArray.removeAt(i);
			}
		}
	}
	
	/**
	 *         XPIC  
	 */
	this.isRelatedIXpicGroupExist = function()
	{
		var isExist = false;
		
		for( var i = 0; i < _this.m_exsistingXpicGroupArray.length; i++)
		{
			var xpicGrouObjcet = _this.m_exsistingXpicGroupArray[i];
			var hBoardSlotId = xpicGrouObjcet.workboardSlotId;
			var vBoardSlotId = xpicGrouObjcet.protectboardSlotId;
			
			if( hBoardSlotId == _this.getCurrentIFODUSelectBoard() || 
				vBoardSlotId == _this.getCurrentIFODUSelectBoard() )
			{
				isExist = true;
				break;
			}
		}
		
		return isExist;
	}
	
	/**
	 *         XPIC  
	 */
	this.getRelatedIXpicGroup = function()
	{
		var xpicObjcet = null;
		
		for( var i = 0; i < _this.m_exsistingXpicGroupArray.length; i++)
		{
			var xpicGrouObjcet = _this.m_exsistingXpicGroupArray[i];
			var hBoardSlotId = xpicGrouObjcet.workboardSlotId;
			var vBoardSlotId = xpicGrouObjcet.protectboardSlotId;
			
			if( hBoardSlotId == _this.getCurrentIFODUSelectBoard() || 
				vBoardSlotId == _this.getCurrentIFODUSelectBoard() )
			{
				xpicObjcet = xpicGrouObjcet;
				break;
			}
		}
		
		return xpicObjcet;
	}
	
	/**
	 *       IF    
	 */
	this.getIFBoardName = function(param_ifslotid)
	{	
		var ifoduStruct = null;
		
		for( var i = 0; i < _this.m_ifoduInforArray.length; i++ )
		{
			var tmpIFSlotId = _this.m_ifoduInforArray[i].getIFSlotId();
			if( tmpIFSlotId == param_ifslotid )
			{
				ifoduStruct = _this.m_ifoduInforArray[i];
			}
		}
		
		return ifoduStruct.getIFBdName();
	}
	
	/**
	 *          SlotId          OduId
	 */
	this.getRelatedODUSlotId = function(param_ifslotid)
	{	
		var ifoduStruct = null;
		
		for( var i = 0; i < _this.m_ifoduInforArray.length; i++ )
		{
			var tmpIFSlotId = _this.m_ifoduInforArray[i].getIFSlotId();
			if( tmpIFSlotId == param_ifslotid )
			{
				ifoduStruct = _this.m_ifoduInforArray[i];
			}
		}
		
		return ( ifoduStruct == null) ? "" : ifoduStruct.getODUSlotId();
	}
	
	/**
	 *        
	 */
	this.isIFBoard = function(t_slotid)
	{
		var isIFBoardFlag = false;
		for( var i = 0; i < _this.m_ifoduInforArray.length; i++ )
		{
			var ifoduStruct = _this.m_ifoduInforArray[i];
			var tmpIFSlotId = ifoduStruct.getIFSlotId();
			var tmpODUSlotId = ifoduStruct.getODUSlotId();
			
			if( t_slotid == tmpIFSlotId )
			{
				return true;
			}
			
			if( t_slotid == tmpODUSlotId )
			{
				return false;
			}
		}
		
		return isIFBoardFlag;
	}
	this.isODUBoard = function(t_slotid)
	{
		var isODUBoardFlag = false;
		for( var i = 0; i < _this.m_ifoduInforArray.length; i++ )
		{
			var ifoduStruct = _this.m_ifoduInforArray[i];
			var tmpIFSlotId = ifoduStruct.getIFSlotId();
			var tmpODUSlotId = ifoduStruct.getODUSlotId();
			if( t_slotid == tmpODUSlotId )
			{
				return true;
			}
			
			if( t_slotid == tmpIFSlotId )
			{
				return false;
			}
		}
		
		return isODUBoardFlag;
	}
}
