/**
 *       
 */

var st = new SortTable();
var emptyIcon = '../../../../../images/treetable/empty.gif';
var ckwip = '../../../../../images/neloop/clockwise_inloop.gif';
var ctwop = '../../../../../images/neloop/counterwise_outloop.gif';

var hasChange = false;
var eleModifyArray = new Array();

function BasicParamModule() {
	var _this = this;
	var isSuccess = false;
	this.listenerList = new Array();

	this.addListener = function(obj) {
		_this.listenerList.push(obj);
	}

	this.notifyAll = function(event) {
		for ( var i = 0; i < _this.listenerList.length; i++) {
			var obj = _this.listenerList[i];
			obj.response(event);
		}
	}

	/**
	 *     
	 * 
	 * @return
	 */
	this.queryLoopback = function() {
		_this.clearParamField();
		var urlreq = "../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_QUERY_RADIOLINKLOOP + "&nmUser=" + nmUser;
		var ifslotid = $("ifoduboardEle").value;
		var rfslotid = g_commonData.getRelatedODUSlotId(ifslotid);
		var xmlstr = createCommonQueryXML(neid, ifslotid, rfslotid);

		loadXMLdoc(urlreq, "POST", true, _this.queryLoopCallback, false,
				"inputdata=" + xmlstr);
	}

	/**
	 *          
	 * 
	 * @param doc
	 * @return
	 */
	this.queryLoopCallback = function(doc) {
		var data = EncapsulateData(doc);
		var dataArray = new Array();
		if (data.getSErrorCode() != OPERATION_SUCCESS) {
			dataArray.push(data);
		}
		if (st.getDataRowLength() > 0) {
			for ( var i = 0, isize = st.getDataRowLength(); i < isize; i++) {
				st.setRowNoneSelect(i);
			}
		}
		rowSelectHandler(null);
		st.clearTableData();
		createTableBody(st, window.tableconf[0], data, RESOURCE);
		_this.setNMPortEnable();
	}

	this.setNMPortEnable = function() {
		if (terminalType == TERMINAL_TYPE.LOCAL_END) {
			parent.isLocalQueryFinshed = true;
		}

		if (terminalType == TERMINAL_TYPE.OPPOSITE_END) {
			parent.isOppositeQueryFinshed = true;
		}

		if (parent.isPeerNeQueryFinshed) {
			if (!parent.isOppositeNeExist() && parent.isLocalQueryFinshed) {
				parent.LoadingProcess.removeWaitStatus();
			}
		}

		if (parent.isLocalQueryFinshed && parent.isOppositeQueryFinshed) {
			parent.LoadingProcess.removeWaitStatus();
		}
		for ( var i = 0, length = st.getDataRowLength(); i < length; i++) {
			var loop = st.getCellCurrentValue(i, "inloop", "inloop");
			var inloopElement = st.getCellShow(i, "inloop").element;
			inloopElement.parentNode.align = "middle";
			if (!loop) {
				inloopElement.disabled = true;
				inloopElement.checked = false;
				st.getCell(i, "inloop").element.disabled = true;
			} else if (loop == "0") {
				inloopElement.disabled = false;
				inloopElement.checked = false;
			} else if (loop == "1") {
				inloopElement.disabled = false;
				inloopElement.checked = true;
			}
			loop = st.getCellCurrentValue(i, "outloop", "outloop");
			var outloopElement = st.getCellShow(i, "outloop").element;
			outloopElement.parentNode.align = "middle";
			if (!loop) {
				outloopElement.disabled = true;
				outloopElement.checked = false;
				st.getCell(i, "outloop").element.disabled = true;
			} else if (loop == "0") {
				if(neType == "115")
				{
					outloopElement.disabled = true;
					outloopElement.checked = false;
				}else{
					outloopElement.disabled = false;
					outloopElement.checked = false;				
				}
			} else if (loop == "1") {
				outloopElement.disabled = false;
				outloopElement.checked = true;
			}
			inloopElement.onclick = function() {
				if (this.checked) {
					this.parentNode.nextSibling.childNodes[0].checked = false;
				}
				st.setCellModify(this.parentNode.parentNode.rowIndex, "inloop",
						true);
				st.getCell(this.parentNode.parentNode.rowIndex, "inloop").element.style.backgroundColor = "#d0f946";
				parent.buttonStruct.applyButton.disabled = !parent.btnRightArr.applybtn.right;
				hasChange = true;
			}
			outloopElement.onclick = function() {
				if (this.checked) {
					this.parentNode.previousSibling.childNodes[0].checked = false;
				}
				st.setCellModify(this.parentNode.parentNode.rowIndex,
						"outloop", true);
				st.getCell(this.parentNode.parentNode.rowIndex, "outloop").element.style.backgroundColor = "#d0f946";
				parent.buttonStruct.applyButton.disabled = !parent.btnRightArr.applybtn.right;
				hasChange = true;
			}
			st.getCell(i, "inloop").element.style.backgroundColor = "#FFFFFF";
			st.getCell(i, "outloop").element.style.backgroundColor = "#FFFFFF";
			
			var objname = st.getCellCurrentValue(i, "interface",
			"interface");
			var attrid = st.getCellCurrentValue(i, "attrid", "attrid");
			var inloop = st.getCellShow(i, "inloop").element.checked;
			var outloop = st.getCellShow(i, "outloop").element.checked;
			refreshGraph(objname.substring(0, objname.lastIndexOf('(')),
					attrid, inloop, outloop);
		}
	}

	this.addModifyRow = function(rowIndex) {
		if (eleModifyArray.indexOf(rowStr) < 0) {
			eleModifyArray.push(rowIndex);
		}
	}

	this.applyLoopback = function() {
		var xmlstr = _this.createModifyLoopback(neid);
		var urlreq = "../../../../../neExlorerServlet?sfid="
				+ TECMDCODE_SET_RADIOLINKLOOP + "&nmUser=" + nmUser;
		loadXMLdoc(urlreq, "POST", false, _this.applyLoopbackCallback, null,
				"inputdata=" + xmlstr);
	}

	/**
	 *    CALLBACK  
	 * 
	 * @param doc
	 * @param param
	 * @return
	 */
	this.applyLoopbackCallback = function(doc) {
		var data = EncapsulateData(doc);
		isSuccess = true;
		if (data.getSErrorCode() != OPERATION_SUCCESS) {
			_this.showErrorDialog(data, true);
			return;
		}		
		hasChange = false;
		_this.clearBasicParamFieldBgColor();
	}

	this.getSuccFlag = function(){
		return isSuccess;
	}
	
	this.showErrorDialog = function(data, isSetFlag) {
		var errArr = [];
		errArr[0] = "nename";
		errArr[1] = "boardname";
		if (isSetFlag) {
			errArr[1] = "slotid";
			errArr[2] = "boardname";
			errArr[3] = "portname";
			errArr[4] = "attrId";
			for ( var i = 0; i < data.getBErrLength(); i++) {
				errorObj = data.getError().rowErrors[i].errorObj;
				var attrName = errorObj["attrId"];
				if ((attrName == "W32PORT_ATTR_PORTLOOPBACK")
						|| (attrName == "W32BRD_ATTR_RFLOOPBACK")) {
					errorObj["attrId"] = RESOURCE[attrName];
				}
			}
		}
		openErrPage("../../../../../page/", data.getError(), errArr);
	}

	/**
	 *    xml  
	 * 
	 * @param neid
	 * @param sfId
	 * @return
	 */
	this.createModifyLoopback = function(neid) {
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		for ( var i = 0, len = st.getDataRowLength(); i < len; i++) {
			if (!st.getModify(i)) {
				continue;
			}
			var row = new tagElement("row-params");
			HopTookit.addParam(row, "neid", neid); //   ID
			var slotid = st.getCellCurrentValue(i, "slotid", "slotid");
			HopTookit.addParam(row, "slotid", slotid); //   ID
			var portid = st.getCellCurrentValue(i, "portid", "portid");
			HopTookit.addParam(row, "portid", portid); //   ID
			var attrid = st.getCellCurrentValue(i, "attrid", "attrid");
			HopTookit.addParam(row, "attrid", attrid); //   ID
			var inloop = st.getCellShow(i, "inloop").element.checked;
			var outloop = st.getCellShow(i, "outloop").element.checked;
			var loopstatus = "0";
			if (inloop) {
				loopstatus = "1";
			} else if (outloop) {
				loopstatus = "2";
			}
			HopTookit.addParam(row, "loopstatus", loopstatus); //     
			bussiness.appendChild(row);
		}
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}

	/**
	 *        
	 * 
	 * @return
	 */
	this.clearParamField = function() {
		hasChange = false;
		st.clearTableData();
	}

	/**
	 *   BasicField          
	 * 
	 * @return
	 */
	this.isAnyElementInBasicParamFieldModified = function() {
		return hasChange;
	}

	/**
	 *      
	 */
	this.initCurrentDomain = function() {
		_this.appendTable($("loop_table"));
	}

	this.appendTable = function(element) {
		st.setImage("../../../../../images/");
		createTableHead(st, window.tableconf[0]);
		st.setBodyHeight(280);
		st.setSingleChoiceFlg(true);
		st.setOnRowSelectHandler(rowSelectHandler);
		element.appendChild(st.getTable());
		element.oncontextmenu = popupMenuHandler;
	}

	function cellEditHandler(param) {
		if (param.colid == "inloop") {
			st.getCellShow(param.rowindex, "outloop").element.checked = false;
		} else {
			st.getCellShow(param.rowindex, "inloop").element.checked = false;
		}
		parent.buttonStruct.applyButton.disabled = !parent.btnRightArr.applybtn.right;
	}

	function rowSelectHandler(param) {
		if (param != null && param.length > 0) {
			var rowid = param;
			var objname = st.getCellCurrentValue(rowid, "interface",
					"interface");
			var attrid = st.getCellCurrentValue(rowid, "attrid", "attrid");
			var inloop = st.getCellShow(rowid, "inloop").element.checked;
			var outloop = st.getCellShow(rowid, "outloop").element.checked;
			refreshGraph(objname.substring(0, objname.lastIndexOf('(')),
					attrid, inloop, outloop);
		} else {
			refreshStr($("ifportname"), 'IF');
			refreshStr($("rfportname"), 'RF');
			$('ifimg').src = emptyIcon;
			$('rfimg').src = emptyIcon;
		}
	}

	function refreshStr(element, str) {
		if (element == null) {
			return;
		}
		element.innerHTML = '<B>' + str + '</B>';
	}

	function refreshGraph(boardname, attrid, inloop, outloop) {
		if ('W32PORT_ATTR_PORTLOOPBACK' == attrid) {
			refreshStr($("ifportname"), boardname);
			refreshStr($("rfportname"), 'RF');
			if (inloop) {
				$('ifimg').src = ckwip;
			} else if (outloop) {
				$('ifimg').src = ctwop;
			} else {
				$('ifimg').src = emptyIcon;
			}
		} else if ('W32BRD_ATTR_RFLOOPBACK' == attrid) {
			refreshStr($("rfportname"), boardname);
			refreshStr($("ifportname"), 'IF');
			if (inloop) {
				$('rfimg').src = ckwip;
			} else if (outloop) {
				$('rfimg').src = ctwop;
			} else {
				$('rfimg').src = emptyIcon;
			}
		}
	}

	/**
	 *     
	 */
	this.createBasicParamIF1Plus1ChangeEvent = function(evtType) {
		var event = new BasicParamIF1Plus1ChangeEvent();
		return event;
	}

}

/**
 *                  
 */
BasicParamModule.prototype.clearBasicParamFieldBgColor = function() {
	for ( var i = 0, len = st.getDataRowLength(); i < len; i++) {
		if (!st.getModify(i)) {
			continue;
		}
		st.setCellModify(i, "inloop", false);
		st.setCellModify(i, "outloop", false);
		st.getCell(i, "inloop").element.style.backgroundColor = "#FFFFFF";
		st.getCell(i, "outloop").element.style.backgroundColor = "#FFFFFF";
	}
}

/**
 *                      
 */
function BasicParamIF1Plus1ChangeEvent() {
	var _this = this;

	this.neid = "-1";

	this.getNeId = function() {
		return _this.neid;
	}
}
