

var SENDPOWER = "TSL:";
var RECEIVEPOWER = "RSL:";
var MSE = "MSE:";

var INVALID_VALUE = "-1";

var INVALID_ALARM = "0";

var PhyBoardColor = "#64DC8C";
var LogicBoardColor = "#B4BEFF";

var PHY_BOARD = "1";

var obj = getNeProperty(self);
var neid = obj["neid"];

var ifoduboardgroup = new IFODUBoardGroupList(neid);

var checkBoxList = [];
/**
 *                
 *                       
 */
var hasQueryTaskFlag = false;
/**
 *                 
 */
var isIniBoardList = false;

var get_odu_power = 999995;

var btnRightArr = new Object();

function init()
{
    initTitle();
	/**
	 *   
	 */
	initRights();
    /**
     *              
     */
    initIFODUBoardInfo();
    
    /**
     *     ODU    
     */
    addIFODUBoardPIC();
    /**
     *       
     */
    refreshBoardAlarmLevel();
    /**
     *        
     */
    refreshBoardInfoFromNe(obj["nmUser"]);
    
    EventUtil.addEventHandler(window, "resize", windowOnResizeTableHandle);

	alert(RESOURCE["testInfoAlert"]);
}
function initRights()
{
	btnRightArr.startTestBtn = new BtnRightObj("startTestBtn", TECMDCODE_RADIO_START_FREQSCAN);
	btnRightArr.saveAsBtn = new BtnRightObj("saveAsBtn", TECMDCODE_RADIO_START_FREQSCAN);
	getRightInfo(obj, btnRightArr);
	$("startTestBtn").disabled = !btnRightArr.startTestBtn.right;	
	$("saveAsBtn").disabled = !btnRightArr.saveAsBtn.right;	
}
/**
 *      Onresize  ,           
 */
function windowOnResizeTableHandle()
{
    if (document.body.clientWidth < 900) 
    {
        $("slotTable").style.width = "1500px";
    }
    else 
    {
        $("slotTable").style.width = "100%";
    }
}

function initTitle()
{
    $("startTestBtn").value = RESOURCE["startTest"];
    $("saveAsBtn").value = RESOURCE["saveAs"];
	$("allselcetspan").innerHTML = RESOURCE["selectall"];
    checkBoxList = [];
}

/**
 *                   
 *                
 */
function initIFODUBoardInfo()
{
    isIniBoardList = true;
    ifoduboardgroup.loadBoardInfo(obj["nmUser"], "../../../../../neExlorerServlet");
    isIniBoardList = false;
}
function doAllSelect()
{
	for(var i=0;i<checkBoxList.length;i++)
	{
		checkBoxList[i].checked = $("allselector").checked;
	}
}
/**
 *   IF/ODU    
 */
function addIFODUBoardPIC()
{
    var length = ifoduboardgroup.boardList.length;
    /**
     *             
     */
    for (var i = 0; i < length; i++) 
    {
        var ifoduBoardObj = ifoduboardgroup.boardList[i];
        var board = addboard(ifoduBoardObj.mIfSlotId, ifoduBoardObj.mBoardName, 
					ifoduBoardObj.mIfPhy, ifoduBoardObj.mOduSlotId, ifoduBoardObj.mOduBoardName, ifoduBoardObj.mOduPhy,i);
		$("boardContainer").appendChild(board);
    }
}

function refreshBoardAlarmLevel()
{
    ifoduboardgroup.getBoardAlarmLevel(obj["nmUser"], "../../../../../neExlorerServlet");
    var length = ifoduboardgroup.boardList.length;
    for (var i = 0; i < length; i++) 
    {
        var ifoduBoardObj = ifoduboardgroup.boardList[i];
        setBoardColor($("ifboard" + ifoduBoardObj.mIfSlotId), ifoduBoardObj.mIfBoardAlarmLevel, ifoduBoardObj.mIfPhy);
        setBoardColor($("oduboard" + ifoduBoardObj.mOduSlotId), ifoduBoardObj.mOduBoardAlarmLevel, ifoduBoardObj.mOduPhy);
    }
}

/**
 *   TECMDCODE_FADEMARGIN_QUERY_GROUP          
 *                              
 * @param {Object} nmuser
 */
function refreshBoardInfoFromNe(/*String*/nmuser)
{
    /**
     *                     
     *               
     */
    if ((!hasQueryTaskFlag) && (!isIniBoardList)) 
    {
        hasQueryTaskFlag = true;
        var xmlstr = createQueryBoardFromNeXML();
        var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_IFLOOPBACKTEST_Query_Info + "&nmUser=" + nmuser;
        loadXMLdoc(urlreq, "POST", true, queryBoardInfoFromNeCallback, null, "inputdata=" + xmlstr);
    }
}

function createQueryBoardFromNeXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var length = ifoduboardgroup.boardList.length;
    for (var i = 0; i < length; i++) 
    {
        var row = new tagElement("row-params");
        
        createXMLparam(row, "neid", neid);
        createXMLparam(row, "ifSlotid", ifoduboardgroup.boardList[i].mIfSlotId);
        createXMLparam(row, "oduSlotid", ifoduboardgroup.boardList[i].mOduSlotId);
        
        bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryBoardInfoFromNeCallback(/*DOMXML*/doc,/*Array*/ params)
{
    hasQueryTaskFlag = false;
    var data = EncapsulateData(doc);
    var len = data.getDataRowLength();
    clearAllBoardNeValue();
    for (var i = 0; i < len; i++) 
    {
        var oduSlotid = data.getDataRowParam(i, "oduSlotid");
        var tsl = data.getDataRowParam(i, "W32BRD_ATTR_ACTTRANSMITPOWER");
        var rsl = data.getDataRowParam(i, "W32BRD_ATTR_ACTRECEIVEPOWER");
        
        /**
         *             
         */
        setRTSLInnerHTML(rsl, tsl, oduSlotid);
        
        var ifSlotid = data.getDataRowParam(i, "ifSlotid");
        var mse = data.getDataRowParam(i, "mse");
        /**
         *      MSE
         */
        setMSEInnerHTML(mse, ifSlotid);
    }
}

/**
 *
 * @param {Object} slotid
 * @param {Object} slotname
 * @param {Object} isIFphy
 * @param {Object} oduid
 * @param {Object} oduname
 * @param {Object} isOduphy
 */
function addboard(slotid, slotname, isIFphy, oduid, oduname, isOduphy,index)
{
    /**
     *        checkBox
     */
    var alldiv = document.createElement("div");
    alldiv.className = 'floatStyle slotdivsize';
    var checkboxInput = document.createElement("input");
    checkboxInput.type = "checkbox";
    checkboxInput.id = "checkbox" + slotid;
    checkboxInput.className = 'checkType floatStyle';
    
    var ifAndOduSlot = new Object();
    ifAndOduSlot.ifSlotid = slotid;
    ifAndOduSlot.oduSlotid = oduid;
    checkboxInput.slotinfo = JSON.stringify(ifAndOduSlot);
    
    checkBoxList[checkBoxList.length] = checkboxInput;
    alldiv.appendChild(checkboxInput);
    
    /**
     *       
     */
    var ifdiv = document.createElement("div");
    ifdiv.id = "ifboard" + slotid;
    ifdiv.align = "left";
    if (isIFphy == PHY_BOARD) 
    {
        ifdiv.className = 'Cardphy SelStateOff cardw floatStyle';
    }
    else 
    {
        ifdiv.className = 'Cardlogic SelStateOff cardw floatStyle';
    }
    
    var ifBoardNameSpan = document.createElement("span");
    ifBoardNameSpan.id = "ifboardName" + slotid;
    ifBoardNameSpan.readOnly = true;
    ifBoardNameSpan.innerHTML = slotid + "-" + slotname;
    ifBoardNameSpan.className = 'boardNameSize';
    ifdiv.appendChild(ifBoardNameSpan);
    
    var ifMSESpan = document.createElement("span");
    ifMSESpan.id = "ifboardMSE" + slotid;
    ifMSESpan.readOnly = true;
    ifMSESpan.innerHTML = MSE;
    ifMSESpan.className = 'iftext';
    ifdiv.appendChild(ifMSESpan);
    
    alldiv.appendChild(ifdiv);
    
    
    /**
     *      
     */
    var hrdiv = document.createElement("div");
    hrdiv.className = "floatStyle linediv";
	
    var hr = document.createElement("hr");
    hr.id = "hrLine" + slotid;
    if (isIE) 
    {
        hr.className = "portlineie";
    }
    else 
    {
        hr.className = "portline";
    }

    hr.size = "1";
    hrdiv.appendChild(hr);

	/**
	 *       
	 */
	var successImg = document.createElement("img");
	successImg.id = "successImg"+slotid;
	successImg.src = "../../../../../images/img_icon_item_sucess.png";
	successImg.align = "middle";
	successImg.style.position = "absolute";
	var topPos = 57*index*1.11+58;
	successImg.style.top = topPos+"px";
    successImg.style.left = "600px";
	successImg.style.display = "none";
	hrdiv.appendChild(successImg);	

	/**
	 *       
	 */
	var failedImg = document.createElement("img");
	failedImg.id = "failedImg"+slotid;
	failedImg.src = "../../../../../images/img_icon_item_failed.png";
	failedImg.align = "middle";
	failedImg.style.position = "absolute";
	var topPos = 57*index*1.11+58;
	failedImg.style.top = topPos+"px";
    failedImg.style.left = "600px";
	failedImg.style.display = "none";
	hrdiv.appendChild(failedImg);	
			
    var resultdiv = document.createElement("div");
    resultdiv.className = "resultdivsize";
    
    var bitNumSpan = document.createElement("span");
    bitNumSpan.id = "bitNumSpan" + slotid;
    bitNumSpan.readOnly = true;
    bitNumSpan.className = 'floatStyle prbsltext';
    resultdiv.appendChild(bitNumSpan);
    
    var bitRateSpan = document.createElement("span");
    bitRateSpan.id = "bitRateSpan" + slotid;
    bitRateSpan.readOnly = true;
    bitRateSpan.className = 'floatStyle prbsltext';
    
    
    resultdiv.appendChild(bitRateSpan);
	
    hrdiv.appendChild(resultdiv);

    alldiv.appendChild(hrdiv);
    
    /**
     *   ODU  
     */
    var odudiv = document.createElement("div");
    odudiv.id = "oduboard" + oduid;
    odudiv.align = "left";
    if (isOduphy == PHY_BOARD) 
    {
        odudiv.className = 'floatStyle Cardphy SelStateOff cardw';
    }
    else 
    {
        odudiv.className = 'floatStyle Cardlogic SelStateOff cardw';
    }
    
    var oduBoardNameSpan = document.createElement("span");
    oduBoardNameSpan.id = "oduboardName" + oduid;
    oduBoardNameSpan.readOnly = true;
    oduBoardNameSpan.className = 'boardNameSize oduboardNameSize';
    oduBoardNameSpan.innerHTML = oduid + "-" + oduname;
    
    odudiv.appendChild(oduBoardNameSpan);
    
    var oduRSLSpan = document.createElement("span");
    oduRSLSpan.id = "oduboardRSL" + oduid;
    oduRSLSpan.readOnly = true;
    oduRSLSpan.innerHTML = RECEIVEPOWER;
    oduRSLSpan.className = 'odusltext';
    odudiv.appendChild(oduRSLSpan);
    
    var oduTSLSpan = document.createElement("span");
    oduTSLSpan.id = "oduboardTSL" + oduid;
    oduTSLSpan.readOnly = true;
    oduTSLSpan.innerHTML = SENDPOWER;
    oduTSLSpan.className = 'odusltext';
    odudiv.appendChild(oduTSLSpan);
	alldiv.appendChild(odudiv);
	
    var oduImg = document.createElement("img");
	oduImg.className = 'floatStyle Cardphy SelStateOff oduantew';
	oduImg.id = "oduImg";
	oduImg.src = "../../../../../images/hop_left.jpg";
	alldiv.appendChild(oduImg);
	
    

    return alldiv;
}

function setPrbsTestResult(ifslotid, bitNum, biRate)
{
    $("bitNumSpan" + ifslotid).innerHTML = RESOURCE["bitNumCT"] + bitNum;
    $("bitRateSpan" + ifslotid).innerHTML = RESOURCE["errRateCT"] + biRate;
	/**
	 *    OP201212070006           0              
	 */
    if(bitNum==0)
	{
		$("hrLine" + ifslotid).style.borderColor  = "#00ff00";
		$("successImg" + ifslotid).style.display = "";
		$("failedImg" + ifslotid).style.display = "none";
	}
	else
	{
		$("hrLine" + ifslotid).style.borderColor  = "#ff0000";
		$("successImg" + ifslotid).style.display = "none";
		$("failedImg" + ifslotid).style.display = "";
	}
}

function clearAllBoardTestResult()
{
    var length = ifoduboardgroup.boardList.length;
    for (var i = 0; i < length; i++) 
    {
    	var ifoduBoardObj = ifoduboardgroup.boardList[i];    	
    	$("bitNumSpan" + ifoduBoardObj.mIfSlotId).innerHTML = "";
    	$("bitRateSpan" + ifoduBoardObj.mIfSlotId).innerHTML = "";
    	$("hrLine" + ifoduBoardObj.mIfSlotId).style.borderColor  = "";     
		$("successImg" + ifoduBoardObj.mIfSlotId).style.display = "none";
		$("failedImg" + ifoduBoardObj.mIfSlotId).style.display = "none";
    }
}

/**
 *         
 */
function clearAllBoardNeValue()
{
    var length = ifoduboardgroup.boardList.length;
    for (var i = 0; i < length; i++) 
    {
        var ifoduBoardObj = ifoduboardgroup.boardList[i];
        $("ifboardMSE" + ifoduBoardObj.mIfSlotId).innerHTML = MSE + "/";
        $("oduboardRSL" + ifoduBoardObj.mOduSlotId).innerHTML = RECEIVEPOWER + "/";
        $("oduboardTSL" + ifoduBoardObj.mOduSlotId).innerHTML = SENDPOWER + "/";
    }
}

/**
 *   RSL TSL    
 * @param {Object} rsl
 * @param {Object} tsl
 * @param {Object} oduslotid
 */
function setRTSLInnerHTML(rsl, tsl, oduslotid)
{
    if (rsl != null || tsl != null || oduslotid != null) 
    {
        $("oduboardRSL" + oduslotid).innerHTML = RECEIVEPOWER + rsl;
        $("oduboardTSL" + oduslotid).innerHTML = SENDPOWER + tsl;
    }
}

/**
 *   MSE     
 * @param {Object} mse
 * @param {Object} slotid
 */
function setMSEInnerHTML(mse, slotid)
{
    if (mse != null || slotid != null) 
    {
        $("ifboardMSE" + slotid).innerHTML = MSE + mse;
    }
}

/**
 *        ,      
 *                    
 * @param boardElm
 * @param alarmlevel
 * @param boardstate     ,true=     false=    
 */
function setBoardColor(/*DOMElement*/boardElm,/*String*/ alarmlevel,/*String*/ boardstate)
{

    var color = ALARM_COLOR[alarmlevel];
    if (alarmlevel == INVALID_VALUE || alarmlevel == INVALID_ALARM) 
    {
        if (boardstate == PHY_BOARD) 
        {
            color = PhyBoardColor;
        }
        else 
        {
            color = LogicBoardColor;
        }
    }
    boardElm.style.backgroundColor = color;
}

function doStartPrbsTest()
{
    xshowModalDialog("starttestdlg.html", RESOURCE["startTest"], 380, 100, "../../../../../images/");
}

function saveAs()
{
	saveStrAsFile("../../../../../",RESOURCE["ifLoopbackTest"],buildSaveAsContent());
}

/**
 *             
 */
function buildSaveAsContent()
{
    var fileContent = "";
    
    var length = ifoduboardgroup.boardList.length;
    /**
     *             
     */
    for (var i = 0; i < length; i++) 
    {
        var ifoduBoardObj = ifoduboardgroup.boardList[i];
		var spliteLine = " ----------------------------- ";
        fileContent += ifoduBoardObj.mIfSlotId + "-" + ifoduBoardObj.mBoardName + spliteLine + ifoduBoardObj.mOduSlotId + "-" + ifoduBoardObj.mOduBoardName + String.fromCharCode(13, 10);
        
        if ($("bitNumSpan" + ifoduBoardObj.mIfSlotId).innerHTML != "") 
        {
            fileContent += $("bitNumSpan" + ifoduBoardObj.mIfSlotId).innerHTML + String.fromCharCode(13, 10);
        }
        if ($("bitRateSpan" + ifoduBoardObj.mIfSlotId).innerHTML != "") 
        {
            fileContent += $("bitRateSpan" + ifoduBoardObj.mIfSlotId).innerHTML + String.fromCharCode(13, 10);
        }
        fileContent += $("ifboardMSE" + ifoduBoardObj.mIfSlotId).innerHTML + String.fromCharCode(13, 10);
        fileContent += $("oduboardRSL" + ifoduBoardObj.mOduSlotId).innerHTML + String.fromCharCode(13, 10);
        fileContent += $("oduboardTSL" + ifoduBoardObj.mOduSlotId).innerHTML + String.fromCharCode(13, 10);
    }
    return fileContent;
}
