var currAttr = []; //               legend               
var currColor = [];
var chart = null;
/**
 *         X      
 */
function getXAxisTick(dinterface)
{
	var categories = [];
	var strTmp = "";
	var bFlag = false;
	var startTime = "";
	for (var i = 0, len = dinterface.rows.length; i < len; i++)
	{
		startTime = dinterface.rows[i]["startTime"].value;
		strTmp = dinterface.rows[i]["showTime"].value;
		if (strTmp == "") //         X   
		{
			categories.push("<span></span>");
		}
		else
		{
			categories.push("<span title='" + startTime + "'>" + strTmp + "</span>");
		}
	}
	return categories;
}

/**
 *         Series  
 * @param Array filter       
 */
function getSeriesFromData(filter)
{
	var series = []; //       
	var name = ""; //Json    name  
	var strTemp = "";
	var valueTemp;
	for (var i = 0, size = filter.length; i < size; i++)
	{
		name = filter[i];
		var json; // Json  
		var dataValue = [];
		for (var j = 0, len = dinterface.rows.length; j < len; j++)
		{
			var rowJson = {};
						
			valueTemp = dinterface.rows[j][name].value;
			if (isNaN(valueTemp) || valueTemp == "/")
			{
				valueTemp = null;
				continue;
			}
			else
			{
				valueTemp = parseFloat(valueTemp);
			}
			rowJson.x = j;
			rowJson.y = valueTemp;  // y   
			rowJson.startTime = dinterface.rows[j]["startTime"].value;
			
			dataValue.push(rowJson);
		}
		json = { name: RESOURCE[name], data: dataValue };
		series.push(json);
	}
	return series;
}

/**
 *        
 * @param {Array} power             
 * @param {Array} color            
 */
function displayPowerGrap(/*Array*/power, /*Array*/color)
{
	grap_refresh_flag = false;
	/**
	 *     DTS2013043000365 
	 *                                
	 */
	
	if (currAttr != power) 
	{
		currAttr.clear();
		currColor.clear();
		for (var i = 0, len = power.length; i < len; i++)
		{
			currAttr[currAttr.length] = power[i];
			currColor[currColor.length] = color[i];
		}
	}
	if(PIC_Height < 250)
	{
		PIC_Height = 250;
	}
	var seriesData = getSeriesFromData(power);
	chart = new Highcharts.Chart({
		colors: color,
		
		chart: 
		{
			renderTo: 'container',
			defaultSeriesType: 'line',
			backgroundColor: '#EFEFEF', //     
			spacingTop: -5,
			width:PIC_Width,
			height:PIC_Height
		},
		title: 
		{
			text: null//    
		},
		subtitle: 
		{
			text: null//     
		},
		xAxis:[ 
			{
				categories: xAxisTicks,
				tickWidth: 0, //  X      
				lineWidth: 0, //  X 
				labels: 
				{
					enabled: false //      X    
				}
			},
			{
				opposite: true, //X      
				categories: xAxisTicks, //X       
				linkedTo: 0,//          	
				tickmarkPlacement: 'on', // on or between					
				labels: 
				{
					enabled: true,
					x: -5,
					y: -5,
					
					style:
					{
						color: '#000000',
						fontSize: '11px',
						lineHeight: '14px'
					}
				}
			}],
		yAxis: 
		{
			endOnTick: false,
			tickmarkPlacement: 'on', // on or between
			title: 
			{
				x: -2,
				text: RESOURCE['txtxPower'],
				style: {
					color: '#000000',
					fontSize: '14px',
					lineHeight: '13px'
				}
			},
			labels: {
				style: {
					color: '#000000',
					fontSize: '12px',
					lineHeight: '12px'
				}
			}
		},
		tooltip: 
		{
			enabled: true,
			formatter: function() 
			{
				return this.point.startTime + '<br/>' + this.series.name +': '+ this.y +'dBm';
			}
		},
				
		legend: {
			enabled: true,
			lineHeight: 16,
			layout: 'horizontal',
			align: 'center',
			verticalAlign: 'bottom',
			y: 5,
			borderWidth: 1,
			borderColor: '#909090',
			borderRadius: 3, //     
			style: {
			padding: '5px'
			},
			shadow: false,
			itemStyle: {
				cursor: 'pointer',
				color: '#3E576F',
				fontSize: '12px'
			}
		},
		plotOptions: 
		{
			line: 
			{
				animation: false,
				dataLabels: 
				{
					y: 15,
					enabled: false  //     
				},
				enableMouseTracking: true //     
			}
		},
		series: seriesData,
		exporting: 
		{
			filename: imgName,
			url: '../../../../saveSVGImageAsGrap?neid=' + neid,
			type: 'image/jpeg',
			buttons: 
			{
				exportButton: 
				{
					enabled: false //     
				},
				printButton: 
				{
					enabled: false //     
				}
			}
		}
	});
	
}
