var neobject = getNeProperty(parent);

var neid = neobject.neid;
var nmUser = neobject.nmUser;
var snkslotid = neobject.linkslotid; //       ID

var st1, tc1, st2;

var RX_POWER_ROW = 2;  //                  

var first_click = true; ///     TAB   

var period_15m = 1; //15    
var period_24h = 2; //24    

var DEFAULT_POWER = ["srcMaxRxPower", "srcMinRxPower", "srcRxPower", "snkMaxRxPower", "snkMinRxPower", "snkRxPower"];//                 
var DEFAULT_COLOR = ["#134914", "#3F48CC", "#00A2E8", "#FF7F27", "#ED1C24", "#FF00FF"]; //        
var DEFAULT_ALL_POWER = ["srcMaxRxPower", "srcMinRxPower", "srcRxPower", "srcAvgRxPower", "srcMaxTxPower", "srcMinTxPower",
 "snkMaxRxPower", "snkMinRxPower", "snkRxPower", "snkAvgRxPower", "snkMaxTxPower", "snkMinTxPower"];

var DEFAULT_ALL_ERR = ["srcES", "srcSES", "srcCSES", "srcUAS", "srcBBE", "srcFEC",
                       "snkES", "snkSES", "snkCSES", "snkUAS", "snkBBE", "snkFEC"];

var xAxisTicks; //                 X                       

var grap_refresh_flag = false; //                        
var rep_refresh_flag = false;  //                          
var refresh_flag = false; //                              

var saveColor = []; //   legend.html                 

var one_day = 1; //      1 
var one_week = 7; //      7 

var his_pfm_type = "2"; //              

var srcNeName; //       
var snkNeName; //       
var srcNeNameNoId;
var snkNeNameNoId;

var dinterface = null; //             

var DISPLAY_GRAP = 1; //       
var DISPLAY_REPORT = 2; //       
var DISPLAY_POWER = 1; //       
var DISPLAY_ERROR = 2; //       

var displayMode = 1; //        or         
var displayType = 1; //        or         

var tc2_fix; //                

var PIC_Height = 200; //        
var PIC_Width = 500; //        

var imgName = null; //                    

var tabSelectFlag = false; //   tab    


var historyDataMap = null;
var timekeySet = [];
var powerData = null;

var nearHisErrorObj = null;
var userName = ""; //          

function init()
{
	initPageValue(); //        
	initTime(one_day); //      
	initTopTable();
	EventUtil.addEventHandler(window, "unload", pictureUnload);
	EventUtil.addEventHandler(window, "resize", pictureResize);
}

function pictureUnload()
{
	if (typeof(chart) != "undefined" && chart != null)
	{
		chart = null;
	}
	
	if (typeof(errorChart) != "undefined" && errorChart != null)
	{
		errorChart = null;
	}
}

function pictureResize()
{
	if(st2 == null)
	{
		return;
	}
	var height = getComponetHeight($("divTotal"), 300);
	st2.setBodyHeight(height + "px");
	$("container").style.height = height + "px";
	$("container1").style.height = height + "px";
}

function initTopTable()
{
	st1 = new SortTable();
	tc1 = window.tableconf[0];
    st1.setImage("../../../../images/");  
    createTableHead(st1, tc1);
    st1.setBodyHeight(60);
    $("autoacross").appendChild(st1.getTable());
}

function initFixData()
{
	PIC_Height = getComponetHeight($("divTotal"), 300);
	PIC_Width = document.body.clientWidth - 40;
	tc2_fix = window.tableconf[1];
    
	srcNeName = parent.nearneName;
	snkNeName = parent.farneName;
	

	if (srcNeName == "null" || srcNeName == undefined)
	{
		srcNeName = "";
		srcNeNameNoId = "null";
	}
	else
	{
		srcNeNameNoId = getNeName(srcNeName.substring(0, srcNeName.indexOf('/')));
	}
	
	if (snkNeName == "null" || snkNeName == undefined)
	{
		snkNeName = "";
		snkNeNameNoId = "null";
	}
	else
	{
		snkNeNameNoId = getNeName(snkNeName.substring(0, snkNeName.indexOf('/')));
	}

}

/**
 *                            
 * @param {Array} filterAttr
 */
function initPowerTable(/*Array*/filterAttr)
{
	if (null != st2)
	{
		if (st2.head.childNodes[0].childNodes.length > 1) 
		{
			st2.head.childNodes[0].removeChild(st2.head.childNodes[0].childNodes[0]);
			st2.head.childNodes[0].removeChild(st2.head.childNodes[0].childNodes[0]);
		}
		clearSortTable(st2);
	}
	var tabConf = getFilterTableConf(tc2_fix, filterAttr);
	
	st2 = new SortTable();
	st2.setImage("../../../../images/");
	createTableHead(st2, tabConf);
	
	st2.setBodyHeight(PIC_Height + "px");
	$("autoacross1").appendChild(st2.getTable());
	if (dinterface != null && dinterface.getDataRowLength() >= 0)
	{
		createTableBody(st2, tabConf, dinterface, RESOURCE);
	}
}

/**
 *         TableConf       
 * @param {Array} filterAttrList
 */
function getFilterTableConf(/*TableConf*/tableConf, /*Array*/filterAttrList)
{
	if(typeof(filterAttrList)== "undefined" || filterAttrList == null || filterAttrList.length == 0)
	{
		return tableConf;
	}
	var tableConfTemp = new TableConf();
	for (var i = 0, len = tableConf.getColsLength(); i < len; i++)
    {
        if (filterAttrList.contains(tableConf.getColId(i))) 
        {
            continue;
        }
		tableConfTemp.colArray[tableConfTemp.colArray.length] = tableConf.colArray[i];
    }
	return tableConfTemp;
}
/**
 *           TD
 */
function getAppendTableTD(/*int*/width,/*string*/htmlvalue,/*int*/colspan)
{
	td = document.createElement("td");
	td.className = "hdr";
	td.innerHTML = htmlvalue;
	td.width = width;
	if(typeof(colspan) != "undefined")
	{
		td.colSpan = colspan;
	}
	return 	td;
}

function getAppendTableBlankTD(/*int*/width,/*int*/colspan)
{
	td = document.createElement("td");
	td.className = "hdr";
	td.innerHTML = "&nbsp;";
	td.width = width;
	td.style.height = "1px";
	td.style.lineHeight = "1px";
	td.style.fontSize = "1px";
	if(typeof(colspan) != "undefined")
	{
		td.colSpan = colspan;
	}
	return 	td;
}

function tabSelectHandler()
{
	tabSelectFlag = true;
	if (first_click) //             
	{
		initFixData();
		queryHistroyPFM();
	}
}

function queryHistroyPFM()
{
	setButtonStatus(true);
	var begintime = $("begintime").value;
    var endtime = $("endtime").value;
	if (getTimeFromString(begintime) >= getTimeFromString(endtime))
	{
		alert(RESOURCE['compareTime']);
		setButtonStatus(false);
        return;
	}
	
	imgName = timeToName(begintime) + "_" + timeToName(endtime); //     
	LoadingProcess.showWaitStatus("../../../../images/");
	var xmlnearstr = createQueryNearPFMXML();
	var urlreq = getRootPath(neid) + "/neExlorerServlet?sfid=" + TECMDCODE_QUERY_HISTORY_LINKPFM + "&nmUser=" + nmUser;
	loadXMLdoc(urlreq, "POST", true, queryNearHistroyPFMCallback, null, "inputdata=" + xmlnearstr);
}

function queryFarHistoryPFM()
{
	if(parent.farNeId != "null")
	{
		var xmlfarstr = createQueryFarPFMXML();
		var urlreq = getRootPath(parent.farNeId) + "/neExlorerServlet?sfid=" + TECMDCODE_QUERY_HISTORY_LINKPFM + "&nmUser=" + nmUser;
		loadXMLdoc(urlreq, "POST", true, queryFarHistroyPFMCallback, null, "inputdata=" + xmlfarstr);
	}else{
		LoadingProcess.removeWaitStatus();
		nearHisErrorObj = null;
		drawPlot();
		setButtonStatus(false);
	}	
}

function drawPlot()
{
	var st1data = convertPowData(powerData);	
	dinterface = convertHistoryData(timekeySet, historyDataMap);
	historyDataMap = null;
	timekeySet.length = 0;
	
	st1.clearTableData();
	createTableBody(st1, tc1, st1data, RESOURCE);
	if (st1.getDataRowLength() == 0)
	{
		setButtonStatus(false);
		$("saveAsGrapBtn").disabled = true;
		return;
	}
	xAxisTicks = getXAxisTick(dinterface);
	if (displayMode == DISPLAY_GRAP)
	{
		if (displayType == DISPLAY_POWER)//    
		{
			if (first_click)
			{
				displayPowerGrap(DEFAULT_POWER, DEFAULT_COLOR);
				first_click = false;
			}
			else
			{
				displayPowerGrap(currAttr, currColor);
			}
			refresh_flag = true; //             
		}
		else
		{
			displayErrorGrap();
			grap_refresh_flag = true; //   
		}
		rep_refresh_flag = true; //                        true            
	}
	else
	{
		displayPFMTable();
		grap_refresh_flag = true;  //                          true          
		refresh_flag = true; //       
	}
}

function createQueryNearPFMXML()
{
	var radioObj = document.getElementsByName("counterType");
    var period = 1;
    for (var i = 0; i < radioObj.length; i++) 
    {
        if (radioObj[i].checked) 
        {
            period = radioObj[i].value;
        }
    }
	 
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","ifsoltID");
    param.setAttribute("value",snkslotid);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","oduSoltID");
    param.setAttribute("value",parent.nearODUSoltId);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","period");
    param.setAttribute("value",period);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","beginTime");
    param.setAttribute("value",$("begintime").value);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","endTime");
    param.setAttribute("value",$("endtime").value);
    row.appendChild(param);    
    param = new tagElement("param");
	param.setAttribute("name","isFar");
    param.setAttribute("value","false");
    row.appendChild(param);
	
	bussiness.appendChild(row);
	
	di.getRoot().appendChild(bussiness);
    return di.toString();
}



function createQueryFarPFMXML()
{
	var radioObj = document.getElementsByName("counterType");
    var period = 1;
    for (var i = 0; i < radioObj.length; i++) 
    {
        if (radioObj[i].checked) 
        {
            period = radioObj[i].value;
        }
    }
	 
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");	
	row = new tagElement("row-params");
	param = new tagElement("param");
	param.setAttribute("name","neid");
    param.setAttribute("value",parent.farNeId);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","ifsoltID");
    param.setAttribute("value",parent.farIFSoltId);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","oduSoltID");
    param.setAttribute("value",parent.farODUSoltId);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","period");
    param.setAttribute("value",period);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","beginTime");
    param.setAttribute("value",$("begintime").value);
    row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name","endTime");
    param.setAttribute("value",$("endtime").value);
    row.appendChild(param);    
    param = new tagElement("param");
	param.setAttribute("name","isFar");
    param.setAttribute("value","true");
    row.appendChild(param);

    param = new tagElement("param");
	param.setAttribute("name","nearslotid");
    param.setAttribute("value",snkslotid);
    row.appendChild(param); 
    
    param = new tagElement("param");
	param.setAttribute("name","nearneid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
	bussiness.appendChild(row);
	
	di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getHistoryData(/*DataInterface */ data, /*Integer*/ index)
{
	var historyData = new Object();
	
    historyData.showTime = data.getDataRowParam(index, "showTime");
    
    historyData.RxPower = data.getDataRowParam(index, "RxPower");
    historyData.AvgRxPower = data.getDataRowParam(index, "AvgRxPower");
    historyData.MaxRxPower = data.getDataRowParam(index, "MaxRxPower");
    historyData.MinRxPower = data.getDataRowParam(index, "MinRxPower");    
    
    historyData.MaxTxPower = data.getDataRowParam(index, "MaxTxPower");
    historyData.MinTxPower = data.getDataRowParam(index, "MinTxPower");
    
    historyData.ES = data.getDataRowParam(index, "ES");
    historyData.SES = data.getDataRowParam(index, "SES");
    historyData.CSES = data.getDataRowParam(index, "CSES");
    historyData.UAS = data.getDataRowParam(index, "UAS");
    historyData.BBE = data.getDataRowParam(index, "BBE");
    historyData.FEC = data.getDataRowParam(index, "FEC");
    
    return historyData;
}



/**
 *                          
 * @param {Object} doc
 */
function queryNearHistroyPFMCallback(doc)
{
	powerData = null;
	historyDataMap = null;
	powerData = new Object();
	historyDataMap = new Object();
	
	var data = EncapsulateData(doc);	
	
	if(0 != data.getSErrorCode()) 
	{
		nearHisErrorObj = data.errObj;
	}

	if (data.getDataRowLength() > 0)
	{
		powerData.NearData = new Object();
		powerData.NearData.neName = data.getDataRowParam(0,"neName");
	    powerData.NearData.maxRxPower = data.getDataRowParam(0,"maxRxPower");
	    powerData.NearData.minRxPower = data.getDataRowParam(0,"minRxPower");  
	    
		for(var i = 1, len = data.getDataRowLength(); i < len; i++)
		{	
			var historyData = new Object();
	        var timeKey = data.getDataRowParam(i,"startTime");
	        timekeySet.push(timeKey);
	        historyData.startTime = timeKey;
	        historyData.NearData = getHistoryData(data, i); 
	        historyDataMap[timeKey] = historyData;	
		}
	}

	queryFarHistoryPFM();
}

/**
 *                          
 * @param {Object} doc
 */
function queryFarHistroyPFMCallback(doc)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);

	if(OPERATION_SUCCESS != data.getSErrorCode()) 
	{
		mergeErrorData(data, nearHisErrorObj);
		nearHisErrorObj = null;
		showErrorDialog(data);
	}
	if (data.getDataRowLength() > 0)
	{	
		powerData.FarData = new Object();
		powerData.FarData.neName = data.getDataRowParam(0,"neName");
		powerData.FarData.maxRxPower = data.getDataRowParam(0,"maxRxPower");
		powerData.FarData.minRxPower = data.getDataRowParam(0,"minRxPower");  
	}	
	for(var i = 1, len = data.getDataRowLength(); i < len; i++)
	{
		var historyData = new Object();
        var timeKey = data.getDataRowParam(i,"startTime");
        if(historyDataMap[timeKey] == null || historyDataMap[timeKey] == undefined)        	
        {
        	 timekeySet.push(timeKey);
        	 historyData.startTime = timeKey;
             historyData.FarData = getHistoryData(data, i); 
             historyDataMap[timeKey] = historyData;   
        }
        else
        {
        	historyDataMap[timeKey].FarData = getHistoryData(data, i); 
        }  
	}	
	
	drawPlot();
	setButtonStatus(false);
}

/**
 *                         
 * @param time
 */
function timeToName(/*String*/time)
{
	var temp;
	var rtn = "";
	for (var i = 0, len = time.length; i < len; i++)
	{
		temp = time.charAt(i);
		if (isNaN(temp) || temp == " ")
		{
			continue;
		}
		rtn += temp;
	}
	return rtn;
}


function displayPFMTable()
{
	initPowerTable(getFilterPFMEvent());
	var srcNum = 6;
	var snkNum = 6;
	for (var i = 0, len = currAttr.length; i < len; i++)
	{
		if (currAttr[i].indexOf("src") != -1)
		{
			srcNum ++;
		}
		else
		{
			snkNum ++;
		}
	}
	apppendTableHead(srcNum, snkNum, srcNeName, snkNeName); //    
	
	rep_refresh_flag = false; //                 false       
}

function getFilterPFMEvent()
{
	var filterPFMEvent = [];
	for (var i = 0, len = DEFAULT_ALL_POWER.length; i < len; i++)
	{
		if (currAttr.contains(DEFAULT_ALL_POWER[i]))
		{
			continue;
		}
		filterPFMEvent[filterPFMEvent.length] = DEFAULT_ALL_POWER[i];
	}
	return filterPFMEvent;
}

/**
 *                  
 *         
 */
function apppendTableHead(/*int*/srcColspan,/*int*/snkColspan,/*string*/srcColName,/*string*/snkColName)
{
	var srcWidth = 0;
	var snkWidth = 0;
	var firstWidth = st2.head.childNodes[0].childNodes[0].childNodes[0].width;
	var td;
	var tempWidth;
	var tr = document.createElement("tr");
	tr.appendChild(getAppendTableBlankTD(firstWidth));
	for(var i = 1;i <= srcColspan;i++)
	{
		tempWidth = st2.head.childNodes[0].childNodes[0].childNodes[i].width;
		srcWidth += tempWidth;
		tr.appendChild(getAppendTableBlankTD(tempWidth));
	}
	for(var i =  srcColspan + 1;i <= srcColspan + snkColspan;i++)
	{
		tempWidth = st2.head.childNodes[0].childNodes[0].childNodes[i].width;
		snkWidth += tempWidth;
		tr.appendChild(getAppendTableBlankTD(tempWidth));
	}
	st2.head.childNodes[0].insertBefore(tr, st2.head.childNodes[0].childNodes[0]);
	
	tr = document.createElement("tr");
	tr.appendChild(getAppendTableBlankTD(firstWidth));
	
	tr.appendChild(getAppendTableTD(srcWidth,srcColName,srcColspan));
	tr.appendChild(getAppendTableTD(snkWidth,snkColName,snkColspan));

	st2.head.childNodes[0].insertBefore(tr, st2.head.childNodes[0].childNodes[1]);
	if(isIE)
	{
		st2.head.childNodes[0].childNodes[0].style.display = "none";
	}
	else
	{
		st2.head.childNodes[0].childNodes[0].style.height = "1px";
		st2.head.childNodes[0].childNodes[0].style.lineHeight = "1px";
		st2.head.childNodes[0].childNodes[0].style.fontSize = "1px";
		st2.head.childNodes[0].childNodes[0].style.visibility = "hidden";
	}
}

function changeDisplay(/*int*/mode)
{
	displayMode = mode; //            
	if(mode == DISPLAY_GRAP)
	{
		setDisplay("autoacross1", "none");
		setDisplay("autoacross2", "");
		if (displayType == DISPLAY_POWER) 
		{
			setDisplay("container", "");
			setDisplay("container1", "none");
			if (grap_refresh_flag || tabSelectFlag) //           
			{
				displayPowerGrap(currAttr, currColor);
				tabSelectFlag = false;
			}
		}
		if (displayType == DISPLAY_ERROR)
		{
			setDisplay("container", "none");
			setDisplay("container1", "");
			if (refresh_flag)
			{
				displayErrorGrap();
			}
		}
	}
	else
	{
		setDisplay("autoacross1", "");
		setDisplay("autoacross2", "none");
		if (rep_refresh_flag)
		{
			displayPFMTable();
		}
	}
}

function refresh()
{
	queryHistroyPFM();
}

function setButtonStatus(/*boolean*/flag)
{
	var pageButton = ["period1", "period2", "grapMode", "repMode", "saveAsGrapBtn", "refreshBtn"];
	for (var i = 0, len = pageButton.length; i < len; i++)
	{
		$(pageButton[i]).disabled = flag;
	}
	if (displayMode == DISPLAY_GRAP)
	{
		$("powerType").disabled = flag;
		$("errorType").disabled = flag;
		$("openLegend").disabled = flag;
	}
}

function save()
{
	if (dinterface.getDataRowLength() == 0)
	{
		alert(RESOURCE["nodata"]);
		return;
	}
	setButtonStatus(true);
	if (displayMode == DISPLAY_REPORT)
	{
		var saveXml = createSaveXml();
		var params = {neid: neid, pfm_type: his_pfm_type, srcNeName: srcNeName, snkNeName: snkNeName, currAttr: currAttr, inputdata: saveXml};
		post(getRootPath(neid) + "/saveCurrentPFM", params);
	}
	else  //      
	{
		if (displayType == DISPLAY_POWER)
		{
			chart.exportChart(chart.options);
		}
		else
		{
			errorChart.exportChart(errorChart.options);
		}
	}
	setButtonStatus(false);
}

function post(url, params)
{
	var temp = document.createElement("form");
	temp.action = url;
	temp.method = "post";
	temp.style.display = "none";
	for (var x in params)
	{
		var opt = document.createElement("textarea");
		opt.name = x;
		opt.value = params[x];
		temp.appendChild(opt);
	}
	document.body.appendChild(temp);
	temp.submit();
}

function createSaveXml()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
	for(var rowIndex = 0, len = st2.getDataRowLength(); rowIndex < len; rowIndex++)
	{	
		var row = new tagElement("row-params");		
		var param = new tagElement("param");    
		var startTime = st2.getCellStoreValue(rowIndex, "startTime", "startTime");
		param.setAttribute("name","startTime");
	    param.setAttribute("value",startTime);
	    row.appendChild(param);
	    var powerindex = 0;
	    var errindex = 0;
		for (var i = 0, size = currAttr.length; i < size; i++)
		{
			if (-1 != currAttr[i].indexOf("src"))
			{
				powerindex ++;
				param = new tagElement("param");
				param.setAttribute("name",currAttr[i]);
			    param.setAttribute("value",st2.getCellStoreValue(rowIndex, currAttr[i], currAttr[i]));
			    row.appendChild(param);
			}
		}		    
		
		for (var j = 0, count = DEFAULT_ALL_ERR.length; j < count; j++)
		{
			if (-1 != DEFAULT_ALL_ERR[j].indexOf("src"))
			{
				errindex ++;
				param = new tagElement("param");
				param.setAttribute("name",DEFAULT_ALL_ERR[j]);
			    param.setAttribute("value",st2.getCellStoreValue(rowIndex, DEFAULT_ALL_ERR[j], DEFAULT_ALL_ERR[j]));
			    row.appendChild(param);
			}
		}		
		
		for (var i = powerindex, size = currAttr.length; i < size; i++)
		{
			if (-1 != currAttr[i].indexOf("snk"))
			{
				param = new tagElement("param");
				param.setAttribute("name",currAttr[i]);
			    param.setAttribute("value",st2.getCellStoreValue(rowIndex, currAttr[i], currAttr[i]));
			    row.appendChild(param);
			}
		}		    
		
		for (var j = errindex, count = DEFAULT_ALL_ERR.length; j < count; j++)
		{
			if (-1 != DEFAULT_ALL_ERR[j].indexOf("snk"))
			{
				param = new tagElement("param");
				param.setAttribute("name",DEFAULT_ALL_ERR[j]);
			    param.setAttribute("value",st2.getCellStoreValue(rowIndex, DEFAULT_ALL_ERR[j], DEFAULT_ALL_ERR[j]));
			    row.appendChild(param);
			}
		}
	    bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
    return di.toString();
}


function openLegend()
{
	xshowModalDialog("legend.html", RESOURCE["openLegend"], 500, 375, "../../../../images/", "no");
}

function changepfmType(/*int*/pfmType)
{
	displayType = pfmType; //     
	if(pfmType == DISPLAY_POWER)
	{
		setDisplay("openLegend", "");
		setDisplay("container", "");
		setDisplay("container1", "none");
		if (grap_refresh_flag)
		{
			displayPowerGrap(currAttr, currColor);
		}
	}
	else
	{
		setDisplay("openLegend", "none");
		setDisplay("container", "none");
		setDisplay("container1", "");
		if (refresh_flag)
		{
			displayErrorGrap();
		}
	}
}

function getPeriod(/*int*/period)
{
	if (period == period_15m)
	{
		initTime(one_day);
	}
	if (period == period_24h)
	{
		initTime(one_week);
	}
}
function initTime(/*int*/days)
{
     var fromTime = new Date();
     fromTime.setDate(fromTime.getDate() - days);
     var toTime = new Date();
     toTime.setDate(toTime.getDate());
     $("begintime").value = createTime(fromTime);
     $("endtime").value = createTime(toTime);
}

function initPageValue()
{
	$('counterTypeT').innerHTML = RESOURCE['counterType'];
	$('type1').innerHTML = RESOURCE['type1'];
    $('type2').innerHTML = RESOURCE['type2'];
	$('periedtime').innerHTML = RESOURCE['periedtime'];
	$('time_from').innerHTML = RESOURCE['time_from'];
	$('time_to').innerHTML = RESOURCE['time_to'];
	$('displayFormatT').innerHTML = RESOURCE['displayFormatT'];
	$('displayFormat1').innerHTML = RESOURCE['displayFormat1'];
	$('displayFormat2').innerHTML = RESOURCE['displayFormat2'];
	$('pfmType1').innerHTML = RESOURCE['pfmType1'];
	$('pfmType2').innerHTML = RESOURCE['pfmType2'];
	
	$("openLegend").value = RESOURCE["openLegend"];
	$("saveAsGrapBtn").value = RESOURCE["saveAsFileBtn"];
	$("refreshBtn").value = RESOURCE["refreshBtn"];
}
function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", data.getError(), errArr); 
}
function setDisplay(/*string*/id, /*string*/displayType)
{
	$(id).style.display = displayType;
}

function getNeName(/*String*/neName)
{
	var len = getStrLength(neName);
	var NameTemp = '';
	if (len > 20)
	{
		NameTemp = neName.substring(0, 17) + "...";
	}
	else
	{
		var avg = parseInt((20 - len)/2);
		var temp = '';
		for (var i = 0; i < avg; i++)
		{
			temp += " ";
		}
		neName = temp + neName;
		
		for (var i = 0, len = (20 - len - avg); i < len; i++)
		{
			neName += " ";
		}
		NameTemp = neName;
	}
	return NameTemp;
	
}

/**
 *            2   
 * @param {Object} str
 */
function getStrLength(str) 
{   
   return str.replace(/[^\x00-\xff]/g, 'xx').length;   
}  
