var errorChart = null; //      

var srcPowerAttr = ['srcMaxRxPower', 'srcMinRxPower', 'srcAvgRxPower']; //                
var snkPowerAttr = ['snkMaxRxPower', 'snkMinRxPower', 'snkAvgRxPower']; //                

var errorAttr = ['srcES' , 'srcSES', 'srcCSES', 'srcUAS', 'srcBBE', 'srcFEC', '0', 'snkES', 'snkSES', 'snkCSES', 'snkUAS', 'snkBBE', 'snkFEC']; // 12   
var grapAttr = [-6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6]; // 12           Y   

var max = RESOURCE['errorMaxRxPower'];
var min = RESOURCE['errorMinRxPower'];
var avg = RESOURCE['errorAvgRxPower'];

var PICOFFSETWIDTH = 80; //     Y      
var DEFAULTRADIUS = 1.6; //            
var MIN_HEIGHT = 300; //         

var PIC_Radius = DEFAULTRADIUS; //      
var TOTAL_Y_INTERVAL = 13;  // Y   13    

var tickInterval; // Y         

/**
 *         X                    
 */
function getErrorXAxisTick()
{
	PIC_Radius = ((PIC_Width - PICOFFSETWIDTH)/dinterface.rows.length)/9;

	var categories = []; // X     
	var startTime = "";
	var showTime = "";
	for (var i = 0, len = dinterface.rows.length; i < len; i++)
	{
		startTime = dinterface.rows[i]["startTime"].value;
		showTime = dinterface.rows[i]["showTime"].value;
		
		if (showTime == "") //         X   
		{
			categories.push("<span></span>");
		}
		else
		{
			categories.push("<span title='" + startTime + "'>" + showTime + "</span>");
		}
	}
	return categories;
}


/**
 *                         
 */
function getErrorSeriesFromData()
{
	var series = []; //       
	var name = '0'; //Json    name  
	var nameTemp;
	
	var error, maxRx, minRx, avgRx;
	var row;
	
	var json = {}; // Json  
	for (var i = 0, len = errorAttr.length; i < len; i++)
	{
		name = errorAttr[i];
		var dataValue = [];
		
		for (var j = 0, len1 = dinterface.rows.length; j < len1; j++)
		{
			var rowJson = {};
			rowJson.y = grapAttr[i];  // y   
			
			row = dinterface.rows[j];
			
			if (name == '0' || row[name].value == '0' ||  row[name].value == '0.0') //    0        
			{
				rowJson.data = null;
				dataValue.push(rowJson);
				continue;
			}
			error = row[name].value;
			if (name.indexOf('src') != -1)
			{
				maxRx = row[srcPowerAttr[0]].value;
				minRx = row[srcPowerAttr[1]].value;
				avgRx = row[srcPowerAttr[2]].value;
			}
			else
			{
				maxRx = row[snkPowerAttr[0]].value;
				minRx = row[snkPowerAttr[1]].value;
				avgRx = row[snkPowerAttr[2]].value;
			}
			
			rowJson.data = error; //    
			rowJson.max = maxRx;  //       
			rowJson.min = minRx;  //       
			rowJson.avg = avgRx;  //       
			rowJson.startTime = row["startTime"].value;
			dataValue.push(rowJson);
		}
		name = name == '0' ? name : RESOURCE[name.substring(3).toLowerCase()]; //     
		
		json = { name: name, data: dataValue };
		series.push(json);
	}
	
	return series;
}

/**
 *        
 */
function displayErrorGrap()
{
	refresh_flag = false; //               
	
	var seriesData = getErrorSeriesFromData();
	
	var categories = getErrorXAxisTick();
	if (errorChart != null)
	{
		errorChart = null;
	}
	if(PIC_Height < MIN_HEIGHT)
	{
		PIC_Height = MIN_HEIGHT;
	}
	tickInterval = (PIC_Height - 70)/TOTAL_Y_INTERVAL;
	
	errorChart = new Highcharts.Chart({
		colors: ['red', 'red', 'red', 'red', 'red', 'red', 'red', 'red', 'red'],
		symbols: ['rectangle', 'rectangle', 'rectangle', 'rectangle', 'rectangle'],
		chart: 
		{
			renderTo: 'container1',
			defaultSeriesType: 'line',
			spacingTop: -15,
			width:PIC_Width,
			height:PIC_Height
		},
		title: null,
		subtitle: null,
		
		xAxis: [
		{
			categories: categories,
			tickWidth: 0,
			lineWidth: 0,
			startOnTick: false,
			labels: 
			{
				enabled: false
			}
		}, {
			opposite: true, //     
			categories: categories,
			tickWidth: 1,
			linkedTo: 0,
			tickLength: 12,
			tickPosition: 'outside',
			startOnTick: false,
			labels: 
			{
				enabled: true,
				align: 'center',
				x: -13,
				y: -20,
				rotation: 90,
				style: {
					color: '#000000',
					fontSize: '11px',
					lineHeight: '14px'
				}
			}
		}],
		yAxis: {
			title: 
			{
				y: 0,
				x: 0,
				text:"<pre>" + snkNeNameNoId + srcNeNameNoId + "</pre>"
			},
			gridLineWidth: 1,
			gridLineColor: '#FFFFFF',
			startOfWeek: 0,
			startOnTick: true,
			endOnTick: false,
			tickColor: '#000000',
			tickLength: 5,
			tickmarkPlacement: 'between', // on or between
			tickPixelInterval: tickInterval,
			tickPosition: 'inside',
			tickWidth: 0,
			showLastLabel: false,
			reversed: true,
			plotLines: [{
				value: 0,
				width: 1,
				color: '#808080'
			}],
			labels: {
				enabled: true,
				
				align: 'right',
				x: -10,
				y: 0,
				
				formatter: function()
				{
					var temp = parseInt(this.value);
					var strTemp = "";
					switch (temp) 
					{
						case -6: 
						case 1: 
							strTemp = 'ES';break;
						case -5:
						case 2: 
							strTemp = 'SES';break;
						case -4:
						case 3: 
							strTemp = 'CSES';break;
						case -3: 
						case 4: 
							strTemp = 'UAS';break;
						case -2:
						case 5:
							 strTemp = 'BBE';break;
						case -1:
						case 6: 
							strTemp = 'FEC';break;
						default:
							strTemp = '';
					}
					return strTemp;
				},
				style: {
					color: '#000000',
					fontSize: '14px',
					lineHeight: '14px'
				}
			}
		},
		tooltip: {
			enabled: true,
			formatter: function()
			{
				var point = this.point;
				
				var display = point.startTime + "<br/>" + this.series.name + ':' + point.data + '<br/>' + max + point.max + 'dBm<br/>' + 
					min +  point.min + 'dBm<br/>' + avg +  point.avg + 'dBm';
				return display;
			}
		},
		
		legend: {
			enabled: false
		},
		
		plotOptions: {
			line: {
				allowPointSelect: false,
				lineWidth: 0, //     
				marker: {
					enabled: true,
					lineWidth: 2,
					radius: PIC_Radius,
					lineColor: '#FFFFFF',
					states: { // states for a single point
						hover: {
							radius: PIC_Radius,
							fillColor: '#880015',
							lineColor: 'black',
							lineWidth: 1
						}
						
					}
				},
				dataLabels: {
					enabled: false //     
				},
				enableMouseTracking: true //     
			}
		},
		exporting: 
		{
			filename: imgName,
			url: '../../../../saveSVGImageAsGrap?neid=' + neid,
			type: 'image/jpeg',
			buttons: 
			{
				exportButton: 
				{
					enabled: false //     
				},
				printButton: 
				{
					enabled: false //     
				}
			}
		},
		series: seriesData
	});
}
