  
/**
*       
*/
function convertHistoryData(timeKeySet, historyDataMap)
{ 	
	var dinterface = new DataInterface();	
	
	timeKeySet.sort();
    for(var i = 0; i < timeKeySet.length; i++)
    {    
       var timekey = timeKeySet[i];
    	var historyData = historyDataMap[timekey];
    	if(historyData == null)
    	{
    	    continue;
    	}   
    	
    	var obj = new Object();		
    	
		var ptag = new ParamTag();
		ptag.value = historyData.startTime;    
    	obj["startTime"] =ptag;
    	
    	if(historyData.NearData != null && historyData.NearData != undefined)
    	{ 
    		ptag = new ParamTag();		
        	ptag.value = historyData.NearData.showTime;    
        	obj["showTime"] = ptag; 
    	}
    	else
    	{
    		historyData.NearData = new Object();
    		setHistoryDataDefault(historyData.NearData, "/", "0");
    	}
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.MaxRxPower;    
        	obj["srcMaxRxPower"] = ptag;       	
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.MinRxPower;    
        	obj["srcMinRxPower"] = ptag;
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.RxPower;    
        	obj["srcRxPower"] = ptag;
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.AvgRxPower;    
        	obj["srcAvgRxPower"] = ptag;       	
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.MaxTxPower;    
        	obj["srcMaxTxPower"] = ptag;
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.MinTxPower;    
        	obj["srcMinTxPower"] = ptag;
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.ES;    
        	obj["srcES"] = ptag;
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.SES;    
        	obj["srcSES"] = ptag;
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.CSES;    
        	obj["srcCSES"] = ptag;
        	
        	var ptagshowTime = new ParamTag();
        	ptag.value = historyData.NearData.UAS;    
        	obj["srcUAS"] = ptag;
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.BBE;    
        	obj["srcBBE"] = ptag;
        	
        	ptag = new ParamTag();
        	ptag.value = historyData.NearData.FEC;    
        	obj["srcFEC"] = ptag;
    
    	
    	if(historyData.FarData != null  && historyData.FarData != undefined)
    	{ 
    		ptag = new ParamTag();		
        	ptag.value = historyData.FarData.showTime;    
        	obj["showTime"] = ptag; 
    	}
    	else
		{
    		historyData.FarData = new Object();
    		setHistoryDataDefault(historyData.FarData, "/", "0");
		}
        	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.MaxRxPower;    
    	obj["snkMaxRxPower"] = ptag;       	
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.MinRxPower;    
    	obj["snkMinRxPower"] = ptag;
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.RxPower;    
    	obj["snkRxPower"] = ptag;
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.AvgRxPower;    
    	obj["snkAvgRxPower"] = ptag;       	
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.MaxTxPower;    
    	obj["snkMaxTxPower"] = ptag;
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.MinTxPower;    
    	obj["snkMinTxPower"] = ptag;
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.ES;    
    	obj["snkES"] = ptag;
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.SES;    
    	obj["snkSES"] = ptag;
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.CSES;    
    	obj["snkCSES"] = ptag;
    	
    	var ptagshowTime = new ParamTag();
    	ptag.value = historyData.FarData.UAS;    
    	obj["snkUAS"] = ptag;
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.BBE;    
    	obj["snkBBE"] = ptag;
    	
    	ptag = new ParamTag();
    	ptag.value = historyData.FarData.FEC;    
    	obj["snkFEC"] = ptag;
    	   
        dinterface.rows[dinterface.rows.length] = obj;
    }
    return dinterface;
}


function setHistoryDataDefault(historyData, powerdefaultValue, pfmdefaultValue)
{	
	historyData.MaxRxPower = powerdefaultValue;
	historyData.MinRxPower = powerdefaultValue;
	historyData.RxPower = powerdefaultValue;
	historyData.MaxTxPower = powerdefaultValue;
	historyData.MinTxPower = powerdefaultValue;
	historyData.AvgRxPower = powerdefaultValue;
	    
	historyData.ES = pfmdefaultValue;
	historyData.SES = pfmdefaultValue;
	historyData.CSES = pfmdefaultValue;
	historyData.UAS = pfmdefaultValue;
	historyData.BBE = pfmdefaultValue;
	historyData.FEC = pfmdefaultValue;   
}



/**
*       
*/
function convertPowData(powerData)
{     
	var dinterface = new DataInterface();  	
	
	if(powerData.NearData != null)
	{
		var nearobj = new Object();	
		
		var ptagneName = new ParamTag();		
		ptagneName.value = powerData.NearData.neName;    
		nearobj["neName"] = ptagneName; 
		
		var ptagMaxRxPower = new ParamTag();		
		ptagMaxRxPower.value = powerData.NearData.maxRxPower;    
    	nearobj["maxRxPower"] = ptagMaxRxPower; 
    	
    	var ptagMinRxPower = new ParamTag();		
    	ptagMinRxPower.value = powerData.NearData.minRxPower;    
    	nearobj["minRxPower"] = ptagMinRxPower; 
    	
    	dinterface.rows[dinterface.rows.length] = nearobj;
	}
	
	if(powerData.FarData != null)
	{
		var farobj = new Object();	
		
		var ptagneName = new ParamTag();		
		ptagneName.value = powerData.FarData.neName;    
		farobj["neName"] = ptagneName; 
		
		var ptagMaxRxPower = new ParamTag();		
		ptagMaxRxPower.value = powerData.FarData.maxRxPower;    
		farobj["maxRxPower"] = ptagMaxRxPower; 
    	
    	var ptagMinRxPower = new ParamTag();		
    	ptagMinRxPower.value = powerData.FarData.minRxPower;    
    	farobj["minRxPower"] = ptagMinRxPower; 
    	
    	dinterface.rows[dinterface.rows.length] = farobj;
	}	 
    return dinterface;
}


/**
 *      
 */
function mergeErrorData(baseData, tmpErrObj)
{
	if(tmpErrObj == undefined  ||  tmpErrObj == null)
	{
		return;
	}
	if(baseData.errObj.s_error.code  == undefined  ||  baseData.errObj.s_error.code == null )
	{
		baseData.errObj.s_error.code = tmpErrObj.s_error.code;
		baseData.errObj.s_error.info = tmpErrObj.s_error.info;
	}
	
	for( var i = 0 ; i < tmpErrObj.rowErrors.length; i++ )
	{
		baseData.errObj.rowErrors[baseData.errObj.rowErrors.length] = tmpErrObj.rowErrors[i]; 
	}
	
	tmpErrObj = null;
}
