var rfParamCache = new Object();
rfParamCache["txfreEle"] = new DecoratedElement();
rfParamCache["txfreEle"].bindElement("txfreEle", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["trspaceEle"] = new DecoratedElement();
rfParamCache["trspaceEle"].bindElement("trspaceEle", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["atpcenableEle"] = new DecoratedElement();
rfParamCache["atpcenableEle"].bindElement("atpcenableEle", DECORATED_ELEMENT_TYPE.CHECKBOX);
rfParamCache["atpcUpperThresEle"] = new DecoratedElement();
rfParamCache["atpcUpperThresEle"].bindElement("atpcUpperThresEle", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["atpcLowerThresEle"] = new DecoratedElement();
rfParamCache["atpcLowerThresEle"].bindElement("atpcLowerThresEle", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["sendpwEle"] = new DecoratedElement();
rfParamCache["sendpwEle"].bindElement("sendpwEle", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["repwEle"] = new DecoratedElement();
rfParamCache["repwEle"].bindElement("repwEle", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["odustaEle"] = new DecoratedElement();
rfParamCache["odustaEle"].bindElement("odustaEle", DECORATED_ELEMENT_TYPE.SELECT);
rfParamCache["antennaplEle"] = new DecoratedElement();
rfParamCache["antennaplEle"].bindElement("antennaplEle", DECORATED_ELEMENT_TYPE.SELECT);

rfParamCache["txfreEle2"] = new DecoratedElement();
rfParamCache["txfreEle2"].bindElement("txfreEle2", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["trspaceEle2"] = new DecoratedElement();
rfParamCache["trspaceEle2"].bindElement("trspaceEle2", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["atpcenableEle2"] = new DecoratedElement();
rfParamCache["atpcenableEle2"].bindElement("atpcenableEle2", DECORATED_ELEMENT_TYPE.CHECKBOX);
rfParamCache["atpcUpperThresEle2"] = new DecoratedElement();
rfParamCache["atpcUpperThresEle2"].bindElement("atpcUpperThresEle2", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["atpcLowerThresEle2"] = new DecoratedElement();
rfParamCache["atpcLowerThresEle2"].bindElement("atpcLowerThresEle2", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["sendpwEle2"] = new DecoratedElement();
rfParamCache["sendpwEle2"].bindElement("sendpwEle2", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["repwEle2"] = new DecoratedElement();
rfParamCache["repwEle2"].bindElement("repwEle2", DECORATED_ELEMENT_TYPE.TEXT);
rfParamCache["odustaEle2"] = new DecoratedElement();
rfParamCache["odustaEle2"].bindElement("odustaEle2", DECORATED_ELEMENT_TYPE.SELECT);
rfParamCache["antennaplEle2"] = new DecoratedElement();
rfParamCache["antennaplEle2"].bindElement("antennaplEle2", DECORATED_ELEMENT_TYPE.SELECT);


function RFAttriModule()
{
	var _this = this;
	
	this.isExpend = false;
	/**
	 * 
	 */
	this.rfComponentsOnChangeArray = new Array("txfreEle", 
												"sendpwEle", 
												"repwEle", 
												"odustaEle", 
												"antennaplEle",
												"trspaceEle", 
												"atpcenableEle",
												"atpcUpperThresEle", 
												"atpcLowerThresEle",
												
												"txfreEle2", 
												"sendpwEle2", 
												"repwEle2", 
												"odustaEle2",
												"antennaplEle2",
												"trspaceEle2", 
												"atpcenableEle2",
												"atpcUpperThresEle2",
												"atpcLowerThresEle2"
												);

	/**
	 * 
	 */
	this.rfComponentsAllArray = new Array(		"txfreEle", 
												"trspaceEle",
												"sendpwEle",
												"repwEle",
												"odustaEle",
												"antennaplEle",
												"atpcenableEle",
												"atpcUpperThresEle",
												"atpcLowerThresEle",
												
												"txfreEle2",
												"trspaceEle2",
												"sendpwEle2",
												"repwEle2",
												"odustaEle2",
												"antennaplEle2",
												"atpcenableEle2",
												"atpcUpperThresEle2",
												"atpcLowerThresEle2"
											);

	this.listenerList = new Array();
	
	this.init = function()
	{
		if ($("RFParamField").style.display == "none") 
		{
			_this.isExpend = false;
		}
	}
	/**
	 *          :true   false    
	 */
	this.getExpend = function()
	{
		return $("RFParamField").style.display != "none";
	}
	
	this.setExpend = function(bExpend)
	{
		if(bExpend)
		{
			$("RFParamField").style.display = "";
			$("arrowImg_rf").src = "../../../../images/down.gif";
		}
		else
		{
			$("RFParamField").style.display = "none";
			$("arrowImg_rf").src = "../../../../images/right.gif";
		}
	}
	this.addListener = function(obj)
	{
		_this.listenerList.push(obj);
	}
	
	this.notifyAll = function(event)
	{		
		for( var i = 0; i < _this.listenerList.length; i++ )
		{
			var obj = _this.listenerList[i];
			obj.response(event);
		}
	}
	
	/**
	 * 
	 * @return
	 */
	this.clearAttriField = function()
	{

		rfParamCache["txfreEle"].initAllValue();
		rfParamCache["trspaceEle"].initAllValue();
		rfParamCache["atpcenableEle"].initAllValue();
		rfParamCache["atpcUpperThresEle"].initAllValue();
		rfParamCache["atpcLowerThresEle"].initAllValue();
		rfParamCache["sendpwEle"].initAllValue();
		rfParamCache["repwEle"].initAllValue();
		rfParamCache["odustaEle"].initAllValue();
		rfParamCache["antennaplEle"].initAllValue();
		
		rfParamCache["txfreEle2"].initAllValue();
		rfParamCache["trspaceEle2"].initAllValue();
		rfParamCache["atpcenableEle2"].initAllValue();
		rfParamCache["atpcUpperThresEle2"].initAllValue();
		rfParamCache["atpcLowerThresEle2"].initAllValue();
		rfParamCache["sendpwEle2"].initAllValue();
		rfParamCache["repwEle2"].initAllValue();
		rfParamCache["odustaEle2"].initAllValue();
		rfParamCache["antennaplEle2"].initAllValue();
		
		
		_this.clearAttriFieldBgColor();
	}

	this.queryCallback = function(data)
	{
		var ifF1p1GroupExisted = g_commonData.isRelatedIF1Plus1GroupExist();

		for( var i = 0; i < data.getDataRowLength(); i++ )
		{
			var slotId = data.getDataRowParam(i, "slotid");
			var isIFBoardFlag = g_commonData.isIFBoard(slotId);
			var isODUBoardFlag = g_commonData.isODUBoard(slotId);
			if( isIFBoardFlag == true )
			{
				var isMainColumn = 
					ifF1p1GroupExisted == true && $("protectboardEle").value == slotId ? false : true;
				_this.processRFData_IF(data, i, isMainColumn);
			}
			if( isODUBoardFlag == true )
			{
				var isMainColumn = 
							ifF1p1GroupExisted == true && 
							g_commonData.getRelatedODUSlotId($("protectboardEle").value) == slotId ?
							false : true;
				
				_this.processRFData_ODU(data, i, isMainColumn);
			}
		}
		
		_this.filterUnsupportAttrByNeTypeAndNeversion();
		_this.isShowAntennaPolar();
	}

	/**
	 *              ?
	 * @param data
	 * @param i
	 * @return
	 */
	this.processRFData_IF = function(data, i, isMainColumn)
	{
		var slotId = data.getDataRowParam(i, "slotid");

		var atpcenableVal = data.getDataRowParam(i, "W32PORT_ATTR_ATPCENABLE");
		
		var atpcUpperThresholdVal = data.getDataRowParam(i, "W32PORT_ATTR_ATPCUPPER");
		var atpcLowerThresholdVal = data.getDataRowParam(i, "W32PORT_ATTR_ATPCLOWER");
		
		_this.getRfElement("atpcenableEle", isMainColumn).checked = atpcenableVal == EnableStatus.ENABLED ? true : false;

		_this.getRfElement("atpcUpperThresEle", isMainColumn).value = atpcUpperThresholdVal;
		_this.getRfElement("atpcLowerThresEle", isMainColumn).value = atpcLowerThresholdVal;
		
		var surfix = isMainColumn ? "" : "2";
		rfParamCache["atpcenableEle" + surfix].updateElementValueToCacheValue();
		rfParamCache["atpcUpperThresEle" + surfix].updateElementValueToCacheValue();
		rfParamCache["atpcLowerThresEle" + surfix].updateElementValueToCacheValue();
		var antennaPolarVal = data.getDataRowParam(i, "W32BRD_ATTR_ANTENNA_POLAR_WBID");
		if(antennaPolarVal != null)
		{
			_this.getRfElement("antennaplEle", isMainColumn).value = antennaPolarVal;
			rfParamCache["antennaplEle" + surfix].updateElementValueToCacheValue();
		}
		
		if( isMainColumn )
		{
			if( atpcenableVal == EnableStatus.ENABLED )
			{
				_this.showATPCThresSpan(true);
			}
			else
			{
				_this.showATPCThresSpan(false);
			}
		}
	}

	/**
	 *          ?
	 * @param data
	 * @param i
	 * @return
	 */
	this.processRFData_ODU = function(data, i, isMainColumn)
	{
		var slotId = data.getDataRowParam(i, "slotid");

		var txfreVal = data.getDataRowParam(i, "W32BRD_ATTR_TRANSMITFRE");
		var rxfreVal = data.getDataRowParam(i, "W32BRD_ATTR_ACTTRECEIVEFRE");
		var trspaceVal = data.getDataRowParam(i, "W32BRD_ATTR_TRINTERVAL");
		var sendpwVal = data.getDataRowParam(i, "W32BRD_ATTR_TRANSMITPOWER");
		var repwVal = data.getDataRowParam(i, "W32BRD_ATTR_RECEIVEPOWER");	//power to be received
		var rxpwVal = data.getDataRowParam(i, "W32BRD_ATTR_ACTRECEIVEPOWER");
		var odustaVal = data.getDataRowParam(i, "W32BRD_ATTR_WORKSTATUS");
		var fre_low = data.getDataRowParam(i, "LOWFRE");					//Range of TX Frequency Low
		var fre_high = data.getDataRowParam(i, "W32BRD_ATTR_WORKRANGE");	//Range of TX Frequency High
		var power_low = data.getDataRowParam(i, "LOWPOWER");						//Tx Power Range Low
		var power_high = data.getDataRowParam(i, "W32BRD_ATTR_ACTRANGEOFPOWER");	//Tx Power Range High
		var actualsendpwVal = data.getDataRowParam(i, "W32BRD_ATTR_ACTTRANSMITPOWER");	//Actual TX Power 
		rxfreVal = (rxfreVal && rxfreVal != "")?rxfreVal:VALID_SHOWVAL;
		rxpwVal = (rxpwVal && rxpwVal != "")?rxpwVal:VALID_SHOWVAL;
		actualsendpwVal = (actualsendpwVal && actualsendpwVal != "")?actualsendpwVal:VALID_SHOWVAL;
		
		_this.getRfElement("txfreEle", isMainColumn).value = txfreVal;
		_this.getRfElement("rxfreEle", isMainColumn).value = rxfreVal;
		_this.getRfElement("trspaceEle", isMainColumn).value = trspaceVal;
		_this.getRfElement("sendpwEle", isMainColumn).value = sendpwVal;
		_this.getRfElement("repwEle", isMainColumn).value = repwVal;
		_this.getRfElement("rxpwEle", isMainColumn).value = rxpwVal;
		_this.getRfElement("odustaEle", isMainColumn).value = odustaVal;
		_this.getRfElement("actualsendpwEle", isMainColumn).value = actualsendpwVal;
		_this.getRfElement("odurslspan", isMainColumn).innerText = RECEIVEPOWER_TITLE + " " + rxpwVal;
		_this.getRfElement("odutslspan", isMainColumn).innerText = SENDPOWER_TITLE + " " + actualsendpwVal;
		
		var surfix = isMainColumn == true ? "" : "2";
		rfParamCache["txfreEle" + surfix].updateElementValueToCacheValue();
		rfParamCache["trspaceEle" + surfix].updateElementValueToCacheValue();
		rfParamCache["sendpwEle" + surfix].updateElementValueToCacheValue();
		rfParamCache["repwEle" + surfix].updateElementValueToCacheValue();
		rfParamCache["odustaEle" + surfix].updateElementValueToCacheValue();

		if( _this.getRfElement("repwEle", isMainColumn).disabled == false )
		{
			rfParamCache[_this.getRfElementID("repwEle", isMainColumn)].setElementDisabled( HopTookit.isDataInBusinessValid(repwVal) ? false : true );
		}
		
		if( HopTookit.isDataValid(fre_low) && HopTookit.isDataValid(fre_high) )
		{
			if( fre_high == "0.0" || fre_high == "0.000" )	//  RTN600       ?
			{
				HopTookit.checkDataRange(_this.getRfElement("txfreEle", isMainColumn), fre_low, "4294967.295", 3);
			}
			else
			{
				HopTookit.checkDataRange(_this.getRfElement("txfreEle", isMainColumn), fre_low, fre_high, 3);
			}
		}
		else
		{
			HopTookit.checkDataRange(_this.getRfElement("txfreEle", isMainColumn), "0", "4294967.295", 3);
		}
		
		if( HopTookit.isDataValid(power_low) && HopTookit.isDataValid(power_high) )
		{
			HopTookit.checkDataRange(_this.getRfElement("sendpwEle", isMainColumn), power_low, power_high, 1);
		}
		else
		{
			HopTookit.checkDataRange(_this.getRfElement("sendpwEle", isMainColumn), "-90.0", "-20.0", 1);
		}
		
	}

	/**
	 *          xml
	 * @param neid
	 * @param row
	 * @param slotIdParam
	 * @return
	 */
	this.createRFAttriFieldApplyXml = function(neid, row, slotId)
	{
		var isIFBoard = g_commonData.isIFBoard(slotId);
		var isLeft = true;
		
		if( g_commonData.isRelatedIF1Plus1GroupExist() )	//          1+1  
		{
			if( isIFBoard )
			{
				isLeft = slotId == $("workboardEle").value ? true : false;
			}
			else
			{
				var workODUSlotId = g_commonData.getRelatedODUSlotId($("workboardEle").value);
				isLeft = slotId == workODUSlotId ? true : false;
			}
		}

		var isColumnModified = false;
		if(_this.isExpend == false)
		{
			return isColumnModified;
		}
		
		
		if( rfParamCache[_this.getRfElementID("txfreEle", isLeft)].isElementModified() == true )
		{
			HopTookit.addParam(row, "W32BRD_ATTR_TRANSMITFRE", _this.getRfElement("txfreEle", isLeft).value * 1000 );
			
			isColumnModified = true;
		}
		
		if( rfParamCache[_this.getRfElementID("trspaceEle", isLeft)].isElementModified() == true )
		{
			HopTookit.addParam(row, "W32BRD_ATTR_TRINTERVAL", _this.getRfElement("trspaceEle", isLeft).value * 1000 );
			
			isColumnModified = true;
		}

		if( rfParamCache[_this.getRfElementID("atpcenableEle", isLeft)].isElementModified() == true )
		{
			if(isLeft)
			{
			  HopTookit.addParam(row, "W32PORT_ATTR_ATPCENABLE", HopTookit.getCheckboxEleValue(_this.getRfElement("atpcenableEle", isLeft)) );			
			  isColumnModified = true;
			}
		}
		
		if( _this.getRfElement("atpcenableEle", isLeft).checked == true )
		{
			if( rfParamCache[_this.getRfElementID("atpcUpperThresEle", isLeft)].isElementModified() == true ||
				rfParamCache[_this.getRfElementID("atpcLowerThresEle", isLeft)].isElementModified() == true )
			{
				HopTookit.addParam(row, "W32PORT_ATTR_ATPCUPPER", _this.getRfElement("atpcUpperThresEle", isLeft).value *10 );
				HopTookit.addParam(row, "W32PORT_ATTR_ATPCLOWER", _this.getRfElement("atpcLowerThresEle", isLeft).value *10 );
				
				isColumnModified = true;
			}
		}
		
		if( rfParamCache[_this.getRfElementID("sendpwEle", isLeft)].isElementModified() == true )
		{
			HopTookit.addParam(row, "W32BRD_ATTR_TRANSMITPOWER", _this.getRfElement("sendpwEle", isLeft).value *10 );
			
			isColumnModified = true;
		}
		
		if( rfParamCache[_this.getRfElementID("repwEle", isLeft)].isElementModified() == true )
		{
			HopTookit.addParam(row, "W32BRD_ATTR_RECEIVEPOWER", _this.getRfElement("repwEle", isLeft).value * 10 );
			isColumnModified = true;
		}
		
		if( rfParamCache[_this.getRfElementID("odustaEle", isLeft)].isElementModified() == true )
		{
			HopTookit.addParam(row, "W32BRD_ATTR_WORKSTATUS", _this.getRfElement("odustaEle", isLeft).value);
			
			isColumnModified = true;
		}
		
		if( rfParamCache[_this.getRfElementID("antennaplEle", isLeft)].isElementModified() == true )
		{
			HopTookit.addParam(row, "W32BRD_ATTR_ANTENNA_POLAR_WBID", _this.getRfElement("antennaplEle", isLeft).value);
			
			isColumnModified = true;
		}
		
		
		return isColumnModified;
	}

	/**
	 *   onchange  
	 * @return
	 */
	this.setRfAttriAtomEditHandler = function()
	{
		for( var i = 0; i < _this.rfComponentsOnChangeArray.length; i++ )
		{
			$(_this.rfComponentsOnChangeArray[i]).onchange = function()
			{
				HopTookit.processCellOnchange(rfParamCache[this.id]);
			}
			
			if( _this.rfComponentsOnChangeArray[i].indexOf("trspaceEle") >= 0 )
			{
				$(_this.rfComponentsOnChangeArray[i]).onchange = function()
				{
					_this.doBusinessIf_GenericEleChanged(this.id);
					
					HopTookit.sendUnionEvent(terminalType, this.id, _this);
				}
			}
			
			if( _this.rfComponentsOnChangeArray[i].indexOf("atpcenableEle") >= 0 )
			{
				$(_this.rfComponentsOnChangeArray[i]).onclick = function()
				{
					_this.doBusinessIf_ATPCEnableEleChanged(this.id);

					HopTookit.sendUnionEvent(terminalType, this.id, _this);
				}
			}
			
			if( _this.rfComponentsOnChangeArray[i].indexOf("txfreEle") >= 0 )
			{
				$(_this.rfComponentsOnChangeArray[i]).onchange = function()
				{
					_this.doBusinessIf_GenericEleChanged(this.id);

					HopTookit.sendUnionEvent(terminalType, this.id, _this);
				}
			}
		}
	}

	this.isAnyElementInThisAttriFieldModified = function()
	{
		var isModified = false;
		
		for( var i = 0; i < _this.rfComponentsAllArray.length; i++ )
		{
			if( HopTookit.isElementModified($(_this.rfComponentsAllArray[i])) )
			{
				isModified = true;
				break;
			}
		}
		
		return isModified;
	}



	/**
	 *                 
	 * @return
	 */
	this.processRfFieldRightColumnDisable = function(event)
	{
		var workmode = event.getWorkMode();
		var isif1plus1checked = event.isRadio1plus1checked();
		
		if( (workmode == wModeStru.HSBVal || workmode == wModeStru.SDVal) && isif1plus1checked == true )
		{
			_this.disableRfFieldRightColumn(true);
		}
		else if( workmode == wModeStru.FDVal && isif1plus1checked == true )
		{
			_this.disableRfFieldRightColumn(true);
			HopTookit.setElementDisalbed("txfreEle2", false, true);
			HopTookit.setElementDisalbed("sendpwEle2", false, true);//FD             ?
		}
		else
		{
			_this.disableRfFieldRightColumn(false);
		}
	}

	/**
	 *                     ?
	 * @param flag
	 * @return
	 */
	this.disableRfFieldRightColumn = function(flag)
	{
		for( var i = 0; i < _this.rfComponentsOnChangeArray.length; i++ )
		{
			if( _this.rfComponentsOnChangeArray[i].indexOf("2") < 0 )
			{
				continue;
			}
				
			HopTookit.setElementDisalbed(_this.rfComponentsOnChangeArray[i], flag, true);
		}
		HopTookit.setElementDisalbed("atpcenableEle2", flag, false);
		HopTookit.setElementDisalbed("odustaEle2", false, true);
		HopTookit.setElementDisalbed("antennaplEle2", false, true);
	}

	this.clearAttriFieldBgColor = function()
	{
		for( var i = 0; i < _this.rfComponentsOnChangeArray.length; i++ )
		{
			if( $(_this.rfComponentsOnChangeArray[i]).disabled == false )
			{
				$(_this.rfComponentsOnChangeArray[i]).style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
			}
		}

		if( $("atpcenableEle").disabled == false )
		{
			$("atpcenableEle").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
		}	
		if( $("atpcenableEle2").disabled == false )
		{
			$("atpcenableEle2").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
		}
	}

	this.initCurrentDomain = function()
	{
		$("RFAttriSpan").innerText = RESOURCE["RFAttriSpan"];
		$("txfreSpan").innerText = RESOURCE["sendfretx"];
		$("rxfreSpan").innerText = RESOURCE["rxfrespan"];
		$("trspaceSpan").innerText = RESOURCE["trspacetx"];
		$("atpcenableSpan").innerText = RESOURCE["atpcenableSpan"];
		$("atpcUpperThresSpan").innerText = RESOURCE["W32PORT_ATTR_ATPCUPPER"];
		$("atpcLowerThresSpan").innerText = RESOURCE["W32PORT_ATTR_ATPCLOWER"];
		$("sendpwSpan").innerText = RESOURCE["sendpwtx"];
		$("repwSpan").innerText = RESOURCE["repwtx"];
		$("rxpwSpan").innerText = RESOURCE["rxpwtx"];
		$("odustaSpan").innerText = RESOURCE["odustatx"];
		$("actualsendpwSpan").innerText = RESOURCE["realsdpwtx"];
		$("antennaplSpan").innerText = RESOURCE["antennapltx"];
		
		_this.setRfAttriAtomEditHandler();
	}
	
	this.processWhenWorkModeChanged = function(event)
	{
		_this.showProtectOduRFInfo(event); //,isRelatedExist
	    
	    _this.processRfFieldRightColumnDisable(event);
	}
	
	this.processWhenProtectGroupBoardChanged = function(event)
	{
		_this.showODUSlotName( g_commonData.isRelatedIF1Plus1GroupExist() );
	}

	/**
	 *   ODU   ?
	 * @return
	 */
	this.showODUSlotName = function(doesIF1Plus1Exist)
	{
		var tmpWorkODUId = null;
		var tmpProtectODUId = null;

		if( doesIF1Plus1Exist == true || $("if1plus1").checked == true )
		{
			var tmpWorkIfSlotId = $("workboardEle").value;
			var tmpProtectIfSlotId = $("protectboardEle").value;
			
			tmpWorkODUId = g_commonData.getRelatedODUSlotId(tmpWorkIfSlotId);
			tmpProtectODUId = g_commonData.getRelatedODUSlotId(tmpProtectIfSlotId);
			
			$("oduMainSpan").innerText = tmpWorkODUId + "-" + ODU_BOARD_NAME;
			$("oduAppendixSpan").innerText = tmpProtectODUId + "-" + ODU_BOARD_NAME;
		}
		else
		{
			var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
			tmpWorkODUId = g_commonData.getRelatedODUSlotId(ifSlotId);
			if(tmpWorkODUId == ifSlotId)
			{
				$("oduMainSpan").innerText = "";
			}
			else
			{	
				$("oduMainSpan").innerText = tmpWorkODUId + "-" + ODU_BOARD_NAME;
			}
		}
	}
	
	this.doBusinessIf_GenericEleChanged = function(column)
	{
		HopTookit.processCellOnchange(rfParamCache[column]);
	}
	
	this.doBusinessIf_ATPCEnableEleChanged = function(column)
	{
		HopTookit.processCellOnchange(rfParamCache[column]);
		_this.showATPCThresSpan($(column).checked);		
		adjustCellWidth();
	}
	
	this.createXpicRFAttriFieldApplyXml = function(neid, row, oduslotid)
	{
		var isColumnModified = false;
		
		if( oduslotid == $("hPolarBdEle").value || oduslotid == $("vPolarBdEle").value )
		{
			return false;
		}
		
		if( oduslotid == g_commonData.getRelatedODUSlotId($("hPolarBdEle").value) )
		{
			if( HopTookit.isElementModified($("repw_hEle")) )
			{
				HopTookit.addParam(row, "W32BRD_ATTR_RECEIVEPOWER", $("repw_hEle").value * 10);
				
				isColumnModified = true;
			}
		}
		
		if( oduslotid == g_commonData.getRelatedODUSlotId($("vPolarBdEle").value) )
		{
			if( HopTookit.isElementModified($("repw_vEle")) )
			{
				HopTookit.addParam(row, "W32BRD_ATTR_RECEIVEPOWER", $("repw_vEle").value * 10);
				
				isColumnModified = true;
			}
		}

		return isColumnModified;
	}
	

	this.showRFAttriField = function()
	{
		var advStyle = $("RFParamField").style.display;
		
		if (!_this.isExpend && $("RFParamField").style.display == "none") 
		{
			querySpecialStart();
		}
		var isQuery = !_this.isExpend;
		_this.showRFAttriFieldWithoutSendingEvent(advStyle,isQuery);
		
		HopTookit.sendUnionFoldEvent(terminalType, "arrowImg_rf", _this, advStyle,isQuery);
	}

	this.showRFAttriFieldWithoutSendingEvent = function(advStyle,isQuery)
	{
		$("RFParamField").style.display = advStyle == "" ? "none" : "";
		$("arrowImg_rf").src = advStyle == "" ? "../../../../images/right.gif" : "../../../../images/down.gif";
		if(isQuery && $("RFParamField").style.display == "")
		{
			_this.isExpend = true;
			queryRFSpecialInfomation();
		}
	}
}




/**
 *        
 * @return
 */
RFAttriModule.prototype.initRfAttriFieldOptions = function()
{
    $("odustaEle").options.length = 0;
    $("odustaEle").options[$("odustaEle").options.length] = new Option(RESOURCE["notWork"], EnableStatus.DISABLED);
    $("odustaEle").options[$("odustaEle").options.length] = new Option(RESOURCE["Work"], EnableStatus.ENABLED);
    
    $("odustaEle2").options.length = 0;
    $("odustaEle2").options[$("odustaEle2").options.length] = new Option(RESOURCE["notWork"], EnableStatus.DISABLED);
    $("odustaEle2").options[$("odustaEle2").options.length] = new Option(RESOURCE["Work"], EnableStatus.ENABLED);
   
    $("antennaplEle").options.length = 0;
    $("antennaplEle").options[$("antennaplEle").options.length] = new Option(RESOURCE["HDirection"], EnableStatus.DISABLED);
    $("antennaplEle").options[$("antennaplEle").options.length] = new Option(RESOURCE["VDirection"], EnableStatus.ENABLED);
    
    $("antennaplEle2").options.length = 0;
    $("antennaplEle2").options[$("antennaplEle2").options.length] = new Option(RESOURCE["HDirection"], EnableStatus.DISABLED);
    $("antennaplEle2").options[$("antennaplEle2").options.length] = new Option(RESOURCE["VDirection"], EnableStatus.ENABLED);
    HopTookit.checkDataRange($("txfreEle"), "0", "4294967.295", 3);
    HopTookit.checkDataRange($("txfreEle2"), "0", "4294967.295", 3);
    
    HopTookit.checkDataRange($("trspaceEle"), "0", "4294967.295", 3);
    HopTookit.checkDataRange($("trspaceEle2"), "0", "4294967.295", 3);
    
    HopTookit.checkDataRange($("sendpwEle"), "-10.0", "35.0", 1);
    HopTookit.checkDataRange($("sendpwEle2"), "-10.0", "35.0", 1);
    
    HopTookit.checkDataRange($("repwEle"), "-78.0", "-23.0", 1);
    HopTookit.checkDataRange($("repwEle2"), "-78.0", "-23.0", 1);
    
    HopTookit.checkDataRange($("atpcUpperThresEle"), "-73.0", "-23.0", 1);
    HopTookit.checkDataRange($("atpcUpperThresEle2"), "-73.0", "-23.0", 1);

    HopTookit.checkDataRange($("atpcLowerThresEle"), "-78.0", "-28.0", 1);
    HopTookit.checkDataRange($("atpcLowerThresEle2"), "-78.0", "-28.0", 1);

}

RFAttriModule.prototype.showATPCThresSpan = function(flag) 
{
	$("atpcUpperThresTR").style.display = flag ? "" : "none";
	$("atpcLowerThresTR").style.display = flag ? "" : "none";
}

/**
 * 
 * @param eleIDstr
 * @param flag:            ?
 * @return
 */
RFAttriModule.prototype.getRfElement = function(eleIDstr, leftFlag)
{
	var tmpStr = leftFlag == true ? "" : "2";
	
	return $( eleIDstr + tmpStr );
}

/**
 * 
 * @param eleIDstr
 * @param flag:            ID
 * @return
 */
RFAttriModule.prototype.getRfElementID = function(eleIDstr, leftFlag)
{
	var tmpStr = leftFlag == true ? "" : "2";
	
	return eleIDstr + tmpStr;
}

/**
 *     ODU      
 * @param flag
 * @return
 */
RFAttriModule.prototype.showProtectOduRFInfo = function(event)//flag
{
	var isRelatedExist = g_commonData.isRelatedIF1Plus1GroupExist();
	var ischecked = event.isRadio1plus1checked();
	
	var flag = ischecked == true ? true : false;
	
	for( var i = 0; i <= RF_PROTECT_ODU_ROW_SUM; i++ )
	{
		$("appendixTD"+i).style.display = flag == true ? "" : "none";
	}
	$("oduMainTD").style.width = (flag == true)?"135px":"270px";
}

/**
 *     
 */
RFAttriModule.prototype.refreshCache = function()
{
	rfParamCache["txfreEle"].updateElementValueToCacheValue();
	rfParamCache["txfreEle2"].updateElementValueToCacheValue();
	rfParamCache["trspaceEle"].updateElementValueToCacheValue();
	rfParamCache["trspaceEle2"].updateElementValueToCacheValue();
	rfParamCache["atpcenableEle"].updateElementValueToCacheValue();
	rfParamCache["atpcenableEle2"].updateElementValueToCacheValue();
	rfParamCache["atpcUpperThresEle"].updateElementValueToCacheValue();
	rfParamCache["atpcLowerThresEle"].updateElementValueToCacheValue();
	rfParamCache["atpcUpperThresEle2"].updateElementValueToCacheValue();
	rfParamCache["atpcLowerThresEle2"].updateElementValueToCacheValue();
	rfParamCache["sendpwEle"].updateElementValueToCacheValue();
	rfParamCache["sendpwEle2"].updateElementValueToCacheValue();
	rfParamCache["repwEle"].updateElementValueToCacheValue();
	rfParamCache["repwEle2"].updateElementValueToCacheValue();
	rfParamCache["odustaEle"].updateElementValueToCacheValue();
	rfParamCache["odustaEle2"].updateElementValueToCacheValue();
	rfParamCache["antennaplEle"].updateElementValueToCacheValue();
	rfParamCache["antennaplEle2"].updateElementValueToCacheValue();
}

/**
 *         XPIC TR
 */
RFAttriModule.prototype.showXPICTr = function(event)
{
	var flag = event.getXPICStatus();
	
	if ($("repwTR")) 
	{
		$("repwTR").style.display = flag == true ? "none" : "";
	}
	if ($("rxpwTR")) 
	{
		$("rxpwTR").style.display = flag == true ? "none" : "";
	}
	
	if ($("repw_vTR")) 
	{
		$("repw_vTR").style.display = flag == true ? "" : "none";
	}
	if ($("rxpw_vTR")) 
	{
		$("rxpw_vTR").style.display = flag == true ? "" : "none";
	}
	if ($("repw_hTR")) 
	{
		$("repw_hTR").style.display = flag == true ? "" : "none";
	}
	if ($("rxpw_hTR")) 
	{
		$("rxpw_hTR").style.display = flag == true ? "" : "none";
	}
	$("oduNameTr").style.display = flag == true ? "none" : "";
	$("antennaplTR").style.display = "";
}

/**
 *     1+1  XPIC    
 */
RFAttriModule.prototype.refreshXpicRelatedData = function(event)
{
	var vBd = event.getVBdStruct();
	var hBd = event.getHBdStruct();
	var data = event.getData();

	for( var i = 0; i < data.getDataRowLength(); i++ )
	{
		var tslotid = data.getDataRowParam(i, "slotid");
		var tport = data.getDataRowParam(i, "port");
		var tReceivePower = data.getDataRowParam(i, "W32BRD_ATTR_RECEIVEPOWER");
		var tActReceivePower = data.getDataRowParam(i, "W32BRD_ATTR_ACTRECEIVEPOWER");
		
		if( vBd.getSlotID() == tslotid &&
			vBd.getPortID() == tport )
		{
			$("repw_vEle").value = HopTookit.isDataInBusinessValid(tReceivePower) == true ? tReceivePower : "";
			$("rxpw_vEle").value = HopTookit.isDataInBusinessValid(tActReceivePower) == true ? tActReceivePower : "";
		}
		else
		{
			$("repw_hEle").value = HopTookit.isDataInBusinessValid(tReceivePower) == true ? tReceivePower : "";
			$("rxpw_hEle").value = HopTookit.isDataInBusinessValid(tActReceivePower) == true ? tActReceivePower : "";
		}
	}
}
/**
 **  V1R2C01            
 **/
RFAttriModule.prototype.filterUnsupportAttrByNeTypeAndNeversion = function()
{	
    if(!HopTookit.isRTN900_AND_VERSION_ABOVE_05760310(neid, neType, neVersion))
    {
        $('repwTR').style.display = 'none';
        $('repw_vTR').style.display = 'none';
        $('repw_hTR').style.display = 'none';
    }    
}

RFAttriModule.prototype.isShowAntennaPolar= function()
{	
    if(neType == NETYPE_RTN380)
    {
        $("antennaplTR").style.display = "";
    }else{
    	$("antennaplTR").style.display = 'none';
    }    
}
