var QUERYSWITCHSTATE = 1;
var LOCKED = 7;//   
var FORCETOWORKINGUNIT = 3;//          
var FORCETOPROTECTIONNUIT = 4;//          
var MANUALTOWORKONGUNIT = 5;//          
var MANUALTOPROTECTIONUNIT = 6;//          
var CLEAR = 2;//   

var switchCmd = new Object();//     
switchCmd.PROTECTIONLOCK = 2;//     
switchCmd.FORCESWITCH = 1;//     
switchCmd.MANULSWITCH = 0;//     
switchCmd.CLSSWITCHCMD = 3;//     

var switchDirection = new Object();//     
switchDirection.SWITCHWORKING = 1;//      
switchDirection.SWITCHPROTECTION = 0;//      

function protectionBoardContextMenu(evt)
{
	removejsDOMmenu();
	if(!evt)
	{
		evt = window.event;
	}
	var elem = (evt.target) ? evt.target : evt.srcElement;
	while(elem!=null)
	{
		if(elem.tagName.toUpperCase() == 'DIV')
		{
			break;	
		}
		elem = elem.parentNode;
	}
	var groupid = elem.getAttribute("groupid");
	var isworkflag = elem.getAttribute("iswork");
	var isprot = true;
	var iswork = false;
	if((isworkflag + "") == "true")
	{
		isprot = false;
		iswork = true;
	}
	var cursorMenu1 = new jsDOMenu(180);
	
	with (cursorMenu1)
	{
		addMenuItem(new menuItem(RESOURCE["queryswitchstate"], "",
				switchFunction, QUERYSWITCHSTATE));
		addMenuItem(new menuItem("-"));

		addMenuItem(new menuItem(RESOURCE["clear"], "", switchFunction, CLEAR));

		addMenuItem(new menuItem(RESOURCE["locked"], "", switchFunction, LOCKED));

		addMenuItem(new menuItem(RESOURCE["forcetoworkingunit"], "",
				switchFunction, FORCETOWORKINGUNIT, isprot));
		addMenuItem(new menuItem(RESOURCE["forcetoprotectionunit"], "",
				switchFunction, FORCETOPROTECTIONNUIT, iswork));

		addMenuItem(new menuItem(RESOURCE["manualtoworkingunit"], "",
				switchFunction, MANUALTOWORKONGUNIT, isprot));
		addMenuItem(new menuItem(RESOURCE["manualtoprotectionunit"], "",
				switchFunction, MANUALTOPROTECTIONUNIT, iswork));
	}

	setPopUpMenu(cursorMenu1);
	showMenu();
}

/**
 *       
 */
function switchFunction(command)
{
	removejsDOMmenu();
	if (command == LOCKED)
	{
		if (!confirm(RESOURCE["LockAlarm"]))
			return;
	}
	if (command > QUERYSWITCHSTATE)
	{
		var flag = confirm(RESOURCE["confimswitch"]);
		if (!flag)
		{
			return;
		}
	}
	var xmlstr = null;
	switch (command)
	{
		case QUERYSWITCHSTATE:
			queryProtection();
			break;
		case CLEAR:
			xmlstr = createProtectionSwitchXML(switchCmd.CLSSWITCHCMD,
					switchDirection.SWITCHWORKING);//     
			break;
		case FORCETOPROTECTIONNUIT:
			xmlstr = createProtectionSwitchXML(switchCmd.FORCESWITCH,
					switchDirection.SWITCHPROTECTION);//       
			break;
		case FORCETOWORKINGUNIT:
			xmlstr = createProtectionSwitchXML(switchCmd.FORCESWITCH,
					switchDirection.SWITCHWORKING);//       
			break;
		case MANUALTOPROTECTIONUNIT:
			xmlstr = createProtectionSwitchXML(switchCmd.MANULSWITCH,
					switchDirection.SWITCHPROTECTION);//       
			break;
		case MANUALTOWORKONGUNIT:
			xmlstr = createProtectionSwitchXML(switchCmd.MANULSWITCH,
					switchDirection.SWITCHWORKING);//       
			break;
		default:
			xmlstr = createProtectionSwitchXML(switchCmd.PROTECTIONLOCK,
					switchDirection.SWITCHWORKING);//     
			break;
	}
	sendSwitchInfo(xmlstr,command);

}

/**
 *          1+1    
 */
function sendSwitchInfo(xmlstr,command)
{
	if (null != xmlstr)
	{
		var urlreq = "../../../../neExlorerServlet?sfid="
				+ NSCMD_CFG_RADIO_1J1PG_EXT_SWCMD + "&flag=1" + "&nmUser="
				+ nmUser;
		loadXMLdoc(urlreq, "POST", true, openSwitchErrDialog, command,
				"inputdata=" + xmlstr);
	}
}

/**
 *       1+1       XML   
 */
function createProtectionSwitchXML(switchCommand, direction)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param","neId",neid);
	row.appendChild(param);
	param = new tagElement("param","groupId",protectionCache["groupId"]);//    id  
	row.appendChild(param);
	param = new tagElement("param","switchMode",switchCommand);//       
	row.appendChild(param);
	param = new tagElement("param","direction",direction);//       
	row.appendChild(param);
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();

}

/**
 *         
 */
function openSwitchErrDialog(doc, para)
{
	var data = EncapsulateData(doc);

	if (0 != data.getSErrorCode())
	{
		HopTookit.showErrorDialog(data);
		return;
	}

	if (para == MANUALTOWORKONGUNIT 
			|| para == MANUALTOPROTECTIONUNIT 
			|| para == FORCETOWORKINGUNIT 
			|| para == FORCETOPROTECTIONNUIT)
	{
		alert(RESOURCE["queryswitchstatus2"]);
	}
	else
	{
		alert(RESOURCE["cfgSuccess"]);
	}
	queryProtection();
}


function queryProtection()
{
	var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_GET_RADIO_1J1PG + "&nmUser="+ nmUser;
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	var tmpSlotArray = new Array(ifSlotId);
	var xmlstr = createCommonQueryXML(neid, tmpSlotArray);
	
	loadXMLdoc(urlreq, "POST", true, queryProtectionCallback, false, "inputdata=" + xmlstr);
}

function queryProtectionCallback(doc)
{
	var data = EncapsulateData(doc);
	HopTookit.showErrorDialog(data);
	if(data.getSErrorCode() == OPERATION_SUCCESS)
    {
		var equipSlotId = data.getDataRowParam(0, "equipSlotId");
		var workingSlotId = data.getDataRowParam(0, "workingSlotId");
		if( equipSlotId == workingSlotId )
		{
			$("workifline1").src= REALLINE_IMAGE_ACTIVE;
			$("workifline2").src = REALLINE_IMAGE;
			$("protectifline1").src = BORKENLINE_IMAGE_STANDBY;
			$("protectifline2").src = BORKENLINE_IMAGE;
		}
		else
		{
			$("workifline1").src= BORKENLINE_IMAGE_STANDBY;
			$("workifline2").src = BORKENLINE_IMAGE;
			$("protectifline1").src = REALLINE_IMAGE_ACTIVE;
			$("protectifline2").src = REALLINE_IMAGE;
		}
    }
}
/**
 *         
 * @return
 */
function ProtectionGraphPainter()
{
	var _this = this;
	
	/**
	 *            
	 */
	this.refreshGraph = function(event)
	{
		$("workoduslotspan").parentNode.style.backgroundColor = CELL_ALARMNOTEXIST_BGCOLOR;
		$("protectoduslotspan").parentNode.style.backgroundColor = CELL_ALARMNOTEXIST_BGCOLOR;
		
		$("workifline1").src = REALLINE_IMAGE;
		$("workifline2").src = REALLINE_IMAGE;
		$("protectifline1").src = REALLINE_IMAGE;
		$("protectifline2").src = REALLINE_IMAGE;
		
		if( event.isRadio1plus1checked() == false )		//                  
		{
			_this.refreshWhenNoGroupExist(event);
		}
		else											//                
		{
			_this.refreshWhenGroupExist(event);
		}
	}

	/**
	 *             
	 */
	this.refreshWhenNoGroupExist = function(event)
	{
		$("protectgraphTR").style.display = "none";
		$("workmodegraph").style.display = "none";
		$("verticalline").style.display = "none";

		var tmpIFVlaue = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
		var tmpODUValue = g_commonData.getRelatedODUSlotId(tmpIFVlaue);

		$("workifslotspan").innerText = tmpIFVlaue + "-" + g_commonData.getIFBoardName(tmpIFVlaue);
		$("workoduslotspan").innerText = tmpODUValue + "-" + ODU_BOARD_NAME;
		$("odurslspan").innerText = RECEIVEPOWER_TITLE + " " + VALID_SHOWVAL;
		$("odutslspan").innerText = SENDPOWER_TITLE + " " + VALID_SHOWVAL;
		
		$("workifslotspan").parentNode.oncontextmenu = null;
		$("workoduslotspan").parentNode.oncontextmenu = null;
		$("protectifslotspan").parentNode.oncontextmenu = null;
		$("protectoduslotspan").parentNode.oncontextmenu = null;
		
		/*
		var obj = new Object();
		obj.ifslotid = tmpIFVlaue;
		if(tmpIFVlaue == tmpODUValue)
		{
			$("workoduslotspan").style.display = "none";
			obj.ifspan = "workoduslotspan";
		}
		else
		{
			$("workoduslotspan").style.display = "";
			obj.ifspan = "workoduslotspan";
		}
		*/
		if( tmpIFVlaue == tmpODUValue )
		{
			$("workoduslotspan").parentNode.style.display = "none";
			if ($("workifslotspan").parentNode != $("odurslspan").parentNode) 
			{
				$("workifslotspan").parentNode.insertBefore($("odurslspan"),$("workifslotspan"));
				$("workifslotspan").parentNode.insertBefore($("odutslspan"),$("workifslotspan"));
			}
		}
		

		$("workifline1").src= REALLINE_IMAGE;
		$("workifline2").src = REALLINE_IMAGE;
		
		
		var obj = new Object();
		obj.ifslotid = tmpIFVlaue;
		obj.ifspan = "workifslotspan";
		_this.refreshLOFAlarm(obj);
	}
	
	this.initProtectBoardAttr = function(objEle,groupid,iswork)
	{
		objEle.setAttribute("groupid",groupid);
		objEle.setAttribute("iswork",iswork);
		objEle.oncontextmenu = protectionBoardContextMenu;
	}
	
	/**
	 *              
	 */
	this.refreshWhenGroupExist = function(event)
	{
		$("protectgraphTR").style.display = "";
		$("workmodegraph").style.display = "";
		$("verticalline").style.display = "";
		
		var tmpmode = HopTookit.getProtectionModeDescription(event.getWorkMode());
		if( event.getWorkMode() == wModeStru.SDVal )
		{
			$("ifprotectiontype").src = "../../../../images/sd.jpg";
		}
		if( event.getWorkMode() == wModeStru.FDVal )
		{
			$("ifprotectiontype").src = "../../../../images/fd.jpg";
		}
		if( event.getWorkMode() == wModeStru.HSBVal )
		{
			$("ifprotectiontype").src = "../../../../images/hsb.jpg";	
		}

		var workIFVlaue = event.getWorkBoardInforStruct().getIFSlotId();
		var workODUValue = g_commonData.getRelatedODUSlotId(workIFVlaue);
		$("workifslotspan").innerText = workIFVlaue + "-" + g_commonData.getIFBoardName(workIFVlaue);
		$("workoduslotspan").innerText = workODUValue + "-" + ODU_BOARD_NAME;
		$("odurslspan").innerText = RECEIVEPOWER_TITLE + " " + VALID_SHOWVAL;
		$("odutslspan").innerText = SENDPOWER_TITLE + " " + VALID_SHOWVAL;
		
		var protectIFVlaue = event.getProtectBoardInforStruct().getIFSlotId();
		var protectODUValue = g_commonData.getRelatedODUSlotId(protectIFVlaue);
		$("protectifslotspan").innerText = protectIFVlaue + "-" + g_commonData.getIFBoardName(protectIFVlaue);
		$("protectoduslotspan").innerText = protectODUValue + "-" + ODU_BOARD_NAME;
		$("odurslspan2").innerText = RECEIVEPOWER_TITLE + " " + VALID_SHOWVAL;
		$("odutslspan2").innerText = SENDPOWER_TITLE + " " + VALID_SHOWVAL;
		
		var equipSlotId = event.getEquipSlotId();	//              
		
		if( HopTookit.isDataInBusinessValid(equipSlotId) == true )
		{
			if( equipSlotId == workIFVlaue )	//   		       
			{
				_this.setWorkBoardActiveStatus();
			}
			else								//   		       
			{
				_this.setProtectBoardActiveStatus();	
			}
		}
		else
		{
			_this.setWorkBoardActiveStatus();
		}
		
		_this.initProtectBoardAttr($("workifslotspan").parentNode,event.getGroupId(),true);
		_this.initProtectBoardAttr($("workoduslotspan").parentNode,event.getGroupId(),true);
		_this.initProtectBoardAttr($("protectifslotspan").parentNode,event.getGroupId(),false);
		_this.initProtectBoardAttr($("protectoduslotspan").parentNode,event.getGroupId(),false);
		
		var objWork = new Object();
		objWork.ifslotid = workIFVlaue;
		objWork.ifspan = "workifslotspan";
		
		var objProtect = new Object();
		objProtect.ifslotid = protectIFVlaue;
		objProtect.ifspan = "protectifslotspan";
		
		_this.refreshLOFAlarm(objWork);
		
		_this.refreshLOFAlarm(objProtect);
	}
	
	/**
	 *       Active  (           S  )
	 */
	this.setWorkBoardActiveStatus = function()
	{
		$("workifline1").src= REALLINE_IMAGE_ACTIVE;
		$("workifline2").src = REALLINE_IMAGE;
		$("protectifline1").src = BORKENLINE_IMAGE_STANDBY;
		$("protectifline2").src = BORKENLINE_IMAGE;
	}
	
	/**
	 *       Active  (            S  )
	 */
	this.setProtectBoardActiveStatus = function()
	{
		$("workifline1").src= BORKENLINE_IMAGE_STANDBY;
		$("workifline2").src = BORKENLINE_IMAGE;
		$("protectifline1").src = REALLINE_IMAGE_ACTIVE;
		$("protectifline2").src = REALLINE_IMAGE;
	}
	
	this.refreshLOFAlarm = function(obj)
	{
		/*
		var xmlstr = _this.createQueryXMLCache(obj.ifslotid);
		        
		loadXMLdoc( "../../../../neExlorerServlet?sfid=" + TE_QUERY_CURRENT_RECORD_CMD + "&flag=0&nmUser="+ nmUser,
				"POST", true, _this.refreshAlarmColor, obj, "inputdata=" + xmlstr );
		      
		loadXMLdoc( "../../../../neExlorerServlet?sfid=" + TE_QUERY_MASK_START_CMD + "&nmUser="+ nmUser,
				"POST", true, _this.refreshAlarmColor, obj, "inputdata=" + xmlstr );
		*/

		var xmlstr = _this.createQueryXML(obj.ifslotid);
		loadXMLdoc( "../../../../neExlorerServlet?sfid=" + TECMDCODE_HOP_QUERY_ALARM + "&nmUser="+ nmUser,
				"POST", true, _this.refreshAlarmColor, obj, "inputdata=" + xmlstr );		
	}
	
	this.createQueryXML = function(_slotid)
	{
	    var root = new inputxml("datainterface");
	    
	    firstlevel = new tagElement("bussiness-params");    
	    secondlevel = new tagElement("row-params");
	    var thirdlevel = null;
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","neid");
	    thirdlevel.setAttribute("value",neid);
	    secondlevel.appendChild(thirdlevel);

	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","slotid");
	    thirdlevel.setAttribute("value",_slotid);
	    secondlevel.appendChild(thirdlevel);
	    
	    firstlevel.appendChild(secondlevel);
	    root.getRoot().appendChild(firstlevel);

	    return root.toString();
	}

	this.refreshAlarmColor = function(doc, param)
	{
		var data = EncapsulateData(doc);
		
		if( !data.isAllSuccess() )
	    {
	    	return;
	    }
	    else
	    {
	    	var dataLength = data.getDataRowLength();
	    	
	    	if( dataLength == 0 )	//              
	    	{
	    		$(param.ifspan).parentNode.style.backgroundColor = CELL_ALARMNOTEXIST_BGCOLOR;
	    	}
	    	else
	    	{
	    		var isAlarmExistFlag = data.getDataRowParam(0, "isAlarmExist");
	    		
	    		$(param.ifspan).parentNode.style.backgroundColor = isAlarmExistFlag == "1" ? CELL_ALARMEXIST_BGCOLOR : CELL_ALARMNOTEXIST_BGCOLOR;
	    		
	    	}
	    }
	}
	
	
	/*
	this.createQueryXMLCache = function(_slotid)
	{
	    var root = new inputxml("datainterface");//  xml      
	    
	    firstlevel = new tagElement("bussiness-params");    
	    secondlevel = new tagElement("row-params");

	    var thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","pageNum");
	    thirdlevel.setAttribute("value","1");
	    secondlevel.appendChild(thirdlevel);
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","resultNumPerPage");
	    thirdlevel.setAttribute("value","40");
	    secondlevel.appendChild(thirdlevel);
	    
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name","sortParam");
        thirdlevel.setAttribute("value","4");
        secondlevel.appendChild(thirdlevel);
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","sortby");
	    thirdlevel.setAttribute("value","des");
	    secondlevel.appendChild(thirdlevel);
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","neID");
	    thirdlevel.setAttribute("value",neid);
	    secondlevel.appendChild(thirdlevel);
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","slotid");
	    thirdlevel.setAttribute("value",_slotid);
	    secondlevel.appendChild(thirdlevel);
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","alarmName");
	    thirdlevel.setAttribute("value","MW_LOF");
	    secondlevel.appendChild(thirdlevel);
 
        for( i = 0; i < 4; i++ )
        {
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name", "alarmLevel");
            thirdlevel.setAttribute("value", i+1);
            secondlevel.appendChild(thirdlevel);
        }
	    
        for( i = 0; i < 6; i++ )
	    {
	        thirdlevel = new tagElement("param");
	        thirdlevel.setAttribute("name","alarmType");
	        thirdlevel.setAttribute("value",i+1);
	        secondlevel.appendChild(thirdlevel);
	    }
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","startFrom");
	    thirdlevel.setAttribute("value","");
	    secondlevel.appendChild(thirdlevel);
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","startTo");
	    thirdlevel.setAttribute("value","");
	    secondlevel.appendChild(thirdlevel);
	    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name","firstFlag");
	    thirdlevel.setAttribute("value","1");
	    secondlevel.appendChild(thirdlevel);
	    
	    firstlevel.appendChild(secondlevel);
	    root.getRoot().appendChild(firstlevel);
	    
	    var xml = root.toString();
	    return xml;
	}
	*/
}
