
function PeerNESearchModule()
{
	var _this = this;
	
	this.m_peerNEID = "";
	this.m_peerRealNEID = "";
	this.m_peerNEName = "";
	this.m_peerNEType = "";
	this.m_peerShelfType= "";
	this.m_peerNEUser = "";
	this.m_peerNEVersion = "";
	this.m_peerNEState = "";
	this.m_peerIFSlotId = "";
	this.m_peerODUSlotId = "";
	this.m_peerGatewayIP = "";
	this.m_peerProcID = null;	
	this.m_peerProcHandle = null;
	
	this.clearData = function()
	{
		_this.m_peerNEID = "";
		_this.m_peerRealNEID = "";
		_this.m_peerNEName = "";
		_this.m_peerNEType = "";
		_this.m_peerShelfType = "";
		_this.m_peerNEUser = "";
		_this.m_peerNEVersion = "";
		_this.m_peerNEState = "";
		_this.m_peerIFSlotId = "";
		_this.m_peerODUSlotId = "";
		_this.m_peerProcID = null;	
		_this.m_peerProcHandle = null;
	}
	
	/**
	 *   IF            
	 */
	this.processWhenIFBoardSelectChanged = function(event)
	{	
		getIsFarEndElement().checked = false;
		
		_this.getOppositeEnd().showMsgWhenSearching();
		
		_this.queryPeerNE(event.getNeId(), event.getSlotId());
	}
	
	/**
	 *            
	 * t_neid     ID
	 * ifslotid     ID
	 */
	this.queryPeerNE = function(t_neid, ifslotid)
	{
		var xml = _this.createPeerXML(t_neid, ifslotid);

		var urlreq = "../../../../neExlorerServlet?sfid="
			+ TECMDCODE_RTN_HOP_QUERY_ALL_OPPOSITENE;											//         
		
		if( getNeProperty(self).sysStatus != "independent" )
		{
			urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_HOP_QUEERY_PEERNE;	//     	
		}

		loadXMLdoc(urlreq, "POST", true, this.queryPeerNeCallback, t_neid, "inputdata=" + xml);
	}
	
	this.createPeerXML = function(t_neid, slotid)
	{
		var di = new inputxml("datainterface");
		bussiness = new tagElement("bussiness-params");
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", t_neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "slotid");
		param.setAttribute("value", slotid);
		row.appendChild(param);

		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);

		return di.toString();
	}
	/**
	 *   FO                           RTN900  
	 *        
	 * 310 380
	 * @param {Object} neType
	 */
	this.isFOCardModelNE = function (neType)
	{
		if (null == neType || undefined == neType)
		{
			neType = "";
		}
		return neType == '115' || neType == '92';
	}
	this.isRTN900Link = function (neType)
	{
		if (null == neType || undefined == neType)
		{
			neType = "";
		}
		return neType == '76' || neType == '77' || neType == '83' || neType == '89' || neType == '90' || neType == '95'
				|| neType == '54' || neType == '55' || neType == '60';
	}
	
	/**
	 *               900          310  
	 *      900       310   false
	 */
	this.isSameDomin = function (localNEType, peerNEType)
	{
		if (null == localNEType || undefined == localNEType)
		{
			localNEType = "";
		}
		
		if (null == peerNEType || undefined == peerNEType)
		{
			peerNEType = "";
		}
		
		if (localNEType == peerNEType)
		{
			return true;
		}
		else
		{
			if (_this.isRTN900Link(localNEType) && _this.isFOCardModelNE(peerNEType))
			{
				return false;
			}
			else if (_this.isFOCardModelNE(localNEType) && _this.isRTN900Link(peerNEType))
			{
				return false;
			}
		}
		
		return true;
	}
	
	this.queryPeerNeCallback = function(doc, param)
	{
		var data = EncapsulateData(doc);
		var sErrCode = data.getSErrorCode();
		/**
		 * DTS2012042503790 
		 *    900   310                    900 310       
		 *                                             
		 */
		if ((sErrCode == OPERATION_SUCCESS || sErrCode == OPERATION_PART_SUCCESS))
		{
			_this.dealPeerNeCallbackWhenSuccess(data, param);
		}
		else
		{
			_this.clearData();
			_this.getOppositeEnd().fillAllDataWhenOppositeNeNotExist();
			isPeerNeQueryFinshed = true;
			if(isLocalQueryFinshed)
			{
				isQueryFinished = true;
				LoadingProcess.removeWaitStatus();
			}
		}
	}
	
	/**
	 *                  
	 */
	this.setRelevantPageAccordingToNeType = function(data)
	{
		if( data.rows[0].peerNEType != null )
		{
			if( data.rows[0].peerNEType.value != terminalStruct.OppositeEnd.neType ||
				data.rows[0].peerShelfType.value != terminalStruct.OppositeEnd.shelfType )	//                      
			{
				$("farEndTerminal").src = HopTookit.getHtmlPageByDevType(data.rows[0].peerNEType.value, 
					(data.rows[0].peerShelfType?data.rows[0].peerShelfType.value:-1), data.getDataRowParam(0, "peerNEID"));
					
				terminalStruct.OppositeEnd.isPageCompletelyLoaded = false;
			}
			else
			{
				terminalStruct.OppositeEnd.isPageCompletelyLoaded = true;
			}
		}
		else
		{
			$("farEndTerminal").src = "farendterminal.html";
		}
	}

	/**
	 *           
	 */
	this.dealPeerNeCallbackWhenSuccess = function(data, param)
	{
		if( getNeProperty(self).sysStatus != "independent" )		//       
		{
			var pLogicNeID	= data.getDataRowParam(0, "peerNEID");
			var pPhyNeID	= data.getDataRowParam(0, "peerRealNEID");
			var pIFSlotID	= data.getDataRowParam(0, "peerIFSlotId");	
           
			
			if (!HopTookit.isDataValid(pLogicNeID) || 
				!HopTookit.isDataValid(pPhyNeID) || 
				!HopTookit.isDataValid(pIFSlotID)) 
            { 
                    if (isLocalQueryFinshed) 
                    { 
                        isPeerNeQueryFinshed = true;
                    	isQueryFinished = true;
                        LoadingProcess.removeWaitStatus(); 
                    } 
                    return; 
            } 
            
            		_this.m_peerNEID = pLogicNeID; 
            		
                var procID = data.getDataRowParam(0, "procID");
		        var procHandle = data.getDataRowParam(0, "procHandle");
		        _this.m_peerProcID = procID;	
	            _this.m_peerProcHandle = procHandle;
		
		        if(procID && procHandle)
		        {
		            terminalStruct.OppositeEnd.PROC_OBJ[pLogicNeID] = [procID, procHandle];
		            PROC_OBJ[pLogicNeID] = [procID, procHandle];
		        }
            		
			_this.queryRemoteNeDetailInfor(param, pLogicNeID, pPhyNeID, pIFSlotID);
		}
		else														//       
		{
			_this.setRelevantPageAccordingToNeType(data);
			zrecuise(param, data);
		}
	}
	
	/**
	 *             
	 */
	this.getPeerInfor = function(data)
	{	
		_this.m_peerNEID = data.getDataRowParam(0, "peerNEID");
		_this.m_peerRealNEID = data.getDataRowParam(0, "peerRealNEID");
		_this.m_peerNEName = data.getDataRowParam(0, "peerNEName");
		_this.m_peerNEType = data.getDataRowParam(0, "peerNEType");
		_this.m_peerShelfType = data.getDataRowParam(0, "peerShelfType");		
		_this.m_peerNEUser = data.getDataRowParam(0, "peerNEUser");
		_this.m_peerNEVersion = data.getDataRowParam(0, "peerNEVersion");
		_this.m_peerNEState = data.getDataRowParam(0, "peerNEState");
		_this.m_peerIFSlotId = data.getDataRowParam(0, "peerIFSlotId");
		_this.m_peerODUSlotId = data.getDataRowParam(0, "peerODUSlotId"); 
		_this.m_peerGatewayIP = data.getDataRowParam(0, "peerGatewayIP");
		if(typeof(_this.m_peerGatewayIP) == "undefined" || _this.m_peerGatewayIP == null)
		{
			_this.m_peerGatewayIP = data.getDataRowParam(0, "peerNEIP")
		}
	}
	
	this.getPeerNEID = function()
	{
		return _this.m_peerNEID;
	}

	this.getPeerRealNEID = function()
	{
		return _this.m_peerRealNEID;
	}

	this.getPeerNEName = function()
	{
		return _this.m_peerNEName;
	}

	this.getPeerIFSlotId = function()
	{
		return _this.m_peerIFSlotId;
	}

	this.getPeerGatewayIP = function()
	{
		return _this.m_peerGatewayIP;
	}

	this.getPeerNEType = function()
	{
		return _this.m_peerNEType;
	}
	
	this.getPeerShelfType = function()
	{
		return _this.m_peerShelfType;
	}
	
	this.getPeerNEVersion = function()
	{
		return _this.m_peerNEVersion;
	}
	
	
	this.getOppositeEnd = function()
	{
		return terminalStruct.OppositeEnd;
	}
	
	this.getLocalEnd = function()
	{
		return terminalStruct.LocalEnd;
	}
	
	this.doDemo = function()
	{
		_this.m_peerNEID = 2;
		_this.m_peerNEName = "NE233";
		_this.m_peerIFSlotId = 3;
		
		
		_this.getOppositeEnd().fillFarNeAllData();
	}
	
	
	
	/**
	 *         
	 */
	this.queryLinkStatus = function(t_neid, ifslotid)
	{
		var xml = _this.createPeerXML(t_neid, ifslotid);

		urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_HOP_QUEERY_PEERNE;			//   	
		
		loadXMLdoc(urlreq, "POST", true, this.queryPeerNeCallback_forLink, t_neid, "inputdata=" + xml);
	}

	/**
	 *          
	 */
	this.queryPeerNeCallback_forLink = function(doc, param)
	{
		buttonStruct.refreshLinkButton.disabled = false;
		
		var data = EncapsulateData(doc);
		
		
		var sErrCode = data.getSErrorCode();
		

		if (sErrCode == OPERATION_SUCCESS || sErrCode == OPERATION_PART_SUCCESS)
		{
			_this.dealPeerNeCallbackWhenSuccess(data, param);
		}
		else
		{	
			_this.clearData();
			_this.getOppositeEnd().fillAllDataWhenOppositeNeNotExist();	
			isPeerNeQueryFinshed = true;
			if(isLocalQueryFinshed)
			{
				isQueryFinished = true;
				LoadingProcess.removeWaitStatus();
			}
		}
	}
	
	/**
	 *            
	 */
	this.queryRemoteNeDetailInfor = function(param, pLogicNeID, pPhyNeID, pIFSlotID)
	{
		var xml = _this.createQueryRemoteNeDetailInforXML(pLogicNeID, pPhyNeID, pIFSlotID);
		
		var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_REMOTE_NE_INFOR;
		
		loadXMLdoc(urlreq, "POST", true, _this.queryRemoteNeDetailInforCallback, param, "inputdata=" + xml);
	}
	
	/**
	 *              XML
	 */
	this.createQueryRemoteNeDetailInforXML = function(pLogicNeID, pPhyNeID, pIFSlotID)
	{
		var di = new inputxml("datainterface");
		bussiness = new tagElement("bussiness-params");
		row = new tagElement("row-params");

		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", pLogicNeID);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "peerNEID");
		param.setAttribute("value", pLogicNeID);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "peerRealNEID");
		param.setAttribute("value", pPhyNeID);
		row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name", "peerIFSlotId");
		param.setAttribute("value", pIFSlotID);
		row.appendChild(param);
		
		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);

		return di.toString();
	}
	
	/**
	 *            
	 */
	this.queryRemoteNeDetailInforCallback = function(doc, param)
	{
		var data = EncapsulateData(doc);
		
		var sErrCode = data.getSErrorCode();

		if (sErrCode == OPERATION_SUCCESS || sErrCode == OPERATION_PART_SUCCESS)
		{
			_this.setRelevantPageAccordingToNeType(data);
			zrecuise(param, data);

		}
		else
		{
			_this.clearData();
			_this.getOppositeEnd().fillAllDataWhenOppositeNeNotExist();
			if(isLocalQueryFinshed)
			{
				isQueryFinished = true;
				LoadingProcess.removeWaitStatus();
			}
		}
	}
	
	/**
	 *                  
	 */
	this.afterGetRemoteNeDetailInfor = function(param, data)
	{
		_this.getPeerInfor(data);
		
		isPeerNeQueryFinshed = true;		
		
		var nearfarendDetector = new NearFarEndDetectorModule();
		nearfarendDetector.queryNearFarEndFlag(param, _this.m_peerNEID);
		
		_this.getOppositeEnd().fillFarNeAllData();
	}
	
}

/**
 *              ,            
 * @param param
 * @param data
 */
function zrecuise(param, data)
{
	try
	{		
		if((!peerNESearchModule.getOppositeEnd().$  || (typeof(peerNESearchModule.getOppositeEnd().$) != 'function')) ||
			peerNESearchModule.getOppositeEnd().$("ifoduImage") == null || 
		    peerNESearchModule.getOppositeEnd().isPageCompletelyLoaded == false )	
		{
			setTimeout(function(){zrecuise(param, data);},1000);
		}
		else
		{
			peerNESearchModule.afterGetRemoteNeDetailInfor(param, data);
		}
	}
	catch(e)
	{	
		writeJSLog(e);
		setTimeout(function(){zrecuise(param, data);},1000);
	}
}

function writeJSLog(e)
{
	var xmlstr = createErrorInfo(e.message, e.fileName, e.lineNumber);
	var urlreq = "../../../../jsLogServlet?timeStamp=" + new Date().getTime();
	loadXMLdoc(urlreq, "POST", true, handleJSLogCallback, null, "inputdata=" + xmlstr);
	return true;
}

function handleJSLogCallback()
{
}
