var neobject = getNeProperty(parent);
var neid = neobject.neid;			//  ID
var neType = neobject.neType;		//    
var shelfType = neobject.shelfType;	//    
var neVersion = neobject.neversion;	//    
var nmUser = neobject.nmUser;		//    

var defaultSlotId = neobject.linkslotid;		//      

var terminalType = TERMINAL_TYPE.LOCAL_END;
parent.terminalStruct.LocalEnd = this;


/**
 *     
 * @return
 */
function init()
{
	bindModules();

	initUI();
	
	fillNearNeAllData();
}

/**
 *        
 */
function fillNearNeAllData()
{
	
	$("isFarEndSpanEleTag").innerText = RESOURCE["farendflag"];
	
	refreshNeDescription();
	
	ifBdSelectModule.queryIFODUBdList();
}

function doSomethingAfterQueryIFODUBdList()
{
	basicParamModule.initBasicParamFieldOptions();
	basicParamModule_xpic.initBasicParamFieldOptions();
	ifAttriModule.initIfAttriFieldOptions();
	rfAttriModule.initRfAttriFieldOptions();
	
	if( defaultSlotId != null && "" != defaultSlotId )
	{
		if( neobject.sysStatus == "independent" )
		{
			$("ifoduboardEle").disabled = true;
		}
		$("ifoduboardEle").value = defaultSlotId;
		setTimeout(setDefaultBdSelectValue,1000);
	}
	else
	{
		$("ifoduboardEle").disabled = false;
	}
}

function setDefaultBdSelectValue()
{
	ifBdSelectModule.changeIFODUSelectAtomValue(defaultSlotId);
}

/**
 *       
 * @return
 */
function refreshNeDescription()
{
	var realneid = neobject.realneid;
	var nename = neobject.nename;
	var ipaddr = neobject.ipaddr;
	refreshLocalNeInfo(nename, ipaddr, realneid);
	queryNeDescription();
}

function refreshLocalNeInfo(nename, ipaddr, realneid)
{
	thisnename = nename.length > 14 ? nename.substring(0,14)+"..." : nename;
	
	var localEndTerminalShowStr = "(" + thisnename + ")";	//"/" + getExtendID(realneid) + "-" + getBaseNeid(realneid) + ")";
	
	$("localEndTerminalTag").innerText = RESOURCE["localendterminal"];
	
	$("localEndTerminalNameTag").innerText = localEndTerminalShowStr;
	
	$("localEndTerminalNameTag").title = "(" + nename + ")"; //+ "/" + getExtendID(realneid) + "-" + getBaseNeid(realneid) + ")";
		
	if(realneid != null)
	{
	   $("neIDinfor").innerText = "NE ID:" + getExtendID(realneid) + "-" + getBaseNeid(realneid);
	}
	
	$("neIPinfor").innerText = "IP:" + ipaddr;	
}


/**
 *       
 * @return
 */
function queryNeDescription()
{
	 var xmlstr = createQuerylocalNeInfoXML(neid);
	  var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_LOCAL_NEINFO + "&nmUser=" + nmUser;
	 loadXMLdoc(urlreq, "POST", true, queryLocalNeCallback, null, "inputdata=" + xmlstr);
}

function createQuerylocalNeInfoXML(neid)
{
	    var di = new inputxml("datainterface");
	    var bussiness = new tagElement("bussiness-params");
	    var row = new tagElement("row-params");
	    var param = new tagElement("param");
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", neid);
	    row.appendChild(param);
        bussiness.appendChild(row);
        di.getRoot().appendChild(bussiness);
        return di.toString();
}

function queryLocalNeCallback(doc)
{
	 var data = EncapsulateData(doc);
     var sErrCode = data.getSErrorCode();
     if (sErrCode == OPERATION_SUCCESS)
     {
    	 if(data.getDataRowLength() > 0)
    	 {    		
    		 var nename = data.getDataRowParam(0, "nename");
    		 var ipaddr = data.getDataRowParam(0, "neip"); 
    		 var realneid = data.getDataRowParam(0, "realneid");
    		 refreshLocalNeInfo(nename, ipaddr, realneid);
    	 }   	
	   
	 }
}



