var g_commonData = new CommonData();
var ifBdSelectModule = new IFODUBoardSelectModule();
var basicParamModule = new BasicParamModule();
var basicParamModule_xpic = new BasicParamXPICModule();
var ifAttriModule = new IFAttriModule();
var rfAttriModule = new RFAttriModule();
var equipInforModule = new EquipInforModule();
var peerNESearchModule = parent.peerNESearchModule;
var evtDispatchCenter = new EventDispatchCenter();
var graphPainter = new ProtectionGraphPainter();



/**
 *       
 * @return
 */
function bindModules()
{
	ifBdSelectModule.addListener(evtDispatchCenter);

	basicParamModule.addListener(evtDispatchCenter);
	basicParamModule_xpic.addListener(evtDispatchCenter);
	
	basicParamModule.addListener(parent.unionDispatchCenter);
	basicParamModule_xpic.addListener(parent.unionDispatchCenter);
	ifAttriModule.addListener(parent.unionDispatchCenter);
	rfAttriModule.addListener(parent.unionDispatchCenter);
	equipInforModule.addListener(parent.unionDispatchCenter);
}

/**
 *          
 * @return
 */
function initUI()
{
	ifBdSelectModule.initCurrentDomain();
	basicParamModule.initCurrentDomain();	//       
	basicParamModule_xpic.initCurrentDomain();	//   XPIC
	ifAttriModule.initCurrentDomain();		//       
	rfAttriModule.initCurrentDomain();		//       
	equipInforModule.initCurrentDomain();	//       
	
	/*$("risking_notice_1plus1").innerText = RESOURCE["DELETE_1PLUS1_RPOTECTION_ALARM"];
	$("risking_notice_xpic").innerText = RESOURCE["DELETE_XPIC_RPOTECTION_ALARM"];*/
}

/**
 *              BasicField, IF Attri, RF Attri, Equiq Infor
 * @return
 */
function queryAllAttributes()
{
	$("if1plus1").disabled = false;
	$("enablexpicEle").disabled = false;
	ifAttriModule.init();
	rfAttriModule.init();
	equipInforModule.init();
	/**
	 *     1+1   XPIC  
	 */
	queryNeInformation();

}

/**
 *     1+1   XPIC  
 * @return
 */
function queryNeInformation()
{
	basicParamModule.queryNeInformation();
	
}

function queryNeInformation_Xpic(dataArray)	//xpic
{
	basicParamModule_xpic.queryNeInformation(dataArray);
}

/**
 *            
 */
function refreshUnEditableParams()
{
	
	if(!parent.isQueryFinished)
	{
		return;
	}
	
    if(terminalType == TERMINAL_TYPE.LOCAL_END)
    {
	    if(!parent.isLocalInterTaskFinshed)
	    {
	    	return; 
	    }
    	parent.isLocalInterTaskFinshed = false;
    }
    
    if(terminalType == TERMINAL_TYPE.OPPOSITE_END)
    {
    	 if(!parent.isRemoteInterTaskFinshed)
		 {
		    	return; 
		 }
    	parent.isRemoteInterTaskFinshed = false;
    }	    
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_RTN_QUERY_IFODUINFO + "&nmUser="+ nmUser;

	var xmlstr = getQueryBoardInforXml(1);
	
	loadXMLdoc(urlreq, "POST", true, refreshUnEditableParamsCallback, null, "inputdata=" + xmlstr);
}

/**
 *                   
 */
function refreshUnEditableParamsCallback(doc)
{
	if(terminalType == TERMINAL_TYPE.LOCAL_END)
    {	 
    	parent.isLocalInterTaskFinshed = true;
    }
    
    if(terminalType == TERMINAL_TYPE.OPPOSITE_END)
    {    	
    	parent.isRemoteInterTaskFinshed = true;
    }
	
	var data = EncapsulateData(doc);
	
    if( data.getSErrorCode() == OPERATION_FAIL )
    {
    	return;
    }
    var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
    var curSelectedIFBoard = ifSlotId;
	for( var i = 0; i < data.getDataRowLength(); i++ )
	{
		var slotId = data.getDataRowParam(i, "slotid");

		if( curSelectedIFBoard == slotId )
		{
			var recRadioLinkID = data.getDataRowParam(i, "W32PORT_ATTR_RECRADIOLINKID");
		    $("revLinkEle").value = HopTookit.replaceNegativeWithEmptyStr(recRadioLinkID);
		    
			var ethBandLow = data.getDataRowParam(i, "ethband");
			var ethBandHigh = data.getDataRowParam(i, "ethbandHigh");
			if( ethBandHigh != null && ethBandHigh != "" )
			{
				$("ethBandEle").value = ethBandLow + "-" + ethBandHigh;
			}
			else
			{
				$("ethBandEle").value = ethBandLow;
			}
			var data_actSendMode = data.getDataRowParam(i, "W32PORT_ATTR_SENDMODID");
			var data_actReceiveMode = data.getDataRowParam(i, "W32PORT_ATTR_RECEIVEMODID");
			if(typeof(data_actSendMode) != "undefined"
				&& typeof(data_actReceiveMode) != "undefined")
			{
				$("actSendModeEle").value = typeof(ensureCalModeDynStru[data_actSendMode]) == "undefined"?VALID_SHOWVAL:ensureCalModeDynStru[data_actSendMode];
				$("actReceiveModeEle").value = typeof(ensureCalModeDynStru[data_actReceiveMode]) == "undefined"?VALID_SHOWVAL:ensureCalModeDynStru[data_actReceiveMode];
			}
		}
		else
		{
			refreshRFAttriUneditElemnts(curSelectedIFBoard, slotId, data, i);
		    
			refreshEquipInforUneditElemnts(curSelectedIFBoard, slotId, data, i);
		
		}
	}
}

function refreshEquipInforUneditElemnts(curSelectedIFBoard, slotId, data, rowIndex)
{
	  var relatedODUId = g_commonData.getRelatedODUSlotId(curSelectedIFBoard)
	   if( relatedODUId == slotId)
		{  
			var frequency = data.getDataRowParam(rowIndex, "W32BRD_ATTR_FREQUENCY");
			if (frequency !=-1)
			{
			   $("freqEle").value = frequency;
			}
		    var hlStationVar = data.getDataRowParam(rowIndex, "W32BRD_ATTR_HLSTATION");
		    if (hlStationVar !=-1)
		    {
		    	$("stationTypeEle").value = hlStation[hlStationVar];
		    	EquipInforCache["stationTypeEle"] = hlStationVar;
		    }
		    var powerOutput = data.getDataRowParam(rowIndex, "W32BRD_ATTR_POWEROUTPUT");
		    if (powerOutput !=-1)
		    {
		      $("oduTypeEle").value = powerGrade[powerOutput];
		    }
		    var quipTypeVar = data.getDataRowParam(rowIndex, "W32BRD_ATTR_QUIPTYPE");
		    if (quipTypeVar!=-1)
		    {
		       $("equiqTypeEle").value = quipType[quipTypeVar];
		    }
		    var produceSN = data.getDataRowParam(rowIndex, "W32BRD_ATTR_PRODUCESN");
		    var factoryCodeValue = data.getDataRowParam(rowIndex, "W32BRD_ATTR_FACTORYCODE");
		    if (produceSN!=-1)
		    {
				if (factoryCodeValue == null)
				{
		       		$("oduSnEle").value = produceSN;
				}
				else
				{
			  		$("oduSnEle").value = produceSN + "-" + factoryCodeValue;
				}
		    }
		}
}
function refreshRFAttriUneditElemnts(curSelectedIFBoard, slotId, data, rowIndex)
{	
	 var relatedODUId = g_commonData.getRelatedODUSlotId(curSelectedIFBoard)
	  
	 var ifF1p1GroupExisted = g_commonData.isRelatedIF1Plus1GroupExist();
	 var ifxpicGroupExisted = g_commonData.isRelatedIXpicGroupExist();
	  if(ifF1p1GroupExisted)
	  {	  
		  var relatedProtectODUId = get1plusODUProtectBoard();
		  var relatedWorkODUId = get1plusODUWorkBoard();
		  if(relatedProtectODUId == slotId)
		  {
			  var isMainColumn = false;				 
			  updateRFAttriElements(isMainColumn, data, rowIndex);		    
			
		  }
		  if(relatedWorkODUId == slotId)
		  {
			   var isMainColumn = true;			  
			   updateRFAttriElements(isMainColumn, data, rowIndex);		 
		  }			  
		 
	  }
	  
	  else if(ifxpicGroupExisted)
	  {
		  var relatedProtectODUId = getxpicODUProtectBoard();
		  var relatedWorkODUId = getxpicODUWorkBoard();
		  if(relatedProtectODUId == slotId)
		  {
			   var isMainColumn = false;				 
			   updateRFAttriElements(isMainColumn, data, rowIndex);	 
		  }
		  if(relatedWorkODUId == slotId)
		  {
			  var isMainColumn = true;
			  updateRFAttriElements(isMainColumn, data, rowIndex);	
		  }				  
	  }		 
	  else
	  {
		  if( relatedODUId == slotId)
		  {  
		      var isMainColumn = true;
		      updateRFAttriElements(isMainColumn, data, rowIndex);	
		  }	  		  
	  }	
}
function updateRFAttriElements(isMainColumn, data, rowIndex)
{
	var rxfreVal = data.getDataRowParam(rowIndex, "W32BRD_ATTR_ACTTRECEIVEFRE");
	var rxpwVal = data.getDataRowParam(rowIndex, "W32BRD_ATTR_ACTRECEIVEPOWER");
	var actualTxPowerVal = data.getDataRowParam(rowIndex, "W32BRD_ATTR_ACTTRANSMITPOWER");
	rxfreVal = (rxfreVal && rxfreVal != "")?rxfreVal:VALID_SHOWVAL;
	rxpwVal = (rxpwVal && rxpwVal != "")?rxpwVal:VALID_SHOWVAL;
	actualTxPowerVal = (actualTxPowerVal && actualTxPowerVal != "")?actualTxPowerVal:VALID_SHOWVAL;
	if(isMainColumn)
	{
		 rfAttriModule.getRfElement("rxfreEle", isMainColumn).value = rxfreVal;	
	     rfAttriModule.getRfElement("rxpwEle", isMainColumn).value = rxpwVal;
	     rfAttriModule.getRfElement("actualsendpwEle", isMainColumn).value = actualTxPowerVal;
		 rfAttriModule.getRfElement("odurslspan", isMainColumn).innerText = RECEIVEPOWER_TITLE + " " + rxpwVal;
		rfAttriModule.getRfElement("odutslspan", isMainColumn).innerText = SENDPOWER_TITLE + " " + actualTxPowerVal;
	}
	else
	{
		var txfreVal = data.getDataRowParam(rowIndex, "W32BRD_ATTR_TRANSMITFRE");
		var trspaceVal = data.getDataRowParam(rowIndex, "W32BRD_ATTR_TRINTERVAL");
		var sendpwVal = data.getDataRowParam(rowIndex, "W32BRD_ATTR_TRANSMITPOWER");
		var repwVal = data.getDataRowParam(rowIndex, "W32BRD_ATTR_RECEIVEPOWER");	//power to be received
		
		if( rfAttriModule.getRfElement("txfreEle", isMainColumn).disabled )
		{
			rfAttriModule.getRfElement("txfreEle", isMainColumn).value = txfreVal;
		}
		if( rfAttriModule.getRfElement("rxfreEle", isMainColumn).disabled )
		{
			rfAttriModule.getRfElement("rxfreEle", isMainColumn).value = rxfreVal;
		}
		if( rfAttriModule.getRfElement("trspaceEle", isMainColumn).disabled )
		{
			rfAttriModule.getRfElement("trspaceEle", isMainColumn).value = trspaceVal;
		}
		if( rfAttriModule.getRfElement("sendpwEle", isMainColumn).disabled )
		{
			rfAttriModule.getRfElement("sendpwEle", isMainColumn).value = sendpwVal;
		}
		if( rfAttriModule.getRfElement("repwEle", isMainColumn).disabled )
		{
			rfAttriModule.getRfElement("repwEle", isMainColumn).value = repwVal;
		}
		if( rfAttriModule.getRfElement("rxpwEle", isMainColumn).disabled )
		{
			rfAttriModule.getRfElement("rxpwEle", isMainColumn).value = rxpwVal;
		}
		if( rfAttriModule.getRfElement("actualsendpwEle", isMainColumn).disabled )
		{
			rfAttriModule.getRfElement("actualsendpwEle", isMainColumn).value = actualTxPowerVal;
		}
		rfAttriModule.getRfElement("odurslspan", isMainColumn).innerText = RECEIVEPOWER_TITLE + " " + rxpwVal;
		rfAttriModule.getRfElement("odutslspan", isMainColumn).innerText = SENDPOWER_TITLE + " " + actualTxPowerVal;
	}
}
function get1plusODUProtectBoard()
{
	var protectboard = "";
	if("" != $("protectboardEle").value)
	{
		protectboard = $("protectboardEle").value;
	}
	else
	{
		if(g_commonData.getRelatedIF1Plus1Group() != null)
		{
			var if1plus1GroupObjcet  = g_commonData.getRelatedIF1Plus1Group();
			protectboard = if1plus1GroupObjcet.protectboardSlotId;
		}
	}
	
	return g_commonData.getRelatedODUSlotId(protectboard);
}
function get1plusODUWorkBoard()
{
	var workboard = "";
	
	if("" != $("workboardEle").value)
	{
		workboard = $("workboardEle").value;
	}
	else
	{
		if(g_commonData.getRelatedIF1Plus1Group() != null)
		{
			var if1plus1GroupObjcet  = g_commonData.getRelatedIF1Plus1Group();
			workboard = if1plus1GroupObjcet.workboardSlotId;
		}	
	}
	
	return g_commonData.getRelatedODUSlotId(workboard);
}
function getxpicODUProtectBoard()
{
	var protectboard = "";
	if("" != $("protectboardEle").value)
	{
		protectboard = $("protectboardEle").value;
	}
	else
	{
		if(g_commonData.getRelatedIXpicGroup() != null)
		{
			var xpicGroupObjcet  = g_commonData.getRelatedIXpicGroup();
			protectboard = xpicGroupObjcet.protectboardSlotId;
		}
	}
	
	return g_commonData.getRelatedODUSlotId(protectboard);
}
function getxpicODUWorkBoard()
{
	var workboard = "";
	
	if("" != $("workboardEle").value)
	{
		workboard = $("workboardEle").value;
	}
	else
	{
		if(g_commonData.getRelatedIXpicGroup() != null)
		{
			var xpicGroupObjcet  = g_commonData.getRelatedIXpicGroup();
			workboard = xpicGroupObjcet.workboardSlotId;
		}	
	}
	
	return g_commonData.getRelatedODUSlotId(workboard);
}
/**
 *            IF Attri RF Attri Equiq Infor
 * @return
 */
function queryBoardInformation(dataArray)
{
	ifAttriModule.clearAttriField();
	rfAttriModule.clearAttriField();
	equipInforModule.clearAttriField();
	
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_RTN_QUERY_IFODUINFO + "&nmUser="+ nmUser;

	var xmlstr = getQueryBoardInforXml();//          XPIC     ODU        
	
	loadXMLdoc(urlreq, "POST", true, queryBoardInformationCallback, dataArray, "inputdata=" + xmlstr);
}


/**
 *              
 */
function queryIFSpecialInfomation()
{
	querySpecialInformation(true,false,false);
}

/**
 *              
 */
function queryRFSpecialInfomation()
{
	querySpecialInformation(false,true,false);
}

/**
 *              
 *                           
 */
function queryEquipSpecialInfomation()
{
	querySpecialInformation(false,false,true);
}

function querySpecialInformation(isQueryIF,isQueryRF,isQueryEquip)
{
	parent.LoadingProcess.showWaitStatus("../../../../images/", RESOURCE["loadingtitle"]);
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_RTN_QUERY_IFODUINFO + "&nmUser="+ nmUser;

	var slotIdArray = getCommonQueryBoardArray();

	var xmlstr = createSpecialQueryXML(neid, slotIdArray, isQueryIF,isQueryRF,isQueryEquip);
	
	loadXMLdoc(urlreq, "POST", true, querySpecialInfomationCallBack,[isQueryIF,isQueryRF,isQueryEquip], "inputdata=" + xmlstr);
}

/**
 *           
 */
function querySpecialStart()
{
	parent.isLocalQueryFinshed = false;
	parent.isOppositeQueryFinshed = false;
	parent.isQueryFinished = false;
	parent.lastApplyBtnStatus = parent.buttonStruct.applyButton.disabled;
	parent.querydataArray.clear();
}


/**
 *            
 * @param {Object} doc
 * @param {Object} params 0=  ,1=  ,2=  
 */
function querySpecialInfomationCallBack(doc, params)
{
    var data = EncapsulateData(doc);
    var isQueryIF = params[0];
    var isQueryRF = params[1];
    var isQueryEquip = params[2];
    try 
    {
        if (isQueryIF) 
        {
            ifAttriModule.queryCallback(data);
        }
        if (isQueryRF) 
        {
            rfAttriModule.queryCallback(data);
        }
        if (isQueryEquip) 
        {
            equipInforModule.queryCallback(data);
        }
    } 
    catch (e) 
    {
    }
	
	refreshQueryFlagState();
	
	if (parent.isOppositeNeExist() == false) 
    {
        parent.querydataArray.clear();
        if (data.getSErrorCode() != OPERATION_SUCCESS) 
        {
			parent.buttonStruct.applyButton.disabled = parent.lastApplyBtnStatus;
            HopTookit.showErrorDialog(data);
            return;
        }
    }
	else
	{
		parent.querydataArray.push(data);
		if(parent.querydataArray.length > 1)
		{
			parent.buttonStruct.applyButton.disabled = parent.lastApplyBtnStatus;
			showMergedError(parent.querydataArray);
			parent.querydataArray.clear();
		}
	}
    
}

function refreshQueryFlagState()
{
    if (terminalType == TERMINAL_TYPE.LOCAL_END) 
    {
        parent.isLocalQueryFinshed = true;
    }
    
    if (terminalType == TERMINAL_TYPE.OPPOSITE_END) 
    {
        parent.isOppositeQueryFinshed = true;
    }
    if (parent.isPeerNeQueryFinshed) 
    {
        if (!parent.isOppositeNeExist() && parent.isLocalQueryFinshed) 
        {
            parent.LoadingProcess.removeWaitStatus();
            parent.isQueryFinished = true;
        }
    }
    if (parent.isLocalQueryFinshed && parent.isOppositeQueryFinshed) 
    {
        parent.LoadingProcess.removeWaitStatus();
        parent.isQueryFinished = true;
    }
}



/**
 *               
 * @param doc
 * @return
 */
function queryBoardInformationCallback(doc, dataArray)
{
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() != OPERATION_SUCCESS) 
    {
        dataArray.push(data);
    }
    try 
    {
        ifAttriModule.queryCallback(data);
        rfAttriModule.queryCallback(data);
        equipInforModule.queryCallback(data);
        parent.buttonStruct.applyButton.disabled = true;
    } 
    catch (e) 
    {
    }
    
    refreshQueryFlagState();
	if (parent.isOppositeNeExist() == false) 
    {
        parent.querydataArray.clear();
		showMergedError(dataArray);
    }
	else
	{
		parent.querydataArray.push(mergeDataArrayError(dataArray));
		if(parent.querydataArray.length > 1)
		{
			showMergedError(parent.querydataArray);
			parent.querydataArray.clear();
		}
	}
}

function queryTheOtherBoardInfoCallBack(doc)
{
}

/**
 *           ,        
 * @param {Object} dataArray
 */
function mergeDataArrayError(dataArray)
{
	for( var i = dataArray.length - 1; i >= 0; i-- )
	{
		if(dataArray[i] == null || dataArray[i].getSErrorCode() == OPERATION_SUCCESS )
		{
			dataArray.removeAt(i);
		}
	}
	if( dataArray.length == 0 )
	{
		return null;
	}
	var baseData = dataArray[0];
	for( var i = 1; i < dataArray.length; i++ )
	{
		mergeErrorData(baseData, dataArray[i]);
	}
	return baseData;
}

/**
 *         
 * @param dataArray
 * @return
 */
function showMergedError(dataArray)
{
	for( var i = dataArray.length - 1; i >= 0; i-- )
	{
		if(dataArray[i] == null || dataArray[i].getSErrorCode() == OPERATION_SUCCESS )
		{
			dataArray.removeAt(i);
		}
	}
	
	if( dataArray.length == 0 )
	{
		return;
	}
	else if( dataArray.length == 1 )
	{
		HopTookit.showErrorDialog(dataArray[0]);
		return;
	}
	else
	{
		var baseData = dataArray[0];
		for( var i = 1; i < dataArray.length; i++ )
		{
			mergeErrorData(baseData, dataArray[i]);
		}
		HopTookit.showErrorDialog(baseData);
	}
}

/**
 *         
 * @param dataArray
 * @return
 */
function showMergedApplyError(dataArray)
{
	for( var i = dataArray.length - 1; i >= 0; i-- )
	{
		if( dataArray[i].getSErrorCode() == OPERATION_SUCCESS )
		{
			dataArray.removeAt(i);
		}
	}
	
	if( dataArray.length == 0 )
	{
		return;
	}
	else if( dataArray.length == 1 )
	{
		HopTookit.showApplyErrorDialog(dataArray[0]);
		return;
	}
	else
	{
		var baseData = dataArray[0];
		for( var i = 1; i < dataArray.length; i++ )
		{
			mergeErrorData(baseData, dataArray[i]);
		}
		HopTookit.showApplyErrorDialog(baseData);
	}
}

/**
 *      
 */
function mergeErrorData(baseData, tmpData)
{
	for( var i = 0 ; i < tmpData.errObj.rowErrors.length; i++ )
	{
		baseData.errObj.rowErrors[baseData.errObj.rowErrors.length] = tmpData.errObj.rowErrors[i]; 
	}
}

/**
 *                        
 * @return
 */
function isAnyElementModified()
{
	var result = false;
	
	var neAttributeModifyFlag = isAnyElementInNeAttriFieldModified();
	var boardAttriFiledModifyFlag = isAnyElementInBoardAttriFieldModified();
	
	if( neAttributeModifyFlag == true || boardAttriFiledModifyFlag == true )
	{
		result = true;
	}

	return result;
}

/**
 *                 
 * @return
 */
function isAnyElementInNeAttriFieldModified()
{
	var result = ( basicParamModule.isAnyElementInBasicParamFieldModified() ||
				 basicParamModule_xpic.isAnyElementInBasicParamFieldModified() ) == true ? 
				 true : false;
	
	return result;
}

/**
 * IF RF EQUIP            
 * @return
 */
function isAnyElementInBoardAttriFieldModified()
{
	var result = false;
	
	if( ifAttriModule.isAnyElementInThisAttriFieldModified() )
	{
		result = true;
	}

	if( rfAttriModule.isAnyElementInThisAttriFieldModified() )
	{
		result = true;
	}
	
	return result;
}

/**
 *           
 * @return
 */
function applyAllAttributes(syncFlg, delayTime)
{
	var if1plus1OperationType = NEOPERATION_TYPE.DONOTING;
	
	var xpicOperationType = NEOPERATION_TYPE.DONOTING;
	
	if( basicParamModule.isAnyElementInBasicParamFieldModified() == true )
	{
		if1plus1OperationType = basicParamModule.getApplyOperationType();
	}
	
	if( basicParamModule_xpic.isAnyElementInBasicParamFieldModified() == true )
	{
		xpicOperationType = basicParamModule_xpic.getApplyOperationType();
	}
	
	if (if1plus1OperationType== NEOPERATION_TYPE.RECREATE 
			|| xpicOperationType == NEOPERATION_TYPE.RECREATE)
	{
		if (!confirm(RESOURCE["delete_and_recreate1plus1_notice"]))
		{
			return;
		}
	}

	var if1plus1Oper = new OperationStateMapping();
	if1plus1Oper.init(basicParamModule, if1plus1OperationType);
	
	var xpicOper = new OperationStateMapping();
	xpicOper.init(basicParamModule_xpic, xpicOperationType);
	
	var operExecutor = new OperationExecutor(); 
	operExecutor.excuteOperations(if1plus1Oper, xpicOper);

	if( isAnyElementInBoardAttriFieldModified() == true )
	{
	        if(delayTime > 0)
	        {
		    window.setTimeout("applyBoardInformation('" + syncFlg +"')", delayTime);
		} else {
		    applyBoardInformation(syncFlg)
		}
	} else {
	    parent.closeWindowFlg = syncFlg;
	}
}

/**
 *         
 * @return
 */
function applyBoardInformation(syncFlg)
{
	parent.LoadingProcess.removeWaitStatus();
	parent.LoadingProcess.showWaitStatus("../../../../images/",RESOURCE["loadingtitle"]);
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_RTN_APPLY_IFODUINFO + "&nmUser="+ nmUser;
	
	var xmlstr = createAllBoardConfigurationXml();

	loadXMLdoc(urlreq, "POST", syncFlg, applyAllAttributesCallback, syncFlg, "inputdata=" + xmlstr);
}

/**
 *        1Plus1   XPIC      
 * @return
 */
function createAllBoardConfigurationXml()
{
	var if1plus1protectgroupFlag = g_commonData.isRelatedIF1Plus1GroupExist();
	var xpicprotectgroupFlag = g_commonData.isRelatedIXpicGroupExist();
	
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");

    createIFBoardConfigurationXml(bussiness);
    
    createIF1Plus1ProtectionBoardConfigurationXml(bussiness, if1plus1protectgroupFlag);
    
    createXpicProtectionBoardConfigurationXml(bussiness, xpicprotectgroupFlag);
    
    var row = new tagElement("row-params");
	HopTookit.addParam(row, "neid", neid);
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	HopTookit.addParam(row, "slotid", ifSlotId);
	HopTookit.addParam(row, "port", "1");
	bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function createIFBoardConfigurationXml(bussiness)
{
    var row = new tagElement("row-params");
	
	HopTookit.addParam(row, "neid", neid);
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	HopTookit.addParam(row, "slotid", ifSlotId);
    
	HopTookit.addParam(row, "port", "1");

	var isIFModified = ifAttriModule.createIFAttriFieldApplyXML(neid, row);
	if( isIFModified == true )
	{
		bussiness.appendChild(row);
	}
}

function createIF1Plus1ProtectionBoardConfigurationXml(bussiness, if1plus1protectgroupFlag)
{
	var row = null;
	var slotIdArray = null;
	if( if1plus1protectgroupFlag == true )
	{
		var workODUSlotId = g_commonData.getRelatedODUSlotId($("workboardEle").value);
		var protectODUSlotId = g_commonData.getRelatedODUSlotId($("protectboardEle").value);
		slotIdArray = new Array($("workboardEle").value, $("protectboardEle").value);
		if($("workboardEle").value != workODUSlotId)
		{
			slotIdArray.push(workODUSlotId);
		}
		if($("protectboardEle").value != protectODUSlotId)
		{
			slotIdArray.push(protectODUSlotId);
		}
	}
	else
	{
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
		var thisODUSlotId = g_commonData.getRelatedODUSlotId(ifSlotId);
		var slotIdArray = new Array(ifSlotId);
		if(ifSlotId != thisODUSlotId)
		{
			slotIdArray.push(thisODUSlotId);
		}
	}
	for( var i = 0; i < slotIdArray.length; i++ )
	{
		row = new tagElement("row-params");
		
		HopTookit.addParam(row, "neid", neid);
	    
		HopTookit.addParam(row, "slotid", slotIdArray[i]);
	    
		HopTookit.addParam(row, "port", "1");

		var isRFModified = rfAttriModule.createRFAttriFieldApplyXml(neid, row, slotIdArray[i]);
		
		if( isRFModified == true )
		{
			bussiness.appendChild(row);
		}
	}
}

function createXpicProtectionBoardConfigurationXml(bussiness, xpicprotectgroupFlag)
{
	var row = null;
	if( xpicprotectgroupFlag == true )
	{
        var xpicslotIdArray = new Array(
        		$("hPolarBdEle").value, 
        		$("vPolarBdEle").value);
        var hODUSlotId = g_commonData.getRelatedODUSlotId($("hPolarBdEle").value);
        var vODUSlotId = g_commonData.getRelatedODUSlotId($("vPolarBdEle").value);
		if($("hPolarBdEle").value != hODUSlotId)
		{
			xpicslotIdArray.push(hODUSlotId);
		}
		if($("vPolarBdEle").value != vODUSlotId)
		{
			xpicslotIdArray.push(vODUSlotId);
		}
	    for( var i = 0; i < xpicslotIdArray.length; i++ )
	    {
	    	row = new tagElement("row-params");
	    	
	    	HopTookit.addParam(row, "neid", neid);
	        
	    	HopTookit.addParam(row, "slotid", xpicslotIdArray[i]);
	        
	    	HopTookit.addParam(row, "port", "1");
	        
	        var isIFXpicModified = ifAttriModule.createXpicIFAttriFieldApplyXML(neid, row, xpicslotIdArray[i]);
	
	        var isRFXpicModified = rfAttriModule.createXpicRFAttriFieldApplyXml(neid, row, xpicslotIdArray[i]);
	        
	        if( isIFXpicModified == true || isRFXpicModified == true )
	        {
	        	bussiness.appendChild(row);
	        }
	    }
	}
}


/**
 *        
 * @param doc
 * @return
 */
function applyAllAttributesCallback(doc, param)
{
	parent.LoadingProcess.removeWaitStatus();
    parent.closeWindowFlg = param;
    
    var data = EncapsulateData(doc);    

    if( data.getSErrorCode() == OPERATION_SUCCESS )
    {
    	if(ifAttriModule.isNeedApplyRrefreshCache())    	
    	{
    		 ifAttriModule.refreshCache();
    		 ifAttriModule.clearAttriFieldBgColor();
    	}
       
        rfAttriModule.refreshCache();
      
        rfAttriModule.clearAttriFieldBgColor();
    }
    
    
    if (parent.isOppositeNeExist() == false) 
    {
        parent.apllydataArray.clear();
        if (data.getSErrorCode() != OPERATION_SUCCESS) 
        {
            HopTookit.showApplyErrorDialog(data);
            return;
        }
    }
	else
	{
		parent.apllydataArray.push(data);
		
		if(parent.apllydataArray.length > 1)
		{			
			showMergedApplyError(parent.apllydataArray);
			parent.apllydataArray.clear();
		}
	}
   if(data.getSErrorCode() == OPERATION_FAIL || data.getSErrorCode() == OPERATION_PART_SUCCESS)
   {  
   	 return;
   }
}


/**
 *          XML        
 * @param {Object} neid
 * @param {Object} slotIdArray
 * @param {Object} isQueryIF
 * @param {Object} isQueryRF
 */
function createSpecialQueryXML(neid, slotIdArray,isQueryIF,isQueryRF,isQueryEquip)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null; 
    if( slotIdArray )		//      
    {
	    for( var i = 0; i < slotIdArray.length; i++ )
	    {
	    	if("" == slotIdArray[i])
	    	{	  
	    		continue;
	    	}	    	
	        row = new tagElement("row-params");
	        
	        HopTookit.addParam(row, "neid", neid);
	        
	        HopTookit.addParam(row, "slotid", slotIdArray[i]);
	        
	        HopTookit.addParam(row, "port", "1");
			
			HopTookit.addParam(row, "isQueryIF", isQueryIF);
			HopTookit.addParam(row, "isQueryRF", isQueryRF);
			
			HopTookit.addParam(row, "isQueryEquip", isQueryEquip);
	        HopTookit.addParam(row, "isLogFlag", 0);
	        
	        bussiness.appendChild(row);
	    }
    }
	di.getRoot().appendChild(bussiness);
    
    return di.toString();
}


/**
 * 
 * @param neid
 * @param ifslotid
 * @param oduslotid             ODU     
 * @param anotheroduslotid    1+1                       ODU     
 * @return
 */
function createCommonQueryXML(neid, slotIdArray, flag)
{
	var isRefresh = 0;
	var islog = 1; 
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null; 
    
    if( slotIdArray )		//      
    {
	    for( var i = 0; i < slotIdArray.length; i++ )
	    {
	    	if("" == slotIdArray[i])
	    	{	  
	    		continue;
	    	}	    	
	        row = new tagElement("row-params");
	        
	        HopTookit.addParam(row, "neid", neid);
	        
	        HopTookit.addParam(row, "slotid", slotIdArray[i]);
	        
	        HopTookit.addParam(row, "port", "1");
	        
	        /**
	         *  flag 1                 
	         */
	        if (flag == 1)
	        {
	        	isRefresh = flag;
	        	islog = 0;
	        }
	        HopTookit.addParam(row, "isRefreshUnEditable", isRefresh);
			HopTookit.addParam(row, "isQueryIF", ($("IFParamField").style.display != "none"));
			HopTookit.addParam(row, "isQueryRF", ($("RFParamField").style.display != "none"));
			
			HopTookit.addParam(row, "isQueryEquip", ($("equiqInforField").style.display != "none"));
	        HopTookit.addParam(row, "isLogFlag", islog);
	        
	        bussiness.appendChild(row);
	    }
    }
    else					//      
    {
        row = new tagElement("row-params");
        HopTookit.addParam(row, "neid", neid);
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function getCommonQueryBoardArray()
{
	var slotIdArray = null;
	var if1plus1protectgroupFlag = g_commonData.isRelatedIF1Plus1GroupExist();
	
	if( if1plus1protectgroupFlag == true )
	{
		var workODUSlotId = g_commonData.getRelatedODUSlotId($("workboardEle").value);
		var protectODUSlotId = g_commonData.getRelatedODUSlotId($("protectboardEle").value);
		slotIdArray = new Array($("workboardEle").value);
		if($("workboardEle").value != workODUSlotId)
		{
			slotIdArray.push(workODUSlotId);
		}
		slotIdArray.push($("protectboardEle").value);
		if($("protectboardEle").value != protectODUSlotId)
		{
			slotIdArray.push(protectODUSlotId);
		}
	}
	else
	{
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
		var thisODUSlotId = g_commonData.getRelatedODUSlotId(ifSlotId);
		slotIdArray = new Array(ifSlotId);
		if(ifSlotId != thisODUSlotId)
		{
			slotIdArray.push(thisODUSlotId);
		}
	}
	return slotIdArray;
}

function getQueryBoardInforXml(flag)
{
	var xmlstr = null;
	var slotIdArray = getCommonQueryBoardArray();
	
	xmlstr = createCommonQueryXML(neid, slotIdArray, flag);
	
	return xmlstr;
}

/**
 *   validate.js                
 * @param obj
 * @return
 */
function doSomethingIfObjDataChanged(obj)
{
	HopTookit.setElementModified(obj);
	if( obj.onchange )
	{
		obj.onchange();
	}
}

/**
 *     
 * @return
 */
function adjustCellWidth()
{
	$("oduNameTD").width = 130;
	$("txfreTD").width = 130;
	$("rxfreTD").width = 130;
	$("trspaceTD").width = 130;
	$("atpcenableTD").width = 130;
	
	$("atpcUpperThresTD").width = 130;
	$("atpcLowerThresTD").width = 130;
	$("sendpwTD").width = 130;
	$("repwTD").width = 130;
	$("rxpwTD").width = 130;
	
	$("repw_vTD").width = 130;
	$("rxpw_vTD").width = 130;
	$("repw_hTD").width = 130;
	$("rxpw_hTD").width = 130;
	$("odustaTD").width = 130;
}

/**
 **                   
 **
 **/
/**function queryAllIFBoardsServiceCapacity()
{
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_GET_ALLIFBOARDS_SERVICE_CAPACITY + "&nmUser="+ nmUser;

    var xmlstr = createCommonQueryXML(neid);
		
    loadXMLdoc(urlreq, "POST", true, initCapacityMap, false, "inputdata=" + xmlstr);
}**/

/**
 **             7M: 1,QPSK,10M% 2,16QAM, 20M% 3,32QAM, 25M% 4,64QAM, 32M% 5,128QAM, 38M% 6,256QAM, 44M;14M: 1,QPSK,10M% 2,16QAM, 20M% 3,32QAM, 25M% 4,64QAM, 32M% 5,128QAM, 38M% 6,256QAM, 44M
 **       ';'               :                                                             %    
 **/
function parseBandWidthAndCapacity(str)
{    
    var arr1, arr2, arr3, modeObj;
    
    arr1 = str.split(';');
    for(var i = 0, iLen = arr1.length; i < iLen; i++)
    {
        arr2 = arr1[i].split(':');
        
        if(arr1[i].trim().length <= 0)
        {
            continue;
        }
        
        var bandWidth;
        switch(arr2[0].trim())
        {
        	case '3.5M':
        		bandWidth = bandWidthStru.FREQ_3_5MHz_VAL;
        		break;
            case '7M':
                bandWidth = bandWidthStru.FREQ_7MHz_VAL;
                break;
            case '14M':
                bandWidth = bandWidthStru.FREQ_14MHz_VAL;
                break;
            case '28M':
                bandWidth = bandWidthStru.FREQ_28MHz_VAL;
                break;
            case '40M':
                bandWidth = bandWidthStru.FREQ_40MHz_VAL;
                break;
            case '56M':
                bandWidth = bandWidthStru.FREQ_56MHz_VAL;
                break;  
            case 'FCC30M':
                bandWidth = bandWidthStru.FREQ_30MHz_VAL_NA;
                break;  
            case 'FCC40M':
                bandWidth = bandWidthStru.FREQ_40MHz_VAL_NA;
                break;  
            case 'FCC50M':
                bandWidth = bandWidthStru.FREQ_50MHz_VAL_NA;
                break;  
			case '250M':
				bandWidth = bandWidthStru.FREQ_250MHz_VAL;
				break;
			case '500M':
				bandWidth = bandWidthStru.FREQ_500MHz_VAL;
				break;
			case '750M':
				bandWidth = bandWidthStru.FREQ_750MHz_VAL;
				break;
			case '125M':
				bandWidth = bandWidthStru.FREQ_125MHz_VAL;
				break;
        }
        
        if(arr2.length < 2)
        {
        	return;
        }
        
        arr2 = arr2[1].trim().split('%')
        
        modeObj = new Object();
        var text;
        for(var j = 0, jLen = arr2.length; j < jLen; j++)
        {
            arr3 = arr2[j].trim().split(',');
            if(arr3.length < 3)
            {
            	continue;
            }
            var caseStr = arr3[1].trim().toUpperCase();
            var modeArray = [];
            switch(caseStr)
            {
                case 'QPSK':
                    text = "QPSK/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_QPSK = text;
                    modeObj.MODE_QPSK_VAL = '1';
                    modeObj["1"] = text;
                    break;
                case '16QAM':
                    text = "16QAM/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_16QAM = text;
                    modeObj.MODE_16QAM_VAL = '2';
                    modeObj["2"] = text;
                    break;
                case '32QAM':
                    text = "32QAM/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_32QAM = text;
                    modeObj.MODE_32QAM_VAL = '3';
                    modeObj["3"] = text;
                    break;
                case '64QAM':
                    text = "64QAM/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_64QAM = text;
                    modeObj.MODE_64QAM_VAL = '4';
                    modeObj["4"] = text;
                    break;
                case '128QAM':
                    text = "128QAM/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_128QAM = text;
                    modeObj.MODE_128QAM_VAL = '5';
                    modeObj["5"] = text;
                    break;
                case '256QAM':
                    text = "256QAM/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_256QAM = text;
                    modeObj.MODE_256QAM_VAL = '6';
                    modeObj["6"] = text;
                    break;
                case '512QAM':
                    text = "512QAM/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_512QAM = text;
                    modeObj.MODE_512QAM_VAL = '7';
                    modeObj["7"] = text;
                    break;
                case '1024QAM':
                    text = "1024QAM/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_1024QAM = text;
                    modeObj.MODE_1024QAM_VAL = '8';
                    modeObj["8"] = text;
                    break;
                case 'QPSKSTRONG':
                    text = "QPSKStrong/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_QPSKStrong = text;
                    modeObj.MODE_QPSKStrong_VAL = '9';
                    modeObj["9"] = text;
					if (bandWidth == bandWidthStru.FREQ_250MHz_VAL) 
					{
						text = "QPSKStrong_250M/" + arr3[2].trim() + 'bit/s';
						modeObj.MODE_QPSKStrong_250M = text;
						modeObj.MODE_QPSKStrong_250M_VAL = '14';
						modeObj["14"] = text;
					}
					if (bandWidth == bandWidthStru.FREQ_500MHz_VAL) 
					{
						text = "QPSKStrong_500M/" + arr3[2].trim() + 'bit/s';
						modeObj.MODE_QPSKStrong_500M = text;
						modeObj.MODE_QPSKStrong_500M_VAL = '15';
						modeObj["15"] = text;
					}
                    break;
                case '16QAMSTRONG':
                    text = "16QAMStrong/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_16QAMStrong = text;
                    modeObj.MODE_16QAMStrong_VAL = '10';
                    modeObj["10"] = text;
                    break;
                case '512QAMLIGHT':
                    text = "512QAMLight/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_512QAMLight = text;
                    modeObj.MODE_512QAMLight_VAL = '11';
                    modeObj["11"] = text;
                    break;
                case '1024QAMLIGHT':
                    text = "1024QAMLight/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_1024QAMLight = text;
                    modeObj.MODE_1024QAMLight_VAL = '12';
                    modeObj["12"] = text;
                    break;
                case '2048QAM':
                    text = "2048QAM/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_2048QAM = text;
                    modeObj.MODE_2048QAM_VAL = '13';
                    modeObj["13"] = text;
                    break;
                case 'QPSKStrong_250M':
                    text = "QPSKStrong_250M/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_QPSKStrong_250M = text;
                    modeObj.MODE_MQPSKStrong_250M_VAL = '14';
                    modeObj["14"] = text;
                    break;
                case 'QPSKStrong_500M':
                    text = "QPSKStrong_500M/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_QPSKStrong_500M = text;
                    modeObj.MODE_QPSKStrong_500M_VAL = '15';
                    modeObj["15"] = text;
                    break;
                case 'QPSKStrong_62p5M':
                    text = "QPSKStrong_62p5M/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_QPSKStrong_250M = text;
                    modeObj.MODE_MQPSKStrong_250M_VAL = '17';
                    modeObj["17"] = text;
                    break;
                case 'QPSKStrong_125M':
                    text = "QPSKStrong_125M/" + arr3[2].trim() + 'bit/s';
                    modeObj.MODE_QPSKStrong_500M = text;
                    modeObj.MODE_QPSKStrong_500M_VAL = '18';
                    modeObj["18"] = text;
                    break;
            }
        }
        
        capacityMap[bandWidth] = modeObj;
    }
 }


/**
 *          option                                     
 * @param selectObj, text, value, defaultText, defaultValue
 * @return
 */
function addModeOption(selectObj, text, value, defaultText, defaultValue)
{
    if(text)
    {
	selectObj.options[selectObj.options.length] = new Option(text, value);
    } else {
	selectObj.options[selectObj.options.length] = new Option(defaultText, defaultValue);
    }
}

/**
 *          option                                         
 * @param selectObj, text, defaultText, index
 * @return
 */
function updateModeOptionText(selectObj, text, defaultText, value)
{
    var opt;
    for(var i = 0, len = selectObj.options.length; i < len; i++)
    {
        if(selectObj.options[i].value == value) 
        {
            opt = selectObj.options[i];
            break;
        }
    }
    
    if(!opt)
    {
        return;
    }
    
    if(text && (opt.text != text))
    {
	opt.text = text;
    } else if(!text && opt.text != defaultText){
	opt.text = defaultText;
    } 
}

/**
 *   ensureCalModeDynStru  ,                  
 * @param selectObj, text, defaultText, index
 * @return
 */
function updateDynModeStruText(index, text)
{
    if(text)
    {
        ensureCalModeDynStruNew[index] = text;
    } else {
        ensureCalModeDynStruNew[index] = ensureCalModeDynStru[index];
    }
}

/**
 **       1J1                    
 **        1j1  1J0                    1j1               
 **/
function hasPBoardIFAttrChanged()
{
    if($("if1plus1").checked)
    {
        if(HopTookit.getIfoduModuleObj(ifBdSelectModule.getIFODUBoardSelectElementValue()).ifSlotId == $("protectboardEle").value && ifAttriModule.isAnyElementInThisAttriFieldModified())
        {
            return true;
        }
    }
    
    return false;
}
