
/**
 * 01.The IF Board Select Component, which is placed on the top of the page 
 * @return
 */
function IFODUBoardSelectModule()
{
	var _this = this;
	
	this.listenerList = new Array(); 
		
	this.addListener = function(obj)
	{
		_this.listenerList.push(obj);
	}
	
	this.notifyAll = function(event)
	{		
		for( var i = 0; i < _this.listenerList.length; i++ )
		{
			var obj = _this.listenerList[i];
			obj.response(event);
		}
	}
	
	/**
	 *         
	 */
	this.queryIFODUBdList = function()
	{
	    var xmlstr = createCommonQueryXML(neid);
	    var urlreq = "../../../../neExlorerServlet?sfid=" + get_iduodu_protectgroup + "&nmUser=" + nmUser;
	    loadXMLdoc(urlreq, "POST", true, _this.queryIFODUBdListCallback, null, "inputdata=" + xmlstr);
	}
	
	/**
	 *        
	 */
	this.queryIFODUBdListCallback = function(doc)
	{
		    var data = EncapsulateData(doc);		    
		   
	        var sErrCode = data.getSErrorCode();
			

        /**
         * DTS:DTS2013053003621 
         * 
         *     :              mute     RF     ,         
         *           ,                ,              ,
         *             ,               loading  
         * 
         */
	   if (sErrCode != null && sErrCode != OPERATION_SUCCESS 
		    && sErrCode != OPERATION_PART_SUCCESS && terminalType == TERMINAL_TYPE.OPPOSITE_END )
	   {
			fillAllDataWhenOppositeNeNotExist();	
			parent.isPeerNeQueryFinshed = true;
			if(parent.isLocalQueryFinshed)
			{
				parent.isQueryFinished = true;
				parent.LoadingProcess.removeWaitStatus();
			}			
		}
		else
		{
            _this.getIFODUBoardSelectElement().options.length = 0;
		    
		    HopTookit.addOptionToSelectElement(_this.getIFODUBoardSelectElement(), RESOURCE["selifbd"], "-1");//Please Select IF Board
		    
		    g_commonData.getIFODUInforArray().clear();
		    
		    for( var i = 0; i < data.getDataRowLength(); i++ )
		    {
		    	_this.addSlotToIFODUBoardSelectElement(data, i, "workingSlotId");
		    	
		    	_this.addSlotToIFODUBoardSelectElement(data, i, "protectionSlotId");
		    }
		    
		    doSomethingAfterQueryIFODUBdList();
			
		}
				
	}
	
	/**
	 *  IF             
	 */
	this.addSlotToIFODUBoardSelectElement = function(data, i, flag)
	{
		var tSlotId = data.getDataRowParam(i, flag);
		if(tSlotId==0)
		{
		  return;
	  	}
		if( !HopTookit.isDataValid(tSlotId) )
		{
			return;
		}

		var tBoardName = flag == "workingSlotId" ? "workingbdname" : "protectbdname";
		var tOduId = flag == "workingSlotId" ? "workoduid" : "protectoduid";
		var tBoardType =  flag == "workingSlotId" ? "workingbdtype" : "protectbdtype";
		
		var ifoduObj = new IFODUBoardInfoStruct();
		ifoduObj.setIFSlotId(data.getDataRowParam(i, flag));
		ifoduObj.setIFBdName(data.getDataRowParam(i, tBoardName));
		ifoduObj.setIFBdType(data.getDataRowParam(i, tBoardType));
		ifoduObj.setODUSlotId(data.getDataRowParam(i, tOduId));
		ifoduObj.setIsWork(data.getDataRowParam(i, "isWork"));
		ifoduObj.setWMode(data.getDataRowParam(i, "wMode"));
		g_commonData.getIFODUInforArray().push(ifoduObj);

		HopTookit.addOptionToSelectElement(_this.getIFODUBoardSelectElement(), ifoduObj.getIFBoardDescription(),JSON.stringify(ifoduObj));//ifoduObj.getIFSlotId()
	}
	
	/**
	 *                                       
	 */
	this.setIFODUSelectAtomEditHandler = function()
	{
		_this.getIFODUBoardSelectElement().onchange = function()
		{
			var ifbdcuevalue = this.value;
			var eleCurValue2Obj = HopTookit.getIfoduModuleObj(ifbdcuevalue);
			var eleCurValue = eleCurValue2Obj.ifSlotId;
			var bdtype = eleCurValue2Obj.ifBdType;
			
			_this.showIFODUImage(eleCurValue);
			if( HopTookit.isDataInBusinessValid(eleCurValue) )
			{
				var bdName = this.options[this.options.selectedIndex].innerText;
				bdName = bdName.toUpperCase();
				
				if (!HopTookit.isRTN900NA(neid, neType))
				{
					$("ifchannelbandwidthEle").options.length = 0;
					if( JSON.parse(this.options[this.options.selectedIndex].value).ifBdType == SHXA2 )
					{
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_7MHz, bandWidthStru.FREQ_7MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_14MHz, bandWidthStru.FREQ_14MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_28MHz, bandWidthStru.FREQ_28MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_56MHz, bandWidthStru.FREQ_56MHz_VAL);						
					}
					else if( JSON.parse(this.options[this.options.selectedIndex].value).ifBdType == SHUF3 )
					{
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_250MHz, bandWidthStru.FREQ_250MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_500MHz, bandWidthStru.FREQ_500MHz_VAL);								
					}
					else
					{
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_3_5MHz, bandWidthStru.FREQ_3_5MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_7MHz, bandWidthStru.FREQ_7MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_14MHz, bandWidthStru.FREQ_14MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_28MHz, bandWidthStru.FREQ_28MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_40MHz, bandWidthStru.FREQ_40MHz_VAL);
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_56MHz, bandWidthStru.FREQ_56MHz_VAL);	
						$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_FCC50MHz, bandWidthStru.FREQ_FCC50MHz_VAL);
						}
				}
				
				if(HopTookit.isSupportRunmode(bdtype))
				{
					$("ifrunmodeTR").style.display = ""; 
				}
				else
				{
					$("ifrunmodeTR").style.display = "none"
				}
				
				$("ifservtypeEle").options.length = 0;
				$("ifservtypeEle").options[$("ifservtypeEle").options.length] = new Option(ifServiceTypeStru.E1ETH, ifServiceTypeStru.E1ETH_VAL);
				if(HopTookit.isSupportChangeServtype(neid, eleCurValue, bdtype))
				{
					$("ifservtypeEle").options[$("ifservtypeEle").options.length] = new Option(ifServiceTypeStru.STMETH, ifServiceTypeStru.STMETH_VAL);
					$("ifservtypeEle").options[$("ifservtypeEle").options.length] = new Option(ifServiceTypeStru.SDH, ifServiceTypeStru.SDH_VAL);
				}
				
				_this.getIFODUBoardSelectElement().options.length = 0;
				var tmpArray = g_commonData.getIFODUInforArray();
				for( var i = 0; i < tmpArray.length; i++ )
				{
					var ifoduObj = tmpArray[i];
					HopTookit.addOptionToSelectElement(_this.getIFODUBoardSelectElement(), ifoduObj.getIFBoardDescription(),JSON.stringify(ifoduObj));//ifoduObj.getIFSlotId()
				}
				_this.getIFODUBoardSelectElement().value = ifbdcuevalue;
			
				$("allParamDomainDiv").style.display = "";		//       
				parent.$("buttoniframe").style.visibility = "";
				var event = new IFODUBoardSelectChangedEvent();
				
				event.initData(neid, eleCurValue);		
				
				if( terminalType == TERMINAL_TYPE.LOCAL_END )	//     
				{
					parent.isOppositeQueryFinshed = false;
					parent.isLocalQueryFinshed = false;
					parent.isPeerNeQueryFinshed = false;
					parent.isQueryFinished = false;
					parent.LoadingProcess.removeWaitStatus();
					parent.LoadingProcess.showWaitStatus("../../../../images/",RESOURCE["loadingtitle"]);	
				}			
				
				queryAllAttributes();						//              
				
				_this.notifyAll(event);		
				if (terminalType == TERMINAL_TYPE.LOCAL_END) //     
				{
					parent.startUnEditableInterval(true);
				}
			}
			else
			{
				$("allParamDomainDiv").style.display = "none";	//          
			}
		}
	}
	
	this.initCurrentDomain = function()
	{
		_this.setIFODUSelectAtomEditHandler();
	}
	
	/**
	 *                         
	 */
	this.showIFODUImage = function(curVal)
	{
		$("ifoduImage").style.display = HopTookit.isDataInBusinessValid(curVal) == true ? "" : "none";
	}
	
	this.changeIFODUSelectAtomValue = function(newValue)
	{
		for( var i = 0; i < _this.getIFODUBoardSelectElement().options.length; i++ )
		{
			if( newValue == "-1" )
			{
				_this.getIFODUBoardSelectElement().value = newValue;
				break;
			}
				
			var tmpOption = _this.getIFODUBoardSelectElement().options[i].value;
			var tmpObj = JSON.parse(tmpOption);
			if( tmpObj.ifSlotId == newValue )
			{
				_this.getIFODUBoardSelectElement().selectedIndex = i;
				break;
			}
		}

		_this.getIFODUBoardSelectElement().onchange();
	}
	
}

/**
 *   $("ifoduboardEle")   element
 */
IFODUBoardSelectModule.prototype.getIFODUBoardSelectElement = function()
{
	return $("ifoduboardEle");
}

/**
 *   $("ifoduboardEle")   Value
 */
IFODUBoardSelectModule.prototype.getIFODUBoardSelectElementValue = function()
{
	return $("ifoduboardEle").value;
}




/**
 *           ODU        
 */
function IFODUBoardInfoStruct()
{
	this.ifSlotId = null;
	this.ifBdName = null;
	this.ifBdType = null;
	this.oduSlotId = null;
	this.isWork = null;
	this.wMode = null;
}

IFODUBoardInfoStruct.prototype.setIFSlotId = function(value)
{
	this.ifSlotId = value;
}

IFODUBoardInfoStruct.prototype.setIFBdName = function(value)
{
	this.ifBdName = value;
}

IFODUBoardInfoStruct.prototype.setIFBdType = function(value)
{
	this.ifBdType = value;
}

IFODUBoardInfoStruct.prototype.setODUSlotId = function(value)
{
	this.oduSlotId = value;
}

IFODUBoardInfoStruct.prototype.setIsWork = function(value)
{
	return this.isWork = value;
}

IFODUBoardInfoStruct.prototype.setWMode = function(value)
{
	return this.wMode = value;
}

IFODUBoardInfoStruct.prototype.getIFSlotId = function()
{
	return this.ifSlotId;
}

IFODUBoardInfoStruct.prototype.getIFBdName = function()
{
	return this.ifBdName;
}

IFODUBoardInfoStruct.prototype.getIFBdType = function()
{
	return this.ifBdType;
}

IFODUBoardInfoStruct.prototype.getODUSlotId = function()
{
	return this.oduSlotId;
}

IFODUBoardInfoStruct.prototype.getIFBoardDescription = function()
{
	return this.ifSlotId +"-"+this.ifBdName;
}

IFODUBoardInfoStruct.prototype.getIsWork = function()
{
	return this.isWork != "0";
}

IFODUBoardInfoStruct.prototype.getWMode = function()
{
	return this.wMode;
}

function IFODUBoardSelectChangedEvent()
{
	var _this = this;

	this.eventType = EVENT_TYPE.IFODUCHANGE_EVENT;
	
	this.neid = "-1";
	
	this.slotId = "-1";
	
	this.initData = function(tNeId, tSlotId) 
	{
		_this.neid = tNeId;
		_this.slotId = tSlotId;
	}
	
	this.getEventType = function()
	{
		return _this.eventType;
	}
	
	this.getNeId = function()
	{
		return _this.neid;
	}
	
	this.getSlotId = function()
	{
		return _this.slotId;
	}
}
