/**
 *   
 */

var ifParamCache = new Object();
ifParamCache["linkEle"] = new DecoratedElement();
ifParamCache["linkEle"].bindElement("linkEle", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["if1workmodeEle"] = new DecoratedElement();
ifParamCache["if1workmodeEle"].bindElement("if1workmodeEle", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["ifservtypeEle"] = new DecoratedElement();
ifParamCache["ifservtypeEle"].bindElement("ifservtypeEle", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["ifchannelbandwidthEle"] = new DecoratedElement();
ifParamCache["ifchannelbandwidthEle"].bindElement("ifchannelbandwidthEle", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["stm1CapEle"] = new DecoratedElement();
ifParamCache["stm1CapEle"].bindElement("stm1CapEle", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["amEle"] = new DecoratedElement();
ifParamCache["amEle"].bindElement("amEle", DECORATED_ELEMENT_TYPE.CHECKBOX);
ifParamCache["ensureCalModeEle"] = new DecoratedElement();
ifParamCache["ensureCalModeEle"].bindElement("ensureCalModeEle", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["allCalModeEle"] = new DecoratedElement();
ifParamCache["allCalModeEle"].bindElement("allCalModeEle", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["manualmodeEle"] = new DecoratedElement();
ifParamCache["manualmodeEle"].bindElement("manualmodeEle", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["guE1CapEle"] = new DecoratedElement();
ifParamCache["guE1CapEle"].bindElement("guE1CapEle", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["e1CapEle"] = new DecoratedElement();
ifParamCache["e1CapEle"].bindElement("e1CapEle", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["e1StatusEle"] = new DecoratedElement();
ifParamCache["e1StatusEle"].bindElement("e1StatusEle", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["allE1CapEle"] = new DecoratedElement();
ifParamCache["allE1CapEle"].bindElement("allE1CapEle", DECORATED_ELEMENT_TYPE.TEXT);

var ensureE1CapacityMax = 75;
var fullE1CapacityMax = 75;
var STM1CapacityMax = 2;

ifParamCache["vLinkIdEle"] = new DecoratedElement();
ifParamCache["vLinkIdEle"].bindElement("vLinkIdEle", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["hLinkIdEle"] = new DecoratedElement(); 
ifParamCache["hLinkIdEle"].bindElement("hLinkIdEle", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["guE1CapEle_V"] = new DecoratedElement();
ifParamCache["guE1CapEle_V"].bindElement("guE1CapEle_V", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["guE1CapEle_H"] = new DecoratedElement();
ifParamCache["guE1CapEle_H"].bindElement("guE1CapEle_H", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["e1StatusEle_V"] = new DecoratedElement();
ifParamCache["e1StatusEle_V"].bindElement("e1StatusEle_V", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["e1StatusEle_H"] = new DecoratedElement();
ifParamCache["e1StatusEle_H"].bindElement("e1StatusEle_H", DECORATED_ELEMENT_TYPE.SELECT);
ifParamCache["allE1CapEle_V"] = new DecoratedElement();
ifParamCache["allE1CapEle_V"].bindElement("allE1CapEle_V", DECORATED_ELEMENT_TYPE.TEXT);
ifParamCache["allE1CapEle_H"] = new DecoratedElement();
ifParamCache["allE1CapEle_H"].bindElement("allE1CapEle_H", DECORATED_ELEMENT_TYPE.TEXT);


var maxE1NumObj = new Object();

function IFAttriModule()
{
	var _this = this;
	
	this.isExpend = false;
	
	this.eleOnChangeArray = new Array(
			"guE1CapEle_V",
			"guE1CapEle_H",
			"allE1CapEle_H",
			"allE1CapEle_V"
			);
	
	this.eleCanModifyArray = new Array(	"linkEle",
										"if1workmodeEle",
										"ifservtypeEle",

										"ifchannelbandwidthEle",
										"stm1CapEle",
										"ensureCalModeEle",
										"allCalModeEle",
										"manualmodeEle",
										"guE1CapEle",
										"e1CapEle",
										"allE1CapEle",
										"amEle",
										"e1StatusEle",
										
										"vLinkIdEle",
										"hLinkIdEle",
										
										"guE1CapEle_V",
										"guE1CapEle_H",										
										
										"e1StatusEle_V",
										"e1StatusEle_H",
										"allE1CapEle_V",
										"allE1CapEle_H");

	this.listenerList = new Array();
	
	this.init = function()
	{
		if ($("IFParamField").style.display == "none") 
		{
			_this.isExpend = false;
		}
	}
	/**
	 *          :true   false    
	 */
	this.getExpend = function()
	{
		return $("IFParamField").style.display != "none";
	}
	
	this.setExpend = function(bExpend)
	{
		if(bExpend)
		{
			$("IFParamField").style.display = "";
			$("arrowImg_if").src = "../../../../images/down.gif";
		}
		else
		{
			$("IFParamField").style.display = "none";
			$("arrowImg_if").src = "../../../../images/right.gif";
		}
	}
	
	this.addListener = function(obj)
	{
		_this.listenerList.push(obj);
	}
	
	this.notifyAll = function(event)
	{		
		for( var i = 0; i < _this.listenerList.length; i++ )
		{
			var obj = _this.listenerList[i];
			obj.response(event);
		}
	}
	
	/**
	 *                            
	 * @return
	 */
	this.initIfAttriFieldOptions = function()
	{
		HopTookit.checkDataRange($("linkEle"), 1, 4094);

		$("ifservtypeEle").options.length = 0;
		$("ifservtypeEle").options[$("ifservtypeEle").options.length] = new Option(ifServiceTypeStru.E1ETH, ifServiceTypeStru.E1ETH_VAL);
		$("ifservtypeEle").options[$("ifservtypeEle").options.length] = new Option(ifServiceTypeStru.STMETH, ifServiceTypeStru.STMETH_VAL);
		$("ifservtypeEle").options[$("ifservtypeEle").options.length] = new Option(ifServiceTypeStru.SDH, ifServiceTypeStru.SDH_VAL);	
		
		if( HopTookit.isRTN900NA(neid, neType))
		{
			ifParamCache["ifservtypeEle"].setElementDisabled(true);
		}
		
		$("ifrunmodeEle").options.length = 0;
		$("ifrunmodeEle").options[$("ifrunmodeEle").options.length] = new Option(ifRunModeStru.IS2, ifRunModeStru.IS2_VAL);
		$("ifrunmodeEle").options[$("ifrunmodeEle").options.length] = new Option(ifRunModeStru.IS3, ifRunModeStru.IS3_VAL);
		
		_this.filterUnsupportAttrByNeTypeAndNeversion();
		
		$("ifchannelbandwidthEle").options.length = 0;
		if( HopTookit.isRTN900NA(neid, neType) )
		{
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_30MHz_NA, bandWidthStru.FREQ_30MHz_VAL_NA);
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_40MHz_NA, bandWidthStru.FREQ_40MHz_VAL_NA);
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_50MHz_NA, bandWidthStru.FREQ_50MHz_VAL_NA);
		}
		else
		{
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_3_5MHz, bandWidthStru.FREQ_3_5MHz_VAL);
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_7MHz, bandWidthStru.FREQ_7MHz_VAL);
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_14MHz, bandWidthStru.FREQ_14MHz_VAL);
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_28MHz, bandWidthStru.FREQ_28MHz_VAL);
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_40MHz, bandWidthStru.FREQ_40MHz_VAL);
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_56MHz, bandWidthStru.FREQ_56MHz_VAL);
			$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_FCC50MHz, bandWidthStru.FREQ_FCC50MHz_VAL);
		}
		
		$("amEle").checked = false;
		
		$("e1StatusEle").options.length = 0;
		$("e1StatusEle").options[$("e1StatusEle").options.length] = new Option(RESOURCE["enable"], EnableStatus.ENABLED);
		$("e1StatusEle").options[$("e1StatusEle").options.length] = new Option(RESOURCE["disable"], EnableStatus.DISABLED);
		
		HopTookit.checkDataRange($("hLinkIdEle"), 1, 4094);
		HopTookit.checkDataRange($("vLinkIdEle"), 1, 4094);
		
        $("e1StatusEle_V").options.length = 0;
		$("e1StatusEle_V").options[$("e1StatusEle_V").options.length] = new Option(RESOURCE["enable"], EnableStatus.ENABLED);
		$("e1StatusEle_V").options[$("e1StatusEle_V").options.length] = new Option(RESOURCE["disable"], EnableStatus.DISABLED);

        $("e1StatusEle_H").options.length = 0;
		$("e1StatusEle_H").options[$("e1StatusEle_H").options.length] = new Option(RESOURCE["enable"], EnableStatus.ENABLED);
		$("e1StatusEle_H").options[$("e1StatusEle_H").options.length] = new Option(RESOURCE["disable"], EnableStatus.DISABLED);
	}
	
	/**
	 *       
	 * @return
	 */
	this.setIFAttriAtomEditHandler = function()
	{
		for( var i = 0; i < _this.eleOnChangeArray.length; i++ )
		{
			$(_this.eleOnChangeArray[i]).onchange = function()
			{
				HopTookit.processCellOnchange(ifParamCache[this.id]);
			} 
		}
		
		$("linkEle").onchange = function()
		{
			_this.doBusinessIf_GenericEleChanged("linkEle");
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);	
		}
		
		$("if1workmodeEle").onchange = function()
		{
			_this.doBusinessIf_GenericEleChanged("if1workmodeEle");
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);		
		}
		
		$("ifservtypeEle").onchange = function()
		{
			if( protectionCache["protectionEle"] == false && $("if1plus1").checked == true )
			{
				alert(RESOURCE["create1plus1_and_setservtype_notice1"]);
				
				
				ifParamCache["ifservtypeEle"].updateCacheValueToElementValue();
				
				return;
			}
			
			_this.doBusinessIf_ServiceTypeChanged();
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);		
		}
		
		$("ifchannelbandwidthEle").onchange = function()
		{
			_this.doBusinessIf_IFChannelBandwidthEleChanged();	
   	               
			HopTookit.sendUnionEvent(terminalType, this.id, _this);		
		}
		
		$("stm1CapEle").onchange = function()
		{
			_this.doBusinessIf_GenericEleChanged("stm1CapEle");
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		} 
		
		$("amEle").onclick = function()
		{
			if(!$("amEle").disabled == true)
			{
				_this.doBusinessIf_AMEleChanged();
			
				HopTookit.sendUnionEvent(terminalType, this.id, _this);		
			}
		}
		
		$("ensureCalModeEle").onchange = function()
		{
			_this.doBusinessIf_AMEnable_EnsureCalModulationModeChanged();

			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		$("allCalModeEle").onchange = function()
		{
			_this.doBusinessIf_AMEnable_AllCalModulationModeChanged();

			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		$("manualmodeEle").onchange = function()
		{
			_this.doBusinessIf_AMDisable_ManualCalModulationModeChanged();

			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("guE1CapEle").onchange = function()
		{
			_this.doBusinessIf_guE1CapEleChanged();
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		} 
		
		$("e1CapEle").onchange = function()
		{
			_this.doBusinessIf_e1CapEleChanged();
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		} 

		$("e1StatusEle").onchange = function()
		{
			_this.doBusinessIf_E1StatusEleChanged();

			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("allE1CapEle").onchange = function()
		{
			_this.doBusinessIf_AllE1CapEleChanged();

			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("hLinkIdEle").onchange = function()
		{
			_this.doBusinessIf_GenericEleChanged(this.id);
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("vLinkIdEle").onchange = function()
		{
			_this.doBusinessIf_GenericEleChanged(this.id);
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("guE1CapEle_V").onchange = function()
		{
			_this.doBusinessIf_guE1CapVEleChanged(this.id);
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("guE1CapEle_H").onchange = function()
		{
			_this.doBusinessIf_guE1CapHEleChanged(this.id);
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("allE1CapEle_V").onchange = function()
		{
			_this.doBusinessIf_AllE1CapVEleChanged(this.id);
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("allE1CapEle_H").onchange = function()
		{
			_this.doBusinessIf_AllE1CapHEleChanged(this.id);
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("e1StatusEle_V").onchange = function()
		{
			_this.doBusinessIf_E1StatusVEleChanged("e1StatusEle_V");
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
			
			ifParamCache["allE1CapEle_V"].setElementDisabled( this.value == EnableStatus.ENABLED ? false : true );
			
		}
		
		$("e1StatusEle_H").onchange = function()
		{
			_this.doBusinessIf_E1StatusHEleChanged("e1StatusEle_H");
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
	}
	
	/**
	 *             IF     
	 * @param data
	 * @param i
	 * @return
	 */
	this.queryCallback = function(data)
	{
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
		var curSelectedIFBoard = ifSlotId;//_ifBdSelectModule.getIFODUBoardSelectElementValue();
		var index = -1;

		var isIF1 = false;	//   RTN600   RTN900  IF1       IF1 Workmode
		
		var isPacketNE = HopTookit.isRTN600(neid, neType);
		var isPacketIFBoard = SpecialAttrMgr.isCPSupport(neid, curSelectedIFBoard, 
				"TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_PACKETMICROWAVE_IFBOARD");
		
		if( HopTookit.getIfoduModuleObj($("ifoduboardEle").value).ifBdType == "2081" 
			|| isPacketIFBoard )
		{
			isIF1 = true;
		}

		var isIF2 = false;
		if( (HopTookit.getIfoduModuleObj($("ifoduboardEle").value).ifBdType == "2079") ||
				(HopTookit.getIfoduModuleObj($("ifoduboardEle").value).ifBdType == "2080"))
		{
			isIF2 = true;
		}
		
		var isIFE2 = false;
		if(HopTookit.getIfoduModuleObj($("ifoduboardEle").value).ifBdType == "1404")
		{
			isIFE2 = true;
		}
		
		
		for( var i = 0; i < data.getDataRowLength(); i++ )
		{
			var slotId = data.getDataRowParam(i, "slotid");
			
			if( curSelectedIFBoard == slotId )
			{
				index = i;
				break;
			}
		}
		if( index == -1 )
		{
			return;
		}

		var data_linkEle = data.getDataRowParam(index, "W32PORT_ATTR_RADIOLINKID");
		var data_if1currentworkmodeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "W32PORT_ATTR_RADIOWORKMODE") );
		var data_if1allworkmodeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "W32PORT_ATTR_ALLWORKMODE") );
		var data_ifservtypeEle;
		if(isIF2 || isIFE2)
		{
			data_ifservtypeEle = "";
		}else{
			data_ifservtypeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "IFPORT_ATTR_SERVICETYPE"));
		}
		 
		var data_ifrunmodeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "W32PORT_ATTR_IFRUNNINGMODE") );
		var data_ifchannelbandwidthEle = data.getDataRowParam(index, "W32PORT_ATTR_CHANNELSPACE");
		
		var data_stm1Cap = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "IFPORT_ATTR_STM1NUM") );	//STM1  
		
		var data_amEle = data.getDataRowParam(index, "W32PORT_ATTR_ACMENABLESTATUS");
		
		var data_guE1Cap = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "IFPORT_ATTR_ENSUREE1NUM") );
		if(isIFE2)
		{
			data_guE1Cap = "";
		}
		var data_e1Cap = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "IFPORT_ATTR_E1NUM") );

		var data_guE1CapRangeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "IFPORT_ATTR_ENSUREE1NUM_RANGE") );
		var data_manualmodeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "W32PORT_ATTR_MANUALMODE") );
		var data_ensureCalModeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "W32PORT_ATTR_ENSURECALMODE") );
		var data_allCalModeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "W32PORT_ATTR_ALLCALMODE") );
		var data_e1StatusEle = data.getDataRowParam(index, "IFPORT_ATTR_E1STATUS");
		var data_fullE1Cap = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "IFPORT_ATTR_FULLE1NUM") );
		var data_fullE1CapRangeEle = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "IFPORT_ATTR_FULLE1NUM_RANGE") );
		var issupportactmode = data.getDataRowParam(index, "issupportactmode");
		if(typeof(issupportactmode) != "undefined" && issupportactmode == "true")
		{
			$("actSendModeTR").style.display = "";
			$("actReceiveModeTR").style.display = "";
			var data_actSendMode = data.getDataRowParam(index, "W32PORT_ATTR_SENDMODID");
			var data_actReceiveMode = data.getDataRowParam(index, "W32PORT_ATTR_RECEIVEMODID");
			$("actSendModeEle").value = typeof(ensureCalModeDynStru[data_actSendMode]) == "undefined"?"/":ensureCalModeDynStru[data_actSendMode];
			$("actReceiveModeEle").value = typeof(ensureCalModeDynStru[data_actReceiveMode]) == "undefined"?"/":ensureCalModeDynStru[data_actReceiveMode];
		}
		else
		{
			$("actSendModeTR").style.display = "none";
			$("actReceiveModeTR").style.display = "none";
		}
		$("ifrunmodeEle").value = data_ifrunmodeEle || "0";
		_this.initGloabParam(data.getDataRowParam(index, "capacity"), data_ifchannelbandwidthEle);
		var modelObj = new IfModelObject();
		modelObj.ifServiceType = data_ifservtypeEle;
		modelObj.ifBandWidth = data_ifchannelbandwidthEle;
		modelObj.ifRunMode = $("ifrunmodeEle").value;

		var ensuremodelist = data.getDataRowParam(index, "ensuremodelist");
		if(typeof(ensuremodelist) != "undefined" && ensuremodelist != null && ensuremodelist != "")
		{
			$("ensureCalModeEle").setAttribute("rangeList",ensuremodelist);
		}
		var allcalmodelist = data.getDataRowParam(index, "allcalmodelist");
		if(typeof(allcalmodelist) != "undefined" && allcalmodelist != null && allcalmodelist != "")
		{
			$("allCalModeEle").setAttribute("rangeList",allcalmodelist);
		}
		var manualmodelist = data.getDataRowParam(index, "manualmodelist");
		if(typeof(manualmodelist) != "undefined" && manualmodelist != null && manualmodelist != "")
		{
			$("manualmodeEle").setAttribute("rangeList",manualmodelist);
		}
		_this.addCalModeElementOption($("ensureCalModeEle"), modelObj);
    	_this.addCalModeElementOption($("allCalModeEle"), modelObj);
   		_this.addCalModeElementOption($("manualmodeEle"), modelObj);
   		_this.updateEnsureCalModeDynStruNew(modelObj);

		if (!HopTookit.isElementModified($("linkEle"))) 
		{
			$("linkEle").value = data_linkEle;
		}
		$("if1workmodeEle").options.length = 0;
		if( HopTookit.isDataInBusinessValid(data_if1currentworkmodeEle) &&
			HopTookit.isDataInBusinessValid(data_if1allworkmodeEle) )
		{
			var wmodes = data_if1allworkmodeEle.split("%");
            for (var j = 0; j < wmodes.length; j++) 
            {
                var wmode = wmodes[j];
                var modeId = parseInt(wmode.substring(0, wmode.indexOf(","))); 
                var wmodeShow = modeId + ") " + wmode.substring(wmode.indexOf(",") + 1, wmode.length);
                $("if1workmodeEle").options[$("if1workmodeEle").options.length] = new Option(wmodeShow, modeId);
            }
		}
		$("if1workmodeEle").value = data_if1currentworkmodeEle;

		$("ifservtypeEle").value = data_ifservtypeEle;
		$("ifchannelbandwidthEle").value = data_ifchannelbandwidthEle;
		$("stm1CapEle").value = data_stm1Cap;
		$("amEle").checked = data_amEle == EnableStatus.ENABLED ? true : false;

		$("guE1CapEle").value = data_guE1Cap;
		$("e1CapEle").value = data_e1Cap;
		$("allE1CapEle").value = data_fullE1Cap;
		
		$("manualmodeEle").value = data_manualmodeEle;

		$("ensureCalModeEle").value = data_ensureCalModeEle;
		$("allCalModeEle").value = data_allCalModeEle;
		$("e1StatusEle").value = data_e1StatusEle;

		$("revLinkEle").value = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(index, "W32PORT_ATTR_RECRADIOLINKID") );
		
		var ethBandLow = data.getDataRowParam(index, "ethband");
		var ethBandHigh = data.getDataRowParam(index, "ethbandHigh");
		if( ethBandHigh != null && ethBandHigh != "" )
		{
			$("ethBandEle").value = ethBandLow + "-" + ethBandHigh;
		}
		else
		{
			$("ethBandEle").value = ethBandLow;
		}
		
		
		/**ifParamCache["linkEle"].updateElementValueToCacheValue();
		ifParamCache["if1workmodeEle"].updateElementValueToCacheValue();
		ifParamCache["ifservtypeEle"].updateElementValueToCacheValue();
		ifParamCache["ifchannelbandwidthEle"].updateElementValueToCacheValue();
		ifParamCache["stm1CapEle"].updateElementValueToCacheValue();
		ifParamCache["amEle"].updateElementValueToCacheValue();
		ifParamCache["ensureCalModeEle"].updateElementValueToCacheValue();
		ifParamCache["allCalModeEle"].updateElementValueToCacheValue();
		ifParamCache["manualmodeEle"].updateElementValueToCacheValue();
		ifParamCache["guE1CapEle"].updateElementValueToCacheValue();
		ifParamCache["e1CapEle"].updateElementValueToCacheValue();
		ifParamCache["e1StatusEle"].updateElementValueToCacheValue();
		ifParamCache["allE1CapEle"].updateElementValueToCacheValue();**/
		
		_this.refreshCache();

		ifParamCache["if1workmodeEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_if1currentworkmodeEle) ? false : true );
		$("if1workmodeTR").style.display = isIF1 ? "" : "none"; 
		ifParamCache["ifservtypeEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_ifservtypeEle)&&!isIF1 && !isIF2 && !isIFE2 ? false : true );
		if (HopTookit.isRTN900NA(neid, neType) )
		{
			ifParamCache["ifservtypeEle"].setElementDisabled(true);
		}

		ifParamCache["ifchannelbandwidthEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_ifchannelbandwidthEle)&&!isIF1 ? false : true );
		ifParamCache["stm1CapEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_stm1Cap)&&!isIF1 ? false : true );
		ifParamCache["amEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_amEle)&&!isIF1 ? false : true );

		/**
		 * DTS2012041705683
		 *        STMETH  SDH     E1   
		 *   IFX2 IFU2                 E1   
		 */
	
		_this.setSTM1AndE1NumStatus(ifParamCache["ifservtypeEle"].getElementValue());		
		
		ifParamCache["guE1CapEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_guE1Cap)&&!isIF1 && !isIFE2 ? false : true );
		ifParamCache["stm1CapEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_stm1Cap)&&!isIF1 && !isIFE2 ? false : true );
		ifParamCache["allE1CapEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_guE1CapRangeEle)&&!isIF1 ? false : true );
		ifParamCache["ensureCalModeEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_ensureCalModeEle)&&!isIF1 ? false : true );
		ifParamCache["allCalModeEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_allCalModeEle)&&!isIF1 ? false : true );
		ifParamCache["manualmodeEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_manualmodeEle)&&!isIF1 ? false : true );
		ifParamCache["e1StatusEle"].setElementDisabled( HopTookit.isDataInBusinessValid(data_e1StatusEle)&&!isIF1 && !isIFE2 ? false : true );
		
		var minSTM1 = 1, maxSTM1 = 1;
		var serviceType = data_ifservtypeEle;
        var band = data_ifchannelbandwidthEle;
        switch(serviceType)
        {
            case '2':
                minSTM1 = 0;
                maxSTM1 = 1;
                break;
            case '3':
                if(band == '4')
                {
                    minSTM1 = 1;
                    maxSTM1 = 1;
                } 
                else if(band == '6' || band == '9')
                {
                    minSTM1 = 1;
                    maxSTM1 = 2;
                }
                break;
            default: break;
        }
        
		HopTookit.checkDataRange($("stm1CapEle"), minSTM1, maxSTM1);

		if( HopTookit.isDataInBusinessValid(data_guE1CapRangeEle) == true )
		{
			_this.checkGuaranteeCapcityRange(0, data_guE1CapRangeEle);
			ensureE1CapacityMax = data_guE1CapRangeEle;
			fullE1CapacityMax = data_guE1CapRangeEle;
		}
		
		if( HopTookit.isDataInBusinessValid(data_fullE1CapRangeEle) == true )
		{
			_this.checkFullCapacityRange(data_guE1Cap, data_fullE1CapRangeEle);
			fullE1CapacityMax = data_fullE1CapRangeEle;
			if( parseInt(data_fullE1CapRangeEle) < parseInt($("allE1CapEle").value) )
			{
				$("allE1CapEle").value = data_fullE1CapRangeEle;
				ifParamCache["allE1CapEle"].updateElementBgColor();
			}
		}		

		$("allE1CapTR").style.display = $("e1StatusEle").value == EnableStatus.ENABLED ? "" : "none";
		
		if(HopTookit.isDataInBusinessValid(data_e1Cap))
		{
			var maxValue = HopTookit.isDataInBusinessValid(data_guE1Cap)?data_guE1Cap:75;
			HopTookit.checkDataRange($("e1CapEle"), 0, maxValue);
			$("e1CapTR").style.display = ""; 
		}
		else
		{
			$("e1CapTR").style.display = "none"; 
		}
		_this.showAMContentTr( ifParamCache["amEle"].getCacheValue() );

		_this.filterUnsupportAllMoulationOptions();

		
		if( HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion) )	//RTN900                 
		{
			_this.queryMaxE1Num(curSelectedIFBoard);
		}
		else									//RTN600             
		{
			ifParamCache["guE1CapEle"].setElementDisabled(true);
		}
		if($("ifchannelbandwidthEle").value == bandWidthStru.FREQ_3_5MHz_VAL)
		{
		}

		/**
		 *    bandwidthList   attrib_value_range.xml    
		 *                 XPIC              
		 */
		/**
    	 * 1                 
    	 * 2 IS3       3.5M;  IS2    QPSK-16QAM        3.5M
    	 * 3 IS3       FCC50M
    	 */
		/**********************************************************************************************************/
		var bandwidthlistStr = data.getDataRowParam(index, "bandwidthlist");
		/**
		 * 1    IF1             AM           hybrid  
		 */
		if(bandwidthlistStr)
		{
			var bandwidthList = HopTookit.getIfoduModuleObj(bandwidthlistStr);
			var bandWidthListOptions = HopTookit.getBandWidthList(neid, neType);
			var bandwidthcfgList = bandwidthList[0].list;
			var len = bandwidthcfgList.length;
			if(len > 0)
			{
				var selectedValue = $("ifchannelbandwidthEle").value||data_ifchannelbandwidthEle;
				var runmode = $("ifrunmodeEle").value;
				$("ifchannelbandwidthEle").options.length = 0;
				for(var index = 0;index<len;index++)
				{
					var width = parseInt(bandwidthcfgList[index]);
					if((("1" == width || "9" == width) && ifRunModeStru.IS3_VAL == runmode))
			    	{
			    		continue;
			    	}
					$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthListOptions[width],width);
				}
				$("ifchannelbandwidthEle").value = selectedValue;

				_this.doBusinessIf_IFChannelBandwidthEleChanged();
			}
			else
			{
				if( !HopTookit.isSupportBandwidth_40MHz(/*neType*/) )
				{
					var selectedValue = $("ifchannelbandwidthEle").value;
					$("ifchannelbandwidthEle").options.length = 0;
					$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_3_5MHz, bandWidthStru.FREQ_3_5MHz_VAL);
					$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_7MHz, bandWidthStru.FREQ_7MHz_VAL);
					$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_14MHz, bandWidthStru.FREQ_14MHz_VAL);
					$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_28MHz, bandWidthStru.FREQ_28MHz_VAL);
					$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_40MHz, bandWidthStru.FREQ_40MHz_VAL);
					$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_56MHz, bandWidthStru.FREQ_56MHz_VAL);
					$("ifchannelbandwidthEle").options[$("ifchannelbandwidthEle").options.length] = new Option(bandWidthStru.FREQ_FCC50MHz, bandWidthStru.FREQ_FCC50MHz_VAL);
					$("ifchannelbandwidthEle").value = selectedValue;
				}
			}
		}

		/**********************************************************************************************************/
		_this.filterUnsupportAttrByNeTypeAndNeversion();
		
		_this.refreshCache();
	}

	
	
	this.isNeedApplyRrefreshCache  = function()
	{
		var row = new tagElement("row-params");
		return _this.createIFAttriFieldApplyXML(1, row);
	}
	/**
	 *     xml
	 */
	this.createIFAttriFieldApplyXML = function(neid, row)
	{
		var isColumnModified = false;
		
		if( ifParamCache["linkEle"].isElementModified() )
		{
			HopTookit.addParam(row, "W32PORT_ATTR_RADIOLINKID", $("linkEle").value);
			
			isColumnModified = true;
		}
		if(_this.isExpend == false)
		{
			return isColumnModified;
		}
		if( ifParamCache["if1workmodeEle"].isElementModified() )
		{
			HopTookit.addParam(row, "W32PORT_ATTR_RADIOWORKMODE", $("if1workmodeEle").value);
			
			isColumnModified = true;
		}
		
		if( ifParamCache["ifservtypeEle"].cacheValue == "1"  && $("ifservtypeEle").value == "3")
		{
			HopTookit.addParam(row, "IFPORT_ATTR_E1STATUS", 0);
			
			isColumnModified = true;
		}
		
		if( ifParamCache["ifservtypeEle"].isElementModified() )
		{
			HopTookit.addParam(row, "IFPORT_ATTR_SERVICETYPE", $("ifservtypeEle").value);
			
			isColumnModified = true;
		}
		
		if( ifParamCache["stm1CapEle"].isElementModified() && !ifParamCache["stm1CapEle"].getElementDisabled() )
		{
			HopTookit.addParam(row, "IFPORT_ATTR_STM1NUM", $("stm1CapEle").value);
			
			isColumnModified = true;
		}

		if( $("enablexpicEle").checked )	//  XPIC      XPIC        XPIC  
		{
			return isColumnModified;
		}
		
		/*      XPIC                  */
		var isBandWidthModified = ifParamCache["ifchannelbandwidthEle"].isElementModified(); 
		if( isBandWidthModified || _this.isAnyIFAttrModified())
		{
			HopTookit.addParam(row, "W32PORT_ATTR_CHANNELSPACE", $("ifchannelbandwidthEle").value);
			
			isColumnModified = true;
		}
	
		var isAMModified = _this.isAMElementsModified(); 
		if( isBandWidthModified || isAMModified || _this.isAnyIFAttrModified())	//  AM 4           
		{
			if( ifParamCache["amEle"].isElementModified() || _this.isAnyIFAttrModified())	//   AM        
			{
				if( ifParamCache["amEle"].getElementValue() == false )			//   AM        
				{
					_this.setAcmParam(	row, 
										"0", 
										"255", 
										"255", 
										ifParamCache["manualmodeEle"].getElementValue()
									);
				}
				else															//   AM         
				{
					_this.setAcmParam(	row, 
										"1", 
										ifParamCache["ensureCalModeEle"].getElementValue(),
										ifParamCache["allCalModeEle"].getElementValue(),
										"255"
									);
				}
			}
			else	//        AM             
			{
				if( ifParamCache["amEle"].getElementValue() == false )			//  AM      
				{
					if( ifParamCache["manualmodeEle"].isElementModified() == true )
					{
						_this.setAcmParam(	row, 
											"0", 
											"255", 
											"255", 
											ifParamCache["manualmodeEle"].getElementValue()
										);
					}
				}
				else														//  AM     
				{
					if( ifParamCache["ensureCalModeEle"].isElementModified() == true ||
						ifParamCache["allCalModeEle"].isElementModified() == true ) 
					{
						_this.setAcmParam(	row, 
											"1", 
											ifParamCache["ensureCalModeEle"].getElementValue(),
											ifParamCache["allCalModeEle"].getElementValue(),
											"255"
										);
					}
				}
			}
			
			isColumnModified = true;
		}
		
		if( ifParamCache["amEle"].getElementValue() == true &&
			ifParamCache["e1StatusEle"].isElementModified())
		{
			  if(ifParamCache["ifservtypeEle"].getElementValue() != ifServiceTypeStru.STMETH_VAL && ifParamCache["ifservtypeEle"].getElementValue() != ifServiceTypeStru.SDH_VAL)
			  {
					HopTookit.addParam(row, "IFPORT_ATTR_E1STATUS", ifParamCache["e1StatusEle"].getElementValue() );
					
					isColumnModified = true; 
			  }
		
		}
		        
        if (_this.isNeedPakageSendguE1($("ifservtypeEle").value) &&
        (isBandWidthModified ||
        isAMModified ||
        ifParamCache["guE1CapEle"].isElementModified() ||
        ($("e1StatusEle").value == EnableStatus.ENABLED && ifParamCache["allE1CapEle"].isElementModified()) ||
        _this.isAnyIFAttrModified())) 
        {
            HopTookit.addParam(row, "IFPORT_ATTR_ENSUREE1NUM", ifParamCache["guE1CapEle"].getElementValue());
            
            var allE1CapValue = 255;
            
            if (ifParamCache["amEle"].getElementValue() == false) 
            {
                allE1CapValue = 255;
            }
            else 
            {
                if (ifParamCache["e1StatusEle"].getElementValue() == false) 
                {
                    allE1CapValue = ifParamCache["guE1CapEle"].getElementValue();
                }
                else 
                {
                    allE1CapValue = ifParamCache["allE1CapEle"].getElementValue();
                }
            }
            
            HopTookit.addParam(row, "IFPORT_ATTR_FULLE1NUM", allE1CapValue);
            
            isColumnModified = true;
        }
		if(ifParamCache["e1CapEle"].isElementModified())
		{
			HopTookit.addParam(row, "IFPORT_ATTR_E1NUM", ifParamCache["e1CapEle"].getElementValue());
			isColumnModified = true;
		}

		return isColumnModified;
	}
	
	/**
	 *        
	 * @return
	 */
	this.clearAttriField = function()
	{
		$("revLinkEle").value = "";
		$("ethBandEle").value = "";
		
		ifParamCache["linkEle"].initAllValue();
		ifParamCache["if1workmodeEle"].initAllValue();
		ifParamCache["ifservtypeEle"].initAllValue();
		ifParamCache["ifchannelbandwidthEle"].initAllValue();
		ifParamCache["stm1CapEle"].initAllValue();
		ifParamCache["amEle"].initAllValue();
		ifParamCache["ensureCalModeEle"].initAllValue();
		ifParamCache["allCalModeEle"].initAllValue();
		ifParamCache["manualmodeEle"].initAllValue();
		ifParamCache["guE1CapEle"].initAllValue();
		ifParamCache["e1CapEle"].initAllValue();
		ifParamCache["e1StatusEle"].initAllValue();
		ifParamCache["allE1CapEle"].initAllValue();
		
		_this.clearAttriFieldBgColor();
	}

	/**
	 *   IF          
	 * @return
	 */
	this.isAnyElementInThisAttriFieldModified = function()
	{
		var isModified = false;
		
		for( var i = 0; i < _this.eleCanModifyArray.length; i++ )
		{
			if( ifParamCache[_this.eleCanModifyArray[i]].isElementModified() == true )
			{
				isModified = true;
				break;
			}
		}
		
		return isModified;
	}
	
	/**
	 *        
	 */
	this.initCurrentDomain = function()
	{
		/* init IF Attributes Filed Start */
		$("linkIdSpan").innerText = RESOURCE["linkidtx"];
		$("revLinkIdSpan").innerText = RESOURCE["reallinkidtx"];

		$("IFAttriSpan").innerText = RESOURCE["IFAttriSpan"];
		$("if1workmodeSpan").innerText = RESOURCE["if1workmodeSpan"];
		$("ifservtypeSpan").innerText = RESOURCE["ifservicetype"];
		$("ifrunmodeSpan").innerText = RESOURCE["ifrunmode"];
		$("ifchannelbandwidthSpan").innerText = RESOURCE["bandwidth"];
		$("stm1CapSpan").innerText = RESOURCE["stm1numtx"];
		$("amSpan").innerText = RESOURCE["amSpan"];
		$("manualmodeSpan").innerText = RESOURCE["manualmodeSpan"];
		$("guE1CapSpan").innerText = RESOURCE["guaranteenumtx"];
		$("e1CapSpan").innerText = RESOURCE["teenumtx"];
		$("ethBandSpan").innerText = RESOURCE["ethbandtx"];
		
		$("actSendModeSpan").innerText = RESOURCE["actSendMode"];
		$("actReceiveModeSpan").innerText = RESOURCE["actReceiveMode"];
		
		$("ensureCalModeSpan").innerText = RESOURCE["ensuremode"];
		$("allCalModeSpan").innerText = RESOURCE["fullmode"];
		$("e1StatusSpan").innerText = RESOURCE["e1enable"];
		$("allE1CapSpan").innerText = RESOURCE["fullnumtx"];
		
		$("guE1CapSpan_XPIC").innerText = RESOURCE["guaranteenumtx_hv"];
		$("ethBandSpan_XPIC").innerText = RESOURCE["ethbandtx_hv"];
		$("e1StatusSpan_XPIC").innerText = RESOURCE["e1enable_hv"];
		$("allE1CapSpan_XPIC").innerText = RESOURCE["fullnumtx_hv"];
		
		/* init IF Attributes Filed End */
		
		_this.setIFAttriAtomEditHandler();
	}
	
	this.doBusinessIf_GenericEleChanged = function(column)
	{
		HopTookit.processCellOnchange(ifParamCache[column]);
	}
	
	this.doBusinessIf_ServiceTypeChanged = function()
	{
		HopTookit.processCellOnchange( ifParamCache["ifservtypeEle"] );
		
		_this.doBusinessIf_IFChannelBandwidthEleChanged();
		
		_this.adjustSTMNumMax();
		_this.setSTM1AndE1NumStatus(ifParamCache["ifservtypeEle"].getElementValue());
	}
	
	this.doBusinessIf_IFChannelBandwidthEleChanged = function()
	{
		var ifServiceType = $("ifservtypeEle").value;
		var ifBandWidth = $("ifchannelbandwidthEle").value;
		var ifRunMode = $("ifrunmodeEle").value;
		var modelObj = new IfModelObject();
		modelObj.ifServiceType = ifServiceType;
		modelObj.ifBandWidth = ifBandWidth;
		modelObj.ifRunMode = ifRunMode;

		_this.doIFChannelBandwidthEleChanged(modelObj);
		
		_this.updateModeOption( $("ensureCalModeEle"), modelObj);
		_this.updateModeOption( $("allCalModeEle"), modelObj);
		_this.updateModeOption( $("manualmodeEle"), modelObj);
		_this.updateEnsureCalModeDynStruNew(modelObj);
		
		_this.adjustE1NumMax();		
		_this.adjustSTMNumMax();
		_this.doBusinessIf_GenericEleChanged("ifchannelbandwidthEle");
	}
	
	this.doIFChannelBandwidthEleChanged = function(modelObj)
	{
		var ifBandWidth = modelObj.ifBandWidth;
		if (ifBandWidth == bandWidthStru.FREQ_3_5MHz_VAL)
		{
			_this.addCalModeElementOptionFor3_5M($("ensureCalModeEle"));
			_this.addCalModeElementOptionFor3_5M($("allCalModeEle"));
			_this.addCalModeElementOptionFor3_5M($("manualmodeEle"));
			$("amEle").disabled = true;
			if($("amEle").checked == true)
			{
				$("amEle").checked = false;
				_this.doBusinessIf_AMEleChanged();
			}
		}
		else
		{
			_this.addCalModeElementOption($("ensureCalModeEle"),modelObj);
			_this.addCalModeElementOption($("allCalModeEle"),modelObj);
			_this.addCalModeElementOption($("manualmodeEle"),modelObj);
			_this.updateEnsureCalModeDynStruNew(modelObj);
			$("amEle").disabled = false;
		}
		this.filterUnsupportAllMoulationOptions();
	}
	
	this.doBusinessIf_AMEleChanged = function()
	{
		HopTookit.processCellOnchange(ifParamCache["amEle"]);
		
		_this.showAMContentTr($("amEle").checked);
		
		var ifServiceType = $("ifservtypeEle").value;
		var ifBandWidth = $("ifchannelbandwidthEle").value;
		var ifRunMode = $("ifrunmodeEle").value;
		
		var modelObj = new IfModelObject();
		modelObj.ifServiceType = ifServiceType;
		modelObj.ifBandWidth = ifBandWidth;
		modelObj.ifRunMode = ifRunMode;
		
		if( $("amEle").checked == false )
		{
			_this.addCalModeElementOption( $("manualmodeEle"),modelObj);
			ifParamCache["manualmodeEle"].updateElementBgColor();
			
			ifParamCache["ensureCalModeEle"].updateCacheValueToElementValue();
			ifParamCache["ensureCalModeEle"].updateElementBgColor();
			
			ifParamCache["allCalModeEle"].updateCacheValueToElementValue();
			ifParamCache["allCalModeEle"].updateElementBgColor();
			
			if(!HopTookit.isRTN900NA(neid, neType) && HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion))
        	{	
			  $("e1StatusEle").value = EnableStatus.DISABLED;
		    }
			
			_this.checkGuaranteeCapcityRange(0, ensureE1CapacityMax);
		}
		else
		{
			_this.addCalModeElementOption( $("allCalModeEle"),modelObj);
			_this.addCalModeElementOption( $("ensureCalModeEle"),modelObj);
			_this.updateEnsureCalModeDynStruNew(modelObj);
			_this.filterUnsupportAllMoulationOptions();
			ifParamCache["ensureCalModeEle"].updateElementBgColor();
			ifParamCache["allCalModeEle"].updateElementBgColor();
			
			
			ifParamCache["manualmodeEle"].updateCacheValueToElementValue();
			ifParamCache["manualmodeEle"].updateElementBgColor();
			
			if(!HopTookit.isRTN900NA(neid, neType) && HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion))
        	{			
				ifParamCache["e1StatusEle"].updateCacheValueToElementValue();
				if($("e1StatusEle").value == "")
				{
					$("e1StatusEle").value = EnableStatus.DISABLED;
				}			
				_this.doBusinessIf_E1StatusEleChanged();
				
			}
		}
	}
	
	
	this.doBusinessIf_AMEnable_EnsureCalModulationModeChanged = function()
	{
		if( $("amEle").checked == false )
		{
			return;
		}

		_this.adjustE1NumMax();	
		
		_this.filterUnsupportAllMoulationOptions();
		
		_this.doBusinessIf_GenericEleChanged("ensureCalModeEle");
	}
	
	this.doBusinessIf_AMEnable_AllCalModulationModeChanged = function()
	{
		if( $("amEle").checked == false )
		{
			return;
		}
		_this.adjustE1NumMax();
		_this.doBusinessIf_GenericEleChanged("allCalModeEle");
	}
	
	this.doBusinessIf_AMDisable_ManualCalModulationModeChanged = function()
	{
		if( $("amEle").checked == true )
		{
			return;
		}
		
		_this.adjustE1NumMax();
		
		_this.doBusinessIf_GenericEleChanged("manualmodeEle");
	}
	
	this.doBusinessIf_E1StatusEleChanged = function()
	{
		if( ifParamCache["e1StatusEle"].getElementValue() == true )
		{
			ifParamCache["allE1CapEle"].setElementDisabled(false);
			_this.checkGuaranteeCapcityRange(0, $("allE1CapEle").value);
			_this.adjustE1NumMax();
		}
		else
		{			
			_this.adjustE1NumMax();

			ifParamCache["allE1CapEle"].setElementValue( $("guE1CapEle").value );
			ifParamCache["allE1CapEle"].updateElementBgColor();
			ifParamCache["allE1CapEle"].setElementDisabled(true);			
		}
		
		HopTookit.processCellOnchange(ifParamCache["e1StatusEle"]);
		$("allE1CapTR").style.display = $("e1StatusEle").value == EnableStatus.ENABLED ? "" : "none";
	}
	
	this.doBusinessIf_E1StatusVEleChanged = function()
	{
		if( ifParamCache["e1StatusEle_V"].getElementValue() == true )
		{
			ifParamCache["allE1CapEle_V"].setElementDisabled(false);
			if( $("allE1CapEle_V").value == "" || $("allE1CapEle_V").value == "255" )
			{
				$("allE1CapEle_V").value = $("guE1CapEle_V").value;
				ifParamCache["allE1CapEle_V"].updateElementBgColor();
			}
			_this.checkGuaranteeCapcityRange(0, $("allE1CapEle_V").value);
			
		}
		else
		{			
			ifParamCache["allE1CapEle_V"].setElementDisabled(true);			
		}
		
		_this.adjustE1NumMax();
		ifParamCache["allE1CapEle_V"].setElementValue( $("allE1CapEle_V").value );
		HopTookit.processCellOnchange(ifParamCache["e1StatusEle_V"]);
	}
	
	this.doBusinessIf_E1StatusHEleChanged = function()
	{
		if( ifParamCache["e1StatusEle_H"].getElementValue() == true )
		{
			ifParamCache["allE1CapEle_H"].setElementDisabled(false);
			if( $("allE1CapEle_H").value == "" || $("allE1CapEle_H").value == "255" )
			{
				$("allE1CapEle_H").value = $("guE1CapEle_H").value;
				ifParamCache["allE1CapEle_H"].updateElementBgColor();
			}
			_this.checkGuaranteeCapcityRange(0, $("allE1CapEle_H").value);
			
		}
		else
		{			
			ifParamCache["allE1CapEle_H"].setElementDisabled(true);			
		}
		
		_this.adjustE1NumMax();
		ifParamCache["allE1CapEle_H"].setElementValue( $("allE1CapEle_H").value );
		HopTookit.processCellOnchange(ifParamCache["e1StatusEle_H"]);
	}
	this.doBusinessIf_guE1CapEleChanged = function()
	{
		_this.checkFullCapacityRange($("guE1CapEle").value, fullE1CapacityMax);
		
		_this.doBusinessIf_GenericEleChanged("guE1CapEle");		
	}
	
	this.doBusinessIf_e1CapEleChanged = function()
	{
		_this.checkFullCapacityRange($("e1CapEle").value, fullE1CapacityMax);
		
		_this.doBusinessIf_GenericEleChanged("e1CapEle");		
	}

	this.doBusinessIf_guE1CapVEleChanged = function()
	{
		_this.checkFullCapacityRange($("guE1CapEle_V").value, fullE1CapacityMax);
		
		_this.doBusinessIf_GenericEleChanged("guE1CapEle_V");		
	}
	
	this.doBusinessIf_guE1CapHEleChanged = function()
	{
		_this.checkFullCapacityRange($("guE1CapEle_H").value, fullE1CapacityMax);
		
		_this.doBusinessIf_GenericEleChanged("guE1CapEle_H");		
	}
	
	this.doBusinessIf_AllE1CapEleChanged = function()
	{
		/****-----------------------------****/
		/**
		 *     :DTS2012052408114
		 * AM   E1        E1                       AM    E1               
		 *       obj.doAfterBlur();
		 */
		$("allE1CapEle").doAfterBlur = function()
		{
			_this.checkGuaranteeCapcityRange(0, $("allE1CapEle").value);
		}
		_this.doBusinessIf_GenericEleChanged("allE1CapEle");		
	}

	this.doBusinessIf_AllE1CapVEleChanged = function()
	{
		$("allE1CapEle_V").doAfterBlur = function()
		{
			_this.checkGuaranteeCapcityRange(0, $("allE1CapEle_V").value);
		}
		_this.doBusinessIf_GenericEleChanged("allE1CapEle_V");		
	}
	this.doBusinessIf_AllE1CapHEleChanged = function()
	{
		$("allE1CapEle_H").doAfterBlur = function()
		{
			_this.checkGuaranteeCapcityRange(0, $("allE1CapEle_H").value);
		}
		_this.doBusinessIf_GenericEleChanged("allE1CapEle_H");		
	}
	
	this.createXpicIFAttriFieldApplyXML = function(neid, row, ifslotid)
	{
		var isColumnModified = false;
		
		if( ifslotid != $("hPolarBdEle").value && ifslotid != $("vPolarBdEle").value )
		{
			return false;
		}
		
		if( ifslotid == $("hPolarBdEle").value )
		{
			if( ifParamCache["hLinkIdEle"].isElementModified() == true )
			{
				HopTookit.addParam(row, "W32PORT_ATTR_RADIOLINKID", $("hLinkIdEle").value);
				
				isColumnModified = true;
			}
		}
		
		if( ifslotid == $("vPolarBdEle").value )
		{
			if( ifParamCache["vLinkIdEle"].isElementModified() == true )
			{
				HopTookit.addParam(row, "W32PORT_ATTR_RADIOLINKID", $("vLinkIdEle").value);
				
				isColumnModified = true;
			}
		}
		/*
		 * DTS2012053106093
		 * SDH    STM-1     V H       
		 *             STM-1                  
		 *             ifslotid != ifSelectedSlotId      
		 * 
		 * 
		*/
		var ifSelectedSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
		
		if((ifslotid != ifSelectedSlotId) && ifParamCache["stm1CapEle"].isElementModified() == true && !ifParamCache["stm1CapEle"].getElementDisabled())
		{
			HopTookit.addParam(row, "IFPORT_ATTR_STM1NUM", $("stm1CapEle").value);
				
			isColumnModified = true;
		}
		
		return isColumnModified;
	}

	this.refreshXpicRelatedData = function(event)
	{
		var data = event.getData();
		
		var vBdStruct = event.getVBdStruct();
		var hBdStruct = event.getHBdStruct();

	    for( var i = 0; i < data.getDataRowLength(); i++ )
	    {
			var tslotid = data.getDataRowParam(i, "slotid");
			var tport = data.getDataRowParam(i, "port");
			var tlinkid = data.getDataRowParam(i, "W32PORT_ATTR_RADIOLINKID");
			
			var tguaE1Cap = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(i, "guaranteenum") );
			var tE1Enable = data.getDataRowParam(i, "e1enable");
			var tFullE1Cap = HopTookit.replaceNegativeWithEmptyStr( data.getDataRowParam(i, "fullnum") );
			
			if( vBdStruct.getSlotID() == tslotid &&
					vBdStruct.getPortID() == tport )				//boardStructArray[0] VBoard
			{
				$("vLinkIdEle").value = tlinkid;
				ifParamCache["vLinkIdEle"].updateElementValueToCacheValue();
				
				$("guE1CapEle_V").value = tguaE1Cap;
				ifParamCache["guE1CapEle_V"].updateElementValueToCacheValue();
				if($("guE1CapEle_V").value == "")
				{
				  ifParamCache["guE1CapEle_V"].setElementDisabled(true);
				}
				
				$("e1StatusEle_V").value = tE1Enable;
				ifParamCache["e1StatusEle_V"].updateElementValueToCacheValue();
				if($("e1StatusEle_V").value == "")
				{
				  ifParamCache["e1StatusEle_V"].setElementDisabled(true);
				}
				
				ifParamCache["allE1CapEle_V"].setElementDisabled( tE1Enable == 1 ? false : true );
				$("allE1CapEle_V").value = tFullE1Cap;
				ifParamCache["allE1CapEle_V"].updateElementValueToCacheValue();
			}
			else													//boardStructArray[1] HBoard
			{
				$("hLinkIdEle").value = tlinkid;
				ifParamCache["hLinkIdEle"].updateElementValueToCacheValue();
				
				$("guE1CapEle_H").value = tguaE1Cap;
				ifParamCache["guE1CapEle_H"].updateElementValueToCacheValue();
				if($("guE1CapEle_H").value == "")
				{
				  ifParamCache["guE1CapEle_H"].setElementDisabled(true);
				}
				
				$("e1StatusEle_H").value = tE1Enable;
				ifParamCache["e1StatusEle_H"].updateElementValueToCacheValue();
				if($("e1StatusEle_H").value == "")
				{
				  ifParamCache["e1StatusEle_H"].setElementDisabled(true);
				}
				
				ifParamCache["allE1CapEle_H"].setElementDisabled( tE1Enable == 1 ? false : true );
				$("allE1CapEle_H").value = tFullE1Cap;
				ifParamCache["allE1CapEle_H"].updateElementValueToCacheValue();
			}
	    }
	}
	
	/**
	 *   E1             
	 */
	this.queryMaxE1Num = function(ifbdid)
	{
	    var xmlstr = _this.createQueryMaxE1NumXML(ifbdid);
	    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ALL_MAXE1NUM + "&nmUser=" + neobject["nmUser"];
	    loadXMLdoc(urlreq, "POST", false, _this.queryMaxE1NumCallback, null, "inputdata=" + xmlstr);
	}
	
	this.createQueryMaxE1NumXML = function(ifbdid)
	{
	    var di = new inputxml("datainterface");
	    var bussiness = new tagElement("bussiness-params");
	    
	    var row = new tagElement("row-params");
	    var param = new tagElement("param");
	    var neidvalue = neobject.neid;
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", neid);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "slotid");
	    param.setAttribute("value", ifbdid);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "portid");
	    param.setAttribute("value", 1);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "isLogFlag");
	    param.setAttribute("value", 0);
	    row.appendChild(param);
	    
	    bussiness.appendChild(row);
	    di.getRoot().appendChild(bussiness);
	    return di.toString();
	}
	
	this.queryMaxE1NumCallback = function(doc)
	{
	    var data = EncapsulateData(doc);
	    
	    if ( 0 == data.getSErrorCode() ) 
	    {
	        maxE1NumObj = new Object();
	        
	        for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
	        {
	        	var bandType = data.getDataRowParam(i, "bandtype");
	            var modeType = data.getDataRowParam(i, "modetype");
	            var maxE1Num = data.getDataRowParam(i, "maxe1num");
	            maxE1NumObj[bandType + "-" + modeType] = maxE1Num;
	        }
	    }
	}
	
	/**
	 *                     
	 */
	this.adjustE1NumMax = function()
	{
		var ifbandwidth = ifParamCache["ifchannelbandwidthEle"].getElementValue();
		var key = null;
		var fullModeType = null;
		if( ifParamCache["amEle"].getElementValue() == true )	// AM   
		{
			var ensureMode = ifParamCache["ensureCalModeEle"].getElementValue();
			
			key = ifbandwidth + "-" + ensureMode;
			
			if(ifParamCache["e1StatusEle"].getElementValue() == true)
	        {
	            fullModeType = ifParamCache["allCalModeEle"].getElementValue();
	        }
		}
		else
		{
			var manaulMode = ifParamCache["manualmodeEle"].getElementValue();
			
			key = ifbandwidth + "-" + manaulMode;
		}
		
		ensureE1CapacityMax = HopTookit.isDataInBusinessValid( maxE1NumObj[key] ) == true ? maxE1NumObj[key] : "75";
        
        if (fullModeType) 
        {
            var maxtemp = maxE1NumObj[ifbandwidth + "-" + fullModeType];
			fullE1CapacityMax = maxtemp?maxtemp:fullE1CapacityMax;
        }
		
		_this.adjustGuaranteeAndFullE1Capacity();
	}
	
	this.adjustSTMNumMax = function()
	{
		var serviceType = ifParamCache["ifservtypeEle"].getElementValue();
		if("1" == serviceType)
		{
			return;
		}
        var band = ifParamCache["ifchannelbandwidthEle"].getElementValue();
        
        var minSTM1 = 1, maxSTM1 = 1;
        switch(serviceType)
        {
            case '2':
                minSTM1 = 0;
                maxSTM1 = 1;
                break;
            case '3':
                if(band == '4')
                {
                    minSTM1 = 1;
                    maxSTM1 = 1;
                } 
                else if(band == '6' || band == '9')
                {
                    minSTM1 = 1;
                    maxSTM1 = 2;
                }
                break;
            default: break;
        }
        if($("stm1CapEle").value != "" 
		&& (parseInt($("stm1CapEle").value) > maxSTM1 || parseInt($("stm1CapEle").value) < minSTM1))
		{
			ifParamCache["stm1CapEle"].setElementValue( maxSTM1 );
			ifParamCache["stm1CapEle"].updateElementBgColor();
		}
		HopTookit.checkDataRange($("stm1CapEle"), minSTM1, maxSTM1);
	}
	
	/**
	 *                 
	 */
	this.adjustGuaranteeAndFullE1Capacity = function()
	{
		if( $("amEle").checked == true )
		{
			if( $("e1StatusEle").value == EnableStatus.ENABLED )
			{
				if( parseInt($("guE1CapEle").value) > parseInt(ensureE1CapacityMax) )
				{
					ifParamCache["guE1CapEle"].setElementValue( ensureE1CapacityMax );
					ifParamCache["guE1CapEle"].updateElementBgColor();
				}
				if( parseInt($("allE1CapEle").value) > parseInt(fullE1CapacityMax) )
				{
					ifParamCache["allE1CapEle"].setElementValue( fullE1CapacityMax );
					ifParamCache["allE1CapEle"].updateElementBgColor();
				}

				_this.checkGuaranteeCapcityRange(0, $("allE1CapEle").value);
				
				_this.checkFullCapacityRange($("guE1CapEle").value, fullE1CapacityMax);
			}
			else
			{
				_this.checkGuaranteeCapcityRange(0, ensureE1CapacityMax);
				
				_this.checkFullCapacityRange($("guE1CapEle").value, fullE1CapacityMax);
				if($("guE1CapEle").value != "" && parseInt($("guE1CapEle").value) > ensureE1CapacityMax)
				{
					ifParamCache["guE1CapEle"].setElementValue( ensureE1CapacityMax );
					ifParamCache["guE1CapEle"].updateElementBgColor();
				}
			}
		}
		else
		{
			_this.checkGuaranteeCapcityRange(0, ensureE1CapacityMax);
			
			_this.checkFullCapacityRange($("guE1CapEle").value, fullE1CapacityMax);
			if($("guE1CapEle").value != "" && parseInt($("guE1CapEle").value) > ensureE1CapacityMax)
			{
				ifParamCache["guE1CapEle"].setElementValue( ensureE1CapacityMax );
				ifParamCache["guE1CapEle"].updateElementBgColor();
			}
		}
	}
	
	/**
	 *   IF       ethBandwidth , XPIC  
	 */
	this.queryEthBandWidth = function()
	{
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
		var boardArray = [];
		if(ifSlotId == $("vPolarBdEle").value)
		{
			boardArray[0] = HopTookit.getBoardInforStruct($("hPolarBdEle").value, 1);
		}
		else
		{
			boardArray[0] = HopTookit.getBoardInforStruct($("vPolarBdEle").value, 1);
		}
		var hOduSlotid = g_commonData.getRelatedODUSlotId( $("hPolarBdEle").value );
		boardArray[1] = HopTookit.getBoardInforStruct(hOduSlotid, 1);
		var vOduSlotid = g_commonData.getRelatedODUSlotId( $("vPolarBdEle").value );
		boardArray[2] = HopTookit.getBoardInforStruct(vOduSlotid, 1);
		
		var xmlStr = _this.createQueryEthBandWidthXML(boardArray);

		var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_RTN_QUERY_IFODUINFO + "&nmUser="+nmUser;
		
		loadXMLdoc(urlreq, "POST", true, _this.queryEthBandWidthCallback, boardArray,"inputdata=" + xmlStr);
	}
	
	/**
	 *       
	 */
	this.createQueryEthBandWidthXML = function(boardStructArray)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = null;

		for( var i = 0; i < boardStructArray.length; i++ )
		{
			row = new tagElement("row-params");
			
			HopTookit.addParam(row, "neid", neid);
			
			HopTookit.addParam(row, "queryType", "queryEthBandwidth");
			
			HopTookit.addParam(row, "isQueryIF", "true");
			
			HopTookit.addParam(row, "isQueryRF", "true");
			
			HopTookit.addParam(row, "slotid", boardStructArray[i].getSlotID());
			
			HopTookit.addParam(row, "port", boardStructArray[i].getPortID());
			
			HopTookit.addParam(row, "portid", boardStructArray[i].getPortID());
			
			bussiness.appendChild(row);
		}
		
		di.getRoot().appendChild(bussiness);
		
		return di.toString();
	}
	
	this.refreshXPICHElement = function(gue1,ethband,e1state,alle1,ifservicetype)
	{
		if(typeof(ifservicetype) != "undefined" && ifservicetype && !_this.isNeedPakageSendguE1(ifservicetype))
		{
			$("guE1CapEle_H").value = "";
			$("e1StatusEle_H").value = "";
			$("allE1CapEle_H").value = "";
			$("ethBandEle_H").value = ethband;
			ifParamCache["guE1CapEle_H"].setElementDisabled(true);
			ifParamCache["e1StatusEle_H"].setElementDisabled(true);
			ifParamCache["allE1CapEle_H"].setElementDisabled(true);
		}
		else
		{
			$("guE1CapEle_H").value = gue1;
			ifParamCache["guE1CapEle_H"].setElementDisabled($("guE1CapEle_H").value != "" ? false : true)
			$("ethBandEle_H").value = ethband;
			$("e1StatusEle_H").value = e1state;
			ifParamCache["e1StatusEle_H"].setElementDisabled($("e1StatusEle_H").value != "" ? false : true)
			ifParamCache["allE1CapEle_H"].setElementDisabled( $("e1StatusEle_H").value == 1 ? false : true );
			$("allE1CapEle_H").value = alle1;
		}
	}
	
	this.refreshXPICVElement = function(gue1,ethband,e1state,alle1,ifservicetype)
	{
		if(typeof(ifservicetype) != "undefined" && ifservicetype && !_this.isNeedPakageSendguE1(ifservicetype))
		{
			ifParamCache["guE1CapEle_V"].setElementDisabled(true);
			ifParamCache["e1StatusEle_V"].setElementDisabled(true);
			ifParamCache["allE1CapEle_V"].setElementDisabled(true);
			$("guE1CapEle_V").value = "";
			$("e1StatusEle_V").value = "";
			$("allE1CapEle_V").value = "";
			$("ethBandEle_V").value = ethband;
		}
		else
		{
			$("guE1CapEle_V").value = gue1;
			ifParamCache["guE1CapEle_V"].setElementDisabled($("guE1CapEle_V").value != "" ? false : true)
			$("ethBandEle_V").value = ethband;
			$("e1StatusEle_V").value = e1state;
			ifParamCache["e1StatusEle_V"].setElementDisabled($("e1StatusEle_V").value != "" ? false : true)
			ifParamCache["allE1CapEle_V"].setElementDisabled( $("e1StatusEle_V").value == 1 ? false : true );
			$("allE1CapEle_V").value = alle1;
		}
	}
	
	/**
	 *     
	 */
	this.queryEthBandWidthCallback = function(doc, boardStructArray)
	{
		var data = EncapsulateData(doc);
		
	    if( data.getSErrorCode() != OPERATION_SUCCESS && data.getSErrorCode() != OPERATION_PART_SUCCESS )
	    {
	    	return;
	    }

	    var vservicetype = $("ifservtypeEle").value;
	    var hservicetype = $("ifservtypeEle").value;
	    for( var i = 0; i < data.getDataRowLength(); i++ )
	    {
	    	var tslotid = data.getDataRowParam(i, "slotid");
	    	var ifservicetype = data.getDataRowParam(i, "IFPORT_ATTR_SERVICETYPE");
	    	var gue1 = data.getDataRowParam(i, "IFPORT_ATTR_ENSUREE1NUM");
	    	var alle1 = data.getDataRowParam(i, "IFPORT_ATTR_FULLE1NUM");
	    	var e1statue = data.getDataRowParam(i, "IFPORT_ATTR_E1STATUS");
	    	var ethBandWidthValue = data.getDataRowParam(i, "ethband");
	    	var ethBandWidthHighValue = data.getDataRowParam(i, "ethbandHigh");
	    	var rePowerValue = data.getDataRowParam(i, "W32BRD_ATTR_RECEIVEPOWER");
	    	var actTXPowerValue = data.getDataRowParam(i, "W32BRD_ATTR_ACTTRANSMITPOWER");
	    	if( tslotid == $("vPolarBdEle").value )
	    	{
	    		vservicetype = ifservicetype;
	    		_this.refreshXPICVElement(gue1,ethBandWidthValue + "-" + ethBandWidthHighValue,e1statue,alle1,vservicetype);
	    		_this.refreshXPICHElement($("guE1CapEle").value,$("ethBandEle").value,$("e1StatusEle").value,$("allE1CapEle").value,hservicetype);
	    	}
	    	if( tslotid == $("hPolarBdEle").value )
	    	{
	    		hservicetype = ifservicetype;
	    		_this.refreshXPICHElement(gue1,ethBandWidthValue + "-" + ethBandWidthHighValue,e1statue,alle1,hservicetype);
	    		_this.refreshXPICVElement($("guE1CapEle").value,$("ethBandEle").value,$("e1StatusEle").value,$("allE1CapEle").value,vservicetype);
	    	}
	    	if( tslotid == g_commonData.getRelatedODUSlotId($("vPolarBdEle").value) )
	    	{
	    		$("rxpw_vEle").value = actTXPowerValue;
	    		$("repw_vEle").value = rePowerValue;
	    		rfParamCache["repw_vEle"].updateElementValueToCacheValue();
	    	}
	    	if( tslotid == g_commonData.getRelatedODUSlotId($("hPolarBdEle").value) )
	    	{
	    		$("rxpw_hEle").value = actTXPowerValue;
	    		$("repw_hEle").value = rePowerValue;
	    		rfParamCache["repw_hEle"].updateElementValueToCacheValue();
	    	}
	    }
	    ifParamCache["guE1CapEle_V"].updateElementValueToCacheValue();
		ifParamCache["e1StatusEle_V"].updateElementValueToCacheValue();
		ifParamCache["allE1CapEle_V"].updateElementValueToCacheValue();
		ifParamCache["guE1CapEle_H"].updateElementValueToCacheValue();
		ifParamCache["e1StatusEle_H"].updateElementValueToCacheValue();
		ifParamCache["allE1CapEle_H"].updateElementValueToCacheValue();
		
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	    if(vservicetype == hservicetype)
	    {
	    	if(ifSlotId == $("vPolarBdEle").value)
	    	{
	    		_this.refreshXPICHElement($("guE1CapEle").value,$("ethBandEle").value,$("e1StatusEle").value,$("allE1CapEle").value,hservicetype);
	    	}
			if(ifSlotId == $("hPolarBdEle").value)
		    {
		    	_this.refreshXPICVElement($("guE1CapEle").value,$("ethBandEle").value,$("e1StatusEle").value,$("allE1CapEle").value,vservicetype);
			}
		}
    	ifParamCache["guE1CapEle_V"].updateElementBgColor();
		ifParamCache["e1StatusEle_V"].updateElementBgColor();
		ifParamCache["allE1CapEle_V"].updateElementBgColor();
		ifParamCache["guE1CapEle_H"].updateElementBgColor();
		ifParamCache["e1StatusEle_H"].updateElementBgColor();
		ifParamCache["allE1CapEle_H"].updateElementBgColor();
	}
	
	/**
	 *   XPIC       
	 */
	this.responseXpicEnableEvent = function(event)
	{
		var enableStatus = event.getXPICStatus();
		
		if( HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion) == false )
		{
			return;
		}
		
		$("guE1CapTR_XPIC").style.display = (enableStatus == true) ? "" : "none";
		$("ethBandTR_XPIC").style.display = (enableStatus == true && !$("if1plus1").checked) ? "" : "none";
		
		if( enableStatus == true )
		{
			$("guE1CapTR").style.display = "none";
		}
		else
		{
			if( $("ifservtypeEle").value == ifServiceTypeStru.STMETH_VAL || $("ifservtypeEle").value == ifServiceTypeStru.SDH_VAL )
			{
				$("guE1CapTR").style.display = "none";	
			}
			else
			{
				$("guE1CapTR").style.display = "";
				_this.doBusinessIf_AMEleChanged();
			}
		}
		
		$("ethBandTR").style.display = enableStatus == true ? "none" : "";
		
		$("e1StatusTR_XPIC").style.display = (enableStatus == true && $("amEle").checked) ? "" : "none";
		$("allE1CapTR_XPIC").style.display = (enableStatus == true && $("amEle").checked) ? "" : "none";
		
		if( enableStatus == true )
		{
			$("e1StatusAndAllE1Cap_TR").style.display = "none";	
		}
		
		if( $("enablexpicEle").checked == true )
		{
			if( xpicCache["enablexpicEle"].getCacheValue() == false )
			{
				_this.queryEthBandWidth();
				/*$("guE1CapEle_V").value = $("guE1CapEle").value;
				$("ethBandEle_V").value = $("ethBandEle").value;
				$("e1StatusEle_V").value = $("e1StatusEle").value;
				ifParamCache["allE1CapEle_V"].setElementDisabled( $("e1StatusEle_V").value == 1 ? false : true );
				$("allE1CapEle_V").value = $("allE1CapEle").value;
				
				$("guE1CapEle_H").value = $("guE1CapEle").value;
				$("ethBandEle_H").value = $("ethBandEle").value;
				$("e1StatusEle_H").value = $("e1StatusEle").value;
				ifParamCache["allE1CapEle_H"].setElementDisabled( $("allE1CapEle_H").value == 1 ? false : true );
				$("allE1CapEle_H").value = $("allE1CapEle").value;
				var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
				if( ifSlotId == $("vPolarBdEle").value )
				{
					ifParamCache["guE1CapEle_H"].updateElementBgColor();
					ifParamCache["e1StatusEle_H"].updateElementBgColor();
					ifParamCache["allE1CapEle_H"].updateElementBgColor();
				}

				if( ifSlotId == $("hPolarBdEle").value )
				{
					ifParamCache["guE1CapEle_V"].updateElementBgColor();
					ifParamCache["e1StatusEle_V"].updateElementBgColor();
					ifParamCache["allE1CapEle_V"].updateElementBgColor();
				}*/
			}
		}
		
		_this.filterUnsupportAttrByNeTypeAndNeversion();
	}
	


	/**
	 **    RTN   E1  E1   
	 **  V1R2C00         E1  E1    
	 **/
	this.dispalyE1StatusAndAllE1CapTR = function(flag)
	{	
		if(flag && (!HopTookit.isRTN900NA(neid, neType) && HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion)))
		{
			if( $("enablexpicEle").checked)
			{
				 $("e1StatusTR_XPIC").style.display = "";
				 $("allE1CapTR_XPIC").style.display = "";
			}
			else
			{
				 $("e1StatusAndAllE1Cap_TR").style.display = "";			
			}		
		}
		else
		{
		    $("e1StatusAndAllE1Cap_TR").style.display = "none";
			$("e1StatusTR_XPIC").style.display = "none";
			$("allE1CapTR_XPIC").style.display = "none";
		}
		
	}

	/**
	 **   ethBand
	 **/
	this.dispalyethBandTR = function(flag)
	{
		if(HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion) == false)
		{
			return;
		}
		if(flag)
		{
			if( $("enablexpicEle").checked && !$("if1plus1").checked)
			{
				 $("ethBandTR_XPIC").style.display = "";			
			}
			else
			{
				 $("ethBandTR").style.display = "";
				
			}		
		}
		else
		{
		    $("ethBandTR_XPIC").style.display = "none";		
			$("ethBandTR").style.display = "none";
		}
		
	}

	this.dispalyguE1CapTR = function(flag)
	{
		if(flag)
		{
			if( $("enablexpicEle").checked)
			{
				 $("guE1CapTR_XPIC").style.display = "";			
			}
			else
			{
				 $("guE1CapTR").style.display = "";
				
			}		
		}
		else
		{
		    $("guE1CapTR").style.display = "none";		
			$("guE1CapTR_XPIC").style.display = "none";
		}
		
	}

	this.dispalystm1CapTR = function(flag)
	{
		if( flag)
		{
			 $("stm1CapTR").style.display = "";			
		}
		else
		{
			 $("stm1CapTR").style.display = "none";			
		}	
			
	}

	this.dispalyamTR = function(flag)
	{		
		if(flag)
		{
			 $("amTR").style.display = "";
		    	
		    	if($("amEle").checked)
		    	{
		    	    $("ensureCalModeTR").style.display = "";
		    	    $("allCalModeTR").style.display = "";
		    	    $("manualmodeTR").style.display = "none";
		    	} 
		    	else 
		       {
		    	    $("ensureCalModeTR").style.display = "none";
		    	    $("allCalModeTR").style.display = "none";
		    	    $("manualmodeTR").style.display = "";
		    	}
		}
		else
		{
			$("amEle").checked = false;
			 $("amTR").style.display = "none";
			 $("ensureCalModeTR").style.display = "none";
		     $("allCalModeTR").style.display = "none";
		     $("manualmodeTR").style.display = "";
		}
			
	}

	/**
	 *            E1 
	 */
	this.isNeedPakageSendguE1 = function(ifservtypeValue)
	{
		if(ifServiceTypeStru.STMETH_VAL == ifservtypeValue || ifServiceTypeStru.SDH_VAL == ifservtypeValue)
		{
			return false;
		}
		else
		{
			return true;
		}
	}
	
	
	/**
	 **          E1  E1    AM          
	 **E1+ETH:       E1  E1    AM       
	 **STM-1+ETH:       STM-1 AM               E1 
	 **SDH:        STM-1 AM          
	 *     Null  IFU2,IFX2,:       E1  E1    AM       
	 **/
	this.setSTM1AndE1NumStatus = function(ifservtypeValue)
	{		
		if(ifServiceTypeStru.E1ETH_VAL == ifservtypeValue )
		{
			_this.dispalystm1CapTR(false);
			_this.dispalyguE1CapTR(true);    	
			_this.dispalyE1StatusAndAllE1CapTR(true);
			_this.dispalyamTR(true);
			_this.dispalyethBandTR(true);  	
			
			ifParamCache["stm1CapEle"].setElementDisabled(true);
			ifParamCache["e1StatusEle"].setElementDisabled(false);
			if($("amEle").checked)
			{
				 $("e1StatusAndAllE1Cap_TR").style.display = "";
				 
			}else{
				 $("e1StatusAndAllE1Cap_TR").style.display = "none";
			}

	    	ifParamCache["guE1CapEle"].setElementDisabled(false);
	    	
	    	 if($("guE1CapEle").value == "")
			  {
			    	$("guE1CapEle").value = 1;
			   	    ifParamCache["guE1CapEle"].updateElementBgColor();
			  }	  
	    	 
			if($("e1StatusEle").value == "")
			{
				$("e1StatusEle").value = EnableStatus.DISABLED;
			}
	    
	    } 
	    else if(ifServiceTypeStru.STMETH_VAL == ifservtypeValue)
	    {
	    	
	    	_this.dispalystm1CapTR(true);
	    	_this.dispalyguE1CapTR(false);    	
	    	_this.dispalyE1StatusAndAllE1CapTR(false);
	    	_this.dispalyamTR(true);
	    	_this.dispalyethBandTR(true); 
	    	
			if($("stm1CapEle").value == "")
			{
				$("stm1CapEle").value = 1;
				ifParamCache["stm1CapEle"].updateElementBgColor();
			}
	    	
			ifParamCache["stm1CapEle"].setElementDisabled(false);
			ifParamCache["e1StatusEle"].setElementDisabled(true);	    	
	    	ifParamCache["guE1CapEle"].setElementDisabled(true);
	    }
	   else if(ifServiceTypeStru.SDH_VAL == ifservtypeValue)
	    {
	        
		   _this.dispalystm1CapTR(true);
		   _this.dispalyguE1CapTR(false);    	
		   _this.dispalyE1StatusAndAllE1CapTR(false);
		   _this.dispalyamTR(false);
		   _this.dispalyethBandTR(false); 
		   
			if($("stm1CapEle").value == "")
			{
				$("stm1CapEle").value = 1;
				ifParamCache["stm1CapEle"].updateElementBgColor();
			}
		   
			ifParamCache["stm1CapEle"].setElementDisabled(false);
			ifParamCache["e1StatusEle"].setElementDisabled(true);	    	
	    	ifParamCache["guE1CapEle"].setElementDisabled(true);
	    } 
	    else
	    {
	    	 _this.dispalystm1CapTR(false);
	    	 _this.dispalyguE1CapTR(true);    	
	    	 _this.dispalyE1StatusAndAllE1CapTR(true);
	    	 _this.dispalyamTR(true);
	    	 _this.dispalyethBandTR(true); 
	    	 
    		ifParamCache["stm1CapEle"].setElementDisabled(true);
			ifParamCache["e1StatusEle"].setElementDisabled(false);	    
	    	ifParamCache["guE1CapEle"].setElementDisabled(false);
	     
	    }  
		_this.showAMContentTr($("amEle").checked);
	}
	/**
	 *           
	 * @return
	 */
	this.showIFAttriField = function()
	{
		var advStyle = $('IFParamField').style.display;
		if (!_this.isExpend && $("IFParamField").style.display == "none") 
		{
			querySpecialStart();
		}
		var isQuery = !_this.isExpend;
		_this.showIFAttriFieldWithoutSendingEvent(advStyle,isQuery);
		
		HopTookit.sendUnionFoldEvent(terminalType, "arrowImg_if", _this, advStyle,isQuery);
	}
	
	/**
	 *            
	 * @param {Object} advStyle
	 * @param {Object} isQuery
	 */
	this.showIFAttriFieldWithoutSendingEvent = function(advStyle,isQuery)
	{
		$("IFParamField").style.display = advStyle == "none" ? "" : "none";
		$("arrowImg_if").src = advStyle == "" ? "../../../../images/right.gif" : "../../../../images/down.gif";
		if(isQuery && $("IFParamField").style.display == "")
		{
			_this.isExpend = true;
			queryIFSpecialInfomation();
		}
	}
	
	this.checkGuaranteeCapcityRange = function(min, max)
	{
		HopTookit.checkDataRange($("guE1CapEle"), min, max);
		HopTookit.checkDataRange($("guE1CapEle_V"), min, max);
		HopTookit.checkDataRange($("guE1CapEle_H"), min, max);
	}
	
	this.checkFullCapacityRange = function(min, max)
	{
		HopTookit.checkDataRange($("allE1CapEle"), min, max);
		HopTookit.checkDataRange($("allE1CapEle_V"), min, max);
		HopTookit.checkDataRange($("allE1CapEle_H"), min, max);
	}
}

/**
 *                                    
 * @param obj  bandWidthObj
 * @return
 */
IFAttriModule.prototype.updateModeOption = function(obj, modelObj)
{
	var ifServiceType = modelObj.ifServiceType;
	var ifBandWidth = modelObj.ifBandWidth;
	var ifRunMode = modelObj.ifRunMode;
	ifServiceType = HopTookit.isDataValid(ifServiceType)?ifServiceType:modelObj.ifServiceType_default;
	ifBandWidth = HopTookit.isDataValid(ifBandWidth)?ifBandWidth:modelObj.ifBandWidth_default;
	ifRunMode = HopTookit.isDataValid(ifRunMode)?ifRunMode:modelObj.ifRunMode_default;
	var key = ifBandWidth;
	
	var modeObj = ensureCalModeStru;
	if(capacityMap &&  capacityMap[key])
	{
	    modeObj = capacityMap[key];
	}
	
	if( HopTookit.isSupportHighLevelModulation() )
	{
		updateModeOptionText(obj, modeObj.MODE_QPSKStrong, ensureCalModeStru.MODE_QPSKStrong, ensureCalModeStru.MODE_QPSKStrong_VAL);
		updateModeOptionText(obj, modeObj.MODE_QPSK, ensureCalModeStru.MODE_QPSK, ensureCalModeStru.MODE_QPSK_VAL);
		updateModeOptionText(obj, modeObj.MODE_16QAMStrong, ensureCalModeStru.MODE_16QAMStrong, ensureCalModeStru.MODE_16QAMStrong_VAL);
		updateModeOptionText(obj, modeObj.MODE_16QAM, ensureCalModeStru.MODE_16QAM, ensureCalModeStru.MODE_16QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_32QAM, ensureCalModeStru.MODE_32QAM, ensureCalModeStru.MODE_32QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_64QAM, ensureCalModeStru.MODE_64QAM, ensureCalModeStru.MODE_64QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_128QAM, ensureCalModeStru.MODE_128QAM, ensureCalModeStru.MODE_128QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_256QAM, ensureCalModeStru.MODE_256QAM, ensureCalModeStru.MODE_256QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_512QAM, ensureCalModeStru.MODE_512QAM, ensureCalModeStru.MODE_512QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_512QAMLight, ensureCalModeStru.MODE_512QAMLight, ensureCalModeStru.MODE_512QAMLight_VAL);
		updateModeOptionText(obj, modeObj.MODE_1024QAM, ensureCalModeStru.MODE_1024QAM, ensureCalModeStru.MODE_1024QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_1024QAMLight, ensureCalModeStru.MODE_1024QAMLight, ensureCalModeStru.MODE_1024QAMLight_VAL);
	}
	else
	{
		updateModeOptionText(obj, modeObj.MODE_QPSK, ensureCalModeStru.MODE_QPSK, ensureCalModeStru.MODE_QPSK_VAL);
		updateModeOptionText(obj, modeObj.MODE_16QAM, ensureCalModeStru.MODE_16QAM, ensureCalModeStru.MODE_16QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_32QAM, ensureCalModeStru.MODE_32QAM, ensureCalModeStru.MODE_32QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_64QAM, ensureCalModeStru.MODE_64QAM, ensureCalModeStru.MODE_64QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_128QAM, ensureCalModeStru.MODE_128QAM, ensureCalModeStru.MODE_128QAM_VAL);
		updateModeOptionText(obj, modeObj.MODE_256QAM, ensureCalModeStru.MODE_256QAM, ensureCalModeStru.MODE_256QAM_VAL);
	}
}

IFAttriModule.prototype.addCalModeElementOptionFor3_5M = function(obj)
{
	if(obj)
	{
		var key = bandWidthStru.FREQ_3_5MHz_VAL;
		var modeObj = ensureCalModeStru;

		if(capacityMap &&  capacityMap[key])
		{
		    modeObj = capacityMap[key];
		}
		var ovalue = obj.value;
		obj.options.length = 0;
		addModeOption(obj, modeObj.MODE_QPSK, modeObj.MODE_QPSK_VAL, ensureCalModeStru.MODE_QPSK, ensureCalModeStru.MODE_QPSK_VAL);
		addModeOption(obj, modeObj.MODE_16QAM, modeObj.MODE_16QAM_VAL, ensureCalModeStru.MODE_16QAM, ensureCalModeStru.MODE_16QAM_VAL);
		obj.value = ovalue;
		if(obj.selectedIndex == -1)
		{
			obj.selectedIndex = 0;
		}
	}
}

/**
 *        CalMode                
 * @param obj
 * @return
 */
IFAttriModule.prototype.addCalModeElementOption = function(obj, modelObj)
{
	var ifServiceType = modelObj.ifServiceType;
	var ifBandWidth = modelObj.ifBandWidth;
	var ifRunMode = modelObj.ifRunMode;
	ifServiceType = HopTookit.isDataValid(ifServiceType)?ifServiceType:modelObj.ifServiceType_default;
	ifBandWidth = HopTookit.isDataValid(ifBandWidth)?ifBandWidth:modelObj.ifBandWidth_default;
	ifRunMode = HopTookit.isDataValid(ifRunMode)?ifRunMode:modelObj.ifRunMode_default;
	var key = ifBandWidth;

	var oldValue = obj.value;
	obj.options.length = 0;
	var modeObj = ensureCalModeStru;
	if(capacityMap && capacityMap[key])
	{
	    modeObj = capacityMap[key];
	}
	var relation1 = amRelation[ifServiceType];
	var modes = getSupportModes(relation1, ifBandWidth,ifRunMode);
	
	/**	  RTN900     5.*.06.10  ,SL91ISV3/SLD1ISV3         7M/14M/40M ,
		    512QAM/512QAM Light/1024QAM/1024QAM Light       
		RTN905 2A/1C 5.95.06.10 
		RTN910 5.76.06.10 
		RTN950 5.76.06.10 
		RTN950A 5.114.06.10 
		RTN980 5.83.06.10
	 */
	var tSlotID = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	if( ifServiceType == ifServiceTypeStru.E1ETH_VAL &&
		(ifBandWidth == bandWidthStru.FREQ_7MHz_VAL || ifBandWidth == bandWidthStru.FREQ_14MHz_VAL || ifBandWidth == bandWidthStru.FREQ_40MHz_VAL) &&	
		ifRunMode != ifRunModeStru.IS2_VAL &&
		!SpecialAttrMgr.isCPSupport(neid, tSlotID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_7MBINDWIDTH_SUPPORT_1024QAMLIGHT") )
	{
		modes.remove(ensureCalModeStru.MODE_512QAM_VAL);
		modes.remove(ensureCalModeStru.MODE_512QAMLight_VAL);
		modes.remove(ensureCalModeStru.MODE_1024QAM_VAL);
		modes.remove(ensureCalModeStru.MODE_1024QAMLight_VAL);
	}
	
	/**
	  	Hybrid(STM-1+ETH)        40M  
		       512QAM/512QAM Light/1024QAM/1024QAM Light
		         
		RTN905 1C 5.95.06.10
		RTN910 5.76.06.10
		RTN950 5.76.06.10
		RTN950A 5.114.06.10
		RTN980 5.83.06.10
		       SL91ISV3
	 */
	if( ifServiceType == ifServiceTypeStru.STMETH_VAL && 
		ifBandWidth == bandWidthStru.FREQ_40MHz_VAL &&
		ifRunMode != ifRunModeStru.IS2_VAL &&
		!SpecialAttrMgr.isCPSupport(neid, tSlotID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_STM1ETH_40M_SUPPORT_1024QAMLIGHT") )
	{
		modes.remove(ensureCalModeStru.MODE_512QAM_VAL);
		modes.remove(ensureCalModeStru.MODE_512QAMLight_VAL);
		modes.remove(ensureCalModeStru.MODE_1024QAM_VAL);
		modes.remove(ensureCalModeStru.MODE_1024QAMLight_VAL);
	}
	
	if(modes && modes.length > 0)
	{
		var rangeListStr = obj.getAttribute("rangeList");
		var rangeList = [];
		if(typeof(rangeListStr) != "undefined" && rangeListStr != null && rangeListStr != "")
		{
			var rangeobjlist = JSON.parse(rangeListStr);
			rangeList = rangeobjlist[0].list;
		}
		for(var index = 0,len = modes.length;index < len;index++)
		{
			var textValue = modes[index];
			if(rangeList.length > 0 && !rangeList.contains(textValue))
			{
				continue;
			}
			var defaultModeTextValue = ensureCalModeDynStru[textValue];
			var modeValue = modeObj[textValue]||defaultModeTextValue;
			
			if(!modeValue && ! defaultModeTextValue)
			{
				continue;
			}
			addModeOption(obj, modeValue, textValue, defaultModeTextValue, textValue);
		}
	}
	else
	{
		if( HopTookit.isSupportHighLevelModulation() )
		{
			addModeOption(obj, modeObj.MODE_QPSKStrong, modeObj.MODE_QPSKStrong_VAL, ensureCalModeStru.MODE_QPSKStrong, ensureCalModeStru.MODE_QPSKStrong_VAL);
			addModeOption(obj, modeObj.MODE_QPSK, modeObj.MODE_QPSK_VAL, ensureCalModeStru.MODE_QPSK, ensureCalModeStru.MODE_QPSK_VAL);
			addModeOption(obj, modeObj.MODE_16QAMStrong, modeObj.MODE_16QAMStrong_VAL, ensureCalModeStru.MODE_16QAMStrong, ensureCalModeStru.MODE_16QAMStrong_VAL);
			addModeOption(obj, modeObj.MODE_16QAM, modeObj.MODE_16QAM_VAL, ensureCalModeStru.MODE_16QAM, ensureCalModeStru.MODE_16QAM_VAL);
			addModeOption(obj, modeObj.MODE_32QAM, modeObj.MODE_32QAM_VAL, ensureCalModeStru.MODE_32QAM, ensureCalModeStru.MODE_32QAM_VAL);
			addModeOption(obj, modeObj.MODE_64QAM, modeObj.MODE_64QAM_VAL, ensureCalModeStru.MODE_64QAM, ensureCalModeStru.MODE_64QAM_VAL);
			addModeOption(obj, modeObj.MODE_128QAM, modeObj.MODE_128QAM_VAL, ensureCalModeStru.MODE_128QAM, ensureCalModeStru.MODE_128QAM_VAL);
			addModeOption(obj, modeObj.MODE_256QAM, modeObj.MODE_256QAM_VAL, ensureCalModeStru.MODE_256QAM, ensureCalModeStru.MODE_256QAM_VAL);
			addModeOption(obj, modeObj.MODE_512QAM, modeObj.MODE_512QAM_VAL, ensureCalModeStru.MODE_512QAM, ensureCalModeStru.MODE_512QAM_VAL);
			addModeOption(obj, modeObj.MODE_512QAMLight, modeObj.MODE_512QAMLight_VAL, ensureCalModeStru.MODE_512QAMLight, ensureCalModeStru.MODE_512QAMLight_VAL);
			addModeOption(obj, modeObj.MODE_1024QAM, modeObj.MODE_1024QAM_VAL, ensureCalModeStru.MODE_1024QAM, ensureCalModeStru.MODE_1024QAM_VAL);
			addModeOption(obj, modeObj.MODE_1024QAMLight, modeObj.MODE_1024QAMLight_VAL, ensureCalModeStru.MODE_1024QAMLight, ensureCalModeStru.MODE_1024QAMLight_VAL);
			
		}
		else
		{
			addModeOption(obj, modeObj.MODE_QPSK, modeObj.MODE_QPSK_VAL, ensureCalModeStru.MODE_QPSK, ensureCalModeStru.MODE_QPSK_VAL);
			addModeOption(obj, modeObj.MODE_16QAM, modeObj.MODE_16QAM_VAL, ensureCalModeStru.MODE_16QAM, ensureCalModeStru.MODE_16QAM_VAL);
			addModeOption(obj, modeObj.MODE_32QAM, modeObj.MODE_32QAM_VAL, ensureCalModeStru.MODE_32QAM, ensureCalModeStru.MODE_32QAM_VAL);
			addModeOption(obj, modeObj.MODE_64QAM, modeObj.MODE_64QAM_VAL, ensureCalModeStru.MODE_64QAM, ensureCalModeStru.MODE_64QAM_VAL);
			addModeOption(obj, modeObj.MODE_128QAM, modeObj.MODE_128QAM_VAL, ensureCalModeStru.MODE_128QAM, ensureCalModeStru.MODE_128QAM_VAL);
			addModeOption(obj, modeObj.MODE_256QAM, modeObj.MODE_256QAM_VAL, ensureCalModeStru.MODE_256QAM, ensureCalModeStru.MODE_256QAM_VAL);
		}
	}

	if("" == oldValue)
	{
		obj.selectedIndex = 0;
	}
	else
	{
		var index = getOptionsSelectedIndex(obj.options,oldValue);
		obj.selectedIndex = index;
	}
}

function getOptionsSelectedIndex(arr,value)
{
	var selectedIndex = 0;
	for(var i = 0,len = arr.length;i < len;i++)
	{
		var obj = arr[i];
		if(arr[i].value == value)
		{
			selectedIndex = i;
			break;
		}
	}
	return selectedIndex;
}
/**
 *                             
 * @param obj
 * @return
 */
 /**                             
IFAttriModule.prototype.addBandWidthElementOption = function(obj)
{
    obj.options.length = 0;
    
    var stru = bandWidthStru;
    
    if(bandWidthStruNew)
    {
        stru = bandWidthStruNew;
    }
    
    if(HopTookit.isRTN900NA(neid, neType))
    {
        if(stru.FREQ_30MHz_NA)
        {
            obj.options[$("ifchannelbandwidthEle").options.length] = new Option(stru.FREQ_30MHz_NA, stru.FREQ_30MHz_VAL_NA);
        }
        
        if(stru.FREQ_40MHz_NA)
        {
            obj.options[$("ifchannelbandwidthEle").options.length] = new Option(stru.FREQ_40MHz_NA, stru.FREQ_40MHz_VAL_NA);
        }
        
        if(stru.FREQ_50MHz_NA)
        {
            obj.options[$("ifchannelbandwidthEle").options.length] = new Option(stru.FREQ_50MHz_NA, stru.FREQ_50MHz_VAL_NA);
        }
    } else {
        if(stru.FREQ_7MHz)
        {
            obj.options[$("ifchannelbandwidthEle").options.length] = new Option(stru.FREQ_7MHz, stru.FREQ_7MHz_VAL);
        }
        
        if(stru.FREQ_14MHz)
        {
            obj.options[$("ifchannelbandwidthEle").options.length] = new Option(stru.FREQ_14MHz, stru.FREQ_14MHz_VAL);
        }
        
        if(stru.FREQ_28MHz)
        {
            obj.options[$("ifchannelbandwidthEle").options.length] = new Option(stru.FREQ_28MHz, stru.FREQ_28MHz_VAL);
        }
        
        if(stru.FREQ_40MHz)
        {
            obj.options[$("ifchannelbandwidthEle").options.length] = new Option(stru.FREQ_40MHz, stru.FREQ_40MHz_VAL);
        }
        
        if(stru.FREQ_56MHz)
        {
            obj.options[$("ifchannelbandwidthEle").options.length] = new Option(stru.FREQ_56MHz, stru.FREQ_56MHz_VAL);
        }
    }
}**/



/**
 *       AM          
 * @param amStyle
 * @return
 */
IFAttriModule.prototype.showAMContentTr = function(amStyle)
{
	if( !HopTookit.isDataInBusinessValid(amStyle) )
	{
		amStyle = false;
	}
	
	$("ensureCalModeTR").style.display = amStyle == false ? "none" : "";
	
	$("allCalModeTR").style.display = amStyle == false ? "none" : "";
	
	if(HopTookit.isRTN900NA(neid, neType) || !HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion))
	{
	    $("e1StatusTR").style.display = "none";
	   
	    $("e1StatusTR_XPIC").style.display = "none";
		$("allE1CapTR_XPIC").style.display = "none";
	   
	}
	else
	{ 
		if(ifParamCache["ifservtypeEle"].getElementValue() != ifServiceTypeStru.STMETH_VAL && ifParamCache["ifservtypeEle"].getElementValue() != ifServiceTypeStru.SDH_VAL)
		{	   
		    $("e1StatusTR").style.display = amStyle == false ? "none" : "";	
			$("e1StatusTR_XPIC").style.display = ($("enablexpicEle").checked == true && amStyle == true) ? "" : "none";
		    $("allE1CapTR_XPIC").style.display = ($("enablexpicEle").checked == true && amStyle == true) ? "" : "none";
		    
	        if($("e1StatusEle").value == "")
	    	{
	    	   $("e1StatusEle").value = EnableStatus.DISABLED;
	    	}	
	       
	       $("allE1CapTR").style.display = (amStyle == true && $("e1StatusEle").value == EnableStatus.ENABLED) ? "" : "none";	
	       $("e1StatusAndAllE1Cap_TR").style.display = (amStyle == false || $("enablexpicEle").checked == true) ? "none" : "";
	    }	    
	 
	}
	
	if(!HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion))
	{
	    $('ethBandTR').style.display = 'none';
	}
	
	$("manualmodeTR").style.display = amStyle == true ? "none" : "";
	
}


/**
 *  row     ACM   Parameter
 */
IFAttriModule.prototype.setAcmParam = function(row,acmEnableStatVal, ensureCalModeVal, allCalModeVal, manualModeVal)
{
	HopTookit.addParam(row, "W32PORT_ATTR_ACMENABLESTATUS", acmEnableStatVal);

	HopTookit.addParam(row, "W32PORT_ATTR_ENSURECALMODE", ensureCalModeVal);
    
	HopTookit.addParam(row, "W32PORT_ATTR_ALLCALMODE", allCalModeVal);
	
	HopTookit.addParam(row, "W32PORT_ATTR_MANUALMODE", manualModeVal);
}

IFAttriModule.prototype.isAMElementsModified = function()
{
	var result = false;
	
	if( ifParamCache["amEle"].isElementModified() ||
		(ifParamCache["amEle"].getElementValue()== true && ifParamCache["ensureCalModeEle"].isElementModified()) ||
	    (ifParamCache["amEle"].getElementValue()== true && ifParamCache["allCalModeEle"].isElementModified()) ||
	    (ifParamCache["amEle"].getElementValue()== false && ifParamCache["manualmodeEle"].isElementModified()) )
	{
		result = true;
	}
	
	return result;
}

IFAttriModule.prototype.isAnyIFAttrModified = function()
{
        if(!HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion))
        {
            return false;//  V1R2C00       900        E1       ACM        
        }
        
	var result = false;
	
	if( ifParamCache["amEle"].isElementModified() ||
		(ifParamCache["amEle"].getElementValue()== true && ifParamCache["ensureCalModeEle"].isElementModified()) ||
		(ifParamCache["amEle"].getElementValue()== true && ifParamCache["allCalModeEle"].isElementModified()) ||
		(ifParamCache["amEle"].getElementValue()== false && ifParamCache["manualmodeEle"].isElementModified()) ||
		(HopTookit.isDataInBusinessValid($("ifchannelbandwidthEle").value) && ifParamCache["ifchannelbandwidthEle"].isElementModified()) ||
	    (HopTookit.isDataInBusinessValid($("guE1CapEle").value) && ifParamCache["guE1CapEle"].isElementModified() == true) ||
	    ($('e1StatusTR').style.display != 'none' && ifParamCache["e1StatusEle"].isElementModified() == true))
	{
		result = true;
	}
	
	return result;
}
IFAttriModule.prototype.clearAttriFieldBgColor = function()
{
	$("linkEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	
	if( $("if1workmodeEle").disabled == false )
	{
		$("if1workmodeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("ifservtypeEle").disabled == false )
	{
		$("ifservtypeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("ifchannelbandwidthEle").disabled == false )
	{
		$("ifchannelbandwidthEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("stm1CapEle").disabled == false )
	{
		$("stm1CapEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("amEle").disabled == false )
	{
		$("amEle").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
	}
	if( $("ensureCalModeEle").disabled == false )
	{
		$("ensureCalModeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("allCalModeEle").disabled == false )
	{
		$("allCalModeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("manualmodeEle").disabled == false )
	{
		$("manualmodeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("guE1CapEle").disabled == false )
	{
		$("guE1CapEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("e1CapEle").disabled == false )
	{
		$("e1CapEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("e1StatusEle").disabled == false )
	{
		$("e1StatusEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("e1StatusEle_V").disabled == false )
	{
		$("e1StatusEle_V").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("e1StatusEle_H").disabled == false )
	{
		$("e1StatusEle_H").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("guE1CapEle_V").disabled == false )
	{
		$("guE1CapEle_V").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}
	if( $("guE1CapEle_H").disabled == false )
	{
		$("guE1CapEle_H").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	}

	$("allE1CapEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	
	$("hLinkIdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("vLinkIdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
}

/**
 *     
 */
IFAttriModule.prototype.refreshCache = function()
{
	ifParamCache["linkEle"].updateElementValueToCacheValue();
	ifParamCache["if1workmodeEle"].updateElementValueToCacheValue();
	ifParamCache["ifservtypeEle"].updateElementValueToCacheValue();
	ifParamCache["ifchannelbandwidthEle"].updateElementValueToCacheValue();
	ifParamCache["amEle"].updateElementValueToCacheValue();
	ifParamCache["ensureCalModeEle"].updateElementValueToCacheValue();
	ifParamCache["allCalModeEle"].updateElementValueToCacheValue();
	ifParamCache["manualmodeEle"].updateElementValueToCacheValue();
	ifParamCache["guE1CapEle"].updateElementValueToCacheValue();
	ifParamCache["e1CapEle"].updateElementValueToCacheValue();
	ifParamCache["e1StatusEle"].updateElementValueToCacheValue();
	ifParamCache["allE1CapEle"].updateElementValueToCacheValue();
	ifParamCache["stm1CapEle"].updateElementValueToCacheValue();

	ifParamCache["hLinkIdEle"].updateElementValueToCacheValue();
	ifParamCache["vLinkIdEle"].updateElementValueToCacheValue();
}

/**
 * UCD                 
 */
IFAttriModule.prototype.filterUnsupportAllMoulationOptions = function()
{
	var allCalModeOriVal = $("allCalModeEle").value;
	
	$("allCalModeEle").options.length = 0;
	
	var stru = ensureCalModeDynStru;
	
	if(ensureCalModeDynStruNew)
	{
	    stru = ensureCalModeDynStruNew;
	}
	var rangeListStr = $("allCalModeEle").getAttribute("rangeList");
	var rangeList = [];
	if(typeof(rangeListStr) != "undefined" && rangeListStr != null && rangeListStr != "")
	{
		var rangeobjlist = JSON.parse(rangeListStr);
		rangeList = rangeobjlist[0].list;
	}
	for( var key in stru )
	{
		if(isNaN(key))
		{
			continue;
		}
		
		if( HopTookit.compareModulations($("ensureCalModeEle").value, key) > 0 )
		{
			continue;
		}
		
		var ifBandWidth = $("ifchannelbandwidthEle").value;
		
		if ( ifBandWidth == bandWidthStru.FREQ_3_5MHz_VAL && 
			 HopTookit.compareModulations(key, ensureCalModeStru.MODE_16QAM_VAL) > 0
			)
		{
			continue;
		}
		if(rangeList.length > 0 && !rangeList.contains(key))
		{
			continue;
		}
		$("allCalModeEle").options[$("allCalModeEle").options.length] =	new Option(stru[key], key);	
	}
	
	if( HopTookit.compareModulations(
			parseInt(allCalModeOriVal), parseInt($("ensureCalModeEle").value)
									) > 0 )
	{
		$("allCalModeEle").value = allCalModeOriVal;
	}
	else
	{
		ifParamCache["allCalModeEle"].setElementValue( $("ensureCalModeEle").value );
	}
}


/**
 **        7M: 1,QPSK,10M% 2,16QAM, 20M% 3,32QAM, 25M% 4,64QAM, 32M% 5,128QAM, 38M% 6,256QAM, 44M
 **             :                                                             %    
 ** 
 **/
IFAttriModule.prototype.initGloabParam = function(serviceCapacity, bandWidth)
{
    capacityMap = null;

    if(serviceCapacity)
    {
        capacityMap = new Object();
        parseBandWidthAndCapacity(serviceCapacity)
    }
}

IFAttriModule.prototype.updateEnsureCalModeDynStruNew = function(modelObj)
{
	ensureCalModeDynStruNew = null
	var ifServiceType = modelObj.ifServiceType;
	var ifBandWidth = modelObj.ifBandWidth;
	var ifRunMode = modelObj.ifRunMode;
	ifServiceType = HopTookit.isDataValid(ifServiceType)?ifServiceType:modelObj.ifServiceType_default;
	ifBandWidth = HopTookit.isDataValid(ifBandWidth)?ifBandWidth:modelObj.ifBandWidth_default;
	ifRunMode = HopTookit.isDataValid(ifRunMode)?ifRunMode:modelObj.ifRunMode_default;
	var bandWidth = ifBandWidth;

	var modeObj = ensureCalModeStru;
	if(capacityMap && capacityMap[bandWidth])
	{
	    modeObj = capacityMap[bandWidth];
	}
	
	ensureCalModeDynStruNew = new Object();
	var relation1 = amRelation[ifServiceType];
	var modes = getSupportModes(relation1, ifBandWidth,ifRunMode);


	/**	  RTN900     5.*.06.10  ,SL91ISV3/SLD1ISV3         7M/14M/40M ,
		    512QAM/512QAM Light/1024QAM/1024QAM Light       
		RTN905 2A/1C 5.95.06.10 
		RTN910 5.76.06.10 
		RTN950 5.76.06.10 
		RTN950A 5.114.06.10 
		RTN980 5.83.06.10
	 */
	var tSlotID = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	if( ifServiceType == ifServiceTypeStru.E1ETH_VAL &&
		(ifBandWidth == bandWidthStru.FREQ_7MHz_VAL || ifBandWidth == bandWidthStru.FREQ_14MHz_VAL || ifBandWidth == bandWidthStru.FREQ_40MHz_VAL) &&	
		ifRunMode != ifRunModeStru.IS2_VAL &&
		!SpecialAttrMgr.isCPSupport(neid, tSlotID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_7MBINDWIDTH_SUPPORT_1024QAMLIGHT") )
	{
		modes.remove(ensureCalModeStru.MODE_512QAM_VAL);
		modes.remove(ensureCalModeStru.MODE_512QAMLight_VAL);
		modes.remove(ensureCalModeStru.MODE_1024QAM_VAL);
		modes.remove(ensureCalModeStru.MODE_1024QAMLight_VAL);
	}
	/**
	  	Hybrid(STM-1+ETH)        40M  
		       512QAM/512QAM Light/1024QAM/1024QAM Light
		         
		RTN905 1C 5.95.06.10
		RTN910 5.76.06.10
		RTN950 5.76.06.10
		RTN950A 5.114.06.10
		RTN980 5.83.06.10
		       SL91ISV3
	 */
	if( ifServiceType == ifServiceTypeStru.STMETH_VAL && 
		ifBandWidth == bandWidthStru.FREQ_40MHz_VAL &&
		ifRunMode != ifRunModeStru.IS2_VAL &&
		!SpecialAttrMgr.isCPSupport(neid, tSlotID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_STM1ETH_40M_SUPPORT_1024QAMLIGHT") )
	{
		modes.remove(ensureCalModeStru.MODE_512QAM_VAL);
		modes.remove(ensureCalModeStru.MODE_512QAMLight_VAL);
		modes.remove(ensureCalModeStru.MODE_1024QAM_VAL);
		modes.remove(ensureCalModeStru.MODE_1024QAMLight_VAL);
	}

	if(modes && modes.length > 0)
	{
		for(var index = 0,len = modes.length;index < len;index++)
		{
			var textValue = modes[index];
			var modeValue = modeObj[textValue];
			var defaultModeTextValue = ensureCalModeDynStru[textValue];
			updateDynModeStruText(textValue, modeValue);
		}
	}
	else
	{
    	if( HopTookit.isSupportHighLevelModulation() )
    	{
    		updateDynModeStruText(9, modeObj.MODE_QPSKStrong);
            updateDynModeStruText(1, modeObj.MODE_QPSK);
            updateDynModeStruText(10, modeObj.MODE_16QAMStrong);
            updateDynModeStruText(2, modeObj.MODE_16QAM);
            updateDynModeStruText(3, modeObj.MODE_32QAM);
            updateDynModeStruText(4, modeObj.MODE_64QAM);
            updateDynModeStruText(5, modeObj.MODE_128QAM);
            updateDynModeStruText(6, modeObj.MODE_256QAM);
            updateDynModeStruText(7, modeObj.MODE_512QAM);
            updateDynModeStruText(11, modeObj.MODE_512QAMLight);
	        updateDynModeStruText(8, modeObj.MODE_1024QAM);
	        updateDynModeStruText(12, modeObj.MODE_1024QAMLight);
	        
    	}
    	else
    	{
            updateDynModeStruText(1, modeObj.MODE_QPSK);
            updateDynModeStruText(2, modeObj.MODE_16QAM);
            updateDynModeStruText(3, modeObj.MODE_32QAM);
            updateDynModeStruText(4, modeObj.MODE_64QAM);
            updateDynModeStruText(5, modeObj.MODE_128QAM);
            updateDynModeStruText(6, modeObj.MODE_256QAM);
    	}
	}
}

/**
 **    RTN   E1  E1    STM-1      
 **  V1R2C00         E1  E1         STM-1      
 **/
IFAttriModule.prototype.filterUnsupportAttrByNeTypeAndNeversion = function()
{
    if( HopTookit.isRTN900NA(neid, neType) || !HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion))
    {
        $('ifservtypeTR').style.display = 'none';

		if (!HopTookit.isDataInBusinessValid($("guE1CapEle").value)) 
		{
			$('guE1CapTR').style.display = 'none';
		}
        $('guE1CapTR_XPIC').style.display = 'none';
        $('e1StatusTR').style.display = 'none';
        $('e1StatusTR_XPIC').style.display = 'none';
        $('allE1CapTR').style.display = 'none';
        
        $('stm1CapTR').style.display = 'none';
        
        if(!HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion))
        {
            $('ethBandTR').style.display = 'none';
        }
    }    
}
