
var HopTookit = new Object();

/**
 *                   
 * @param obj
 * @return
 */
HopTookit.setElementModified = function(obj)
{
	obj.style.backgroundColor = CELL_MODIFIED_BGCOLOR;	//      ,        
}

/**
 *                
 * @param obj
 * @return
 */
HopTookit.isElementModified = function(obj)
{
	var result = false;
	if(isIE)
	{
		result = obj.style.backgroundColor == CELL_MODIFIED_BGCOLOR ? true : false; 	
	}
	else
	{
		result = obj.style.backgroundColor == CELL_MODIFIED_BGCOLOR_SOLARIS ? true : false;
	}
	
	return result; 
}

/**
 *  Parameter   Row 
 * @param row
 * @param attriName
 * @param attriVal
 * @return
 */
HopTookit.addParam = function(row, attriName, attriVal)
{
    var param = new tagElement("param");
    param.setAttribute("name", attriName);
    param.setAttribute("value", attriVal );
    row.appendChild(param);
}

/**
 *         
 * @param val
 * @return
 */
HopTookit.isDataValid = function(val)
{
	if( val == null || val == "" || val == "undefined" )
	{
		return false; 
	}
	else
	{
		return true;
	}
}


/**
 *               
 * @param val
 * @return
 */
HopTookit.isDataInBusinessValid = function(val)
{
	if( val == null || val == "" || val == "undefined" || val == "-1" )
	{
		return false; 
	}
	else
	{
		return true;
	}
}

/**
 *   checkbox     
 * @param obj
 * @return
 */
HopTookit.getCheckboxEleValue = function(obj)
{
	return obj.checked == true ? "1" : "0";
}

/**
 *                 
 * 
 * @param flag
 * @param ifEditElement    input text  
 * @return
 */
HopTookit.setElementDisalbed = function(eleStr, flag, ifEditElement)
{
	$(eleStr).disabled = flag;

	var destinationColor = ifEditElement ? 
			CELL_ORIGINAL_EDIT_BGCOLOR : CELL_ORIGINAL_BGCOLOR;
	
	$(eleStr).style.backgroundColor = flag ? 
			CELL_DISABLED_BGCOLOR : destinationColor;
}

/**
 *    Option   Select   
 * @param element
 * @param optionName
 * @param optionId
 * @return
 */
HopTookit.addOptionToSelectElement = function(element, optionName, optionId)
{
	element.options[element.options.length] = new Option(optionName, optionId);
}

HopTookit.showErrorDialog = function(data)
{
    var errArr = [];
   
    errArr[0] = "nename";   
    openErrPage("../../../../page/", data.getError(), errArr);
}

HopTookit.showApplyErrorDialog = function(data)
{

    var errorObj = null;  
    for (var i = data.getBErrLength() - 1; i >= 0; i--) 
    {
    	
        errorObj = data.getError().rowErrors[i].errorObj;
       
        
        if (errorObj["attrId"] != null && "" != errorObj["attrId"])
        {
        	var attrId = errorObj["attrId"];
        	if(RESOURCE[attrId])
        	{
        		errorObj["attrId"] = RESOURCE[attrId];
        	}
        	else
            {
        		errorObj["attrId"] = "";
        	}        	
        }
    }	
	
    var errArr = [];    
    errArr[0] = "nename";
    errArr[1] = "slotid";
    errArr[2] = "boardname";
    errArr[3] = "attrId";
    openErrPage("../../../../page/", data.getError(), errArr);
}

/**
 *            
 * @param obj
 * @return
 */
HopTookit.setFocusOnElement = function(obj)
{
	if( obj == null )
	{
		return;
	}
	
	try{
		obj.focus();
	}catch(e)
	{
		
	}
}

/**
 *           
 * @param obj
 * @return
 */
HopTookit.replaceNegativeWithEmptyStr = function(value)
{
	return (!value || value == "-1") ? "" : value;
}

/**
 *            
 */
HopTookit.getPairIFBoard = function(ifslotid)
{
	var flag = ifslotid % 2;
	var pairslotid = flag == 0 ? ifslotid-1 : ifslotid +1;

	return pairslotid;
}

HopTookit.processCellOnchange = function(cache)
{
	cache.updateElementBgColor();
	
	parent.buttonStruct.applyButton.disabled = !parent.btnRightArr.applybtn.right;
}

/**
 *       Event
 */
function UnionEvent()
{
	var _this = this;
	
	this.eventType = EVENT_TYPE.LOCALOPPOSITEUNIONCHNANGE_EVENT;
	
	this.terminalType = ""; 
	
	this.elementID = "";
	
	this.flodStatus = "";
	
	this.isQuery = false;
	
	this.init = function(pTerminalType, pElementID)
	{
		_this.terminalType = pTerminalType;
		
		_this.elementID = pElementID;
	}
	
	this.getEventType = function()
	{
		return _this.eventType;
	}
	
	this.getTermialType = function()
	{
		return _this.terminalType;
	}
	
	this.getElementID = function()
	{
		return _this.elementID;
	}
	
	this.getElementValue = function()
	{
		return $(_this.elementID).value;
	}
	
	this.getElementChecked = function()
	{
		return $(_this.elementID).checked;
	}

	this.setElementDisplay = function(status)
	{
		_this.flodStatus = status;
	}
	
	this.getElementDisplay = function()
	{
		return _this.flodStatus;
	}
	
	this.setIsQuery = function(query)
	{
		_this.isQuery = query;
	}
	
	this.getIsQuery = function()
	{
		return _this.isQuery;
	}
}

/**
 *     
 */
HopTookit.sendUnionEvent = function(terminalType, eleId, obj)
{
	var event = new UnionEvent();
	event.init(terminalType, eleId);
	obj.notifyAll(event);
}

HopTookit.sendUnionFoldEvent = function(terminalType, eleId, obj, advStyle,isQuery)
{
	var event = new UnionEvent();
	event.init(terminalType, eleId);
	event.setElementDisplay(advStyle);
	if(typeof(isQuery) != "undefined")
	{
		event.setIsQuery(isQuery);	
	}
	obj.notifyAll(event);
}

/**
 *      
 */
HopTookit.checkDataRange = function(ele, minVal, maxVal, decimal, exceptval)
{
	ele.minValue = minVal;
		
	ele.maxValue = maxVal;
		
	ele.exceptValue = exceptval;
	
	if( decimal )			//     
	{
		if( exceptval )		//       
		{
			textCheck(ele, minVal, maxVal, decimal, exceptval);
		}
		else
		{
			checkText( ele, minVal, maxVal, decimal );
		}
	}
	else
	{
		if( exceptval )
		{
			textCheck(ele, minVal, maxVal, 0, exceptval);
		}
		else
		{
			checkText( ele, minVal, maxVal, 0);	
		}
	}
    
    HopTookit.setDataRangeTip(ele, minVal, maxVal, exceptval);
}

/**
 * val                                   
 */
HopTookit.adjustIntValueAccordingToRange = function(tmpTerminalType, ele, objVal)
{
	var minVal = ele.minValue;
	
	var maxVal = ele.maxValue;

	if( parseInt(objVal) > parseInt(maxVal) )
	{
		ele.value = maxVal;
		
		if( tmpTerminalType == TERMINAL_TYPE.LOCAL_END )
		{
			setTimeout(HopTookit.alertFarLater,500);	
		}
		else
		{
			setTimeout(HopTookit.alertLocalLater,500);
		}
	}
	else if( parseInt(objVal) < parseInt(minVal) )
	{
		ele.value = minVal;
		
		if( tmpTerminalType == TERMINAL_TYPE.LOCAL_END )
		{
			setTimeout(HopTookit.alertFarLater,500);	
		}
		else
		{
			setTimeout(HopTookit.alertLocalLater,500);
		}
	}
	else
	{
		ele.value = objVal;
	}
}

HopTookit.adjustFloatValueAccordingToRange = function(tmpTerminalType, ele, objVal)
{
	var minVal = ele.minValue;
	
	var maxVal = ele.maxValue;

	if( parseFloat(objVal) > parseFloat(maxVal) )
	{
		ele.value = maxVal;
		
		if( tmpTerminalType == TERMINAL_TYPE.LOCAL_END )
		{
			setTimeout(HopTookit.alertFarLater,500);	
		}
		else
		{
			setTimeout(HopTookit.alertLocalLater,500);
		}
	}
	else if( parseFloat(objVal) < parseFloat(minVal) )
	{
		ele.value = minVal;
		
		if( tmpTerminalType == TERMINAL_TYPE.LOCAL_END )
		{
			setTimeout(HopTookit.alertFarLater,500);	
		}
		else
		{
			setTimeout(HopTookit.alertLocalLater,500);
		}
	}
	else
	{
		ele.value = objVal;
	}
}

HopTookit.alertLocalLater = function()
{
	var alertMsg = RESOURCE["cannotmodifylocal"];
	alert(alertMsg);
}

HopTookit.alertFarLater = function()
{
	var alertMsg = RESOURCE["cannotmodifyfar"];
	alert(alertMsg);
}


/**
 * 
 */
HopTookit.setDataRangeTip = function(ele, minVal, maxVal, exceptval)
{
	if( exceptval == null )
	{
		ele.title = minVal + " ~ " + maxVal;
	}
	else
	{
		ele.title = exceptval + " , " + minVal + " ~ " + maxVal;
	}
}

/**
 *                   
 */
HopTookit.getProtectionModeDescription = function(modeval)
{
	var returnString = "-";
	
	if( modeval == wModeStru.SDVal )
	{
		returnString = wModeStru.SD;
	}
	if( modeval == wModeStru.FDVal )
	{
		returnString = wModeStru.FD;
	}
	if( modeval == wModeStru.HSBVal )
	{
		returnString = wModeStru.HSB;
	}	

	return returnString;
}

/**
 *       ID            ID-  ID, 9-1233   
 * @param neID
 * @return
 */
HopTookit.convertPhyNeIDToLogicNeIDShow = function(neID)
{
	var str = "/";
	
	if(parseInt(neID)!=0 && parseInt(neID) != -1 && !isNaN(parseInt(neID)))
	{
		str =  ((parseInt(neID) - parseInt(neID) % 65536) / 65536) + "-"
			+ (parseInt(neID) % 65536);
	}
	
	return str;
}

/**
 *        
 * @return
 */
function BoardInforStruct()
{
	var _this = this;
	
	this.slotID = -1;
	
	this.portID = -1;

	this.init = function(slotid, portid)
	{
		_this.slotID = slotid;
		_this.portID = portid;
	}
	
	this.getSlotID = function()
	{
		return _this.slotID;
	}
	
	this.getPortID = function()
	{
		return _this.portID;
	}
}

/**
 *            
 */
HopTookit.getBoardInforStruct = function(slotid, portid)
{
	var bdInforStruct = new BoardInforStruct();
	
	bdInforStruct.init(slotid, portid);
	
	return bdInforStruct;
}

HopTookit.isRTN600 = function(tNeID, tNeType)
{
	var isRTN600Flag = SpecialAttrMgr.isNESupport(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_PACKETMICROWAVE_NE");
	
	if( tNeType == NETYPE_RTN610 || tNeType == NETYPE_RTN620 || tNeType == NETYPE_RTN605 || isRTN600Flag ) 
	{
		return true;
	}
	else
	{
		return false;
	}
}

HopTookit.isRTN900_AND_VERSION_ABOVE_05760220 = function(tNeID, tNeType, tNeVersion)
{
	var isSupportE1NumNeVersion = SpecialAttrMgr.isNESupport(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NEVERSION_SUPPORT_E1NUM");
	
	if( isSupportE1NumNeVersion )
	{
		return true;
	}
	
	
	if( tNeType == NETYPE_RTN610 || tNeType == NETYPE_RTN620 || tNeType == NETYPE_RTN605 ) 
	{
		return false;
	}
	else if( tNeType == NETYPE_RTNSMART || tNeType == NETYPE_RTN905 || tNeType == NETYPE_RTN380)
	{
		return true;
	}
	else
	{
		var versionArray = tNeVersion.split(".");
		if( versionArray[2] > "02" || (versionArray[2] == "02" && versionArray[3] >= "20") )
		{
			return true;
		}
		else
		{
			return false;
		}
	}	
}

/**
 *       1+1  
 */
HopTookit.isSupportEditIF1Plus1 = function(tNeID, tNeType)
{
	var isNotSupport1P1Protection = SpecialAttrMgr.isNESupport(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NOTSUPPORT_IF1PLUS1PROTECT");
	
	if( tNeType == NETYPE_RTN610  || tNeType == NETYPE_RTN605 || isNotSupport1P1Protection ) 
	{
		return false;
	}
	else
	{	
		return true;
	}	
}
HopTookit.isRTN900_AND_VERSION_ABOVE_05760310 = function(tNeID, tNeType, tNeVersion)
{
	var isSupportRECEIVEPOWERNeVersion = SpecialAttrMgr.isNESupport(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NEVERSION_SUPPORT_RECEIVEPOWER");
	
	if( isSupportRECEIVEPOWERNeVersion )
	{
		return true;
	}
	
	if( tNeType == NETYPE_RTN610 || tNeType == NETYPE_RTN620 || tNeType == NETYPE_RTN605 ) 
	{
		return false;
	}
	else if( tNeType == NETYPE_RTNSMART || tNeType == NETYPE_RTN905 || tNeType == NETYPE_RTN380)
	{
		return true;
	}
	else
	{
		var versionArray = tNeVersion.split(".");
		if( versionArray[2] > "03" || (versionArray[2] == "03" && versionArray[3] >= "10") )
		{
			return true;
		}
		else
		{
			return false;
		}
	}	
}

HopTookit.isRTN900NA = function(tNeID, tNeType)
{
	var isRTN900NAFlag = SpecialAttrMgr.isNESupport(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_RTN900NA");
	
	if( tNeType == NETYPE_RTN910NA || tNeType == NETYPE_RTN950NA || isRTN900NAFlag )  
	{
		return true;
	}
	else
	{
		return false;
	}
}

/*       ,     
HopTookit.isRTN380 = function(tNeID, tNeType)
{
	if( tNeType == NETYPE_RTN380 || SpecialAttrMgr.isNESupport(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_RTN380") )  
	{
		return true;
	}

	return false;
}
*/

HopTookit.isRTNSmart = function(tNeID, tNeType)
{
	if( SpecialAttrMgr.isNESupportByType(tNeID, tNeType, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NETYPE_PROCESSLIKE_RTN310") )
	{
		return true;
	}
	
	if( tNeType == NETYPE_RTNSMART )  
	{
		return true;
	}
	else
	{
		return false;
	}
}

/**
 *     RTN310       ,         
 */
HopTookit.isRTNSmartV1R1C00 = function(tNeID, tNeType, tNeVesion)
{
	if( SpecialAttrMgr.isNESupportByType(tNeID, tNeType, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NETYPE_PROCESSLIKE_RTN310V1R1C00") )
	{
		return true;
	}
	
	if( HopTookit.isRTNSmart(tNeID, tNeType) )
	{
		var versionArray = tNeVesion.split(".");
		if( versionArray[2] == "01" && versionArray[3] < "20")
		{
			return true;
		}
	}
	return false;
}

/**
 * modulation1	    1
 * modulation2	    2
 *                 
 */
HopTookit.compareModulations = function(modulation1, modulation2)
{
	var priority1 = priorityMap[modulation1];
	var priority2 = priorityMap[modulation2];
	
	if( priority1 > priority2 )
	{
		return 1;
	}
	else if( priority1 == priority2 )
	{
		return 0;
	}
	else
	{
		return -1;
	}
}

/**
 *     XPIC
 */
HopTookit.isSupportXPIC = function(tNeID, tNeType)
{
	var isNotSupportXPIC = SpecialAttrMgr.isNESupport(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NOTSUPPORT_XPIC");
	
	if( tNeType == NETYPE_RTN610 || tNeType == NETYPE_RTN605 || tNeType == NETYPE_RTNSMART || tNeType == NETYPE_RTN380 || isNotSupportXPIC) 
	{
		return false;
	}
	else
	{
		return true;
	}
}
/**
 *     1j1
 * RTNSmart RTN9051C         1J1  
 */
HopTookit.isSupport1J1 = function(tNeID, tNeType, tShelfType)
{
	var isNotSupport1J1 = false;
	var neList = SpecialAttrMgr.getNEAttrListValue(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NOTDISPLAY_IF1PLUS1PROTECTION");
	if (neList != null && neList.length > 0) 
	{
		for (var i=0; i<neList.length; i++)
		{
			if (neList[i] == tShelfType)
			{
				isNotSupport1J1 = true;
			}
		}
	}
	
	if( tNeType == NETYPE_RTNSMART || tNeType == NETYPE_RTN380 || 
	    (tNeType == NETYPE_RTN905 && tShelfType && tShelfType == SHELF_TYPE_905III) ||
	    (tNeType == NETYPE_RTN905 && tShelfType && tShelfType == SHELF_TYPE_905III_EX) ||
	    isNotSupport1J1
	  ) 
	{
		return false;
	}
	else
	{
		return true;
	}
}

/**
 *   RTN310 RTN900       RTN905III                      
 */
HopTookit.isNeedValidateAndRelevantChange = function(endStruct1, endStruct2)
{
    var result = HopTookit.getHtmlPageByDevType(endStruct1.neType, endStruct1.shelfType, endStruct1.neid) == 
		   HopTookit.getHtmlPageByDevType(endStruct2.neType, endStruct2.shelfType, endStruct2.neid) ?
		   true : false
		   
    if(!result && HopTookit.isRTN9051CToRTN900Case(endStruct1, endStruct2))
    {
        result = true;
    }
    
    return result;
}

/**
 **        9051C RTN900     
 **/
HopTookit.isRTN9051CToRTN900Case = function(endStruct1, endStruct2)
{
	var isNotSupportXPIC = false;
	var neList = SpecialAttrMgr.getNEAttrListValue(endStruct1.neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NOTSUPPORT_XPIC");
	if (neList != null && neList.length > 0) 
	{
		for (var i=0; i<neList.length; i++)
		{
			if (neList[i] == endStruct1.shelfType)
			{
				isNotSupportXPIC = true;
			}
		}
	}
	var result = false;
    if( 
            ( endStruct1.neType == NETYPE_RTN905 && (endStruct1.shelfType == SHELF_TYPE_905III || endStruct1.shelfType == SHELF_TYPE_905III_EX || isNotSupportXPIC) 
              && endStruct2.neType != NETYPE_RTNSMART && endStruct2.neType != NETYPE_RTN380
            || endStruct2.neType == NETYPE_RTN905 && (endStruct2.shelfType == SHELF_TYPE_905III || endStruct2.shelfType == SHELF_TYPE_905III_EX || isNotSupportXPIC) 
              && endStruct1.neType != NETYPE_RTNSMART && endStruct1.neType != NETYPE_RTN380
            ) && endStruct1.$("if1plus0").checked && endStruct2.$("if1plus0").checked && endStruct1.$("if1plus0").checked 
              && !endStruct1.$("enablexpicEle").checked && !endStruct2.$("enablexpicEle").checked
    )
    {
        result = true;
    }
      
    return result;  
}

/**
 *                        
 */
HopTookit.getHtmlPageByDevType = function(tNeType, tShelfType, tNeID)
{
	var isNotSupportXPIC = false;
	var neList = SpecialAttrMgr.getNEAttrListValue(tNeID, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NOTSUPPORT_XPIC");
	if (neList != null && neList.length > 0) 
	{
		for (var i=0; i<neList.length; i++)
		{
			if (neList[i] == endStruct1.shelfType)
			{
				isNotSupportXPIC = true;
			}
		}
	}
	var returnPage = "";
	if( tNeType == NETYPE_RTNSMART )
	{
		returnPage = "farendterminal_smart.html";
	}
	else if( tNeType == NETYPE_RTN380 )
	{
		returnPage = "farendterminal_rtn380.html";
	}
	else if(tNeType == NETYPE_RTN905 
		&& (tShelfType == SHELF_TYPE_905III 
			|| tShelfType == SHELF_TYPE_905III_EX 
			|| tShelfType == SHELF_TYPE_ST_RTN905IV
			|| isNotSupportXPIC))
	{
		returnPage = "farendterminal_smart.html";
	}
	else
	{
		returnPage = "farendterminal.html";
	}
	
	return returnPage;
}

/**
 *          
 */
HopTookit.isPairingBoard = function(ifSlotID1, ifSlotID2)
{
	var pairingBoard = HopTookit.getPairingBoard(ifSlotID1)

	var result = pairingBoard == ifSlotID2 ? true : false;

	return result;
}

/**
 *           
 */
HopTookit.isSupportRunmode = function(bdTypevalue)
{
	return false;//return supportRunmodeBds.contains(bdTypevalue);
}
/**
 *         
 */
HopTookit.getIfoduModuleSlotId = function(value)
{
	if("" == value)
	{
		return value;
	}
	var eleCurValue2Obj = JSON.parse(value);
	return eleCurValue2Obj.ifSlotId;
}

HopTookit.getIfoduModuleObj = function(value)
{
	var eleCurValue2Obj = JSON.parse(value);
	return eleCurValue2Obj;
}
/**
 *                      
 */
HopTookit.getIfoduModuleSlotId = function(value)
{
	var eleCurValue2Obj = JSON.parse(value);
	return eleCurValue2Obj.ifSlotId;
}
/**
 *                      
 */
HopTookit.isSupportChangeServtype = function(tNeID, tSlotID, bdTypevalue)
{
	return !( notSupportChangeServtypeBds.contains(bdTypevalue) || 
			  SpecialAttrMgr.isCPSupport(tNeID, tSlotID, "TE_FUNC_RTN_CFG_HOPMGR","TE_ATTR_RTN_HOPMGR_BOARD_NOTSUPPORT_SERVICETYPECHANGE")
			)
}

/**
 *             
 */
HopTookit.isSupportHighLevelModulation = function()
{
	var eleCurValue2Obj = this.getIfoduModuleObj($("ifoduboardEle").value);
	var bdtype = eleCurValue2Obj.ifBdType;
	var runMode = $("ifrunmodeEle").value;
	return (bdtype == SHXA2 || "1" == runMode) && 
			(supportHighModeBds.contains(bdtype) || SpecialAttrMgr.isCPSupport(neid, eleCurValue2Obj.ifSlotId, "TE_FUNC_RTN_CFG_HOPMGR","TE_ATTR_RTN_HOPMGR_BOARD_SUPPORT_HIGHMODULATION"));
}

/**
 *     40M    
 */
HopTookit.isSupportBandwidth_40MHz = function(/*tNeType*/)
{
	var eleCurValue2Obj = this.getIfoduModuleObj($("ifoduboardEle").value);
	var bdtype = eleCurValue2Obj.ifBdType;
	/**
	 * 1 FO IFX2 IFU2   40M 
	 *          ,SMART      
	 */
	return /*!this.isRTNSmart(tNeType) && */(bdtype != IFU2 && bdtype != IFX2 && bdtype != SHXA2) &&
			!SpecialAttrMgr.isCPSupport(neid, eleCurValue2Obj.ifSlotId, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_NOTSUPPORT_SERVICETYPE_40M");
}


/**
 *          XPIC  
 */
HopTookit.isBoardSupportXPIC = function(tNeID, tSlotID, bdtype)
{
	var isBoardSupportXPIC = SpecialAttrMgr.isCPSupport(tNeID, tSlotID, "TE_FUNC_RTN_CFG_HOPMGR","TE_ATTR_RTN_HOPMGR_BOARD_SUPPORT_XPIC");
	
	return supportXPICBds.contains(bdtype) || isBoardSupportXPIC;
}

HopTookit.getBandWidthList = function(tNeID, tNeType)
{
	return this.isRTN900NA(tNeID, tNeType)? bandWidthListNA:bandWidthList;
}
/**
 *       
 */
HopTookit.getPairingBoard = function(ifSlotID1)
{
	var netype = neType;
	var pairingBoard = "";
	
	if( netype == NETYPE_RTN610 )
	{
		pairingBoard = PAIRING_RELATION_610[ifSlotID1];
	}
	if( netype == NETYPE_RTN620 )
	{
		pairingBoard = PAIRING_RELATION_620[ifSlotID1];
	}
	if( netype == NETYPE_RTN605 )
	{
		pairingBoard = PAIRING_RELATION_605[ifSlotID1];
	}
	if( netype == NETYPE_RTN910 || netype == NETYPE_RTN910NA )
	{
		pairingBoard = PAIRING_RELATION_910[ifSlotID1];
	}
	if( netype == NETYPE_RTN950 || netype == NETYPE_RTN950NA || netype == NETYPE_RTN950A)
	{
		pairingBoard = PAIRING_RELATION_950[ifSlotID1];
	}
	if( netype == NETYPE_RTN980 )
	{
		pairingBoard = PAIRING_RELATION_980[ifSlotID1];
	}
	if( netype == NETYPE_RTN905 )
	{
		pairingBoard = PAIRING_RELATION_905[ifSlotID1];
	}
	
	if( pairingBoard == "" )
	{
		var slotRelation = SpecialAttrMgr.getNEAttrValue(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_PAIRINGSLOT_RELATION");
		if( slotRelation != null && slotRelation != "" )
		{
			var relationArray = slotRelation.split(",");
			for( var i = 0; i < relationArray.length; i++ )
			{
				var relation = relationArray[i];
				var keySlotID = relation.split("-")[0];
				var valSlotID = relation.split("-")[1];
				if( ifSlotID1 == keySlotID )
				{
					pairingBoard = valSlotID;
					break;
				}
			}
		}
	}
	
	return pairingBoard;
}

/**
 *     Element
 * @return
 */
function DecoratedElement()
{
	var _this = this;
	
	this.mElementID = null;
	
	this.mType = null;
	
	this.cacheValue = "";
	
	this.getElement = function()
	{
		return $(_this.mElementID);
	}
	
	this.getElementType = function()
	{
		return _this.mType;
	}
	
	this.getElementID = function()
	{
		return _this.mElementID;
	}
	
	this.bindElement = function(elementId, type)
	{
		_this.mElementID = elementId;
		
		_this.mType = type;
		
		_this.initCacheValue();		 
	}

	/*		Setters and Getters	Start	*/
	this.setCacheValue = function(val)
	{
		_this.cacheValue = val;
	}
	
	this.getCacheValue = function()
	{
		return _this.cacheValue;
	}
	
	this.setElementValue = function(val)
	{
		if( _this.isCheckTypeElement() )
		{
			_this.getElement().checked = val;
		}
		else
		{
			_this.getElement().value = val;
		}
	}
	
	this.getElementValue = function()
	{
		var retValue = "";
		
		if( _this.isCheckTypeElement() )
		{
			retValue = _this.getElement().checked;
		}
		else
		{
			retValue = _this.getElement().value;
		}
		
		return retValue;
	}
	
	this.setElementDisabled = function(flag)
	{
		_this.getElement().disabled = flag;
		if(_this.getElement().tagName.toLowerCase() == "select" && !isIE)
		{
			if(flag == true)
			{
				_this.getElement().setAttribute("lastIndex",_this.getElement().selectedIndex);
				_this.getElement().selectedIndex = -1;
			}
			else if(_this.getElement().selectedIndex == -1)
			{
				if (_this.getElement().getAttribute("lastIndex") != null) 
				{
					_this.getElement().selectedIndex = _this.getElement().getAttribute("lastIndex");
				}
				else 
				{
					_this.getElement().selectedIndex = 0;
				}
			}
		}
		_this.updateElementBgColor();
	}
	
	this.getElementDisabled = function()
	{
		return _this.getElement().disabled;
	}	
	
	/*		Setters and Getters	End		*/
	
	this.isElementModified = function()
	{
		var retValue = _this.getElementValue() == _this.getCacheValue() ? false : true;
		
		return retValue;
	}
	
	this.modifyElementValue = function(val)
	{
		if( _this.isCheckTypeElement() )
		{
			_this.getElement().checked = val;
		}
		else
		{
			_this.getElement().value = val;
		}
		
		_this.updateElementBgColor();
	}
	
	/**
	 *        
	 */
	this.updateElementBgColor = function()
	{
		if( _this.getElementDisabled() )							//        disabled          disabled     
		{
			_this.getElement().style.backgroundColor = CELL_DISABLED_BGCOLOR;
		}
		else
		{
			if( _this.isElementModified() )							//                    
			{
				_this.getElement().style.backgroundColor = CELL_MODIFIED_BGCOLOR;	//         ,             
			}
			else													//                   
			{
				if( _this.isCheckTypeElement() )
				{
					_this.getElement().style.backgroundColor = CELL_ORIGINAL_BGCOLOR;	//         ,             				
				}
				else
				{
					_this.getElement().style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;	//         ,             
				}
			}
		}
	}
	
	/**
	 *    check box radio     
	 */
	this.isCheckTypeElement = function()
	{
		var retValue = false;
		
		if( _this.mType == DECORATED_ELEMENT_TYPE.CHECKBOX || 
			_this.mType == DECORATED_ELEMENT_TYPE.RADIO )
		{
			retValue = true;
		}
		
		return retValue;
	}
	
	this.updateElementValueToCacheValue = function()
	{
		_this.setCacheValue(_this.getElementValue());
	}
	
	this.updateCacheValueToElementValue = function()
	{
		_this.setElementValue(_this.getCacheValue());
	}
	
	/**
	 *                 
	 */
	this.initAllValue = function()
	{
		_this.initElementValue();
		_this.initCacheValue();
	}
	
	/**
	 *        
	 */
	this.initCacheValue = function()
	{
		if(  _this.isCheckTypeElement() )
		{
			_this.cacheValue = false;		
		}
		else
		{
			_this.cacheValue = "";
		}
	}
	
	/**
	 *         
	 */
	this.initElementValue = function()
	{
		if(  _this.isCheckTypeElement() )
		{
			_this.getElement().checked = false;		
		}
		else
		{
			_this.getElement().value = "";
		}
	}
}


function OperationStateMapping()
{	
	var _this = this;
	
	this.obj = null;
	
	this.type = null;
	
	this.init = function(_obj, _type)
	{
		_this.obj = _obj;
		
		_this.type = _type
	}
	
	this.getOperationType = function()
	{
		return _this.type;
	}
	
	this.excute = function()
	{
		if( _this.type == NEOPERATION_TYPE.CREATE )
		{
			if(typeof(_this.obj.modifyParamBeforeCreate) != "undefined")
			{
				_this.obj.modifyParamBeforeCreate();
			}
			if(OPERATION_SUCCESS == _this.obj.createProtection())
			{
				_this.obj.modifyProtection();
			}			
			
		}
		else if( _this.type == NEOPERATION_TYPE.DELETE )
		{
			_this.obj.deleteProtection();
		}
		else if( _this.type == NEOPERATION_TYPE.RECREATE )
		{
			_this.obj.recreateProtection();
			_this.obj.modifyProtection();
		}
		else if( _this.type == NEOPERATION_TYPE.MODIFY )
		{
			_this.obj.modifyProtection();
		}
		else if( _this.type == NEOPERATION_TYPE.DONOTING )
		{
		}
		else
		{
		}
	}
}

function OperationExecutor()
{
	this.excuteOperations = function( ifOperation, xpicOperation )
	{
		
		var ifOperationType = ifOperation.getOperationType();
		
		var xpicOperationType = xpicOperation.getOperationType();
		
		if( ifOperationType == NEOPERATION_TYPE.CREATE && xpicOperationType == NEOPERATION_TYPE.DELETE )
		{
			xpicOperation.excute();
			
			ifOperation.excute();
		}
		else if( ifOperationType == NEOPERATION_TYPE.DELETE && xpicOperationType == NEOPERATION_TYPE.CREATE )
		{
			ifOperation.excute();
			
			xpicOperation.excute();		
		}
		else
		{
			ifOperation.excute();
			
			xpicOperation.excute();
		}
	}
}

function getSupportModes(arr, bandType,runmode)
{
	var modes = [];
    for(var i = 0, ilen = arr.length; i < ilen; i++)
    {
        if(arr[i].bandType == bandType)
        {
        	if(ifRunModeStru.IS3_VAL == runmode)
        	{
        		modes = cloneArray(arr[i].highmode);
        	}
        	else
        	{
        		modes = cloneArray(arr[i].amMode);
        	}
            return modes;
        }
    }
    return modes;
}

function cloneArray(modes)
{
	if(modes == null)
	{
		return modes;
	}
	var results = [];
	for (var index = 0, len = modes.length; index < len; index++) 
	{
		results[index] = modes[index];
	}
	return results;
}
