
/**
 * XPIC     
 */
var xpicCache = new Object();

xpicCache["enablexpicEle"] = new DecoratedElement();
xpicCache["enablexpicEle"].bindElement("enablexpicEle", DECORATED_ELEMENT_TYPE.CHECKBOX);
xpicCache["vPolarBdEle"] = new DecoratedElement();
xpicCache["vPolarBdEle"].bindElement("vPolarBdEle", DECORATED_ELEMENT_TYPE.SELECT);
xpicCache["hPolarBdEle"] = new DecoratedElement();
xpicCache["hPolarBdEle"].bindElement("hPolarBdEle", DECORATED_ELEMENT_TYPE.SELECT);

xpicCache["groupId"] = -1;
var hide_groupId_xpic = -1;	
var P1J1 = "10";

var PLA = "11";

function BasicParamXPICModule()
{
	var _this = this;
	
	this.eleOnChangeArray = new Array(	
										);

	this.eleCanModifyArray = new Array(	"enablexpicEle",
										"vPolarBdEle",
										"hPolarBdEle"
										);
	
	this.listenerList = new Array();
	
	this.addListener = function(obj)
	{
		_this.listenerList.push(obj);
	}
	
	this.notifyAll = function(event)
	{		
		for( var i = 0; i < _this.listenerList.length; i++ )
		{
			var obj = _this.listenerList[i];
			obj.response(event);
		}
	}

	/**
	 *       
	 */
	this.queryNeInformation = function(dataArray)
	{
		_this.clearParamField();
		if(HopTookit.isSupportXPIC(neid, neType))
		{
			_this.queryProtection(dataArray);
		}
		else
		{
			$("enablexpicEle").disabled = true;
			queryBoardInformation(dataArray);
		}
	}
	
	/**
	 *   XPIC   
	 */
	this.queryProtection = function(dataArray)
	{
		var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_GET_XPIC + "&nmUser="+ nmUser;
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
		var tmpSlotArray = new Array(ifSlotId);
		var xmlstr = createCommonQueryXML(neid, tmpSlotArray);
		
		loadXMLdoc(urlreq, "POST", true, _this.queryProtectionCallback, dataArray, "inputdata=" + xmlstr);
	}
	
	/**
	 *   XPIC callback  
	 */
	this.queryProtectionCallback = function(doc,dataArray)
	{
		/*$("riskNoticeXpicSpan").style.display = "none";*/
		
		var data = EncapsulateData(doc);
	    
	    var rowid = _this.xpicGroupRelatedToThisBoardExist(data);
	    var isRelatedXpicGrpExist = rowid == -1 ? false : true;

	    if(data.getSErrorCode() != OPERATION_SUCCESS)
	    {

			if( isRelatedXpicGrpExist == true )//                     
			{
				dataArray.push(data);
			}
	    }
		$("vPolarBdEle").disabled = false;
		$("hPolarBdEle").disabled = false;
		$("convertxpicTR").style.display = "none";
	    if( isRelatedXpicGrpExist == false )	    //       XPIC    
	    {
	    	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	    	$("enablexpicEle").checked = false;
	    	$("vPolarBdEle").value = ifSlotId;
	    	$("hPolarBdEle").value = ifSlotId;
	    	
	    	xpicCache["enablexpicEle"].updateElementValueToCacheValue();
	    	
	    	_this.showXPICContentTr(false);	    
	    	xpicCache["vPolarBdEle"].updateElementValueToCacheValue();
	    	xpicCache["hPolarBdEle"].updateElementValueToCacheValue();
	    }
	    else										//      XPIC    
	    {
	    	$("enablexpicEle").checked = true;
	    	
	    	/*if( $("if1plus1").checked == true )
	    	{
	    		$("enablexpicEle").checked = true;
	    		$("enablexpicEle").disabled = true;
	    		_this.sendXPICStatusEventAndQueryBoardInformation(dataArray);
	    		return;
	    	}*/
	    	
	    	$("if1plus1").disabled = true;
	    	
	    	
	    	var tmpGroupId = data.getDataRowParam(rowid, "groupid");
	    	var vPolarBdid = data.getDataRowParam(rowid, "vPolarBdid");
	    	var hPolarBdid = data.getDataRowParam(rowid, "hPolarBdid");			
	    	$("vPolarBdEle").value = vPolarBdid;
	    	$("hPolarBdEle").value = hPolarBdid;
			
			$("vPolarBdEle").disabled = true;
			$("hPolarBdEle").disabled = true;
			$("convertxpicTR").style.display = "";

	    	xpicCache["enablexpicEle"].updateElementValueToCacheValue();
	    	xpicCache["vPolarBdEle"].updateElementValueToCacheValue();
	    	xpicCache["hPolarBdEle"].updateElementValueToCacheValue();
	    	xpicCache["groupId"] = tmpGroupId;
	        
	    	_this.showXPICContentTr(true);
	    	
	        var vBoardStruct = HopTookit.getBoardInforStruct(vPolarBdid, 1);
	        var hBoardStruct = HopTookit.getBoardInforStruct(hPolarBdid, 1);
	        _this.queryRadioLinkID( new Array(vBoardStruct, hBoardStruct) );
	        _this.queryEthBandWidth( new Array(vBoardStruct, hBoardStruct) );
	        if( $("if1plus1").checked == true )
	    	{
	    		$("enablexpicEle").disabled = false;
				$("if1plus1").disabled = false;
	    	}
	    }

	    _this.sendXPICStatusEventAndQueryBoardInformation(dataArray);
	}
	
	/**
	 *   XPIC               
	 */
	this.sendXPICStatusEventAndQueryBoardInformation = function(dataArray)
	{
		var event = _this.createXPICStatusChangeEvent();
		_this.notifyAll(event);
		
		queryBoardInformation(dataArray);
	}
	
	/**
	 *                            
	 * @return
	 */
	this.initBasicParamFieldOptions = function()
	{
		var ifoduInfoArr = g_commonData.getIFODUInforArray();
		
		$("vPolarBdEle").options.length = 0;
		$("hPolarBdEle").options.length = 0;
		
		/*    Protection      */
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];

			HopTookit.addOptionToSelectElement($("vPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
			HopTookit.addOptionToSelectElement($("hPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
		}
		/*    Protection      */
	}
	
	/**
	 *        
	 * @return
	 */
	this.clearParamField = function()
	{
		$("vPolarBdEle").options.length = 0;
		$("hPolarBdEle").options.length = 0;
		var ifoduInfoArr = g_commonData.getIFODUInforArray();
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];

			HopTookit.addOptionToSelectElement($("vPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
			HopTookit.addOptionToSelectElement($("hPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
		}
		
		xpicCache["enablexpicEle"].initAllValue();
		xpicCache["vPolarBdEle"].initAllValue();
		xpicCache["hPolarBdEle"].initAllValue();
		
		/**
		 * DTS2012050703004
		 */
		ifParamCache["vLinkIdEle"].setElementValue("1");
		ifParamCache["hLinkIdEle"].setElementValue("2");
		ifParamCache["vLinkIdEle"].updateElementValueToCacheValue();
		ifParamCache["hLinkIdEle"].updateElementValueToCacheValue();
		
		ifParamCache["guE1CapEle_V"].initAllValue();
		ifParamCache["guE1CapEle_H"].initAllValue();
		ifParamCache["e1StatusEle_V"].initAllValue();
		ifParamCache["e1StatusEle_H"].initAllValue();
		ifParamCache["allE1CapEle_V"].initAllValue();
		ifParamCache["allE1CapEle_H"].initAllValue();
		$("ethBandEle_V").value = "";
		$("ethBandEle_H").value = "";		

		_this.clearBasicParamFieldBgColor();
	}
	
	this.setBaiscParamAtomEditHandler = function()
	{
		for( var i = 0; i < _this.eleOnChangeArray.length; i++ )
		{
			$(_this.eleOnChangeArray[i]).onchange = function()
			{
				HopTookit.processCellOnchange(xpicCache[this.id]);
			} 
		}
		
		$("enablexpicEle").onclick = function()
		{
			_this.doBusinessIf_XPICEnabledChanged();
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("hPolarBdEle").onchange = function()
		{
			_this.setHBoardWhenChangeVBoard("H");
			
			HopTookit.processCellOnchange(xpicCache[this.id]);
		}
		
		$("vPolarBdEle").onchange = function()
		{
			_this.setHBoardWhenChangeVBoard("V");
			
			HopTookit.processCellOnchange(xpicCache[this.id]);
		}
	}

	/**
	 *      
	 */
	this.initCurrentDomain = function()
	{
		/* init XPIC Filed Start */
		$("enablexpicSpan").innerText = RESOURCE["enablexpicSpan"];
		$("polardirvSpan").innerText = RESOURCE["polarDirV"];
		$("linkidvSpan").innerText = RESOURCE["linkIdV"];
		$("polardirhSpan").innerText = RESOURCE["polarDirH"];
		$("linkidhSpan").innerText = RESOURCE["linkIdH"];
		$("convertxpicSpan").innerText = RESOURCE["HVConvert"];
		$("convertxpicEle").value = RESOURCE["switchBtn"];
		/* init XPIC Field Filed End */
		
		_this.setBaiscParamAtomEditHandler();
	}
	
	/**
	 *   XPIC Enable            
	 */
	this.doBusinessIf_XPICEnabledChanged = function()
	{
		if( $("enablexpicEle").checked )
		{
			if ($("IFParamField").style.display == "none")
			{
				ifAttriModule.showIFAttriField();
			}
			if ($("RFParamField").style.display == "none")
			{
				rfAttriModule.showRFAttriField();
			}
		}
		else
		{
			if( xpicCache["enablexpicEle"].getCacheValue() )
			{
				alert(RESOURCE["DELETE_XPIC_RPOTECTION_ALARM"]);
			}
			else
			{
			}
		}
		
		HopTookit.processCellOnchange(xpicCache["enablexpicEle"]);
		
		_this.showXPICContentTr($("enablexpicEle").checked);
		
		_this.filterXpicProtectionBoardInner_selectXpic();
		
		var event = _this.createXPICStatusChangeEvent();
		_this.notifyAll(event);
		
		adjustCellWidth();
	}

	/**
	 *      XPIC          
	 */
	this.xpicGroupRelatedToThisBoardExist = function(data)
	{
		g_commonData.m_exsistingXpicGroupArray.clear();
		
		var rowid = -1;
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	    for( var i = 0; i < data.getDataRowLength(); i++ )
	    {
	    	var hSlotId = data.getDataRowParam(i, "hPolarBdid");
	    	var vSlotId = data.getDataRowParam(i, "vPolarBdid");
	    	
			if( ifSlotId == hSlotId || ifSlotId == vSlotId )
			{
				rowid = i;
			}

			var tmpGroupId = data.getDataRowParam(i, "groupid");

	        g_commonData.addProtectionGroupToXpicGroupArray(tmpGroupId, 
	        		hSlotId, vSlotId);
	    }
	    
	    return rowid;
	}
	
	/**
	 *   RadioLinkID   Rf     
	 */
	this.queryRadioLinkID = function(boardStructArray)
	{
		var xmlStr = _this.createQueryRadioLinkIDXML(boardStructArray);

		var urlreq = "../../../../neExlorerServlet?sfid=93731&flag=1" + "&nmUser="+nmUser;
		
		loadXMLdoc(urlreq, "POST", true, _this.queryRadioLinkIDCallback, boardStructArray,"inputdata=" + xmlStr);
	}
	
	/**
	 *     XML
	 */
	this.createQueryRadioLinkIDXML = function(boardStructArray)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = null;

		for( var i = 0; i < boardStructArray.length; i++ )
		{
			row = new tagElement("row-params");
			
			HopTookit.addParam(row, "neid", neid);
			
			HopTookit.addParam(row, "slotid", boardStructArray[i].getSlotID());
			
			HopTookit.addParam(row, "port", boardStructArray[i].getPortID());
			
			HopTookit.addParam(row, "portid", boardStructArray[i].getPortID());
			
			bussiness.appendChild(row);
		}
		
		di.getRoot().appendChild(bussiness);
		
		return di.toString();
	}

	/**
	 *       LinkId-H LinkId-V    
	 */
	this.queryRadioLinkIDCallback = function(doc, boardStructArray)
	{
		var data = EncapsulateData(doc);
		
	    if( data.getSErrorCode() != OPERATION_SUCCESS && data.getSErrorCode() != OPERATION_PART_SUCCESS )
	    {
	    	return;
	    }
	    
	    var event = new BasicParamXPICRefreshBoardDataEvent();
	    event.initData(boardStructArray[0], boardStructArray[1], data);
	    _this.notifyAll(event);
	}
	
	/**
	 *   IF       ethBandwidth 
	 */
	this.queryEthBandWidth = function(boardStructArray)
	{
		var xmlStr = _this.createQueryEthBandWidthXML(boardStructArray);

		var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_RTN_QUERY_IFODUINFO + "&nmUser="+nmUser;
		
		loadXMLdoc(urlreq, "POST", true, _this.queryEthBandWidthCallback, boardStructArray,"inputdata=" + xmlStr);
	}

	/**
	 *       
	 */
	this.createQueryEthBandWidthXML = function(boardStructArray)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = null;

		for( var i = 0; i < boardStructArray.length; i++ )
		{
			row = new tagElement("row-params");
			
			HopTookit.addParam(row, "neid", neid);
			
			HopTookit.addParam(row, "queryType", "queryEthBandwidth");
			
			HopTookit.addParam(row, "isQueryIF", "true");
			
			HopTookit.addParam(row, "isQueryRF", "true");
			
			HopTookit.addParam(row, "slotid", boardStructArray[i].getSlotID());
			
			HopTookit.addParam(row, "port", boardStructArray[i].getPortID());
			
			HopTookit.addParam(row, "portid", boardStructArray[i].getPortID());
			
			bussiness.appendChild(row);
		}
		
		di.getRoot().appendChild(bussiness);
		
		return di.toString();
	}

	/**
	 *     
	 */
	this.queryEthBandWidthCallback = function(doc, boardStructArray)
	{
		var data = EncapsulateData(doc);
		
	    if( data.getSErrorCode() != OPERATION_SUCCESS && data.getSErrorCode() != OPERATION_PART_SUCCESS )
	    {
	    	return;
	    }
	    
	    for( var i = 0; i < data.getDataRowLength(); i++ )
	    {
	    	var tslotid = data.getDataRowParam(i, "slotid");
	    	var ethBandWidthValue = data.getDataRowParam(i, "ethband");
	    	var ethBandWidthHighValue = data.getDataRowParam(i, "ethbandHigh");
	    	
	    	if( tslotid == $("vPolarBdEle").value )
	    	{
	    		$("ethBandEle_V").value = ethBandWidthValue + "-" + ethBandWidthHighValue;
	    	}
	    	if( tslotid == $("hPolarBdEle").value )
	    	{
	    		$("ethBandEle_H").value = ethBandWidthValue + "-" + ethBandWidthHighValue;
	    	}
	    }
	}
	
	this.getApplyOperationType = function()
	{
		var operationType = NEOPERATION_TYPE.DONOTING;
		
		if( xpicCache["enablexpicEle"].isElementModified() && xpicCache["enablexpicEle"].getCacheValue() == true )
		{
			operationType = NEOPERATION_TYPE.DELETE;
		}
		else if( xpicCache["enablexpicEle"].getElementValue() == true )		//          
		{
			if( xpicCache["enablexpicEle"].getCacheValue() == false )		//     
			{
				operationType = NEOPERATION_TYPE.CREATE;
			}
			else									//     
			{
				if( xpicCache["hPolarBdEle"].isElementModified() ||
				    xpicCache["vPolarBdEle"].isElementModified() )//                         
				{
					operationType = NEOPERATION_TYPE.RECREATE;
				}
				else
				{
					operationType = NEOPERATION_TYPE.MODIFY;
				}
			}
		}

		return operationType;
	}
	
	this.createProtection = function(type)
	{
		var defaulttype = "create";
		if( "recreate_create" == type )
		{
			defaulttype = "recreate_create";
		}
		
		var sfId = NSCMD_CFG_ADD_XPIC_GROUP;
		var xmlstr = _this.createAddXpicXML(neid, sfId, defaulttype);

		var urlreq = "../../../../neExlorerServlet?sfid=" + sfId + "&nmUser="+ nmUser;
		loadXMLdoc(urlreq, "POST", false, _this.applyXpicCallback, defaulttype, "inputdata=" + xmlstr);
	}
	
	this.createAddXpicXML = function(neid, sfId, type)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = new tagElement("row-params");
		
		HopTookit.addParam(row, "neid", neid);
		
		if( type == "create" )
		{
			var groupIds = new Array(1, 2, 3, 4, 5, 6, 7);
			for (var i = 0, m = g_commonData.m_exsistingXpicGroupArray.length; i < m; i++)
			{
				var tmpXpicGrouObjcet = g_commonData.m_exsistingXpicGroupArray[i];
				var tmpGroupId = tmpXpicGrouObjcet.groupId;
				groupIds.remove(tmpGroupId);
			}
			hide_groupId_xpic = groupIds[0];
		}

		if( type == "recreate_create" )
		{
			hide_groupId_xpic = xpicCache["groupId"];
		}
		
		HopTookit.addParam(row, "groupid", hide_groupId_xpic);
		
		HopTookit.addParam(row, "hPolarBdid", $("hPolarBdEle").value);
		
		HopTookit.addParam(row, "vPolarBdid", $("vPolarBdEle").value);
		
		HopTookit.addParam(row, "radioidH", $("hLinkIdEle").value);
		
		HopTookit.addParam(row, "radioidV", $("vLinkIdEle").value);
		
		HopTookit.addParam(row, "transmitFrequency", $("txfreEle").value * 1000);
		
		HopTookit.addParam(row, "W32PORT_ATTR_RADIOLINKIDh", $("hLinkIdEle").value);
		
		HopTookit.addParam(row, "W32PORT_ATTR_RADIOLINKIDv", $("vLinkIdEle").value);
		
		var bandwidth = $("ifchannelbandwidthEle").value;
		HopTookit.addParam(row, "bandwidth", bandwidth);
		var curServiceType = $("ifservtypeEle").value;
		if(((""+ifServiceTypeStru.E1ETH_VAL) == curServiceType) &&
				!(HopTookit.isRTN900NA(neid, neType) || !HopTookit.isRTN900_AND_VERSION_ABOVE_05760220(neid, neType, neVersion)))
		{
			HopTookit.addParam(row, "hPolarBdGue1num", $("guE1CapEle_H").value);
			HopTookit.addParam(row, "vPolarBdGue1num", $("guE1CapEle_V").value);
		}
		
		
		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}

	/**
	 *   XPIC   
	 */
	this.deleteProtection = function(type)
	{
		var sfId = NSCMD_CFG_DEL_XPIC_GROUP;
		var xmlstr = _this.createDeleteXpicXML(neid);
		
		var urlreq = "../../../../neExlorerServlet?sfid=" + sfId + "&nmUser="+ nmUser;
		
		var defaulttype = "delete";
		if( "recreate_delete" == type )
		{
			defaulttype = "recreate_delete";
		}
		
		loadXMLdoc(urlreq, "POST", false, _this.applyXpicCallback, defaulttype, "inputdata=" + xmlstr);
	}

	this.createDeleteXpicXML = function(neid)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = new tagElement("row-params");
		var param = null;

		param = new tagElement("param");
		param.setAttribute("name", "neId");
		param.setAttribute("value", neid);
		row.appendChild(param);

		param = new tagElement("param");
		param.setAttribute("name", "groupId");
		param.setAttribute("value", xpicCache["groupId"]);
		row.appendChild(param);

		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);
		
		return di.toString();
	}

	this.recreateProtection = function()
	{
		_this.deleteProtection("recreate_delete");
		
		_this.createProtection("recreate_create");
	}
	
	this.modifyProtection = function()
	{
		var sfId = NSCMD_CFG_SET_XPIC;
		var xmlstr = _this.createApplyXpicXML(neid, sfId);
		
		var urlreq = "../../../../neExlorerServlet?sfid=" + sfId + "&nmUser="+ nmUser;
		loadXMLdoc(urlreq, "POST", false, _this.applyXpicCallback, "modify", "inputdata=" + xmlstr);
	}
	
	this.modifyParamBeforeCreate = function()
	{
		var xmlstr = _this.createModifyParamXML(neid);
		if(xmlstr == null)
		{
			return;
		}
		var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_SET_XPIC + "&nmUser="+ nmUser;
		loadXMLdoc(urlreq, "POST", false, _this.modifyParamCallback, "modify", "inputdata=" + xmlstr);
	}
	
	this.modifyParamCallback = function(doc)
	{
		var data = EncapsulateData(doc);
		if(data.getSErrorCode() == OPERATION_SUCCESS)
	    {
			_this.refreshModifyParamElement();
	    }
	}
	
	this.refreshModifyParamElement = function()
	{
		ifParamCache["guE1CapEle_V"].updateElementValueToCacheValue();
    	ifParamCache["guE1CapEle_H"].updateElementValueToCacheValue();
    	ifParamCache["e1StatusEle_V"].updateElementValueToCacheValue();
    	ifParamCache["e1StatusEle_H"].updateElementValueToCacheValue();
    	ifParamCache["allE1CapEle_V"].updateElementValueToCacheValue();
    	ifParamCache["allE1CapEle_H"].updateElementValueToCacheValue();
    	
    	if( $("guE1CapEle_V").disabled == false )
    	{
    		$("guE1CapEle_V").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
    	}
    	if( $("guE1CapEle_H").disabled == false )
    	{	    	
    		$("guE1CapEle_H").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
    	}
    	if( $("e1StatusEle_V").disabled == false )
    	{	    	
    		$("e1StatusEle_V").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
    	}
    	if( $("e1StatusEle_H").disabled == false )
    	{
    		$("e1StatusEle_H").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
    	}
    	if( $("allE1CapEle_V").disabled == false )
    	{
    		$("allE1CapEle_V").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
    	}
    	if( $("allE1CapEle_H").disabled == false )
    	{
    		$("allE1CapEle_H").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
    	}
	}
	
	this.createModifyParamXML = function(neid)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var vRowTemp = _this.createVModifyParamRow(neid);
		if (vRowTemp) 
		{
			bussiness.appendChild(vRowTemp);
		}
		var hRowTemp = _this.createHModifyParamRow(neid);
		if (hRowTemp) 
		{
			bussiness.appendChild(hRowTemp);
		}
		if (vRowTemp || hRowTemp) 
        {
            di.getRoot().appendChild(bussiness);
			return di.toString();
        }
		else
		{
			return null;
		}
	}
	
	this.createVModifyParamRow = function(neid)
	{
		var isNeedSendE1_V = false;
		var row = new tagElement("row-params");
		HopTookit.addParam(row, "neid", neid);
		HopTookit.addParam(row, "groupid", xpicCache["groupId"]);
		var slotid_v = $("vPolarBdEle").value
		HopTookit.addParam(row, "slotid", slotid_v);
		HopTookit.addParam(row, "port", "1");
		var ifCurServiceType = ifParamCache["ifservtypeEle"].getElementValue();
		var isSupportE1Num =  (ifCurServiceType != ifServiceTypeStru.STMETH_VAL && ifCurServiceType != ifServiceTypeStru.SDH_VAL);
		if( ifParamCache["amEle"].getElementValue() == true &&
			ifParamCache["e1StatusEle_V"].isElementModified() && isSupportE1Num)
		{
			HopTookit.addParam(row, "IFPORT_ATTR_E1STATUS", ifParamCache["e1StatusEle_V"].getElementValue() );
			
			isNeedSendE1_V = true;
		}
		var isBandWidthModified = ifParamCache["ifchannelbandwidthEle"].isElementModified(); 
		var isAMModified = ifAttriModule.isAMElementsModified(); 
		if( (isBandWidthModified || 
				isAMModified ||
				ifParamCache["guE1CapEle_V"].isElementModified() ||
				($("e1StatusEle_V").value == EnableStatus.ENABLED && ifParamCache["allE1CapEle_V"].isElementModified())) && isSupportE1Num  )
		{
			HopTookit.addParam(row, "IFPORT_ATTR_ENSUREE1NUM", ifParamCache["guE1CapEle_V"].getElementValue() );

			var allE1CapValue = 255;

			if( ifParamCache["amEle"].getElementValue() == false )
			{
				allE1CapValue = 255;
			}
			else
			{
				if( ifParamCache["e1StatusEle_V"].getElementValue() == false )
				{
					allE1CapValue = ifParamCache["guE1CapEle_V"].getElementValue();	
				}
				else
				{
					allE1CapValue = ifParamCache["allE1CapEle_V"].getElementValue();
				}				
			}
			
			HopTookit.addParam(row, "IFPORT_ATTR_FULLE1NUM", allE1CapValue);
			
			if( ifParamCache["guE1CapEle_V"].getElementValue() != "" )
			{
				isNeedSendE1_V = true;
			}
		}
		var ifoduInfor_v = g_commonData.getIfoduStruct(slotid_v);
		var isWork_V = (null == ifoduInfor_v?true:ifoduInfor_v.getIsWork());
		var wMode = (null == ifoduInfor_v?PLA:ifoduInfor_v.getWMode());
		if( isNeedSendE1_V && !(wMode==P1J1 && !isWork_V))
		{
			return row;
		}
		else
		{
			return null;
		}
	}
	
	this.createHModifyParamRow = function(neid)
	{
		var isNeedSendE1_H = false;
		var row = new tagElement("row-params");
		HopTookit.addParam(row, "neid", neid);
		HopTookit.addParam(row, "groupid", xpicCache["groupId"]);
		var slotid_h = $("hPolarBdEle").value;
		HopTookit.addParam(row, "slotid", slotid_h);
		HopTookit.addParam(row, "port", "1");

		var ifCurServiceType = ifParamCache["ifservtypeEle"].getElementValue();
		var isSupportE1Num =  (ifCurServiceType != ifServiceTypeStru.STMETH_VAL && ifCurServiceType != ifServiceTypeStru.SDH_VAL);
		if( ifParamCache["amEle"].getElementValue() == true &&
			ifParamCache["e1StatusEle_H"].isElementModified() && isSupportE1Num)
		{
			HopTookit.addParam(row, "IFPORT_ATTR_E1STATUS", ifParamCache["e1StatusEle_H"].getElementValue() );
			
			isNeedSendE1_H = true;
		}
		var isBandWidthModified = ifParamCache["ifchannelbandwidthEle"].isElementModified(); 
		var isAMModified = ifAttriModule.isAMElementsModified(); 
		if( (isBandWidthModified || 
				isAMModified ||
				ifParamCache["guE1CapEle_H"].isElementModified() ||
				($("e1StatusEle_H").value == EnableStatus.ENABLED && ifParamCache["allE1CapEle_H"].isElementModified())) && isSupportE1Num )
		{
			HopTookit.addParam(row, "IFPORT_ATTR_ENSUREE1NUM", ifParamCache["guE1CapEle_H"].getElementValue() );

			var allE1CapValue = 255;

			if( ifParamCache["amEle"].getElementValue() == false )
			{
				allE1CapValue = 255;
			}
			else
			{
				if( ifParamCache["e1StatusEle_H"].getElementValue() == false )
				{
					allE1CapValue = ifParamCache["guE1CapEle_H"].getElementValue();	
				}
				else
				{
					allE1CapValue = ifParamCache["allE1CapEle_H"].getElementValue();
				}				
			}
			
			HopTookit.addParam(row, "IFPORT_ATTR_FULLE1NUM", allE1CapValue);
			
			if( ifParamCache["guE1CapEle_H"].getElementValue() != "" )
			{
				isNeedSendE1_H = true;
			}
		}
		var ifoduInfor_h = g_commonData.getIfoduStruct(slotid_h);
		var isWork_H =  (null == ifoduInfor_h?true:ifoduInfor_h.getIsWork());
		var wMode = (null == ifoduInfor_h?PLA:ifoduInfor_h.getWMode());
		if( isNeedSendE1_H && !(wMode==P1J1 && !isWork_H)) 
		{
			return row;
		}
		else
		{
			return null;
		}
	}
	
	this.createApplyXpicXML = function(neid)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = new tagElement("row-params");
		
		HopTookit.addParam(row, "neid", neid);

		HopTookit.addParam(row, "groupid", xpicCache["groupId"]);

		if( rfParamCache["txfreEle"].isElementModified() )
		{
			HopTookit.addParam(row, "transmitFrequency", $("txfreEle").value * 1000 );
		}

		if( rfParamCache["trspaceEle"].isElementModified() )
		{
			HopTookit.addParam(row, "trInterval", $("trspaceEle").value * 1000 );
		}
		
		if( rfParamCache["sendpwEle"].isElementModified() )
		{
			HopTookit.addParam(row, "transmitPower", $("sendpwEle").value * 10 );
		}

		if( rfParamCache["odustaEle"].isElementModified() )
		{
			HopTookit.addParam(row, "workStatus", $("odustaEle").value);
		}

		/*      XPIC                  */
		var isBandWidthModified = ifParamCache["ifchannelbandwidthEle"].isElementModified(); 
		if( isBandWidthModified )
		{
			HopTookit.addParam(row, "bandwidth", $("ifchannelbandwidthEle").value);
		}
		
		var isAMModified = ifAttriModule.isAMElementsModified(); 
		if( isBandWidthModified || isAMModified )	//  AM 4           
		{
			if( ifParamCache["amEle"].isElementModified() )	//   AM        
			{
				if( ifParamCache["amEle"].getElementValue() == false )			//   AM        
				{
					_this.setAcmParam(	row, 
										"0", 
										"255", 
										"255", 
										ifParamCache["manualmodeEle"].getElementValue()
									);
				}
				else															//   AM         
				{
					_this.setAcmParam(	row, 
										"1", 
										ifParamCache["ensureCalModeEle"].getElementValue(),
										ifParamCache["allCalModeEle"].getElementValue(),
										"255"
									);
				}
			}
			else	//        AM             
			{
				if( ifParamCache["amEle"].getElementValue() == false )			//  AM      
				{
					if( ifParamCache["manualmodeEle"].isElementModified() == true )
					{
						_this.setAcmParam(	row, 
											"0", 
											"255", 
											"255", 
											ifParamCache["manualmodeEle"].getElementValue()
										);
					}
				}
				else														//  AM     
				{
					if( ifParamCache["ensureCalModeEle"].isElementModified() == true ||
						ifParamCache["allCalModeEle"].isElementModified() == true ) 
					{
						_this.setAcmParam(	row, 
											"1", 
											ifParamCache["ensureCalModeEle"].getElementValue(),
											ifParamCache["allCalModeEle"].getElementValue(),
											"255"
										);
					}
				}
			}
		}

		/*
		if( ifParamCache["ifchannelbandwidthEle"].isElementModified() || ifAttriModule.isAMElementsModified() )
		{
			HopTookit.addParam(row, "bandwidth", $("ifchannelbandwidthEle").value);
			
			if( ifParamCache["amEle"].isElementModified() )	//   AM        
			{
				if( ifParamCache["amEle"].getElementValue() == false )			//   AM        
				{
					_this.setAcmParam(	row, 
										"0", 
										"255", 
										"255", 
										ifParamCache["manualmodeEle"].getElementValue()
									);
				}
				else															//   AM         
				{
					_this.setAcmParam(	row, 
										"1", 
										ifParamCache["ensureCalModeEle"].getElementValue(),
										ifParamCache["allCalModeEle"].getElementValue(),
										"255"
									);
				}
			}
			else	//        AM             
			{
				if( ifParamCache["amEle"].getElementValue() == false )			//  AM      
				{
						_this.setAcmParam(	row, 
											"0", 
											"255", 
											"255", 
											ifParamCache["manualmodeEle"].getElementValue()
										);
				}
				else														//  AM     
				{
						_this.setAcmParam(	row, 
											"1", 
											ifParamCache["ensureCalModeEle"].getElementValue(),
											ifParamCache["allCalModeEle"].getElementValue(),
											"255"
										);
				}
			}
		}
		*/
		bussiness.appendChild(row);
		
		var vRowTemp = _this.createVModifyParamRow(neid);
		if(vRowTemp)
		{
			bussiness.appendChild(vRowTemp);
		}
		
		var hRowTemp = _this.createHModifyParamRow(neid);
		if(hRowTemp)
		{
			bussiness.appendChild(hRowTemp);
		}

		
		var isNeedAppend = false;
		row = new tagElement("row-params");
		HopTookit.addParam(row, "neid", neid);
		HopTookit.addParam(row, "groupid", xpicCache["groupId"]);
		HopTookit.addParam(row, "groupId", xpicCache["groupId"]);
		
		if( rfParamCache["atpcenableEle"].isElementModified() == true )
		{
			HopTookit.addParam(row, "atpcEnableStatus", HopTookit.getCheckboxEleValue($("atpcenableEle")));
			isNeedAppend = true;
		}
		
		if( $("atpcenableEle").checked == true )
		{
			if( rfParamCache["atpcUpperThresEle"].isElementModified() == true ||
				rfParamCache["atpcLowerThresEle"].isElementModified() == true )
			{
			
				HopTookit.addParam(row, "atpcUpperThreshold", $("atpcUpperThresEle").value * 10);
				
				HopTookit.addParam(row, "atpcLowerThreshold", $("atpcLowerThresEle").value * 10);
				
				isNeedAppend = true;
			}
		}
		if( isNeedAppend == true )
		{
			bussiness.appendChild(row);
		}

		if( HopTookit.isElementModified($("repw_vEle")) )
		{
			row = new tagElement("row-params");
			HopTookit.addParam(row, "neid", neid);
			HopTookit.addParam(row, "slotid", g_commonData.getRelatedODUSlotId($("vPolarBdEle").value));
			HopTookit.addParam(row, "W32BRD_ATTR_RECEIVEPOWER", $("repw_vEle").value * 10);
			bussiness.appendChild(row);
		}

		
		if( HopTookit.isElementModified($("repw_hEle")) )
		{
			row = new tagElement("row-params");
			HopTookit.addParam(row, "neid", neid);
			HopTookit.addParam(row, "slotid", g_commonData.getRelatedODUSlotId($("hPolarBdEle").value));
			HopTookit.addParam(row, "W32BRD_ATTR_RECEIVEPOWER", $("repw_hEle").value * 10);
			bussiness.appendChild(row);	
		}

		di.getRoot().appendChild(bussiness);
		return di.toString();
	}
	
	
	this.setAcmParam = function(row,acmEnableStatVal, ensureCalModeVal, allCalModeVal, manualModeVal)
	{
		HopTookit.addParam(row, "amstate", acmEnableStatVal);

		HopTookit.addParam(row, "ensuremode", ensureCalModeVal);
	    
		HopTookit.addParam(row, "fullmode", allCalModeVal);
		
		HopTookit.addParam(row, "manualmode", manualModeVal);
	}
	
	/**
	 *    callback  
	 * @param doc
	 * @return
	 */
	this.applyXpicCallback = function(doc,param)
	{		
		var data = EncapsulateData(doc);
		
	    if(data.getSErrorCode() != OPERATION_SUCCESS)
	    {
	    	HopTookit.showErrorDialog(data);
	    	return data.getSErrorCode();
	    }
		if($("enablexpicEle").checked == false)
		{
			$("vPolarBdEle").disabled = false;
			$("hPolarBdEle").disabled = false;
			$("convertxpicTR").style.display = "none";
		}
		else
		{
			$("vPolarBdEle").disabled = true;
			$("hPolarBdEle").disabled = true;
			$("convertxpicTR").style.display = "";
		}
	    if( param == "create" || param == "recreate_create" )
	    {
	    	xpicCache["enablexpicEle"].updateElementValueToCacheValue();	    
	    	xpicCache["vPolarBdEle"].updateElementValueToCacheValue();
	    	xpicCache["hPolarBdEle"].updateElementValueToCacheValue();
	    	ifParamCache["vLinkIdEle"].updateElementValueToCacheValue();	    	
	    	ifParamCache["hLinkIdEle"].updateElementValueToCacheValue();	    	
	    	ifParamCache["ifchannelbandwidthEle"].updateElementValueToCacheValue();
	    	
	    	$("enablexpicEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("vPolarBdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("hPolarBdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("vLinkIdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("hLinkIdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;	    
	    	if( $("ifchannelbandwidthEle").disabled == false )
	    	{
	    		$("ifchannelbandwidthEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	}
	    	
	    	xpicCache["groupId"] = hide_groupId_xpic;

	        g_commonData.addProtectionGroupToXpicGroupArray(
	        		hide_groupId_xpic, $("hPolarBdEle").value, $("vPolarBdEle").value);
	        
	        /*          ,                 Start */
	        if( getNeProperty(parent).PreConfigedNE == "true" )
	        {
	        	var hODUSlot = g_commonData.getRelatedODUSlotId($("hPolarBdEle").value);
	        	var vODUSlot = g_commonData.getRelatedODUSlotId($("vPolarBdEle").value);
				var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_RTN_QUERY_IFODUINFO + "&nmUser="+ nmUser;
				var xmlstr = createCommonQueryXML(neid, new Array($("hPolarBdEle").value, $("vPolarBdEle").value, hODUSlot, vODUSlot) );
				loadXMLdoc(urlreq, "POST", false, queryTheOtherBoardInfoCallBack, null, "inputdata=" + xmlstr);
	        }
	        /*          ,                 End */
	        
	        return OPERATION_SUCCESS;
	    }
	    else if( param == "delete" || param == "recreate_delete" )
	    {
	    	xpicCache["enablexpicEle"].updateElementValueToCacheValue();
	    	xpicCache["vPolarBdEle"].updateElementValueToCacheValue();
	    	xpicCache["hPolarBdEle"].updateElementValueToCacheValue();
		
		if( $("enablexpicEle").disabled == false )
	    	{
	    		$("enablexpicEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	}
	    	g_commonData.deleteProtectionGroupFromXpicArray(xpicCache["groupId"]);
	    	
	    	if( param == "recreate_delete" )
	    	{
	    		return OPERATION_SUCCESS;	//  return                            
	    	}
	    	
	    	/*$("riskNoticeXpicSpan").style.display = "none";*/
	    }
	    else if( param == "modify" )
	    {
	    	ifParamCache["ifchannelbandwidthEle"].updateElementValueToCacheValue();
	    	ifParamCache["amEle"].updateElementValueToCacheValue();
	    	ifParamCache["ensureCalModeEle"].updateElementValueToCacheValue();
	    	ifParamCache["allCalModeEle"].updateElementValueToCacheValue();
	    	ifParamCache["manualmodeEle"].updateElementValueToCacheValue();
	    	
			_this.refreshModifyParamElement()
	    	
	    	if( $("ifchannelbandwidthEle").disabled == false )
	    	{
	    		$("ifchannelbandwidthEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	}
	    	if( $("amEle").disabled == false )
	    	{
	    		$("amEle").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
	    	}
	    	if( $("ensureCalModeEle").disabled == false )
	    	{
	    		$("ensureCalModeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	}
	    	if( $("allCalModeEle").disabled == false )
	    	{
	    		$("allCalModeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	}
	    	if( $("manualmodeEle").disabled == false )
	    	{
	    		$("manualmodeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	}
	    	
	    	rfParamCache["txfreEle"].updateElementValueToCacheValue();
	    	rfParamCache["trspaceEle"].updateElementValueToCacheValue();
	    	rfParamCache["atpcenableEle"].updateElementValueToCacheValue();
	    	rfParamCache["atpcUpperThresEle"].updateElementValueToCacheValue();
	    	rfParamCache["atpcLowerThresEle"].updateElementValueToCacheValue();
	    	rfParamCache["sendpwEle"].updateElementValueToCacheValue();
	    	rfParamCache["repw_hEle"].updateElementValueToCacheValue();
	    	rfParamCache["repw_vEle"].updateElementValueToCacheValue();
	    	rfParamCache["odustaEle"].updateElementValueToCacheValue();
	    	
	    	$("txfreEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("trspaceEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("atpcenableEle").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
	    	$("atpcUpperThresEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("atpcLowerThresEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("sendpwEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("repw_hEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("repw_vEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    	$("odustaEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	    }
	    else
	    {
	    }
	    
	    
	    return OPERATION_SUCCESS;
	    
	}
	
	/**
	 *   BasicField          
	 * @return
	 */
	this.isAnyElementInBasicParamFieldModified = function()
	{
		var isModified = false;
		
		for( var i = 0; i < _this.eleCanModifyArray.length; i++ )
		{
			if( xpicCache[_this.eleCanModifyArray[i]].isElementModified() == true )
			{
				isModified = true;
				break;
			}
		}

		if( $("enablexpicEle").checked == true )
		{
			if( ifParamCache["ifchannelbandwidthEle"].isElementModified() == true ||
				ifParamCache["amEle"].isElementModified() == true ||
				ifParamCache["ensureCalModeEle"].isElementModified() == true ||
				ifParamCache["allCalModeEle"].isElementModified() == true ||
				ifParamCache["manualmodeEle"].isElementModified() == true ||
				ifParamCache["e1StatusEle_V"].isElementModified() == true ||
				ifParamCache["e1StatusEle_H"].isElementModified() == true ||
				ifParamCache["guE1CapEle_V"].isElementModified() == true ||
				ifParamCache["guE1CapEle_H"].isElementModified() == true ||				
				ifParamCache["allE1CapEle_V"].isElementModified() == true ||
				ifParamCache["allE1CapEle_H"].isElementModified() == true ||
				
				rfParamCache["txfreEle"].isElementModified() == true ||
				rfParamCache["trspaceEle"].isElementModified() == true ||
				rfParamCache["sendpwEle"].isElementModified() == true ||
				rfParamCache["atpcenableEle"].isElementModified() == true ||
				rfParamCache["atpcUpperThresEle"].isElementModified() == true ||
				rfParamCache["atpcLowerThresEle"].isElementModified() == true ||
				rfParamCache["repw_vEle"].isElementModified() == true ||
				rfParamCache["repw_hEle"].isElementModified() == true ||
				rfParamCache["odustaEle"].isElementModified() == true )
			{
				isModified = true;
			}
		}
		
		return isModified;
	}
	
	/**
	 *     XpicEnable
	 * flag     1+1            
	 */
	this.showXpicStatus = function(flag)
	{
		if( flag == true )
		{
			var ifoduboardValue = $("ifoduboardEle").value;
			var eleCurValue2Obj = HopTookit.getIfoduModuleObj(ifoduboardValue);
			
			if( _this.isBoardSupportXPIC(neid, eleCurValue2Obj.ifSlotId, eleCurValue2Obj.ifBdType))
			{
				xpicCache["enablexpicEle"].setElementDisabled(false);	
			}
			else
			{
				xpicCache["enablexpicEle"].setElementDisabled(true);	
			}
			
			_this.showXPICContentTr( $("enablexpicEle").checked );
		}
		else
		{
			xpicCache["enablexpicEle"].setElementDisabled(true);

			_this.showXPICContentTr(false);
		}
	}
	
	/**
	 *       1+1        
	 */
	this.responseCreate1Plus1ProtectionChangeEvent = function(event)
	{
		_this.showXpicStatus(false);
		xpicCache["enablexpicEle"].setElementDisabled(true);
		_this.doBusinessIf_XPICEnabledChanged();
	}
	
	/**
	 *                           XPIC   
	 */
	this.processWhenIFBoardSelectChanged = function(event)
	{
		var ifoduboardValue = $("ifoduboardEle").value;
		var eleCurValue2Obj = HopTookit.getIfoduModuleObj(ifoduboardValue);

		if( _this.isBoardSupportXPIC(neid, eleCurValue2Obj.ifSlotId, eleCurValue2Obj.ifBdType) )
		{
			xpicCache["enablexpicEle"].setElementDisabled(false);
		}
		else
		{
			xpicCache["enablexpicEle"].setElementDisabled(true);
		}
	}
	
	/**
	 *          XPIC   true     false      
	 */
	this.isBoardSupportXPIC = function(tNeID, tSlotID,boardType)
	{
		return HopTookit.isBoardSupportXPIC(tNeID, tSlotID, boardType);
	}
}

/**
 *     XPIC LINKID-V   LINKID-H
 * true    false      
 */
BasicParamXPICModule.prototype.showXPICContentTr = function(flag)
{
	$("xpic_linkidTR").style.display = flag == true ? "" : "none";
}

/**
 *     
 */
BasicParamXPICModule.prototype.createXPICStatusChangeEvent = function()
{
	var event = new BasicParamXPICStatusChangeEvent();
	event.initData(	neid, 
				$("enablexpicEle").checked,
				HopTookit.getBoardInforStruct($("vPolarBdEle"), 1),
				HopTookit.getBoardInforStruct($("hPolarBdEle"), 1)
			);
	
	return event;
}

/**
 *                  
 */
BasicParamXPICModule.prototype.clearBasicParamFieldBgColor = function()
{	
	$("enablexpicEle").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
	$("vPolarBdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("hPolarBdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	
	$("hLinkIdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("vLinkIdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	/*$("guE1CapEle_V").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("guE1CapEle_H").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("e1StatusEle_V").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("e1StatusEle_H").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("allE1CapEle_V").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("allE1CapEle_H").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;*/
}


/**
 *                  
 */
BasicParamXPICModule.prototype.clearXpicGroupFieldBgColor = function()
{	
	$("enablexpicEle").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
	$("vPolarBdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("hPolarBdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;	
	$("hLinkIdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("vLinkIdEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
}


/**
 *   XPIC                      
 */
BasicParamXPICModule.prototype.filterXpicProtectionBoardInner_selectXpic = function()
{
	if( xpicCache["enablexpicEle"] == true )
	{
		return;
	}
	
	$("vPolarBdEle").options.length = 0;
	$("hPolarBdEle").options.length = 0;

	var ifoduInfoArr = g_commonData.getIFODUInforArray();
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	for( var i = 0; i < ifoduInfoArr.length; i++ )
	{
		var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];

		HopTookit.addOptionToSelectElement($("vPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
		
		if( ifSlotId != tmpIFODUBoardInfoStruct.getIFSlotId() )
		{
			HopTookit.addOptionToSelectElement($("hPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
			xpicCache["hPolarBdEle"].setElementValue( tmpIFODUBoardInfoStruct.getIFSlotId() );
			xpicCache["hPolarBdEle"].updateElementBgColor();
		}

	}
	
	xpicCache["vPolarBdEle"].setElementValue(ifSlotId);
	xpicCache["vPolarBdEle"].updateElementBgColor();
	
	if( $("hPolarBdEle").options.length == 0 )
	{	
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() )
			{
				HopTookit.addOptionToSelectElement($("hPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				xpicCache["hPolarBdEle"].setElementValue(tmpIFODUBoardInfoStruct.getIFSlotId());
				xpicCache["hPolarBdEle"].updateElementBgColor();				
			}
		}
	}

}



/**
 *      
 */
BasicParamXPICModule.prototype.filterXpicProtectionBoardAfterQuery = function()
{
	var oriVSlotId = $("vPolarBdEle").value;
	var oriHSlotId = $("hPolarBdEle").value;
	
	$("vPolarBdEle").options.length = 0;
	$("hPolarBdEle").options.length = 0;

	var ifoduInfoArr = g_commonData.getIFODUInforArray();
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	for( var i = 0; i < ifoduInfoArr.length; i++ )
	{
		var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];

		if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() ||
			HopTookit.getPairingBoard(ifSlotId) == tmpIFODUBoardInfoStruct.getIFSlotId() )	
		{
			HopTookit.addOptionToSelectElement($("vPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
			
			if( oriHSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() )
			{
				HopTookit.addOptionToSelectElement($("hPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
			}
		}
	}
	
	xpicCache["vPolarBdEle"].updateCacheValueToElementValue();
	xpicCache["vPolarBdEle"].updateElementBgColor();
	
	xpicCache["hPolarBdEle"].updateCacheValueToElementValue();
	xpicCache["hPolarBdEle"].updateElementBgColor();
}


/**
 * flag          
 */
BasicParamXPICModule.prototype.setHBoardWhenChangeVBoard = function(flag)
{
	var ifoduInfoArr = g_commonData.getIFODUInforArray();
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	if( flag == "H" )
	{
		$("vPolarBdEle").options.length = 0;
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			HopTookit.addOptionToSelectElement($("vPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
		}
		if( $("hPolarBdEle").value != ifSlotId )
		{
			xpicCache["vPolarBdEle"].setElementValue(ifSlotId);
			xpicCache["vPolarBdEle"].updateElementBgColor();
		}
	}
	else
	{
		$("hPolarBdEle").options.length = 0;
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			HopTookit.addOptionToSelectElement($("hPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
		}
		if( $("vPolarBdEle").value != ifSlotId )
		{
			xpicCache["hPolarBdEle"].setElementValue(ifSlotId);
			xpicCache["hPolarBdEle"].updateElementBgColor();
		}
	}
	ifAttriModule.queryEthBandWidth();
/*	
	var destValue = $("vPolarBdEle").value;
	if( $("vPolarBdEle").value == $("ifoduboardEle").value )
	{
		$("vPolarBdEle").options.length = 0;
		$("hPolarBdEle").options.length = 0;

		var ifoduInfoArr = g_commonData.getIFODUInforArray();
		
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			
			if( $("ifoduboardEle").value == tmpIFODUBoardInfoStruct.getIFSlotId() ||
					HopTookit.isPairingBoard($("ifoduboardEle").value, tmpIFODUBoardInfoStruct.getIFSlotId()) )
			{
				HopTookit.addOptionToSelectElement($("vPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				
				if( $("ifoduboardEle").value != tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					HopTookit.addOptionToSelectElement($("hPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
					
					if( HopTookit.isPairingBoard($("ifoduboardEle").value, tmpIFODUBoardInfoStruct.getIFSlotId()) )
					{
						xpicCache["hPolarBdEle"].setElementValue(tmpIFODUBoardInfoStruct.getIFSlotId());
						xpicCache["hPolarBdEle"].updateElementBgColor();
					}
					
					if( i == ifoduInfoArr.length - 1 && $("hPolarBdEle").value == "" )
					{
						xpicCache["hPolarBdEle"].setElementValue( ifoduInfoArr[0].getIFSlotId() );
						xpicCache["hPolarBdEle"].updateElementBgColor();
					}
				}
			}
		}

		xpicCache["vPolarBdEle"].setElementValue(destValue);
		xpicCache["vPolarBdEle"].updateElementBgColor();
	}
	else
	{
		$("hPolarBdEle").options.length = 0;

		var ifoduInfoArr = g_commonData.getIFODUInforArray();
		
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			
			if( $("ifoduboardEle").value == tmpIFODUBoardInfoStruct.getIFSlotId() )
			{
				HopTookit.addOptionToSelectElement($("hPolarBdEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				
				xpicCache["hPolarBdEle"].setElementValue(tmpIFODUBoardInfoStruct.getIFSlotId());
				xpicCache["hPolarBdEle"].updateElementBgColor();
			}	
		}
	}
*/
}


/**
 *       XPIC            
 */
function BasicParamXPICStatusChangeEvent()
{
	var _this = this;
	
	this.eventType = EVENT_TYPE.XPICPROTECTTION_XPICENABLECHANGE_EVENT;

	this.neid = "-1";
	
	this.xpicStatus = "0";
	
	this.vBdStruct = null;
	
	this.hBdStruct = null;

	this.initData = function(tNeId, xpicStat, vboardStruct, hboardStruct) 
	{
		_this.neid = tNeId;
		
		_this.xpicStatus = xpicStat;

		_this.vBdStruct = vboardStruct;
		
		_this.hBdStruct = hboardStruct;
	}
	
	this.getEventType = function()
	{
		return _this.eventType;
	}
	
	this.getNeId = function()
	{
		return _this.neid;
	}
	
	this.getXPICStatus = function()
	{
		return _this.xpicStatus;
	}
	
	this.getVBoardStruct = function()
	{
		return _this.vBdStruct;
	}
	
	this.getHBoardStruct = function()
	{
		return _this.hBdStruct;
	}
}

/**
 *       XPIC            
 */
function BasicParamXPICRefreshBoardDataEvent()
{
	var _this = this;
	
	this.eventType = EVENT_TYPE.XPICPROTECTTION_REFRESHBOARDDATA_EVENT;
	
	this.vBdStruct = null;
	
	this.hBdStruct = null;
	
	this.data = null;

	this.initData = function(_vBoardStruct, _hBoardStruct, _data)
	{
		_this.vBdStruct = _vBoardStruct;
		_this.hBdStruct = _hBoardStruct;
		_this.data = _data;
	}
	
	this.getEventType = function()
	{
		return _this.eventType;
	}
	
	this.getVBdStruct = function()
	{
		return _this.vBdStruct;
	}
	
	this.getHBdStruct = function()
	{
		return _this.hBdStruct;
	}
	
	this.getData = function()
	{
		return _this.data;
	}
}

function convertXPICDirection()
{
	if (!confirm(RESOURCE["confimswitch"]))
	{
		return;
	}
	parent.LoadingProcess.showWaitStatus("../../../../images/",RESOURCE["loadingtitle"]);
	var xmlStr = createHVConvertXML();
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_SET_XPIC_BD_POLAR + "&flag=1" + "&nmUser="
			+ nmUser;
	loadXMLdoc(urlreq, "POST", true, convertXPICDirectionHandler, null, "inputdata="
			+ xmlStr);
}

function createHVConvertXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = null;
	var param = null;
	row = new tagElement("row-params");

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "groupId");
	param.setAttribute("value", xpicCache["groupId"]);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "hPolarBdid");
	param.setAttribute("value", $("vPolarBdEle").value);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "vPolarBdid");
	param.setAttribute("value", $("hPolarBdEle").value);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}
function convertXPICDirectionHandler(doc)
{
	parent.LoadingProcess.removeWaitStatus();
	var dinterface = EncapsulateData(doc);
	if (0 != dinterface.getSErrorCode())
	{
		showErrorDialog(dinterface);
		return;
	}
	queryNeInformation();
}
