

/**
 *         
 */

var protectionCache = new Object();
protectionCache["protectionEle"] = false;		//1+1    1+0
protectionCache["workmodeEle"] = new DecoratedElement();
protectionCache["workmodeEle"].bindElement("workmodeEle", DECORATED_ELEMENT_TYPE.SELECT);
protectionCache["workboardEle"] = new DecoratedElement();
protectionCache["workboardEle"].bindElement("workboardEle", DECORATED_ELEMENT_TYPE.SELECT);
protectionCache["protectboardEle"] = new DecoratedElement();
protectionCache["protectboardEle"].bindElement("protectboardEle", DECORATED_ELEMENT_TYPE.SELECT);
protectionCache["rModeEle"] = new DecoratedElement();
protectionCache["rModeEle"].bindElement("rModeEle", DECORATED_ELEMENT_TYPE.SELECT);
protectionCache["wtrTimeEle"] = new DecoratedElement();
protectionCache["wtrTimeEle"].bindElement("wtrTimeEle", DECORATED_ELEMENT_TYPE.TEXT);
protectionCache["switchEnableEle"] = new DecoratedElement();
protectionCache["switchEnableEle"].bindElement("switchEnableEle", DECORATED_ELEMENT_TYPE.SELECT);
protectionCache["groupId"] = -1;
protectionCache["equipSlotId"] = -1;

var hide_groupId = -1;	


function BasicParamModule()
{
	var _this = this;

	this.eleOnChangeArray = new Array(	"wtrTimeEle",
										"switchEnableEle");

	this.eleCanModifyArray = new Array(	"workboardEle",
										"protectboardEle", 
										"wtrTimeEle",
										"switchEnableEle",
										"workmodeEle",
										"rModeEle");
	
	this.listenerList = new Array();
	
	this.addListener = function(obj)
	{
		_this.listenerList.push(obj);
	}
	
	this.notifyAll = function(event)
	{		
		for( var i = 0; i < _this.listenerList.length; i++ )
		{
			var obj = _this.listenerList[i];
			obj.response(event);
		}
	}

	/**
	 *       
	 */
	this.queryNeInformation = function()
	{
		_this.clearParamField();
		
		_this.queryProtection();
	}
	
	/**
	 *     1+1   
	 * @return
	 */
	this.queryProtection = function()
	{
		var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_GET_RADIO_1J1PG + "&nmUser="+ nmUser;
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
		var tmpSlotArray = new Array(ifSlotId);
		var xmlstr = createCommonQueryXML(neid, tmpSlotArray);
		
		loadXMLdoc(urlreq, "POST", true, _this.queryProtectionCallback, false, "inputdata=" + xmlstr);
	}

	/**
	 *     1+1    callback  
	 * @param doc
	 * @return
	 */
	this.queryProtectionCallback = function(doc)
	{
		/*$("riskNotice1Plus1Span").style.display = "none";*/
		
		var data = EncapsulateData(doc);
		
		var dataArray = new Array();
		
	    if(data.getSErrorCode() != OPERATION_SUCCESS)
	    {
	    	dataArray.push(data);
	    }
	    if( !HopTookit.isSupport1J1(neid, neType, shelfType) )
	    {
	    	$("if1plus1TR").style.display = "none";
	    	$("if1plus0").disabled = true;
	    	$("if1plus1").disabled = true;
	    }
	    else
	    {
	    	$("if1plus1TR").style.display = "";
	    	$("if1plus0").disabled = false;
	    	$("if1plus1").disabled = false;
	    }
	    var rowid = _this.IF1plus1GroupRelatedToThisBoardExist(data);

	    var isRelatedProtectGrpExist = rowid == -1 ? false : true;
	   	if( isRelatedProtectGrpExist == true )
	    {
	    	var workingSlotId = data.getDataRowParam(rowid, "workingSlotId");
	    	var protectionSlotId = data.getDataRowParam(rowid, "protectionSlotId");
	    	
	    	if( workingSlotId == "0" || protectionSlotId == "0" )
	    	{
	    		isRelatedProtectGrpExist = false;
	    	}
	    }
		
		$("workmodeEle").disabled = false;
		$("workboardEle").disabled = false;
		$("protectboardEle").disabled = false;
	    if( isRelatedProtectGrpExist == false )	//               
	    {
	    	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	    	$("workboardEle").value = ifSlotId;
	    	$("protectboardEle").value = ifSlotId;
	    	_this.showIF1Plus1ConfigurationPannel(false);
	    	
	    	protectionCache["protectionEle"] = false;
	    }
	    else
	    {
	    	var groupId = data.getDataRowParam(rowid, "groupId");
	    	var workingSlotId = data.getDataRowParam(rowid, "workingSlotId");
	    	var protectionSlotId = data.getDataRowParam(rowid, "protectionSlotId");
			var workingbdname = data.getDataRowParam(rowid, "workingbdname");
			var protectbdname = data.getDataRowParam(rowid, "protectbdname");
			var wMode = data.getDataRowParam(rowid, "wMode");
			
			var rMode = data.getDataRowParam(rowid, "rMode");
			var wtrTime = data.getDataRowParam(rowid, "wtrTime");
			var switchEnable = data.getDataRowParam(rowid, "switchEnable");
		
			var equipSlotId = data.getDataRowParam(rowid, "equipSlotId");
			
			$("workmodeEle").value = wMode;
			$("workboardEle").value = workingSlotId;
			$("protectboardEle").value = protectionSlotId;
			$("rModeEle").value = rMode;
			$("wtrTimeEle").value = wtrTime;
			$("switchEnableEle").value = switchEnable;
	        
	        protectionCache["protectionEle"] = true;
	        protectionCache["workmodeEle"].updateElementValueToCacheValue();
	        protectionCache["workboardEle"].updateElementValueToCacheValue();
	        protectionCache["protectboardEle"].updateElementValueToCacheValue();
	        protectionCache["rModeEle"].updateElementValueToCacheValue();
	        protectionCache["wtrTimeEle"].updateElementValueToCacheValue();
	        protectionCache["switchEnableEle"].updateElementValueToCacheValue();
	        protectionCache["groupId"] = groupId;
	        protectionCache["equipSlotId"] = equipSlotId;
	        
	        hide_groupId = groupId;

	        _this.showIF1Plus1ConfigurationPannel(true);
	    	$("enablexpicEle").disabled = true;
			
			$("workmodeEle").disabled = true;
			$("workboardEle").disabled = true;
			$("protectboardEle").disabled = true;
	        
	        _this.setIFComponentsDisabledViaBusiness();

			/** 
			* RTN605    ,7 8      1+1  ,    ,         
			*/ 
	        if( neType != NETYPE_RTN905 && neType != NETYPE_RTN605) //    905  
	        {
	        	_this.filterIF1Plus1ProtectionBoardAfterQuery();
	        }
	    }
	    
	    /*   RTn605 RTN610     1+1     */
	    _this.supportIF1Plus1EditDeal();

	    /*   Work Mode      */
	    var modechange_event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_MODECHANGE_EVENT);
		_this.notifyAll(modechange_event);
		
		/*   Board       */
		var boardchange_event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_BOARDCHANGE_EVENT);
		_this.notifyAll(boardchange_event);

		/*              */
		var refreshgraph_event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_REFRESHGRAPH_EVENT);
		_this.notifyAll(refreshgraph_event);

		queryNeInformation_Xpic(dataArray);
		
		_this.filterUnsupportAttrByBoard();
	}
	
	/**
	 *        1+1              
	 */
	this.supportIF1Plus1EditDeal = function()
	{
		if(!HopTookit.isSupportEditIF1Plus1(neid, neType))
		{
			 $("if1plus0").disabled = true;
			 $("if1plus1").disabled = true;	
			 $("workmodeEle").disabled = true;
			 $("workboardEle").disabled = true;	
			 $("protectboardEle").disabled = true;	
		}
	}
	

	this.getApplyOperationType = function()
	{
		var operationType = NEOPERATION_TYPE.DONOTING;
		
		if( $("if1plus0").checked == true && protectionCache["protectionEle"] == true )			//         
		{
			operationType = NEOPERATION_TYPE.DELETE;
		}
		else if( $("if1plus1").checked == true )												//                
		{
			if( protectionCache["protectionEle"] == false )										//         
			{
				operationType = NEOPERATION_TYPE.CREATE;
			}
			else									//        
			{
				if( protectionCache["workmodeEle"].isElementModified() == true ||
					protectionCache["workboardEle"].isElementModified() == true ||
					protectionCache["protectboardEle"].isElementModified() == true 
				  )	//                                          
				{
					operationType = NEOPERATION_TYPE.RECREATE;
				}
				else
				{
					operationType = NEOPERATION_TYPE.MODIFY;
				}
			}
		}
		
		return operationType;
	}
	
	/**
	 *    callback  
	 * @param doc
	 * @return
	 */
	this.applyIF1Plus1Callback = function(doc,param)
	{
		var data = EncapsulateData(doc);
		parent.buttonStruct.queryButton.disabled = false;
	    if(data.getSErrorCode() != OPERATION_SUCCESS)
	    {
			parent.buttonStruct.applyButton.disabled = false;
	    	HopTookit.showErrorDialog(data);
	    	return;
	    }
		parent.buttonStruct.applyButton.disabled = true;
		if($("if1plus1").checked == false)
		{
			$("workmodeEle").disabled = false;
			$("workboardEle").disabled = false;
			$("protectboardEle").disabled = false;
		}
		else
		{
			$("workmodeEle").disabled = true;
			$("workboardEle").disabled = true;
			$("protectboardEle").disabled = true;
		}
		
	    if( param == "create" || param == "recreate_create" )
	    {
	    	protectionCache["protectionEle"] = true;
	    	protectionCache["groupId"] = hide_groupId;
	    	protectionCache["workmodeEle"].updateElementValueToCacheValue();
	    	protectionCache["workboardEle"].updateElementValueToCacheValue();
	    	protectionCache["protectboardEle"].updateElementValueToCacheValue();
	        protectionCache["rModeEle"].updateElementValueToCacheValue();
	        protectionCache["wtrTimeEle"].updateElementValueToCacheValue();
	        protectionCache["switchEnableEle"].updateElementValueToCacheValue();
	        
	        g_commonData.addProtectionGroupToIF1PlusGroupArray(
	        		hide_groupId, $("workboardEle").value, $("protectboardEle").value);

	        /*          ,                 Start */
	        if( getNeProperty(parent).PreConfigedNE == "true" )
	        {
	        	var workODUSlot = g_commonData.getRelatedODUSlotId($("workboardEle").value);
	        	var protODUSlot = g_commonData.getRelatedODUSlotId($("protectboardEle").value);
				var urlreq = "../../../../neExlorerServlet?sfid=" + TECMD_RTN_QUERY_IFODUINFO + "&nmUser="+ nmUser;
				var xmlstr = createCommonQueryXML(neid, new Array($("workboardEle").value, $("protectboardEle").value, workODUSlot, protODUSlot) );
				loadXMLdoc(urlreq, "POST", false, queryTheOtherBoardInfoCallBack, null, "inputdata=" + xmlstr);
	        }
	        /*          ,                 End */
	        
			var refreshgraph_event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_REFRESHGRAPH_EVENT);
			_this.notifyAll(refreshgraph_event);			
	    }
	    else if( param == "delete" || param == "recreate_delete" )
	    {
	    	protectionCache["protectionEle"] = false;
			protectionCache["workboardEle"].initCacheValue();
	    	protectionCache["protectboardEle"].initCacheValue();
	    	g_commonData.deleteProtectionGroupFromIF1PlusGroupArray(protectionCache["groupId"]);
	    	
	    	if( param == "recreate_delete" )
	    	{
	    		return;	//  return                            
	    	}
	    	
	    	/*$("riskNotice1Plus1Span").style.display = "none";*/
	    	
			var refreshgraph_event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_REFRESHGRAPH_EVENT);
			_this.notifyAll(refreshgraph_event);
	    }
	    else if( param == "modify" )
	    {
	    }
	    else
	    {
	    }
	    
	    _this.clearBasicParamFieldBgColor();
	  
		parent.buttonStruct.queryButton.disabled = false;
		parent.buttonStruct.applyButton.disabled = true;
	}

	/**
	 *    xml  
	 * @param neid
	 * @param sfId
	 * @return
	 */
	this.createModifyIf1Plus1XML = function(neid, sfId)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");

		var row = new tagElement("row-params");
		
		HopTookit.addParam(row, "sfId", sfId);
		
		HopTookit.addParam(row, "neid", neid);					//   ID
		
		HopTookit.addParam(row, "groupId", protectionCache["groupId"]);	//      ID

		
		HopTookit.addParam(row, "wmode", $("workmodeEle").value);

		HopTookit.addParam(row, "rMode", $("rModeEle").value);	//         
		
		HopTookit.addParam(row, "wtrTime", $("wtrTimeEle").value);//         
		
		if( $("workmodeEle").value != wModeStru.FDVal )
		{
			HopTookit.addParam(row, "switchEnable", $("switchEnableEle").value);//         
		}

		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);

		return di.toString();
	}

	/**
	 *   1+1   xml
	 * @param neid
	 * @param sfId
	 * @return
	 */
	this.createDeleteIf1Plus1XML = function(neid, sfId)
	{	
	    var di = new inputxml("datainterface");
	    var bussiness = new tagElement("bussiness-params");
	    var row = new tagElement("row-params");

	    HopTookit.addParam(row, "sfId", sfId);

	    HopTookit.addParam(row, "neid", neid);
	    
	    HopTookit.addParam(row, "groupId", protectionCache["groupId"]);

	    bussiness.appendChild(row);
	    di.getRoot().appendChild(bussiness);
	    
	    return di.toString();	
	}

	/**
	 *   1+1   xml
	 * @param neid
	 * @param sfId
	 * @return
	 */
	this.createAddIf1Plus1XML = function(neid, sfId, type)
	{
		var di = new inputxml("datainterface");
		var bussiness = new tagElement("bussiness-params");
		var row = new tagElement("row-params");

		HopTookit.addParam(row, "sfId", sfId);

		HopTookit.addParam(row, "neid", neid);
		
		if( type == "create" )
		{
			var groupIds = new Array(1, 2, 3, 4, 5, 6, 7);
			for (var i = 0, m = g_commonData.m_exsistingIF1plus1GroupArray.length; i < m; i++)
			{
				var tmpIF1Plus1GrouObjcet = g_commonData.m_exsistingIF1plus1GroupArray[i];
				var tmpGroupId = tmpIF1Plus1GrouObjcet.groupId;
				groupIds.remove(tmpGroupId);
			}
			hide_groupId = groupIds[0];
		}
		if( type == "recreate_create" )
		{
			hide_groupId = protectionCache["groupId"];
		}
		
		HopTookit.addParam(row, "groupId", hide_groupId);
		
		HopTookit.addParam(row, "wMode", $("workmodeEle").value);
		
		HopTookit.addParam(row, "workingSlotId", $("workboardEle").value);
		
		HopTookit.addParam(row, "workingport", "1");
		
		HopTookit.addParam(row, "protectionSlotId", $("protectboardEle").value);

		HopTookit.addParam(row, "protectionport", "1");

		HopTookit.addParam(row, "rMode", $("rModeEle").value);
		
		HopTookit.addParam(row, "wtrTime", $("wtrTimeEle").value);

		if ( $("workmodeEle").value != wModeStru.FDVal )
		{
			HopTookit.addParam(row, "switchEnable", $("switchEnableEle").value);
		}
		
		bussiness.appendChild(row);
		di.getRoot().appendChild(bussiness);
		return di.toString();
	}

	/**
	 *                            
	 * @return
	 */
	this.initBasicParamFieldOptions = function()
	{
		var ifoduInfoArr = g_commonData.getIFODUInforArray();
		
		/*    Protection      */
		$("workmodeEle").options.length = 0;
		$("workmodeEle").options[$("workmodeEle").options.length] = new Option(wModeStru.SD, wModeStru.SDVal);
		$("workmodeEle").options[$("workmodeEle").options.length] = new Option(wModeStru.FD, wModeStru.FDVal);
		$("workmodeEle").options[$("workmodeEle").options.length] = new Option(wModeStru.HSB, wModeStru.HSBVal);
		
		$("workboardEle").options.length = 0;
		$("protectboardEle").options.length = 0;
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];

			HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
			HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
		}
		
		$("rModeEle").options.length = 0;
		$("rModeEle").options[$("rModeEle").options.length] = new Option(RESOURCE["revertivemode"], revtModeStru.reveriveModeVal);
		$("rModeEle").options[$("rModeEle").options.length] = new Option(RESOURCE["nonrevertivemode"], revtModeStru.nonreveriveModeVal);

		HopTookit.checkDataRange($("wtrTimeEle"), wtrTimeStru.minValue, wtrTimeStru.maxValue);

		$("switchEnableEle").options.length = 0;
		$("switchEnableEle").options[$("switchEnableEle").options.length] = new Option(RESOURCE["enable"], EnableStatus.ENABLED);
		$("switchEnableEle").options[$("switchEnableEle").options.length] = new Option(RESOURCE["disable"], EnableStatus.DISABLED);
		/*    Protection      */
	}
	
	/**
	 *        
	 * @return
	 */
	this.clearParamField = function()
	{
		$("workboardEle").options.length = 0;
		$("protectboardEle").options.length = 0;
		var ifoduInfoArr = g_commonData.getIFODUInforArray();
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];

			HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
			HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
		}
		
		$("if1plus0").checked = true;
		$("workmodeEle").selectedIndex = wModeStru.HSBVal;
		$("rModeEle").value = revtModeStru.reveriveModeVal;
		$("wtrTimeEle").value = wtrTimeStru.defaultValue;
		$("switchEnableEle").value = EnableStatus.ENABLED;
		
		protectionCache["protectionEle"] = false;
		protectionCache["workmodeEle"].initCacheValue();
		protectionCache["workboardEle"].initAllValue();		//          
		protectionCache["protectboardEle"].initAllValue();	//          
		protectionCache["rModeEle"].initCacheValue();
		protectionCache["wtrTimeEle"].initCacheValue();
		protectionCache["switchEnableEle"].initCacheValue();
		
		_this.clearBasicParamFieldBgColor();
	}

	/**
	 *                1+1   
	 *                 -1 
	 *              ID    
	 * @return
	 */
	this.IF1plus1GroupRelatedToThisBoardExist = function(data)
	{
		g_commonData.m_exsistingIF1plus1GroupArray.clear();
		
		var rowid = -1;
		var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	    for( var i = 0; i < data.getDataRowLength(); i++ )
	    {
	    	var workingSlotId = data.getDataRowParam(i, "workingSlotId");
	    	var protectionSlotId = data.getDataRowParam(i, "protectionSlotId");
	    	
			if( ifSlotId == workingSlotId || ifSlotId == protectionSlotId )
			{
				rowid = i;
			}
			
			var tmpGroupId = data.getDataRowParam(i, "groupId");

	        g_commonData.addProtectionGroupToIF1PlusGroupArray(tmpGroupId, 
	        		workingSlotId, protectionSlotId);
	    }
	    
	    return rowid;
	}
	
	this.setBaiscParamAtomEditHandler = function()
	{
		for( var i = 0; i < _this.eleOnChangeArray.length; i++ )
		{
			$(_this.eleOnChangeArray[i]).onchange = function()
			{
				HopTookit.processCellOnchange(protectionCache[this.id]);
			} 
		}
		
		$("if1plus0").onclick = function()
		{
			_this.doBusinessIf_IF1Plus0ProtectionChanged();
				  
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("if1plus1").onclick = function()
		{
			if( protectionCache["protectionEle"] == false && $("if1plus1").checked == true &&
				ifParamCache["ifservtypeEle"].isElementModified() )
			{
				alert(RESOURCE["create1plus1_and_setservtype_notice2"]);
				$("if1plus0").checked = true;
				return;
			}
			
			_this.doBusinessIf_IF1Plus1ProtectionChanged();							//mach
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}
		
		$("workmodeEle").onchange = function()
		{
			_this.doBusinessIf_WorkModeEleChanged();
			
			HopTookit.sendUnionEvent(terminalType, this.id, _this);
		}

		$("workboardEle").onchange = function()
		{
			/*	     
			if( $("workboardEle").value != $("ifoduboardEle").value && 
				$("protectboardEle").value != $("ifoduboardEle").value )
			{
				alert(RESOURCE["themsg"] + $("ifoduboardEle").options[$("ifoduboardEle").selectedIndex].text + RESOURCE["if1plus1boardselectmsg"]);
				protectionCache["workboardEle"].modifyElementValue( $("ifoduboardEle").value );
				return;
			}
			*/
			
			_this.setProtecttionBoardWhenChangeWorkBoard();
			
			HopTookit.processCellOnchange(protectionCache[this.id]);
		    var event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_BOARDCHANGE_EVENT);
			_this.notifyAll(event);
		}
		
		$("protectboardEle").onchange = function()
		{
			/*	     
			if( $("workboardEle").value != $("ifoduboardEle").value && 
				$("protectboardEle").value != $("ifoduboardEle").value )
			{
				alert(RESOURCE["themsg"] + $("ifoduboardEle").options[$("ifoduboardEle").selectedIndex].text + RESOURCE["if1plus1boardselectmsg"]);
				protectionCache["protectboardEle"].modifyElementValue( $("ifoduboardEle").value );
				return;
			}
			*/
			
			HopTookit.processCellOnchange(protectionCache[this.id]);
			var event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_BOARDCHANGE_EVENT);
			_this.notifyAll(event);
		}
		
		$("rModeEle").onchange = function()
		{
			HopTookit.processCellOnchange(protectionCache[this.id]);
			_this.setIFComponentsDisabledViaBusiness();
			
			var desValue = $("rModeEle").value == EnableStatus.ENABLED ? "600" : "0";
			protectionCache["wtrTimeEle"].modifyElementValue(desValue);
		}
	}

	/**
	 *         1+1    1+0                   
	 * @return
	 */
	this.showIF1Plus1ConfigurationPannel = function(showflag)
	{
		if( showflag )
		{
			$("if1plus1").checked = true;
			$("workmodeTR").style.display = "";
			$("workboardTR").style.display = "";
			$("protectboardTR").style.display = "";
			$("advanceTR").style.display = "";

			$("advanceCompTR").style.display = "";
		}
		else
		{
			$("if1plus0").checked = true;
			$("workmodeTR").style.display = "none";
			$("workboardTR").style.display = "none";
			$("protectboardTR").style.display = "none";
			$("advanceTR").style.display = "none";

			$("advanceCompTR").style.display = "none";
		}
		
	    /*   Work Mode      */
	    var modechange_event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_MODECHANGE_EVENT);
		_this.notifyAll(modechange_event);
		
		var boardchange_event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_BOARDCHANGE_EVENT);
		_this.notifyAll(boardchange_event);
		
		HopTookit.setFocusOnElement(document.body);
	}

	/**
	 *                    
	 * @return
	 */
	this.setIFComponentsDisabledViaBusiness = function()
	{

		protectionCache["wtrTimeEle"].setElementDisabled( $("rModeEle").value == revtModeStru.nonreveriveModeVal ? true : false );
		protectionCache["switchEnableEle"].setElementDisabled( $("workmodeEle").value == wModeStru.FDVal ? true : false );
	}

	/**
	 *   BasicField          
	 * @return
	 */
	this.isAnyElementInBasicParamFieldModified = function()
	{
		var isModified = false;
		
		for( var i = 0; i < _this.eleCanModifyArray.length; i++ )
		{
			if( protectionCache[_this.eleCanModifyArray[i]].isElementModified() == true )
			{
				isModified = true;
				break;
			}
		}

		if( protectionCache["protectionEle"] != $("if1plus1").checked )
		{
			isModified = true;
		}
		
		return isModified;
	}

	this.deleteProtection = function(type)
	{
		var sfId = NSCMD_CFG_DEL_RADIO_1J1PG;
		var xmlstr = _this.createDeleteIf1Plus1XML(neid, sfId);
		
		var urlreq = "../../../../neExlorerServlet?sfid=" + sfId + "&nmUser="+ nmUser;
		
		var defaulttype = "delete";
		if( "recreate_delete" == type )
		{
			defaulttype = "recreate_delete";
		}
		
		loadXMLdoc(urlreq, "POST", false, _this.applyIF1Plus1Callback, defaulttype, "inputdata=" + xmlstr);
	}

	this.createProtection = function(type)
	{
		var defaulttype = "create";
		if( "recreate_create" == type )
		{
			defaulttype = "recreate_create";
		}
		
		var sfId = NSCMD_CFG_ADD_RADIO_1J1PG;
		var xmlstr = _this.createAddIf1Plus1XML(neid, sfId, defaulttype);
		
		var urlreq = "../../../../neExlorerServlet?sfid=" + sfId + "&nmUser="+ nmUser;
		loadXMLdoc(urlreq, "POST", false, _this.applyIF1Plus1Callback, defaulttype, "inputdata=" + xmlstr);
	}

	this.modifyProtection = function()
	{
		var sfId = NSCMD_CFG_SET_RADIO_1J1PG_RESTORE_MO;
		var xmlstr = _this.createModifyIf1Plus1XML(neid, sfId);
		
		var urlreq = "../../../../neExlorerServlet?sfid=" + sfId + "&nmUser="+ nmUser;
		loadXMLdoc(urlreq, "POST", false, _this.applyIF1Plus1Callback, "modify", "inputdata=" + xmlstr);	
	}

	/**
	 *     1+1                                         
	 * @return
	 */	
	this.recreateProtection = function()
	{
		_this.deleteProtection("recreate_delete");
	
		_this.createProtection("recreate_create");
	}

	this.operateCommonIf1Plus1Protection = function(sfId, xmlstr)
	{
		var urlreq = "../../../../neExlorerServlet?sfid=" + sfId + "&nmUser="+ nmUser;
		loadXMLdoc(urlreq, "POST", false, _this.applyIF1Plus1Callback, false, "inputdata=" + xmlstr);
	}
	
	/**
	 *      
	 */
	this.initCurrentDomain = function()
	{
		$("basicParamSpan").innerText = RESOURCE["basicparam"];
		/* init Protection Filed Start */
		$("protectionSpan").innerText = RESOURCE["protectionSpan"];
		$("workmodeSpan").innerText = RESOURCE["workmodeTR"];
		$("workboardSpan").innerText = RESOURCE["workingboardTR"];
		$("protectboardSpan").innerText = RESOURCE["protectingboardTR"];	
		$("advanceSpan").innerText = RESOURCE["advanceSpan"];
		$("rModeSpan").innerText = RESOURCE["rmodeSpan"];
		$("rModeSpan").innerText = RESOURCE["rmodeSpan"];
		$("wtrTimeSpan").innerText = RESOURCE["wtrtimeSpan"];
		$("switchEnableSpan").innerText = RESOURCE["switchenableSpan"];
		/* init Basic Parameters Filed End */
		
		_this.setBaiscParamAtomEditHandler();
	}
	
	/**
	 *     
	 */
	this.createBasicParamIF1Plus1ChangeEvent = function(evtType)
	{
	    var event = new BasicParamIF1Plus1ChangeEvent();	    
	    var workIFBoard = new IFODUBoardInfoStruct();
	    workIFBoard.setIFSlotId($("workboardEle").value);
	    workIFBoard.setIFBdName("-");
	    workIFBoard.setODUSlotId(g_commonData.getRelatedODUSlotId($("workboardEle").value));
	    
	    var protectIFBoard = new IFODUBoardInfoStruct();
	    protectIFBoard.setIFSlotId($("protectboardEle").value);
	    protectIFBoard.setIFBdName("-");
	    protectIFBoard.setODUSlotId(g_commonData.getRelatedODUSlotId($("protectboardEle").value));

	    var isRelatedProtectGrpExist = g_commonData.isRelatedIF1Plus1GroupExist();
	    
	    event.initData(neid,protectionCache["groupId"], $("workmodeEle").value ,workIFBoard, protectIFBoard, evtType, protectionCache["equipSlotId"]);
	    
	    return event;
	}
	
	
	/**
	 *  1plus0                
	 */
	this.doBusinessIf_IF1Plus0ProtectionChanged = function()
	{
		if( protectionCache["protectionEle"] == true )		//         
		{
			/*$("riskNotice1Plus1Span").style.display = "";*/
			alert(RESOURCE["DELETE_1PLUS1_RPOTECTION_ALARM"]);
		}
		else												//         
		{
			/*$("riskNotice1Plus1Span").style.display = "none";*/
		}
		
		$("if1plus0").style.backgroundColor = protectionCache["protectionEle"] == !$("if1plus0").checked ?
				CELL_ORIGINAL_BGCOLOR : CELL_MODIFIED_BGCOLOR;
		
		$("if1plus1").style.backgroundColor = protectionCache["protectionEle"] == $("if1plus1").checked ?
				CELL_ORIGINAL_BGCOLOR : CELL_MODIFIED_BGCOLOR;
		
		HopTookit.setFocusOnElement(document.body);
		parent.buttonStruct.applyButton.disabled = false;
		
		_this.showIF1Plus1ConfigurationPannel(false);
		
		var event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_DELETEPROTECTIONCHANGE_EVENT);
		_this.notifyAll(event);
		
		adjustCellWidth();
	}

	/**
	 *  1plus1                
	 */
	this.doBusinessIf_IF1Plus1ProtectionChanged = function()
	{
		/*$("riskNotice1Plus1Span").style.display = "none";*/

		$("if1plus0").style.backgroundColor = protectionCache["protectionEle"] == !$("if1plus0").checked ?
				CELL_ORIGINAL_BGCOLOR : CELL_MODIFIED_BGCOLOR;
		
		$("if1plus1").style.backgroundColor = protectionCache["protectionEle"] == $("if1plus1").checked ?
				CELL_ORIGINAL_BGCOLOR : CELL_MODIFIED_BGCOLOR;
		
		/*
		if( $("enablexpicEle").checked == true )
		{
			$("enablexpicEle").checked = false;
			$("enablexpicEle").onclick();
		}*/
		adjustCellWidth();
		
		HopTookit.setFocusOnElement(document.body);
		parent.buttonStruct.applyButton.disabled = false;
		
		_this.filterIF1Plus1ProtectionBoardInner_select1Plus1();
		
		_this.showIF1Plus1ConfigurationPannel(true);
		var event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_CREATEPROTECTIONCHANGE_EVENT);
		_this.notifyAll(event);
	}
	
	/**
	 *   WorkMode                
	 */
	this.doBusinessIf_WorkModeEleChanged = function()
	{
		_this.setIFComponentsDisabledViaBusiness();
		HopTookit.processCellOnchange(protectionCache["workmodeEle"]);
		
		_this.filterIF1Plus1ProtectionBoardInner_selectMode();
		
	    var event = _this.createBasicParamIF1Plus1ChangeEvent(EVENT_TYPE.IF1PLUS1_MODECHANGE_EVENT);
		_this.notifyAll(event);
	}
	
	/**
	 *   XPIC Enable  check box     
	 */
	this.responseXpicEnableEvent = function(event)
	{
		var enableStatus = event.getXPICStatus();
		
		$("if1plus1").disabled = enableStatus;
		/*
		if( enableStatus == true )
		{
			if( $("if1plus1").checked == true )
			{
				$("if1plus0").checked = true;
				$("if1plus0").onclick();		//       onclick
			}
			$("if1plus1").disabled = true;
		}
		else
		{
			$("if1plus1").disabled = false;
		}*/

		_this.showLinkIDTr( !enableStatus );
	}

	this.showBasicParamField = function()
	{
		var advStyle = $('basicParamField').style.display;
		
		_this.showBasicParamFieldWithoutSendingEvent(advStyle);
		
		HopTookit.sendUnionFoldEvent(terminalType, "arrowImg_basic", _this, advStyle);
	}
	
	this.showBasicParamFieldWithoutSendingEvent = function(advStyle)
	{
		$("basicParamField").style.display = advStyle == "none" ? "" : "none";
		$("arrowImg_basic").src = advStyle == "" ? "../../../../images/right.gif" : "../../../../images/down.gif";
	}
}




/**
 *                  
 */
BasicParamModule.prototype.clearBasicParamFieldBgColor = function()
{
	$("if1plus0").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
	$("if1plus1").style.backgroundColor = CELL_ORIGINAL_BGCOLOR;
	$("workmodeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("workboardEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("protectboardEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("rModeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("wtrTimeEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
	$("switchEnableEle").style.backgroundColor = CELL_ORIGINAL_EDIT_BGCOLOR;
}

/**
 *              
 * @return
 */
BasicParamModule.prototype.showAdvContentTr = function(advStyle)
{
	$("advanceContentTR").style.display = advStyle == "" ? "none" : "";
	
	$("advArrowImg").src = advStyle == "" ? "../../../../images/right.gif" : "../../../../images/down.gif";
}

/**
 *     LinkID  Real Link ID  TR
 */
BasicParamModule.prototype.showLinkIDTr = function(advStyle)
{
	$("protect_linkidTR").style.display = advStyle == true ? "" : "none";
}


/**
 *      
 */
BasicParamModule.prototype.filterIF1Plus1ProtectionBoardAfterQuery = function()
{
	var oriWorkSlotId = $("workboardEle").value;
	var oriProtSlotId = $("protectboardEle").value;
	
	$("workboardEle").options.length = 0;
	$("protectboardEle").options.length = 0;

	var ifoduInfoArr = g_commonData.getIFODUInforArray();
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	for( var i = 0; i < ifoduInfoArr.length; i++ )
	{
		var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
		
		if( $("workmodeEle").value == wModeStru.HSBVal )	//   HSB
		{
			if( oriWorkSlotId == ifSlotId )				//            
			{
				HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				if( ifSlotId != tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				}
			}
			else														//            
			{
				if( ifSlotId != tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				}
				HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());				
			}
		}
		else	//   SD FD
		{
			if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() ||
				HopTookit.getPairingBoard(ifSlotId) == tmpIFODUBoardInfoStruct.getIFSlotId() )	
			{
				HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				
				if( oriProtSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				}
			}
		}
	}
	
	protectionCache["workboardEle"].updateCacheValueToElementValue();
	protectionCache["workboardEle"].updateElementBgColor();
	
	protectionCache["protectboardEle"].updateCacheValueToElementValue();
	protectionCache["protectboardEle"].updateElementBgColor();
}


BasicParamModule.prototype.filterIF1Plus1ProtectionBoardInner_select1Plus1 = function()
{
	if( protectionCache["protectionEle"] == true )
	{
		return;
	}
	
	$("workboardEle").options.length = 0;
	$("protectboardEle").options.length = 0;

	var ifoduInfoArr = g_commonData.getIFODUInforArray();
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	for( var i = 0; i < ifoduInfoArr.length; i++ )
	{
		var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
		
		if( $("workmodeEle").value == wModeStru.HSBVal || $("workmodeEle").value == "" )	//   HSB
		{
			HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());

			if( ifSlotId != tmpIFODUBoardInfoStruct.getIFSlotId() )
			{
				HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				if( HopTookit.getPairingBoard(ifSlotId) == tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					protectionCache["protectboardEle"].setElementValue( tmpIFODUBoardInfoStruct.getIFSlotId() );
					protectionCache["protectboardEle"].updateElementBgColor();
				}
			}
		}
		else	//   SD FD
		{
			if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() ||
				HopTookit.getPairingBoard(ifSlotId) == tmpIFODUBoardInfoStruct.getIFSlotId() )	
			{
				HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				
				if( HopTookit.getPairingBoard(ifSlotId) == tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
					protectionCache["protectboardEle"].setElementValue( tmpIFODUBoardInfoStruct.getIFSlotId() );
					protectionCache["protectboardEle"].updateElementBgColor();
				}
			}	
		}
	}
	
	protectionCache["workboardEle"].setElementValue(ifSlotId);
	protectionCache["workboardEle"].updateElementBgColor();
	
	if( $("protectboardEle").options.length == 0 )
	{
		
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() )
			{
				HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				protectionCache["protectboardEle"].setElementValue(tmpIFODUBoardInfoStruct.getIFSlotId());
				protectionCache["protectboardEle"].updateElementBgColor();				
			}
		}
	}

}

/**
 *        1+1    
 */
BasicParamModule.prototype.filterIF1Plus1ProtectionBoardInner_selectMode = function()
{
	$("workboardEle").options.length = 0;
	$("protectboardEle").options.length = 0;

	var ifoduInfoArr = g_commonData.getIFODUInforArray();
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	for( var i = 0; i < ifoduInfoArr.length; i++ )
	{
		var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];

		if( $("workmodeEle").value == wModeStru.HSBVal || $("workmodeEle").value == "" )	//   HSB
		{
			HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
			
			if( ifSlotId != tmpIFODUBoardInfoStruct.getIFSlotId() )
			{
				HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				if( HopTookit.getPairingBoard(ifSlotId) == tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					protectionCache["protectboardEle"].setElementValue( tmpIFODUBoardInfoStruct.getIFSlotId() );
					protectionCache["protectboardEle"].updateElementBgColor();
				}
			}
		}
		else																				//   SD FD
		{
			if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() ||
				HopTookit.getPairingBoard(ifSlotId) == tmpIFODUBoardInfoStruct.getIFSlotId() )	//                    
			{
				HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				
				if( HopTookit.getPairingBoard(ifSlotId) == tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());

					protectionCache["protectboardEle"].setElementValue( tmpIFODUBoardInfoStruct.getIFSlotId() );
					protectionCache["protectboardEle"].updateElementBgColor();
				}
			}
		}
	}
	
	protectionCache["workboardEle"].setElementValue(ifSlotId);
	protectionCache["workboardEle"].updateElementBgColor();
	
	if( $("protectboardEle").options.length == 0 )
	{
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() )
			{
				HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				protectionCache["protectboardEle"].setElementValue(tmpIFODUBoardInfoStruct.getIFSlotId());
				protectionCache["protectboardEle"].updateElementBgColor();
				break;
			}
		}
	}
	else
	{
		if( $("protectboardEle").value == "" )
		{
			protectionCache["protectboardEle"].setElementValue( $("protectboardEle").options[0].value );
			protectionCache["protectboardEle"].updateElementBgColor();
		}
	}
}

/**
 * 
 */
BasicParamModule.prototype.setProtecttionBoardWhenChangeWorkBoard = function()
{
	var destValue = $("workboardEle").value;
	var ifSlotId = HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value);
	if( $("workboardEle").value == ifSlotId )
	{
		$("workboardEle").options.length = 0;
		$("protectboardEle").options.length = 0;

		var ifoduInfoArr = g_commonData.getIFODUInforArray();
		
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			
			if( $("workmodeEle").value == wModeStru.HSBVal )	//   HSB
			{
				HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				
				if( ifSlotId != tmpIFODUBoardInfoStruct.getIFSlotId() )
				{
					HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
					
					if( HopTookit.isPairingBoard(ifSlotId, tmpIFODUBoardInfoStruct.getIFSlotId()) )
					{
						protectionCache["protectboardEle"].setElementValue(tmpIFODUBoardInfoStruct.getIFSlotId());
						protectionCache["protectboardEle"].updateElementBgColor();
					}
					
					if( i == ifoduInfoArr.length - 1 && $("protectboardEle").value == "" )
					{
						protectionCache["protectboardEle"].setElementValue( ifoduInfoArr[0].getIFSlotId() );
						protectionCache["protectboardEle"].updateElementBgColor();
					}
				}
			}
			else	//   SD FD
			{
				if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() ||
						HopTookit.isPairingBoard(ifSlotId, tmpIFODUBoardInfoStruct.getIFSlotId()) )
				{
					HopTookit.addOptionToSelectElement($("workboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
					
					if( ifSlotId != tmpIFODUBoardInfoStruct.getIFSlotId() )
					{
						HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
						
						protectionCache["protectboardEle"].setElementValue(tmpIFODUBoardInfoStruct.getIFSlotId());
						protectionCache["protectboardEle"].updateElementBgColor();
					}
				}
			}
		}

		protectionCache["workboardEle"].setElementValue(destValue);
		protectionCache["workboardEle"].updateElementBgColor();
	}
	else
	{
		$("protectboardEle").options.length = 0;

		var ifoduInfoArr = g_commonData.getIFODUInforArray();
		
		for( var i = 0; i < ifoduInfoArr.length; i++ )
		{
			var tmpIFODUBoardInfoStruct = ifoduInfoArr[i];
			
			if( ifSlotId == tmpIFODUBoardInfoStruct.getIFSlotId() )
			{
				HopTookit.addOptionToSelectElement($("protectboardEle"), tmpIFODUBoardInfoStruct.getIFBoardDescription(), tmpIFODUBoardInfoStruct.getIFSlotId());
				
				protectionCache["protectboardEle"].setElementValue(tmpIFODUBoardInfoStruct.getIFSlotId());
				protectionCache["protectboardEle"].updateElementBgColor();
			}	
		}
	}	
}



/**
 *                      
 */
function BasicParamIF1Plus1ChangeEvent()
{
	var _this = this;
	
	this.eventType = "";

	this.neid = "-1";
	
	this.groupid = "-1";
	
	this.workMode = "-1";
	
	this.workIFBoardInforStruct = "";
	
	this.protectIFBoardInforStruct = "";
	
	this.bRadio1plus1checked = "";
	
	this.equipSlotId = "-1";
	
	this.initData = function(tNeId,tGroupId, tWorkMode, workIFBoardStruct, protectIFBoardStruct, tEventType, tEquipSlotId) 
	{
		_this.neid = tNeId;
		
		_this.eventType = tEventType;
		
		_this.groupid = tGroupId;
		
		_this.workMode = tWorkMode;
		
		_this.workIFBoardInforStruct = workIFBoardStruct;
		
		_this.protectIFBoardInforStruct = protectIFBoardStruct;
		
		_this.bRadio1plus1checked = $("if1plus1").checked == true ? true : false;
		
		_this.equipSlotId = tEquipSlotId;
	}
	
	this.getEventType = function()
	{
		return _this.eventType;
	}
	
	this.getNeId = function()
	{
		return _this.neid;
	}
	
	this.getGroupId = function()
	{
		return _this.groupid;
	}
	
	this.getWorkMode = function()
	{
		return _this.workMode;
	}
	
	this.getWorkBoardInforStruct = function()
	{
		return _this.workIFBoardInforStruct;
	}
	
	this.getProtectBoardInforStruct = function()
	{
		return _this.protectIFBoardInforStruct;
	}
	
	this.isRadio1plus1checked = function()
	{
		return _this.bRadio1plus1checked;
	}
	
	this.getEquipSlotId = function()
	{
		return _this.equipSlotId;
	}
}
/**
 **IF1     XPIC     XPIC  checkbox
 **/
BasicParamModule.prototype.filterUnsupportAttrByBoard = function()
{
	var ifoduboardValue = $("ifoduboardEle").value;
	var eleCurValue2Obj = HopTookit.getIfoduModuleObj(ifoduboardValue);
	var baordType = eleCurValue2Obj.ifBdType;
		
	var isSupportXPIC = HopTookit.isBoardSupportXPIC(neid, eleCurValue2Obj.ifSlotId, baordType);
	/*
    var boardName = g_commonData.getIFBoardName(HopTookit.getIfoduModuleSlotId($("ifoduboardEle").value));
    var IF1 = 'IF1';
    var IFU2 = 'IFU2';
    if(IF1 == boardName || IFU2 == boardName)
    	*/
    if(isSupportXPIC)	
    {
        $("enablexpicTR").style.display = '';
    }
    else
    {
        $("enablexpicTR").style.display = 'none';
    } 
}
