var INVALID_GROUP = "-1";

var INVALID_VALUE = "-1";

var INVALID_ALARM = "0";

var CELL_ALARMEXIST_BGCOLOR = "#ff1919";
var CELL_ALARMNOTEXIST_BGCOLOR = "#8ce78c";

var wModeStru = new Object();
wModeStru.SD = "SD";
wModeStru.FD = "FD";
wModeStru.HSB = "HSB";
wModeStru.SDVal = "0";
wModeStru.FDVal = "1";
wModeStru.HSBVal = "2";

var PhyBoardColor = "#64DC8C";
var LogicBoardColor = "#B4BEFF";

var REALLINE_IMAGE = "../../../../images/hop_line.jpg";
var BORKENLINE_IMAGE = "../../../../images/hop_line.jpg";//hop_line2
var BORKENLINE_IMAGE_STANDBY = "../../../../images/hop_line_standby.jpg";
var REALLINE_IMAGE_ACTIVE = "../../../../images/hop_line_active.jpg";

/**
 *          ,     
 */
function queryLinkBoard(neid, slotid,nmUser)
{
    var xmlstr = createQueryBoardXML(neid, slotid);
    var protection = new Object();
    protection.neid = neid;
    protection.wifslotid = slotid;
	protection.nmUser = nmUser;
    var urlreq = getRootPath(neid) + "/neExlorerServlet?sfid=" + TECMDCODE_QUERY_LINKALARM_BOARD + "&nmUser=" + nmUser;
    loadXMLdoc(urlreq, "POST", true, queryBoardCallback, [protection], "inputdata=" + xmlstr);
}

/**
 *          XML
 * @param neid   ID
 * @param slotid   ID
 */
function createQueryBoardXML(/*String*/neid,/*String*/slotid)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "port");
    param.setAttribute("value", "1");
    row.appendChild(param);
	
	param = new tagElement("param");
    param.setAttribute("name", "isNoAlarm");
    param.setAttribute("value", "true");
    row.appendChild(param);
	
	param = new tagElement("param");
    param.setAttribute("name", "isNoODU");
    param.setAttribute("value", "true");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isLogFlag");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *          
 * @param doc       XML  
 * @param params     ,         
 */
function queryBoardCallback(/*DOMXML*/doc,/*Array*/ params)
{
    var data = EncapsulateData(doc);
    var protection = params[0];
    if (data.getDataRowLength() > 0 && data.getDataRowParam(0, "wifslotid") != null) 
    {
    	protection.neip = data.getDataRowParam(0, "neip");
    	protection.nename = data.getDataRowParam(0, "nename");
    	protection.realneid = data.getDataRowParam(0, "realneid");
        protection.groupid = data.getDataRowParam(0, "groupid");
        protection.grouptype = data.getDataRowParam(0, "grouptype");
        protection.wifslotid = data.getDataRowParam(0, "wifslotid");
        protection.wifboardtype = data.getDataRowParam(0, "wifboardtype");
        protection.wifboardname = data.getDataRowParam(0, "wifboardname");
        protection.wifboardstate = data.getDataRowParam(0, "wifboardstate");
        protection.wifalarmlevel = data.getDataRowParam(0, "wifalarmlevel");
        protection.woduslotid = data.getDataRowParam(0, "woduslotid");
        protection.woduboardtype = data.getDataRowParam(0, "woduboardtype");
        protection.woduboardname = data.getDataRowParam(0, "woduboardname");
        protection.woduboardstate = data.getDataRowParam(0, "woduboardstate");
        protection.wodualarmlevel = data.getDataRowParam(0, "wodualarmlevel");
        protection.wodumute = data.getDataRowParam(0, "wodumute");
        protection.wodutsl = data.getDataRowParam(0, "wodutsl");
        protection.wodursl = data.getDataRowParam(0, "wodursl");
        if (protection.groupid != INVALID_GROUP) 
        {
            protection.pifslotid = data.getDataRowParam(0, "pifslotid");
            protection.pifboardtype = data.getDataRowParam(0, "pifboardtype");
            protection.pifboardname = data.getDataRowParam(0, "pifboardname");
            protection.pifboardstate = data.getDataRowParam(0, "pifboardstate");
            protection.pifalarmlevel = data.getDataRowParam(0, "pifalarmlevel");
            protection.poduslotid = data.getDataRowParam(0, "poduslotid");
            protection.poduboardtype = data.getDataRowParam(0, "poduboardtype");
            protection.poduboardname = data.getDataRowParam(0, "poduboardname");
            protection.poduboardstate = data.getDataRowParam(0, "poduboardstate");
            protection.podualarmlevel = data.getDataRowParam(0, "podualarmlevel");
            protection.podumute = data.getDataRowParam(0, "podumute");
        }
        refreshProtection(protection);
    }
	if (data.getSErrorCode() == 0) 
	{
		if ($("oppositeurl")) 
		{
			$("oppositeurl").disabled = false;
			$("oppositeurl").onclick = openOppositeNeExplorer;
		}
	}
	else 
	{
		if (data.getSErrorCode() == 1090646019) 
		{
			$("tableContainer").style.display = "none";
			$("localEndTerminalNameTag").innerText = RESOURCE["nocontactwithoppositeend"];
			return;
		}
		if ($("oppositeurl")) 
		{
			$("oppositeurl").disabled = true;
			$("oppositeurl").onclick = null;
		}
	}
    showErrorDialog(data);
}

/**
 *       
 *               
 */
function showErrorDialog(/*Object*/data)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", data.getError(), errArr); 
}

/**
 *                  
 * @param protection        
 */
function refreshProtection(/*Object*/protection)
{
    $("workifline1").src = REALLINE_IMAGE;
    $("workifline2").src = REALLINE_IMAGE;
    $("protectifline1").src = REALLINE_IMAGE;
    $("protectifline2").src = REALLINE_IMAGE;
    setNEName($("localEndTerminalNameTag"),protection.nename);

	$("neIDinfor").innerText = "NE ID:" + getExtendID(protection.realneid) + "-" + getBaseNeid(protection.realneid);
	
	$("neIPinfor").innerText = "IP:" + protection.neip;
    if (protection.groupid == INVALID_GROUP) 
    {
        refreshWhenNoGroupExist(protection);
    }
    else //                
     {
        refreshWhenGroupExist(protection);
    }
}

function refreshWhenNoGroupExist(protection)
{
    $("protectgraphTR").style.display = "none";
    $("workmodegraph").style.display = "none";
    $("verticalline").style.display = "none";
    
    var tmpIFVlaue = protection.wifslotid;
    var tmpODUValue = protection.woduslotid;
    
    $("workifslotspan").innerText = tmpIFVlaue + "-" + protection.wifboardname;
    $("workoduslotspan").innerText = tmpODUValue + "-" + protection.woduboardname;
    if (tmpIFVlaue == tmpODUValue) 
    {
        $("workoduslotspan").style.display = "none";
    }
    
    $("workifline1").src = REALLINE_IMAGE;
    $("workifline2").src = REALLINE_IMAGE;
	
	var obj = new Object();
	obj.ifslotid = tmpIFVlaue;
	obj.ifspan = "workifslotspan";
	refreshLOFAlarm(protection.neid,obj,protection.nmUser);
}

function refreshWhenGroupExist(protection)
{
    $("protectgraphTR").style.display = "";
    $("workmodegraph").style.display = "";
    $("verticalline").style.display = "";
    
    var tmpmode = protection.grouptype;
    if (tmpmode == wModeStru.SDVal) 
    {
        $("ifprotectiontype").src = "../../../../images/sd.jpg";
    }
    if (tmpmode == wModeStru.FDVal) 
    {
        $("ifprotectiontype").src = "../../../../images/fd.jpg";
    }
    if (tmpmode == wModeStru.HSBVal) 
    {
        $("ifprotectiontype").src = "../../../../images/hsb.jpg";
    }
    $("oduimgTD").rowSpan = 2;
    
    var workIFVlaue = protection.wifslotid;
    var workODUValue = protection.woduslotid;
    $("workifslotspan").innerText = workIFVlaue + "-" + protection.wifboardname;
    $("workoduslotspan").innerText = workODUValue + "-" + protection.woduboardname;
    
    var protectIFVlaue = protection.pifslotid;
    var protectODUValue = protection.poduslotid;
    $("protectifslotspan").innerText = protectIFVlaue + "-" + protection.pifboardname;
    $("protectoduslotspan").innerText = protectODUValue + "-" + protection.poduboardname;
	
	$("workifline1").src= REALLINE_IMAGE_ACTIVE;
	$("workifline2").src = REALLINE_IMAGE;
	$("protectifline1").src = BORKENLINE_IMAGE_STANDBY;
	$("protectifline2").src = BORKENLINE_IMAGE;
	
	var objWork = new Object();
	objWork.ifslotid = workIFVlaue;
	objWork.ifspan = "workifslotspan";
	
	var objProtect = new Object();
	objProtect.ifslotid = protectIFVlaue;
	objProtect.ifspan = "protectifslotspan";
	
	refreshLOFAlarm(protection.neid,objWork,protection.nmUser);
	
	refreshLOFAlarm(protection.neid,objProtect,protection.nmUser);
}
function refreshLOFAlarm(_neid,obj,nmUser)
{
    var xmlstr = createQueryXML(_neid,obj.ifslotid);
    loadXMLdoc(getRootPath(_neid) + "/neExlorerServlet?sfid=" + TECMDCODE_HOP_QUERY_ALARM + "&nmUser=" + nmUser, "POST", true, refreshAlarmColor, obj, "inputdata=" + xmlstr);
}
	
function createQueryXML(_neid,_slotid)
{
    var root = new inputxml("datainterface");
    
    firstlevel = new tagElement("bussiness-params");    
    secondlevel = new tagElement("row-params");
    var thirdlevel = null;
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","neid");
    thirdlevel.setAttribute("value",_neid);
    secondlevel.appendChild(thirdlevel);

    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name","slotid");
    thirdlevel.setAttribute("value",_slotid);
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);

    return root.toString();
}

function refreshAlarmColor(doc, param)
{
	var data = EncapsulateData(doc);
	
	if( !data.isAllSuccess())
    {
    	return;
    }
    else
    {
    	var dataLength = data.getDataRowLength();
    	
    	if( dataLength == 0 )	//              
    	{
    		$(param.ifspan).parentNode.style.backgroundColor = CELL_ALARMNOTEXIST_BGCOLOR;
    	}
    	else
    	{
    		var isAlarmExistFlag = data.getDataRowParam(0, "isAlarmExist");
    		$(param.ifspan).style.backgroundColor = isAlarmExistFlag == "1" ? CELL_ALARMEXIST_BGCOLOR : CELL_ALARMNOTEXIST_BGCOLOR;
    	}
    }
}

/**
 *       ,                
 *    1024*768        
 * @param elm          
 * @param nename     
 */
function setNEName(elm, nename)
{
    elm.title = nename;
    if (nename.length > 25) 
    {
        nename = nename.substring(0, 22) + "...";
    }
    elm.innerHTML = nename;
}
