var neobject = getNeProperty(self);

var srcneid = neobject.neid;
var nmUser = neobject.nmUser;
var srcslotid = neobject.linkslotid; //       ID

var snkneid = neobject.snkneid;
var snkslotid = neobject.snklinkslotid;

var INVALID_GROUP = "-1";

var INVALID_VALUE = "-1";

var INVALID_ALARM = "0";

var CapacityUnit = "Mbit/s";

var PhyBoardColor = "#64DC8C";
var LogicBoardColor = "#B4BEFF";

var VALID = "/";

var SENDPOWER = "TSL";
var RECEIVEPOWER = "RSL";

var Link_ErrorList = [];

var srcProtection = null;
var snkProtection = null;
var firstQueryFlag = true;
var OTHER_HEIGHT = 410;

var srcst;
var snkst;

var IntervalObject = null;
var IntervalTime = 5000;

if( neobject.sysStatus != "independent" )
{
	IntervalTime = 30000;
}

var QueryStepIndex = 0;
var QueryPeriod = 3;

/**
 *      
 */
function init()
{
	initTitle();
	initTable();
	$("autuRefresh").disabled = true;
	queryBoardInterval();
	IntervalObject = window.setInterval(queryBoardInterval,IntervalTime);
	EventUtil.addEventHandler(window, "resize", windowOnResizeTableHandle);
}

/**
 *          
 */
function queryBoardInterval()
{
	if(QueryStepIndex == 0)
	{
		querySrcBoard(true);
	}
}

function initTitle()
{
	setSpanTitle("nename");
	setSpanTitle("xpic");
	setSpanTitle("atpc");
	if(neobject.neType ==115)
	{
	    $("srcam_title").innerHTML = RESOURCE["amac"];
	    $("snkam_title").innerHTML = RESOURCE["amac"];
	}
	else 
	{
	    $("srcam_title").innerHTML = RESOURCE["am"];
	    $("snkam_title").innerHTML = RESOURCE["am"];
	}
	setSpanTitle("e1pri");
	setSpanTitle("fulle1cap");
	setSpanTitle("ifcband");
	setSpanTitle("modulation");
	setSpanTitle("capacity");
	setSpanTitle("datesband");
	setSpanTitle("loopback");
	$("refreshBtn").value = RESOURCE["refresh"];
	if(neobject.neType ==115 || neobject.neType == 92)
	{
	   $("alarmtitle").innerHTML = RESOURCE["alarmtitle2"];
	}
	else
	{
	   $("alarmtitle").innerHTML = RESOURCE["alarmtitle"];
	}
	$("srcDetailLink").innerHTML = RESOURCE["detailtitle"];
	$("snkDetailLink").innerHTML = RESOURCE["detailtitle"];
	$("autorefresh").innerHTML = RESOURCE["autorefresh"];
	$("srcwifstate").innerHTML = RESOURCE["ifactive"];
	$("srcpifstate").innerHTML = RESOURCE["ifstandby"];
	$("snkwifstate").innerHTML = RESOURCE["ifactive"];
	$("snkpifstate").innerHTML = RESOURCE["ifstandby"];
	$("selIntervalTime").options[0] = new Option("5" + RESOURCE["second"],"5000");
	$("selIntervalTime").options[1] = new Option("15" + RESOURCE["second"],"15000");
	$("selIntervalTime").options[2] = new Option("30" + RESOURCE["second"],"30000");
	$("selIntervalTime").options[3] = new Option("60" + RESOURCE["second"],"60000");
	if( neobject.sysStatus != "independent" )
	{
		$("selIntervalTime").value = ""+IntervalTime;
	}
}

/**
 *   span 
 * @param domid      ,               
 */
function setSpanTitle(/*String*/domid)
{
    var srcdom = $("src" + domid + "_title");
    if(srcdom)
    {
    	srcdom.innerHTML = RESOURCE[domid];
    }
    var snkdom = $("snk" + domid + "_title");
    if(snkdom)
    {
    	snkdom.innerHTML = RESOURCE[domid];
    }
}

/**
 *        
 */
function initTable()
{
	srcst = new SortTable();
	srcst.isUsedForSelectList = true;
    srcst.setImage("../../../../images/");  
    createTableHead(srcst, window.tableconf[0]);
    var height = document.body.clientHeight - OTHER_HEIGHT;
    height = height < 85?85:height;
    srcst.setBodyHeight(height);
    $("salmtablecontainer").appendChild(srcst.getTable());
    
    snkst = new SortTable();
    snkst.isUsedForSelectList = true;
    snkst.setImage("../../../../images/");  
    createTableHead(snkst, window.tableconf[0]);
    snkst.setBodyHeight(height);
    $("nalmtablecontainer").appendChild(snkst.getTable());
}


/**
 *          ,       /   /   
 */
function queryBoard()
{
	if(QueryStepIndex == 0)
	{
		$("refreshBtn").disabled = true;
		$("autuRefresh").disabled = true;
		$("selIntervalTime").disabled = true;

		querySrcBoard(false);
	}
	else
	{
		alert(RESOURCE["querynotend"]);
	}
}

/**
 *           ,     
 * @param bInterval       
 */
function querySrcBoard(/*boolean*/bInterval)
{
	QueryStepIndex++;
	var xmlstr = createQueryBoardXML(srcneid,srcslotid,bInterval);
	var protection = new Object();
	protection.neid = srcneid;
	protection.wifslotid = srcslotid;
	var urlreq = getRootPath(srcneid) + "/neExlorerServlet?sfid=" + TECMDCODE_QUERY_LINKALARM_BOARD + "&nmUser=" + nmUser;
	loadXMLdoc(urlreq, "POST", true, queryBoardCallback, ["src",protection,bInterval], "inputdata=" + xmlstr);
}

/**
 *           ,     
 * @param bInterval       
 */
function querySnkBoard(/*boolean*/bInterval)
{
	if(snkneid == "null")
	{
		$("snkBoardTitle").style.display = "";
		$("snkBoardTitle").innerHTML = RESOURCE["nocontactwithoppositeend"];
		return;
	}
	$("snkBoardTitle").style.display = "none";
	QueryStepIndex++;
	var xmlstr = createQueryBoardXML(snkneid,snkslotid,bInterval);
	var protection = new Object();
	protection.neid = snkneid;
	protection.wifslotid = snkslotid;
	var urlreq = getRootPath(snkneid) + "/neExlorerServlet?sfid=" + TECMDCODE_QUERY_LINKALARM_BOARD + "&nmUser=" + nmUser;
	loadXMLdoc(urlreq, "POST", true, queryBoardCallback, ["snk",protection,bInterval], "inputdata=" + xmlstr);
}


/**
 *          XML
 * @param neid   ID
 * @param slotid   ID
 * @param bInterval       
 */
function createQueryBoardXML(/*String*/neid,/*String*/slotid,/*boolean*/bInterval)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    param = new tagElement("param");
	param.setAttribute("name","port");
    param.setAttribute("value","1");
    row.appendChild(param);
    
    if(bInterval == true && firstQueryFlag == false)
    {
	    param = new tagElement("param");
		param.setAttribute("name","isLogFlag");
	    param.setAttribute("value","0");
	    row.appendChild(param);
    }

	bussiness.appendChild(row);
	
	di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *          
 * @param doc       XML  
 * @param params     ,         
 */
function queryBoardCallback(/*DOMXML*/doc,/*Array*/params)
{
	var data = EncapsulateData(doc);
	var protection = params[1];
	if(data.getDataRowLength() > 0 && data.getDataRowParam(0, "wifslotid") != null)
	{
		protection.groupid = data.getDataRowParam(0, "groupid");
		protection.grouptype = data.getDataRowParam(0, "grouptype");
		protection.wifslotid = data.getDataRowParam(0, "wifslotid");
		protection.wifboardtype = data.getDataRowParam(0, "wifboardtype");
		protection.wifboardname = data.getDataRowParam(0, "wifboardname");
		protection.wifboardstate = data.getDataRowParam(0, "wifboardstate");
		protection.wifalarmlevel = data.getDataRowParam(0, "wifalarmlevel");
		protection.woduslotid = data.getDataRowParam(0, "woduslotid");
		protection.woduboardtype = data.getDataRowParam(0, "woduboardtype");
		protection.woduboardname = data.getDataRowParam(0, "woduboardname");
		protection.woduboardstate = data.getDataRowParam(0, "woduboardstate");
		protection.wodualarmlevel = data.getDataRowParam(0, "wodualarmlevel");
		protection.wodumute = data.getDataRowParam(0, "wodumute");
		protection.wodutsl = data.getDataRowParam(0, "wodutsl");
		protection.wodursl = data.getDataRowParam(0, "wodursl");
		if(protection.groupid != INVALID_GROUP)
		{
			protection.pifslotid = data.getDataRowParam(0, "pifslotid");
			protection.pifboardtype = data.getDataRowParam(0, "pifboardtype");
			protection.pifboardname = data.getDataRowParam(0, "pifboardname");
			protection.pifboardstate = data.getDataRowParam(0, "pifboardstate");
			protection.pifalarmlevel = data.getDataRowParam(0, "pifalarmlevel");
			protection.poduslotid = data.getDataRowParam(0, "poduslotid");
			protection.poduboardtype = data.getDataRowParam(0, "poduboardtype");
			protection.poduboardname = data.getDataRowParam(0, "poduboardname");
			protection.poduboardstate = data.getDataRowParam(0, "poduboardstate");
			protection.podualarmlevel = data.getDataRowParam(0, "podualarmlevel");
			protection.podumute = data.getDataRowParam(0, "podumute");
		}
		eval(params[0] + "Protection = protection;");
		
		refreshProtection(params[0],protection);
	}
	if (data.getSErrorCode() == 1090646019) 
	{
		$(params[0] + "BoardTitle").style.display = "";
		$(params[0] + "BoardTitle").innerHTML = RESOURCE["nocontactwithoppositeend"];
		return;
	}
	handleQueryEnd(data,params[2]);
	queryParams(params[0],protection,params[2]);
	$(params[0] + "BoardTitle").style.display = "none";
	$(params[0] + "BoardTitle").innerHTML = "";
}

/**
 *                  
 * @param profix         src  snk
 * @param protection        
 */
function refreshProtection(/*String*/profix,/*Object*/protection)
{
	$(profix + "wcontainer").style.display = "";
	$(profix + "wiftext").innerHTML = protection.wifslotid + "-" + protection.wifboardname;
	setBoardColor($(profix + "wiftext").parentNode,protection.wifalarmlevel,protection.wifboardstate);
	if(protection.wifslotid != protection.woduslotid)
	{
		$(profix + "wodutext").innerHTML = protection.woduslotid + "-" + protection.woduboardname;
	}
	else
	{
		if (isIE) 
		{
			$(profix + "wodursltext").style.fontSize = "11px";
			$(profix + "wodursltext").style.lineHeight = "10px";
			$(profix + "wodursltext").style.top = "-8px";
			$(profix + "wodutsltext").style.fontSize = "11px";
			$(profix + "wodutsltext").style.lineHeight = "10px";
			$(profix + "wodutsltext").style.top = "-8px";
		}else{
			$(profix + "wodursltext").style.fontSize = "11px";
			$(profix + "wodursltext").style.lineHeight = "10px";
			$(profix + "wodursltext").style.top = "0px";
			$(profix + "wodutsltext").style.fontSize = "11px";
			$(profix + "wodutsltext").style.lineHeight = "10px";
			$(profix + "wodutsltext").style.top = "0px";
		}	
	}
	setBoardColor($(profix + "wodutext").parentNode,protection.wodualarmlevel,protection.woduboardstate);
	
	if(neobject.neType ==115 || neobject.neType == 92)
	{
	    $(profix + "txstatus1_title").innerHTML = RESOURCE["txstatusnoodu"];
	} 
	else if(protection.wifslotid != protection.woduslotid)
	{
	    $(profix + "txstatus1_title").innerHTML = RESOURCE["txstatus"].replace("ODU",$(profix + "wodutext").innerHTML);
	} else {
	    $(profix + "txstatus1_title").innerHTML = RESOURCE["txstatus"];
	}
	
	$(profix + "txstatus1_tr").style.display = "";
	if(protection.wodumute == INVALID_VALUE)
	{
		$(profix + "txstatus1_value").innerHTML = VALID;
	}
	else
	{
		$(profix + "txstatus1_value").innerHTML = ODUMuteStatus[protection.wodumute];
	}
	if(protection.wodutsl && protection.wodutsl != "")
	{
		$(profix + "wodutsltext").innerHTML = SENDPOWER + " " + protection.wodutsl;
	}
	else
	{
		$(profix + "wodutsltext").innerHTML = SENDPOWER + " " + VALID;
	}
	if(protection.wodursl && protection.wodursl != "")
	{
		$(profix + "wodursltext").innerHTML = RECEIVEPOWER + " " + protection.wodursl;
	}
	else
	{
		$(profix + "wodursltext").innerHTML = RECEIVEPOWER + " " + VALID;
	}

	if(protection.groupid != INVALID_GROUP)
	{
		$(profix + "piftext").innerHTML = protection.pifslotid + "-" + protection.pifboardname;
		setBoardColor($(profix + "piftext").parentNode,protection.pifalarmlevel,protection.pifboardstate);
		if(protection.pifslotid != protection.poduslotid)
		{
			$(profix + "podutext").innerHTML = protection.poduslotid + "-" + protection.poduboardname;
		}
		else
		{
			$(profix + "podursltext").style.fontSize = "11px";
			$(profix + "podursltext").style.lineHeight = "10px";
			$(profix + "podursltext").style.top = "-8px";
			$(profix + "podutsltext").style.fontSize = "11px";
			$(profix + "podutsltext").style.lineHeight = "10px";
			$(profix + "podutsltext").style.top = "-8px";
		}
		setBoardColor($(profix + "podutext").parentNode,protection.podualarmlevel,protection.poduboardstate);
		$(profix + "txstatus2_title").innerHTML = RESOURCE["txstatus"].replace("ODU",$(profix + "podutext").innerHTML);
		if(protection.podumute == INVALID_VALUE)
		{
			$(profix + "txstatus2_value").innerHTML = VALID;
		}
		else
		{
			$(profix + "txstatus2_value").innerHTML = ODUMuteStatus[protection.podumute];
		}
		$(profix + "grouptypecontainer").style.backgroundImage = GroupType[profix + protection.grouptype];
		
		$(profix + "pcontainer").style.display = "";
		$(profix + "wifstate").style.display = "";
		$(profix + "txstatus2_tr").style.display = "";
		$(profix + "grouptypecontainer").style.display = "";
	}
	else
	{
		$(profix + "pcontainer").style.display = "none";
		$(profix + "wifstate").style.display = "none";
		$(profix + "txstatus2_tr").style.display = "none";
		$(profix + "grouptypecontainer").style.display = "none";
	}
}

/**
 *        ,      
 *                    
 * @param boardElm
 * @param alarmlevel
 * @param boardstate     ,true=     false=    
 */
function setBoardColor(/*DOMElement*/boardElm,/*String*/alarmlevel,/*String*/boardstate)
{
	var color = ALARM_COLOR[alarmlevel];
	if(alarmlevel == INVALID_VALUE || alarmlevel == INVALID_ALARM)
	{
		if(boardstate == "true")
		{
			color = PhyBoardColor;
		}
		else
		{
			color = LogicBoardColor;
		}
	}
	boardElm.style.backgroundColor = color;
}

/**
 *        XML
 * @param profix   snk/src
 * @param protection      
 */
function createQueryAlarmXML(/*String*/profix,/*Object*/protection)
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var neid = srcneid;
    if(profix == "snk")
    {
    	neid = snkneid;
    }
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name","slotid");
    param.setAttribute("value",protection.wifslotid);
    row.appendChild(param);

	bussiness.appendChild(row);
	
	if(protection.groupid != INVALID_GROUP)
	{
		row = new tagElement("row-params");
	    
	    var param = new tagElement("param");    
	    param.setAttribute("name","neid");
	    param.setAttribute("value",neid);
	    row.appendChild(param);
		
		param = new tagElement("param");
		param.setAttribute("name","slotid");
	    param.setAttribute("value",protection.pifslotid);
	    row.appendChild(param);
	
		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);
    return di.toString();
}


/**
 *            
 *                       
 *              
 * @param data          
 * @param bInterval       
 */
function handleQueryEnd(/*Object*/data,/*boolean*/bInterval)
{
	if(OPERATION_SUCCESS != data.getSErrorCode()) 
	{
		Link_ErrorList[Link_ErrorList.length] = data;
	}
	if(QueryStepIndex == QueryPeriod)
	{
		querySnkBoard(bInterval);
	}
	else if(QueryStepIndex == 2 * QueryPeriod)
	{
		if(bInterval == false || firstQueryFlag == true)
		{
			if(Link_ErrorList.length > 0)
			{
				var datatemp = null;
				for(var i = 0,len = Link_ErrorList.length;i < len;i++)
				{
					datatemp = Link_ErrorList[i];
					if(data.getSErrorCode() < datatemp.getSErrorCode())
					{
						data.setSErrorCode(datatemp.getSErrorCode());
						data.setSErrorInfo(datatemp.getSErrorInfo());
					}
					data.getError().rowErrors = data.getError().rowErrors.concat(datatemp.getError().rowErrors);
				}
			}
			showErrorDialog(data);
		}
		if($("autuRefresh").checked == false)
		{
			$("refreshBtn").disabled = false;
			$("selIntervalTime").disabled = false;
			$("autuRefresh").disabled = false;
		}
		else
		{
			$("refreshBtn").disabled = true;
			$("selIntervalTime").disabled = true;
			$("autuRefresh").disabled = false;
		}
		firstQueryFlag = false;
		QueryStepIndex = 0;
		Link_ErrorList = [];
	}
	
}

/**
 *       
 * @param profix   ,snk    src
 * @param protection      
 * @param bInterval       
 */
function queryParams(/*String*/profix,/*Object*/protection,/*boolean*/bInterval)
{
	QueryStepIndex++;
	var xmlstr = createQueryBoardXML(protection.neid,protection.wifslotid);
	var urlreq = getRootPath(protection.neid) + "/neExlorerServlet?sfid=" + TECMDCODE_QUERY_LINKALARM_PARAMS + "&nmUser=" + nmUser;
	loadXMLdoc(urlreq, "POST", true, queryParamsCallback, [profix,protection,bInterval], "inputdata=" + xmlstr);
}

/**
 *           ,               
 * @param doc      DOMXML  
 * @param params      ,  ,     ,      
 */
function queryParamsCallback(/*DOMXML*/doc,/*Array*/params)
{
	var data = EncapsulateData(doc);

	if(data.getDataRowLength() > 0)
	{
		var profix = params[0];
		setNEName($(profix + "nename_value"),data.getDataRowParam(0, "nename"));
		var xpic = data.getDataRowParam(0, "W32PORT_ATTR_XPICENABLED");
		$(profix + "xpic_value").innerHTML = EnableStatus[xpic];
		var atpc = data.getDataRowParam(0, "W32PORT_ATTR_ATPC_ENABLE");
		$(profix + "atpc_value").innerHTML = EnableStatus[atpc];
		var amstatus = data.getDataRowParam(0, "W32PORT_ATTR_ACMENABLESTATUS");
		$(profix + "am_value").innerHTML = EnableStatus[amstatus];
		var e1pri = data.getDataRowParam(0, "IFPORT_ATTR_E1STATUS");
		$(profix + "e1pri_value").innerHTML = EnableStatus[e1pri];
		var fulle1cap = data.getDataRowParam(0, "IFPORT_ATTR_ENSUREE1NUM_RANGE");
		$(profix + "fulle1cap_value").innerHTML = fulle1cap;
		var ifcband = data.getDataRowParam(0, "W32PORT_ATTR_CHANNELSPACE");
		$(profix + "ifcband_value").innerHTML = bandwidth[ifcband];
		var ensuremode = data.getDataRowParam(0, "W32PORT_ATTR_ENSURECALMODE");
		var allmode = data.getDataRowParam(0, "W32PORT_ATTR_ALLCALMODE");
		var manualmode = data.getDataRowParam(0, "W32PORT_ATTR_MANUALMODE");
		var showmode = ModulationMode[ensuremode] + "-" + ModulationMode[allmode];
		if(amstatus == DISABLED_STATUS)
		{
			showmode = ModulationMode[manualmode];
			$(profix + "fulle1cap_value").innerHTML = "-";
		}
		$(profix + "modulation_value").innerHTML = showmode;
		var capacity = data.getDataRowParam(0, "capacity");
		capacity = getCapacity(capacity,ifcband,amstatus,ensuremode,allmode,manualmode);
		$(profix + "capacity_value").innerHTML = capacity + CapacityUnit;
		var datesband = data.getDataRowParam(0, "ethband");
		$(profix + "datesband_value").innerHTML = datesband + CapacityUnit;
		var loopback = data.getDataRowParam(0, "W32PORT_ATTR_PORTLOOPBACK");
		$(profix + "loopback_value").innerHTML = LoopBack[loopback];
		refreshXpic(profix,xpic)
		refreshAtpc(profix,atpc);
		refreshAMStatus(profix,amstatus);
		refreshE1Pri(profix,e1pri,fulle1cap);
		refreshDateband(profix,datesband);
		refreshBandWidth(profix,ifcband);
		refreshCapacity(profix,capacity);
		refreshLoopback(profix,loopback);
		$(profix + "attrcontainer").style.display = "";
	}
	handleQueryEnd(data,params[2]);
	
	queryAlarms(params[0],params[1],params[2]);
}

/**
 *              7M: 1,QPSK,10M% 2,16QAM, 20M% 3,32QAM, 25M% 4,64QAM, 32M% 5,128QAM, 38M% 6,256QAM, 44M;14M: 1,QPSK,10M% 2,16QAM, 20M% 3,32QAM, 25M% 4,64QAM, 32M% 5,128QAM, 38M% 6,256QAM, 44M
 *        ';'               :                                                             %    
 * AM                           
 **/
function getCapacity(/*string*/capacity,/*string*/ifcband,/*string*/amstatus,/*string*/ensuremode,/*string*/allmode,/*string*/manualmode)
{
	var capacityResult = "";
    if(capacity && capacity != "" && amstatus && amstatus != "")
    {
    	var arr1, arr2, arr3;
    	var ensurecapacity="";
    	var allcapacity = "";
	    arr1 = capacity.split(';');
	    for(var i = 0, iLen = arr1.length; i < iLen; i++)
	    {
	    	arr2 = arr1[i].split(':');
	        
	        if(arr1[i].trim().length <= 0)
	        {
	            continue;
	        }
	        
	        if(ifcband == getCapacityBandType(arr2[0].trim()))
	        {
	        	arr2 = arr2[1].trim().split('%');
	        	for(var j = 0, jLen = arr2.length; j < jLen; j++)
	        	{
	            	arr3 = arr2[j].trim().split(',');
	                if(arr3.length < 3)
	                {
	                	continue;
	                }
	            	if(amstatus == DISABLED_STATUS)
			        {
			        	if(manualmode == getCapacityModeType(arr3[1].trim()))
			        	{
				        	ensurecapacity = arr3[2].trim().replace("M","");
				        	break;
			        	}
			        }
			        else
			        {
		            	
		            	if(ensuremode == getCapacityModeType(arr3[1].trim()))
		            	{
		            		ensurecapacity = arr3[2].trim().replace("M","");
		            		continue;
		            	}
		            	if(allmode == getCapacityModeType(arr3[1].trim()))
		            	{
		            		allcapacity = arr3[2].trim().replace("M","");
		            		continue;
		            	}
	            	}
	            }
	            break;
	        }
	    }
	    
	    capacityResult = ensurecapacity
	    if(allcapacity != "")
	    {
	    	capacityResult += "-" + allcapacity;
	    }
    }
    return capacityResult;
}

/**
 *          
 * @param band
 */
function getCapacityBandType(/*string*/band)
{
	var bandtype = 0;
	switch(band)
    {
    	case '3.5M':
    		bandtype = 1;
    		break;
    	case '7M':
    		bandtype = 2;
    		break;
    	case '14M':
    		bandtype = 3;
    		break;
    	case '28M':
    		bandtype = 4;
    		break;
    	case '40M':
    		bandtype = 5;
    		break;
    	case '56M':
    		bandtype = 6;
    		break;
    	case 'FCC30M':
    		bandtype = 9;
    		break;
    	case 'FCC40M':
    		bandtype = 8;
    		break;
    	case 'FCC50M':
    		bandtype = 7;
    		break;
    }
    return bandtype;
}

/**
 *             
 * @param mode
 */
function getCapacityModeType(/*string*/mode)
{
	var modetype = 0;
	switch(mode)
    {
    	case 'QPSK':
    		modetype = 1;
    		break;
    	case '16QAM':
    		modetype = 2;
    		break;
    	case '32QAM':
    		modetype = 3;
    		break;
    	case '64QAM':
    		modetype = 4;
    		break;
    	case '128QAM':
    		modetype = 5;
    		break;
    	case '256QAM':
    		modetype = 6;
    		break;
    }
    return modetype;
}


/**
 *       ,                
 *    1024*768        
 * @param elm          
 * @param nename     
 */
function setNEName(elm,nename)
{
	elm.title = nename;
	if(nename.length > 25)
	{
		nename = nename.substring(0,22) + "...";
	}
	elm.innerHTML = nename;
}

/**
 *   XPIC  ,               
 * @param profix   snk/src
 * @param xpic
 */
function refreshXpic(/*String*/profix,/*String*/xpic)
{
	if(xpic && xpic != "")
	{
		$(profix + "xpic_tr").style.display = "";
	}
	else
	{
		$(profix + "xpic_tr").style.display = "none";
	}
}

/**
 *   ATPC  ,               
 * @param profix   snk/src
 * @param atpc
 */
function refreshAtpc(/*String*/profix,/*String*/atpc)
{
	if(atpc && atpc != "")
	{
		$(profix + "atpc_tr").style.display = "";
	}
	else
	{
		$(profix + "atpc_tr").style.display = "none";
	}
}

/**
 *           ,               
 * @param profix   snk/src
 * @param loopback
 */
function refreshLoopback(/*String*/profix,/*String*/loopback)
{
	if(loopback == INVALID_VALUE)
	{
		$(profix + "loopback_value").innerHTML = VALID;
	}
	if(loopback == null || loopback == "")
	{
		$(profix + "loopback_tr").style.display = "none";
	}
	else
	{
		$(profix + "loopback_tr").style.display = "";
	}
}

/**
 *                    ,       
 * @param profix   snk/src
 * @param e1pri
 */
function refreshBandWidth(/*String*/profix,/*String*/band)
{
	if(band == null || band == "" || band == INVALID_VALUE)
	{
		$(profix + "ifcband_tr").style.display = "none";
		$(profix + "modulation_tr").style.display = "none";
		$(profix + "capacity_tr").style.display = "none";
	}
	else
	{
		$(profix + "ifcband_tr").style.display = "";
		$(profix + "modulation_tr").style.display = "";
		$(profix + "capacity_tr").style.display = "";
	}
}

/**
 *   AM               
 * @param profix   snk/src
 * @param e1pri
 */
function refreshAMStatus(/*String*/profix,/*String*/amstatus)
{
	if(amstatus == null || amstatus == "" || amstatus == INVALID_VALUE)
	{
		$(profix + "am_tr").style.display = "none";
	}
	else
	{
		$(profix + "am_tr").style.display = "";
	}
}

/**
 *   E1   ,  E1               
 * @param profix   snk/src
 * @param e1pri
 */
function refreshE1Pri(/*String*/profix,/*String*/e1pri,/*String*/fulle1pri)
{
	if(e1pri == null || e1pri == "" || e1pri == INVALID_VALUE)
	{
		$(profix + "e1pri_tr").style.display = "none";
		$(profix + "fulle1cap_tr").style.display = "none";
	}
	else
	{
		$(profix + "e1pri_tr").style.display = "";
		$(profix + "fulle1cap_tr").style.display = "";
	}
}
/**
 *         
 * @param profix   snk/src
 * @param dateband
 */
function refreshCapacity(/*String*/profix,/*String*/capacity)
{
	if(capacity == null || capacity == "")
	{
		$(profix + "capacity_tr").style.display = "none";
	}
	else
	{
		$(profix + "capacity_tr").style.display = "";
	}
}
/**
 *         
 * @param profix   snk/src
 * @param dateband
 */
function refreshDateband(/*String*/profix,/*String*/dateband)
{
	if(dateband == null || dateband == "")
	{
		$(profix + "datesband_tr").style.display = "none";
	}
	else
	{
		$(profix + "datesband_tr").style.display = "";
		if(dateband == "0.0")
		{
			$(profix + "datesband_value").innerHTML = "-";
		}
	}
}

/**
 *          
 * @param profix   snk/src
 * @param protection      
 * @param bInterval       
 */
function queryAlarms(/*String*/profix,/*Object*/protection,/*boolean*/bInterval)
{
	QueryStepIndex++;
	var xmlstr = createQueryAlarmXML(profix,protection);
  var neid = srcneid;
  if(profix == "snk")
  {
  	neid = snkneid;
  }

	var urlreq = getRootPath(neid) + "/neExlorerServlet?sfid=" + TECMDCODE_QUERY_LINKALARM_ALARMS + "&nmUser=" + nmUser;
	loadXMLdoc(urlreq, "POST", true, queryAlarmCallback, [profix,bInterval], "inputdata=" + xmlstr);
}

/**
 *          ,                      
 * @param doc      DOMXML  
 * @param params     ,  ,      
 */
function queryAlarmCallback(/*DOMXML*/doc,/*Array*/params)
{
	var data = EncapsulateData(doc);

	eval("createAlarmTableBody(" + params[0] + "st, data)");

	handleQueryEnd(data,params[1]);
}

/**
 *         ,             
 * @param st     
 * @param data         
 */
function createAlarmTableBody(/*Table Object*/st,/*Object*/data)
{
	var lastSelectedAlarm = [];
	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	{
		if (st.getRowSelFlag(i))
		{
			lastSelectedAlarm[lastSelectedAlarm.length] = st.getCellStoreValue(i, "evtSerialNum","evtSerialNum");
		}
	}
	st.clearTableData();
	createTableBody(st, window.tableconf[0], data, RESOURCE);
	for(var j = 0; j < st.getDataRowLength(); j++)
    {
        var storevalue = st.getCellStoreValue(j,"level","level");
        st.getCellElement(j,"alarmLevel").style.backgroundColor = ALARM_COLOR[storevalue];
        st.getCellElement(j,"alarmLevel").childNodes[0].style.color = "#000000";
        if(lastSelectedAlarm.contains(st.getCellStoreValue(j, "evtSerialNum", "evtSerialNum")))
		{
			singleClick(st.getRow(j).element, true);
		}
    }
}

/**
 *       
 *               
 */
function showErrorDialog(/*Object*/data)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", data.getError(), errArr); 
}

/**
 *       
 * @param profix        ,      
 */
function detailAlarm(/*String*/profix)
{
	var URL = "/nemgr/rtn/page/linkalarm/linkalarmdetail.html?";
    for(var obj in neobject)
    {
    	URL += obj + "=";
    	if(profix == "snk" && obj == "neid")
    	{
    		URL += snkneid + "&";
    	}
    	else
    	{
    		URL += neobject[obj] + "&";
    	}
    }
    var protection  = srcProtection;
    if(profix == "snk")
    {
    	protection = snkProtection;
    }
    
	URL += "slotId=" + getSlotStr(protection) + "&sessionid=" + neobject["sessionid"] +"&radiolinkalarm=1";
   var tempNeID = neobject.neid;
		if(profix == "snk")
		{
			tempNeID = snkneid;
		}
	xshowModalDialog(getRootPath(tempNeID) + URL,RESOURCE["alarmbrowse"],800,550,"",true,true);
}

/**
 *         ID   ,     
 */
function getSlotStr(/*Object*/protection)
{
	var str = protection.wifslotid + "," + protection.woduslotid;
	if(protection.groupid != INVALID_GROUP)
	{
		str += "," + protection.pifslotid + "," + protection.poduslotid;
	}
	return str;
}

/**
 *      Onresize  ,              
 */
function windowOnResizeTableHandle()
{
	$("salmtablecontainer").style.width = (document.body.clientWidth - 15) * 0.48;
	$("nalmtablecontainer").style.width = (document.body.clientWidth - 15) * 0.48;
	 var height = document.body.clientHeight - OTHER_HEIGHT;
	height = height < 85?85:height;
    srcst.setBodyHeight(height);
    snkst.setBodyHeight(height);
	for(var i = 0, len = window.sortTableArray.length; i < len; i++)
	{
		var tempst = window.sortTableArray[i][0];
		var temptc = window.sortTableArray[i][1];
		if(typeof(tempst.element.headRow.element.cols) != "undefined"
		    && tempst.element.headRow.element.cols != null)
		{
			adjustTableLayout(tempst,temptc);
		}
	}
}

/**
 *     Checkbox     
 *          ,        
 * @param check     
 */
function autoRefresh(check)
{
	if(check == false)
	{
		if(IntervalObject)
		{
			window.clearInterval(IntervalObject);
			IntervalObject = null;
		}
		$("refreshBtn").disabled = false;
		$("selIntervalTime").disabled = false;
	}
	else
	{
		IntervalObject = window.setInterval(queryBoardInterval,$("selIntervalTime").value);
		$("refreshBtn").disabled = true;
		$("selIntervalTime").disabled = true;
	}
}
