loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/ifoduconfig/ifoduconfig_" + SYSTEMCONF.getLanguage()
		+ ".xml");

var lastselect;

var curboardgp;

var protect = new Object();
protect[0] = "1+1 SD";
protect[1] = "1+1 FD";
protect[2] = "1+1 HSB";

var quipType = [];
quipType[5] = RESOURCE["sdh"];
quipType[10] = RESOURCE["pdh"];

var hlStation = [];
hlStation[5] = RESOURCE["lStation"];
hlStation[10] = RESOURCE["hStation"];

var switchStatus = [];
switchStatus[0] = RESOURCE["notWork"];
switchStatus[1] = RESOURCE["Work"];

var powerGrade = [];
powerGrade[5] = RESOURCE["Standard"];
powerGrade[10] = RESOURCE["High"];

var ODU_INF_FUN_ID = "10290";//ODU         ID                
var neobject = getNeProperty(self);

var boardgrouplist = new Object(); //      /odu     

var btnRightArr = new Object();

var neidvalue = neobject.neid;

var queryInfoInteval = null;

var autoRefresh = true;

var groupLen = 0;

function tabSelectHandler()
{
	querygroup();
}
function querygroup()
{	
	var xmlstr = createQueryXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + get_iduodu_protectgroup
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];	
	loadXMLdoc(urlreq, "POST", true, updateGP, null, "inputdata=" + xmlstr);
}

function updateGP(doc)
{
	var contain = $("contain");
	while (contain.hasChildNodes())
	{
		contain.removeChild(contain.childNodes[0]);
	}
	var data = EncapsulateData(doc);

	var len = data.getDataRowLength();

	if (len <= 0)
	{
    $("applybtn2").disabled = true;
   	$("querybtn2").disabled = true;
		return;
	}
	for (var key in boardgrouplist)
  {
      boardgrouplist[key] = null;
  }
	for ( var i = 0; i < len; i++)
	{
		var wmode = data.getDataRowParam(i, "wMode");
		if (wmode != null)
		{
			var wboard = new boardgroup();

			wboard.ifslotid = data.getDataRowParam(i, "workingSlotId");
			wboard.ifportid = data.getDataRowParam(i,"workingPortId");
			wboard.ifphy = data.getDataRowParam(i, "workifphy");
			wboard.ifname = data.getDataRowParam(i, "workingbdname");
			wboard.oduslotid = data.getDataRowParam(i, "workoduid");
			wboard.oduphy = data.getDataRowParam(i, "workoduphy");
			wboard.protecttype = data.getDataRowParam(i, "wMode");
			wboard.iswork = 1;
			boardgrouplist[wboard.ifslotid + wboard.ifportid + wboard.oduslotid] = wboard;

			var pboard = new boardgroup();

			pboard.ifslotid = data.getDataRowParam(i, "protectionSlotId");
			pboard.ifportid = data.getDataRowParam(i,"protectionPortId");
			pboard.ifphy = data.getDataRowParam(i, "protectifphy");
			pboard.ifname = data.getDataRowParam(i, "protectbdname");
			pboard.oduslotid = data.getDataRowParam(i, "protectoduid");
			pboard.oduphy = data.getDataRowParam(i, "protectoduphy");
			pboard.protecttype = data.getDataRowParam(i, "wMode");

			boardgrouplist[pboard.ifslotid + pboard.ifportid + pboard.oduslotid] = pboard;

			createifprotect(wboard, pboard);
		}
		else
		{
			var wboard = new boardgroup();

			wboard.ifslotid = data.getDataRowParam(i, "workingSlotId");
			wboard.ifportid = data.getDataRowParam(i,"workingPortId");
			wboard.ifphy = data.getDataRowParam(i, "workifphy");
			wboard.ifname = data.getDataRowParam(i, "workingbdname");
			wboard.oduslotid = data.getDataRowParam(i, "workoduid");
			wboard.oduphy = data.getDataRowParam(i, "workoduphy");

			if (wboard.oduslotid == null)
			{
				boardgrouplist[wboard.ifslotid + wboard.ifportid] = wboard;
			}
			else
			{
				boardgrouplist[wboard.ifslotid + wboard.ifportid + wboard.oduslotid] = wboard;
			}

			createif(wboard);
		}
	}
	if(groupLen != len)
  {
  	initIfOduInfo(); 
  }
	hfSetSelState(lastselect);
  groupLen = len;
}

function initIfOduInfo()
{	
	var ifSlot = null;
	var ifport = null;
	if(lastselect != null && lastExist(lastselect))
	{
		ifSlot = lastselect;
	}
	
	if(!ifSlot)
	{
		for (var key in boardgrouplist)
  	{
  		if(!boardgrouplist[key])
  		{
  			continue;
  		}
      ifSlot = boardgrouplist[key].ifslotid;
      ifport = boardgrouplist[key].ifportid;
      lastselect = ifSlot+ "_" +ifport;
  		break;
  	}	
	}

	if (!ifSlot)
	{
		return;
	}

	var ifElement = $("slot" + ifSlot + "_" + ifport);

	boardon(ifSlot + "_" + ifport, ifElement);
	ifElement.style.className = "Cardphylog SelStateOff cardw";
}

function lastExist(id)
{
	for (var key in boardgrouplist)
	{
    if(boardgrouplist[key] && (id == boardgrouplist[key].ifslotid +"_" + boardgrouplist[key].ifportid))
    {
    	return true;
    }
	}
	return false;
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}


function init()
{
	initinput();
	querygroup();
}

function setQueryInfoInterval()
{
	autoRefresh = true;
	if(!queryInfoInteval)
	{
		queryInfoInteval = window.setInterval("queryinfo('true')",6000);
	}
}

function clearQueryInfoInterval()
{
	autoRefresh = false;
	if(queryInfoInteval)
	{
		window.clearInterval(queryInfoInteval);
		queryInfoInteval = null;
	}
}

function setspantx(domid)
{
	var dome = $(domid);
	dome.innerHTML = RESOURCE[domid];
}

function initinput()
{
	$("querybtn2").value = RESOURCE["query"];
	$("applybtn2").value = RESOURCE["apply"];

	btnRightArr.querybtn2 = new BtnRightObj("querybtn2", query_oduif_params);
	btnRightArr.applybtn2 = new BtnRightObj("applybtn2", apply_if_params);
	getRightInfo(neobject, btnRightArr);
	$("querybtn2").disabled = !btnRightArr.querybtn2.right;
	$("applybtn2").disabled = !btnRightArr.applybtn2.right;

	setspantx("wmodetx");
	setspantx("linkidtx");
	setspantx("reallinkidtx");
  setspantx("bandwidth");
  setspantx("ammode");
  setspantx("amstate");
  setspantx("manualmode");
  setspantx("ensuremode");
  setspantx("fullmode");

	setspantx("oduatt");
	setspantx("sendfretx");
	setspantx("sendfrerangetx");
	setspantx("realsdfretx");
	setspantx("realrefretx");

	setspantx("trspacetx");
	setspantx("realtrspacetx");
	setspantx("pwatt");

	setspantx("sendpwtx");
	setspantx("sendpwrangetx");
	setspantx("realsdpwtx");

	setspantx("realrepwtx");
	setspantx("odustatx");
	setspantx("realodustatx");
	setspantx("devatt");
	setspantx("fresegtx");
	setspantx("devtypetx");
	setspantx("stationtx");
	setspantx("serialtx");
	setspantx("powertypetx");

	var odusta = $("odusta");
	odusta.options[odusta.options.length] = new Option(RESOURCE["notWork"], 0);
	odusta.options[odusta.options.length] = new Option(RESOURCE["Work"], 1);

	valinum1("linkid", "1", "4094");
	forbidinput("reallinkid");

	valinum("sendfre", "0", "4294967.295");
	valinum("trspace", "0", "4294967.295");
	valinum1("sendpw", "-10.0", "35.0");

	forbidinput("sendfrerange");
	forbidinput("realsdfre");
	forbidinput("realrefre");
	forbidinput("realtrspace");
	forbidinput("sendpwrange");
	forbidinput("realsdpw");
	forbidinput("realrepw");
	forbidinput("realodusta");

	forbidinput("freseg");
	forbidinput("devtype");
	forbidinput("station");
	forbidinput("serial");
	forbidinput("powertype");
	
	setSelectRefreshState("odusta");
	setSelectRefreshState("wmode");
	setSelectRefreshState("bandwidthselect");
	
	$("bandwidthselect").onchange = function()
	{
		if($("amstateselect").value == 0)
		{
			if(this.value == "5")
			{
				$("manualmodeselect").disabled = true;
				setSelectIndex($("manualmodeselect"),"4");
			}
			else
			{
				if($("manualmodeselect").disabled)
				{
					$("manualmodeselect").disabled = false;
				}
				if($("manualmodeselect").value == "4")
				{
					setSelectIndex($("manualmodeselect"),"1");
				}
			}
		}
	}
	
	setSelectRefreshState("ammodeselect");
	setSelectRefreshState("amstateselect");
	setSelectRefreshState("manualmodeselect");
	setSelectRefreshState("ensuremodeselect");
	setSelectRefreshState("fullmodeselect");
	
	setTextRefreshState("linkid");
	setTextRefreshState("sendfre");
	setTextRefreshState("trspace");
	setTextRefreshState("sendpw");
    /*
	atpcenable["onchange"] = function()
	{
		var enable = $("atpcautoenable").value;
		var v = this.value;
		if (v == 0 && enable == 0)
		{
			atpcstep.disabled = true;
		}
		else
		{
			atpcstep.disabled = false;
		}
	};

	atpcautoenable["onchange"] = function()
	{
		var enable = $("atpcenable").value;
		var v = this.value;
		if (v == 0 && enable == 0)
		{
			atpcstep.disabled = true;
		}
		else
		{
			atpcstep.disabled = false;
        }
    };*/
}

/**
 *   Text         
 */
function setTextRefreshState(name)
{
	$(name)["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	  setApplybtn2Status(true);
	}
}

/**
 *   Select         
 */
function setSelectRefreshState(name)
{
	$(name)["onchange"] = function()
	{
		clearQueryInfoInterval();
		setApplybtn2Status(true);
	}
	$(name)["onclick"] = function()
	{
		clearQueryInfoInterval();
		setApplybtn2Status(true);
	}
}


function initHybrid()
{
	var bandwidth = $("bandwidthselect");
	bandwidth.options.length = 0;
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth2"], 2);
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth3"], 3);
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth4"], 4);
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth5"], 5);
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth6"], 6);
    
    var ammode = $("ammodeselect");
    ammode.options.length = 0;
    ammode.options[ammode.options.length] = new Option(RESOURCE["ammode0"], 0);
    ammode.options[ammode.options.length] = new Option(RESOURCE["ammode1"], 1);
    
	var amstate = $("amstateselect");
	amstate.options.length = 0;
    amstate.options[amstate.options.length] = new Option(RESOURCE["disable"], 0);
    amstate.options[amstate.options.length] = new Option(RESOURCE["enable"], 1);
    amstate.onchange = changeAmState;
    
    initmodeselect("manualmodeselect");
    initmodeselect("fullmodeselect");
    initmodeselect("ensuremodeselect");
}

function initmodeselect(selectid)
{
    var e = $(selectid);
    e.options.length = 0;
    e.options[e.options.length] = new Option(RESOURCE["ensuremode1"], 1);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode2"], 2);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode3"], 3);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode4"], 4);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode5"], 5);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode6"], 6);
}


function createif(singleobj)
{
	var fieldset = document.createElement("fieldset");
	fieldset.className = "iffieleset";
	fieldset.style.borderWidth = "2px";
	var boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

    var board = addboard(singleobj.ifslotid, singleobj.ifname, singleobj.oduslotid, singleobj.ifphy, singleobj.ifportid);
	board.oncontextmenu = rightClickEvent;
	boardcontain.appendChild(board);

    var board = addboard(singleobj.oduslotid, "ODU", singleobj.ifslotid, singleobj.oduphy, singleobj.ifportid);
	boardcontain.appendChild(board);

	fieldset.appendChild(boardcontain);

	var ifcontain = document.createElement("div");

	ifcontain.className = "ifgroupcontain";

	ifcontain.appendChild(fieldset);

	var contain = $("contain");

	contain.appendChild(ifcontain);
}

function rightClickEvent(evt)
{
	if ((SYSTEMCONF.getStatus() | SYSTEMCONF.getM2000()) == 0)
	{
		removejsDOMmenu();
		var cursorMenu = new jsDOMenu(140);
		var ifSlotId = this.childNodes[0].innerHTML.split("-")[0];
		var oduSlotId = this.parentElement.childNodes[1].childNodes[0].innerHTML.split("-")[0];
        cursorMenu.addMenuItem(new menuItem(RESOURCE["hopmgr"], "", openHopMgr, ifSlotId + "," + oduSlotId));
		setPopUpMenu(cursorMenu);
		rightClickHandler(evt);
		return;
	}
}

function openHopMgr(param)
{
	queryPeerNE(param);
}

function addboard(slotid, slotname, friendid, isphy, portid, isProtect)
{
	var board = document.createElement("div");
	board.className = "Slot slotw";
	if (slotid != null)
	{
		var slot = document.createElement("div");
		slot.id = "slot" + slotid + "_" + portid;
		if (isphy != null)
		{
			slot.className = 'Cardphylog SelStateOff cardw';
		}
		else
		{
			slot.className = 'Cardlogic SelStateOff cardw';
		}

		slot.innerHTML = slotid + "-" + slotname;

		slot.friendid = friendid;
		board.appendChild(slot);
        if (isProtect) 
        {
            var proSpan = document.createElement('div');
            proSpan.className = 'ifpro';
            proSpan.style.marginLeft = '36px';
            proSpan.style.marginTop = '-6px';
            slot.appendChild(proSpan);
        }
	}

	return board;
}

function createifprotect(workobj, protectobj)
{
	var fieldset = document.createElement("fieldset");
	fieldset.className = "ifgroupfieleset";
	fieldset.style.borderWidth = "2px";

	var legend = document.createElement("legend");
	var text = document.createElement("span");

	text.innerHTML = protect[workobj.protecttype];
	legend.appendChild(text);
	fieldset.appendChild(legend);

	var boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

    var board = addboard(workobj.ifslotid, workobj.ifname+ "-" + workobj.ifportid, workobj.oduslotid, workobj.ifphy, workobj.ifportid);
	board.oncontextmenu = rightClickEvent;
	boardcontain.appendChild(board);

    var board = addboard(workobj.oduslotid, "ODU", workobj.ifslotid, workobj.oduphy, workobj.ifportid);
	boardcontain.appendChild(board);

	fieldset.appendChild(boardcontain);

	boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

    var board = addboard(protectobj.ifslotid, protectobj.ifname+ "-" + protectobj.ifportid, protectobj.oduslotid, protectobj.ifphy, protectobj.ifportid, true);
	board.oncontextmenu = rightClickEvent;
	boardcontain.appendChild(board);

    var board = addboard(protectobj.oduslotid, "ODU", protectobj.ifslotid, protectobj.oduphy, protectobj.ifportid);
	boardcontain.appendChild(board);

	fieldset.appendChild(boardcontain);

	var ifcontain = document.createElement("div");

	ifcontain.className = "ifgroupcontain";

	ifcontain.appendChild(fieldset);

	var contain = $("contain");

	contain.appendChild(ifcontain);
}

function hfClearSelState()
{	
	if (lastselect != null)
	{
		var ele = $("slot" + lastselect);
		ele.className = ele.className.replace("SelStateOn", "SelStateOff");
	}
}

function hfSetSelState(boardid)
{
	var portid = boardid.split("_")[1]; 
    var slotid = boardid.split("_")[0];
	var ele = $("slot"+slotid + "_" + portid);
	ele.className = ele.className.replace("SelStateOff", "SelStateOn");
}

function handelclick(evt)
{
	var evt = evt ? evt : window.event;
	var element = evt.srcElement;
	var id = element.id;

	if (id.substr(0, 4) != "slot")
	{
		return;
	}

	boardon(id.substr(4, id.length), element);

}

function compareNum(str1, str2)
{
	var value1 = parseInt(str1);
	var value2 = parseInt(str2);
	return compare(value1, value2);
}

function compare(str1, str2)
{
	if (str1 > str2)
	{
		return 1;
	}
	if (str1 < str2)
	{
		return -1;
	}
	return 0;
}

function boardon(boardid, element)
{	
	hfClearSelState();
	
	hfSetSelState(boardid);
	
	var portid = boardid.split("_")[1]; 
    var boardid = boardid.split("_")[0]; 
    
    
	lastselect = boardid+"_"+portid;

	var friend = element.friendid;

	var boardgp;

	if (friend != null)
	{
		if (compareNum(boardid, friend) > 0)
		{
			boardgp = boardgrouplist[friend + portid + boardid];
		}
		else
		{
			boardgp = boardgrouplist[boardid + portid + friend];
		}
	}
	else
	{

		boardgp = boardgrouplist[boardid + portid ];
	}

	if (curboardgp != null)
	{
		if (curboardgp.ifslotid == boardgp.ifslotid && curboardgp.ifportid == boardgp.ifportid)
		{

		}
	}

	curboardgp = boardgp;

	queryboardatt(boardgp);
}

/**
 * odu/if   
 */
function queryinfo(isInteval)
{
	if(isInteval && isInteval == "true")
	{
		if(!autoRefresh)
		{
			return;
		}
	}
	else
	{
		setQueryInfoInterval();
	}
	if (curboardgp != null)
	{
		queryboardatt(curboardgp,isInteval);
	}
}

/**
 * if/odu board group
 */
function boardgroup()
{
	this.ifslotid = null;
	this.ifportid = null;
	this.ifphy = null;
	this.oduslotid = null;
	this.oduphy = null;

	this.ifname = null;
	this.oduname = "ODU";

	this.protecttype = null;

	this.iswork = null;
}

/**
 *     /     
 */

function queryboardatt(boardgp,isInteval)
{
  setQuerybtn2Status(false);
	setApplybtn2Status(false);
	setfiesetname(boardgp);
	setinputalbe();
	var xmlstr = createQueryinfoXML(boardgp,isInteval);
	var urlreq = "../../../../neExlorerServlet?sfid=" + query_oduif_params
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, updataInfo, boardgp, "inputdata=" + xmlstr);
}

/**
 *      /       
 */

function setfiesetname(boardgp)
{
    var dome = $("ifboard");
    
    if(boardgp.ifportid != null && typeof(boardgp.ifportid) != "undefined") 
    { 
    	dome.innerHTML = boardgp.ifslotid+"-"+ boardgp.ifname + "-" + boardgp.ifportid; 
    } 
    else 
    { 
    	dome.innerHTML = boardgp.ifslotid+"-"+ boardgp.ifname;
    	dome.innerHTML = boardgp.ifslotid+"-"+ boardgp.ifname; 
	} 
    dome = $("oduboard");
    dome.innerHTML = boardgp.oduslotid + "-" + boardgp.oduname;
}

/**
 *              
 */

function setinputalbe()
{

}

function createQueryinfoXML(boardgp,isInteval)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = new tagElement("row-params");
	var param = new tagElement("param");
	var neidvalue = neobject.neid;
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	param = new tagElement("param");
	var ifslotid = boardgp.ifslotid;
	param.setAttribute("name", "ifslotid");
	param.setAttribute("value", ifslotid);
	row.appendChild(param);
	
	/**
	param = new tagElement("param");
	var slotid = boardgp.oduslotid;
	param.setAttribute("name", "port");
	param.setAttribute("value", 1);
	row.appendChild(param);
	*/
	
	param = new tagElement("param");
    var ifportid = boardgp.ifportid;
    param.setAttribute("name","port");
    param.setAttribute("value",ifportid);
    row.appendChild(param);

	/**
	 * odu      
	 */
	if (boardgp.oduslotid != null)
	{
		param = new tagElement("param");
		var slotid = boardgp.oduslotid;
		param.setAttribute("name", "slotid");
		param.setAttribute("value", slotid);
		row.appendChild(param);
	}
	if(isInteval && isInteval == "true")
	{
		param = new tagElement("param");
		param.setAttribute("name", "isLogFlag");
		param.setAttribute("value", "0");
		row.appendChild(param);
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();

}


function changeAmState()
{
	var stateValue = this.value;
	if(0 == stateValue)
    {
		    initmodeselect("manualmodeselect");
			setinputstatus("manualmodeselect",false);
	        setinputstatus("ensuremodeselect",true);
	        setinputstatus("fullmodeselect",true);
     }else
     {
		    initmodeselect("fullmodeselect");
		    initmodeselect("ensuremodeselect");
		    setinputstatus("fullmodeselect",false);
			setinputstatus("ensuremodeselect",false);
	        setinputstatus("manualmodeselect",true);
      }
}

function setinputstatus(domid,status)
{
    var e = $(domid);
    if(true == status)
    {
        e.options.length = 0;
    	e.options[e.options.length] = new Option(RESOURCE["invalidvalue"],255);
    }

    e.disabled = status;
}

function forbiddenHybrid(status)
{
	setinputstatus("bandwidthselect",status);
	setinputstatus("ammodeselect",status);
	setinputstatus("amstateselect",status);
	setinputstatus("manualmodeselect",status);
	setinputstatus("ensuremodeselect",status);
	setinputstatus("fullmodeselect",status);
	if(false == status)
	{
		initHybrid();
	}
}

function setSelectIndex(domObject,value)
{
     for (var j = 0; j < domObject.options.length; j++) 
     {
          var curvalue = domObject.options[j].value;
          if (curvalue == value) 
          {
              domObject.options.selectedIndex = j;
              break;
          }
     }
}
function updataInfo(doc, boardgp)
{
	setQuerybtn2Status(true);	
	var data = EncapsulateData(doc);

	if (data.getDataRowLength() > 0)
	{
		var wmSel = $("wmode");

		for ( var i = wmSel.options.length - 1; i >= 0; i--)
		{
			wmSel.remove(i);
		}
		var allMode = data.getDataRowParam(0, "workmode");
		
		if (null != allMode && "" != allMode)
		{
			if (parseInt(allMode) == -1)
			{
				wmSel.disabled = true;
                forbiddenHybrid(false);//    hybrid     
			}
			else
			{
				wmSel.disabled = false;
                forbiddenHybrid(true);//    hybrid     
				var wmodes = allMode.split("%"); //         
        var curwmode = parseInt(data.getDataRowParam(0, "W32PORT_ATTR_RADIOWORKMODE")); //         
				for ( var j = 0; j < wmodes.length; j++)
				{
					var wmode = wmodes[j];
          var modeId = parseInt(wmode.substring(0, wmode.indexOf(","))); //       ID
          var wmodeShow = modeId +
                    ") " +
                    wmode.substring(wmode.indexOf(",") + 1, wmode.length);
                    wmSel.options[wmSel.options.length] = new Option(wmodeShow, modeId);

					if (modeId == curwmode)
					{
						wmSel.options.selectedIndex = j;
					}
				}
			}
		}
		else
		{
			wmSel.disabled = true;
      forbiddenHybrid(false);//    hybrid     
		}

		var linkid = data.getDataRowParam(0, "W32PORT_ATTR_RADIOLINKID");
		if (linkid != null && parseInt(linkid) > 0)
		{
			$("linkid").value = linkid;
		}
		var reallinkid = data.getDataRowParam(0, "W32PORT_ATTR_RECRADIOLINKID");
		if (reallinkid != null && parseInt(reallinkid) >= 0)
		{
			$("reallinkid").value = reallinkid;
		}
		else
		{
			$("reallinkid").value = "";//               
		}
        /************************************************************************************/
        
        var bandwidth = data.getDataRowParam(0, "bandwidth");
        if (bandwidth != null && !isNaN(bandwidth) && parseInt(bandwidth) > 0) 
        {
            setSelectIndex($("bandwidthselect"),bandwidth);
        }
        var ammode = data.getDataRowParam(0, "ammode");
        if (ammode != null && !isNaN(ammode) && parseInt(ammode) > 0) 
        {
            setSelectIndex($("ammodeselect"),ammode);
        }
        else
        {
        	setinputstatus("ammodeselect",true);//RTN900    AM  
        }
        
        var amstate = data.getDataRowParam(0, "amstate");
        if (amstate != null && !isNaN(amstate) && parseInt(amstate) > 0) 
        {
            setSelectIndex($("amstateselect"),amstate);
        }
        if(0 == amstate)
        {
	        var manualmode = data.getDataRowParam(0, "manualmode");
	        if (manualmode != null && !isNaN(manualmode) && parseInt(manualmode) > 0) 
	        {
	            setSelectIndex($("manualmodeselect"),manualmode);
	        }
	        if(5 == bandwidth)
	        {
	        	$("manualmodeselect").disabled = true;
	        }
	        setinputstatus("ensuremodeselect",true);
	        setinputstatus("fullmodeselect",true);
        }else
        {
	        var ensuremode = data.getDataRowParam(0, "ensuremode");
	        if (ensuremode != null && !isNaN(ensuremode) && parseInt(ensuremode) > 0) 
	        {
	            setSelectIndex($("ensuremodeselect"),ensuremode);
	        }
	        
	        var fullmode = data.getDataRowParam(0, "fullmode");
	        if (fullmode != null && !isNaN(fullmode) && parseInt(fullmode) > 0) 
	        {
	            setSelectIndex($("fullmodeselect"),fullmode);
	        }
	        setinputstatus("manualmodeselect",true);
        }
        /**
        var ensuremode = data.getDataRowParam(0, "ensuremode");
        if (ensuremode != null && !isNaN(ensuremode) && parseInt(ensuremode) > 0) 
        {
            setSelectIndex($("ensuremodeselect"),ensuremode);
        }
        
        var fullmode = data.getDataRowParam(0, "fullmode");
        if (fullmode != null && !isNaN(fullmode) && parseInt(fullmode) > 0) 
        {
            setSelectIndex($("fullmodeselect"),fullmode);
        }
        
        var manualmode = data.getDataRowParam(0, "manualmode");
        if (manualmode != null && !isNaN(manualmode) && parseInt(manualmode) > 0) 
        {
            setSelectIndex($("manualmodeselect"),manualmode);
        }
        */
        /**************************************************************************************/
        /*
		var atpcenable = data.getDataRowParam(0, "W32PORT_ATTR_ATPCENABLE");
		if (atpcenable != null)
		{
			$("atpcenable").selectedIndex = atpcenable;
		}
		
		var atpclow = data.getDataRowParam(0, "W32PORT_ATTR_ATPCUPPER");
		var atpchigh = data.getDataRowParam(0, "W32PORT_ATTR_ATPCLOWER");
		atpclow = (atpclow - 65536) / 10;
		atpchigh = (atpchigh - 65536) / 10;

		if (atpclow != null)
		{
			$("atpcrange").value = atpchigh + "~" + atpclow;
		}

		var atpcautoenable = data.getDataRowParam(0,
				"W32PORT_ATTR_ATPCAUTOENABLE");

		if (atpcautoenable != null && "1" == atpcautoenable)
		{//                                            
			atpcautoenable = true;
			var atpccurlow = data.getDataRowParam(0,
					"W32PORT_ATTR_ATPCCURTHUPPER");
			var atpccurhigh = data.getDataRowParam(0,
					"W32PORT_ATTR_ATPCCURTHLOWER");

			if ((null != atpccurlow && "/" != atpccurlow)
					&& ("" != atpccurlow && "-1" != atpccurlow))
			{
				atpccurlow = (atpccurlow - 65536) / 10;
				atpccurhigh = (atpccurhigh - 65536) / 10;
				$("atpcrange").value = atpccurhigh + "~" + atpccurlow;
			}
		}
		if (atpcautoenable != null)
		{
			$("atpcautoenable").selectedIndex = atpcautoenable;
		}
		else
		{
			atpcautoenable = 0;
		}

		var atpcstep = data.getDataRowParam(0, "W32PORT_ATTR_ATPCADJUSTMENT");

		setselsimplevalue(data, atpcstep / 10, "atpcstep");

		var select = $("atpcstep");
		if (atpcenable == 0 && atpcautoenable == 0)
		{
			select.disabled = true;
		}
		else
		{
			select.disabled = false;
		}
        */
		settxdirectvalue(data, "W32BRD_ATTR_TRANSMITFRE", "sendfre");
		
    var atpclow = data.getDataRowParam(0, "LOWFRE");
    var atpchigh = data.getDataRowParam(0, "W32BRD_ATTR_WORKRANGE");
		$("sendfrerange").value = atpclow + "~" + atpchigh;

		settxvalue(data, "W32BRD_ATTR_ACTTRANSMITFRE", "realsdfre");
		settxvalue(data, "W32BRD_ATTR_ACTTRECEIVEFRE", "realrefre");

		settxdirectvalue(data, "W32BRD_ATTR_TRINTERVAL", "trspace");
		settxvalue(data, "W32BRD_ATTR_ACTTRINTERVAL", "realtrspace");

		settxdirectvalue(data, "W32BRD_ATTR_TRANSMITPOWER", "sendpw");

		atpclow = data.getDataRowParam(0, "LOWPOWER");
		atpchigh = data.getDataRowParam(0, "W32BRD_ATTR_ACTRANGEOFPOWER");

		if(atpclow == "/" && atpchigh == "/")
		{
	    	 $("sendpwrange").value = "/";
		}
	    else
	    {
	    	 $("sendpwrange").value = atpclow + "~" + atpchigh;
	    } 

		settxvalue(data, "W32BRD_ATTR_ACTTRANSMITPOWER", "realsdpw");
		settxvalue(data, "W32BRD_ATTR_ACTRECEIVEPOWER", "realrepw");


		setselvalue(data, "W32BRD_ATTR_WORKSTATUS", "odusta");

		setrealSWITCHSTATUSvalue(data, "W32BRD_ATTR_SWITCHSTATUS", "realodusta");

		settxdirectvalue(data, "W32BRD_ATTR_FREQUENCY", "freseg");

		var value = data.getDataRowParam(0, "W32BRD_ATTR_QUIPTYPE");
		if (value == "5" || value == "10")
		{
			$("devtype").value = quipType[value];
		}
		settxdirectvalue(data, "W32BRD_ATTR_PRODUCESN", "serial");

		var value = data.getDataRowParam(0, "W32BRD_ATTR_HLSTATION");
		if (value == "5" || value == "10")
		{
			$("station").value = hlStation[value];
		}

		var value = data.getDataRowParam(0, "W32BRD_ATTR_POWEROUTPUT");
		if (value == "5" || value == "10")
		{
			$("powertype").value = powerGrade[value];
		}
		refreshParamValue();
	}
	else
	{
		lastParamValue = [];
	}
}

/**
 *   input = text ,dom    
 */
function settxdirectvalue(data, vname, domid)
{
	var value = data.getDataRowParam(0, vname);
	if (value != null)
	{
		$(domid).value = value;
	}
}

/**
 *   input = text ,dom    
 */
function settxvalue(data, vname, domid)
{
	var value = data.getDataRowParam(0, vname);
	if (value != null)
	{
		$(domid).value = value;
	}

}

/**
 *           
 */
function setrealSWITCHSTATUSvalue(data, vname, domid)
{
	var value = data.getDataRowParam(0, vname);
	if (value != null)
	{
		if (value == 0)
		{
			$(domid).value = switchStatus[0];
		}
		else if (value == 1)
		{
			$(domid).value = switchStatus[1];
		}
		else
		{
			$(domid).value = "";
		}
	}

}

/**
 *   input = select ,dom    
 */
function setselvalue(data, vname, domid)
{
	var value = data.getDataRowParam(0, vname);
	var select = $(domid);
	if (value != null && parseInt(value) >= 0)
	{
		for ( var i = 0; i < select.options.length; i++)
		{
			if (select.options[i].value == value)
			{
				select.options[i].selected = true;
				break;
			}
		}
	}
}

function setselsimplevalue(data, value, domid)
{
	var select = $(domid);
	if (value != null && parseInt(value) > 0)
	{
		for (i = 0; i < select.options.length; i++)
		{
			if (select.options[i].value == value)
			{
				select.options[i].selected = true;
				break;
			}
		}
	}
}

function applyifodu()
{
    setQuerybtn2Status(false);
		setApplybtn2Status(false);
    var xmlstr = setifinfoXML();
    if(null == xmlstr)
    {
    	setQuerybtn2Status(true);
    	return;
    }
   
    var urlreq = "../../../../neExlorerServlet?sfid=" + apply_if_params_sdh + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];  
    
    loadXMLdoc(urlreq, "POST", true, updataif, curboardgp, "inputdata=" + xmlstr);
}

function setifinfoXML()
{
    if (null == curboardgp || curboardgp.ifslotid == null || curboardgp.oduslotid == null) 
    {
    	if(btnRightArr.applybtn2.right)
    	{
         $("applybtn2").disabled = false;
    	}
    	if(btnRightArr.querybtn2.right)
    	{
    	  $("querybtn2").disabled = false;
    	}
        return null;
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    createXMLparam(row, "neid", neobject.neid);
		createXMLparam(row, "ifslotid", curboardgp.ifslotid);
	createXMLparam(row,"port",curboardgp.ifportid);

    var portselect = $("wmode");
    if (!portselect.disabled && checkParamValueChange("wmode")) 
    {
        var portvalue = portselect.options[portselect.selectedIndex].value;
        createXMLparam(row, "W32PORT_ATTR_RADIOWORKMODE", portvalue);
    }

    var linkid = getattvalue("linkid");
    createXMLparam(row, "W32PORT_ATTR_RADIOLINKID", linkid);

    var bandwidthobj = $("bandwidthselect");
    if (!bandwidthobj.disabled && checkParamValueChange("bandwidthselect")) 
    {
        var bandwidth = getattvalue("bandwidthselect");
    	createXMLparam(row, "bandwidth", bandwidth);
    }
    
    var ammodeobj = $("ammodeselect");
    if (!ammodeobj.disabled && checkParamValueChange("ammodeselect")) 
    {
        var ammode = getattvalue("ammodeselect");
    	createXMLparam(row, "ammode", ammode);
    }
    
    var hybridobj = $("amstateselect");
    if (!hybridobj.disabled && (checkParamValueChange("amstateselect") || checkParamValueChange("manualmodeselect") 
    		|| checkParamValueChange("ensuremodeselect") || checkParamValueChange("fullmodeselect"))) 
    {
        var amstate = getattvalue("amstateselect");
    	createXMLparam(row, "amstate", amstate);
    	amstate = getattvalue("manualmodeselect");
    	createXMLparam(row, "manualmode", amstate);
    	amstate = getattvalue("ensuremodeselect");
    	createXMLparam(row, "ensuremode", amstate);
    	amstate = getattvalue("fullmodeselect");
    	createXMLparam(row, "fullmode", amstate);
    }

    /***     ODU     ***/
    if(checkParamValueChange("sendfre") || checkParamValueChange("trspace")
    	|| checkParamValueChange("sendpw") || checkParamValueChange("odusta"))
    {
	    createXMLparam(row, "slotid", curboardgp.oduslotid);
	    
	    var sendfre = getattvalue("sendfre");
	    createXMLparam(row, "W32BRD_ATTR_TRANSMITFRE", sendfre * 1000);
	    
	    var trspace = getattvalue("trspace");
	    createXMLparam(row, "W32BRD_ATTR_TRINTERVAL", trspace * 1000);
	    
	    var sendpw = getattvalue("sendpw");
	    createXMLparam(row, "W32BRD_ATTR_TRANSMITPOWER", sendpw * 10);
	    
	    var odusta = getattvalue("odusta");
	    
	    var realodusta = getattvalue("realodusta");
	    createXMLparam(row, "W32BRD_ATTR_WORKSTATUS", odusta);
  	}
    /***     ODU      ***/
    if(row.childNodes.length <= 1)
    {
    	return null;
    }
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function updataif(doc)
{
	setQuerybtn2Status(true);
  var data = EncapsulateData(doc);
  if (data.getSErrorCode() != 0) 
  {
      showErrorDialog(data);
      setApplybtn2Status(true);
  }
  else
  {
  	refreshParamValue();
  	setQueryInfoInterval();
  }
}



function createXMLparam(row, name, value)
{
	param = new tagElement("param");
	param.setAttribute("name", name);
	param.setAttribute("value", value);
	row.appendChild(param);
}

function getattvalue(domid)
{
	return $(domid).value;
}

function valinum(domid, min, max)
{
	var e = $(domid);

	checkText(e, min, max, 3);
}

function valinum1(domid, min, max)
{
	var e = $(domid);

	checkText(e, min, max);
}

function forbidinput(domid)
{
	var e = $(domid);

	e.disabled = true;
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", data.getError(), errArr);
}


function setQuerybtn2Status(status)
{
	if(btnRightArr.querybtn2.right)
	{
		$("querybtn2").disabled = !status;	
	}
}

function setApplybtn2Status(status)
{
	if(btnRightArr.applybtn2.right)
	{
		$("applybtn2").disabled = !status;	
	}
}

var lastParamValue = [];
function refreshParamValue()
{
	lastParamValue = [];
	if(!$("wmode").disabled)
	{
		lastParamValue["wmode"] = $("wmode").value;
	}
	if(!$("bandwidthselect").disabled)
	{
		lastParamValue["bandwidthselect"] = $("bandwidthselect").value;
	}
	if(!$("ammodeselect").disabled)
	{
		lastParamValue["ammodeselect"] = $("ammodeselect").value;
	}
	if(!$("amstateselect").disabled)
	{
		lastParamValue["amstateselect"] = $("amstateselect").value;
	}
	if(!$("manualmodeselect").disabled)
	{
		lastParamValue["manualmodeselect"] = $("manualmodeselect").value;
	}
	if(!$("ensuremodeselect").disabled)
	{
		lastParamValue["ensuremodeselect"] = $("ensuremodeselect").value;
	}
	if(!$("fullmodeselect").disabled)
	{
		lastParamValue["fullmodeselect"] = $("fullmodeselect").value;
	}
	if(!$("odusta").disabled)
	{
		lastParamValue["odusta"] = $("odusta").value;
	}
	if(!$("linkid").disabled)
	{
		lastParamValue["linkid"] = $("linkid").value;
	}
	if(!$("sendfre").disabled)
	{
		lastParamValue["sendfre"] = $("sendfre").value;
	}
	if(!$("trspace").disabled)
	{
		lastParamValue["trspace"] = $("trspace").value;
	}
	if(!$("sendpw").disabled)
	{
		lastParamValue["sendpw"] = $("sendpw").value;
	}
}

function checkParamValueChange(name)
{
	var blResult = false;
	if(null != lastParamValue && typeof(lastParamValue[name]) != "undefined")
	{
		if($(name).value != lastParamValue[name])
		{
			blResult = true;
		}
	}
	return blResult;
}
