loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/ifoduconfig/ifoduconfig_" + SYSTEMCONF.getLanguage() + ".xml");

var lastselect;

var curboardgp;

var e1StatusOptions = [];
e1StatusOptions[0] = new Option(RESOURCE["disable"], 0);
e1StatusOptions[1] = new Option(RESOURCE["enable"], 1);

var protect = new Object();
protect[0] = "1+1 SD";
protect[1] = "1+1 FD";
protect[2] = "1+1 HSB";

var quipType = [];
quipType[5] = RESOURCE["sdh"];
quipType[10] = RESOURCE["pdh"];

var hlStation = [];
hlStation[5] = RESOURCE["lStation"];
hlStation[10] = RESOURCE["hStation"];

var switchStatus = [];
switchStatus[0] = RESOURCE["notWork"];
switchStatus[1] = RESOURCE["Work"];

var powerGrade = [];
powerGrade[5] = RESOURCE["Standard"];
powerGrade[10] = RESOURCE["High"];

var ODU_INF_FUN_ID = "10290";
var neobject = getNeProperty(self);

var boardgrouplist = new Object();
var btnRightArr = new Object();

var neidvalue = neobject.neid;

var isXpicBoard = false;

var xpicBoardIDList = new Object();

var synFlg=false;

var autoRefresh = true;

var queryInfoInteval = null;

var is1J1Fd = false;

var proif1ObjList = new Array();

function tabSelectHandler()
{ 
    querygroup();
    sendQueryXPICInfo();
    
}

function sendQueryXPICInfo(param)
{
    isXpicBoard = false;
    var xmlstr = createQueryXpicXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_GET_XPIC +
    "&flag=1" +
    "&nmUser=" +
    neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", false, queryXPICCallback, param, "inputdata=" + xmlstr);
}

function createQueryXpicXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neId");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
	param = new tagElement("param");
	param.setAttribute("name", "isLogFlag");
	param.setAttribute("value", "0");
	row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryXPICCallback(doc, flg)
{
    xpicBoardIDList = new Object();
    var ifSlot = null;
    for (var key in boardgrouplist) 
    {
        ifSlot = boardgrouplist[key].ifslotid;
        break;
    }
    
    if(flg)
    {
        ifSlot = curboardgp.ifslotid;
    }
    
    if (!ifSlot) 
    {
        return;
    }
    var dinterface = EncapsulateData(doc);
    
        for (var i = 0, m = dinterface.getDataRowLength(); i < m; i++) 
        {
            xpicBoardIDList[dinterface.getDataRowParam(i, "hPolarBdid")] = dinterface.getDataRowParam(i, "hPolarBdid");
            xpicBoardIDList[dinterface.getDataRowParam(i, "vPolarBdid")] = dinterface.getDataRowParam(i, "vPolarBdid");
            
    } 
    judgeIsXpicBoard(ifSlot);
    
    if(curboardgp)
    {
        queryboardatt(curboardgp, 'fromQueryXpic');
    }
}

function judgeIsXpicBoard(ifSlotid)
{
	isXpicBoard = false;
    if (ifSlotid in xpicBoardIDList) 
    {
        isXpicBoard = true;
        return;
    }
    
}

function setInputByXPIC()
{
    $("bandwidthselect").disabled = isXpicBoard;
    $("ammodeselect").disabled = isXpicBoard;
    $("amstateselect").disabled = isXpicBoard;
    $("manualmodeselect").disabled = isXpicBoard;
    $("fullmodeselect").disabled = isXpicBoard;
    $("ensuremodeselect").disabled = isXpicBoard;
}


function querygroup()
{
	var xml1f1str = createQueryIf1Plus1XML();
    var url1f1req = "../../../../neExlorerServlet?sfid=" + NSCMD_CFG_GET_RADIO_1J1PG 
    + "&timeStamp=" + new Date().getTime() + "&nmUser="
	+ neobject["nmUser"];
    loadXMLdoc(url1f1req, "POST", synFlg, queryProtectionCallback, true, "inputdata=" + xml1f1str);			

}


/**
 *       1+1       XML   
 */
function createQueryIf1Plus1XML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neId");

	param.setAttribute("value", neidvalue);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "isLogFlag");
	param.setAttribute("value", "0");
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function queryProtectionCallback(doc)
{
	var data = EncapsulateData(doc);
	
	proif1ObjList.clear();
	
	for ( var i = 0; i < data.getDataRowLength(); i++)
	{
		var proif1Obj = new Object();
		proif1Obj.groupId = data.getDataRowParam(i, "groupId");
		proif1Obj.workingSlotId = data.getDataRowParam(i, "workingSlotId");
		proif1Obj.protectionSlotId = data.getDataRowParam(i, "protectionSlotId");
		proif1Obj.equipSlotId = data.getDataRowParam(i, "equipSlotId");
		proif1ObjList[i] = proif1Obj;
	}

  var xmlstr = createQueryXML();
  var urlreq = "../../../../neExlorerServlet?sfid=" + get_iduodu_protectgroup + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
  loadXMLdoc(urlreq, "POST", synFlg, updateGP, null, "inputdata=" + xmlstr);
}

var lastData = null;
function updateGP(doc)
{
    synFlg=true;
    var contain = $("contain");
   
    
    var data = EncapsulateData(doc);
    
    var len = data.getDataRowLength();
    
    if(lastData !=null && len == lastData.getDataRowLength())
    {
    	var isAnychange =false;
    	for (var i = 0; i < len; i++) 
    	{
    		 	if(data.getDataRowParam(i, "workingSlotId") != lastData.getDataRowParam(i, "workingSlotId")
    		 	|| data.getDataRowParam(i, "workingbdname") != lastData.getDataRowParam(i, "workingbdname"))
    		 	{
    		 		isAnychange = true;
    		 		break;
    		 	}
    	}
    	if(!isAnychange)
    	{
    		 return;
    	}
    }
    
    lastData = data;
    
     while (contain.hasChildNodes()) 
    {
        contain.removeChild(contain.childNodes[0]);
    }
 
    if (len <= 0) 
    {
        $("applybtn2").disabled = true;
        $("querybtn2").disabled = true;
        return;
    }
    
    for (var i = 0; i < len; i++) 
    {
        var wmode = data.getDataRowParam(i, "wMode");
        if (wmode != null && wmode != '10') 
        {
            var wboard = new boardgroup();
            
            wboard.ifslotid = data.getDataRowParam(i, "workingSlotId");
            wboard.ifphy = data.getDataRowParam(i, "workifphy");
            wboard.ifname = data.getDataRowParam(i, "workingbdname");
            wboard.oduslotid = data.getDataRowParam(i, "workoduid");
            wboard.oduphy = data.getDataRowParam(i, "workoduphy");
            wboard.protecttype = data.getDataRowParam(i, "wMode");
            wboard.iswork = 1;
            boardgrouplist[wboard.ifslotid + wboard.oduslotid] = wboard;
            
            var pboard = new boardgroup();
            
            pboard.ifslotid = data.getDataRowParam(i, "protectionSlotId");
            pboard.ifphy = data.getDataRowParam(i, "protectifphy");
            pboard.ifname = data.getDataRowParam(i, "protectbdname");
            pboard.oduslotid = data.getDataRowParam(i, "protectoduid");
            pboard.oduphy = data.getDataRowParam(i, "protectoduphy");
            pboard.protecttype = data.getDataRowParam(i, "wMode");
            
            boardgrouplist[pboard.ifslotid + pboard.oduslotid] = pboard;
            
            createifprotect(wboard, pboard);
        }
        else 
        {
            var wboard = new boardgroup();
            
            wboard.ifslotid = data.getDataRowParam(i, "workingSlotId");
            wboard.ifphy = data.getDataRowParam(i, "workifphy");
            wboard.ifname = data.getDataRowParam(i, "workingbdname");
            wboard.oduslotid = data.getDataRowParam(i, "workoduid");
            wboard.oduphy = data.getDataRowParam(i, "workoduphy");
            
            if(!isInvalid(wmode) && wmode == '10')
            {
                wboard.protecttype = data.getDataRowParam(i, "wMode");
                wboard.iswork = data.getDataRowParam(i, "isWork");
            }
            
            if (wboard.oduslotid == null) 
            {
                boardgrouplist[wboard.ifslotid] = wboard;
            }
            else 
            {
                boardgrouplist[wboard.ifslotid + wboard.oduslotid] = wboard;
            }
            
            createif(wboard);
        }
    }
    
    initIfOduInfo();
}

function initIfOduInfo()
{
    var ifSlot = null;
    for (var key in boardgrouplist) 
    {
        ifSlot = boardgrouplist[key].ifslotid;
        break;
    }
    
    if (!ifSlot) 
    {
        return;
    }
    
    var ifElement = $("slot" + ifSlot);
    
    boardon(ifSlot, ifElement);
    ifElement.style.className = "Cardphylog SelStateOff cardw";
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
  
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function init()
{
	
    initinput();
    querygroup();
    sendQueryXPICInfo();
    
    setspantx("W32BRD_ATTR_REMARK");
    
    window.setInterval("querygroup()",20000);
    setQueryInfoInterval();

}

function setQueryInfoInterval()
{
	autoRefresh = true;
	if(!queryInfoInteval)
	{
            queryInfoInteval = window.setInterval("queryinfo('true')",10000);
	}
}

function clearQueryInfoInterval()
{
	autoRefresh = false;
	if(queryInfoInteval)
	{
		window.clearInterval(queryInfoInteval);
		queryInfoInteval = null;
	}
}


function setspantx(domid)
{
    var dome = $(domid);
    dome.innerHTML = RESOURCE[domid];
}

function initinput()
{
    $("querybtn2").value = RESOURCE["query"];
    $("applybtn2").value = RESOURCE["apply"];
    
    btnRightArr.querybtn2 = new BtnRightObj("querybtn2", query_oduif_params);
    btnRightArr.applybtn2 = new BtnRightObj("applybtn2", apply_odu_params);
    getRightInfo(neobject, btnRightArr);
    $("querybtn2").disabled = !btnRightArr.querybtn2.right;
    $("applybtn2").disabled = !btnRightArr.applybtn2.right;
    
    setspantx("wmodetx");
    setspantx("linkidtx");
    setspantx("reallinkidtx");
    setspantx("bandwidth");
    setspantx("ammode");
    setspantx("amstate");
    setspantx("manualmode");
    setspantx("ensuremode");
    setspantx("fullmode");
    setspantx("e1enable");
    setspantx("guaranteenumtx");
    setspantx("fullnumtx");
    setspantx("ifservicetype");
    setspantx("ensuree1numrangetx");
    setspantx("ethbandtx");
    setspantx("fullnumrangetx");
    setspantx("stm1numtx");
    
    var serviceType = $("servicetype");
    serviceType.options[serviceType.options.length] = new Option(RESOURCE["service1"], 1);
    serviceType.options[serviceType.options.length] = new Option(RESOURCE["service2"], 2);
    serviceType.options[serviceType.options.length] = new Option(RESOURCE["service3"], 3);
    
    setspantx("oduatt");
    setspantx("sendfretx");
    setspantx("sendfrerangetx");
    setspantx("realsdfretx");
    setspantx("realrefretx");
    
    setspantx("trspacetx");
    setspantx("realtrspacetx");
    setspantx("pwatt");
    
    setspantx("sendpwtx");
    setspantx("sendpwrangetx");
    setspantx("realsdpwtx");
    
    setspantx("realrepwtx");
    setspantx("odustatx");
    setspantx("realodustatx");
    setspantx("devatt");
    setspantx("fresegtx");
    setspantx("devtypetx");
    setspantx("stationtx");
    setspantx("serialtx");
    setspantx("powertypetx");
    setspantx("repwtx");
    setspantx("gaptx");
    setspantx("gaptx1");
    
    setspantx("ifbandwidthmode");
    
    var odusta = $("odusta");
    odusta.options[odusta.options.length] = new Option(RESOURCE["notWork"], 0);
    odusta.options[odusta.options.length] = new Option(RESOURCE["Work"], 1);
    
    valinum1("linkid", "1", "4094");
    forbidinput("reallinkid");
    
    valinum("sendfre", "0", "4294967.295");
    valinum("trspace", "0", "4294967.295");
    valinum1("sendpw", "-10.0", "35.0");
    textCheck($("repw"), "-90.0", "-20.0",1,"-10.0");
    
    forbidinput("sendfrerange");
    forbidinput("realsdfre");
    forbidinput("realrefre");
    forbidinput("realtrspace");
    forbidinput("sendpwrange");
    forbidinput("realsdpw");
    forbidinput("realrepw");
    forbidinput("realodusta");
    
    forbidinput("freseg");
    forbidinput("devtype");
    forbidinput("station");
    forbidinput("serial");
    forbidinput("powertype");
    
    checkTextForGNum();
    checkTextForFNum();
    
    addClearIntervalEvent();
    
}

function addClearIntervalEvent()
{
	$("linkid")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
	$("guaranteenum")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
  $("fullnum")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
	$("W32BRD_ATTR_REMARK")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
	$("sendfre")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
	$("trspace")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
	$("sendpw")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
	$("repw")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
	$("odusta")["onchange"] = function()
	{
		clearQueryInfoInterval();
	}
	
	$("W32BRD_ATTR_REMARK_txt")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
	}
	
}


function initHybrid()
{
    var servicetype = $("servicetype");
    servicetype.options.length = 0;
    servicetype.options[servicetype.options.length] = new Option("", "");
    servicetype.options[servicetype.options.length] = new Option(RESOURCE["service1"], 1);
    servicetype.options[servicetype.options.length] = new Option(RESOURCE["service2"], 2);
    servicetype.options[servicetype.options.length] = new Option(RESOURCE["service3"], 3);
    servicetype.onchange = changeIFService;
    servicetype.disabled = isXpicBoard;
    
    
    var bandwidth = $("bandwidthselect");
    bandwidth.options.length = 0;
    bandwidth.options[bandwidth.options.length] = new Option("", "");
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth2"], 2);
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth3"], 3);
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth4"], 4);
    if(curboardgp.ifname == 'ISU2' || curboardgp.ifname == 'ISX2')
    {
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth5"], 5);
    }
    bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth6"], 6);
    bandwidth.disabled = isXpicBoard;
    bandwidth.onchange = changeBandWidth;
    
    var ammode = $("ammodeselect");
    ammode.options.length = 0;
    ammode.options[ammode.options.length] = new Option("", "");
    ammode.options[ammode.options.length] = new Option(RESOURCE["ammode0"], 0);
    ammode.options[ammode.options.length] = new Option(RESOURCE["ammode1"], 1);
    ammode.disabled = isXpicBoard;
    
    var amstate = $("amstateselect");
    amstate.options.length = 0;
    amstate.options[amstate.options.length] = new Option("", "");
    amstate.options[amstate.options.length] = new Option(RESOURCE["disable"], 0);
    amstate.options[amstate.options.length] = new Option(RESOURCE["enable"], 1);
    amstate.onchange = changeAmState;
    amstate.disabled = isXpicBoard;
    
    initmodeselect("manualmodeselect");
    $("manualmodeselect").disabled = isXpicBoard;
    initmodeselect("fullmodeselect");
    $("fullmodeselect").disabled = isXpicBoard;
    initmodeselect("ensuremodeselect");
    $("ensuremodeselect").disabled = isXpicBoard;

    
    initmodeselect("manualmodeselect",true);
    initmodeselect("fullmodeselect",true);
    initmodeselect("ensuremodeselect",true);
    
    var e1Enable = $("e1enableselect");
    e1Enable.options.length = 0;
    e1Enable.options[e1Enable.options.length] = new Option(RESOURCE["disable"], 0);
    e1Enable.options[e1Enable.options.length] = new Option(RESOURCE["enable"], 1);
    e1Enable.onchange = changeE1Enable;
    
    tagModeEvent();
}

function initmodeselect(selectid,isAddEmpty)
{
    var e = $(selectid);
    e.options.length = 0;
    if(isAddEmpty)
    {
    	e.options[e.options.length] = new Option("", "");
    }
    e.options[e.options.length] = new Option(RESOURCE["ensuremode1"], 1);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode2"], 2);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode3"], 3);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode4"], 4);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode5"], 5);
    e.options[e.options.length] = new Option(RESOURCE["ensuremode6"], 6);
}

function createif(singleobj)
{
    var fieldset = document.createElement("fieldset");
    fieldset.className = "iffieleset";
    fieldset.style.borderWidth = "2px";
    var boardcontain = document.createElement("div");
    boardcontain.className = "boardcontain";
    
    var board = addboard(singleobj.ifslotid, singleobj.ifname, singleobj.oduslotid, singleobj.ifphy);
    board.oncontextmenu = rightClickEvent;
    boardcontain.appendChild(board);
    
    var board = addboard(singleobj.oduslotid, "ODU", singleobj.ifslotid, singleobj.oduphy);
    boardcontain.appendChild(board);
    
    fieldset.appendChild(boardcontain);
    
    var ifcontain = document.createElement("div");
    
    ifcontain.className = "ifgroupcontain";
    
    ifcontain.appendChild(fieldset);
    
    var contain = $("contain");
    
    contain.appendChild(ifcontain);
}

function rightClickEvent(evt)
{
    if ((SYSTEMCONF.getStatus() | SYSTEMCONF.getM2000()) == 0) 
    {
        removejsDOMmenu();
        var cursorMenu = new jsDOMenu(140);
        var ifSlotId = this.childNodes[0].innerHTML.split("-")[0];
        var oduSlotId = this.parentElement.childNodes[1].childNodes[0].innerHTML.split("-")[0];
        cursorMenu.addMenuItem(new menuItem(RESOURCE["hopmgr"], "", openHopMgr, ifSlotId + "," + oduSlotId));
        setPopUpMenu(cursorMenu);
        rightClickHandler(evt);
        return;
    }
}

function openHopMgr(param)
{

			
    var slotid = param.split(",")[0];					//     
    
    var neEle = window.top.frames["objecttree"].tree[neobject.realneid];
    
    if( null == neEle )
    {
    	return;
    }

    var fun = window.top.frames["functiontree"].tree[49221];	//49921 Radio Link Management fun id    
    
    if( null == fun )
    {
    	return;
    }
    
    neEle.isSelect();
    neEle.onClick();

    var isLinkParamModified = false;
    
    for( var i = 0; i < fun.argus.length; i++ )
    {
		if( isLinkParamModified == true )
		{
			break;
		}
    	
    	var tmpargus = fun.argus[i];

    	for( var j = 0; j < tmpargus.childNodes.length; j++ )
    	{
    		if( isLinkParamModified == true )
    		{
    			break;
    		}
    		
    		if( tmpargus.childNodes == null )
    		{
    			continue;
    		}
    		
    		var tmpstr = tmpargus.childNodes[j].getAttribute("link");
    		
    		if( tmpstr != null )
    		{
        		var index = tmpstr.indexOf("&domain=");
        		
        		var str1 = tmpstr.substring(0, index);
        		var str2 = tmpstr.substring(index, tmpstr.length);
        		var finalstr = str1 + "&linkslotid=" + slotid + str2;		//       
        		tmpargus.childNodes[j].setAttribute("link",finalstr);
        		
        		isLinkParamModified = true;
    		}
    	}
    }

    fun.expand();
    fun.isSelect();    
    fun.onClick();
    
    fun = null;
    neEle = null;
    
}

function addboard(slotid, slotname, friendid, isphy, isProtect)
{
    var board = document.createElement("div");
    board.className = "Slot slotw";
    if (slotid != null) 
    {
        var slot = document.createElement("div");
        slot.id = "slot" + slotid;
        if (isphy != null) 
        {
            slot.className = 'Cardphylog SelStateOff cardw';
        }
        else 
        {
            slot.className = 'Cardlogic SelStateOff cardw';
        }
        
        slot.innerHTML = slotid + "-" + slotname;
        
        slot.friendid = friendid;
        board.appendChild(slot);
        if (isProtect) 
        {
            var proSpan = document.createElement('div');
            proSpan.className = 'ifpro';
            proSpan.style.marginLeft = '36px';
            proSpan.style.marginTop = '-6px';
            slot.appendChild(proSpan);
        }
    }
    
    return board;
}

function createifprotect(workobj, protectobj)
{
	var isEquipAsWorkSolt = false;
	for ( var i = 0; i < proif1ObjList.length; i++)
	{
		var proif1Obj = proif1ObjList[i];
		if(proif1Obj.equipSlotId ==  workobj.ifslotid)
		{
			isEquipAsWorkSolt = true;
			break;
		}
	}
	
    var fieldset = document.createElement("fieldset");
    fieldset.className = "ifgroupfieleset";
    fieldset.style.borderWidth = "2px";
    
    var legend = document.createElement("legend");
    var text = document.createElement("span");
    
    text.innerHTML = protect[workobj.protecttype];
    legend.appendChild(text);
    fieldset.appendChild(legend);
    
    var boardcontain = document.createElement("div");
    boardcontain.className = "boardcontain";
    
    var board = null;    
    if(isEquipAsWorkSolt)
    {
       board = addboard(workobj.ifslotid, workobj.ifname, workobj.oduslotid, workobj.ifphy);
    }
    else
    {
    	board = addboard(workobj.ifslotid, workobj.ifname, workobj.oduslotid, workobj.ifphy, true);
    }
    board.oncontextmenu = rightClickEvent;
    boardcontain.appendChild(board);
    
    var board = addboard(workobj.oduslotid, "ODU", workobj.ifslotid, workobj.oduphy);
    boardcontain.appendChild(board);
    
    fieldset.appendChild(boardcontain);
    
    boardcontain = document.createElement("div");
    boardcontain.className = "boardcontain";
    
    if(isEquipAsWorkSolt)
	{
		 board = addboard(protectobj.ifslotid, protectobj.ifname, protectobj.oduslotid, protectobj.ifphy, true);
	}
	else
	{
		 board = addboard(protectobj.ifslotid, protectobj.ifname, protectobj.oduslotid, protectobj.ifphy);
	}
    board.oncontextmenu = rightClickEvent;
    boardcontain.appendChild(board);
    
    var board = addboard(protectobj.oduslotid, "ODU", protectobj.ifslotid, protectobj.oduphy);
    boardcontain.appendChild(board);
    
    fieldset.appendChild(boardcontain);
    
    var ifcontain = document.createElement("div");
    
    ifcontain.className = "ifgroupcontain";
    
    ifcontain.appendChild(fieldset);
    
    var contain = $("contain");
    
    contain.appendChild(ifcontain);
}

function hfClearSelState()
{
    if (lastselect != null) 
    {
        var ele = $("slot" + lastselect);
        ele.className = ele.className.replace("SelStateOn", "SelStateOff");
    }
}

function hfSetSelState(eid)
{
    var ele = $("slot" + eid);
    ele.className = ele.className.replace("SelStateOff", "SelStateOn");
}

function handelclick(evt)
{
    var evt = evt ? evt : window.event;
    var element = evt.srcElement;
    var id = element.id;
    
    if (id.substr(0, 4) != "slot") 
    {
        return;
    }
    
    boardon(id.substr(4, id.length), element);
    
}

function compareNum(str1, str2)
{
    var value1 = parseInt(str1);
    var value2 = parseInt(str2);
    return compare(value1, value2);
}

function compare(str1, str2)
{
    if (str1 > str2) 
    {
        return 1;
    }
    if (str1 < str2) 
    {
        return -1;
    }
    return 0;
}

function boardon(boardid, element)
{
    judgeIsXpicBoard(boardid);
    hfClearSelState();
    hfSetSelState(boardid);
    lastselect = boardid;
    
    var friend = element.friendid;
    
    var boardgp;
    
    if (friend != null) 
    {
        if (compareNum(boardid, friend) > 0) 
        {
            boardgp = boardgrouplist[friend + boardid];
        }
        else 
        {
            boardgp = boardgrouplist[boardid + friend];
        }
    }
    else 
    {
        boardgp = boardgrouplist[boardid];
    }
    
    if (curboardgp != null) 
    {
        if (curboardgp.ifslotid == boardgp.ifslotid) 
        {
        
        }
    }
    
    curboardgp = boardgp;
    
    queryMaxE1Num(boardgp);
    queryboardatt(boardgp, 'fromClickBoard');
    autoRefresh = true;
}

function queryMaxE1Num(boardgp)
{
    var xmlstr = createQueryMaxE1NumXML(boardgp);
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ALL_MAXE1NUM + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, queryMaxE1NumCallback, null, "inputdata=" + xmlstr);
}

function createQueryMaxE1NumXML(boardgp)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue = neobject.neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    var ifslotid = boardgp.ifslotid;
    param.setAttribute("name", "slotid");
    param.setAttribute("value", ifslotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var slotid = boardgp.oduslotid;
    param.setAttribute("name", "portid");
    param.setAttribute("value", 1);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isLogFlag");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryMaxE1NumCallback(doc)
{
    var data = EncapsulateData(doc);
    if (0 == data.getSErrorCode()) 
    {
        maxE1NumObj = new Object();
        for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
        {
            var bandType = data.getDataRowParam(i, "bandtype");
            var modeType = data.getDataRowParam(i, "modetype");
            var maxE1Num = data.getDataRowParam(i, "maxe1num");
            maxE1NumObj[bandType + "-" + modeType] = maxE1Num;
        }
    }
}

function queryinfo(isInteval)
{
	if(isInteval && isInteval == "true")
	{
		if(!autoRefresh)
		{
			return;
		}
	}
	else
	{
		setQueryInfoInterval();
	}
	if (curboardgp != null)
	{
		queryboardatt(curboardgp);
	}
}

function boardgroup()
{
    this.ifslotid = null;
    this.ifphy = null;
    this.oduslotid = null;
    this.oduphy = null;
    
    this.ifname = null;
    this.oduname = "ODU";
    
    this.protecttype = null;
    
    this.iswork = null;
}

function queryboardatt(boardgp, srcParam)
{
    $("applybtn2").disabled = true;
    $("querybtn2").disabled = true;
    setfiesetname(boardgp);
    setinputalbe();

    if(srcParam == 'fromClickBoard' && is1J1Fd)
    {
        setStatusByNJ1Mode();//       1+1   FD                       
    }

    var xmlstr = createQueryinfoXML(boardgp);
    clearQueryInfoInterval();
    var urlreq = "../../../../neExlorerServlet?sfid=" + query_oduif_params + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    if(srcParam == 'fromQueryXpic')
    {
        loadXMLdoc(urlreq, "POST", false, updataInfo, boardgp, "inputdata=" + xmlstr);
    } 
    else 
    {
        loadXMLdoc(urlreq, "POST", true, updataInfo, boardgp, "inputdata=" + xmlstr);
    }
}

function setfiesetname(boardgp)
{
    var dome = $("ifboard");
    dome.innerHTML = boardgp.ifslotid + "-" + boardgp.ifname;
    dome = $("oduboard");
    dome.innerHTML = boardgp.oduslotid + "-" + boardgp.oduname;
}

function setinputalbe()
{

}

function createQueryinfoXML(boardgp)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    var neidvalue = neobject.neid;
    param.setAttribute("name", "neid");
    param.setAttribute("value", neidvalue);
    row.appendChild(param);
    
    param = new tagElement("param");
    var ifslotid = boardgp.ifslotid;
    param.setAttribute("name", "ifslotid");
    param.setAttribute("value", ifslotid);
    row.appendChild(param);
    
    param = new tagElement("param");
    var slotid = boardgp.oduslotid;
    param.setAttribute("name", "port");
    param.setAttribute("value", 1);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isLogFlag");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    if (boardgp.oduslotid != null) 
    {
        param = new tagElement("param");
        var slotid = boardgp.oduslotid;
        param.setAttribute("name", "slotid");
        param.setAttribute("value", slotid);
        row.appendChild(param);
    }
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function changeAmState()
{
    clearQueryInfoInterval();
    var stateValue = this.value;
    if (0 == stateValue) 
    {
        initmodeselect("manualmodeselect");
        setinputstatus("manualmodeselect", false);
        setinputstatus("ensuremodeselect", true);
        setinputstatus("fullmodeselect", true);
        
        $("e1enableselect").disabled = true;
        $("e1enableselect").options.selectedIndex = 0;
        
        $("fullnum").disabled = true;
        $("fullnum").value = "-";
    }
    else 
    {
        initmodeselect("fullmodeselect");
        initmodeselect("ensuremodeselect");
        setinputstatus("fullmodeselect", false);
        setinputstatus("ensuremodeselect", false);
        setinputstatus("manualmodeselect", true);
        
        $("e1enableselect").disabled = false;
        $("fullnum").disabled = $("e1enableselect").value == 0;
        $("fullnum").value = $("guaranteenum").value;
    }
    
    refreshAmMode($('servicetype').value);
    refreshE1EditStatus();
    refreshE1();
}

function changeE1Enable()
{
    clearQueryInfoInterval();

    var e1Enable = this.value;
    if (0 == e1Enable) 
    {
        $("fullnum").disabled = true;
        $("fullnum").value = $("guaranteenum").value;
    }
    else 
    {
        $("fullnum").disabled = false;
    }
    
    refreshE1EditStatus();
    refreshE1();
}

function setinputstatus(domid, status)
{
    var e = $(domid);
    if (true == status) 
    {
        e.options.length = 0;
        e.options[e.options.length] = new Option(RESOURCE["invalidvalue"], 255);
    }
    
    e.disabled = status;
}

function forbiddenHybrid(status)
{
    setinputstatus("bandwidthselect", status);
    setinputstatus("ammodeselect", status);
    setinputstatus("amstateselect", status);
    setinputstatus("manualmodeselect", status);
    setinputstatus("ensuremodeselect", status);
    setinputstatus("fullmodeselect", status);
    setinputstatus("e1enableselect", status);
    
    setinputstatus("servicetype", status);
	
    $("guaranteenum").disabled = status;
    $("guaranteenum").value = "-";
    $("fullnum").disabled = status;
    $("fullnum").value = "-";
    $("ensuree1numrange").value = "-";
    $("ethband").value = "-";
    $("fullnumrange").value = "-";
    
    $("stm1num").disabled = status;
    $("stm1num").value = "-";
	
    if (false == status) 
    {
        initHybrid();
    }
}

function setSelectIndex(domObject,tmpvalue,isRemoveEmpty)
{
     if(isRemoveEmpty)
     {
     	domObject.remove(0);
    }
    for (var j = 0; j < domObject.options.length; j++) 
    {
        var curvalue = domObject.options[j].value;
        if (curvalue == tmpvalue) 
        {
            domObject.options.selectedIndex = j;
            break;
        }
    }
}

function updataInfo(doc, boardgp)
{
    var data = EncapsulateData(doc);
    if (data.getDataRowLength() > 0) 
    {
        parseServiceCapacity(data);
        fillIfwidthMode(data);
        fillInterAttr(data);
        fillAmAttr(data);
        fillODUAttr(data);
        
        $("ifbandwidthmodeselect").disabled = true;
        refreshParamValue();         
    }
    else
    {
    	lastParamValue = [];
    }
    
      if(btnRightArr.applybtn2.right)
    	{
        $("applybtn2").disabled = false;
      }
      if(btnRightArr.querybtn2.right)
    	{
        $("querybtn2").disabled = false;
      }   
    setODUInfoEnable();
    refStatusByGorupBoard(boardgp);
    setQueryInfoInterval();
}

function fillIfwidthMode(data)
{
    var bandwidth = data.getDataRowParam(0, "bandwidth");
    if (bandwidth != undefined && bandwidth != null && bandwidth != "")
    {
        var ifbdwidthmode = $("ifbandwidthmodeselect");
        ifbdwidthmode.options.length = 0;
        ifbdwidthmode.options[ifbdwidthmode.options.length] = new Option(RESOURCE["fccmode"], RESOURCE["fccmode"]);
        ifbdwidthmode.options[ifbdwidthmode.options.length] = new Option(RESOURCE["etsimode"], RESOURCE["etsimode"]);
        ifbdwidthmode.onchange = changeIFWidthMode;
        
        if (bandwidth == 9 || bandwidth == 8 || bandwidth == 7)
        {
            ifbdwidthmode.options.selectedIndex = 0;
        }
        else
        {
            ifbdwidthmode.options.selectedIndex = 1;
        }
    }
}

function changeIFWidthMode()
{
    var tmpmode = this.value;
    if (tmpmode == "FCC")
    {
        var bandwidth = $("bandwidthselect");
        bandwidth.options.length = 0;
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth7"], 9);
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth8"], 8);
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth9"], 7);
        bandwidth.onchange = changeBandWidth;
    }
    else
    {
        var bandwidth = $("bandwidthselect");
        bandwidth.options.length = 0;
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth2"], 2);
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth3"], 3);
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth4"], 4);
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth5"], 5);
        bandwidth.options[bandwidth.options.length] = new Option(RESOURCE["bandwidth6"], 6);
        bandwidth.onchange = changeBandWidth;
    }
}

function settxdirectvalue(data, vname, domid)
{
    var value = data.getDataRowParam(0, vname);
    if (value != null) 
    {
        $(domid).value = value;
    }
}

function setODUInfoEnable()
{
    $("sendfre").disabled = isXpicBoard;
    $("trspace").disabled = isXpicBoard;
    $("sendpw").disabled = isXpicBoard;
    $("W32BRD_ATTR_REMARK_txt").disabled = isXpicBoard;
}

function settxdirectvalue(data, vname, domid)
{
    var value = data.getDataRowParam(0, vname);
    if (value != null) 
    {
        $(domid).value = value;
    }
}

function settxvalue(data, vname, domid)
{
    var value = data.getDataRowParam(0, vname);
    if (value != null) 
    {
        $(domid).value = value;
    }
    
}

function setrealSWITCHSTATUSvalue(data, vname, domid)
{
    var value = data.getDataRowParam(0, vname);
    if (value != null) 
    {
        if (value == 0) 
        {
            $(domid).value = switchStatus[0];
        }
        else if (value == 1) 
        {
            $(domid).value = switchStatus[1];
        }
        else 
        {
            $(domid).value = "";
        }
    }
    
}

function setselvalue(data, vname, domid)
{
    var value = data.getDataRowParam(0, vname);
    var select = $(domid);
    if (value != null && parseInt(value) >= 0) 
    {
        for (var i = 0; i < select.options.length; i++) 
        {
            if (select.options[i].value == value) 
            {
                select.options[i].selected = true;
                break;
            }
        }
    }
}

function setselsimplevalue(data, value, domid)
{
    var select = $(domid);
    if (value != null && parseInt(value) > 0) 
    {
        for (i = 0; i < select.options.length; i++) 
        {
            if (select.options[i].value == value) 
            {
                select.options[i].selected = true;
                break;
            }
        }
    }
}

function applyifodu()
{
    $("applybtn2").disabled = true;
    $("querybtn2").disabled = true;
    var xmlstr = setifinfoXML();
    if (null == xmlstr) 
    {
        return;
    }
    var urlreq = "../../../../neExlorerServlet?sfid=" + apply_if_params + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, updataif, curboardgp, "inputdata=" + xmlstr);
}

function setifinfoXML()
{
    if (null == curboardgp || curboardgp.ifslotid == null || curboardgp.oduslotid == null) 
    {
    	if(btnRightArr.applybtn2.right)
    	{
        $("applybtn2").disabled = false;
      }
      if(btnRightArr.querybtn2.right)
    	{
        $("querybtn2").disabled = false;
      }
        return null;
    }
    
    if (checkParamValueChange("linkid") ||  checkParamValueChange("bandwidthselect") 
        	|| checkParamValueChange("ammodeselect") || checkParamValueChange("amstateselect")
        	|| checkParamValueChange("manualmodeselect") || checkParamValueChange("ensuremodeselect") 
        	|| checkParamValueChange("fullmodeselect")|| checkParamValueChange("guaranteenum") 
        	|| checkParamValueChange("fullnum") 
        	|| checkParamValueChange("sendfre") || checkParamValueChange("trspace")
        	|| checkParamValueChange("sendpw") || checkParamValueChange("odusta"))
        { 	
           if( confirm(RESOURCE["datamodifiedmsg"]) == false )
    	   {
              $("applybtn2").disabled = false;
        	  $("querybtn2").disabled = false;
    		  return;
    	   }
        }
    
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    createXMLparam(row, "neid", neobject.neid);
    
    createXMLparam(row, "ifslotid", curboardgp.ifslotid);
    createXMLparam(row, "port", "1");
    var portselect = $("wmode");
    if (!portselect.disabled) 
    {
        var portvalue = portselect.options[portselect.selectedIndex].value;
        createXMLparam(row, "W32PORT_ATTR_RADIOWORKMODE", portvalue);
    }
    
    if( $("W32BRD_ATTR_REMARK_txt") && !$("W32BRD_ATTR_REMARK_txt").disabled)
    {
    	createXMLparam(row, "W32BRD_ATTR_REMARK", $("W32BRD_ATTR_REMARK_txt").value);
    }
    
    var linkid = getattvalue("linkid");
    if (!$("linkid").disabled) 
    {
        createXMLparam(row, "W32PORT_ATTR_RADIOLINKID", linkid);
   }
    
    var bandwidthobj = $("bandwidthselect");
    if (!bandwidthobj.disabled) 
    {
        var bandwidth = getattvalue("bandwidthselect");
        createXMLparam(row, "bandwidth", bandwidth);
    }
    
    var ammodeobj = $("ammodeselect");
    if (!ammodeobj.disabled) 
    {
        var ammode = getattvalue("ammodeselect");
        createXMLparam(row, "ammode", ammode);
    }
    
    var hybridobj = $("amstateselect");
    if (!hybridobj.disabled) 
    {
        var amstate = getattvalue("amstateselect");
        createXMLparam(row, "amstate", amstate);
        amstate = getattvalue("manualmodeselect");
        createXMLparam(row, "manualmode", amstate);
        amstate = getattvalue("ensuremodeselect");
        createXMLparam(row, "ensuremode", amstate);
        amstate = getattvalue("fullmodeselect");
        createXMLparam(row, "fullmode", amstate);
        
       
	
        
        
    }

    createXMLparam(row, "slotid", curboardgp.oduslotid);
    
    if (!$("sendfre").disabled) 
    {
        var sendfre = getattvalue("sendfre");
        createXMLparam(row, "W32BRD_ATTR_TRANSMITFRE", sendfre * 1000);
    }
    
    if (!$("trspace").disabled) 
    {
        var trspace = getattvalue("trspace");
        createXMLparam(row, "W32BRD_ATTR_TRINTERVAL", trspace * 1000);
    }
    if (!$("sendpw").disabled) 
    {
        var sendpw = getattvalue("sendpw");
        createXMLparam(row, "W32BRD_ATTR_TRANSMITPOWER", sendpw * 10);
    }
    
    if ( !$("repw").disabled )
    {
    	var repw = getattvalue("repw");
    	createXMLparam(row, "W32BRD_ATTR_RECEIVEPOWER", repw * 10);
    }
    
    var odusta = getattvalue("odusta");
    
    var realodusta = getattvalue("realodusta");
    if (!$("odusta").disabled) 
    {
        createXMLparam(row, "W32BRD_ATTR_WORKSTATUS", odusta);
    }
    
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function updataif(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() != 0) 
    {
        showErrorDialog(data);
    }
    else
    {
        setQueryInfoInterval();
	  }
	    if(btnRightArr.applybtn2.right)
    	{
        $("applybtn2").disabled = false;
      }
      if(btnRightArr.querybtn2.right)
    	{
        $("querybtn2").disabled = false;
      }

}



function createXMLparam(row, name, value)
{
    param = new tagElement("param");
    param.setAttribute("name", name);
    param.setAttribute("value", value);
    if(value!="-")
    {
    	row.appendChild(param);
     }
}

function getattvalue(domid)
{
    return $(domid).value;
}

function valinum(domid, min, max)
{
    var e = $(domid);
    
    checkText(e, min, max, 3);
}

function valinum1(domid, min, max)
{
    var e = $(domid);
    
    checkText(e, min, max);
}

function forbidinput(domid)
{
    var e = $(domid);
    
    e.disabled = true;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", data.getError(), errArr);
}

function checkTextForGNum()
{
    var obj = $("guaranteenum");
    obj.style.imeMode = "disabled";
    
    obj.onpaste = function()
    {
        return false;
    }
    
    obj.onblur = function()
    {
        var max = $("fullnum").value;
        var amState = $("amstateselect").value;
		var e1Enable = $("e1enableselect").value;
        var mode = 0 == amState ? $("manualmodeselect").value : $("ensuremodeselect").value;
        var mv = maxE1NumObj[$("bandwidthselect").value + "-" + mode];
        if (e1Enable == 1)
		{
			max = parseInt(max) > parseInt(mv) ? mv : max;
		}
		else
		{
			max = mv;
		}
        blurValidate(obj, "0", max + '');
        if (1 == amState && 0 == e1Enable) 
        {
            $("fullnum").value = this.value;
        }
    }
    
}

function checkTextForFNum()
{
    var obj = $("fullnum");
    obj.style.imeMode = "disabled";
    
    obj.onpaste = function()
    {
        return false;
    }
    
    obj.onblur = function()
    {
        var max = maxE1NumObj[$("bandwidthselect").value + "-" + $("fullmodeselect").value];
        if (max <= Number($("guaranteenum").value)) 
        {
            alert(RESOURCE["invalide1num"]);
			$("fullnum").value=max;
        }
        else 
        {
            blurValidate(obj, $("guaranteenum").value, max + '');
        }
    }
    
}

function fillInterAttr(data)
{
    if( $("W32BRD_ATTR_REMARK_txt"))
    {
         settxdirectvalue(data,"W32BRD_ATTR_REMARK","W32BRD_ATTR_REMARK_txt");
    }

    var wmSel = $("wmode");
    
    for (var i = wmSel.options.length - 1; i >= 0; i--) 
    {
        wmSel.remove(i);
    }
    var allMode = data.getDataRowParam(0, "workmode");
    if (null != allMode && "" != allMode) 
    {
        if (parseInt(allMode) == -1) 
        {
            wmSel.disabled = true;
            forbiddenHybrid(false);
        }
        else 
        {
            wmSel.disabled = false;
            forbiddenHybrid(true);
            var wmodes = allMode.split("%");
            var curwmode = parseInt(data.getDataRowParam(0, "W32PORT_ATTR_RADIOWORKMODE")); 
            for (var j = 0; j < wmodes.length; j++) 
            {
                var wmode = wmodes[j];
                var modeId = parseInt(wmode.substring(0, wmode.indexOf(","))); 
                var wmodeShow = modeId + ") " + wmode.substring(wmode.indexOf(",") + 1, wmode.length);
                wmSel.options[wmSel.options.length] = new Option(wmodeShow, modeId);
                
                if (modeId == curwmode) 
                {
                    wmSel.options.selectedIndex = j;
                }
            }
        }
    }
    else 
    {
        wmSel.disabled = true;
        forbiddenHybrid(false);
    }
    
    var linkid = data.getDataRowParam(0, "W32PORT_ATTR_RADIOLINKID");
    if (linkid != null && parseInt(linkid) > 0) 
    {
        $("linkid").value = linkid;
    }

    var reallinkid = data.getDataRowParam(0, "W32PORT_ATTR_RECRADIOLINKID");
    if (reallinkid != null && parseInt(reallinkid) >= 0) 
    {
        $("reallinkid").value = reallinkid;
    }
    else 
    {
        $("reallinkid").value = "";
    }
}

function fillAmAttr(data)
{
    var serviceType = data.getDataRowParam(0, "serviceType");

    if(!isInvalid(serviceType))
    {
        setSelectIndex($("servicetype"),serviceType,true);   
    } else {
        setinputstatus("servicetype", true); 
    }
    
    var bandwidth = data.getDataRowParam(0, "bandwidth");
    if (bandwidth != null && !isNaN(bandwidth) && parseInt(bandwidth) > 0) 
    {
        if (bandwidth == 9 || bandwidth == 8 || bandwidth == 7)
        {
            var bandwidthobj = $("bandwidthselect");
            bandwidthobj.options.length = 0;
            bandwidthobj.options[bandwidthobj.options.length] = new Option("", "");
            bandwidthobj.options[bandwidthobj.options.length] = new Option(RESOURCE["bandwidth7"], 9);
            bandwidthobj.options[bandwidthobj.options.length] = new Option(RESOURCE["bandwidth8"], 8);
            bandwidthobj.options[bandwidthobj.options.length] = new Option(RESOURCE["bandwidth9"], 7);
            bandwidthobj.onchange = changeBandWidth;
        }
        else
        {
            var bandwidthobj = $("bandwidthselect");
            bandwidthobj.options.length = 0;
            bandwidthobj.options[bandwidthobj.options.length] = new Option("", "");
            bandwidthobj.options[bandwidthobj.options.length] = new Option(RESOURCE["bandwidth2"], 2);
            bandwidthobj.options[bandwidthobj.options.length] = new Option(RESOURCE["bandwidth3"], 3);
            bandwidthobj.options[bandwidthobj.options.length] = new Option(RESOURCE["bandwidth4"], 4);
            bandwidthobj.options[bandwidthobj.options.length] = new Option(RESOURCE["bandwidth5"], 5);
            bandwidthobj.options[bandwidthobj.options.length] = new Option(RESOURCE["bandwidth6"], 6);
            bandwidthobj.onchange = changeBandWidth;
        }
        setSelectIndex($("bandwidthselect"),bandwidth,true);   
    }

    var ammode = data.getDataRowParam(0, "ammode");
    if (ammode != null && !isNaN(ammode) && parseInt(ammode) > 0) 
    {
        setSelectIndex($("ammodeselect"),ammode,false);
    }
    else 
    {
        setinputstatus("ammodeselect", true);
    }
    
    var amstate = data.getDataRowParam(0, "amstate");
    if (amstate != null && !isNaN(amstate) && parseInt(amstate) > 0) 
    {
        setSelectIndex($("amstateselect"),amstate,true);
    }
    if (0 == amstate) 
    {
	        setSelectIndex($("amstateselect"),amstate,true);
        var manualmode = data.getDataRowParam(0, "manualmode");
        if (manualmode != null && !isNaN(manualmode) && parseInt(manualmode) > 0) 
        {
	            setSelectIndex($("manualmodeselect"),manualmode,true);
        }
        setinputstatus("ensuremodeselect", true);
        setinputstatus("fullmodeselect", true);
        
        
        var e1enable = data.getDataRowParam(0, "e1enable");

        if (!isInvalid(e1enable)) 
        {
            setSelectIndex($("e1enableselect"), e1enable);
        }  else {
            setinputstatus($("e1enableselect"), true);
        }
        $("e1enableselect").disabled = true;
        
        $("fullnum").disabled = true;
        
        var ensuremode = data.getDataRowParam(0, "ensuremode");
        if(isInvalid(ensuremode))
        {
             $("ensuremodeselect").disable = true;
        }
        
         var fullmode = data.getDataRowParam(0, "fullmode");
         if(isInvalid(fullmode))
        {
             $("fullmodeselect").disable = true;
        }
    }
    else 
    {
        var ensuremode = data.getDataRowParam(0, "ensuremode");
        if (ensuremode != null && !isNaN(ensuremode) && parseInt(ensuremode) > 0) 
        {
	            setSelectIndex($("ensuremodeselect"),ensuremode,true);
        }
        
        var fullmode = data.getDataRowParam(0, "fullmode");
        if (fullmode != null && !isNaN(fullmode) && parseInt(fullmode) > 0) 
        {
	            setSelectIndex($("fullmodeselect"),fullmode,true);
        }
        setinputstatus("manualmodeselect", true);
        
        var e1enable = data.getDataRowParam(0, "e1enable");
        if (e1enable != null && !isNaN(e1enable) && parseInt(e1enable) >= 0) 
        {
            setSelectIndex($("e1enableselect"), e1enable);
            
            if (0 == e1enable) 
            {
                $("fullnum").disabled = true;
            }
        }
    }
    
    var guaranteenum = data.getDataRowParam(0, "guaranteenum");
    if (guaranteenum != null && !isNaN(guaranteenum) && parseInt(guaranteenum) >= 0) 
    {
        $("guaranteenum").value = guaranteenum;
    }
    else
    {
        $("guaranteenum").disabled = true;
    }
    
    var maxe1cap1 = data.getDataRowParam(0, "maxe1cap1");
	var tempMaxE1 = isInvalid(maxe1cap1);
	if(!tempMaxE1)
	{
		valinum1("guaranteenum", "0", maxe1cap1);
	}else
	{
		valinum1("guaranteenum", "0", "5");//default value
	}
    $("ensuree1numrange").value = (tempMaxE1? '-' : (0 + '-' + maxe1cap1));
    
    var ethband = data.getDataRowParam(0, "ethband1");
    $("ethband").value = (isInvalid(ethband)? '-' : ethband/1000);
    
    if(!isInvalid(ethband) && isNaN(ethband/1000) && ethband.indexOf('-') > 0)
    {
        var arr = ethband.split('-')
        $("ethband").value = parseInt(arr[0])/1000 + '-' + parseInt(arr[1])/1000;
    }
    
    var fullnum = data.getDataRowParam(0, "fullnum");
    if (fullnum != null && !isNaN(fullnum) && parseInt(fullnum) >= 0) 
    {
        $("fullnum").value = fullnum == 0xFF ? "-" : fullnum;
    }
    
    var fullnumrange = data.getDataRowParam(0, "fullnumrange");
    $("fullnumrange").value = (isInvalid(fullnumrange)? '-' : 0 + '-' + fullnumrange);
    
    var stm1num = data.getDataRowParam(0, "stm1num");
    $("stm1num").value = stm1num >= 0? stm1num : "-";
    
    if(isInvalid($('wmode').value))
    {
        refreshAmMode(serviceType);

         if(serviceType == '1' || isInvalid(serviceType))
        {
            $('stm1num').disabled = true;
            $('stm1num').value = '-';
        } else {
            $('stm1num').disabled = false;         
        }
    }
}

function fillODUAttr(data)
{
    settxdirectvalue(data, "W32BRD_ATTR_TRANSMITFRE", "sendfre");
    
    var atpclow = data.getDataRowParam(0, "LOWFRE");
    var atpchigh = data.getDataRowParam(0, "W32BRD_ATTR_WORKRANGE");
    $("sendfrerange").value = atpclow + "~" + atpchigh;
    
    settxvalue(data, "W32BRD_ATTR_ACTTRANSMITFRE", "realsdfre");
    settxvalue(data, "W32BRD_ATTR_ACTTRECEIVEFRE", "realrefre");
    
    settxdirectvalue(data, "W32BRD_ATTR_TRINTERVAL", "trspace");
    settxvalue(data, "W32BRD_ATTR_ACTTRINTERVAL", "realtrspace");
    
    settxdirectvalue(data, "W32BRD_ATTR_TRANSMITPOWER", "sendpw");
    
    atpclow = data.getDataRowParam(0, "LOWPOWER");
    atpchigh = data.getDataRowParam(0, "W32BRD_ATTR_ACTRANGEOFPOWER");
    
    if(atpclow == "/" && atpchigh == "/")
	{
    	 $("sendpwrange").value = "/";
	}
    else
    {
    	 $("sendpwrange").value = atpclow + "~" + atpchigh;
    } 
    
    settxvalue(data, "W32BRD_ATTR_ACTTRANSMITPOWER", "realsdpw");
    settxvalue(data, "W32BRD_ATTR_ACTRECEIVEPOWER", "realrepw");
    
    settxvalue(data, "W32BRD_ATTR_RECEIVEPOWER", "repw");

    setselvalue(data, "W32BRD_ATTR_WORKSTATUS", "odusta");

    setrealSWITCHSTATUSvalue(data, "W32BRD_ATTR_SWITCHSTATUS", "realodusta");

    settxdirectvalue(data, "W32BRD_ATTR_FREQUENCY", "freseg");

    var value = data.getDataRowParam(0, "W32BRD_ATTR_QUIPTYPE");
    if (value == "5" || value == "10") 
    {
        $("devtype").value = quipType[value];
    }

    settxdirectvalue(data, "W32BRD_ATTR_PRODUCESN", "serial");

    var value = data.getDataRowParam(0, "W32BRD_ATTR_HLSTATION");
    if (value == "5" || value == "10") 
    {
        $("station").value = hlStation[value];
    }

    var value = data.getDataRowParam(0, "W32BRD_ATTR_POWEROUTPUT");
    if (value == "5" || value == "10") 
    {
        $("powertype").value = powerGrade[value];
    }
}

function changeIFService()
{
    clearQueryInfoInterval();

    var serviceType = this.value;
        
    refreshAmMode(serviceType);
    refreshE1EditStatus();
    
    if(serviceType == '1')
    {
        $('stm1num').disabled = true;
        $('stm1num').value = '-';
    } else {
       $('stm1num').disabled = false;
       $('stm1num').value = '';           
    }
}

function changeBandWidth()
{
     clearQueryInfoInterval();
     
     updateBandWidthResource(this.value);
     updateModeOptionText($('manualmodeselect'));
     updateModeOptionText($('fullmodeselect'));
     updateModeOptionText($('ensuremodeselect'));
     
     refreshAmMode($('servicetype').value);
     refreshE1();
}

function tagModeEvent()
{
    var obj = $("manualmodeselect");
    obj.onchange = refreshE1;
    
    obj = $("ensuremodeselect");
    obj.onchange = refreshE1;
    
    obj = $("fullmodeselect");
    obj.onchange = refreshE1;
}

function checkTextForFStm1Num(flg)
{
    var serviceType = getattvalue("servicetype");
    var band = getattvalue("bandwidthselect");
    var obj = $('stm1num');
    obj.style.imeMode = "disabled";
    
    var minSTM1 = '1', maxSTM1 = '1';
    switch(serviceType)
    {
        case '2':
            minSTM1 = '0';
            maxSTM1 = '1';
            break;
        case '3':  
            if(band == '4')
            {
                minSTM1 = '1';
                maxSTM1 = '1';
            } else if(band == '6')
            {
                minSTM1 = '1';
                maxSTM1 = '2';
            }
            break;
        default: break;
    }    
        
    if(flg)
    {
        blurValidate(obj, minSTM1, maxSTM1);
    } else {
    	var evt = EventUtil.getEvent();
        return digitalCheck(obj, minSTM1, maxSTM1,null,null,evt);
    }
}

function isProtectBoard(key)
{
    var obj = boardgrouplist[key];
    var protectType = obj.protecttype;
    
    if(!isInvalid(protectType) && obj.iswork != 1)
    {
        return true;
    }
    
    return false;
}

function isWorkBoard(key)
{
    var obj = boardgrouplist[key];
    var protectType = obj.protecttype;
    
    if(!isInvalid(protectType) && obj.iswork == 1)
    {
        return true;
    }
    
    return false;
}

function refStatusByGorupBoard(obj)
{
    var key = obj.ifslotid + obj.oduslotid;
    
    is1J1Fd = false;
    
    if(!isWorkBoard(key) && !isProtectBoard(key))
    {  if(btnRightArr.applybtn2.right)
    	 {
         $('applybtn2').disabled = false;
       }
        return;
    }
    
    if(isProtectBoard(key))
    {
        if(obj.protecttype != '1')
        {
            $('applybtn2').disabled = true;
        } else {
            setStatusByNJ1Mode(obj.protecttype);
            is1J1Fd = true;
        }
        $('servicetype').disabled = true;
    } else if(isWorkBoard(key)){
        $('servicetype').disabled = true;
    } 
}

function setStatusByNJ1Mode(mode)
{
    if(mode == '1')
    {
        $("bandwidthselect").disabled = true;
        $("ammodeselect").disabled = true;
        $("amstateselect").disabled = true;
        $("manualmodeselect").disabled = true;
        $("fullmodeselect").disabled = true;
        $("ensuremodeselect").disabled = true;
        $("e1enableselect").disabled = true;
        $("stm1num").disabled = true
        $("guaranteenum").disabled = true;
        $("fullnum").disabled = true;
        $("linkid").disabled = true;
    } else {
        $("bandwidthselect").disabled = false;
        $("ammodeselect").disabled = false;
        $("amstateselect").disabled = false;
        $("manualmodeselect").disabled = false;
        $("fullmodeselect").disabled = false;
        $("ensuremodeselect").disabled = false;
        $("e1enableselect").disabled = false;
        $("stm1num").disabled = false;
        $("guaranteenum").disabled = false;
        $("fullnum").disabled = false;
        $("linkid").disabled = false;
    }
}

var lastParamValue = [];
function refreshParamValue()
{
	lastParamValue = [];
	
	if(!$("wmode").disabled)
	{
		lastParamValue["wmode"] = $("wmode").value;
	}
	if(!$("bandwidthselect").disabled)
	{
		lastParamValue["bandwidthselect"] = $("bandwidthselect").value;
	}
	if(!$("ammodeselect").disabled)
	{
		lastParamValue["ammodeselect"] = $("ammodeselect").value;
	}
	if(!$("amstateselect").disabled)
	{
		lastParamValue["amstateselect"] = $("amstateselect").value;
	}
	if(!$("manualmodeselect").disabled)
	{
		lastParamValue["manualmodeselect"] = $("manualmodeselect").value;
	}
	if(!$("ensuremodeselect").disabled)
	{
		lastParamValue["ensuremodeselect"] = $("ensuremodeselect").value;
	}
	if(!$("fullmodeselect").disabled)
	{
		lastParamValue["fullmodeselect"] = $("fullmodeselect").value;
	}
	if(!$("guaranteenum").disabled)
	{
		lastParamValue["guaranteenum"] = $("guaranteenum").value;
	}
	if(!$("fullnum").disabled)
	{
		lastParamValue["fullnum"] = $("fullnum").value;
	}
	if(!$("odusta").disabled)
	{
		lastParamValue["odusta"] = $("odusta").value;
	}
	if(!$("linkid").disabled)
	{
		lastParamValue["linkid"] = $("linkid").value;
	}
	if(!$("sendfre").disabled)
	{
		lastParamValue["sendfre"] = $("sendfre").value;
	}
	if(!$("trspace").disabled)
	{
		lastParamValue["trspace"] = $("trspace").value;
	}
	if(!$("sendpw").disabled)
	{
		lastParamValue["sendpw"] = $("sendpw").value;
	}
}

function checkParamValueChange(name)
{
	var blResult = false;
	if(null != lastParamValue && typeof(lastParamValue[name]) != "undefined")
	{
		if($(name).value != lastParamValue[name])
		{
			blResult = true;
		}
	}
	return blResult;
}


