loadXMLdoc("../../../../conf/system.xml", "GET", false, EncapsulateSConf);
getResourse("../../../../res/commonres_" + SYSTEMCONF.getLanguage() + ".xml");
getResourse("../../res/ifoduconfig/ifoduconfig_" + SYSTEMCONF.getLanguage()
		+ ".xml");

var lastselect;

var curboardgp;
var groupLen = 0;
var protect = new Object();
protect[0] = "SD";
protect[1] = "FD";
protect[2] = "HSB";

var quipType = [];
quipType[5] = RESOURCE["sdh"];
quipType[10] = RESOURCE["pdh"];

var hlStation = [];
hlStation[5] = RESOURCE["lStation"];
hlStation[10] = RESOURCE["hStation"];

var switchStatus = [];
switchStatus[0] = RESOURCE["notWork"];
switchStatus[1] = RESOURCE["Work"];

var powerGrade = [];
powerGrade[5] = RESOURCE["Standard"];
powerGrade[10] = RESOURCE["High"];

var neobject = getNeProperty(self);

var boardgrouplist = new Object(); //      /odu     

var btnRightArr = new Object();

var neidvalue = neobject.neid;
function tabSelectHandler()
{
	querygroup();
}
function querygroup()
{
	var xmlstr = createQueryXML();
	var urlreq = "../../../../neExlorerServlet?sfid=" + get_iduodu_protectgroup
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, updateGP, null, "inputdata=" + xmlstr);
}

function updateGP(doc)
{
	var contain = $("contain");
	while (contain.hasChildNodes())
	{
		contain.removeChild(contain.childNodes[0]);
	}
	var data = EncapsulateData(doc);

	var len = data.getDataRowLength();

	if (len <= 0)
	{
		return;
	}

	for ( var i = 0; i < len; i++)
	{
		var wmode = data.getDataRowParam(i, "wMode");
		if (wmode != null)
		{
			var wboard = new boardgroup();

			wboard.ifslotid = data.getDataRowParam(i, "workingSlotId");
			if (data.getDataRowParam(i, "workingPortId") != null)
			{
				wboard.ifportid = data.getDataRowParam(i, "workingPortId");
			}
			wboard.ifphy = data.getDataRowParam(i, "workifphy");
			wboard.ifname = data.getDataRowParam(i, "workingbdname");
			wboard.oduslotid = data.getDataRowParam(i, "workoduid");
			wboard.oduphy = data.getDataRowParam(i, "workoduphy");
			wboard.protecttype = data.getDataRowParam(i, "wMode");
			wboard.iswork = 1;
			boardgrouplist[wboard.ifslotid + wboard.oduslotid] = wboard;

			var pboard = new boardgroup();

			pboard.ifslotid = data.getDataRowParam(i, "protectionSlotId");
			if (data.getDataRowParam(i, "protectionPortId") != null)
			{
				pboard.ifportid = data.getDataRowParam(i, "protectionPortId");
			}
			pboard.ifphy = data.getDataRowParam(i, "protectifphy");
			pboard.ifname = data.getDataRowParam(i, "protectbdname");
			pboard.oduslotid = data.getDataRowParam(i, "protectoduid");
			pboard.oduphy = data.getDataRowParam(i, "protectoduphy");
			pboard.protecttype = data.getDataRowParam(i, "wMode");

			boardgrouplist[pboard.ifslotid + pboard.oduslotid] = pboard;

			createifprotect(wboard, pboard);
		}
		else
		{
			var wboard = new boardgroup();

			wboard.ifslotid = data.getDataRowParam(i, "workingSlotId");
			if (data.getDataRowParam(i, "workingPortId") != null)
			{
				wboard.ifportid = data.getDataRowParam(i, "workingPortId");
			}
			wboard.ifphy = data.getDataRowParam(i, "workifphy");
			wboard.ifname = data.getDataRowParam(i, "workingbdname");
			wboard.oduslotid = data.getDataRowParam(i, "workoduid");
			wboard.oduphy = data.getDataRowParam(i, "workoduphy");

			if (wboard.oduslotid == null)
			{
				boardgrouplist[wboard.ifslotid] = wboard;
			}
			else
			{
				boardgrouplist[wboard.ifslotid + wboard.oduslotid] = wboard;
			}

			createif(wboard);
		}
	}
	if(groupLen != len)
  {
	initIfOduInfo();
	}
	hfSetSelState(lastselect);
	groupLen = len;
}

function initIfOduInfo()
{
	var ifSlot = null;
	if(lastselect != null && lastExist(lastselect))
	{
		ifSlot = lastselect;
	}
	if (!ifSlot)
	{
		for (var key in boardgrouplist)
  	{
  		if(!boardgrouplist[key])
  		{
  			continue;
  		}
      ifSlot = boardgrouplist[key].ifslotid;
      if (boardgrouplist[key].ifportid != null)
			{
				ifSlot += "-" + boardgrouplist[key].ifportid;
			}
      lastselect = ifSlot;
  		break;    	
  	}	
	}
	if (!ifSlot)
	{
		return;
	}

	var ifElement = $("slot" + ifSlot);

	boardon(ifSlot, ifElement);
	ifElement.style.className = "Cardphylog SelStateOff cardw";
}

function lastExist(id)
{
	for (var key in boardgrouplist)
	{
    if(boardgrouplist[key] 
    	&& ((boardgrouplist[key].ifportid == null && id == boardgrouplist[key].ifslotid)
    			|| (boardgrouplist[key].ifportid != null && id == boardgrouplist[key].ifslotid + "-" + boardgrouplist[key].ifportid)))
    {
    	return true;
    }
	}
	return false;
}

function createQueryXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

var queryInfoInteval = null;
var autoRefresh = true;
function init()
{
	initinput();
	querygroup();
	window.setInterval("querygroup()",20000);
	setQueryInfoInterval();
}

function setQueryInfoInterval()
{
	autoRefresh = true;
	if(!queryInfoInteval)
	{
		queryInfoInteval = window.setInterval("queryinfo('true')",6000);
	}
}

function clearQueryInfoInterval()
{
	autoRefresh = false;
	if(queryInfoInteval)
	{
		window.clearInterval(queryInfoInteval);
		queryInfoInteval = null;
	}
}
function setspantx(domid)
{
	var dome = $(domid);
	dome.innerHTML = RESOURCE[domid];
}

function initinput()
{
	$("querybtn2").value = RESOURCE["query"];
	$("applybtn2").value = RESOURCE["apply"];

	btnRightArr.querybtn2 = new BtnRightObj("querybtn2", query_oduif_params);
	btnRightArr.applybtn2 = new BtnRightObj("applybtn2", apply_odu_params);
	getRightInfo(neobject, btnRightArr);
	$("querybtn2").disabled = !btnRightArr.querybtn2.right;
	$("applybtn2").disabled = !btnRightArr.applybtn2.right;

	setspantx("wmodetx");
	setspantx("linkidtx");
	setspantx("reallinkidtx");
	setspantx("atpcenabletx");
	setspantx("atpcrangetx");
	setspantx("atpcsteptx");
	setspantx("oduatt");
	setspantx("sendfretx");
	setspantx("sendfrerangetx");
	setspantx("realsdfretx");
	setspantx("realrefretx");

	setspantx("trspacetx");
	setspantx("realtrspacetx");
	setspantx("pwatt");

	setspantx("sendpwtx");
	setspantx("sendpwrangetx");
	setspantx("realsdpwtx");

	setspantx("realrepwtx");
	setspantx("odustatx");
	setspantx("realodustatx");
	setspantx("devatt");
	setspantx("fresegtx");
	setspantx("devtypetx");
	setspantx("stationtx");
	setspantx("serialtx");
	setspantx("powertypetx");

	var atpcstep = $("atpcstep");
	atpcstep.options[atpcstep.options.length] = new Option("1", 1);
	atpcstep.options[atpcstep.options.length] = new Option("2", 2);
	atpcstep.options[atpcstep.options.length] = new Option("3", 3);
	atpcstep.options[atpcstep.options.length] = new Option("4", 4);
	atpcstep.options[atpcstep.options.length] = new Option("5", 5);

	var atpcenable = $("atpcenable");
	atpcenable.options[atpcenable.options.length] = new Option(
			RESOURCE["disable"], 0);
	atpcenable.options[atpcenable.options.length] = new Option(
			RESOURCE["enable"], 1);

	var odusta = $("odusta");
	odusta.options[odusta.options.length] = new Option(RESOURCE["notWork"], 0);
	odusta.options[odusta.options.length] = new Option(RESOURCE["Work"], 1);

	valinum1("linkid", "1", "4094");
	forbidinput("reallinkid");
	forbidinput("atpcrange");

	valinum("sendfre", "0", "4294967.295");
	valinum("trspace", "0", "4294967.295");
	valinum1("sendpw", "-10.0", "35.0");

	forbidinput("sendfrerange");
	forbidinput("realsdfre");
	forbidinput("realrefre");
	forbidinput("realtrspace");
	forbidinput("sendpwrange");
	forbidinput("realsdpw");
	forbidinput("realrepw");
	forbidinput("realodusta");

	forbidinput("freseg");
	forbidinput("devtype");
	forbidinput("station");
	forbidinput("serial");
	forbidinput("powertype");
	$("odusta")["onchange"] = function()
	{
		clearQueryInfoInterval();
		setApplybtn2Status(true);
	}  

	$("linkid")["onkeydown"] = function()
	{
		clearQueryInfoInterval();
		setApplybtn1Status(true);
	}
	
	$('sendfre')["onkeydown"] = function()
	{
			clearQueryInfoInterval();
	    setApplybtn2Status(true);
	}
	
	$('trspace')["onkeydown"] = function()
	{
		clearQueryInfoInterval();
		setApplybtn2Status(true);
	}
	
	$('sendpw')["onkeydown"] = function()
	{
		clearQueryInfoInterval();
		setApplybtn2Status(true);
	}


	atpcenable["onchange"] = function()
	{
		clearQueryInfoInterval();
		setApplybtn1Status(true);
		var v = this.value;
		if (v == 0)
		{
			atpcstep.disabled = true;
		}
		else
		{
			atpcstep.disabled = false;
		}
	};
	
	atpcenable["onclick"] = function()
	{
		clearQueryInfoInterval();
	}
	atpcstep["onchange"] = function()
	{
		clearQueryInfoInterval();
		setApplybtn1Status(true);
	}
	atpcstep["onclick"] = function()
	{
		clearQueryInfoInterval();
	}
}

function createif(singleobj)
{
	var fieldset = document.createElement("fieldset");
	fieldset.className = "iffieleset";
	fieldset.style.borderWidth = "2px";
		
	var boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

	var board = addboard(singleobj.ifslotid, singleobj.ifname, singleobj.ifportid,
			singleobj.oduslotid, singleobj.ifphy);
	board.oncontextmenu = rightClickEvent;
	boardcontain.appendChild(board);

	var board = addboard(singleobj.oduslotid, "ODU", null, singleobj.ifslotid,
			singleobj.oduphy);
	boardcontain.appendChild(board);

	fieldset.appendChild(boardcontain);

	var ifcontain = document.createElement("div");

	ifcontain.className = "ifgroupcontain";

	ifcontain.appendChild(fieldset);

	var contain = $("contain");

	contain.appendChild(ifcontain);
}

function rightClickEvent(evt)
{
	if ((SYSTEMCONF.getStatus() | SYSTEMCONF.getM2000()) == 0)
	{
		removejsDOMmenu();
		var cursorMenu = new jsDOMenu(140);
		var ifSlotId = this.childNodes[0].innerHTML.split("-")[0];
		var oduSlotId = this.parentElement.childNodes[1].childNodes[0].innerHTML.split("-")[0];
		cursorMenu.addMenuItem(new menuItem(RESOURCE["hopmgr"], "", openHopMgr,
				ifSlotId + "," + oduSlotId));
		setPopUpMenu(cursorMenu);
		rightClickHandler(evt);
		return;
	}
}

function openHopMgr(param)
{

			
    var slotid = param.split(",")[0];					//     

    var neEle = window.top.frames["objecttree"].tree[neobject.realneid];
    
    if( null == neEle )
    {
    	return;
    }

    var fun = window.top.frames["functiontree"].tree[49221];	//49921 Radio Link Management fun id    
    
    if( null == fun )
    {
    	return;
    }
    
    neEle.isSelect();
    neEle.onClick();

    var isLinkParamModified = false;
    
    for( var i = 0; i < fun.argus.length; i++ )
    {
		if( isLinkParamModified == true )
		{
			break;
		}
    	
    	var tmpargus = fun.argus[i];

    	for( var j = 0; j < tmpargus.childNodes.length; j++ )
    	{
    		if( isLinkParamModified == true )
    		{
    			break;
    		}
    		
    		if( tmpargus.childNodes == null )
    		{
    			continue;
    		}
    		
    		var tmpstr = tmpargus.childNodes[j].getAttribute("link");
    		
    		if( tmpstr != null )
    		{
        		var index = tmpstr.indexOf("&domain=");
        		
        		var str1 = tmpstr.substring(0, index);
        		var str2 = tmpstr.substring(index, tmpstr.length);
        		var finalstr = str1 + "&linkslotid=" + slotid + str2;		//       
        		tmpargus.childNodes[j].setAttribute("link",finalstr);
        		
        		isLinkParamModified = true;
    		}
    	}
    }

    fun.expand();
    fun.isSelect();    
    fun.onClick();
    
    fun = null;
    neEle = null;
    
}

function addboard(slotid, slotname, portid, friendid, isphy)
{
	var board = document.createElement("div");
	board.className = "Slot slotw";
	if (slotid != null)
	{
		var slot = document.createElement("div");
		slot.id = "slot" + slotid;
		if (isphy != null)
		{
			slot.className = 'Cardphylog SelStateOff cardw';
		}
		else
		{
			slot.className = 'Cardlogic SelStateOff cardw';
		}

		slot.innerHTML = slotid + "-" + slotname;
		if (null != portid)
		{
			slot.innerHTML += "-" + portid;			
			slot.id += "-" + portid;
		}

		slot.friendid = friendid;
		board.appendChild(slot);
	}

	return board;
}

function createifprotect(workobj, protectobj)
{
	var fieldset = document.createElement("fieldset");
	fieldset.className = "ifgroupfieleset";
	fieldset.style.borderWidth = "2px";

	var legend = document.createElement("legend");
	var text = document.createElement("span");

	text.innerHTML = protect[workobj.protecttype];
	legend.appendChild(text);
	fieldset.appendChild(legend);

	var boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

	var board = addboard(workobj.ifslotid, workobj.ifname, workobj.ifportid, workobj.oduslotid,
			workobj.ifphy);
	board.oncontextmenu = rightClickEvent;
	boardcontain.appendChild(board);

	var board = addboard(workobj.oduslotid, "ODU", null, workobj.ifslotid,
			workobj.oduphy);
	boardcontain.appendChild(board);

	fieldset.appendChild(boardcontain);

	boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

	var board = addboard(protectobj.ifslotid, protectobj.ifname, protectobj.ifportid,
			protectobj.oduslotid, protectobj.ifphy);
	board.oncontextmenu = rightClickEvent;
	boardcontain.appendChild(board);

	var board = addboard(protectobj.oduslotid, "ODU", null, protectobj.ifslotid,
			protectobj.oduphy);
	boardcontain.appendChild(board);

	fieldset.appendChild(boardcontain);

	var ifcontain = document.createElement("div");

	ifcontain.className = "ifgroupcontain";

	ifcontain.appendChild(fieldset);

	var contain = $("contain");

	contain.appendChild(ifcontain);

}

function hfClearSelState()
{
	if (lastselect != null)
	{
		var ele = $("slot" + lastselect);
		ele.className = ele.className.replace("SelStateOn", "SelStateOff");
	}
}

function hfSetSelState(eid)
{
	var ele = $("slot" + eid);
	ele.className = ele.className.replace("SelStateOff", "SelStateOn");
}

function handelclick(evt)
{
	var evt = evt ? evt : window.event;
	var element = evt.srcElement;
	var id = element.id;

	if (id.substr(0, 4) != "slot")
	{
		return;
	}

	boardon(id.substr(4, id.length), element);

}

function compareNum(str1, str2)
{
	var value1 = parseInt(str1);
	var value2 = parseInt(str2);
	return compare(value1, value2);
}

function compare(str1, str2)
{
	if (str1 > str2)
	{
		return 1;
	}
	if (str1 < str2)
	{
		return -1;
	}
	return 0;
}

function boardon(boardid, element)
{
	hfClearSelState();
	hfSetSelState(boardid);
	lastselect = boardid;

	var boardid = boardid.split("-")[0];
	var friend = element.friendid;

	var boardgp;

	if (friend != null)
	{
		if (compareNum(boardid, friend) > 0)
		{
			boardgp = boardgrouplist[friend + boardid];
		}
		else
		{
			boardgp = boardgrouplist[boardid + friend];
		}
	}
	else
	{

		boardgp = boardgrouplist[boardid];
	}

	if (curboardgp != null)
	{
		if (curboardgp.ifslotid == boardgp.ifslotid)
		{

		}
	}

	curboardgp = boardgp;

	queryboardatt(boardgp);
}

/**
 * odu/if   
 */
function queryinfo(isInteval)
{
	if(isInteval && isInteval == "true")
	{
		if(!autoRefresh)
		{
			return;
		}
	}
	else
	{
		setQueryInfoInterval();
	}
	if (curboardgp != null)
	{
		queryboardatt(curboardgp);
	}
}

/**
 * if/odu board group
 */
function boardgroup()
{
	this.ifslotid = null;
	this.ifportid = null;
	this.ifphy = null;
	this.oduslotid = null;
	this.oduphy = null;

	this.ifname = null;
	this.oduname = "ODU";

	this.protecttype = null;

	this.iswork = null;
}

/**
 *     /     
 */

function queryboardatt(boardgp)
{
	setQuerybtn2Status(false);
	setApplybtn2Status(false);	
	
	setQuerybtn1Status(false);
	setApplybtn1Status(false);
	setfiesetname(boardgp);
	setinputalbe();
	var xmlstr = createQueryinfoXML(boardgp);
	var urlreq = "../../../../neExlorerServlet?sfid=" + query_oduif_params
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, updataInfo, boardgp, "inputdata=" + xmlstr);
}

/**
 *      /       
 */

function setfiesetname(boardgp)
{
	var dome = $("ifboard");
	dome.innerHTML = boardgp.ifname + "-" + boardgp.ifslotid;
	if (boardgp.ifportid != null)
	{
		dome.innerHTML += "-" + boardgp.ifportid;
	}
	dome = $("oduboard");
	dome.innerHTML = boardgp.oduname + "-" + boardgp.oduslotid;
}

/**
 *              
 */

function setinputalbe()
{

}

function createQueryinfoXML(boardgp)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");

	var row = new tagElement("row-params");
	var param = new tagElement("param");
	var neidvalue = neobject.neid;
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	param = new tagElement("param");
	var ifslotid = boardgp.ifslotid;
	param.setAttribute("name", "ifslotid");
	param.setAttribute("value", ifslotid);
	row.appendChild(param);
	
	param = new tagElement("param");
	var slotid = boardgp.oduslotid;
	param.setAttribute("name", "port");
	var ifportid = 1;

	if (boardgp.ifportid != null)
	{
		ifportid = boardgp.ifportid;
	}
	param.setAttribute("value", ifportid);
	row.appendChild(param);

	/**
	 * odu      
	 */
	if (boardgp.oduslotid != null)
	{
		param = new tagElement("param");
		var slotid = boardgp.oduslotid;
		param.setAttribute("name", "slotid");
		param.setAttribute("value", slotid);
		row.appendChild(param);
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();

}

function updataInfo(doc, boardgp)
{
	setQuerybtn2Status(true);	
	setQuerybtn1Status(true);
	var data = EncapsulateData(doc);

	if (data.getDataRowLength() > 0)
	{
		var wmSel = $("wmode");

		for ( var i = wmSel.options.length - 1; i >= 0; i--)
		{
			wmSel.remove(i);
		}
		var allMode = data.getDataRowParam(0, "workmode");
		if (null != allMode && "" != allMode)
		{
			if (parseInt(allMode) == -1)
			{
				wmSel.disabled = true;
			}
			else
			{
				wmSel.disabled = false;
				var wmodes = allMode.split("%"); //         
				var curwmode = parseInt(data.getDataRowParam(0,
						"W32PORT_ATTR_RADIOWORKMODE")); //         
				for ( var j = 0; j < wmodes.length; j++)
				{
					var wmode = wmodes[j];
					var modeId = parseInt(wmode
							.substring(0, wmode.indexOf(","))); //       ID
					var wmodeShow = modeId
							+ ") "
							+ wmode.substring(wmode.indexOf(",") + 1,
									wmode.length);
					wmSel.options[wmSel.options.length] = new Option(wmodeShow,
							modeId);

					if (modeId == curwmode)
					{
						wmSel.options.selectedIndex = j;
					}
				}
			}
		}
		else
		{
			wmSel.disabled = true;
		}

		var linkid = data.getDataRowParam(0, "W32PORT_ATTR_RADIOLINKID");
		if (linkid != null && parseInt(linkid) > 0)
		{
			$("linkid").value = linkid;
		}
		var reallinkid = data.getDataRowParam(0, "W32PORT_ATTR_RECRADIOLINKID");
		if (reallinkid != null && parseInt(reallinkid) >= 0)
		{
			$("reallinkid").value = reallinkid;
		}
		else
		{
			$("reallinkid").value = "";//               
		}
		var atpcenable = data.getDataRowParam(0, "W32PORT_ATTR_ATPCENABLE");
		if (atpcenable != null)
		{
			$("atpcenable").selectedIndex = atpcenable;
		}
		
		var atpclow = data.getDataRowParam(0, "W32PORT_ATTR_ATPCUPPER");
		var atpchigh = data.getDataRowParam(0, "W32PORT_ATTR_ATPCLOWER");
		atpclow = (atpclow - 65536) / 10;
		atpchigh = (atpchigh - 65536) / 10;

		var atpcautoenable = data.getDataRowParam(0,
				"W32PORT_ATTR_ATPCAUTOENABLE");
		if ("1" == atpcautoenable)
		{
			atpcautoenable = true;
		}
		else
		{
			atpcautoenable = false;
		}

		if (atpclow != null)
		{
			$("atpcrange").value = atpchigh + "~" + atpclow;
		}
		if (atpcautoenable == true)
		{
			var atpccurlow = data.getDataRowParam(0,
					"W32PORT_ATTR_ATPCCURTHUPPER");
			var atpccurhigh = data.getDataRowParam(0,
					"W32PORT_ATTR_ATPCCURTHLOWER");

			if ((null != atpccurlow && "/" != atpccurlow)
					&& ("" != atpccurlow && "-1" != atpccurlow))
			{
				atpccurlow = (atpccurlow - 65536) / 10;
				atpccurhigh = (atpccurhigh - 65536) / 10;
				$("atpcrange").value = atpccurhigh + "~" + atpccurlow;
			}
		}

		var atpcstep = data.getDataRowParam(0, "W32PORT_ATTR_ATPCADJUSTMENT");

		setselsimplevalue(data, atpcstep / 10, "atpcstep");

		var select = $("atpcstep");
		if (atpcenable == 0)
		{
			select.disabled = true;
		}
		else
		{
			select.disabled = false;
		}

		settxdirectvalue(data, "W32BRD_ATTR_TRANSMITFRE", "sendfre");

		atpclow = data.getDataRowParam(0, "LOWFRE");
		atpchigh = data.getDataRowParam(0, "W32BRD_ATTR_WORKRANGE");
		$("sendfrerange").value = atpclow + "~" + atpchigh;

		settxvalue(data, "W32BRD_ATTR_ACTTRANSMITFRE", "realsdfre");
		settxvalue(data, "W32BRD_ATTR_ACTTRECEIVEFRE", "realrefre");

		settxdirectvalue(data, "W32BRD_ATTR_TRINTERVAL", "trspace");
		settxvalue(data, "W32BRD_ATTR_ACTTRINTERVAL", "realtrspace");

		settxdirectvalue(data, "W32BRD_ATTR_TRANSMITPOWER", "sendpw");

		atpclow = data.getDataRowParam(0, "LOWPOWER");
		atpchigh = data.getDataRowParam(0, "W32BRD_ATTR_ACTRANGEOFPOWER");

		if(atpclow == "/" && atpchigh == "/")
		{
	    	 $("sendpwrange").value = "/";
		}
	    else
	    {
	    	 $("sendpwrange").value = atpclow + "~" + atpchigh;
	    } 

		settxvalue(data, "W32BRD_ATTR_ACTTRANSMITPOWER", "realsdpw");
		settxvalue(data, "W32BRD_ATTR_ACTRECEIVEPOWER", "realrepw");

		setselvalue(data, "W32BRD_ATTR_WORKSTATUS", "odusta");

		setrealSWITCHSTATUSvalue(data, "W32BRD_ATTR_SWITCHSTATUS", "realodusta");

		settxdirectvalue(data, "W32BRD_ATTR_FREQUENCY", "freseg");

		var value = data.getDataRowParam(0, "W32BRD_ATTR_QUIPTYPE");
		if (value == "5" || value == "10")
		{
			$("devtype").value = quipType[value];
		}
		settxdirectvalue(data, "W32BRD_ATTR_PRODUCESN", "serial");

		var value = data.getDataRowParam(0, "W32BRD_ATTR_HLSTATION");
		if (value == "5" || value == "10")
		{
			$("station").value = hlStation[value];
		}

		var value = data.getDataRowParam(0, "W32BRD_ATTR_POWEROUTPUT");
		if (value == "5" || value == "10")
		{
			$("powertype").value = powerGrade[value];
		}
	    refreshParamValue();
    }
    else
    {
	    lastParamValue = [];
    }
}

/**
 *   input = text ,dom    
 */
function settxdirectvalue(data, vname, domid)
{
	var value = data.getDataRowParam(0, vname);
	if (value != null)
	{
		$(domid).value = value;
	}
}

/**
 *   input = text ,dom    
 */
function settxvalue(data, vname, domid)
{
	var value = data.getDataRowParam(0, vname);
	if (value != null)
	{
		$(domid).value = value;
	}

}

/**
 *           
 */
function setrealSWITCHSTATUSvalue(data, vname, domid)
{
	var value = data.getDataRowParam(0, vname);
	if (value != null)
	{
		if (value == 0)
		{
			$(domid).value = switchStatus[0];
		}
		else if (value == 1)
		{
			$(domid).value = switchStatus[1];
		}
		else
		{
			$(domid).value = "";
		}
	}

}

/**
 *   input = select ,dom    
 */
function setselvalue(data, vname, domid)
{
	var value = data.getDataRowParam(0, vname);
	var select = $(domid);
	if (value != null && parseInt(value) >= 0)
	{
		for ( var i = 0; i < select.options.length; i++)
		{
			if (select.options[i].value == value)
			{
				select.options[i].selected = true;
				break;
			}
		}
	}

}

function setselsimplevalue(data, value, domid)
{
	var select = $(domid);
	if (value != null && parseInt(value) > 0)
	{
		for (i = 0; i < select.options.length; i++)
		{
			if (select.options[i].value == value)
			{
				select.options[i].selected = true;
				break;
			}
		}
	}

}

/**
 * odu      
 */
function applyodu()
{
	setQuerybtn2Status(false);
	setApplybtn2Status(false);
	var xmlstr = setoduinfoXML();

	var urlreq = "../../../../neExlorerServlet?sfid=" + apply_odu_params
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, updataodu, curboardgp, "inputdata="
			+ xmlstr);
}

function setoduinfoXML()
{
	if (curboardgp.oduslotid == null)
	{
		return;
	}

	 if (checkParamValueChange("sendfre") || checkParamValueChange("trspace")
		  || checkParamValueChange("sendpw") || checkParamValueChange("odusta"))
     { 	
		 if( confirm(RESOURCE["datamodifiedmsg"]) == false )
	     {
		    setQuerybtn2Status(true);
		    setApplybtn2Status(true);
		    return;
	     }
    }
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	createXMLparam(row, "neid", neobject.neid);

	createXMLparam(row, "slotid", curboardgp.oduslotid);

	var sendfre = getattvalue("sendfre");
	createXMLparam(row, "W32BRD_ATTR_TRANSMITFRE", sendfre * 1000);

	var trspace = getattvalue("trspace");
	createXMLparam(row, "W32BRD_ATTR_TRINTERVAL", trspace * 1000);

	var sendpw = getattvalue("sendpw");
	createXMLparam(row, "W32BRD_ATTR_TRANSMITPOWER", sendpw * 10);

	var odusta = getattvalue("odusta");
	createXMLparam(row, "W32BRD_ATTR_WORKSTATUS", odusta);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();

}

function applyif()
{
	setApplybtn1Status(false);
	setQuerybtn1Status(false);
	var xmlstr = setifinfoXML();

	var urlreq = "../../../../neExlorerServlet?sfid=" + apply_if_params
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, updataif, curboardgp, "inputdata="
			+ xmlstr);
}

function setifinfoXML()
{
	if (curboardgp.ifslotid == null)
	{
		return;
	}
	if (checkParamValueChange("linkid"))
	{ 	
		if( confirm(RESOURCE["datamodifiedmsg"]) == false )
		{
		   setApplybtn1Status(true);
		   setQuerybtn1Status(true);
		   return;
		}
    }

	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	createXMLparam(row, "neid", neobject.neid);

	createXMLparam(row, "slotid", curboardgp.ifslotid);
	if (curboardgp.ifportid != null)
	{
		createXMLparam(row, "port", curboardgp.ifportid);
	}

	var portselect = $("wmode");
	if (!portselect.disabled)
	{
		var portvalue = portselect.options[portselect.selectedIndex].value;
		createXMLparam(row, "W32PORT_ATTR_RADIOWORKMODE", portvalue);
	}

	var linkid = getattvalue("linkid");
	createXMLparam(row, "W32PORT_ATTR_RADIOLINKID", linkid);

	var atpcenable = getattvalue("atpcenable");
	createXMLparam(row, "W32PORT_ATTR_ATPCENABLE", atpcenable);

	if (atpcenable == 1)
	{
		var atpcstep = getattvalue("atpcstep");
		createXMLparam(row, "W32PORT_ATTR_ATPCADJUSTMENT", atpcstep * 10);
	}

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();

}

function updataif(doc)
{
	setQuerybtn1Status(true);
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() != 0)
	{
		showErrorDialog(data);

	}
  else
  {
  	setQueryInfoInterval();
  }
}

function updataodu(doc)
{
	setQuerybtn2Status(true);
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() != 0)
	{
		showErrorDialog(data);

	}
  else
  {
  	setQueryInfoInterval();
  }
}

function createXMLparam(row, name, value)
{
	param = new tagElement("param");
	param.setAttribute("name", name);
	param.setAttribute("value", value);
	row.appendChild(param);
}

function getattvalue(domid)
{
	return $(domid).value;
}

function valinum(domid, min, max)
{
	var e = $(domid);

	checkText(e, min, max, 3);
}

function valinum1(domid, min, max)
{
	var e = $(domid);

	checkText(e, min, max);
}

function forbidinput(domid)
{
	var e = $(domid);

	e.disabled = true;
}

function showErrorDialog(data)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", data.getError(), errArr);
}


function setQuerybtn2Status(status)
{
	if(btnRightArr.querybtn2.right)
	{
		$("querybtn2").disabled = !status;	
	}
}

function setApplybtn2Status(status)
{
	if(btnRightArr.applybtn2.right)
	{
		$("applybtn2").disabled = !status;	
	}
}

function setQuerybtn1Status(status)
{
	if(btnRightArr.querybtn1.right)
	{
	}
}

function setApplybtn1Status(status)
{
	if(btnRightArr.applybtn1.right)
	{
	}
}

var lastParamValue = [];
function refreshParamValue()
{
	lastParamValue = [];
	
	if(!$("wmode").disabled)
	{
		lastParamValue["wmode"] = $("wmode").value;
	}
	if(!$("odusta").disabled)
	{
		lastParamValue["odusta"] = $("odusta").value;
	}
	if(!$("linkid").disabled)
	{
		lastParamValue["linkid"] = $("linkid").value;
	}
	if(!$("sendfre").disabled)
	{
		lastParamValue["sendfre"] = $("sendfre").value;
	}
	if(!$("trspace").disabled)
	{
		lastParamValue["trspace"] = $("trspace").value;
	}
	if(!$("sendpw").disabled)
	{
		lastParamValue["sendpw"] = $("sendpw").value;
	}
}

function checkParamValueChange(name)
{
	var blResult = false;
	if(null != lastParamValue && typeof(lastParamValue[name]) != "undefined")
	{
		if($(name).value != lastParamValue[name])
		{
			blResult = true;
		}
	}
	return blResult;
}

