
var resourceMap;

/**
 **                   7M: 1,QPSK,10M% 2,16QAM, 20M% 3,32QAM, 25M% 4,64QAM, 32M% 5,128QAM, 38M% 6,256QAM, 44M;14M: 1,QPSK,10M% 2,16QAM, 20M% 3,32QAM, 25M% 4,64QAM, 32M% 5,128QAM, 38M% 6,256QAM, 44M
 **           ';'                       :                                                                                                %       
 **/
function parseServiceCapacity(data)
{    
    var serviceCapacity = data.getDataRowParam(0, "capacity");
    var bandWidth = data.getDataRowParam(0, "bandwidth");
    resourceMap = null;
 
    if(!isValid(serviceCapacity) || !isValid(bandWidth))
    {
        reStoreSource();
        return;
    }
    
    resourceMap = new Object();
    
    var arr1, arr2, arr3, modeResource;
    
    arr1 = serviceCapacity.split(';');
    for(var i = 0, iLen = arr1.length; i < iLen; i++)
    {
        arr2 = arr1[i].split(':');
        
        if(arr1[i].trim().length <= 0)
        {
            continue;
        }
        
        var tmpBandWidth;
        switch(arr2[0].trim())
        {
            case '7M':
                tmpBandWidth = 2;
                break;
            case '14M':
                tmpBandWidth = 3;
                break;
            case '28M':
                tmpBandWidth = 4;
                break;
            case '40M':
                tmpBandWidth = 5;
                break;
            case '56M':
                tmpBandWidth = 6;
                break;  
            case 'FCC30M':
                tmpBandWidth = 7;
                break;  
            case 'FCC40M':
                tmpBandWidth = 8;
                break;  
            case 'FCC50M':
                tmpBandWidth = 9;
                break;  
        }
        
        arr2 = arr2[1].trim().split('%')
        
        modeResource = new Object();
        var text;
        for(var j = 0, jLen = arr2.length; j < jLen; j++)
        {
            arr3 = arr2[j].trim().split(',');
            if(arr3.length < 3)
            {
            	continue;
            }
            switch(arr3[1].trim())
            {
                case 'QPSK':
                    modeResource[1] = "QPSK/" + arr3[2].trim() + 'bit/s';
                    break;
                case '16QAM':
                    modeResource[2] = "16QAM/" + arr3[2].trim() + 'bit/s';
                    break;
                case '32QAM':
                    modeResource[3] = "32QAM/" + arr3[2].trim() + 'bit/s';
                    break;
                case '64QAM':
                    modeResource[4] = "64QAM/" + arr3[2].trim() + 'bit/s';
                    break;
                case '128QAM':
                    modeResource[5] = "128QAM/" + arr3[2].trim() + 'bit/s';
                    break;
                case '256QAM':
                    modeResource[6] = "256QAM/" + arr3[2].trim() + 'bit/s';
                    break;
            }
        }
        
        resourceMap[tmpBandWidth] = modeResource;
    }
    
    updateBandWidthResource(bandWidth);
 }

/**
 **                           
 **                       
 **
 **/
function updateBandWidthResource(key)
{
    var resourceObj;
    if(resourceMap && resourceMap[key])
    {
        resourceObj = resourceMap[key];

        for(var i = 1; i <= 6; i++)
        {
            if(resourceObj[i])
            {
                RESOURCE['ensuremode' + i] = resourceObj[i];
            } else {
                RESOURCE['ensuremode' + i] = getModeText(i);
            }
        }
    }
}


/**
 **                         ,               updateBandWidthResource            
 **
 **/
function updateModeOptionText(obj)
{
    if(obj.options.length <= 0)
    {
        return;
    }
    
    for(var i = 0, len = obj.options.length; i < len; i++)
    {
        var value = obj.options[i].value;
        var text = obj.options[i].text;
        
        if(!RESOURCE['ensuremode' + value])
        {
            continue;
        }
        
        if(RESOURCE['ensuremode' + value] != text)
        {
            obj.options[i].text = RESOURCE['ensuremode' + value]
        }
    }
}

/**
 **                                 
 **
 **/
function reStoreSource()
{
    RESOURCE['ensuremode1'] = 'QPSK';
    RESOURCE['ensuremode2'] = '16QAM';
    RESOURCE['ensuremode3'] = '32QAM';
    RESOURCE['ensuremode4'] = '64QAM';
    RESOURCE['ensuremode5'] = '128QAM';
    RESOURCE['ensuremode6'] = '256QAM';
}

function getModeText(value)
{
    switch(value)
    {
        case 1:
            return 'QPSK';
        case 2:
            return '16QAM';
        case 3:
            return '32QAM';
        case 4:
            return '64QAM';
        case 5:
            return '128QAM';
        case 6:
            return '256QAM';
        default:
            return 'QPSK';
    
    }
}

function isValid(val)
{
    if(!val || val == '-1' || val == '255' || val == '/' || val == '-' || val == '')
    {
        return false;
    }
    
    return true;
}
