
var PERIOD_ALL = 0;
var PERIOD_15M = 1;
var PERIOD_24H = 2;
var NO_PERIOD = 3;

var PFM_TPT_ALL = 0;
var PFM_TPT_15ML = 1;
var PFM_TPT_15MH = 2;
var PFM_TPT_24H = 3;
var PFM_TPT_CSES = 4;

var PFM_MOT_15MM = 1;
var PFM_MOT_24HM = 2;
var PFM_MOT_15MR = 3;
var PFM_MOT_24HR = 4;

var PFM_ALL_EVENT = 0;

var EventType_Filter = new Object();
EventType_Filter["PFM_MNT_ALL"] = 0;
EventType_Filter["PFM_MNT_EC_RS"] = 1;
EventType_Filter["PFM_MNT_EC_MS"] = 2;
EventType_Filter["PFM_MNT_EC_HVC"] = 3;
EventType_Filter["PFM_MNT_EC_LVC"] = 4;
EventType_Filter["PFM_MNT_EC_OTH"] = 5;
EventType_Filter["PFM_MNT_PT_AU"] = 6;
EventType_Filter["PFM_MNT_PT_TU"] = 7;
EventType_Filter["PFM_MNT_FM_RS"] = 8;
EventType_Filter["PFM_MNT_CNT_OTH"] = 9;
EventType_Filter["PFM_MNT_OP_RCV"] = 10;
EventType_Filter["PFM_MNT_OP_SND"] = 11;
EventType_Filter["PFM_MNT_TP"] = 12;
EventType_Filter["PFM_MNT_TLB"] = 13;
EventType_Filter["PFM_MNT_CCV"] = 14;
EventType_Filter["PFM_MNT_PHY_OTH"] = 15;
EventType_Filter["PFM_MNT_CPU"] = 22;
EventType_Filter["PFM_MNT_IF"] = 23;
EventType_Filter["PFM_MNT_RADIO_TSL"] = 25;
EventType_Filter["PFM_MNT_RADIO_RSL"] = 24;
EventType_Filter["PFM_MNT_WAVE_LENGTH"] = 16;
EventType_Filter["PFM_MNT_WAVE_OFFSET"] = 17;
EventType_Filter["PFM_MNT_OSNR"] = 18;
EventType_Filter["PFM_MNT_EC_OSC"] = 19;
EventType_Filter["PFM_MNT_EC_OTU"] = 20;
EventType_Filter["PFM_MNT_EC_ODU"] = 21;
EventType_Filter["PFM_MNT_FEC"] = 34;
var Option_Filter = new Object();
Option_Filter["PFM_EXT_ZERO"] = 1;
Option_Filter["PFM_EXT_CUR"] = 2;
Option_Filter["PFM_EXT_MAX"] = 3;
Option_Filter["PFM_EXT_MIN"] = 4;
Option_Filter["PFM_EXT_CSES"] = 5;
Option_Filter["PFM_EXT_UAT"] = 6;
Option_Filter["PFM_FILTALL_EXORSUBEVENT"] = 100;

Option_Filter["PFM_QET_NONE"] = 0;
Option_Filter["PFM_QET_NOTENDED"] = 1;
Option_Filter["PFM_QET_ENDED"] = 2;
Option_Filter["PFM_QET_ALL"] = 3;

var FuncType_Filter = new Object();
FuncType_Filter["PFM_MNT_ALL"] = 0;
FuncType_Filter["PFM_MNT_EC_RS"] = 1;
FuncType_Filter["PFM_MNT_EC_MS"] = 2;
FuncType_Filter["PFM_MNT_EC_HVC"] = 3;
FuncType_Filter["PFM_MNT_EC_LVC"] = 4;
FuncType_Filter["PFM_MNT_EC_OTH"] = 5;
FuncType_Filter["PFM_MNT_PT_AU"] = 6;
FuncType_Filter["PFM_MNT_PT_TU"] = 7;
FuncType_Filter["PFM_MNT_FM_RS"] = 8;
FuncType_Filter["PFM_MNT_CNT_OTH"] = 9;
FuncType_Filter["PFM_MNT_OP_RCV"] = 10;
FuncType_Filter["PFM_MNT_OP_SND"] = 11;
FuncType_Filter["PFM_MNT_TP"] = 12;
FuncType_Filter["PFM_MNT_TLB"] = 13;
FuncType_Filter["PFM_MNT_CCV"] = 14;
FuncType_Filter["PFM_MNT_PHY_OTH"] = 15;
FuncType_Filter["PFM_MNT_IF"] = 23;
FuncType_Filter["PFM_MNT_OSC"] = 19;
FuncType_Filter["PFM_MNT_DDN"] = 24;
FuncType_Filter["PFM_MNT_EC_OTU"] = 20;
FuncType_Filter["PFM_MNT_EC_ODU"] = 21;


function newParam(name, value)
{
    var param = new tagElement("param");
    param.setAttribute("name", name);
    param.setAttribute("value", value);
    return param;
}

function addParam(row, param)
{
    row.appendChild(param);
}

function addParams(row, params)
{
    for (var i = 0; i < params.length; i++) 
    {
        addParam(row, params[i]);
    }
}

function TEPfmMonObjID()
{
    this.neID = -1;
    this.slotID = -1;
    this.fbType = -1;
    this.portID = -1;
    this.pathID = -1;
    
    this.name = "-";
    
    this.tostring = function()
    {
        return this.name;
    }
    
    this.toparams = function()
    {
        var params = new Array();
        params[0] = newParam("neID", this.neID);
        params[1] = newParam("slotID", this.slotID);
        params[2] = newParam("fbType", this.fbType);
        params[3] = newParam("portID", this.portID);
        params[4] = newParam("pathID", this.pathID);
        return params;
    }
}

function TEPfmBsEvent()
{
    this.m_usEventID;
    this.m_strEventName;
    this.m_groupID;
    this.m_usFBType;
    this.m_usMainType;
    this.m_usSubType;
    this.m_usExType;
    this.m_usThrType;
    this.m_usIsUAT;
    this.m_dMinThr15mLow;
    this.m_dMaxThr15mLow;
    this.m_dMinThr15mHigh;
    this.m_dMaxThr15mHigh;
    this.m_dMinThr24h;
    this.m_dMaxThr24h;
    this.m_dDefThr15mLow;
    this.m_dDefThr15mHigh;
    this.m_dDefThr24h;
    this.m_dUnit;
    this.m_strUnitName;
    this.m_usFstType;
    this.m_strPMParameterName;
}

function PfmFilter()
{
    this.GaugeEventType_CheckBox = null;
    this.GaugeEventType = null;
    
    this.CounterEventType_CheckBox = null;
    this.CounterEventType = null;
    
    this.OptionType_CheckBox = null;
    this.OptionType = null;
    
    this.periodType = null;
    
    this.pfmmonobjArr = new Array();
    
    this.beginTimeID = null;
    this.endTimeID = null;
    
    this.addPfmMonObj = function(obj)
    {
        this.pfmmonobjArr.push(obj);
    }
    
    this.getPfmMonObjArr = function()
    {
        return this.pfmmonobjArr;
    }
    this.hasCounterEventType = function()
    {
            for (var i = 0; i < this.GaugeEventType_CheckBox.length; i++) 
            {
                if (!$(this.GaugeEventType_CheckBox[i]).disabled) 
                {
                    return true;
                }
            }
            for (var i = 0; i < this.CounterEventType_CheckBox.length; i++) 
            {
                if (!$(this.CounterEventType_CheckBox[i]).disabled) 
                {
                    return true;
                }
            }
            return false;
        
    }
    this._getMainTypeList = function()
    {
        var strMainTypeList = "";
            for (var i = 0; i < this.GaugeEventType_CheckBox.length; i++) 
            {
                if ($(this.GaugeEventType_CheckBox[i]).checked) 
                {
                    strMainTypeList += EventType_Filter[this.GaugeEventType[i]];
                    strMainTypeList += "-";
                }
            }
            if ($("checkBoxOTHEREventType").checked) 
            {
                strMainTypeList += EventType_Filter["PFM_MNT_PHY_OTH"];
                strMainTypeList += "-";
            }
            for (var i = 0; i < this.CounterEventType_CheckBox.length; i++) 
            {
                if ($(this.CounterEventType_CheckBox[i]).checked) 
                {
                    strMainTypeList += EventType_Filter[this.CounterEventType[i]];
                    strMainTypeList += "-";
                }
            }
            if ($("checkBoxOTHERErrorEventType").checked) 
            {
                strMainTypeList += EventType_Filter["PFM_MNT_EC_OTH"];
                strMainTypeList += "-";
                
            }
        
        if ("" == strMainTypeList) 
        {
            strMainTypeList = EventType_Filter["PFM_MNT_ALL"];
        }
        else 
        {
            strMainTypeList = strMainTypeList.substring(0, strMainTypeList.length - 1);
        }
        return strMainTypeList;
    }
    
    this._getExtTypeList = function()
    {
        var strExtTypeList = "";
            for (var i = 0; i < 2; i++) 
            {
                if ($(this.OptionType_CheckBox[i]).checked) 
                {
                    strExtTypeList += Option_Filter[this.OptionType[i]];
                    strExtTypeList += "-";
                    if (this.OptionType[i] == "PFM_EXT_MAX") 
                    {
                        strExtTypeList += Option_Filter["PFM_EXT_MIN"];
                        strExtTypeList += "-";
                    }
                }
            }
            for (var i = 2; i < this.OptionType_CheckBox.length; i++) 
            {
                if ($(this.OptionType_CheckBox[i]).checked) 
                {
                    strExtTypeList += Option_Filter[this.OptionType[i]];
                    strExtTypeList += "-";
                }
            }
        
        if ("" == strExtTypeList) 
        {
            strExtTypeList = Option_Filter["PFM_FILTALL_EXORSUBEVENT"];
        }
        else 
        {
            strExtTypeList = strExtTypeList.substring(0, strExtTypeList.length - 1);
        }
        return strExtTypeList;
    }
    
    this._getSubTypeList = function()
    {
        return PFM_ALL_EVENT;
    }
    
    this._getPeriodType = function()
    {
        var radioObj = document.getElementsByName("radiobtn");
        for (var i = 0; i < radioObj.length; i++) 
        {
            if (radioObj[i].checked) 
            {
                this.periodType = radioObj[i].value;
            }
        }
        if ($("counterDiv") != null && $("counterDiv").style.display != "none" 
			&& $("checkBoxShowCSESOption") != null && $("checkBoxShowCSESOption").checked) 
        {
            this.periodType += "-";
            this.periodType += NO_PERIOD;
        }
        return this.periodType;
    }
    
    this._getBeginTime = function()
    {
        if ($(this.beginTimeID) != null) 
        {
            return getTimeFromString($(this.beginTimeID).value, STANDARD_FORMAT);
        }
        return "";
    }
    
    this._getEndTime = function()
    {
        if ($(this.endTimeID) != null) 
        {
            return getTimeFromString($(this.endTimeID).value, STANDARD_FORMAT);
        }
        return "";
    }
    
    this._ShowZeroData = function()
    {
        var ZeroData = false;
        if ($("checkBoxSuprsZeroDataOption").checked && $("counterDiv").style.display == "inline") 
        {
            ZeroData = true;
        }
        return ZeroData;
    }
    this._disableAllEventTypes = function()
    {
        for (var k = 0; k < this.GaugeEventType_CheckBox.length; k++) 
        {
            $(this.GaugeEventType_CheckBox[k]).disabled = true;
            $(this.GaugeEventType_CheckBox[k] + "_Text").disabled = true;
            $(this.GaugeEventType_CheckBox[k]).checked = false;
        }
        
        $("checkBoxOTHEREventType").disabled = true;
        $("checkBoxOTHEREventType_Text").disabled = true;
        $("checkBoxOTHEREventType").checked = false;
        
        for (var j = 0; j < this.CounterEventType_CheckBox.length; j++) 
        {
            $(this.CounterEventType_CheckBox[j]).disabled = true;
            $(this.CounterEventType_CheckBox[j] + "_Text").disabled = true;
            $(this.CounterEventType_CheckBox[j]).checked = false;
        }
        
        $("checkBoxOTHERErrorEventType").disabled = true;
        $("checkBoxOTHERErrorEventType_Text").disabled = true;
        $("checkBoxOTHERErrorEventType").checked = false;
    }
    
    this.filterUnsupportedEventTypes = function(eventList)
    {
        this._disableAllEventTypes();
        if ((null == eventList) || ("" == eventList)) 
        {
            return;
        }
        var events = eventList.split("-");
        
        for (var i = 0; i < events.length; i++) 
        {
        
            if (events[i] == EventType_Filter["PFM_MNT_PHY_OTH"]) 
            {
                $("checkBoxOTHEREventType").disabled = false;
                $("checkBoxOTHEREventType").checked = true;
                $("checkBoxOTHEREventType_Text").disabled = false;
            }
            
            if (events[i] == EventType_Filter["PFM_MNT_EC_OTH"] || events[i] == EventType_Filter["PFM_MNT_EC_HVC"]) 
            {
                $("checkBoxOTHERErrorEventType").disabled = false;
                $("checkBoxOTHERErrorEventType").checked = true;
                $("checkBoxOTHERErrorEventType_Text").disabled = false;
            }
            
            for (var k = 0; k < this.GaugeEventType_CheckBox.length; k++) 
            {
                if (events[i] == EventType_Filter[this.GaugeEventType[k]]) 
                {
                    $(this.GaugeEventType_CheckBox[k]).disabled = false;
                    $(this.GaugeEventType_CheckBox[k]).checked = true;
                    $(this.GaugeEventType_CheckBox[k] + "_Text").disabled = false;
                    break;
                }
            }
            
            for (var j = 0; j < this.CounterEventType_CheckBox.length; j++) 
            {
                if (events[i] == EventType_Filter[this.CounterEventType[j]]) 
                {
                    $(this.CounterEventType_CheckBox[j]).disabled = false;
                    $(this.CounterEventType_CheckBox[j]).checked = true;
                    $(this.CounterEventType_CheckBox[j] + "_Text").disabled = false;
                    break;
                }
            }
        }
    }
    
    this.toRowParmas = function()
    {
        var rowArr = new Array();
        for (var i = 0; i < this.pfmmonobjArr.length; i++) 
        {
            var pfmmonobj = this.pfmmonobjArr[i];
            var row = new tagElement("row-params");
            if (pfmmonobj == null) 
            {
                alert(RESOURCE["monobject"]);
                return null;
            }
            addParams(row, pfmmonobj.toparams());
			if(!this.hasCounterEventType())
			{
				alert(RESOURCE["boardnotsupport"]);
                return null;
			}
            if (0 == this._getMainTypeList()) 
            {
                alert(RESOURCE["selectmaintype"]);
                return null;
            }
            addParam(row, newParam("period", this._getPeriodType()));
            addParam(row, newParam("mainType", this._getMainTypeList()));
            addParam(row, newParam("extType", this._getExtTypeList()));
            addParam(row, newParam("subType", this._getSubTypeList()));
            addParam(row, newParam("beginTime", this._getBeginTime()));
            addParam(row, newParam("endTime", this._getEndTime()));
            addParam(row, newParam("ZeroData", this._ShowZeroData()));
            rowArr.push(row);
        }
        return rowArr;
    }
}
