/**
*            
*/
loadXMLdoc("../../../../conf/system.xml", "GET",false, EncapsulateSConf);
language = SYSTEMCONF.getLanguage();
getResourse("../../../../res/commonres_"+ language +".xml");
    
getResourse("../../res/if1plus1/if1plus1res_"+ language +".xml");
document.title = RESOURCE["createif1plus1"];

var DEFAULTGROUPID = 1; //          
var REVERTIVWTRTIME = 600; //                 
var NONREVERTIVWTRTIME = 0; //               
var wMode = new Object(); //      
wMode.SD = "SD";
wMode.FD = "FD";
wMode.HSB = "HSB"; 
  
var board = new Object(); //              
var boardList = null; //              
var win = getParentWindow(); //         
var neid = win.neid;
var ct = null; //CTable    
var isSuccess = false; //             
var hasApplied = false; //                 

var MIN_PGID = "1";
var MAX_PGID = "3";

/**
*         
*/
function init()   
{
    sendGetAvailableResourceInfo();
	
    ct = new CTable();
    ct.addHead(RESOURCE["attr"],RESOURCE["value"]);

    var pGIdAtom = new Atom("text");
    pGIdAtom.element.setAttribute("id", "htmlTableTextCrtIf1plus1Groupid");
    checkText(pGIdAtom.element,MIN_PGID,MAX_PGID);  
    pGIdAtom.element.style.width="100%";
    ct.addAttrRow("groupid",RESOURCE["groupid"],pGIdAtom);
 
    var wModeAtom = new Atom("select");
    wModeAtom.element.setAttribute("id", "htmlTableSelectCrtIf1plus1WMode");
    for (var j = wModeAtom.element.options.length - 1; j >= 0; j--)
    {
        wModeAtom.element.options[j] = null;
    } 
    wModeAtom.addOption(wMode.SD,"0");
    wModeAtom.addOption(wMode.FD,"1");
    wModeAtom.addOption(wMode.HSB,"2");
    wModeAtom.element.selectedIndex = 2;
    wModeAtom.element.style.width="100%";
    ct.addAttrRow("wmode",RESOURCE["wmode"],wModeAtom);

    wModeAtom.element["onchange"] = function()
    {
        var switchEnableAtom = ct.getAtom("switchenable");        
        if ( this.value == 1 )
        {
            switchEnableAtom.element.disabled = true;
			switchEnableAtom.element.selectedIndex = 0;
        }
        else
        {
            switchEnableAtom.element.disabled = false;
			switchEnableAtom.element.selectedIndex = 1;			
        } 
        $("applyBtn").disabled = false;
        $("okBtn").disabled = false;
    }

    var rModeAtom = new Atom("select");
    rModeAtom.element.setAttribute("id", "htmlTableSelectCrtIf1plus1RMode");
    for (var j = rModeAtom.element.options.length - 1; j >= 0; j--)
    {
        rModeAtom.element.options[j] = null;
    }
    rModeAtom.addOption(RESOURCE["revertivemode"],"1");//            
    rModeAtom.addOption(RESOURCE["nonrevertivemode"],"0");
    rModeAtom.element.selectedIndex = 0;
    rModeAtom.element.style.width="100%";
    ct.addAttrRow("rmode",RESOURCE["rmode"],rModeAtom);

    var wtrTimeAtom = new Atom("text"); 
    wtrTimeAtom.element.setAttribute("id", "htmlTableTextCrtIf1plus1Wtrtime");
    wtrTimeAtom.element.style.width = "100%";
    wtrTimeAtom.setValue(REVERTIVWTRTIME);//                600s
    wtrTimeAtom.element.disabled = false;

    checkText(wtrTimeAtom.element,"300","720");  

    ct.addAttrRow("wtrtime",RESOURCE["wtrtime"],wtrTimeAtom);

    rModeAtom.element["onchange"] = function()
    {
        var wtrtime = ct.getAtom("wtrtime");
        if(this.value == 0)
        {
            wtrtime.element.disabled = true;
            wtrtime.setValue(0);
        }
        else
        {
            wtrtime.element.disabled = false;
            wtrTimeAtom.setValue(REVERTIVWTRTIME);//                600s		
        }
        $("applyBtn").disabled = false;
        $("okBtn").disabled = false;
    }  

    var switchEnableAtom = new Atom("select");
    switchEnableAtom.element.setAttribute("id", "htmlTableSelectCrtIf1plus1Switchenable");
    for (var j = switchEnableAtom.element.options.length - 1; j >= 0; j--)
    {
        switchEnableAtom.element.options[j] = null;
    }
    switchEnableAtom.addOption(RESOURCE["disable"],"0");
    switchEnableAtom.addOption(RESOURCE["enable"],"1");
    switchEnableAtom.element.selectedIndex = 1;
    switchEnableAtom.element.style.width = "100%";
    ct.addAttrRow("switchenable",RESOURCE["switchenable"],switchEnableAtom);

    switchEnableAtom.element["onchange"] = function()
    {
        $("applyBtn").disabled = false;
        $("okBtn").disabled = false;
    }

    var workingBoardAtom = new Atom("select");
    workingBoardAtom.element.setAttribute("id", "htmlTableSelectCrtIf1plus1WorkingBoard");
    for (var j = workingBoardAtom.element.options.length - 1; j >= 0; j--)
    {
        workingBoardAtom.element.options[j] = null;
    }

    var workBoardList = new Array();
    for(var i = 0,len = boardList.length;i < len;i++)  //                  
    {
        if (!workBoardList.contains(boardList[i].slotID.value))
        {
            workingBoardAtom.addOption(
                boardList[i].slotID.value + "-" + boardList[i].boardName.value, boardList[i].slotID.value);
				workBoardList.append(boardList[i].slotID.value, true);
        }
    }
    workingBoardAtom.element.style.width = "100%";
    ct.addAttrRow("workingboard",RESOURCE["workingboard"],workingBoardAtom);

    workingBoardAtom.element["onchange"] = function()
    {
        $("applyBtn").disabled = false;
        $("okBtn").disabled = false;
	
        for (var j = workingPortAtom.element.options.length - 1; j >= 0; j--)
        {
            workingPortAtom.element.options[j] = null;
        }
  
        for(var i = 0,len = boardList.length;i < len;i++)  //                  
        {
            if (this.value == boardList[i].slotID.value)
            {
                workingPortAtom.addOption(boardList[i].portName.value, boardList[i].portID.value);
            }
        }
    } 

    var workingPortAtom = new Atom("select");
    workingPortAtom.element.setAttribute("id", "htmlTableSelectCrtIf1plus1WorkingPort");
    for (var j = workingPortAtom.element.options.length - 1; j >= 0; j--)
    {
        workingPortAtom.element.options[j] = null;
    }
    for(var i = 0,len = boardList.length;i < len;i++)  //                  
    {
        if (ct.getAttrValue("workingboard") == boardList[i].slotID.value)
        {
            workingPortAtom.addOption(boardList[i].portName.value, boardList[i].portID.value);
        }  
    }
    workingPortAtom.element.style.width = "100%";
    ct.addAttrRow("workingport",RESOURCE["workingport"],workingPortAtom);

    workingPortAtom.element["onchange"] = function()
    {
        $("applyBtn").disabled = false;
        $("okBtn").disabled = false;
    }

    var protectionBoardAtom = new Atom("select");
    protectionBoardAtom.element.setAttribute("id", "htmlTableSelectCrtIf1plus1ProBoard");
    for (var j = protectionBoardAtom.element.options.length - 1; j >= 0; j--)
    {
        protectionBoardAtom.element.options[j] = null;
    }

    var protectionBoardList = new Array();  
    for(var i = 0,len = boardList.length;i < len;i++)  //                  
    {
        if (!protectionBoardList.contains(boardList[i].slotID.value))
        {
            protectionBoardAtom.addOption(
                boardList[i].slotID.value + "-" + boardList[i].boardName.value, boardList[i].slotID.value);
                protectionBoardList.append(boardList[i].slotID.value, true);
        }
    }
    protectionBoardAtom.element.style.width = "100%";
    ct.addAttrRow("protectionboard",RESOURCE["protectionboard"],protectionBoardAtom);

    protectionBoardAtom.element["onchange"] = function()
    {
        $("applyBtn").disabled = false;
        $("okBtn").disabled = false;
	
        for (var j = protectionPortAtom.element.options.length - 1; j >= 0; j--)
        {
            protectionPortAtom.element.options[j] = null;
        }
  
        for(var i = 0,len = boardList.length;i < len;i++)  //                  
        {
            if (this.value == boardList[i].slotID.value)
            {
                protectionPortAtom.addOption(boardList[i].portName.value, boardList[i].portID.value);
            }
        }
    }

    var protectionPortAtom = new Atom("select");
    protectionPortAtom.element.setAttribute("id", "htmlTableSelectCrtIf1plus1ProPort");
    for (var j = protectionPortAtom.element.options.length - 1; j >= 0; j--)
    {
        protectionPortAtom.element.options[j] = null;
    }
    for(var i = 0,len = boardList.length;i < len;i++)  //                  
    {
        if (ct.getAttrValue("protectionboard") == boardList[i].slotID.value)
        {
            protectionPortAtom.addOption(boardList[i].portName.value, boardList[i].portID.value);
        } 
    }
    protectionPortAtom.element.style.width = "100%";
    ct.addAttrRow("protectionport",RESOURCE["protectionport"],protectionPortAtom);

    protectionPortAtom.element["onchange"] = function()
    {
        $("applyBtn").disabled = false;
        $("okBtn").disabled = false;
    }

    document.body.appendChild(ct.getTable());
}

/**
*              
*/
function sendGetAvailableResourceInfo()
{
    var xmlstr = createGetAvailableResXML();	
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_GET_BOARD_RES+"&flag=1";
    loadXMLdoc(urlreq,"POST",false,refreshGetAvailableRes,null,"inputdata="+xmlstr);
}

/**
*                  
*/
function createGetAvailableResXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);

    return di.toString();
}

/**
*                   
*/
function refreshGetAvailableRes(doc)
{   
    boardList = new Array();
    var dinterface = EncapsulateData(doc);

    if((null == dinterface.getSErrorCode())||(0 == dinterface.getSErrorCode()))
    {
        for(var i = 0,len = dinterface.getDataRowLength();i < len;i++)
        {
            var tmpPort = new Object();
            var obj = dinterface.rows[i];
            tmpPort.slotID = obj["slotId"];
            tmpPort.boardType = obj["boardType"];
            tmpPort.boardName = obj["boardName"];

            tmpPort.subSlotID = obj["subSlotId"];
            tmpPort.subBoardType = obj["subBoardType"];
            tmpPort.subBoardName = obj["subBoardName"];

            tmpPort.portID = obj["portID"];
            tmpPort.portType = obj["portType"];
            tmpPort.portName = obj["portName"];

            boardList.append(tmpPort);
        }
    }
} 
   
/**
*                         
*/
function sendApplyInfo()
{
    var xmlstr = createCreateIf1Plus1XML(); //            			
    var urlreq ="../../../../neExlorerServlet?sfid="+NSCMD_CFG_ADD_RADIO_1J1PG+"&nmUser="+win.obj["nmUser"];		
    loadXMLdoc(urlreq, "POST",false,openCreateErrDialog,null,"inputdata="+xmlstr);   	
}

/**
*                          
*/
function sendConfirmInfo()
{
    sendApplyInfo();
    if(true == isSuccess)//         
    {
        closeClick();
    }	
}

function closeClick()
{	
    xcloseDialog();
}

/**
*                  
*/
function createCreateIf1Plus1XML ()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
		
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    var param = new tagElement("param");
    var groupIdValue = ct.getAttrValue("groupid");
    if (groupIdValue == "")
    {
    	  alert(RESOURCE["inputPGID"]);
    }
    param.setAttribute("name","groupId");
    param.setAttribute("value", groupIdValue);
    row.appendChild(param);
		
    param = new tagElement("param");
    var workingBoardInfo = ct.getAttrValue("workingboard");  //          
    var workingSlotIdValue = workingBoardInfo.split("-")[0];  //        
    param.setAttribute("name","workingSlotId");
    param.setAttribute("value", workingSlotIdValue);
    row.appendChild(param);
  			
    param = new tagElement("param"); 			
    param.setAttribute("name","workingSubSlotId");
    param.setAttribute("value", 0xff);
    row.appendChild(param);
  			
    param = new tagElement("param");
    var workingPortInfo = ct.getAttrValue("workingport");  //          
    var workingPortIdValue = workingPortInfo.split("-")[0];  //        
    param.setAttribute("name","workingPortId");
    param.setAttribute("value", workingPortIdValue);
    row.appendChild(param);  			
		
    param = new tagElement("param");
    var protectionBoardInfo = ct.getAttrValue("protectionboard");  //          
    var protectionSlotIdValue = protectionBoardInfo.split("-")[0];  //        
    param.setAttribute("name","protectionSlotId");
    param.setAttribute("value", protectionSlotIdValue);
    row.appendChild(param);
  			
    param = new tagElement("param"); 			
    param.setAttribute("name","protectionSubSlotId");
    param.setAttribute("value", 0xff);
    row.appendChild(param);
  			
    param = new tagElement("param");
    var protectionPortInfo = ct.getAttrValue("protectionport");  //          
    var protectionPortIdValue = protectionPortInfo.split("-")[0];  //        
    param.setAttribute("name","protectionPortId");
    param.setAttribute("value", protectionPortIdValue);
    row.appendChild(param);  		
		
    param = new tagElement("param");
    var workModeValue = ct.getAttrValue("wmode");
    param.setAttribute("name","wMode");
    param.setAttribute("value", workModeValue);
    row.appendChild(param);
		
    param = new tagElement("param");
    var revertiveModeValue = ct.getAttrValue("rmode");
    param.setAttribute("name","rMode");
    param.setAttribute("value", revertiveModeValue);
    row.appendChild(param);
		
    param = new tagElement("param");
    var wtrTimeValue = ct.getAttrValue("wtrtime");
    param.setAttribute("name","wtrTime");
    param.setAttribute("value", wtrTimeValue);
    row.appendChild(param);
		
    if (workModeValue != 1)
    {
        param = new tagElement("param");
        var switchEnableValue = ct.getAttrValue("switchenable");
        param.setAttribute("name","switchEnable");
        param.setAttribute("value", switchEnableValue);
        row.appendChild(param);
    }
		
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
		
    return di.toString();
}

/**
*        1+1            
*/
function openCreateErrDialog(doc)
{
    var dinterface  = EncapsulateData(doc);

    if(0 != dinterface.getSErrorCode()) 
    {
        isSuccess = false;	
        hasApplied = false;	
        showErrorDialog(dinterface);
        return ;
    }

    $("applyBtn").disabled = true;
    isSuccess = true;
    hasApplied = true;		
    win.refresh();		
}

/**
*         
*/
function initBtn()
{
    $("okBtn").value = RESOURCE["okbutton"];
    $("cancelBtn").value = RESOURCE["cancelbutton"];
    $("applyBtn").value = RESOURCE["applybutton"];
    if("" == ct.getAttrValue("workingboard") || "" == ct.getAttrValue("protectionboard"))
    {
        $("okBtn").disabled = true;
        $("applyBtn").disabled = true;
    }
}

function showErrorDialog(dinterface)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../page/", dinterface.getError(), errArr);
}
