var netype = win.netype;

var RTN_905 = "95";
/**
 * FO R1C01      1+1    
 *                  
 * 1         
 * 2     
 * 3     
 * 
 *   FO                             
 */
function init()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attr"], RESOURCE["value"]);
	
	/**
	 *       
	 * 0-noprot       
	 * 1-lagprot LAG       
	 * 2-splitprot           
	 * 0xff-   
	 * RTN310V1R1C01                  LAG       
	 * RTN380V1R1C00             
	 * RTN900R5C01    0xff
     */	
	var wModeAtom = new Atom("select");
	ct.addAttrRow("wmode", RESOURCE["wmode"], wModeAtom);

	var rModeAtom = new Atom("select");
	ct.addAttrRow("rmode", RESOURCE["rmode"], rModeAtom);

	var wtrTimeAtom = new Atom("text");
	ct.addAttrRow("wtrtime", RESOURCE["wtrtime"], wtrTimeAtom);

	var switchEnableAtom = new Atom("select");
	ct.addAttrRow("switchenable", RESOURCE["switchenable"], switchEnableAtom);
	/**
	 *         :0      1     
	 */
	var workprounitAtom = new Atom("select");
	ct.addAttrRow("workprounit", RESOURCE["workprounit"], workprounitAtom);
    
	/**
	 *     
	 */	
	var ifportAtom = new Atom("select");
	ct.addAttrRow("ifport", RESOURCE["ifport"], ifportAtom);	

	document.getElementById("ctable").appendChild(ct.getTable());
	initTableData();
}

/**
 *          
 */
function initTableData()
{
	/**
	 *           
	 */
	sendGetAvailableResourceInfo(IF_BOARD_PORT_1PLUS1,PORT_TYPE_RESOURCE,getIFPortAvailableResCallBack);

	var wModeAtom = ct.getAtom("wmode");
	for ( var j = wModeAtom.element.options.length - 1; j >= 0; j--)
	{
		wModeAtom.element.options[j] = null;
	}
	wModeAtom.addOption(wMode.SD, "0");
	wModeAtom.addOption(wMode.FD, "1");
	wModeAtom.addOption(wMode.HSB, "2");
	wModeAtom.element.selectedIndex = 2;

	wModeAtom.element["onchange"] = function()
	{
		var switchEnableAtom = ct.getAtom("switchenable");
		var workprounitAtom = ct.getAtom("workprounit");

		if (this.value == 1)
		{
			switchEnableAtom.element.disabled = true;
		}
		else//       SD/HSB 
		{
			if(workprounitAtom.getValue() == 1)
			{
				switchEnableAtom.element.disabled = true;
			}else{
				switchEnableAtom.element.disabled = false;
			}			
		}
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}

	var rModeAtom = ct.getAtom("rmode");
	for ( var j = rModeAtom.element.options.length - 1; j >= 0; j--)
	{
		rModeAtom.element.options[j] = null;
	}
	rModeAtom.addOption(RESOURCE["revertivemode"], "1");
	rModeAtom.addOption(RESOURCE["nonrevertivemode"], "0");
	rModeAtom.element.selectedIndex = 0;
	rModeAtom.element.style.width = "100%";

	var wtrTimeAtom = ct.getAtom("wtrtime");
	wtrTimeAtom.element.style.width = "100%";
	wtrTimeAtom.setValue(REVERTIVWTRTIME);
	wtrTimeAtom.element.disabled = false;

	checkText(wtrTimeAtom.element, "300", "720");

	rModeAtom.element["onchange"] = function()
	{
		var wtrtime = ct.getAtom("wtrtime");
		if (this.value == 0)
		{
			wtrtime.element.disabled = true;
			wtrtime.setValue("-");
		}
		else
		{
			wtrtime.element.disabled = false;
			wtrTimeAtom.setValue(REVERTIVWTRTIME);

		}
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}

	var switchEnableAtom = ct.getAtom("switchenable");
	for ( var j = switchEnableAtom.element.options.length - 1; j >= 0; j--)
	{
		switchEnableAtom.element.options[j] = null;
	}
	switchEnableAtom.addOption(RESOURCE["disable"], "0");
	switchEnableAtom.addOption(RESOURCE["enable"], "1");
	switchEnableAtom.element.selectedIndex = 1;
	switchEnableAtom.element.style.width = "100%";

	switchEnableAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}
	var workprounitAtom = ct.getAtom("workprounit");
	workprounitAtom.element.options.length = 0;
	workprounitAtom.addOption(RESOURCE["workunit"], "0");
	workprounitAtom.addOption(RESOURCE["protectetunit"], "1");
	workprounitAtom.element.style.width = "100%";	
	
	workprounitAtom.element["onchange"] = function()
	{
		var wmode = ct.getAtom("wmode");
		var switchEnableAtom = ct.getAtom("switchenable");
		if(this.value == 1)
		{			
			switchEnableAtom.element.disabled = true;
		}else {
			if(wmode.getValue() == 1)
			{
				switchEnableAtom.element.disabled = true;
			}else{
				switchEnableAtom.element.disabled = false;
			}				
		}
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}
}

/**
 *          FO    RTN         
 */
function createCreateIf1Plus1XML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	/**
	 *   QX         :   1
	 */
	var param = new tagElement("param");
	param.setAttribute("name", "groupId");
	param.setAttribute("value", "1");
	row.appendChild(param);
	param = new tagElement("param");
	var ifport = JSON.parse(ct.getAttrValue("ifport"));
	param.setAttribute("name", "ifSlotId");
	param.setAttribute("value", ifport.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "ifPortId");
	param.setAttribute("value", ifport.portId);
	row.appendChild(param);

	param = new tagElement("param", "srvpgType", 255);
	row.appendChild(param);
	param = new tagElement("param", "SrvPortnum", 0);
	row.appendChild(param);
	
	param = new tagElement("param");
	var workprounitValue = ct.getAttrValue("workprounit");
	param.setAttribute("name", "role");
	param.setAttribute("value", workprounitValue);
	row.appendChild(param);
	/**
	 *      
	 * 0  SD
	 * 1 FD
	 * 2 HSB E-Band   HSB 
	 */
	param = new tagElement("param");
	var revertiveModeValue = ct.getAttrValue("wmode");
	param.setAttribute("name", "pgType");
	param.setAttribute("value", revertiveModeValue);
	row.appendChild(param);
	/**
	 *        
	 * 0-    Norvt      
	 * 1-    Rvt     (  )
	 */
	param = new tagElement("param");
	var revertiveModeValue = ct.getAttrValue("rmode");
	param.setAttribute("name", "rvtmode");
	param.setAttribute("value", revertiveModeValue);
	row.appendChild(param);
	
	param = new tagElement("param");	
	var wtrTimeValue = ct.getAttrValue("wtrtime");
	/**
	 *                       0x00
	 */
	if(wtrTimeValue=="-")
	{
		wtrTimeValue=0;
	}
	param.setAttribute("name", "rvtTime");
	param.setAttribute("value", wtrTimeValue);
	row.appendChild(param);
	
	if(!ct.getAtom("switchenable").element.disabled)
	{
		param = new tagElement("param");	
		var switchenableValue = ct.getAttrValue("switchenable");
		param.setAttribute("name", "switchEnable");
		param.setAttribute("value", switchenableValue);
		row.appendChild(param);
	}
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}
