var winurlobj = getParentWindow();
var avaiPortList = winurlobj.avaiPortList;
var allPortList = winurlobj.portList;
var usedPortList = winurlobj.usedPortList;

window.onload = function()
{	  	
	initButtonText();
    initDate();
}

function initButtonText()
{ 
	$("intersel1").innerHTML = RESOURCE["availablePort"];	
	$("intersel2").innerHTML = RESOURCE["selectedPort"];	
	$("okbtn").value = RESOURCE["okbutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];	
	$("applybtn").value = RESOURCE["applybutton"];
	$("rightmovebtn").disabled = true;
	$("leftmovebtn").disabled = true;
}

function initDate()
{
	$("right").options.length = 0;
	$("left").options.length = 0;

	usedPortList = sortPortList(usedPortList);
	avaiPortList = sortPortList(avaiPortList);
	
	var option;
	for(var i = 0, length = usedPortList.length; i < length; i ++)
	{
		option = document.createElement("OPTION");
		option.text = usedPortList[i].portname;
		option.value = JSON.stringify(usedPortList[i]);
		$("right").options.add(option);
	}
	
	for(var i = 0, length = avaiPortList.length; i <length; i ++)
	{
		option = document.createElement("OPTION");
		option.text = avaiPortList[i].portname;
		option.value = JSON.stringify(avaiPortList[i]);
		$("left").options.add(option);
	}
}

function sortPortList(portList)
{
	var sortPortList = [];
	var length = portList.length;
	
	if(length > 1)
	{
		var tmpPort;
		var comp;
		for(var i = 0; i < length - 1; i++)
		{
			tmpPort = portList[i+1];
			comp = portList[i].portId - tmpPort.portId;
			if(comp > 1)
			{
				portList[i+1] = portList[i];
				portList[i] = tmpPort;
			}
		}
	}	
	
	sortPortList = portList;
	return sortPortList;
}

function compare(value1, value2)
{
	  var v1 = value1.substring(0, value1.indexOf("-"));
	  var v2 = value2.substring(0, value2.indexOf("-"));
	  if(parseInt(v1) == parseInt(v2))
	  {
	  	  var v11 = value1.substring(value1.lastIndexOf("-") + 1, value1.indexOf("("));
	  	  var v22 = value2.substring(value2.lastIndexOf("-") + 1, value2.indexOf("("));
	  	  return v11 - v22;   	
	  }
	  return v1- v2; 	
}

function isLeftSelect()
{
	var flag = false;
    var slt1 = document.getElementById("left");
    for (var i = 0; i < slt1.options.length; i++)
    {
        if (slt1.options[i].selected)
        {
        	flag = true;
        	$("rightmovebtn").disabled = false;
            break;
        }
    }
    
    if (!flag)
    {
    	$("rightmovebtn").disabled = true;
    }
}

function isRightSelect()
{
	var flag = false;
    var slt2 = document.getElementById("right");
    for (var i = 0; i < slt2.options.length; i++)
    {
        if (slt2.options[i].selected)
        {
        	flag = true;
        	$("leftmovebtn").disabled = false;
            break;
        }
    }
    
    if (!flag)
    {
    	$("leftmovebtn").disabled = true;
    }
}

function toRight()
{
    var slt1 = document.getElementById("left");

    document.getElementById("applybtn").disabled = false; 
    
    for(var i = 0, length= slt1.options.length; i < length; i++)
    {
    	if(slt1.options[i].selected)
        {
    		var opt = JSON.parse(slt1.options[i].value);
    		
    		for(var j = avaiPortList.length - 1; j >= 0; j--)
    		{
    			if(opt.portname == avaiPortList[j].portname)
    			{
    				avaiPortList.removeAt(j);
    			}
    		}

    		usedPortList.push(opt);   		    		
        }
    }   
    
    $("rightmovebtn").disabled = true;	
    initDate();
}

function toLeft()
{
    var slt1 = document.getElementById("right");

    document.getElementById("applybtn").disabled = false; 
    
    for(var i = 0, length= slt1.options.length; i < length; i++)
    {
    	if(slt1.options[i].selected)
        {
    		var opt = JSON.parse(slt1.options[i].value);
    		
    		for(var j = usedPortList.length - 1; j >= 0; j--)
    		{
    			if(opt.portname == usedPortList[j].portname)
    			{
    				usedPortList.removeAt(j);
    			}
    		}

    		avaiPortList.push(opt);   		    		
        }
    }   
    $("leftmovebtn").disabled = true;	
    initDate();
}   

function doCreate(buttonFlag)
{
	  var length = $("right").options.length;
	  if (0 >= length)
	  {
	  	  alert(RESOURCE["selectePort"]);
	  	  return;
	  }
	  
	  var portString = $("right").options[0].text;
	  for(var i = 1; i < length; i++)
	  {
		  portString = portString+ "," + $("right").options[i].text;
	  }
	  winurlobj.setSvrPortString(portString);
	  
	  if (buttonFlag)
	  {
		    xcloseDialog();
		    return;
	  }
	
	  winurlobj.setSvrPortInfo(usedPortList, avaiPortList);	  
}
