/**
 *       ID
 */
var IF_BOARD_PORT_1PLUS1 = "ATTR_IF_PORT_1PLUS1";
/**
 *       ID
 */
var SERVICE_PORT_1PLUS1 = "ATTR_SERVICE_PORT_1PLUS1";

var BOARD_TYPE_RESOURCE = 1;

var PORT_TYPE_RESOURCE = 2;

/**
 *            
 */
var TE_RTN_NE = 11;  

var ELAGMGR_FUNCID = 8494;

/**
 * FO R1C01      1+1    
 *                  
 * 1         
 * 2     
 * 3     
 * 
 *   FO                             
 */
function init()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attr"], RESOURCE["value"]);
	
	/**
	 *       
	 * 0-noprot       
	 * 1-lagprot LAG       
	 * 2-splitprot           
	 * 0xff-   
	 * RTN310V1R1C01                  LAG       
	 * RTN380V1R1C00             
	 * RTN900R5C01    0xff
	 */

	var srvprottypeAtom = new Atom("select");
	ct.addAttrRow("srvprottype", RESOURCE["srvprottype"], srvprottypeAtom);
	srvprottypeAtom.element.disabled = true;	
	
	var laglinkAtom = new Atom("span");
	ct.addAttrRow("laglink", RESOURCE["laglink"], laglinkAtom);

	var elem = document.createElement("a");
    elem.href="###";
    elem.innerText = RESOURCE["laglinkInfo"];
    elem.id = "laglinkBtn";
	elem.style.width = "100%";
    elem.onclick = onGotoLagMgr;
    laglinkAtom.element.parentNode.appendChild(elem);
	
	var wModeAtom = new Atom("select");
	ct.addAttrRow("wmode", RESOURCE["wmode"], wModeAtom);

	var rModeAtom = new Atom("select");
	ct.addAttrRow("rmode", RESOURCE["rmode"], rModeAtom);

	var wtrTimeAtom = new Atom("text");
	ct.addAttrRow("wtrtime", RESOURCE["wtrtime"], wtrTimeAtom);
	

	var switchEnableAtom = new Atom("select");
	ct.addAttrRow("switchenable", RESOURCE["switchenable"], switchEnableAtom);
	/**
	 *         :0      1     
	 */
	var workprounitAtom = new Atom("select");
	ct.addAttrRow("workprounit", RESOURCE["workprounit"], workprounitAtom);
    
	/**
	 *     
	 */	
	var ifportAtom = new Atom("select");
	ct.addAttrRow("ifport", RESOURCE["ifport"], ifportAtom);	

	ifportAtom.element.disabled = true;
	/**
	*     
	*/
	var svrportAtom = new Atom("select");
	ct.addAttrRow("svrport", RESOURCE["svrport"], svrportAtom);					
	
	document.getElementById("ctable").appendChild(ct.getTable());
	initTableData();
}

/**
 *   LAG     
 */
function onGotoLagMgr()
{
	xcloseDialog();
	var win = getParentWindow();
	var fun = win.top.frames["functiontree"].tree[ELAGMGR_FUNCID];
	if(null == fun)
	{
	    	return;
	}
	fun.isSelect();
	fun.expand();
	
	var url = getLagLinkUrl(fun.argus);
	
	
    fun.onClick();  

}


/**
 *          
 */
function initTableData()
{
	/**
	 *           
	 */
	sendGetAvailableResourceInfo(IF_BOARD_PORT_1PLUS1,PORT_TYPE_RESOURCE,getIFPortAvailableResCallBack);
	/**
	 *          
	 */
	sendGetAvailableResourceInfo(SERVICE_PORT_1PLUS1,PORT_TYPE_RESOURCE,getServicePortAvailableResCallBack);
	
	var srvprottypeAtom = ct.getAtom("srvprottype");
	for ( var j = srvprottypeAtom.element.options.length - 1; j >= 0; j--)
	{
		srvprottypeAtom.element.options[j] = null;
	}	
	srvprottypeAtom.addOption(RESOURCE["lagtype"], "1");
	
	
	var wModeAtom = ct.getAtom("wmode");
	for ( var j = wModeAtom.element.options.length - 1; j >= 0; j--)
	{
		wModeAtom.element.options[j] = null;
	}
	wModeAtom.addOption(wMode.SD, "0");
	wModeAtom.addOption(wMode.FD, "1");
	wModeAtom.addOption(wMode.HSB, "2");
	wModeAtom.element.selectedIndex = 2;

	wModeAtom.element["onchange"] = function()
	{
		var switchEnableAtom = ct.getAtom("switchenable");

		if (this.value == 1)
		{
			switchEnableAtom.element.disabled = true;
			switchEnableAtom.addOption("-", "3");
			switchEnableAtom.element.selectedIndex = 2;
		}
		else if(this.value == 0)
		{
			switchEnableAtom.element.disabled = false;
			switchEnableAtom.removeOption("3");
		}else{
			switchEnableAtom.element.disabled = false;
			switchEnableAtom.removeOption("3");			
		}
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}

	var rModeAtom = ct.getAtom("rmode");
	for ( var j = rModeAtom.element.options.length - 1; j >= 0; j--)
	{
		rModeAtom.element.options[j] = null;
	}
	rModeAtom.addOption(RESOURCE["revertivemode"], "1");
	rModeAtom.addOption(RESOURCE["nonrevertivemode"], "0");
	rModeAtom.element.selectedIndex = 0;
	rModeAtom.element.style.width = "100%";
	
	var wtrTimeAtom = ct.getAtom("wtrtime");
	wtrTimeAtom.element.style.width = "100%";
	wtrTimeAtom.setValue(REVERTIVWTRTIME);
	wtrTimeAtom.element.disabled = false;

	checkText(wtrTimeAtom.element, "300", "720");

	rModeAtom.element["onchange"] = function()
	{
		var wtrtime = ct.getAtom("wtrtime");
		if (this.value == 0)
		{
			wtrtime.element.disabled = true;
			wtrtime.setValue("-");
		}
		else
		{
			wtrtime.element.disabled = false;
			wtrTimeAtom.setValue(REVERTIVWTRTIME);

		}
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}

	var switchEnableAtom = ct.getAtom("switchenable");
	for ( var j = switchEnableAtom.element.options.length - 1; j >= 0; j--)
	{
		switchEnableAtom.element.options[j] = null;
	}
	switchEnableAtom.addOption(RESOURCE["disable"], "0");
	switchEnableAtom.addOption(RESOURCE["enable"], "1");
	switchEnableAtom.element.selectedIndex = 1;
	switchEnableAtom.element.style.width = "100%";

	switchEnableAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}
	var workprounitAtom = ct.getAtom("workprounit");
	workprounitAtom.element.options.length = 0;
	workprounitAtom.addOption(RESOURCE["workunit"], "0");
	workprounitAtom.addOption(RESOURCE["protectetunit"], "1");
	workprounitAtom.element.style.width = "100%";	
}

/**
 *             
 * @param {Object} supportAttrName
 * @param {Object} resourceType
 * @param {Object} getAvailableResCallBack
 */
function sendGetAvailableResourceInfo(supportAttrName,resourceType,getAvailableResCallBack)
{
	var xmlstr = createGetPortAvailableResXML(supportAttrName,resourceType);
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ TECMDCODE_COMMON_FIND_RESURCE + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, getAvailableResCallBack, null,
			"inputdata=" + xmlstr);
}
/**
 *        XML
 * @param {Object} supportAttrName
 * @param {Object} resourceType
 */
function createGetPortAvailableResXML(supportAttrName,resourceType)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	var param = new tagElement("param");
	param.setAttribute("name", "supportAttrName");
	param.setAttribute("value", supportAttrName);
	row.appendChild(param);

	var param = new tagElement("param");
	param.setAttribute("name", "resourceType");
	param.setAttribute("value", resourceType);
	row.appendChild(param);

	var param = new tagElement("param");
	param.setAttribute("name", "funDomainType");
	param.setAttribute("value", TE_RTN_NE);
	row.appendChild(param);
			
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}
/**
 *           
 * @param {Object} doc
 */
function getIFPortAvailableResCallBack(doc)
{
	var dinterface = EncapsulateData(doc);
	
	if ((null == dinterface.getSErrorCode())
			|| (0 == dinterface.getSErrorCode()))
	{
		var ifportAtom = ct.getAtom("ifport");
		ifportAtom.element.options.length = 0;
		for ( var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
		{
			var tmpboard = new Object();
			var obj = dinterface.rows[i];
			tmpboard.portname = obj["portname"].value;
			tmpboard.slotId = obj["slotId"].value;
			tmpboard.portId = obj["portId"].value;
			ifportAtom.addOption(tmpboard.portname, JSON.stringify(tmpboard));		
		}
	}
}
/**
 *           
 * @param {Object} doc
 */
function getServicePortAvailableResCallBack(doc)
{
	var dinterface = EncapsulateData(doc);
	
	if ((null == dinterface.getSErrorCode())
			|| (0 == dinterface.getSErrorCode()))
	{
		var svrportAtom = ct.getAtom("svrport");
		svrportAtom.element.options.length = 0;
		for ( var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
		{
			var tmpboard = new Object();
			var obj = dinterface.rows[i];
			tmpboard.portname = obj["portname"].value;
			tmpboard.slotId = obj["slotId"].value;
			tmpboard.portId = obj["portId"].value;

			svrportAtom.addOption(tmpboard.portname, JSON.stringify(tmpboard));		
		}
	}
}
function initBtn()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
}

function sendApplyInfo()
{
	var xmlstr = createCreateIf1Plus1XML();
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_ADD_RADIO_1J1PG_FO + "&nmUser=" + win.obj["nmUser"];

	loadXMLdoc(urlreq, "POST", false, openCreateErrDialog, null, "inputdata="
			+ xmlstr);
}
/**
 *          FO    RTN         
 */
function createCreateIf1Plus1XML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	/**
	 *   QX         :   1
	 */
	var param = new tagElement("param");
	param.setAttribute("name", "groupId");
	param.setAttribute("value", "1");
	row.appendChild(param);
	param = new tagElement("param");
	var ifport = JSON.parse(ct.getAttrValue("ifport"));
	param.setAttribute("name", "ifSlotId");
	param.setAttribute("value", ifport.slotId);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "ifPortId");
	param.setAttribute("value", ifport.portId);
	row.appendChild(param);

	param = new tagElement("param");
	var svrport = JSON.parse(ct.getAttrValue("svrport"));
	param.setAttribute("name", "Srvpid");
	param.setAttribute("value", svrport.portId);
	row.appendChild(param);
	/**
	 *       
	* 	0-noprot       
	* 	1-lagprot LAG       
	* 	2-splitprot           
	* 	0xff-   
	*	RTN310V1R1C01                  LAG       
	*	RTN380V1R1C00             
	*	RTN900R5C01    0xff
	 */
	param = new tagElement("param");
	var srvprottypeValue = ct.getAttrValue("srvprottype");
	param.setAttribute("name", "srvpgType");
	param.setAttribute("value", srvprottypeValue);
	row.appendChild(param);

	param = new tagElement("param");
	var workprounitValue = ct.getAttrValue("workprounit");
	param.setAttribute("name", "role");
	param.setAttribute("value", workprounitValue);
	row.appendChild(param);
	/**
	 *      
	 * 0  SD
	 * 1 FD
	 * 2 HSB E-Band   HSB 
	 */
	param = new tagElement("param");
	var revertiveModeValue = ct.getAttrValue("wmode");
	param.setAttribute("name", "pgType");
	param.setAttribute("value", revertiveModeValue);
	row.appendChild(param);
	/**
	 *        
	 * 0-    Norvt      
	 * 1-    Rvt     (  )
	 */
	param = new tagElement("param");
	var revertiveModeValue = ct.getAttrValue("rmode");
	param.setAttribute("name", "rvtmode");
	param.setAttribute("value", revertiveModeValue);
	row.appendChild(param);
	
	param = new tagElement("param");	
	var wtrTimeValue = ct.getAttrValue("wtrtime");
	/**
	 *                       0x00
	 */
	if(wtrTimeValue=="-")
	{
		wtrTimeValue=0;
	}
	param.setAttribute("name", "rvtTime");
	param.setAttribute("value", wtrTimeValue);
	row.appendChild(param);
	
	if(!ct.getAtom("switchenable").element.disabled)
	{
		param = new tagElement("param");	
		var switchenableValue = ct.getAttrValue("switchenable");
		param.setAttribute("name", "switchEnable");
		param.setAttribute("value", switchenableValue);
		row.appendChild(param);
	}
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}


function getLagLinkUrl(argus)
{
    var fis = argus[0].getElementsByTagName("functionItem");
    return resetLink(fis[0].getAttribute("link"));
}

function resetLink(link)
{
    var strFullPath=window.document.location.href;
    var strPath=window.document.location.pathname;
    var pos=strFullPath.indexOf(strPath);
    var prePath=strFullPath.substring(0,pos);
    var postPath=strPath.substring(0,strPath.substr(1).indexOf('/') + 1);
    var linknew = link.replace(/^[..\/]+/,"/nemgr/");
    return addProcInfoToUrl(prePath+postPath + linknew);
}
