var DEFAULTGROUPID = 1;

var REVERTIVWTRTIME = 600;

var NONREVERTIVWTRTIME = 0;

var wMode = new Object();
wMode.SD = "SD";
wMode.FD = "FD";
wMode.HSB = "HSB";

var PORTNO = 1;

var board = new Object();

var boardList = null;

var win = getParentWindow();
var neid = win.neid;

var ct = null;

var isSuccess = false;

var hasApplied = false;
var MIN_PG_ID = 1;
var MAX_PG_ID = 3;

function init()
{
	ct = new CTable();
	ct.addHead(RESOURCE["attr"], RESOURCE["value"]);

	var wModeAtom = new Atom("select");
	ct.addAttrRow("wmode", RESOURCE["wmode"], wModeAtom);

	var rModeAtom = new Atom("select");
	ct.addAttrRow("rmode", RESOURCE["rmode"], rModeAtom);

	var wtrTimeAtom = new Atom("text");
	ct.addAttrRow("wtrtime", RESOURCE["wtrtime"], wtrTimeAtom);

	var switchEnableAtom = new Atom("select");
	ct.addAttrRow("switchenable", RESOURCE["switchenable"], switchEnableAtom);

	var workingBoardAtom = new Atom("select");
	ct.addAttrRow("workingboard", RESOURCE["workingboard"], workingBoardAtom);

	var protectionBoardAtom = new Atom("select");
	ct.addAttrRow("protectionboard", RESOURCE["protectionboard"],
			protectionBoardAtom);

	document.getElementById("ctable").appendChild(ct.getTable());

	initTableData();
}

function initTableData()
{
	sendGetAvailableResourceInfo();

	var wModeAtom = ct.getAtom("wmode");
	for ( var j = wModeAtom.element.options.length - 1; j >= 0; j--)
	{
		wModeAtom.element.options[j] = null;
	}
	wModeAtom.addOption(wMode.SD, "0");
	wModeAtom.addOption(wMode.FD, "1");
	wModeAtom.addOption(wMode.HSB, "2");
	wModeAtom.element.selectedIndex = 2;

	wModeAtom.element["onchange"] = function()
	{
		var switchEnableAtom = ct.getAtom("switchenable");

		if (this.value == 1)
		{
			switchEnableAtom.element.disabled = true;
		}
		else
		{
			switchEnableAtom.element.disabled = false;
		}
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}

	var rModeAtom = ct.getAtom("rmode");
	for ( var j = rModeAtom.element.options.length - 1; j >= 0; j--)
	{
		rModeAtom.element.options[j] = null;
	}
	rModeAtom.addOption(RESOURCE["revertivemode"], "1");
	rModeAtom.addOption(RESOURCE["nonrevertivemode"], "0");
	rModeAtom.element.selectedIndex = 0;
	rModeAtom.element.style.width = "100%";

	var wtrTimeAtom = ct.getAtom("wtrtime");
	wtrTimeAtom.element.style.width = "100%";
	wtrTimeAtom.setValue(REVERTIVWTRTIME);
	wtrTimeAtom.element.disabled = false;

	checkText(wtrTimeAtom.element, "300", "720");

	rModeAtom.element["onchange"] = function()
	{
		var wtrtime = ct.getAtom("wtrtime");
		if (this.value == 0)
		{
			wtrtime.element.disabled = true;
			wtrtime.setValue(0);
		}
		else
		{
			wtrtime.element.disabled = false;
			wtrTimeAtom.setValue(REVERTIVWTRTIME);

		}
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}

	var switchEnableAtom = ct.getAtom("switchenable");
	for ( var j = switchEnableAtom.element.options.length - 1; j >= 0; j--)
	{
		switchEnableAtom.element.options[j] = null;
	}
	switchEnableAtom.addOption(RESOURCE["disable"], "0");
	switchEnableAtom.addOption(RESOURCE["enable"], "1");
	switchEnableAtom.element.selectedIndex = 1;
	switchEnableAtom.element.style.width = "100%";

	switchEnableAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}

	var workingBoardAtom = ct.getAtom("workingboard");
	for ( var j = workingBoardAtom.element.options.length - 1; j >= 0; j--)
	{
		workingBoardAtom.element.options[j] = null;
	}
	for ( var i = 0, len = boardList.length; i < len; i++)
	{
		workingBoardAtom.addOption(boardList[i].slotID.value + "-"
				+ boardList[i].boardName.value + "-"
				+ boardList[i].portNo.value, boardList[i].slotID.value);
	}
	workingBoardAtom.element.style.width = "100%";

	workingBoardAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}

	var protectionBoardAtom = ct.getAtom("protectionboard");
	for ( var j = protectionBoardAtom.element.options.length - 1; j >= 0; j--)
	{
		protectionBoardAtom.element.options[j] = null;
	}
	for ( var i = 0, len = boardList.length; i < len; i++)
	{
		protectionBoardAtom.addOption(boardList[i].slotID.value + "-"
				+ boardList[i].boardName.value + "-"
				+ boardList[i].portNo.value, boardList[i].slotID.value);
	}
	protectionBoardAtom.element.style.width = "100%";

	protectionBoardAtom.element["onchange"] = function()
	{
		$("applyBtn").disabled = false;
		$("okBtn").disabled = false;
	}
}

function sendGetAvailableResourceInfo()
{
	var xmlstr = createGetAvailableResXML();
	var urlreq = "../../../../neExlorerServlet?sfid="
			+ TECMDCODE_GET_BOARD_RES + "&flag=1";
	loadXMLdoc(urlreq, "POST", false, refreshGetAvailableRes, null,
			"inputdata=" + xmlstr);
}

function createGetAvailableResXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function refreshGetAvailableRes(doc)
{
	boardList = new Array();
	var dinterface = EncapsulateData(doc);
	if ((null == dinterface.getSErrorCode())
			|| (0 == dinterface.getSErrorCode()))
	{
		for ( var i = 0, len = dinterface.getDataRowLength(); i < len; i++)
		{
			var tmpboard = new Object();
			var obj = dinterface.rows[i];
			tmpboard.slotID = obj["slotId"];
			tmpboard.boardType = obj["boardType"];
			tmpboard.boardName = obj["boardName"];
			var portNo = new Object();
			portNo.value = PORTNO;
			portNo.options = null;
			tmpboard.portNo = portNo;
			boardList.append(tmpboard);
		}
	}
}

function vlidateboard()
{
	var wBoardslot = ct.getAttrValue("workingboard");
	var pBoardslot = ct.getAttrValue("protectionboard");

	var isprotect = false;
	var typea = getboardtype(wBoardslot);

	var typeb = getboardtype(pBoardslot);

	if (typea == typeb)
	{
		isprotect = true;
	}

	if (typea == "1032" || typea == "1033")
	{
		if (typeb == "1033" || typeb == "1032")
		{
			isprotect = true;
		}
	}

	if (typea == "1176" || typea == "1177")
	{
		if (typeb == "1176" || typeb == "1177")
		{
			isprotect = true;
		}
	}

        if (typea == "2079" || typea == "2080" || typea == "2081")
        {
            if (typeb == "2079" || typeb == "2080" || typeb == "2081")
            {
                isprotect = true;  
            }
        }
		/**
		 * DCR OP201206290002
		 *          ISV3   IS2    ISX2/ISU2  1+1   .
		 *     q00119080
		 */
        if (typea == "2468" || typea == "2267")//BDTYPE_SL91ISV3 BDTYPE_SL91ISX2
        {
            if (typeb == "2468" || typeb == "2267")
            {
                isprotect = true;  
            }
        }
		if (typea == "2468" || typea == "2266")//BDTYPE_SL91ISV3 BDTYPE_SL91ISU2
        {
            if (typeb == "2468" || typeb == "2266")
            {
                isprotect = true;  
            }
        }
	return isprotect;
}

function getboardtype(slotid)
{
	for ( var i = 0, len = boardList.length; i < len; i++)
	{
		if (boardList[i].slotID.value == slotid)
		{
			return boardList[i].boardType.value;
		}
	}
}

function sendApplyInfo()
{
	if (!vlidateboard())
	{
		alert(RESOURCE["noright"]);
		return;
	}

	if (ct.getAttrValue("workingboard") == "")
	{
		alert(RESOURCE["workBoardAlert"]);
		return;

	}

	if (ct.getAttrValue("protectionboard") == "")
	{
		alert(RESOURCE["protectBoardAlert"]);
		return;
	}

	var xmlstr = createCreateIf1Plus1XML();

	var urlreq = "../../../../neExlorerServlet?sfid="
			+ NSCMD_CFG_ADD_RADIO_1J1PG + "&nmUser=" + win.obj["nmUser"];

	loadXMLdoc(urlreq, "POST", false, openCreateErrDialog, null, "inputdata="
			+ xmlstr);
}

function sendConfirmInfo()
{
	sendApplyInfo();
	if (true == isSuccess)
	{
		closeClick();
	}
}

function closeClick()
{
	xcloseDialog();
}

function createCreateIf1Plus1XML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");

	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	
	var groupIds = new Array(1, 2, 3, 4, 5, 6, 7);
	for (var i = 0, m = win.protectionGroupSTable.getDataRowLength(); i < m; i++)
	{
		var groupId = parseInt(win.protectionGroupSTable.getCellStoreValue(i, "groupid", "groupId"));
		groupIds.remove(groupId);
	}

	var param = new tagElement("param");
	param.setAttribute("name", "groupId");
	param.setAttribute("value", groupIds[0]);
	row.appendChild(param);

	param = new tagElement("param");
	var workingBoardInfo = ct.getAttrValue("workingboard");
	
	var workingSlotIdValue = workingBoardInfo.split("-")[0];
	param.setAttribute("name", "workingSlotId");
	param.setAttribute("value", workingSlotIdValue);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "workingport");
	param.setAttribute("value", PORTNO);
	row.appendChild(param);

	param = new tagElement("param");
	var protectionBoardInfo = ct.getAttrValue("protectionboard");
	var protectionSlotIdValue = protectionBoardInfo.split("-")[0];
	param.setAttribute("name", "protectionSlotId");
	param.setAttribute("value", protectionSlotIdValue);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "protectionport");
	param.setAttribute("value", PORTNO);
	row.appendChild(param);

	param = new tagElement("param");
	var workModeValue = ct.getAttrValue("wmode");
	param.setAttribute("name", "wMode");
	param.setAttribute("value", workModeValue);
	row.appendChild(param);

	param = new tagElement("param");
	var revertiveModeValue = ct.getAttrValue("rmode");
	param.setAttribute("name", "rMode");
	param.setAttribute("value", revertiveModeValue);
	row.appendChild(param);

	param = new tagElement("param");
	var wtrTimeValue = ct.getAttrValue("wtrtime");

	param.setAttribute("name", "wtrTime");
	param.setAttribute("value", wtrTimeValue);
	row.appendChild(param);

	if (workModeValue != 1)
	{
		param = new tagElement("param");
		var switchEnableValue = ct.getAttrValue("switchenable");
		param.setAttribute("name", "switchEnable");
		param.setAttribute("value", switchEnableValue);
		row.appendChild(param);
	}

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function openCreateErrDialog(doc)
{
	var dinterface = EncapsulateData(doc);

	if (0 != dinterface.getSErrorCode())
	{
		isSuccess = false;
		hasApplied = false;
		showErrorDialog(dinterface);
		return;
	}

	$("applyBtn").disabled = true;
	isSuccess = true;
	hasApplied = true;
	win.refresh();
	initTableData();

}

function initBtn()
{
	$("okBtn").value = RESOURCE["okbutton"];
	$("cancelBtn").value = RESOURCE["cancelbutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
	if ("" == ct.getAttrValue("workingboard")
			|| "" == ct.getAttrValue("protectionboard"))
	{
		$("okBtn").disabled = true;
	}
}

function showErrorDialog(dinterface)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", dinterface.getError(), errArr);
}
