var st = null;

var btnRightArr = new Object();
var neobject = getNeProperty(parent.self);

var ifBandwidth = null;
var e1Enable = null;
var ensureMode = null;
var fullMode = null;

var ensureModeRowIndex = -1;

function init()
{
    $("querybtn").value = RESOURCE["query"];
    $("applybtn").value = RESOURCE["apply"];
    
    st = new SortTable();
    st.setImage("../../../../images/");
    
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(cellEditHandler);
    $("divtbl").appendChild(st.getTable());
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_QUERY_E1PRI);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_SET_E1PRI);
    
    getRightInfo(neobject, btnRightArr);
	
	$("querybtn").disabled = !btnRightArr.querybtn.right;
}

function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        query();
    }
}

function cellEditHandler(param)
{
    if (param.colid == "e1cap" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var rowIndex = param.rowindex;
        var minVlaue = st.getCellStoreValue(rowIndex - 1, "e1cap", "e1cap");
        var nValue = st.getCellStoreValue(rowIndex + 1, "e1cap", "e1cap");
        var maxE1Cap = st.getCellStoreValue(rowIndex, "maxe1cap", "maxe1cap");
        var maxValue = parseInt(maxE1Cap) > parseInt(nValue) ? nValue : maxE1Cap;
        
        var cell = st.getCellEdit(rowIndex, "e1cap");
        textCheck(cell.element, rowIndex, minVlaue, maxValue);
    }
    
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        if (st.getModify(i)) 
        {
            $("applybtn").disabled = !btnRightArr.applybtn.right;
            break;
        }
    }
}

function query()
{
    $("querybtn").disabled = true;
	$("applybtn").disabled = true;
    
    var xmlstr = createQueryXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_E1PRI + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    
    loadXMLdoc(urlreq, "POST", true, queryCallback, null, "inputdata=" + xmlstr);
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    row.appendChild(createTagElement("neid", neobject.neid));
    row.appendChild(createTagElement("slotid", neobject.slotid));
    row.appendChild(createTagElement("portid", 1));
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryCallback(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        if (data.getDataRowParam(i, "bandwidth") != null) 
        {
            ifBandwidth = data.getDataRowParam(i, "bandwidth");
            e1Enable = data.getDataRowParam(i, "e1enable");
            ensureMode = data.getDataRowParam(i, "ensuremode");
            fullMode = data.getDataRowParam(i, "fullmode");
            break;
        }
    }
    
    st.clearTableData();
    createTableBody(st, window.tableconf[0], data, RESOURCE);
    
    for (var j = 0, n = st.getDataRowLength(); j < n; j++) 
    {
        var e1cap = parseInt(st.getCellStoreValue(j, "e1cap", "e1cap"));
        if (e1cap == 0xFF) 
        {
            st.setCellIsEdit(st.getCell(j, "e1cap"), 0);
            st.getCellShow(j, "e1cap").element.innerHTML = "-";
			st.getCellShow(j, "ethband").element.innerHTML = "-";
        }
        else 
        {
			var mode = st.getCellStoreValue(j, "mode", "mode");
            if (e1Enable == 0 || mode == ensureMode || mode == fullMode) 
            {
                st.setCellIsEdit(st.getCell(j, "e1cap"), 0);
				if (mode == ensureMode)
				{
					ensureModeRowIndex = j;
				}
            }
			var ethBand = parseInt(st.getCellStoreValue(j, "ethband", "ethband"));
			st.getCellShow(j, "ethband").element.innerHTML = ethBand / 1000;
        }
    }
}

function createQueryEthBandXML(arg)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    row.appendChild(createTagElement("neid", neobject.neid));
    row.appendChild(createTagElement("slotid", neobject.slotid));
    row.appendChild(createTagElement("portid", st.getCellStoreValue(arg, "portid", "portid")));
    row.appendChild(createTagElement("bandwidth", ifBandwidth));
    row.appendChild(createTagElement("mode", st.getCellStoreValue(arg, "mode", "mode")));
    row.appendChild(createTagElement("e1cap", st.getCellStoreValue(arg, "e1cap", "e1cap")));
	row.appendChild(createTagElement("isLogFlag", 0));
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryEthBand(arg)
{
    var xmlstr = createQueryEthBandXML(arg);
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_E1PRI_ETHBAND + "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, queryEthBandCallback, arg, "inputdata=" + xmlstr);
}

function queryEthBandCallback(doc, arg)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (0 == data.getSErrorCode()) 
    {
        var ethBand = parseInt(data.getDataRowParam(0, "ethband"));
        st.setCellValue(st.getCell(arg, "ethband"), "ethband", ethBand);
        st.getCellShow(arg, "ethband").element.innerHTML = ethBand / 1000;
    }
}

function createModifyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    row.appendChild(createTagElement("neid", neobject.neid));
    row.appendChild(createTagElement("slotid", neobject.slotid));
    row.appendChild(createTagElement("portid", st.getCellStoreValue(0, "portid", "portid")));
    row.appendChild(createTagElement("modenum", st.getDataRowLength()));
    
    var e1caps = "";
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var mode = st.getCellStoreValue(i, "mode", "mode");
        var e1cap = st.getCellStoreValue(i, "e1cap", "e1cap");
        e1caps += toHex(mode) + toHex(e1cap);
    }
    row.appendChild(createTagElement("e1caps", e1caps));
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    
    return di.toString();
}

function modify()
{
    var isSend = true;
	var minEthBand = parseInt(st.getCellStoreValue(ensureModeRowIndex, "ethband", "ethband"));

    for (var i = ensureModeRowIndex + 1, m = st.getDataRowLength() - 1; i < m; i++) 
    {
        var ethBand = st.getCellStoreValue(i, "ethband", "ethband");
        if (typeof(ethBand) != "undefined" && ethBand != "0" && parseInt(ethBand) < minEthBand) 
        {
            isSend = false;
						break;
        }
    }
    
    if (!isSend) 
    {
        alert(RESOURCE["noncondition"]);
        return;
    }
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xmlStr = createModifyXML();
    var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_E1PRI + "&flag=1" + "&nmUser=" + neobject["nmUser"];
    loadXMLdoc(urlreq, "POST", true, openModifyErrDialog, null, "inputdata=" + xmlStr);
}

function openModifyErrDialog(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    if (0 != data.getSErrorCode()) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
        showErrorDialog(data);
        return;
    }
    
    refreshTableState(st, window.tableconf[0], data);
}

function textCheck(obj, index, min, max, decimalCount,othervalue)
{
	min += "";
	max += "";

	obj.style.imeMode = "disabled";

	obj.onpaste = function()
	{
		return false;
	}

	obj.onblur = function()
	{
		numCellOnBlur(obj, min, max, decimalCount,othervalue);
		queryEthBand(index);
	}

	obj.onkeypress = function()
	{
		var evt= EventUtil.getEvent();
		return digitalCheck(obj, min, max, decimalCount,othervalue, evt);
	}
}

window.onresize=function()
{
    st.setBodyHeight(getComponetHeight($("divtbl"), 50) + "px");
}	
