var tab = null;
var st = null;
var tc = null;
var beginTime = "";
var endTime = "";
var imgName = ""; //                    

var btnRightArr = new Object();
var obj = getNeProperty(self);
var neid = obj["neid"];
var remoteneid = null;
var localBg = null;
var remoteBg = new BoardGroup();

var rxPNower = [];
rxPNower[7] = 6.69;
rxPNower[14] = 9.70;
rxPNower[28] = 12.71;
rxPNower[56] = 15.72;

var bandwidth = [];//    M
bandwidth[0] = 14;
bandwidth[1] = 3.5;
bandwidth[2] = 7;
bandwidth[3] = 14;
bandwidth[4] = 28;
bandwidth[5] = 40;
bandwidth[6] = 56;
bandwidth[7] = 30;//FCC30M
bandwidth[8] = 40;//FCC40M
bandwidth[9] = 50;//FCC50M
bandwidth[10] = 250;
bandwidth[11] = 500;
bandwidth[12] = 750;
bandwidth[13] = 250;//FCC250M
bandwidth[14] = 500;//FCC5000M
bandwidth[15] = 750;//FCC750M

var freqStepIndex = [30,30,15,10,5];

var TYPE_INVALID_NEID = -1;
var TYPE_AUTOCLEARODUMUTE = "11";//           11 ODU     
var TYPE_ODUMUTE = "0";//      
var TYPE_ODUUNMUTE = "1";//      
var TYPE_ODUAUTOCLEAR_DISABLE = 0;//    ODU    
var TYPE_ODUAUTOCLEAR_ENABLE = 1;//    ODU    
var TYPE_ODUMUTE_TIME = 30;//       30m     
var TYPE_STEP_FREQ = 15;//      1.5MHz
var xAxisName = "";
var yAxisName = "";
var categories = [];
var series = [{}];
var CurrentData = [];

var AjaxLoading = false;

var isNeedResetLocalOduFre = true;

function init()
{
    initres();
    initRights()
    initResultImage();
    initResultTable();
    initTabs();
    if(btnRightArr.startscan_label.right)
    {
    	$("startscan_label").disabled = true;
    	$("stopscan_label").disabled = true;
        
        $("saveimgbtn").disabled = true;
        $("savebtn").disabled = true;
        
    	queryGroup(neid);
    }
}

function initres()
{
	setResourceValue("linkid_label",RESOURCE["linkid"]);
	setResourceValue("txfreq_label",RESOURCE["txfreq"]);
	setResourceValue("oduslotid_label",RESOURCE["oduslotid"]);
	setResourceValue("odutxstate_label",RESOURCE["odutxstate"]);
	setResourceValue("txfreqrg_label",RESOURCE["txfreqrg"]);
	setResourceValue("freqscanrg_label",RESOURCE["freqscanrg"]);
	setResourceValue("freqscanstep_label",RESOURCE["freqscanstep"]);
	setResourceValue("oduautounmute_label",RESOURCE["oduautounmute"]);
	
	setResourceValue("spanMutefartitle",RESOURCE["mutefartitle"]);
	
	if (SYSTEMCONF.getLanguage() == "en")
	{
		$("startscan_label").className = "buttonstyle9";
		$("stopscan_label").className = "buttonstyle9";
	}
	$("startscan_label").value = RESOURCE["startscan"];
	$("stopscan_label").value = RESOURCE["stopscan"];
	
	$("savebtn").value = RESOURCE["savebtn"];
	$("saveimgbtn").value = RESOURCE["savebtn"];
	
	xAxisName = RESOURCE["xaxisname"];
	yAxisName = RESOURCE["yaxisname"];

	checkText($("oduautounmute_input"), "1", "2880");//      :1-2880min    5min
}

function setResourceValue(domid,value)
{
    var dome = $(domid);
    dome.innerHTML = value;
}

function setTextValue(domid,value)
{
    var dome = $(domid);
    dome.value = value;
}
function initRights()
{
	btnRightArr.startscan_label = new BtnRightObj("startscan_label", TECMDCODE_RADIO_START_FREQSCAN);
	btnRightArr.stopscan_label = new BtnRightObj("stopscan_label", TECMDCODE_RADIO_STOP_FREQSCAN);
	getRightInfo(obj, btnRightArr);
	$("startscan_label").disabled = !btnRightArr.startscan_label.right;	
	$("stopscan_label").disabled = true;
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("imgdiv", RESOURCE["resultsimg"], $("imgdiv"));
	tab.addEmbedTab("tablediv", RESOURCE["resultstable"], $("tablediv"));
	setSelectedEmbedTab("imgdiv");
    $("embedtab").appendChild(tab.getEmbedTabs());
	setSelectedEmbedTab("imgdiv");
}

function embedTabSelectHandler(id)
{
    if (id == "imgdiv") 
    {
    	if(true == hasRedrawed)
    	{
    		return;
    	}
    	redrawByOldPoints();
    }
    else if (id == "tablediv") 
    {
    	hasRedrawed = false;
    }
}

function redrawByOldPoints()
{
	if(chart == null)
	{
		return;
	}
	chart.cleanAllPoints();//             
	for(var i = 0,len = CurrentData.length;i < len;i++)
	{
		var p = CurrentData[i];
		chart.addNextPoint(p.x,p.y);
	}
	chart.render();
	hasRedrawed = true;
}
function initAutoClearTime()
{
	var freqStep = $("freqscanstep_input").options.selectedIndex;
	$("oduautounmute_input").value = freqStepIndex[freqStep];
}
/*
 *      
 */
function initResultTable()
{
    st = new SortTable();
    tc = window.tableconf[0];
	st.setImage("../../../../images/");
    createTableHead(st, tc);
    $("freqscantablediv").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("freqscantablediv"),-60) + "px");
    $("freqscantablediv").oncontextmenu = popupMenuHandler;
    var data = EncapsulateData(getXMLDoc(createBlankXML()));
    createTableBody(st, window.tableconf[0], data, RESOURCE);
}
function createBlankXML()
{
	di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");
	bussiness.appendChild(row);
	
	rowerror = new tagElement("error-message");
	rowerror.setAttribute("errorcode","0");
	rowerror.setAttribute("errorinfo","0");
	
	di.getRoot().appendChild(bussiness);
	di.getRoot().appendChild(rowerror);
	return di.toString();
}

/**
 *                  
 */
function setComponetHeight()
{
	var lastHeight = 100;
	lastHeight = getComponetHeight($("freqscan"+tab.getSelectEmbedTab()));
	lastHeight = lastHeight < 100?100:lastHeight;
}

function initResultImage()
{
	drawPowerGrap(xAxisName,yAxisName);
}

function tabSelectHandler()
{
	queryGroup(neid);
}

/**
 *           -     
 * @param neid
 * @return
 */
function queryGroup(neid,slotid)
{
	var xmlstr = createQueryGroupXML(neid,slotid);
	var urlreq = getRootPath(neid)+ "/neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_GROUP + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, callbackQueryGroup,slotid, "inputdata=" + xmlstr);
}

function createQueryGroupXML(neidValue,slotidValue)
{
	di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");

	createXMLparam(row,"neid", neidValue);
	if(slotidValue != null && slotidValue != "") 
	{ 
		createXMLparam(row,"slotid", slotidValue); 
	} 
	if(obj.neType == "115")
	{
		createXMLparam(row, "querytype", "getallIFODUBoard");
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function callbackQueryGroup(doc,param)
{
	var data = EncapsulateData(doc);
	var len = data.getDataRowLength();
	
	if(null != param)
	{
		for ( var i = 0; i < len; i++)
		{
			var protectType = data.getDataRowParam(i, "protectType");
			if (protectType != null)
			{
				remoteBg.protectType = data.getDataRowParam(i, "protectType");
				remoteBg.pOduSlotId = data.getDataRowParam(i, "pOduSlotId");
				remoteBg.pOduPhy = data.getDataRowParam(i, "pOduPhy");
				
				remoteBg.mOduSlotId = data.getDataRowParam(i, "mOduSlotId");
				remoteBg.mOduPhy = data.getDataRowParam(i, "mOduPhy");
			}
		}
		LoadingProcess.removeWaitStatus();
	}
	else
	{
		var oduslotid = $("oduslotid_input");
		oduslotid.options.length = 0;

		for ( var i = 0; i < len; i++)
		{
			var bg = new BoardGroup();
			bg.neId = neid;
			bg.mSlotId = data.getDataRowParam(i, "mSlotId");
			bg.mIfPhy = data.getDataRowParam(i, "mIfPhy");
			bg.mBoardName = data.getDataRowParam(i, "mBoardName");
			bg.mOduSlotId = data.getDataRowParam(i, "mOduSlotId");
			bg.mOduPhy = data.getDataRowParam(i, "mOduPhy");
			bg.mOduName = (data.getDataRowParam(i, "mOduBoardName"))||"ODU";
			bg.protectType = data.getDataRowParam(i, "protectType");
			if(null == bg.protectType && 1 == bg.mOduPhy)
			{
				oduslotid.options[oduslotid.options.length] = new Option(bg.mOduSlotId + "-" +bg.mOduName, JSON.stringify(bg));
			}
		}
		showErrorDialog(data);
		initLinkInfors();
	}
}

/**
 *               :  id odu                         
 * @return
 */
function initLinkInfors()
{
	$("startscan_label").disabled = true;
    
    $("saveimgbtn").disabled = true;
    $("savebtn").disabled = true;
    
    $("freqscan_low_input").value = "";
    $("freqscan_hig_input").value = "";
    
    beginTime = "";
    endTime = "";
	var oduslotidOptions = $("oduslotid_input").options;
	var oduslotidObj = "";
	if($("oduslotid_input").options != null && $("oduslotid_input").options.selectedIndex >=0)
	{
		var optIndex = $("oduslotid_input").options.selectedIndex;
		oduslotidObj = oduslotidOptions[optIndex].value;
	}	
	localBg = getExistBG(oduslotidObj);//          
	if(null == localBg)
	{
		return;
	}
	LoadingProcess.showWaitStatus("../../../../images/");
	initFreqScan();//            
	/** 
	*    :DTS2013062005389 
	*      ODU   ,             
	*/ 
	initRemoteNeInfo();      

	var xmlstr = createInitLinkInforsXML(localBg);
	var urlreq = getRootPath(neid) + "/neExlorerServlet?sfid=" + TE_RADIO_FREQSCAN_INITLINK_INFO + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, callbackInitLinkInfors,null, "inputdata=" + xmlstr);
}
function initRemoteNeInfo() 
{ 
	remoteneid = TYPE_INVALID_NEID; 
	if(remoteBg != null) 
	{ 
		remoteBg.neId = TYPE_INVALID_NEID; 
		remoteBg.protectType = null; 
		remoteBg.pOduSlotId = -1; 
		remoteBg.pOduPhy = -1; 
		remoteBg.mOduSlotId = -1; 
		remoteBg.mOduPhy = -1; 
	} 
}

function createInitLinkInforsXML(ifoduBg)
{
	var ifslotid = ifoduBg.mSlotId;
	var oduslotid = ifoduBg.mOduSlotId;
	
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	 
	createXMLparam(row,"neid", neid);
	createXMLparam(row,"ifslotid", ifslotid);
	createXMLparam(row,"slotid", oduslotid);
	createXMLparam(row,"port", 1);
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function callbackInitLinkInfors(doc)
{
	var data = EncapsulateData(doc);
	if(OPERATION_SUCCESS == data.getSErrorCode())
	{
		var freq = parseFloat(data.getDataRowParam(0, "W32BRD_ATTR_TRANSMITFRE"))/1000;
		var channelspace = parseFloat(data.getDataRowParam(0, "W32PORT_ATTR_CHANNELSPACE")||"0");
		var oduWork = data.getDataRowParam(0, "W32BRD_ATTR_WORKSTATUS");
		var linkid = data.getDataRowParam(0, "W32PORT_ATTR_RADIOLINKID");
		
		var lowFreq = parseFloat(data.getDataRowParam(0, "LOWFRE"))/1000;
		var highFreq = parseFloat(data.getDataRowParam(0, "W32BRD_ATTR_WORKRANGE"))/1000;
		 
		localBg.curFreq = freq;
		localBg.cfgFreq = freq;
		localBg.nextFreq = freq;
		localBg.oduWork = oduWork;
		localBg.bandwidth = (bandwidth[channelspace])/2;
		
		localBg.minFreq = lowFreq + localBg.bandwidth;
		localBg.maxFreq = highFreq - localBg.bandwidth;
		
		$("linkid_input").value = linkid;
		$("txfreq_input").value = freq.toFixed(3);
		$("odutxstate_input").value = RESOURCE["workstatus_" + oduWork];
		
		$("txfreqrg_input").value = localBg.minFreq.toFixed(3) + "-" + localBg.maxFreq.toFixed(3);
		
		checkTextAllowSomeValue($("freqscan_low_input"), localBg.minFreq.toFixed(3), localBg.maxFreq.toFixed(3), 3,[""]);
		checkTextAllowSomeValue($("freqscan_hig_input"), localBg.minFreq.toFixed(3), localBg.maxFreq.toFixed(3), 3,[""]);
		
		$("startscan_label").disabled = !btnRightArr.startscan_label.right;
	    $("saveimgbtn").disabled = false;
	    $("savebtn").disabled = false;
	    
		queryOppositeNE(neid,localBg);
	}
	else
	{
		$("linkid_input").value = "";
		$("txfreq_input").value = "";
		$("odutxstate_input").value = "";
		
		$("startscan_label").disabled = true;
	    $("saveimgbtn").disabled = true;
	    $("savebtn").disabled = true;
	    
	    LoadingProcess.removeWaitStatus();
	}
	
	showErrorDialog(data);
}

/**
 *                                 
 * @return
 */
function queryOppositeNE(neidValue,bg)
{
	var xml = createPeerXML(neidValue,bg);
	var urlreq = getRootPath(neidValue)+ "/neExlorerServlet?sfid=" + TECMDCODE_RTN_HOP_QUEERY_PEERNE + "&nmUser=" + obj["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryPeerNeCallback, null, "inputdata=" + xml);
}

function createPeerXML(neidValue,bg)
{
	var di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");
	
	createXMLparam(row,"neid",neidValue);
	createXMLparam(row,"slotid",bg.mSlotId);
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
				
	return di.toString();
}

function queryPeerNeCallback(doc)
{
    var data = EncapsulateData(doc);
	if (OPERATION_SUCCESS == data.getSErrorCode() && data.getDataRowLength() == 1)
	{
		remoteneid = (data.getDataRowParam(0, "peerNEID")||(-1));
		var peerRealNEID = data.getDataRowParam(0, "peerRealNEID");
		var peerIFSlotId = data.getDataRowParam(0, "peerIFSlotId");	
	
		
		var xml = createQueryPeerNEInfo(remoteneid,peerRealNEID,peerIFSlotId);
		var urlreq = getRootPath(remoteneid)+"/neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_REMOTE_NE_INFOR + "&nmUser=" + obj["nmUser"];
		loadXMLdoc(urlreq, "POST", true, queryPeerNEInfoHandler, null, "inputdata=" + xml);
	}
	else
	{
		LoadingProcess.removeWaitStatus();
		return;
	}
}

function createQueryPeerNEInfo(peerNEID,peerRealNEID,peerIFSlotId)
{
	var di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");

	createXMLparam(row,"neid",peerNEID);
	createXMLparam(row,"peerNEID",peerNEID);
	createXMLparam(row,"peerRealNEID",peerRealNEID);
	createXMLparam(row,"peerIFSlotId",peerIFSlotId);
	createXMLparam(row,"funid",obj["funnodeid"]);
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function queryPeerNEInfoHandler(doc)
{
	var data = EncapsulateData(doc);
	if(OPERATION_SUCCESS == data.getSErrorCode() && data.getDataRowLength() == 1)
	{
		var peerIFSlotId = data.getDataRowParam(0, "peerIFSlotId");
		var peerIFBoardName = data.getDataRowParam(0, "peerIFBoardName");
		var peerODUSlotId = data.getDataRowParam(0, "peerODUSlotId");

		remoteBg.neId = remoteneid;
		remoteBg.mSlotId = peerIFSlotId;
		remoteBg.mBoardName = peerIFBoardName;
		remoteBg.mOduSlotId = peerODUSlotId;
		remoteBg.protectType = null;
		
		queryGroup(remoteneid,peerIFSlotId);
	}
	else
	{
		LoadingProcess.removeWaitStatus();
		return;
	}
}

var currentTaskIndex = 0;
var STEP_INVALID_TASK = -1;
var STEP_MUTE_REMOTE_ODU = 0;
var STEP_MUTE_LOCAL_ODU = 1;
var STEP_QUERY_LOCAL_ODU_FREQFILTER = 2;
var STEP_MINIMIZE_LOCAL_ODU_FREQFILTER = 3;
var STEP_SET_LOCAL_ODU_FREQ = 4;
var STEP_QUERY_LOCAL_ODU_RXPOWER = 5;
var STEP_ADD_LOCAL_ODU_POINT = 6;
var STEP_UNMUTE_LOCAL_ODU = 7;
var STEP_RESET_LOCAL_ODU_FREQFILTER = 8;
var STEP_STOP_FREQSCAN = true;//        
var hasRedrawed = true;

function freqscanStart()
{
	if((null != getLowcfgFreq() && null != getHigcfgFreq()) && getLowcfgFreq() >= getHigcfgFreq())
	{
		alert(RESOURCE["freqrange_err"]);
		return;
	}
	
	if (!confirm(RESOURCE["dangeralarm_cof"])) 
    {
        return;
    }
	
	if (!confirm(RESOURCE["dangeralarm_cof_again"])) 
    {
        return;
    }
	
	alert(RESOURCE["redalert"]);
	
	$("oduslotid_input").disabled = true;
	$("startscan_label").disabled = true;
	$("stopscan_label").disabled = !btnRightArr.stopscan_label.right;
	$("freqscan_low_input").disabled = true;
	$("freqscan_hig_input").disabled = true;
	$("freqscanstep_input").disabled = true;
	$("oduautounmute_input").disabled = true;
	$("chbMuteFar").disabled = true;
	$("saveimgbtn").disabled = true;
    $("savebtn").disabled = true;
    
	initFreqScan();
	scheduleTask(currentTaskIndex);
}

function errCauseStop(nextStep)
{
	STEP_STOP_FREQSCAN = true;
	currentTaskIndex = nextStep;
	scheduleTask(currentTaskIndex);
}

function freqscanStop()
{
	$("stopscan_label").disabled = true;
	STEP_STOP_FREQSCAN = true;
	currentTaskIndex = STEP_UNMUTE_LOCAL_ODU;
	if(AjaxLoading)
	{
		window.setTimeout(freqscanStop,500);
	}
	else
	{
		scheduleTask(STEP_UNMUTE_LOCAL_ODU);
	}
}

/**
 *           
 */
function initFreqScan()
{
    beginTime = "";
    endTime = "";
    
	STEP_STOP_FREQSCAN = false;
	hasRedrawed = false;
	CurrentData = [];
	currentTaskIndex = STEP_MUTE_REMOTE_ODU;
	chart.cleanAllPoints();//  chart             
	st.clearTableData();//        
	addTimeStamp(RESOURCE["time"]);
	
	var currDate = new Date();
	beginTime = createTime(currDate, false);
}

function refreshLinkInfos()
{
	if(null != localBg.cfgFreq)
	$("txfreq_input").value = (parseFloat(localBg.cfgFreq)).toFixed(3);//        
	if(null != localBg.oduWork)
	$("odutxstate_input").value = RESOURCE["workstatus_" + localBg.oduWork];
}

function getLowcfgFreq()
{
	var lowFreq = $("freqscan_low_input").value;
	if("" == lowFreq.trim())
	{
		return null;
	}
	return parseFloat(lowFreq);
}

function getHigcfgFreq()
{
	var higFreq = $("freqscan_hig_input").value;
	if("" == higFreq.trim())
	{
		return null;
	}
	return parseFloat(higFreq);
}

function getFreqStep()
{
	var freqStep = $("freqscanstep_input").value;
	if("" == freqStep.trim())
	{
		return TYPE_STEP_FREQ;
	}
	return parseFloat(freqStep);
}

function getAutoClearTime()
{
	var autoClearTime = $("oduautounmute_input").value;
	if("" == autoClearTime.trim())
	{
		var defaultTimeIndex = $("freqscanstep_input").options.selectedIndex;
		return freqStepIndex[defaultTimeIndex];
	}
	return parseFloat(autoClearTime);
}

/**
 *          
 * 1 mute     ODU          ODU    mute  
 */
function scheduleTask(taskIndex)
{
	refreshLinkInfos();
	if(typeof(taskIndex) == "undefined")
	{
		taskIndex = currentTaskIndex;
	}
	switch(taskIndex)
	{
		case STEP_MUTE_REMOTE_ODU:
			setOduWorkStatus_rmute(remoteBg.neId,remoteBg,TYPE_ODUMUTE,TYPE_ODUAUTOCLEAR_ENABLE,(getAutoClearTime()||TYPE_ODUMUTE_TIME));//   :mute     ODU(  ODU online)
			break;
		case STEP_MUTE_LOCAL_ODU:
			setOduWorkStatus_lmute(localBg.neId,localBg,TYPE_ODUMUTE,TYPE_ODUAUTOCLEAR_DISABLE);//   :mute     ODU(  ODU online)
			break;
		case STEP_QUERY_LOCAL_ODU_FREQFILTER:
			queryODUFilterBandwidth(localBg.neId,localBg.mOduSlotId);//        ODU                 ODU          (  ODU online)
			break;
		case STEP_MINIMIZE_LOCAL_ODU_FREQFILTER:
			minimizeODUFilterBandwidth(localBg.neId,localBg.mOduSlotId,(getLowcfgFreq() || localBg.minFreq),localBg.minFilter);//                   (  ODU online)
			break;
			/**           *************************************************************************/
		case STEP_SET_LOCAL_ODU_FREQ:
			setOduTXFreq(localBg.neId,localBg.mOduSlotId,localBg.nextFreq);//        ODU    
			break;
		case STEP_QUERY_LOCAL_ODU_RXPOWER:
			queryOduRXPower(localBg.neId,localBg.mOduSlotId);//              ODU     (  ODU online)
			break;
		case STEP_ADD_LOCAL_ODU_POINT:
			{
				if(true == STEP_STOP_FREQSCAN)
				{
					break;
				}
				if(localBg.isValidPoint_x && localBg.isValidPoint_y)
				{
					var dataValue = {x:localBg.cfgFreq,y:localBg.curRxPower};
					CurrentData[CurrentData.length] = dataValue;
					if ($("imgdiv").style.display == "") 
					{
						chart.addNextPoint(localBg.cfgFreq, localBg.curRxPower);//           
					}
					addRow2Talbe(localBg.cfgFreq,localBg.curRxPower);//         
				}
				if(localBg.nextFreq <= (getHigcfgFreq() || localBg.maxFreq))
				{
					localBg.cfgFreq = localBg.nextFreq;
					currentTaskIndex = STEP_SET_LOCAL_ODU_FREQ;
					scheduleTask(STEP_SET_LOCAL_ODU_FREQ);
				}
				else
				{
					currentTaskIndex = STEP_UNMUTE_LOCAL_ODU;
					scheduleTask(STEP_UNMUTE_LOCAL_ODU);
				}
				break;
			}
			/**           ************************************************************************/
		case STEP_UNMUTE_LOCAL_ODU:
			setOduWorkStatus_lunmute(localBg.neId,localBg,TYPE_ODUUNMUTE,TYPE_ODUAUTOCLEAR_ENABLE);//            ODU  
			break;
		case STEP_RESET_LOCAL_ODU_FREQFILTER:
			resetODUFilterBandwidth(localBg.neId,localBg.mOduSlotId,localBg.curFreq,localBg.curFilter);//                      (  ODU online)
			break;
		default:
			{
				var endDate = new Date();
				endTime = createTime(endDate, false);
				addTimeStamp(RESOURCE["time"] + beginTime + "-" + endTime);//       
				STEP_STOP_FREQSCAN = true;
				
				$("oduslotid_input").disabled = false;
				$("stopscan_label").disabled = true;
				$("startscan_label").disabled = !btnRightArr.startscan_label.right;
				$("freqscan_low_input").disabled = false;
				$("freqscan_hig_input").disabled = false;
				$("freqscanstep_input").disabled = false;
				$("oduautounmute_input").disabled = false;
				$("chbMuteFar").disabled = false;
				$("saveimgbtn").disabled = false;
			    $("savebtn").disabled = false;
			    
				break;
			}
	}
}

function addTimeStamp(timestr)
{
	var timestamp = (timestr||"");
	chart.options.subtitle.text = timestamp;
	if ($("imgdiv").style.display == "") 
	{
		chart.render();
		hasRedrawed = true;
	}
}


/**
 * step1:       ODU       
 * @param neidValue
 * @param oduslotid         odu  
 * @param status 0:mute 1:unmute
 * @return
 */
function setOduWorkStatus_lmute(neidValue,oduslotid,/*0:mute 1:unmute*/status,autoclear,time)
{
	if(true == STEP_STOP_FREQSCAN || TYPE_INVALID_NEID == neidValue)
	{
		return;
	}
	
	var xmlstr = createSetOduWorkStatusXML(neidValue,oduslotid,status,autoclear,time);
	var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
    if(isRFIterface)
    {
        urlreq = getRootPath(neidValue)+"/neExlorerServlet?sfid=" + SET_RF_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    else
    {
        urlreq = getRootPath(neidValue)+"/neExlorerServlet?sfid=" + SET_ODU_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
	loadXMLdoc(urlreq, "POST", true, callbackSetOduWorkStatus_lmute,status, "inputdata=" + xmlstr);
}

function setOduWorkStatus_rmute(neidValue,oduslotid,/*0:mute 1:unmute*/status,autoclear,time)
{
	if(true == STEP_STOP_FREQSCAN)
	{
		return;
	}
	if(TYPE_INVALID_NEID == neidValue || !$("chbMuteFar").checked)
	{
		currentTaskIndex = STEP_MUTE_LOCAL_ODU;
		scheduleTask(STEP_MUTE_LOCAL_ODU);
		return;
	}
	var xmlstr = createSetOduWorkStatusXML(neidValue,oduslotid,status,autoclear,time);
	var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
    if(isRFIterface)
    {
        urlreq = getRootPath(neidValue)+ "/neExlorerServlet?sfid=" + SET_RF_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    else
    {
        urlreq = getRootPath(neidValue)+ "/neExlorerServlet?sfid=" + SET_ODU_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    AjaxLoading = true;
	loadXMLdoc(urlreq, "POST", true, callbackSetOduWorkStatus_rmute,status, "inputdata=" + xmlstr);
	setTimeout(muteLocalODUDelay,1000);
}

function muteLocalODUDelay()
{
	currentTaskIndex = STEP_MUTE_LOCAL_ODU;
	scheduleTask(STEP_MUTE_LOCAL_ODU);
}

function setOduWorkStatus_lunmute(neidValue,oduslotid,/*0:mute 1:unmute*/status,autoclear,time)
{
	if(TYPE_INVALID_NEID == neidValue)
	{
		return;
	}
	var xmlstr = createSetOduWorkStatusXML(neidValue,oduslotid,status,autoclear,time);
	var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
	if(isRFIterface)
    {
        urlreq = getRootPath(neidValue) + "/neExlorerServlet?sfid=" + SET_RF_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    else
    {
        urlreq = getRootPath(neidValue)+ "/neExlorerServlet?sfid=" + SET_ODU_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
	AjaxLoading = true;
	loadXMLdoc(urlreq, "POST", true, callbackSetOduWorkStatus_lunmute,status, "inputdata=" + xmlstr);
}

function createSetOduWorkStatusXML(neidValue,oduslotid,/*0:mute 1:unmute*/status,autoclear/*0:disable 1:enable*/,time)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	 
	var neboard = oduslotid;
	if("0" == status )
	{
		if(neboard.protectType != null)
		{
			row = new tagElement("row-params");
			
			createXMLparam(row,"neid",neboard.neId);
			createXMLparam(row,"slotid",neboard.pOduSlotId);
			createXMLparam(row,"W32BRD_ATTR_WORKSTATUS", status);//  odu    
			createXMLparam(row,"opType", TYPE_AUTOCLEARODUMUTE);//      
			
			createXMLparam(row,"isAutoClear", ""+autoclear);//  odu   mute  ,      
			createXMLparam(row,"autoClearTime", autoclear*(time||5));//                 5s
			
			createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
			
			bussiness.appendChild(row);
		}
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.mOduSlotId);
		createXMLparam(row,"W32BRD_ATTR_WORKSTATUS", status);//  odu    
		createXMLparam(row,"opType", TYPE_AUTOCLEARODUMUTE);//      
		createXMLparam(row,"isAutoClear", ""+autoclear);//  odu   mute  ,      
		createXMLparam(row,"autoClearTime", autoclear*(time||5));//                 5s
		
		createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
		bussiness.appendChild(row);
	}
	else
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.mOduSlotId);
		createXMLparam(row,"W32BRD_ATTR_WORKSTATUS", status);//  odu    
		createXMLparam(row,"opType", TYPE_AUTOCLEARODUMUTE);//      
		createXMLparam(row,"isAutoClear", ""+autoclear);//  odu   mute  ,      
		createXMLparam(row,"autoClearTime", autoclear*(time||5));//                 5s
		createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
		
		bussiness.appendChild(row);
		if(neboard.protectType != null)
		{
			row = new tagElement("row-params");
			createXMLparam(row,"W32BRD_ATTR_WORKSTATUS", status);//  odu    
			createXMLparam(row,"opType", TYPE_AUTOCLEARODUMUTE);//      
			
			createXMLparam(row,"isAutoClear", ""+autoclear);//  odu   mute  ,      
			createXMLparam(row,"autoClearTime", autoclear*(time||5));//                 5s
			createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
			
			bussiness.appendChild(row);
		}
	}
	
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function callbackSetOduWorkStatus_lmute(doc,param)
{
	var data = EncapsulateData(doc);
	if(OPERATION_SUCCESS == data.getSErrorCode())
	{
		localBg.oduWork = (param || TYPE_ODUMUTE);//  ODU    
		currentTaskIndex = STEP_QUERY_LOCAL_ODU_FREQFILTER;
		scheduleTask(STEP_QUERY_LOCAL_ODU_FREQFILTER);
	}
	else
	{
		showErrorDialog(data);
		errCauseStop(STEP_INVALID_TASK);
	}
}

function callbackSetOduWorkStatus_rmute(doc)
{
	AjaxLoading = false;
	/*
	var data = EncapsulateData(doc);
	if(OPERATION_SUCCESS == data.getSErrorCode())
	{
		currentTaskIndex = STEP_QUERY_LOCAL_ODU_FREQFILTER;
		scheduleTask(STEP_QUERY_LOCAL_ODU_FREQFILTER);
	}
	else
	{
		showErrorDialog(data);
		errCauseStop(STEP_UNMUTE_LOCAL_ODU);
	}
	*/
}
function callbackSetOduWorkStatus_lunmute(doc,param)
{
	AjaxLoading = false;
	var data = EncapsulateData(doc);
	if(OPERATION_SUCCESS == data.getSErrorCode())
	{
		localBg.oduWork = (param || TYPE_ODUUNMUTE);//  ODU    
		if(isNeedResetLocalOduFre)
		{
			currentTaskIndex = STEP_RESET_LOCAL_ODU_FREQFILTER;
			scheduleTask(STEP_RESET_LOCAL_ODU_FREQFILTER);
		}else{
			errCauseStop(STEP_INVALID_TASK);
		}		
	}
	else
	{
		showErrorDialog(data);
		if(isNeedResetLocalOduFre)
		{
			errCauseStop(STEP_RESET_LOCAL_ODU_FREQFILTER);
		}else{
			errCauseStop(STEP_INVALID_TASK);
		}
		
	}
}
/**
 * step2:    ODU               
 * @param neidValue
 * @param oduslotid:odu  
 * @return
 */
function queryODUFilterBandwidth(neidValue,oduslotid)
{
	var xmlstr = createQueryODUFilterBandwidthXML(neidValue,oduslotid);
	var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
    if(isRFIterface)
    {
        urlreq = getRootPath(neidValue)+"/neExlorerServlet?sfid=" + QUERY_RF_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    else
    {
        urlreq = getRootPath(neidValue)+"/neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
	loadXMLdoc(urlreq, "POST", true, callbackQueryODUFilterBandwidth,null, "inputdata=" + xmlstr);
}

function createQueryODUFilterBandwidthXML(neidValue,oduslotid)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	createXMLparam(row,"neid",neidValue);
	createXMLparam(row,"slotid", oduslotid);
	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32BRD_ATTR_CURFILTERBANDWIDTH");//         
	createXMLparam(row,"attrId","W32BRD_ATTR_CURFILTERBANDWIDTH_ALL");//           
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function callbackQueryODUFilterBandwidth(doc)
{
	var data = EncapsulateData(doc);
	if(OPERATION_SUCCESS == data.getSErrorCode())
	{
		localBg.curFilter = parseFloat(data.getDataRowParam(0, "W32BRD_ATTR_CURFILTERBANDWIDTH")||"0");
		localBg.minFilter = parseFloat((data.getDataRowOptions(0, "W32BRD_ATTR_CURFILTERBANDWIDTH_ALL")||[0])[0]);//         ,      
		
		currentTaskIndex = STEP_MINIMIZE_LOCAL_ODU_FREQFILTER;
		scheduleTask(STEP_MINIMIZE_LOCAL_ODU_FREQFILTER);
		isNeedResetLocalOduFre = true;
	}
	else
	{
		showErrorDialog(data,["nename","slotid","boardname"]);
		errCauseStop(STEP_UNMUTE_LOCAL_ODU);
		isNeedResetLocalOduFre = false;
	}
}

/**
 * step3 1     ODU                ;2     ODU            
 * @param neidValue
 * @param oduslotid odu  
 * @return
 */
function setOduTXFreq(neidValue,oduslotid,freq)
{
	if(true == STEP_STOP_FREQSCAN)
	{
		return;
	}
	var xmlstr = createSetOduTXFreqXML(neidValue,oduslotid,freq);
	var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
	if(isRFIterface)
    {
        urlreq = getRootPath(neidValue)+"/neExlorerServlet?sfid=" + SET_RF_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    else
    {
        urlreq = getRootPath(neidValue)+"/neExlorerServlet?sfid=" + SET_ODU_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
	AjaxLoading = true;
	loadXMLdoc(urlreq, "POST", true, callbackSetOduTXFreq,null, "inputdata=" + xmlstr);
}

function createSetOduTXFreqXML(neidValue,oduslotid,freq)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	createXMLparam(row,"neid",neidValue);
	createXMLparam(row,"slotid", oduslotid);
	createXMLparam(row,"W32BRD_ATTR_TRANSMITFRE",freq*1000);//  ODU      
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function callbackSetOduTXFreq(doc)
{
	AjaxLoading = false;
	var data = EncapsulateData(doc);
	var errCode = parseInt(data.getSErrorCode());
	if(OPERATION_SUCCESS == errCode)
	{
		localBg.nextFreq += getFreqStep();//              
		localBg.isValidPoint_x = true;
		
		currentTaskIndex = STEP_QUERY_LOCAL_ODU_RXPOWER;
		scheduleTask(STEP_QUERY_LOCAL_ODU_RXPOWER);
	}
	else
	{
		localBg.isValidPoint_x = false;
		showErrorDialog(data,["nename","slotid","boardname"]);
		errCauseStop(STEP_UNMUTE_LOCAL_ODU);
	}
}

/**
 * step4             ODU     
 * @param neidValue
 * @param oduslotid ODU   
 * @return
 */
function queryOduRXPower(neidValue,oduslotid)
{
	if(true == STEP_STOP_FREQSCAN)
	{
		return;
	}
	var xmlstr = createQueryOduRXPowerXML(neidValue,oduslotid);
	var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
    if(isRFIterface)
    {
        urlreq = getRootPath(neidValue)+ "/neExlorerServlet?sfid=" + QUERY_RF_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    else
    {
        urlreq = getRootPath(neidValue)+ "/neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    AjaxLoading = true;
	loadXMLdoc(urlreq, "POST", true, callbackQueryOduRXPower,null, "inputdata=" + xmlstr);
}

function createQueryOduRXPowerXML(neidValue,oduslotid)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	createXMLparam(row,"neid",neidValue);
	createXMLparam(row,"slotid", oduslotid);
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTTRANSMITPOWER");//  ODU      
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTRECEIVEPOWER");//  ODU      
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function callbackQueryOduRXPower(doc)
{
	AjaxLoading = false;
	var data = EncapsulateData(doc);
	var errCode = parseInt(data.getSErrorCode());
	if(OPERATION_SUCCESS == errCode && "/" != data.getDataRowParam(0, "W32BRD_ATTR_ACTRECEIVEPOWER"))
	{
		var rxPower = parseFloat(data.getDataRowParam(0, "W32BRD_ATTR_ACTRECEIVEPOWER"));
		localBg.curRxPower = rxPower;// - rxPNower[localBg.minFilter || 7];
		
		localBg.isValidPoint_y = true;
		
		currentTaskIndex = STEP_ADD_LOCAL_ODU_POINT;
		scheduleTask(STEP_ADD_LOCAL_ODU_POINT);
	}
	else
	{
		localBg.isValidPoint_y = false;
		showErrorDialog(data,["nename","slotid","boardname"]);
		errCauseStop(STEP_UNMUTE_LOCAL_ODU);
	}
}

/**
 *                  (  ODU online)
 * @param neidValue
 * @param oduslotid
 * @param freq
 * @param filter
 * @return
 */
function minimizeODUFilterBandwidth(neidValue,oduslotid,freq,filter)
{
	if(true == STEP_STOP_FREQSCAN)
	{
		return;
	}
	var xmlstr = createResetODUFilterBandwidthXML(neidValue,oduslotid,freq,filter);
	var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
    if(isRFIterface)
    {
        urlreq = getRootPath(neidValue) + "/neExlorerServlet?sfid=" + SET_RF_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    else
    {
        urlreq = getRootPath(neidValue) + "/neExlorerServlet?sfid=" + SET_ODU_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    AjaxLoading = true;
	loadXMLdoc(urlreq, "POST", true, callbackMinimizeODUFilterBandwidth,freq, "inputdata=" + xmlstr);
}

function resetODUFilterBandwidth(neidValue,oduslotid,freq,filter)
{
	var xmlstr = createResetODUFilterBandwidthXML(neidValue,oduslotid,freq,filter);
	var isRFIterface = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_RTN_CFG_ODUINTERFACE","TE_ATTR_RTN_ISRFINTERFACE");
    if(isRFIterface)
    {
        urlreq = getRootPath(neidValue) + "/neExlorerServlet?sfid=" + SET_RF_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    else
    {
        urlreq = getRootPath(neidValue) + "/neExlorerServlet?sfid=" + SET_ODU_INTERFACE + "&nmUser=" + obj["nmUser"];
    }
    AjaxLoading = true;
	loadXMLdoc(urlreq, "POST", true, callbackResetODUFilterBandwidth,freq, "inputdata=" + xmlstr);
}

function createResetODUFilterBandwidthXML(neidValue,oduslotid,freq,filter)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	createXMLparam(row,"neid",neidValue);
	createXMLparam(row,"slotid", oduslotid);
	createXMLparam(row,"W32BRD_ATTR_TRANSMITFRE",freq*1000);//ODU      
	createXMLparam(row,"W32BRD_ATTR_CURFILTERBANDWIDTH",filter*1000);//       
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function callbackMinimizeODUFilterBandwidth(doc,param)
{
	AjaxLoading = false;
	var data = EncapsulateData(doc);
	if(OPERATION_SUCCESS == data.getSErrorCode())
	{
		localBg.cfgFreq = (param || localBg.minFreq);//          
		localBg.nextFreq = localBg.cfgFreq;//        
		currentTaskIndex = STEP_SET_LOCAL_ODU_FREQ;
		scheduleTask(STEP_SET_LOCAL_ODU_FREQ);
	}
	else
	{
		showErrorDialog(data,["nename","slotid","boardname"]);
		errCauseStop(STEP_UNMUTE_LOCAL_ODU);
	}
}

function callbackResetODUFilterBandwidth(doc,param)
{
	AjaxLoading = false;
	var data = EncapsulateData(doc);
	if(OPERATION_SUCCESS == data.getSErrorCode())
	{
		localBg.cfgFreq = (param || localBg.curFreq);
		currentTaskIndex = STEP_INVALID_TASK;
		scheduleTask(STEP_INVALID_TASK);
	}
	else
	{
		showErrorDialog(data,["nename","slotid","boardname"]);
		errCauseStop(STEP_INVALID_TASK);
	}
}

function showErrorDialog(data,errArr)
{
	var errArr = errArr || ["nename"];
	openErrPage("../../../../page/", data.getError(), errArr);
}

/**
 *       -ODU         
 * @return
 */
function BoardGroup()
{
	this.neId = -1;
	this.protectType = null;
	this.convert = null;
	
	this.mSlotId = null;//     
	this.mBoardName = null;//     
	this.mIfPhy = null;//            
	this.bandwidth = null;//         
	this.mOduSlotId = null;//      
	this.mOduPhy = null;//            
	this.mOduName = "ODU";//             ODU FO     ODU 
	this.oduWork = null;//        0:mute 1:unmute
	this.pOduSlotId = null;//        ODU  
	this.pOduPhy = null;//              
	
	this.minFilter = null;//           KHz
	this.curFilter = null;//           KHz
	this.curFreq = null;//         
	this.minFreq = null;//                
	this.maxFreq = null;//                
	
	this.cfgFreq = null;//                  
	this.curRxPower = null;//                  
	this.nextFreq = null;//              
	
	this.isValidPoint_x = false;//  x      
	this.isValidPoint_y = false;//  y      
}

function getExistBG(oduslotidValue)
{
	if("" == oduslotidValue)
	{
		return null;
	}
	return JSON.parse(oduslotidValue);
}

function createXMLparam(row, name, value)
{
	var param = new tagElement("param", name, value);
	row.appendChild(param);
	return param;
}

function addRow2Talbe(txFreq, rxPower)
{
	if (txFreq == null || rxPower == null)
	{
		return;
	}
	st.removeEmptyTr();
	var _txFreq = parseFloat(txFreq).toFixed(3);
	var _rxPower = parseFloat(rxPower).toFixed(2);
	var row = st.createRow();
	
	var txFreqCell = st.createCell(tc.getColWidth(0));
	var txFreqAtom = st.createAtom(tc.getColShowType(0));
	txFreqAtom.setValue(_txFreq);
	st.setCellValue(txFreqCell, tc.getColId(0), _txFreq);
	st.setCellIsEdit(txFreqCell, tc.getIsEdit(0));
	st.addCellShow(txFreqCell, txFreqAtom);
	st.addCell(row, tc.getColId(0), txFreqCell);
	
	var rxPowerCell = st.createCell(tc.getColWidth(1));
	var rxPowerAtom = st.createAtom(tc.getColShowType(1));
	rxPowerAtom.setValue(_rxPower);
	st.setCellValue(rxPowerCell, tc.getColId(1), _rxPower);
	st.setCellIsEdit(rxPowerCell, tc.getIsEdit(1));
	st.addCellShow(rxPowerCell, rxPowerAtom);
	st.addCell(row, tc.getColId(1), rxPowerCell);
	
	st.addRow(row);

	adjustTableLayout(st, tc);
}

/**
 *          
 * @return
 */
function saveAsInfo()
{
    if (0 == st.getDataRowLength()) 
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    var title = RESOURCE["resultstable"] + "(" + RESOURCE["time"] + beginTime;
    if(endTime == "")
    {
    	title += "-" + endTime;
    }
    title += ")";
    openSaveAsPage('../../../../page/', title, 'st');
}

function saveAsImage()
{
    if (0 == chart.getPointCount()) 
    {
        alert(RESOURCE["nodata"]);
        return;
    }
    imgName = timeToName(beginTime) + "_" + timeToName(endTime); //     
    chart.options.exporting.filename = imgName;
	chart.exportChart(chart.options);
}

function timeToName(/*String*/time)
{
	var temp;
	var rtn = "";
	for (var i = 0, len = time.length; i < len; i++)
	{
		temp = time.charAt(i);
		if (isNaN(temp) || temp == " ")
		{
			continue;
		}
		rtn += temp;
	}
	return rtn;
}

function chnMuteFarOnClick()
{
	if($("chbMuteFar").checked)
	{
		$("oduautounmute_input").disabled = false;
	}
	else
	{
		$("oduautounmute_input").disabled = true;
	}
}
