var chart = null;
function drawPowerGrap(xAxisName,yAxisName)
{
	chart = new Highcharts.Chart({
		chart:
		{
			renderTo: 'freqscanimgdiv',
			inverted: false,
			defaultSeriesType: 'spline',
			backgroundColor: '#EFEFEF',//     
			marginRight: 40,
			marginBottom: 40,
			marginTop: 5
		},
		subtitle: 
		{
			text: '',
			align: 'left',
			verticalAlign: 'bottom',
			y: 5, // docs
			style:
			{
				color: '#3E576F'
			}
		},
		xAxis: {
			title: 
			{
				text: xAxisName
			},
			endOnTick: false,
			startOnTick: true,
			gridLineWidth: 0,
			tickWidth: 1,
			tickPosition: 'inside',
			showLastLabel: true,
			tickmarkPlacement: 'on',
			minPadding: 0.02,
			maxPadding: 0.02,
			maxZoom: 60
		},
		yAxis:
		{
			title: 
			{
				text: yAxisName
			},
			tickWidth: 1,
			showLastLabel: true,
			minPadding: 0.01,
			maxPadding: 0.01,
			maxZoom: 60,
			labels:
			{
				formatter: function()
				{
					return this.value;// +'dBm';
				}
			},
			plotLines:
				[{value: 0,width: 1,color: '#808080'}]
		},
		tooltip: {
			crosshairs:
				[{
					value:true,
					color:'#808080'
				}],
			borderWidth: 1,
			formatter:
				function()
				{
		                return /*'<b>'+ this.series.name +'</b><br/>'+*/ this.x + ' MHz' +' : '+ this.y +' dBm';
				}
		},
		legend: {
			enabled: false,
			layout: 'vertical',
			align: 'right',
			verticalAlign: 'top',
			x: -10,
			y: 100,
			borderWidth: 0
		},
		plotOptions: 
		{
			spline:
			{
				lineWidth: 1, //     
				dataLabels: 
				{
					x: 40,
					y: -15,
					enabled: false  //     
				},
				states: {
					hover: {
						lineWidth: 2
					}
				},
				enableMouseTracking: true, //     
				marker: 
				{
					enabled: true,
					radius: 2,
					lineColor: '#FFFFFF',
					states:
					{
						hover: 
						{
							lineColor: '#000000',//marker      
							radius: 4
						}
					}
				}
			}
		},
		series: series,
		exporting: 
		{
			filename: imgName,
			url: '../../../../saveSVGImageAsGrap?neid=' + neid,
			type: 'image/jpeg',
			buttons: 
			{
				exportButton: 
				{
					enabled: false //     
				},
				printButton: 
				{
					enabled: false //     
				}
			}
		}
	});
}
