 loadXMLdoc("../../../../conf/system.xml", "GET", false,EncapsulateSConf);
loadXMLdoc("../../../../help/"+SYSTEMCONF.getLanguage()+"/helpidresource.xml", "GET", false,EncapsulateHelpConfig);
getResourse("../../res/fastconfig/fastconfig_" + SYSTEMCONF.getLanguage() + ".xml");

document.title = RESOURCE["title"];
var obj = parseURLStr(this);
var neid = obj.neid;  //     ID
var neType = parseInt(obj.netype);
var pmode = -1;  //        
var winp;//        
var allMode;//        
var wlinkId = 1;  //       ID    
var wtf = 0;  //             
var plinkId = 1;  //       ID    
var ptf = 0;  //             


var closeflag = 0;

var pagenum = obj.pagenum ;

function initPage()
{
    createText(pagenum);
    
   document.title = RESOURCE["title"];
   
   document.getElementById("boardlabel").innerHTML = RESOURCE["ifboard"];
   document.getElementById("modelabel").innerHTML = RESOURCE["workmode"];
   document.getElementById("linklabel").innerHTML = RESOURCE["linkid"];
   document.getElementById("stationlabel").innerHTML = RESOURCE["station"];
   document.getElementById("tflabel").innerHTML = RESOURCE["tfrequency"];
   document.getElementById("trlabel").innerHTML = RESOURCE["trinterval"];
   document.getElementById("tplabel").innerHTML = RESOURCE["tpower"];   
   
   document.getElementById("upStep").value = RESOURCE["upstep"];
   document.getElementById("nextStep").value = RESOURCE["nextstep"];
   document.getElementById("exit").value = RESOURCE["exit"];
   
   var stationSel = document.getElementById("station");
   stationSel.options[stationSel.options.length] = new Option(RESOURCE["lowstation"], 5);
   stationSel.options[stationSel.options.length] = new Option(RESOURCE["highstation"], 10);
   
   document.getElementById("linkid").style.imeMode = "disabled"; 
   document.getElementById("tfrequency").style.imeMode = "disabled"; 
   document.getElementById("trinterval").style.imeMode = "disabled"; 
   document.getElementById("tpower").style.imeMode = "disabled";  
   document.getElementById("station").disabled = true;
   
   
   checkText(document.getElementById("tpower"), "-10.0","35.0");
   
   checkText(document.getElementById("linkid"), "1","4094");
   
   checkTFText(document.getElementById("tfrequency"), "1","4294967295");
   
   checkText(document.getElementById("trinterval"), "1","4294967295");
   winp = window.dialogArguments;  
}

function checkTFText(obj,min,max,decimalCount)
{	
	
	
	obj.style.imeMode = "disabled";
	
	obj.onpaste = function()
	{
		return false;
	}
	
    obj.onblur = function()
	{
		blurValidate(obj,min,max,decimalCount);
		var ifSel = document.getElementById("ifboard");
	    if (ifSel.options.selectedIndex == 0)
	    {
	       wtf = obj.value;
		
	    }
	    else
	    {
	       ptf = obj.value;
	    }
    }
    
    obj.onkeypress = function()
    {
        return digitalCheck(obj, min, max,decimalCount);    	
    }
}

function init()
{
   var root = new inputxml("datainterface");
   var firstlevel = new tagElement("bussiness-params");
   var secondlevel = new tagElement("row-params");
   var thirdlevel = new tagElement("param");
   thirdlevel.setAttribute("name", "neid");
   thirdlevel.setAttribute("value", neid);
   secondlevel.appendChild(thirdlevel);
   firstlevel.appendChild(secondlevel);
   root.getRoot().appendChild(firstlevel);
   
   loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_RNT_FASTCFG_GET_BDPROPERY+"&flag=1", "POST", false, initData, null, "inputdata=" + root.toString());
}

function testnextStep()
{
	closeflag = 1;
    winp.isexit = false;
    winp.communication = true;
    winp.pageurl = "portfoliocfg.html?neid=" + neid + "&netype=" + neType+ "&pagenum=" + 3;
    window.close();
}

function initData(doc)
{   	 
    var data = EncapsulateData(doc);  //       XML      
    if (data.getDataRowLength() > 0)
    {    	
        var pm = data.getDataRowParam(0, "mode");  //      
        if (pm != null && pm != "")
        {
            pmode = parseInt(pm);  // pm      pmode
        }
        var board = document.getElementById("ifboard");
        var ifboard = data.getDataRowParam(0, "board");  //      
        board.options[board.options.length] = new Option(ifboard, ifboard);
        var ifboardOptions = data.getDataRowOptions(0, "board");  //       
        if (ifboardOptions != null)
        {
            for (var i = 0; i < ifboardOptions.length; i++)
            {
                ifboard = ifboardOptions[i];
                board.options[board.options.length] = new Option(ifboard, ifboard);
            }
        }
        board.selectedIndex = 0;
        
        board.onchange = linkage;
        var wmSel = document.getElementById("wmode");               
        allMode = data.getDataRowParam(0, "wmode");
        if (null != allMode && "" != allMode)
        {
        	 document.getElementById("nextStep").disabled = false;
        	 var wmode = allMode;
	         var wmodes = wmode.split("%");  //        
	         var curwmode = parseInt(data.getDataRowParam(0, "curwmode"));  //                
		     for (var j = 0; j < wmodes.length; j++)
		     {
		         wmode = wmodes[j];
		         var modeId =  parseInt(wmode.substring(0, wmode.indexOf(",")));  //      ID
		         var wmodeShow = modeId + ") " + wmode.substring(wmode.indexOf(",") + 1, wmode.length);
		         wmSel.options[wmSel.options.length] = new Option(wmodeShow, wmode);
		         
		         if (modeId == curwmode)
		         {
		             wmSel.options.selectedIndex = j;
		         }  	           	        	        	        
		     }	 	      
        }         
            
	    var linkId = data.getDataRowParam(0, "wlinkid");  //        ID
	    if (linkId != null && parseInt(linkId) > 0)
	    {
	       document.getElementById("linkid").value = linkId;
	       wlinkId = linkId;
	    }
	    var station = data.getDataRowParam(0, "station");  //      
	    var stationSel = document.getElementById("station");
	    if (station != null && station != "0")
	    {	      
	       for (var k = 0; k < stationSel.length; k++)
	       {
	           if (stationSel.options[k].value == station)
	           {
	               stationSel.selectedIndex = k;
	               break;
	           }
	       }
	    }
	    else
	    {
	    	stationSel.selectedIndex = -1;
	    }
	    var tf = data.getDataRowParam(0, "wtf");  //          
	    if (tf != null)
	    {
	        document.getElementById("tfrequency").value = tf;
	        wtf = tf;
	    }
	    var tr = data.getDataRowParam(0, "tr");  //      
	    if (tr != null)
	    {
	        document.getElementById("trinterval").value = tr;
	    }
	    var tp = data.getDataRowParam(0, "tp");   //      
	    if (tp != null)
	    {
	        document.getElementById("tpower").value = tp;
	    }
	    var linkId2 = data.getDataRowParam(0, "plinkid");  //         ID
	    if (linkId2 != null)
	    {
	        plinkId = linkId2;
	    }
	    var tf2 = data.getDataRowParam(0, "ptf");  //          
	    if (tf2 != null)
	    {
	        ptf = tf2;
	    }
        if (null != allMode && "" != allMode)
        {
	    	checkNull(document.getElementById("linkid"));
	    	checkNull(document.getElementById("tfrequency"));
	    	checkNull(document.getElementById("trinterval"));
	    	checkNull(document.getElementById("tpower"));
	    }
    }     
}

function linkage()
{
    
    var ifboard = document.getElementById("ifboard");  //          
    var wmode = document.getElementById("wmode");
    var linkid = document.getElementById("linkid");
    var station = document.getElementById("station");
    var tf = document.getElementById("tfrequency");
    var tr = document.getElementById("trinterval");
    var tp = document.getElementById("tpower");
    switch (ifboard.options.selectedIndex)
    {
        case 0:  //                
            linkid.value = wlinkId;
            tf.value = wtf;  
		    wmode.disabled = false;
		    linkid.disabled = false;
		    tf.disabled = false;
		    tr.disabled = false;
		    tp.disabled = false;
		    break;
	    case 1:  //                
	        if (pmode != 1)
		    {		         
		         tf.disabled = "disabled";
		    }
		    else
		    {
                tf.value = ptf;
		    }
		    linkid.disabled = "disabled";
	        wmode.disabled = "disabled";
		    tr.disabled = "disabled";
		    tp.disabled = "disabled";
		    break;
    }
}

/**
*            
* @param obj       
* @param min     
* @param max     
* @param alertfalg          
* @param isfloat                
*/
function digitalCheck(obj, min, max, alertflag, isfloat, unit, tipstr)
{
    var tip = RESOURCE[obj.id] + RESOURCE[tipstr] + "[" + min + "-" + max + "]";
    
    var code=event.keyCode;
    var ch = String.fromCharCode(code);
    if(code==13){
        return false;
    }
    
    if(code == 8 || code == 46 || code == 9){
    	return true;   //DEL   
    }
    if(code > 36 && code < 41){
        return true;        //   
    }
    if(event.ctrlKey){
        if(ch == 'X' || ch == 'C' || ch == 'V' || ch == 'A'){  //X C V A
            return true;
        }
        else{
            return false;
        }
    }
    if(event.shiftKey){
        return false;
    }
    if (min < 0)
    {
       if (isfloat)
       {
          if ((code < 48 || (code > 57 && code < 96 ||code > 105)) && code != 109 && code != 189 && code != 110 && code != 190)
          {
             return false;
          }
       }
       else
       {
          if ((code < 48 || (code > 57 && code < 96 ||code > 105)) && code != 109 && code != 189)
          {
             return false;
          }
       }
    }
    else 
    {
        if (isfloat)
        {
          if ((code < 48 || (code > 57 && code < 96 ||code > 105)) && code != 110 && code != 190)
          {
             return false;  //   
          }
        }
        else
        {
           if (code < 48 || (code > 57 && code < 96 ||code > 105))
           {
             return false;  //   
           }
        }
    }
    var value=obj.value;
    pos=digitalTag_getPos(obj);                 //        
    
    if (isfloat)
    {
       if (pos == 0 && (code == 110 || code == 190))
       {
          return false;
       }
       if (value.indexOf(".") > 0 && pos > 0 && (code == 110 || code == 190))
       {
          return false;
       }
       if (value.indexOf(".") < 0 && pos > 0 && (code == 110 || code == 190))
       {
          return true;
       }
       if (value.indexOf(".") > 0)
       {
          var length = value.substr(value.indexOf(".")).length;
          if (length == unit.substr(unit.indexOf(".")).length)
          {
             return false;
          }
       }
    }
    if (min <= 0)
    {
        if (min < 0 && pos == 0 && (code == 109 || code == 189))
        {
           var compareValue = "-" + value;
           return checkRange(compareValue, min, max, alertflag, isfloat, tip, obj);
        }
        if (pos > 0 && (code == 109 || code == 189))
        {
           return false;
        }
        if ((value=='0' || value=="-0") && pos > 0 && code != 110 && code != 190)
        {
            return false;
        }
        var index = value.indexOf("-");
        if (pos == (index + 1) && value.length > (index + 1) && (code == 48 || code == 96))
        { 
            return false;
        }
    }
    else
    {
        if ((code==48 || code==96) && (pos==0))
        {
            return false;
        }
        if (pos == 0 && value.length > 0 && (code == 48 || code == 96))
        { 
            return false;
        }
        if (value=='0' && pos>0)
        {
            return false;
        }
    }
    
    if(code < 58){
        ch = '' + code - 48
    }
    else{
        ch = '' + code - 96
    }
    var SelectChars=document.selection.createRange().text;
    var endleng=0
    if(SelectChars!=null&&SelectChars.length==null){
        endleng=1
    }
    if(SelectChars!=null&&SelectChars.length!=null){
        endleng=SelectChars.length
    }
    var newVal = value.substring(0,pos) + ch + value.substring(pos+endleng);
    return checkRange(newVal, min, max, alertflag, isfloat, tip, obj);
}

function checkRange(value, min, max, alertflag, isfloat, tip, obj)
{
    var flag = false;
    if (isfloat)
    {
       if (parseFloat(value) > parseFloat(max) || parseFloat(value) < parseFloat(min))
       {
           flag = true;
       }
    }
    else
    {
       if (parseInt(value, 10) > max || parseInt(value, 10) < min)
       {
          flag = true;
       }
    }
    if (flag && alertflag)
    {
        alert(tip);
        if ("linkid" == obj.id)           
	    {
	    	var ifSel = document.getElementById("ifboard");
	        if (ifSel.options.selectedIndex == 0)
	        {
	    	    wlinkId = obj.value;
	    	   
	    	}
	    	else
	    	{
	    		if (pmode == 1)
	            {	     	 
	               plinkId = wlinkId; 
	            }      		
	    	}
	    }    
	    if ("tfrequency" == obj.id)           
	    {
	    	var ifSel = document.getElementById("ifboard");
	        if (ifSel.options.selectedIndex == 0)
	        {
	    	    wtf = obj.value;
	    	   
	    	}
	    	else
	    	{
	    		if (pmode == 1)
	            {	     	 
	               ptf = obj.value; 
	            }      		
	    	}
	    }      
        document.getElementById("nextStep").disabled = false;
        return false;
    }
    else if (flag && !alertflag)
    {
        return false;
    }
    else
    {
        return true;
    } 
}

function compare(obj)
{
  if (obj != null)
  {
    if (obj.id == "tfrequency")
    {
      if (wtf == ptf)
      {
         alert(RESOURCE["tfrequencynotsame"]);
         document.getElementById("tfrequency").focus();
	     return false;
      }
    }
  }
  else
  {
      if (wtf == ptf)
      {
         alert(RESOURCE["tfrequencynotsame"]);
         document.getElementById("tfrequency").focus();
	     return false;
      }
  }
  return true;
}

function checkNull(obj)
{
	if (obj.value != null && obj.value != "" && obj.value != "-")
	{
		document.getElementById("nextStep").disabled = false;
	}
	else
	{
		document.getElementById("nextStep").disabled = "disabled";
	}
}

function upStep()
{		
	document.getElementById("upStep").disabled = true;
	setTimeout(uppage,20);
}

function uppage()
{	    
	var pagenum = 0 ;
    var urlvar ;
    if (winp.isifbd == "1")
    {
       urlvar = "ifprotect.html";
       pagenum = 1;	
    }
    else
    {
       urlvar = "boardview_" + neType + ".html";
       pagenum = 0;		
    }
        
    closeflag = 1;
    winp.isexit = false;
    winp.communication = true;
    winp.pageurl = urlvar + "?neid=" + neid + "&netype=" + obj.netype+ "&pagenum=" + pagenum;
    window.close();
}

function nextStep()
{
	document.getElementById("nextStep").disabled = true;
	setTimeout(nextpage,20);
}

function nextpage()
{
	if (pmode == 1)
	{
	    if (!compare())
	    {
	       return false;
	    }	
	}
	if(checkAllNull())
	{
		var oduWorkXML = createODUWorkXML();
		
		loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_RNT_FASTCFG_SET_ODU_WORK+"&flag=1", "POST", false, callBack, null, "inputdata=" + oduWorkXML);
	}
}

function checkAllNull()
{
    var trInterval = document.getElementById("trinterval").value;
    var tpower = document.getElementById("tpower").value;    
    var frqInputValue  = document.getElementById("tfrequency").value/1;
	if ("" === trInterval)
	{
		alert(RESOURCE["trintervalnull"]);
		document.getElementById("nextStep").disabled = false;
		return false;
	}
	if ("" === tpower)
	{
		alert(RESOURCE["tpowernull"]);
		document.getElementById("nextStep").disabled = false;
		return false;
	}
	if ("" === wlinkId)
	{
		alert(RESOURCE["wlinkidnull"]);
		document.getElementById("nextStep").disabled = false;
		return false;
	}
	if ("" === wtf) 
	{
		alert(RESOURCE["wtfrequencynull"]);
		document.getElementById("nextStep").disabled = false;
		return false;
	}    
	if(isNaN(frqInputValue))
    {
        alert(RESOURCE["ptfrequencyIncorrect"]);
        document.getElementById("nextStep").disabled = false;
        return false;
    }
    else
    {
        ptf = frqInputValue;
        if (1 == pmode)
    	{
    		if ("" === ptf)
    		{
                document.getElementById("tfrequency").value = "0";
    			alert(RESOURCE["ptfrequencynull"]);
    			document.getElementById("nextStep").disabled = false;
    			return false;
    		}    		
    	}
    }
	
	return true; 	
}



function exitcallback(doc)
{
	   winp.isexit = true;
	   window.close();
}

function createODUWorkXML()
{   
	var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
        
    var ifbdSel = document.getElementById("ifboard");
    var wbd = ifbdSel.options[0].value;
    var wifbdSlotId = parseInt(wbd.substring(0, wbd.indexOf("-")));
    var woduSlotId = wifbdSlotId + 10;
    
    var secondlevel = new tagElement("row-params");
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", woduSlotId);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "W32BRD_ATTR_WORKSTATUS");
    thirdlevel.setAttribute("value", 1);
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
    
    if (ifbdSel.options.length > 1)
    {      
    	var pbd = ifbdSel.options[1].value;
        var pifbdSlotId = parseInt(pbd.substring(0, pbd.indexOf("-")));
    	var poduSlotId = pifbdSlotId + 10;
    
    	secondlevel = new tagElement("row-params"); 
    	thirdlevel = new tagElement("param"); 
    	thirdlevel.setAttribute("name", "neid");
    	thirdlevel.setAttribute("value", neid); 
    	secondlevel.appendChild(thirdlevel);  
    
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "slotid");
    	thirdlevel.setAttribute("value", poduSlotId);
    	secondlevel.appendChild(thirdlevel);
    
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "W32BRD_ATTR_WORKSTATUS");
    	thirdlevel.setAttribute("value", 1);
    	secondlevel.appendChild(thirdlevel);
    	firstlevel.appendChild(secondlevel);      
    }
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function callBack(doc)
{
    var objerr = EncapsulateData(doc);
	if (objerr.getSErrorCode() == 0)
    {    	  
        var saveXML = createSaveXML();
       	loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_RNT_FASTCFG_SAVE_BDPROPERY+"&flag=0", "POST", false, handleSaveBack, null, "inputdata=" + saveXML);       
        
        var pagenum = 0 ;
        var urlvar ;
        
        
        if (winp.ispdhbd == 1 || winp.ispdhbd == "1")
        {
           urlvar = "portfoliocfg.html";
           
           pagenum = 3;	
        }
        else
        {
           urlvar = "clockorderwirecfg.html";
           
           pagenum = 4;	
        }
        
        closeflag = 1;
        winp.isexit = false;
        winp.communication = true;
    	winp.pageurl = urlvar + "?neid=" + neid + "&netype=" + obj.netype+ "&pagenum=" + pagenum;
        window.close();
    }
    else
    {
        showErrorMessage(objerr);
    }
}

function showErrorMessage(objerr)
{      
    var errArr = [];    
    errArr[0] = "errObjStr";
    var oError = objerr.getError();
    var errObjStr = "";
    if(objerr.getBErrLength() > 0)
    {
        for(var i = 0; i < objerr.getBErrLength(); i++)
        {
            tempErrObjStr = "";
            nename = "";
            if(null != oError.getRowKey(i, "nename") && "" != oError.getRowKey(i, "nename"))
            {
                nename = oError.getRowKey(i, "nename");
            }
            if("-1" == oError.getRowKey(i, "boardtype")) 
            {
                boardname = "ODU"; 
            }
            else
            {  
            	  boardname = oError.getRowKey(i, "boardname");
            } 	
           
            if(null != oError.getRowKey(i, "slotid") && "" != oError.getRowKey(i, "slotid"))
            {
                tempErrObjStr += nename + "-" + oError.getRowKey(i, "slotid")+ "-" + boardname;
            }           
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
    }
    openErrPage("../../../../page/", oError, errArr);     
    errArr = null;
    document.getElementById("nextStep").disabled = false;       
}

function handleSaveBack(doc)
{
}

function createSaveXML()
{	
    var linkid = document.getElementById("linkid");
	wlinkId  = linkid.value;
    
    var ifbdSel = document.getElementById("ifboard");
    var wmSel = document.getElementById("wmode");
    var stationSel = document.getElementById("station");
    var trInterval = document.getElementById("trinterval");
    var tpower = document.getElementById("tpower");  
    var wmode = "0";
    if (-1 != wmSel.selectedIndex && null != wmSel.options && null != wmSel.options[wmSel.selectedIndex])
    {
    	wmode = wmSel.options[wmSel.selectedIndex].value;  
    }       
      
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");   
    var secondlevel = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);   
    
    var wbd = "";
    if (null != ifbdSel.options[0])
    {
    	wbd = ifbdSel.options[0].value;
    }
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "ifboard");
    thirdlevel.setAttribute("value", wbd);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "wmode");
    if (wmode == null || wmode == "")
    {
    	wmode = "0";
    }
    thirdlevel.setAttribute("value", wmode);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "allmode");
    if (allMode == null)
    {
    	allMode = "";
    }
    thirdlevel.setAttribute("value", allMode);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "linkid");
    thirdlevel.setAttribute("value", wlinkId);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "station");
    var station1 = "0";
    if (-1 != stationSel.options.selectedIndex)
    {
    	station1 = stationSel.options[stationSel.options.selectedIndex].value;
    }
    thirdlevel.setAttribute("value", station1);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "tf");
    thirdlevel.setAttribute("value", wtf);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "tr");
    thirdlevel.setAttribute("value", trInterval.value);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "tp");
    thirdlevel.setAttribute("value", tpower.value);
    secondlevel.appendChild(thirdlevel);
    firstlevel.appendChild(secondlevel);
    
    if (ifbdSel.options.length > 1)
    {
      if (pmode == 1)
      {
    	secondlevel = new tagElement("row-params"); 
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "neid");
    	thirdlevel.setAttribute("value", neid);
    	secondlevel.appendChild(thirdlevel);
    
        var pbd = "";
	    if (null != ifbdSel.options[1])
	    {
	    	pbd = ifbdSel.options[1].value;
	    }     
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "ifboard");
    	thirdlevel.setAttribute("value", pbd);
    	secondlevel.appendChild(thirdlevel);
    	
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "wmode");
    	if (wmode == null || wmode == "")
	    {
	    	wmode = "0";
	    }
    	thirdlevel.setAttribute("value", wmode);
    	secondlevel.appendChild(thirdlevel);
    
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "allmode");
	    if (allMode == null)
	    {
	    	allMode = "";
	    }
	    thirdlevel.setAttribute("value", allMode);
	    secondlevel.appendChild(thirdlevel);
    
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "linkid");
    	thirdlevel.setAttribute("value", wlinkId);
    	secondlevel.appendChild(thirdlevel);
    
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "station");
    	var station2 = "0";
	    if (-1 != stationSel.options.selectedIndex)
	    {
	    	station2 = stationSel.options[stationSel.options.selectedIndex].value;
	    }
    	thirdlevel.setAttribute("value", station2);
    	secondlevel.appendChild(thirdlevel);
    
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "tf");
    	thirdlevel.setAttribute("value", ptf);
    	secondlevel.appendChild(thirdlevel);
    
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "tr");
    	thirdlevel.setAttribute("value", trInterval.value);
    	secondlevel.appendChild(thirdlevel);
    
    	thirdlevel = new tagElement("param");
    	thirdlevel.setAttribute("name", "tp");
    	thirdlevel.setAttribute("value", tpower.value);
    	secondlevel.appendChild(thirdlevel);
    	firstlevel.appendChild(secondlevel);
      } 
    }
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function exit()
{	  
	  if (0 == closeflag)
	  {
	  	 
	  	 if(confirm(RESOURCE["confirmquit"]))
       {
	  	 var di = new inputxml("datainterface");
       var bussiness = new tagElement("bussiness-params");
       var row = new tagElement("row-params");
       var param = new tagElement("param");
       param.setAttribute("name", "neid");
       param.setAttribute("value", neid);
       row.appendChild(param);
       bussiness.appendChild(row);
       di.getRoot().appendChild(bussiness);
       var xml = di.toString();
	   loadXMLdoc("../../../../neExlorerServlet?sfid="+TECMDCODE_RNT_FASTCFG_CLEAR_NECACHE+"&flag=1", "POST", false, exitcallback, null, "inputdata="+xml);
       }
	  }	  
}

