var lastselect;
var neobject = getNeProperty(self);

var boardGroupList = new Object(); 
var currentBoardGroup = null;
var remoteBoardGroup = new BoardGroup();

var protect = new Object();
protect["-1"] = "XPIC";
protect["0"] = "1+1 SD";
protect["1"] = "1+1 FD";
protect["2"] = "1+1 HSB";

var PROTECTTYPE_1PLUS1 = "2";
var PROTECTTYPE_XPIC = "-1";

var errNum = 0;
var errMaxNum = 3;
var timeOut = null;
var delayTime = 4000;//ms

var btnRightArr = new Object();

var neidvalue = neobject.neid;
var remoteneidvalue = null;

var LINK_BREAK_VALUE = 0;

var currentTaskIndex = 0;


var STEP_QUERY_SYSTEMPARAM = 10;
var STEP_CALCULATE_DELTAMSE = 11
var STEP_SET_MUTEODU_TX = 12;
var STEP_QUERY_RSL_r_RX = 13;
var STEP_SET_UNMUTEODU_TX = 14
var STEP_QUERY_FADEMARGIN_EXT = 15;

var STEP_QUERY_CUR_RSL0 = 0;
var STEP_QUERY_CUR_MSE0 = 1

var STEP_QUERY_TX = 2;
var STEP_QUERY_TX_RANGE = 3;
var STEP_SET_RSL_s_TX = 4;
var STEP_QUERY_RSL = 5;
var STEP_QUERY_MSE = 6;
var STEP_SET_TX = 7;
var STEP_RESUME_TX = 8;
var STEP_QUERY_MARGIN = 9;

var PER_TX_POWER = 2;

var firstResultStr = "";

var INT_INVALID = 65536;
var INVALID_FADEMARGIN = 65535;

var pageWaitFlag = false;

var fadeMarginWaitInterval = null;

var QUERY_RX_RANGE_FIRST = true;

var QEURY_PEER_NOTFINISH = true;

var ERRORCODE_TIME_OUT = 1090650120;


/*********************************************************/
/*********************************************************/

function init()
{
	initElementRes();
	queryGroup(neidvalue);
	setPageElementState(true);
}

function tabSelectHandler()
{
	queryGroup(neidvalue);
}

/**
 *       
 */
function Pair(value1,value2)
{
	this.value1 = value1;
	this.value2 = value2;
}

/**
 *       
 */
function setPageWait()
{
	pageWaitFlag = true;
	setPageElementState(true);
	document.body.style.cursor = "wait";
}

/**
 *     
 */
function resumePageWait()
{
	pageWaitFlag = false;
	setPageElementState(false);
	document.body.style.cursor = "default";
}

/**
 *        
 */
function getNewLine()
{
	return String.fromCharCode(13, 10);
}

/**
 *             
 *   :BoardGroup
 */
function getTransNeBoardInfo()
{
	if($("rdLocaltoRemote").checked)
	{
		return remoteBoardGroup; 
	}
	else
	{
		return currentBoardGroup;
	}
}

/**
 *         ,  :     
 *          
 *   :  \  
 */
function getTransFirstTitle()
{
	if($("rdLocaltoRemote").checked)
	{
		return RESOURCE["remote"];
	}
	else
	{
		return RESOURCE["local"];
	}
}

/**
 *             
 *   :BoardGroup
 */
function getReceiveNeBoardInfo()
{
	if($("rdLocaltoRemote").checked)
	{
		return currentBoardGroup; 
	}
	else
	{
		return remoteBoardGroup;
	}
}

/**
 *         ,  :     
 *          
 *   :  \  
 */
function getReceiveFirstTitle()
{
	if($("rdLocaltoRemote").checked)
	{
		return RESOURCE["local"];
	}
	else
	{
		return RESOURCE["remote"];
	}
}

function queryGroup(neid,slot)
{
	if(slot != null)
	{
		$("txtResult").value += getNewLine() + RESOURCE["queryxpic1j1"];
		setWaitIntervalStart();
	}
	var xmlstr = createQueryGroupXML(neid,slot);
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_GROUP
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryGroupHandler, slot, "inputdata=" + xmlstr);
}

function createQueryGroupXML(neid,slot)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	createXMLparam(row,"neid",neid)
	if(slot != null)
	{
		createXMLparam(row,"slotId",slot)
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}


function queryGroupHandler(doc,slot)
{
	var data = EncapsulateData(doc);
	if(slot != null)
	{
		setWaitIntervalEnd(data.getSErrorCode());
		firstResultStr = $("txtResult").value;
	}
	else
	{
		var contain = $("contain");
		while (contain.hasChildNodes())
		{
			contain.removeChild(contain.childNodes[0]);
		}
	}
	var len = data.getDataRowLength();

	for ( var i = 0; i < len; i++)
	{
		var boardGroup = null;
		if(slot == null)
		{
			boardGroup = new BoardGroup();
		}
		else
		{
			boardGroup = remoteBoardGroup;
		}
		boardGroup.mSlotId = data.getDataRowParam(i, "mSlotId");
		boardGroup.mIfPhy = data.getDataRowParam(i, "mIfPhy");
		boardGroup.mBoardName = data.getDataRowParam(i, "mBoardName");
		boardGroup.mOduSlotId = data.getDataRowParam(i, "mOduSlotId");
		boardGroup.mOduPhy = data.getDataRowParam(i, "mOduPhy");
		boardGroup.neversion = data.getDataRowParam(i, "neversion")||"";
		var protectType = data.getDataRowParam(i, "protectType");
		if (protectType != null)
		{
			boardGroup.protectType = data.getDataRowParam(i, "protectType");
			boardGroup.pSlotId = data.getDataRowParam(i, "pSlotId");
			boardGroup.pIfPhy = data.getDataRowParam(i, "pIfPhy");
			boardGroup.pBoardName = data.getDataRowParam(i, "pBoardName");
			boardGroup.pOduSlotId = data.getDataRowParam(i, "pOduSlotId");
			boardGroup.pOduPhy = data.getDataRowParam(i, "pOduPhy");
			boardGroup.convert = data.getDataRowParam(i, "convert");
			if(slot == null)
			{
				createIfProtect(boardGroup);
				boardGroupList[getBoardGroupKey(boardGroup)] = boardGroup;
			}
		}
		else if(slot == null)
		{
			createIf(boardGroup);
			boardGroupList[getBoardGroupKey(boardGroup)] = boardGroup;
		}
	}
}

/**
 *         
 *@param boardGroup        
 */
function getBoardGroupKey(boardGroup)
{
	if(boardGroup.protectType == null)
	{
		return boardGroup.mSlotId + "_" + boardGroup.mOduSlotId;
	}
	else
	{
		return boardGroup.protectType + "_" + boardGroup.mSlotId + "_" + boardGroup.mOduSlotId;
	}
}



/**
 *        innerHTML  
 *@param domid      ID
 */
function setElementHTML(domid)
{
	var dome = $(domid);
	dome.innerHTML = RESOURCE[domid];
}

/**
 *           
 */
function initElementRes()
{
	$("btnTest").value = RESOURCE["test"];

	setElementHTML("spLinkId");
	setElementHTML("spLocalNe");
	setElementHTML("spRemoteNe");
	setElementHTML("spTestMode");
	setElementHTML("spAuto");
	setElementHTML("spManual");
	setElementHTML("spTxPower1");
	setElementHTML("spTxPower2");
	setElementHTML("spDirection");
	setElementHTML("spLocaltoRemote");
	setElementHTML("spRemotetoLocal");
	setElementHTML("spResult");
	
	btnRightArr.btnTest = new BtnRightObj("btnTest", query_oduif_params);
	getRightInfo(neobject, btnRightArr);
	$("btnTest").disabled = !btnRightArr.btnTest.right;
}


function queryPeerNE(param)
{
	$("txtLinkId").value = "";
	$("txtLocalNe").value = "";
	$("txtRemoteNe").value = "";
	setPageElementState(true);
	$("txtResult").value=RESOURCE["querylinkandremote"];
	setWaitIntervalStart();
	var slotid = param.split(",")[0];
	var xml = createPeerXML(slotid);
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_HOP_QUEERY_PEERNE 
	+ "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
			
	loadXMLdoc(urlreq, "POST", true, queryPeerNEHandler, param, "inputdata=" + xml);
}


function createPeerXML(slotid)
{
	var di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");

	param = new tagElement("param");
	neidvalue = neobject.neid;
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function queryPeerNEHandler(doc, param)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0 && data.getDataRowLength() == 1)
	{
		var ifSlotId = param.split(",")[0];
		var ifBoardName = param.split(",")[1];
		var localNEIP = data.getDataRowParam(0, "localNEIP");
		var localNEName = data.getDataRowParam(0, "localNEName");
		var localNEID = data.getDataRowParam(0, "localNEID");
		remoteneidvalue = data.getDataRowParam(0, "peerNEID");
		var peerRealNEID = data.getDataRowParam(0, "peerRealNEID");
		var peerIFSlotId = data.getDataRowParam(0, "peerIFSlotId");
		
		var procID = data.getDataRowParam(0, "procID");
		var procHandle = data.getDataRowParam(0, "procHandle");
		
		if(procID && procHandle)
		{
		    PROC_OBJ[remoteneidvalue] = [procID, procHandle];
		}
		
		$("txtLocalNe").value = "NE" + getNeid(localNEID) + " " + RESOURCE["nename"] + ":"
			+ localNEName + " " + "IP:" + localNEIP + " " + ifSlotId 
			+ "-" + ifBoardName;
		var xml = createQueryPeerNEInfo(remoteneidvalue,peerRealNEID,peerIFSlotId);
		var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_REMOTE_NE_INFOR 
		+ "&nmUser=" + neobject["nmUser"];
		loadXMLdoc(urlreq, "POST", true, queryPeerNEInfoHandler, param, "inputdata=" + xml);
	}
	else
	{
		hfClearSelState();
	}
	
	showErrorDialog(data,QEURY_PEER_NOTFINISH);
}

function createQueryPeerNEInfo(peerNEID,peerRealNEID,peerIFSlotId)
{

	var di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", peerNEID);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "peerNEID");
	param.setAttribute("value", peerNEID);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "peerRealNEID");
	param.setAttribute("value", peerRealNEID);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "peerIFSlotId");
	param.setAttribute("value", peerIFSlotId);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "funid");
	param.setAttribute("value", neobject["funnodeid"]);
	row.appendChild(param);
	

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function queryPeerNEInfoHandler(doc)
{
	var data = EncapsulateData(doc);
	if(data.getSErrorCode() == 0 && data.getDataRowLength() == 1)
	{
		var peerRealNEID = data.getDataRowParam(0, "peerRealNEID");
		var peerIFSlotId = data.getDataRowParam(0, "peerIFSlotId");
		var peerNeName = data.getDataRowParam(0, "peerNEName");
		var peerNeVersion = data.getDataRowParam(0, "peerNEVersion");
		var peerNEIP = data.getDataRowParam(0, "peerNEIP");
		var peerIFBoardName = data.getDataRowParam(0, "peerIFBoardName");
		var peerODUSlotId = data.getDataRowParam(0, "peerODUSlotId");
		$("txtRemoteNe").value = "NE" + getNeid(peerRealNEID) + " " + RESOURCE["nename"] + ":" 
			+ peerNeName + " " + "IP:" + peerNEIP + " " + peerIFSlotId 
			+ "-" + peerIFBoardName;
		remoteBoardGroup.neId = remoteneidvalue;
		remoteBoardGroup.mSlotId = peerIFSlotId;
		remoteBoardGroup.mBoardName = peerIFBoardName;
		remoteBoardGroup.mOduSlotId = peerODUSlotId;
		remoteBoardGroup.neversion = peerNeVersion||"";
		remoteBoardGroup.protectType = null;
		var peerSupported = data.getDataRowParam(0, "peerSupported");
		if(typeof(peerSupported)!="undefined" && peerSupported != null && peerSupported == "false")
		{
			$("txtResult").value += getNewLine() + RESOURCE["peerNoSupport"];
			resumePageWait();
			$("btnTest").disabled = true;
		}
		else
		{
			queryGroup(remoteneidvalue,peerIFSlotId);
			queryTXRange(QUERY_RX_RANGE_FIRST);
			setPageElementState(false);
			resumePageWait();
		}
		
	}

	/**
	 * DTS2012050701453 
	 *                
	 */
	if (data.getSErrorCode() == "1090629639")
	{
		data.errObj.s_error.info = RESOURCE["peerneerrinfo"];
	}
	showErrorDialog(data,QEURY_PEER_NOTFINISH);
}
/**
 *      RTN900            R3C01
 * @param {Object} neversion
 */
function isRTN900BeforeR3C01(neversion)
{
	var isBeforeR3C01 = SpecialAttrMgr.isNESupport(neobject.neid, "TE_FUNC_RTN_CFG_FADEMARGIN", "TE_ATTR_RTN_FADEMARGIN_BEFORE_RTN900R3C02");
	
	if( isBeforeR3C01 )
	{
		return true;
	}
		
	var verArr = neversion.split('.');
	if(!isRTN900NEtype(verArr[1]))
	{
		return false;
	}
	if (verArr[2] < '03' || (verArr[2] == '03' && verArr[3] < '20')) 
	{
		return true;
	}
	return false;
		
}

/**
 *              
 *         
 */
function setWaitIntervalStart()
{
	if(fadeMarginWaitInterval == null)
	{
		showWait();
		fadeMarginWaitInterval = window.setInterval(showWait,1000);
	}
}

/**
 *              
 *               
 *@param result      
 */
function setWaitIntervalEnd(result)
{
	if(fadeMarginWaitInterval != null)
	{
		if(result > 2)
		{
			result = 2;
		}
		$("txtResult").value += RESOURCE["result" + result];
		window.clearInterval(fadeMarginWaitInterval);
		fadeMarginWaitInterval = null;
	}
}

/**
 *       
 */
function showWait()
{
	$("txtResult").value += ".";
}

function createIf(singleobj)
{
	var fieldset = document.createElement("fieldset");
	fieldset.className = "iffieleset";
	fieldset.style.borderWidth = "2px";
	var legend = document.createElement("legend");
	var text = document.createElement("span");

	text.innerHTML = "IF";
	legend.appendChild(text);
	fieldset.appendChild(legend);
	
	var boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

	var ifboard = addBoard(singleobj.mSlotId, singleobj.mBoardName, getBoardGroupKey(singleobj), singleobj.mIfPhy);

	boardcontain.appendChild(ifboard);

	var board = addBoard(singleobj.mOduSlotId, "ODU", getBoardGroupKey(singleobj), singleobj.mOduPhy);
	boardcontain.appendChild(board);

	fieldset.appendChild(boardcontain);

	var ifcontain = document.createElement("div");

	ifcontain.className = "ifgroupcontain";

	ifcontain.appendChild(fieldset);

	var contain = $("contain");

	contain.appendChild(ifcontain);
	if(singleobj.mSlotId == singleobj.mOduSlotId)
	{
		$("slot_" + singleobj.mBoardName + "_" + singleobj.mSlotId).style.width = "100%";
		$("slot_" + singleobj.mBoardName + "_" + singleobj.mSlotId).parentNode.style.width = "96%";
		board.style.display = "none";
	}
}

function addBoard(slotid, slotname, friendid, isphy, isProtect)
{
	var board = document.createElement("div");
	board.className = "Slot slotw";
	if (slotid != null)
	{
		var slot = document.createElement("div");
		slot.id = "slot_" + slotname + "_" + slotid;
		if (isphy != null)
		{
			slot.className = 'Cardphylog SelStateOff cardw';
		}
		else
		{
			slot.className = 'Cardlogic SelStateOff cardw';
		}
		
		slot.innerHTML = slotid + "-" + slotname;
		
		slot.friendid = friendid;
		board.appendChild(slot);
		if (isProtect) 
		{
			var proSpan = document.createElement('div');
			proSpan.className = 'ifpro';
			proSpan.style.marginLeft = '36px';
			proSpan.style.marginTop = '-6px';
			slot.appendChild(proSpan);
		}
	}

	return board;
}

function createIfProtect(boardGroup)
{
	var fieldset = document.createElement("fieldset");
	fieldset.className = "ifgroupfieleset";
	fieldset.style.borderWidth = "2px";

	var legend = document.createElement("legend");
	var text = document.createElement("span");

	text.innerHTML = protect[boardGroup.protectType];
	legend.appendChild(text);
	fieldset.appendChild(legend);
	var mblProtect = false;
	var pblProtect = true;
	if(boardGroup.protectType == "-1")
	{
		pblProtect = false;
	}
	else if(boardGroup.convert)
	{
		mblProtect = true;
		pblProtect = false;
	}
	var boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

  var ifboard = addBoard(boardGroup.mSlotId, boardGroup.mBoardName, getBoardGroupKey(boardGroup), boardGroup.mIfPhy,mblProtect);

	boardcontain.appendChild(ifboard);

  var woduboard = addBoard(boardGroup.mOduSlotId, boardGroup.mOduName, getBoardGroupKey(boardGroup), boardGroup.mOduPhy);
	boardcontain.appendChild(woduboard);

	fieldset.appendChild(boardcontain);

	boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";
	
	

  var board = addBoard(boardGroup.pSlotId, boardGroup.pBoardName, getBoardGroupKey(boardGroup), boardGroup.pIfPhy, pblProtect);

	boardcontain.appendChild(board);

    var poduboard = addBoard(boardGroup.pOduSlotId, "ODU", getBoardGroupKey(boardGroup), boardGroup.pOduPhy);
	boardcontain.appendChild(poduboard);
	
	fieldset.appendChild(boardcontain);

	var ifcontain = document.createElement("div");

	ifcontain.className = "ifgroupcontain";

	ifcontain.appendChild(fieldset);

	var contain = $("contain");

	contain.appendChild(ifcontain);
	if(boardGroup.mSlotId == boardGroup.mOduSlotId)
	{
		$("slot_" + boardGroup.mBoardName + "_" + boardGroup.mSlotId).style.width = "100%";
		$("slot_" + boardGroup.mBoardName + "_" + boardGroup.mSlotId).parentNode.style.width = "96%";
		woduboard.style.display = "none";
	}
	if(boardGroup.pSlotId == boardGroup.pOduSlotId)
	{
		$("slot_" + boardGroup.mBoardName + "_" + boardGroup.mSlotId).style.width = "100%";
		$("slot_" + boardGroup.pBoardName + "_" + boardGroup.pSlotId).parentNode.style.width = "96%";
		poduboard.style.display = "none";
	}
}

function hfClearSelState()
{
	if (lastselect != null)
	{
		var ele = $("slot" + lastselect);
		ele.className = ele.className.replace("SelStateOn", "SelStateOff");
	}
}

function hfSetSelState(eid)
{
	var ele = $("slot" + eid);
	ele.className = ele.className.replace("SelStateOff", "SelStateOn");
}

function handelclick(evt)
{
	var evt = evt ? evt : window.event;
	var element = evt.srcElement;
	var id = element.id;

	if (id.substr(0, 4) != "slot")
	{
		return;
	}

	boardon(id.substr(4, id.length), element);

}

function compareNum(str1, str2)
{
	var value1 = parseInt(str1);
	var value2 = parseInt(str2);
	return compare(value1, value2);
}

function compare(str1, str2)
{
	if (str1 > str2)
	{
		return 1;
	}
	if (str1 < str2)
	{
		return -1;
	}
	return 0;
}

function boardon(boardid, element)
{
	if(pageWaitFlag)
	{
		return;
	}
	hfClearSelState();
	hfSetSelState(boardid);
	lastselect = boardid;

	var friend = element.friendid;
	var boardgp = boardGroupList[friend];
	boardgp.neId = neidvalue;
	currentBoardGroup = boardgp;
	setPageWait();
	
	if(boardgp.protectType == PROTECTTYPE_XPIC) 
	{
	    var params = getXPICSendBDParams(boardgp, boardid);
	    queryPeerNE(params[0] + "," + params[1]);
	} else {
	    queryPeerNE(boardgp.mSlotId + "," + boardgp.mBoardName);
	}
	queryIFLink();
	$("txtTxPower1").value = "";
	$("txtTxPower2").value = "";
}

/**
 ** XPIC                 
 **/
function getXPICSendBDParams(boardgp, boardid)
{
    var params = [];
    if(boardgp.protectType == PROTECTTYPE_XPIC) 
    {
        var tempArr = boardid.split('_');
        
        var slotid = tempArr[tempArr.length - 1];
        
        if(boardgp.pSlotId == slotid)
        {
            params[0] = boardgp.pSlotId;
            params[1] = boardgp.pBoardName;
        } else {
            params[0] = boardgp.mSlotId;
            params[1] = boardgp.mBoardName;
        }
    }
    
    return params;
}


/**
 * if/odu board group
 */
function BoardGroup()
{
	this.neId = null;
	this.protectType = null;
	
	this.neversion = "";
	
	this.mSlotId = null;
	this.mBoardName = null;
	this.mIfPhy = null;
	this.mOduSlotId = null;
	this.mOduPhy = null;
	this.mOduName = "ODU";
	this.convert = null;
	this.mRslList = null;
	this.mMseList = null;
	this.mQueryRslCount = 0;
	this.mRxPower = null;
	this.mTxPower = null;
	this.mTxRange = null;
	this.mBeTxPower = null;
	
	this.pSlotId = null;
	this.pBoardName = null;
	this.pIfPhy = null;
	this.pOduSlotId = null;
	this.pOduPhy = null;
	this.pOduName = "ODU";
	this.pRslList = null;
	this.pMseList = null;
	this.pRxPower = null;
}

/**
 *          
 */
function rdAutoOnClick()
{
	$("txtTxPower1").disabled = true;
	$("txtTxPower2").disabled = true;
}

/**
 *          
 */
function rdManualOnClick()
{
	$("txtTxPower1").disabled = false;
	$("txtTxPower2").disabled = false;
}

/**
 *           
 */
function setPageElementState(state)
{
	$("rdAuto").disabled = state;
	$("rdManual").disabled = state;
	var txFlag = true;
	if(!$("rdManual").disabled && $("rdManual").checked)
	{
		txFlag = false;
	}
	$("txtTxPower1").disabled = txFlag;
	$("txtTxPower2").disabled = txFlag;
	$("rdLocaltoRemote").disabled = state;
	$("rdRemotetoLocal").disabled = state;
	$("btnTest").disabled = state;
}

function createXMLparam(row, name, value)
{
	param = new tagElement("param");
	param.setAttribute("name", name);
	param.setAttribute("value", value);
	row.appendChild(param);
	return param;
}

function showErrorDialog(data,first,errArrs)
{
	if(first == null && data.getSErrorCode() != 0 && data.getSErrorCode() != 1)
	{
		resumePageWait();
	}
	pageWaitFlag = false;
	document.body.style.cursor = "default";
	var errArr = [];
	if(errArrs)
	{
		errArr = errArrs
	}
	else
	{
		errArr[0] = "nename";
	}
	
	openErrPage("../../../../page/", data.getError(), errArr);
}

/**
 *          
 */
function startTest()
{
	if(!verifyInput())
	{
		return;
	}
	if (!confirm(RESOURCE["DANGER_ALARM"])) 
        {
            return;
        }
	/**
	 *      DTS2012112002322
	 *    SE                   
	 * 	                  
	 * 
	 * 		     1.                    
	 *                2.                      FadeMargin   
	 *          	  3.              FadeMargin                
	 */
	if($("rdRemotetoLocal").checked && isRTN900BeforeR3C01(remoteBoardGroup.neversion))
	{
		alert(RESOURCE["peerVerNoSupport"]);
		return;
	}

	setPageWait();
	
	$("txtResult").value = firstResultStr + getNewLine() + RESOURCE["starttest"] ;
	
	initTest();
	
	attemperTask();
}

function verifyInput()
{
	var result = true;
	if(rdManual.checked)
	{
		if($("txtTxPower1").value == "")
		{
			alert(RESOURCE["txpower1null"]);
			$("txtTxPower1").focus();
			result = false;
		}
		else if($("txtTxPower2").value == "")
		{
			alert(RESOURCE["txpower2null"]);
			$("txtTxPower2").focus();
			result = false;
		}
		else if(parseFloat($("txtTxPower1").value) <= parseFloat($("txtTxPower2").value))
		{
			alert(RESOURCE["manulerror"]);
			$("txtTxPower1").focus();
			result = false;
		}
	}
	return result;
}

/**
 *           
 */
function initTest()
{
	errNum = 0;//       
	if(null != timeOut)
	{
		window.clearTimeout(timeOut);
		timeOut = null;
	}
	currentTaskIndex = STEP_QUERY_CUR_RSL0;
	currentBoardGroup.mRslList = [];
	currentBoardGroup.mMseList = [];
	currentBoardGroup.pRslList = [];
	currentBoardGroup.pMseList = [];
	currentBoardGroup.mRxPower = null;
	currentBoardGroup.mMse = null;
	currentBoardGroup.pMse = null;
	currentBoardGroup.mMaxRxPower = null;
	currentBoardGroup.mQueryRslCount = 0;
	remoteBoardGroup.mRslList = [];
	remoteBoardGroup.mMseList = [];
	remoteBoardGroup.pRslList = [];
	remoteBoardGroup.pMseList = [];
	remoteBoardGroup.mRxPower = null;
	remoteBoardGroup.mMse = null;
	remoteBoardGroup.pMse = null;
	remoteBoardGroup.mMaxRxPower = null;
	remoteBoardGroup.mQueryRslCount = 0;
}

/**
 *   TSL RSL MSE  
 */
function queryMSE()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep3"];
	setWaitIntervalStart();
	var xmlstr = createQueryMSE();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_MSE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryMSEHandler, null, "inputdata=" + xmlstr);
}

/**
 *     TSL RSL MSE   XML
 */
function createQueryMSE()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	
	var row = new tagElement("row-params");
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mSlotId);
	bussiness.appendChild(row);
	
	if(neboard.protectType != null)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pSlotId);
		bussiness.appendChild(row);
	}

	di.getRoot().appendChild(bussiness);

	return di.toString();
}
	
/**
 *     MSE    65535,       ,      65535
 */
function getMSEShowValue(mse)
{
	if(parseFloat(mse) < 0)
	{
		mse = 65535;
	}
	
	return mse;
}

/**
 *   TSL RSL MSE       
 *             
 *@param doc      XML
 */
function queryMSEHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	setWaitIntervalEnd(data.getSErrorCode());
	
	if(rdRemotetoLocal.checked && neboard.mQueryRslCount >= 1 && data.getSErrorCode() == ERRORCODE_TIME_OUT)
	{
		currentTaskIndex = STEP_RESUME_TX;
		attemperTask();
		return;
	}
	if (data.getSErrorCode() == 0 && data.getDataRowLength() >= 1)
	{
		var txneboard = getTransNeBoardInfo();
		
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mMse = data.getDataRowParam(0,"mse");
		$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"if") + getMSEShowValue(mMse) + "dB";
		
		var pMse = null;
		var slotid2 = null;
		if(data.getDataRowLength() > 1)
		{
			slotid2 = data.getDataRowParam(1,"slotid");
			pMse = data.getDataRowParam(1,"mse");
			$("txtResult").value += " "+ getProtectFirst(neboard,slotid2,"if") + getMSEShowValue(pMse) + "dB";
		}
		if(neboard.mQueryRslCount == 1)
		{
			if(parseFloat(mMse) <= LINK_BREAK_VALUE)
			{
				neboard.mMseList = null;
			}
			else
			{
				neboard.mMseList[neboard.mMseList.length] = mMse;
			}
			if(null != pMse && parseFloat(pMse) <= LINK_BREAK_VALUE)
			{
				neboard.pMseList = null;
			}
			else
			{
				neboard.pMseList[neboard.pMseList.length] = pMse;
			}
			if(rdAuto.checked)
			{
				txneboard.mBeTxPower = parseFloat((txneboard.mBeTxPower - PER_TX_POWER).toFixed(1));
			}
			else
			{
				txneboard.mBeTxPower = parseFloat($("txtTxPower1").value);
			}
			
			currentTaskIndex = STEP_SET_TX;
		}
		else
		{
			if(null != neboard.mMseList)
			{
				neboard.mMseList[neboard.mMseList.length] = mMse;
			}
			if(data.getDataRowLength() > 1 && null != neboard.pMseList)
			{
				neboard.pMseList[neboard.pMseList.length] = pMse;
			}
			if(rdAuto.checked)
			{
				txneboard.mBeTxPower = parseFloat((txneboard.mBeTxPower - PER_TX_POWER).toFixed(1));
			}
			else
			{
				txneboard.mBeTxPower = parseFloat($("txtTxPower2").value);
			}
		}

		if((parseFloat(mMse) <= LINK_BREAK_VALUE && null != neboard.mMseList) || (null != pMse && parseFloat(pMse) <= LINK_BREAK_VALUE && null != neboard.pMseList))
		{
			if(null != neboard.mMseList)
			{
				neboard.mRslList.length = neboard.mRslList.length - 1;
				neboard.mMseList.length = neboard.mMseList.length - 1;
				if(parseFloat(mMse) <= LINK_BREAK_VALUE)
				{
					$("txtResult").value += getNewLine() + getProtectFirst(neboard,slotid1,"if") +  RESOURCE["linkerror"];
				}
			}
			if(null != pMse && null != neboard.pMseList)
			{
				neboard.pRslList.length = neboard.pRslList.length - 1;
				neboard.pMseList.length = neboard.pMseList.length - 1;
				if(parseFloat(pMse) <= LINK_BREAK_VALUE)
				{
					$("txtResult").value += getNewLine() + getProtectFirst(neboard,slotid2,"if") +  RESOURCE["linkerror"];
				}
			}
			
			currentTaskIndex = STEP_RESUME_TX;
		}
		else if(txneboard.mBeTxPower < txneboard.mTxRange.value1|| (rdManual.checked && neboard.mQueryRslCount > 2))
		{
			currentTaskIndex = STEP_RESUME_TX;
		}
		else
		{
			currentTaskIndex = STEP_SET_TX;
		}
		attemperTask();
	}
	showErrorDialog(data);
}

/**
 *         
 *@param first                   ,
 *                        
 */
function queryTXRange(first)
{
	if(first == null)
	{
		$("txtResult").value += getNewLine() + RESOURCE["query"] + getTransFirstTitle() + RESOURCE["teststep1"];
		setWaitIntervalStart();
	}
	var xmlstr = createQueryTXRange();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryTXRangeHandler, first, "inputdata=" + xmlstr);
}

/**
 *            XML
 */
function createQueryTXRange()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);
	
	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTRANGEOFPOWER");
	createXMLparam(row,"attrId","LOWPOWER");
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *         ,            
 *@param doc     XML  
 */
function queryTXRangeHandler(doc,first)
{
	var data = EncapsulateData(doc);
	if(first == null)
	{
		setWaitIntervalEnd(data.getSErrorCode());
	}
	if (data.getSErrorCode() == 0 && data.getDataRowLength() == 1)
	{
		var lowpower = data.getDataRowParam(0,"LOWPOWER");
		var heighpower = data.getDataRowParam(0,"W32BRD_ATTR_ACTRANGEOFPOWER");
		var neboard = getTransNeBoardInfo();

		textCheck($("txtTxPower1"),lowpower,heighpower);
		textCheck($("txtTxPower2"),lowpower,heighpower);
		if(first == null)
		{
			$("txtResult").value += " " + lowpower + "dBm" + "-" + heighpower + "dBm";
			if(rdAuto.checked && (neboard.mTxPower - PER_TX_POWER) < lowpower)
			{
				
			    if($("rdRemotetoLocal").checked)
			    {
			    	$("txtResult").value += getNewLine() + RESOURCE["err_fm"];
			    	$("txtResult").value += getNewLine() + RESOURCE["completetest"];
			    	
			    	resumePageWait();
			    }
			    else
			    {
			    	currentTaskIndex = STEP_SET_MUTEODU_TX;
			    	
			    	attemperTask();
			    }
			} 
			else 
			{			
			    neboard.mTxRange = new Pair(lowpower,heighpower);
			    currentTaskIndex = STEP_QUERY_RSL;
			    
			    attemperTask();
			}
		}
	}
	showErrorDialog(data,first);
}

/**
 *       
 */
function queryTXPower()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getTransFirstTitle() + RESOURCE["teststep2"];
	setWaitIntervalStart();

	var xmlstr = createQueryTXPower();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryTXPowerHandler, null, "inputdata=" + xmlstr);
}

/**
 *          XML
 */
function createQueryTXPower()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);

	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32BRD_ATTR_TRANSMITPOWER");
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *            
 *             ,                 
 *@param doc      XML  
 */
function queryTXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0 && data.getDataRowLength() == 1)
	{
		var txpower = parseFloat(data.getDataRowParam(0,"W32BRD_ATTR_TRANSMITPOWER"));
		$("txtResult").value += " " + txpower + "dBm";
		var neboard = getTransNeBoardInfo();
		
		neboard.mTxPower = txpower;
		neboard.mBeTxPower = txpower;
		
		
		currentTaskIndex = STEP_QUERY_TX_RANGE;
		attemperTask();
	}
	
	showErrorDialog(data);
}

function queryRXPower()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep7"];
	setWaitIntervalStart();

	var xmlstr = createQueryRXPower();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryRXPowerHandler, null, "inputdata=" + xmlstr);
}

/**
 *          XML
 */
function createQueryRXPower()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	
	var row = new tagElement("row-params");
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);

	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTTRANSMITPOWER");
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTRECEIVEPOWER");
	bussiness.appendChild(row);
	if(neboard.protectType != null)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pOduSlotId);
	
		createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
		createXMLparam(row,"attrId","W32BRD_ATTR_ACTTRANSMITPOWER");
		createXMLparam(row,"attrId","W32BRD_ATTR_ACTRECEIVEPOWER");
		bussiness.appendChild(row);
	}
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function getProtectFirst(neboard,slotid,flag)
{
	var first = "";
	if(neboard.protectType  != null)
	{
		var workflag = true;
		if(flag.toLowerCase() == "if")
		{
			workFlag = (neboard.mSlotId == slotid);
		}
		else
		{
			workFlag = (neboard.mOduSlotId == slotid);
		}
		if(neboard.protectType.toString() == "-1")
		{
			first = workFlag?"H:":"V:";
		}
		else
		{
			first = workFlag?RESOURCE["main"]:RESOURCE["back"];
		}
	}
	return first;
}

/**
 *            
 *             ,                 
 *@param doc      XML  
 */
function queryRXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	setWaitIntervalEnd(data.getSErrorCode());
	if(rdRemotetoLocal.checked && neboard.mQueryRslCount >= 1 && data.getSErrorCode() == ERRORCODE_TIME_OUT)
	{
		currentTaskIndex = STEP_RESUME_TX;
		attemperTask();
		return;
	}
	if (data.getSErrorCode() == 0 && data.getDataRowLength() >= 1)
	{
		neboard.mQueryRslCount++;
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mRxPower = data.getDataRowParam(0,"W32BRD_ATTR_ACTRECEIVEPOWER");
		$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"odu") + mRxPower + "dBm";
		var pRxPower = null;
		if(data.getDataRowLength() > 1)
		{
			var slotid2 = data.getDataRowParam(1,"slotid");
			pRxPower = data.getDataRowParam(1,"W32BRD_ATTR_ACTRECEIVEPOWER");
			$("txtResult").value += " " + getProtectFirst(neboard,slotid2,"odu") + pRxPower + "dBm";
		}
		
		neboard.mRslList[neboard.mRslList.length] = mRxPower;
		if(data.getDataRowLength() > 1)
		{
			neboard.pRslList[neboard.pRslList.length] = pRxPower;
		}
		
		currentTaskIndex = STEP_QUERY_MSE;
		attemperTask();
	}
	showErrorDialog(data);
}

/**
 *         
 */
function setTXPower()
{
	$("txtResult").value += getNewLine() + RESOURCE["set"] + getTransFirstTitle() + RESOURCE["teststep4"] + ":" + getTransNeBoardInfo().mBeTxPower + "dBm";
	setWaitIntervalStart();
	var xmlstr = createSetTXPower();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_SET_TXPOWER
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, setTXPowerHandler, null, "inputdata=" + xmlstr);
}

/**
 *         
 */
function resumeTXPower()
{
	$("txtResult").value += getNewLine() + RESOURCE["resume"] + getTransFirstTitle() + RESOURCE["teststep4"]+":" + getTransNeBoardInfo().mTxPower + "dBm";
	setWaitIntervalStart();
	var xmlstr = createResumeTXPower();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_SET_TXPOWER
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, resumeTXPowerHandler, null, "inputdata=" + xmlstr);
}

/**
 *          XML
 *@param txpower        
 */
function createSetTXPower(txpower)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);
	
	if(isNaN(txpower))
	{
		createXMLparam(row,"txPower",Math.round(neboard.mBeTxPower * 10));
	}
	else
	{
		createXMLparam(row,"txPower",txpower);
	}
	
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *          XML
 *@param txpower        
 */
function createResumeTXPower()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);
	createXMLparam(row,"txPower",Math.round(neboard.mTxPower * 10));
	
	bussiness.appendChild(row);
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *            
 *             RSL MSE
 *@param doc      XML  
 */
function setTXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0)
	{
		currentTaskIndex = STEP_QUERY_RSL;
		attemperTask();
	}
	showErrorDialog(data);
}

/**
 *            
 *           FadeMargin 
 *@param doc      XML  
 */
function resumeTXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0)
	{
		currentTaskIndex = STEP_QUERY_MARGIN;
		attemperTask();
	}
	showErrorDialog(data);
}

/**
 *   FadeMargin 
 */
function queryFadeMargin()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep6"];
	setWaitIntervalStart();
	var xmlstr = createQueryFadeMargin();
	if(null == xmlstr)
	{
		/** 
		 * DTS2011062002861
		 *  xmlstr                         
		 * q00119080 
		 * 2011-6-19 
		 */
		setWaitIntervalEnd(2); 
		resumePageWait();
		return;
	}
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_FADEMARGIN
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryFadeMarginHandler, null, "inputdata=" + xmlstr);
}

/**
 *   FadeMargin    XML
 */
function createQueryFadeMargin()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	var testmode = $("rdAuto").checked?0:1;
	var row = null;
	if(null != neboard.mMseList)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.mSlotId);
		createXMLparam(row,"testmode",testmode);
		createXMLparam(row,"rxPower",Math.round(neboard.mRxPower * 10));
		createXMLparam(row,"num",neboard.mRslList.length);
		createXMLparam(row,"rslmse",convertProperty(neboard.mRslList,neboard.mMseList));
		
		createXMLparam(row,"rslmseforlog",neboard.mRslList.join(",")+"-"+neboard.mMseList.join(","));
		createXMLparam(row,"slotFlag","1");
		createXMLparam(row,"mset",neboard.mRxmset);
		createXMLparam(row,"sensitivity",neboard.mRxsensitivity);
		
		bussiness.appendChild(row);
	}
	if(neboard.protectType != null && null != neboard.pMseList)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pSlotId);
		createXMLparam(row,"testmode",testmode);
		createXMLparam(row,"rxPower",Math.round(neboard.pRxPower*10));
		createXMLparam(row,"num",neboard.pRslList.length);
		createXMLparam(row,"rslmse",convertProperty(neboard.pRslList,neboard.pMseList));
		
		createXMLparam(row,"rslmseforlog",neboard.pRslList.join(",")+"-"+neboard.pMseList.join(","));
		createXMLparam(row,"slotFlag","0");
		createXMLparam(row,"mset",neboard.pRxmset);
		createXMLparam(row,"sensitivity",neboard.pRxsensitivity);
		
		bussiness.appendChild(row);
	}
	if(null == row)
	{
		return null;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *   FadeMargin        
 *@param doc      XML  
 */
function queryFadeMarginHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	if ((data.getSErrorCode() == 0) && data.getDataRowLength() >= 1)
	{
		/**   R6C00                Fademargin                     ODU  **/
		var deltaMse = parseFloat(data.getDataRowParam(0,"deltamse")) / 10;
		var deltaMse_1 = deltaMse;
		var dirc = 0;//            .
		if(data.getDataRowLength() > 1)
		{
			deltaMse_1 = parseFloat(data.getDataRowParam(1,"deltamse")) / 10;
		}
		
		if(deltaMse <= deltaMse_1)
		{
			deltaMse = deltaMse;
			dirc = 0;
		}
		else
		{
			deltaMse = deltaMse_1;
			dirc = 1;
		}
		
		if(deltaMse < 0.5)
		{
			setWaitIntervalEnd(2);
			
			$("txtResult").value += " " + getProtectFirst(neboard,data.getDataRowParam(dirc,"slotid"),"if") + RESOURCE["deltamsel"];
			var neTxboard = getTransNeBoardInfo();
			var neTxVersion = neTxboard.neversion;
			var isMuteWithfm = isSupportMuteWithfm(neTxVersion);
			if(($("rdRemotetoLocal").checked) || (isMuteWithfm == false))
			{
				$("txtResult").value += getNewLine() + RESOURCE["err_fm"];
				
				$("txtResult").value += getNewLine() + RESOURCE["completetest"];
				
				resumePageWait();
			}
			else
			{
				currentTaskIndex = STEP_SET_MUTEODU_TX;
				attemperTask();
			}
		}
		else
		{
			setWaitIntervalEnd(0);
			
			var slotid1 = data.getDataRowParam(0,"slotid");
			var mfademargin = parseInt(data.getDataRowParam(0,"fademargin")) / 10;
			
			mfademargin = (mfademargin < 0 ? 'NaN' : mfademargin);
			
			$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"if") + RESOURCE["fademargintitle"] + ":" + mfademargin + "dB";
			
			if(data.getDataRowLength() > 1)
			{
				var slotid2 = data.getDataRowParam(1,"slotid");
				var pfademargin = parseInt(data.getDataRowParam(1,"fademargin")) / 10;
				
				pfademargin = (pfademargin < 0 ? 'NaN' : pfademargin);
				
				$("txtResult").value += " "+ getProtectFirst(neboard,slotid2,"if") + RESOURCE["fademargintitle"] + ":" + pfademargin + "dB";
			}
			$("txtResult").value += getNewLine() + RESOURCE["completetest"];
			
			resumePageWait();
		}
	}
	else
	{
		setWaitIntervalEnd(2);
		var errArr = ["nename","slotid","boardname"];
		showErrorDialog(data,null,errArr);
		
		$("txtResult").value += getNewLine() + RESOURCE["completetest"];
		resumePageWait();
	}
}

function queryFadeMarginExt()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep6"];
	setWaitIntervalStart();
	var xmlstr = createQueryFadeMarginExt();
	if(null == xmlstr)
	{
		/** 
		 * DTS2011062002861
		 *  xmlstr                         
		 * q00119080 
		 * 2011-6-19 
		 */
		setWaitIntervalEnd(2); 
		resumePageWait();
		return;
	}
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_FADEMARGIN_EXT
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryFadeMarginExtHandler, null, "inputdata=" + xmlstr);
}

function createQueryFadeMarginExt()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	var row = null;
	if(null != neboard.mMseList)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.mSlotId);
		createXMLparam(row,"rsl0",neboard.mRxPower * 10);
		createXMLparam(row,"rsl1",neboard.mRxPower_r * 10);
		
		bussiness.appendChild(row);
	}
	if(neboard.protectType != null && null != neboard.pMseList)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pSlotId);
		createXMLparam(row,"rsl0",neboard.pRxPower*10);
		createXMLparam(row,"rsl1",neboard.pRxPower_r * 10);
		
		bussiness.appendChild(row);
	}
	if(null == row)
	{
		return null;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function queryFadeMarginExtHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	if ((data.getSErrorCode() == 0 || data.getSErrorCode() == 1) && data.getDataRowLength() >= 1)
	{
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mFadeMargin_r = parseFloat(data.getDataRowParam(0,"fademargin"));
		
		if(mFadeMargin_r != INVALID_FADEMARGIN)
		{
			setWaitIntervalEnd(0);
			$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"if") + " " +RESOURCE["fademargintitle"] + ":" + (mFadeMargin_r/10) + "dB";
		}
		else
		{
			/**
			 * <=-90
			 *        0  Fade Margin =                ;
			 *          -90dBm  Fade Margin    
			 *         - max[RSL_r -90] -      MSEt (  ODU       -90     RSL_r  -90) 
			 * 
			 */
			setWaitIntervalEnd(2);
			$("txtResult").value += getNewLine() + getProtectFirst(neboard,slotid1,"if") + " " +RESOURCE["channelerr"];
		}
		if(data.getDataRowLength() > 1)
		{
			var slotid2 = data.getDataRowParam(1,"slotid");
			var pFadeMargin_r = parseFloat(data.getDataRowParam(1,"fademargin"));
			
			if(pFadeMargin_r != INVALID_FADEMARGIN)
			{
				$("txtResult").value += " " + getProtectFirst(neboard,slotid2,"if") + " " + RESOURCE["fademargintitle"] + ":" + (pFadeMargin_r/10) + "dB";
			}
			else
			{
				/**
				 * 
				 *        0  Fade Margin =                ;
				 *          -90dBm  Fade Margin    
				 *         - max[RSL_r -90] -      MSEt (  ODU       -90     RSL_r  -90) 
				 * .toFixed(2)
				 */
				
				$("txtResult").value += getNewLine() + getProtectFirst(neboard,slotid2,"if") + " " +RESOURCE["channelerr"];
			}
		}
		else if(data.getSErrorCode() == 1)
		{
			$("txtResult").value += " "+ getProtectFirst(neboard,data.getBErrParam(0,"slotid"),"if") + RESOURCE["result2"];
		}
	}
	else
	{
		setWaitIntervalEnd(2);
	}
	var errArr = ["nename","slotid","boardname"];
	showErrorDialog(data,null,errArr);
	currentTaskIndex = STEP_SET_UNMUTEODU_TX;
	attemperTask();
}

/**
 *  RSL MSE     QX     
 */
function convertProperty(rsllist,mselist)
{
	var result = "";
	var points = new Array();
	if(rsllist != null && mselist != null
		&& rsllist.length == mselist.length)
	{
		for(var i = 0,m = rsllist.length;i < m;i++)
		{
			var rsl = rsllist[i] * 10;
			var mse = mselist[i] * 10;
			points.push(rsl);
			points.push(mse);
			
			if(rsl < 0)
			{
				rsl = "0000" + (INT_INVALID + rsl).toString(16);
			}
			else
			{
				rsl = "0000" + rsl.toString(16);
			}
			if(mse < 0)
			{
				mse = "0000" + (INT_INVALID + mse).toString(16);
			}
			else
			{
				mse = "0000" +  mse.toString(16);
			}
			result += rsl.substr(rsl.length - 4) + mse.substr(mse.length - 4);
		}
		
		/**
		 *    R6C00           ,Fademargin                                        
		 */
		/**result = points.join(",");**/
	}
	return result.toLowerCase();
}

/**
 *       
 */
function attemperTask()
{
	switch(currentTaskIndex)
	{
		case STEP_QUERY_CUR_RSL0:
			queryCurRsl();
			break;
		case STEP_QUERY_CUR_MSE0:
			break;
		case STEP_QUERY_SYSTEMPARAM:
			querySystemParam();
			break;
		case STEP_QUERY_TX:
			queryTXPower();
			break;
		case STEP_QUERY_TX_RANGE:
			queryTXRange();
			break;
		case STEP_SET_RSL_s_TX:
			break;
		case STEP_QUERY_RSL:
			queryRXPower();
			break;
		case STEP_QUERY_MSE:
			queryMSE();
			break;
		case STEP_SET_TX:
			setTXPower();
			break;
		case STEP_RESUME_TX:
			resumeTXPower();
			break;
		case STEP_CALCULATE_DELTAMSE:
			break;
		case STEP_QUERY_MARGIN:
			queryFadeMargin();
			break;
		case STEP_SET_MUTEODU_TX:
			setTxoduWorkMuteStatus("0");
			break;
		case STEP_QUERY_RSL_r_RX:
			queryRSL_rRX();
			break;
		case STEP_SET_UNMUTEODU_TX:
			setTxoduWorkStatus("1");
			break;
		case STEP_QUERY_FADEMARGIN_EXT:
			queryFadeMarginExt();
			break;	
		default:
			break;
	}
}

/**
 *     ID
 */
function queryIFLink()
{
	var xmlstr = createQueryIFLink();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_IF_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryIFLinkHandler, null, "inputdata=" + xmlstr);
}

/**
 *     ID   XML
 */
function createQueryIFLink()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	
	createXMLparam(row,"neid",currentBoardGroup.neId);
	
	if(currentBoardGroup.protectType == PROTECTTYPE_XPIC) 
	{
	    var params = getXPICSendBDParams(currentBoardGroup, lastselect);
	    createXMLparam(row,"slotid", params[0]);
	} else {
	    createXMLparam(row,"slotid",currentBoardGroup.mSlotId);
        }
        
	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32PORT_ATTR_RADIOLINKID");
	createXMLparam(row,"attrId","W32PORT_ATTR_RECRADIOLINKID");
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *     ID       
 *@param doc     XML  
 */
function queryIFLinkHandler(doc)
{
	var data = EncapsulateData(doc);
	if ((data.getSErrorCode() == 0 || data.getSErrorCode() == 1)&& data.getDataRowLength() == 1)
	{
		var linkid = data.getDataRowParam(0,"W32PORT_ATTR_RADIOLINKID");
		var reallinkid = data.getDataRowParam(0,"W32PORT_ATTR_RECRADIOLINKID");
		$("txtLinkId").value = reallinkid;
	}
}

/**
 *                RSL0 MSE0 ,        (RSL_s)   
 *@param doc     XML  
 */
function queryCurRsl()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep7"];
	setWaitIntervalStart();

	var xmlstr = createQueryCurRsl();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryCurRslHandler, null, "inputdata=" + xmlstr);
}

/**
 *          XML
 */
function createQueryCurRsl()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	
	var row = new tagElement("row-params");
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);

	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTTRANSMITPOWER");
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTRECEIVEPOWER");
	
	createXMLparam(row,"attrId","W32BRD_ATTR_FREQUENCY");
	
	bussiness.appendChild(row);
	if(neboard.protectType != null)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pOduSlotId);
	
		createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
		createXMLparam(row,"attrId","W32BRD_ATTR_ACTTRANSMITPOWER");
		createXMLparam(row,"attrId","W32BRD_ATTR_ACTRECEIVEPOWER");
		
		createXMLparam(row,"attrId","W32BRD_ATTR_FREQUENCY");
		bussiness.appendChild(row);
	}
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *            
 *             ,                 
 *@param doc      XML  
 */
function queryCurRslHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0 && data.getDataRowLength() >= 1)
	{
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mRxPower = data.getDataRowParam(0,"W32BRD_ATTR_ACTRECEIVEPOWER");
		
		var mRxFreqBand = data.getDataRowParam(0,"W32BRD_ATTR_FREQUENCY");
		$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"odu") + mRxPower + "dBm";
		
		var pRxPower = null;
		var pRxFreqBand = null;
		if(data.getDataRowLength() > 1)
		{
			var slotid2 = data.getDataRowParam(1,"slotid");
			pRxPower = data.getDataRowParam(1,"W32BRD_ATTR_ACTRECEIVEPOWER");
			
			pRxFreqBand = data.getDataRowParam(0,"W32BRD_ATTR_FREQUENCY");
			
			$("txtResult").value += " " + getProtectFirst(neboard,slotid2,"odu") + pRxPower + "dBm";
		}
		neboard.mRxPower = parseFloat(mRxPower);
		neboard.pRxPower = parseFloat(pRxPower);
		
		neboard.mRxFreqBand = parseFloat(mRxFreqBand);
		neboard.pRxFreqBand = parseFloat(pRxFreqBand);
		currentTaskIndex = STEP_QUERY_SYSTEMPARAM;
		attemperTask();
	}
	var errArr = ["nename","slotid","boardname"];
	showErrorDialog(data,null,errArr);
}

function queryCurMse()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + "  MSE!";
	setWaitIntervalStart();
	var xmlstr = createQueryMSE();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_MSE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryCurMseHandler, null, "inputdata=" + xmlstr);
}

function queryCurMseHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	setWaitIntervalEnd(data.getSErrorCode());
	
	if (data.getSErrorCode() == 0 && data.getDataRowLength() >= 1)
	{
		var txneboard = getTransNeBoardInfo();
		
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mMse = data.getDataRowParam(0,"mse");
		$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"if") + getMSEShowValue(mMse) + "dB";
		
		var pMse = null;
		var slotid2 = null;
		if(data.getDataRowLength() > 1)
		{
			slotid2 = data.getDataRowParam(1,"slotid");
			pMse = data.getDataRowParam(1,"mse");
			$("txtResult").value += " "+ getProtectFirst(neboard,slotid2,"if") + getMSEShowValue(pMse) + "dB";
		}
		neboard.mMse = mMse;
		neboard.pMse = pMse;

		currentTaskIndex = STEP_QUERY_SYSTEMPARAM;
		attemperTask();
	}
	var errArr = ["nename","slotid","boardname"];
	showErrorDialog(data,null,errArr);
	
}

/**
 *         (RSL_s) STEP_SET_RSL_s_TX
 */
function setRSL_sTXPower()
{
	var txPower = 0;
	var txNeboard = getTransNeBoardInfo();
	var maxTxpower = txNeboard.mMaxTxPower;
	var curActTxpower = txNeboard.mActTxPower;
	var rxNeboard = getReceiveNeBoardInfo();
	var maxRxpower = rxNeboard.mMaxRxPower;
	var curRxpower = rxNeboard.mRxPower;
	txPower = Math.min(maxTxpower,(curActTxpower + maxRxpower-curRxpower)) - PER_TX_POWER;
	$("txtResult").value += getNewLine() + RESOURCE["set"] + getTransFirstTitle() + "      " + ":" + txPower + "dBm";
	setWaitIntervalStart();
	var xmlstr = createSetTXPower(txPower * 10);
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_SET_TXPOWER
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, setRSL_sTXPowerHandler, null, "inputdata=" + xmlstr);
}

function setRSL_sTXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0)
	{
		currentTaskIndex = STEP_QUERY_RSL;
		attemperTask();
	}
	var errArr = ["nename","slotid","boardname"];
	showErrorDialog(data,null,errArr);
}

function querySystemParam()
{
	setWaitIntervalStart();
	var xmlstr = createQuerySystemParam();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_SYSTEMPARAM
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, querySystemParamHandler, null, "inputdata=" + xmlstr);
}
function createQuerySystemParam()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	
	var row = new tagElement("row-params");
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mSlotId);
	createXMLparam(row,"portid","1");
	if(!isNaN(neboard.mRxFreqBand))
	{
		createXMLparam(row,"mRxFreqBand",neboard.mRxFreqBand);
	}
	bussiness.appendChild(row);
	if(neboard.protectType != null)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pSlotId);
		createXMLparam(row,"portid","1");
		if(!isNaN(neboard.pRxFreqBand))
		{
			createXMLparam(row,"pRxFreqBand",neboard.pRxFreqBand);
		}
		bussiness.appendChild(row);
	}
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function querySystemParamHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	setWaitIntervalEnd(data.getSErrorCode());
	
	if (data.getSErrorCode() == 0 && data.getDataRowLength() >= 1)
	{
		for(var i = 0; i < data.getDataRowLength(); i++)  //       
	    {
			var slotFlag = parseInt(data.getDataRowParam(i,"slotFlag"));
			var maxRxPower = parseFloat(data.getDataRowParam(i,"rxmaxpower"));
			var rxmset = parseFloat(data.getDataRowParam(i,"rxmset"));
			var rxsensitivity = parseFloat(data.getDataRowParam(i,"rxsensitivity"));
		
			if("1" == slotFlag)
			{
				neboard.mMaxRxPower = maxRxPower;
				neboard.mRxmset = rxmset;
				neboard.mRxsensitivity = rxsensitivity;				
			}
			else
			{
				neboard.pMaxRxPower = maxRxPower;
				neboard.pRxmset = rxmset;
				neboard.pRxsensitivity = rxsensitivity;						
			}
	    } 

		currentTaskIndex = STEP_QUERY_TX;
		attemperTask();
	}
	var errArr = ["nename","slotid","boardname"];
	showErrorDialog(data,null,errArr);
}
function setTxoduWorkStatus(status)
{
	var tempinfo = "";
	if(currentTaskIndex == STEP_SET_UNMUTEODU_TX)
	{
		tempinfo = RESOURCE["unmuteode"];
	}
	else
	{
		tempinfo = RESOURCE["muteode"];
	}
	
	$("txtResult").value += getNewLine() + RESOURCE["set"] + getTransFirstTitle() + tempinfo;
	setWaitIntervalStart();

	var xmlstr = createSetTxoduWorkStatus(status);
	var urlreq = "../../../../neExlorerServlet?sfid=" + SET_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, setTxoduWorkStatusHandler, status, "inputdata=" + xmlstr);
}


function setTxoduWorkMuteStatus(status)
{
	var tempinfo = "";
	if(currentTaskIndex == STEP_SET_UNMUTEODU_TX)
	{
		tempinfo = RESOURCE["unmuteode"];
	}
	else
	{
		tempinfo = RESOURCE["muteode"];
	}
	
	$("txtResult").value += getNewLine() + RESOURCE["set"] + getTransFirstTitle() + tempinfo;
	setWaitIntervalStart();
	var neboard = getTransNeBoardInfo();
	var xmlstr = createSetTxoduWorkStatus(status);
	var urlreq = "../../../../neExlorerServlet?sfid=" + SET_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, setTxoduWorkStatusMuteHandler, null, "inputdata=" + xmlstr);
	/**
	if((null != neboard.protectType && PROTECTTYPE_XPIC == neboard.protectType) || null == neboard.protectType)
	{
		loadXMLdoc(urlreq, "POST", true, setTxoduWorkStatusMuteXPICHandler, null, "inputdata=" + xmlstr);
	}
	else
	{
		loadXMLdoc(urlreq, "POST", false, setTxoduWorkStatusMute1plus1Handler, null, "inputdata=" + xmlstr);
	}
	**/
}

function delayXSeconds()
{
		setWaitIntervalEnd(0);
		currentTaskIndex = STEP_QUERY_RSL_r_RX;
		if(timeOut)
		{
			window.clearTimeout(timeOut);
		}
		timeOut = null;
		attemperTask();
}

function setTxoduWorkStatusMuteHandler(doc)
{
		/**
		 * 1 ODU                6s    
		 * 2 6S                     
		 * 3 6s                                                   
		 * 4 5    ODU             
		 *       3s  .
		 */
		timeOut = window.setTimeout("delayXSeconds()",delayTime);
}

function setTxoduWorkStatusMute1plus1Handler(doc)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0)
	{
		currentTaskIndex = STEP_QUERY_RSL_r_RX;
		attemperTask();	
	}
	resumePageWait();
	var errArr = ["nename","slotid","boardname"];
	showErrorDialog(data,null,errArr);
}


function createSetTxoduWorkStatus(status)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	if("0" == status )
	{
		if(neboard.protectType != null)
		{
			row = new tagElement("row-params");
			createXMLparam(row,"neid",neboard.neId);
			createXMLparam(row,"slotid",neboard.pOduSlotId);
			createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
			createXMLparam(row,"W32BRD_ATTR_WORKSTATUS_WITH_FADEMARGIN",status);
			
			bussiness.appendChild(row);
		}
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.mOduSlotId);
		
		createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
		createXMLparam(row,"W32BRD_ATTR_WORKSTATUS_WITH_FADEMARGIN",status);
		bussiness.appendChild(row);
		
	}else
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.mOduSlotId);
		
		createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
		createXMLparam(row,"W32BRD_ATTR_WORKSTATUS_WITH_FADEMARGIN",status);
		bussiness.appendChild(row);
		if(neboard.protectType != null)
		{
			row = new tagElement("row-params");
			createXMLparam(row,"neid",neboard.neId);
			createXMLparam(row,"slotid",neboard.pOduSlotId);
			createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
			createXMLparam(row,"W32BRD_ATTR_WORKSTATUS_WITH_FADEMARGIN",status);
			
			bussiness.appendChild(row);
		}
	}
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function setTxoduWorkStatusHandler(doc,param)
{
	if(param && "1" ==param)
	{
		errNum++;
		var data = EncapsulateData(doc);
		var errorCode = data.getSErrorCode()
		setWaitIntervalEnd(errorCode);
		if (errorCode == 0)
		{
			if(currentTaskIndex == STEP_SET_UNMUTEODU_TX)
			{
				errNum = 0;
				$("txtResult").value += getNewLine() + RESOURCE["completetest"];
				resumePageWait();
			}
		}
		else
		{
			
			if(errNum <= errMaxNum)
			{
				currentTaskIndex = STEP_SET_UNMUTEODU_TX;
				attemperTask();
			}
			else
			{
				var errArr = ["nename","slotid","boardname"];
				showErrorDialog(data,null,errArr);
			}
		}
	}
	else
	{
	}
}

function queryRSL_rRX()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep7"];
	setWaitIntervalStart();
	var xmlstr = createQueryRXPower();//createQueryCurRsl();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryRSL_rRXHandler, null, "inputdata=" + xmlstr);
}

function queryRSL_rRXHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	setWaitIntervalEnd(data.getSErrorCode());
	if ((data.getSErrorCode() == 0 || data.getSErrorCode() == 1) && data.getDataRowLength() >= 1)
	{
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mRxPower_r = parseFloat(data.getDataRowParam(0,"W32BRD_ATTR_ACTRECEIVEPOWER")).toFixed(1);
		neboard.mRxPower_r = mRxPower_r;
		
		$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"odu") + mRxPower_r + "dBm";
		if(data.getDataRowLength() > 1)
		{
			var slotid2 = data.getDataRowParam(1,"slotid");
			var pRxPower_r = parseFloat(data.getDataRowParam(1,"W32BRD_ATTR_ACTRECEIVEPOWER")).toFixed(1);
			
			neboard.pRxPower_r = pRxPower_r;
			$("txtResult").value += " " + getProtectFirst(neboard,slotid2,"odu") + pRxPower_r + "dBm";
		}
		else if(data.getSErrorCode() == 1)
		{
			$("txtResult").value += " "+ getProtectFirst(neboard,data.getBErrParam(0,"slotid"),"odu") + RESOURCE["result2"];
		}
	}
	var errArr = ["nename","slotid","boardname"];
	showErrorDialog(data,null,errArr);
	currentTaskIndex = STEP_QUERY_FADEMARGIN_EXT;
	attemperTask();
}

function isSupportMuteWithfm(neversion)
{
	var isSupportAttr = SpecialAttrMgr.isNESupport(neobject.neid, 
			"TE_FUNC_RTN_CFG_FADEMARGIN", "TE_ATTR_RTN_FADEMARGIN_AFTER_RTN900R3C03");
	
	if( isSupportAttr )
	{
		return true;
	}
	
	var isSupport = true;
	
	if(neversion && neversion.indexOf(".") > 0)
	{
		var ver = neversion.split(".");
		var ver_r = ver[2];
		var ver_c = ver[3];
		return (ver_r >"03")||(ver_r =="03" && ver_c >= "42");
	}
	
	return isSupport;
}
