var lastselect;
var neobject = getNeProperty(self);

var boardGroupList = new Object(); 
var currentBoardGroup = null;
var remoteBoardGroup = new BoardGroup();

var protect = new Object();
protect["-1"] = "XPIC";
protect["0"] = "1+1 SD";
protect["1"] = "1+1 FD";
protect["2"] = "1+1 HSB";

var btnRightArr = new Object();

var neidvalue = neobject.neid;
var remoteneidvalue = null;

var LINK_BREAK_VALUE = 0;

var currentTaskIndex = 0;

var STEP_QUERY_TX = 0;
var STEP_QUERY_TX_RANGE = 1;
var STEP_QUERY_RSL = 2;
var STEP_QUERY_MSE = 3;
var STEP_SET_TX = 4;
var STEP_RESUME_TX = 5;
var STEP_QUERY_MARGIN = 6;

var PER_TX_POWER = 2;

var firstResultStr = "";

var INT_INVALID = 65536;

var pageWaitFlag = false;

var fadeMarginWaitInterval = null;

var QUERY_RX_RANGE_FIRST = true;

var QEURY_PEER_NOTFINISH = true;

var TIME_OUT = 1090650120;


/*********************************************************/
/*********************************************************/

function init()
{
	initElementRes();
	queryGroup(neidvalue);
	setPageElementState(true);
}

function tabSelectHandler()
{
	queryGroup(neidvalue);
}

/**
 *       
 */
function Pair(value1,value2)
{
	this.value1 = value1;
	this.value2 = value2;
}

/**
 *       
 */
function setPageWait()
{
	pageWaitFlag = true;
	setPageElementState(true);
	document.body.style.cursor = "wait";
}

/**
 *     
 */
function resumePageWait()
{
	pageWaitFlag = false;
	setPageElementState(false);
	document.body.style.cursor = "default";
}

/**
 *        
 */
function getNewLine()
{
	return String.fromCharCode(13, 10);
}

/**
 *             
 *   :BoardGroup
 */
function getTransNeBoardInfo()
{
	if($("rdLocaltoRemote").checked)
	{
		return remoteBoardGroup; 
	}
	else
	{
		return currentBoardGroup;
	}
}

/**
 *         ,  :     
 *          
 *   :  \  
 */
function getTransFirstTitle()
{
	if($("rdLocaltoRemote").checked)
	{
		return RESOURCE["remote"];
	}
	else
	{
		return RESOURCE["local"];
	}
}

/**
 *             
 *   :BoardGroup
 */
function getReceiveNeBoardInfo()
{
	if($("rdLocaltoRemote").checked)
	{
		return currentBoardGroup; 
	}
	else
	{
		return remoteBoardGroup;
	}
}

/**
 *         ,  :     
 *          
 *   :  \  
 */
function getReceiveFirstTitle()
{
	if($("rdLocaltoRemote").checked)
	{
		return RESOURCE["local"];
	}
	else
	{
		return RESOURCE["remote"];
	}
}

function queryGroup(neid,slot)
{
	if(slot != null)
	{
		$("txtResult").value += getNewLine() + RESOURCE["queryxpic1j1"];
		setWaitIntervalStart();
	}
	var xmlstr = createQueryGroupXML(neid,slot);
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_GROUP
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryGroupHandler, slot, "inputdata=" + xmlstr);
}

function createQueryGroupXML(neid,slot)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	createXMLparam(row,"neid",neid)
	if(slot != null)
	{
		createXMLparam(row,"slotId",slot)
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}


function queryGroupHandler(doc,slot)
{
	var data = EncapsulateData(doc);
	if(slot != null)
	{
		setWaitIntervalEnd(data.getSErrorCode());
		firstResultStr = $("txtResult").value;
	}
	else
	{
		var contain = $("contain");
		while (contain.hasChildNodes())
		{
			contain.removeChild(contain.childNodes[0]);
		}
	}
	var len = data.getDataRowLength();

	for ( var i = 0; i < len; i++)
	{
		var boardGroup = null;
		if(slot == null)
		{
			boardGroup = new BoardGroup();
		}
		else
		{
			boardGroup = remoteBoardGroup;
		}
		boardGroup.mSlotId = data.getDataRowParam(i, "mSlotId");
		boardGroup.mIfPhy = data.getDataRowParam(i, "mIfPhy");
		boardGroup.mBoardName = data.getDataRowParam(i, "mBoardName");
		boardGroup.mOduSlotId = data.getDataRowParam(i, "mOduSlotId");
		boardGroup.mOduPhy = data.getDataRowParam(i, "mOduPhy");
		
		var protectType = data.getDataRowParam(i, "protectType");
		
		if (protectType != null)
		{
			boardGroup.protectType = data.getDataRowParam(i, "protectType");
			boardGroup.pSlotId = data.getDataRowParam(i, "pSlotId");
			boardGroup.pIfPhy = data.getDataRowParam(i, "pIfPhy");
			boardGroup.pBoardName = data.getDataRowParam(i, "pBoardName");
			boardGroup.pOduSlotId = data.getDataRowParam(i, "pOduSlotId");
			boardGroup.pOduPhy = data.getDataRowParam(i, "pOduPhy");
			boardGroup.convert = data.getDataRowParam(i, "convert");
			if(slot == null)
			{
				createIfProtect(boardGroup);
				boardGroupList[getBoardGroupKey(boardGroup)] = boardGroup;
			}
		}
		else if(slot == null)
		{
			createIf(boardGroup);
			boardGroupList[getBoardGroupKey(boardGroup)] = boardGroup;
		}
	}
}

/**
 *         
 *@param boardGroup        
 */
function getBoardGroupKey(boardGroup)
{
	if(boardGroup.protectType == null)
	{
		return boardGroup.mSlotId + "_" + boardGroup.mOduSlotId;
	}
	else
	{
		return boardGroup.protectType + "_" + boardGroup.mSlotId + "_" + boardGroup.mOduSlotId;
	}
}



/**
 *        innerHTML  
 *@param domid      ID
 */
function setElementHTML(domid)
{
	var dome = $(domid);
	dome.innerHTML = RESOURCE[domid];
}

/**
 *           
 */
function initElementRes()
{
	$("btnTest").value = RESOURCE["test"];

	setElementHTML("spLinkId");
	setElementHTML("spLocalNe");
	setElementHTML("spRemoteNe");
	setElementHTML("spTestMode");
	setElementHTML("spAuto");
	setElementHTML("spManual");
	setElementHTML("spTxPower1");
	setElementHTML("spTxPower2");
	setElementHTML("spDirection");
	setElementHTML("spLocaltoRemote");
	setElementHTML("spRemotetoLocal");
	setElementHTML("spResult");
	
	btnRightArr.btnTest = new BtnRightObj("btnTest", query_oduif_params);
	getRightInfo(neobject, btnRightArr);
	$("btnTest").disabled = !btnRightArr.btnTest.right;
}


function queryPeerNE(param)
{
	$("txtLinkId").value = "";
	$("txtLocalNe").value = "";
	$("txtRemoteNe").value = "";
	setPageElementState(true);
	$("txtResult").value=RESOURCE["querylinkandremote"];
	setWaitIntervalStart();
	var slotid = param.split(",")[0];
	var xml = createPeerXML(slotid);
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_HOP_QUEERY_PEERNE 
	+ "&timeStamp=" + new Date().getTime() + "&nmUser=" + neobject["nmUser"];
	
	loadXMLdoc(urlreq, "POST", true, queryPeerNEHandler, param, "inputdata=" + xml);
}


function createPeerXML(slotid)
{
	var di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");

	param = new tagElement("param");
	neidvalue = neobject.neid;
	param.setAttribute("name", "neid");
	param.setAttribute("value", neidvalue);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function queryPeerNEHandler(doc, param)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0 && data.getDataRowLength() == 1)
	{
		var ifSlotId = param.split(",")[0];
		var ifBoardName = param.split(",")[1];
		var localNEIP = data.getDataRowParam(0, "localNEIP");
		var localNEName = data.getDataRowParam(0, "localNEName");
		var localNEID = data.getDataRowParam(0, "localNEID");
		remoteneidvalue = data.getDataRowParam(0, "peerNEID");
		var peerRealNEID = data.getDataRowParam(0, "peerRealNEID");
		var peerIFSlotId = data.getDataRowParam(0, "peerIFSlotId");
		
		var procID = data.getDataRowParam(0, "procID");
		var procHandle = data.getDataRowParam(0, "procHandle");
		
		if(procID && procHandle)
		{
		    PROC_OBJ[remoteneidvalue] = [procID, procHandle];
		}
		
		$("txtLocalNe").value = "NE" + getNeid(localNEID) + " " + RESOURCE["nename"] + ":"
			+ localNEName + " " + "IP:" + localNEIP + " " + ifSlotId 
			+ "-" + ifBoardName;
		var xml = createQueryPeerNEInfo(remoteneidvalue,peerRealNEID,peerIFSlotId);
		var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_REMOTE_NE_INFOR 
		+ "&nmUser=" + neobject["nmUser"];
		loadXMLdoc(urlreq, "POST", true, queryPeerNEInfoHandler, param, "inputdata=" + xml);
	}
	else
	{
		hfClearSelState();
	}
	
	showErrorDialog(data,QEURY_PEER_NOTFINISH);
}

function createQueryPeerNEInfo(peerNEID,peerRealNEID,peerIFSlotId)
{

	var di = new inputxml("datainterface");
	bussiness = new tagElement("bussiness-params");
	row = new tagElement("row-params");

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", peerNEID);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "peerNEID");
	param.setAttribute("value", peerNEID);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "peerRealNEID");
	param.setAttribute("value", peerRealNEID);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "peerIFSlotId");
	param.setAttribute("value", peerIFSlotId);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "funid");
	param.setAttribute("value", neobject["funnodeid"]);
	row.appendChild(param);
	

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function queryPeerNEInfoHandler(doc)
{
	var data = EncapsulateData(doc);
	if(data.getSErrorCode() == 0 && data.getDataRowLength() == 1)
	{
		var peerRealNEID = data.getDataRowParam(0, "peerRealNEID");
		var peerIFSlotId = data.getDataRowParam(0, "peerIFSlotId");
		var peerNeName = data.getDataRowParam(0, "peerNEName");
		var peerNeVersion = data.getDataRowParam(0, "peerNEVersion");
		var peerNEIP = data.getDataRowParam(0, "peerNEIP");
		var peerIFBoardName = data.getDataRowParam(0, "peerIFBoardName");
		var peerODUSlotId = data.getDataRowParam(0, "peerODUSlotId");
	
		$("txtRemoteNe").value = "NE" + getNeid(peerRealNEID) + " " + RESOURCE["nename"] + ":" 
			+ peerNeName + " " + "IP:" + peerNEIP + " " + peerIFSlotId 
			+ "-" + peerIFBoardName;
		remoteBoardGroup.neId = remoteneidvalue;
		remoteBoardGroup.mSlotId = peerIFSlotId;
		remoteBoardGroup.mBoardName = peerIFBoardName;
		remoteBoardGroup.mOduSlotId = peerODUSlotId;
		var peerSupported = data.getDataRowParam(0, "peerSupported");
		if(typeof(peerSupported)!="undefined" && peerSupported != null && peerSupported == "false")
		{
			$("txtResult").value += getNewLine() + RESOURCE["peerNoSupport"];
			resumePageWait();
			$("btnTest").disabled = true;
		}
		else
		{
			queryGroup(remoteneidvalue,peerIFSlotId);
			queryTXRange(QUERY_RX_RANGE_FIRST);
			setPageElementState(false);
			resumePageWait();
		}
	}

	showErrorDialog(data,QEURY_PEER_NOTFINISH);
}


/**
 *              
 *         
 */
function setWaitIntervalStart()
{
	if(fadeMarginWaitInterval == null)
	{
		showWait();
		fadeMarginWaitInterval = window.setInterval(showWait,1000);
	}
}

/**
 *              
 *               
 *@param result      
 */
function setWaitIntervalEnd(result)
{
	if(fadeMarginWaitInterval != null)
	{
		if(result > 2)
		{
			result = 2;
		}
		$("txtResult").value += RESOURCE["result" + result];
		window.clearInterval(fadeMarginWaitInterval);
		fadeMarginWaitInterval = null;
	}
}

/**
 *       
 */
function showWait()
{
	$("txtResult").value += ".";
}

function createIf(singleobj)
{
	var fieldset = document.createElement("fieldset");
	fieldset.className = "iffieleset";
	fieldset.style.borderWidth = "2px";
	var legend = document.createElement("legend");
	var text = document.createElement("span");

	text.innerHTML = "IF";
	legend.appendChild(text);
	fieldset.appendChild(legend);
	
	var boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

	var ifboard = addBoard(singleobj.mSlotId, singleobj.mBoardName, getBoardGroupKey(singleobj), singleobj.mIfPhy);

	boardcontain.appendChild(ifboard);

	var board = addBoard(singleobj.mOduSlotId, "ODU", getBoardGroupKey(singleobj), singleobj.mOduPhy);
	boardcontain.appendChild(board);

	fieldset.appendChild(boardcontain);

	var ifcontain = document.createElement("div");

	ifcontain.className = "ifgroupcontain";

	ifcontain.appendChild(fieldset);

	var contain = $("contain");

	contain.appendChild(ifcontain);
	if(singleobj.mSlotId == singleobj.mOduSlotId)
	{
		$("slot_" + singleobj.mBoardName + "_" + singleobj.mSlotId).style.width = "100%";
		$("slot_" + singleobj.mBoardName + "_" + singleobj.mSlotId).parentNode.style.width = "96%";
		board.style.display = "none";
	}
}

function addBoard(slotid, slotname, friendid, isphy, isProtect)
{
	var board = document.createElement("div");
	board.className = "Slot slotw";
	if (slotid != null)
	{
		var slot = document.createElement("div");
		slot.id = "slot_" + slotname + "_" + slotid;
		if (isphy != null)
		{
			slot.className = 'Cardphylog SelStateOff cardw';
		}
		else
		{
			slot.className = 'Cardlogic SelStateOff cardw';
		}
		
		slot.innerHTML = slotid + "-" + slotname;
		
		slot.friendid = friendid;
		board.appendChild(slot);
		if (isProtect) 
		{
			var proSpan = document.createElement('div');
			proSpan.className = 'ifpro';
			proSpan.style.marginLeft = '36px';
			proSpan.style.marginTop = '-6px';
			slot.appendChild(proSpan);
		}
	}

	return board;
}

function createIfProtect(boardGroup)
{
	var fieldset = document.createElement("fieldset");
	fieldset.className = "ifgroupfieleset";
	fieldset.style.borderWidth = "2px";

	var legend = document.createElement("legend");
	var text = document.createElement("span");

	text.innerHTML = protect[boardGroup.protectType];
	legend.appendChild(text);
	fieldset.appendChild(legend);
	var mblProtect = false;
	var pblProtect = true;
	if(boardGroup.protectType == "-1")
	{
		pblProtect = false;
	}
	else if(boardGroup.convert)
	{
		mblProtect = true;
		pblProtect = false;
	}
	var boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";

  var ifboard = addBoard(boardGroup.mSlotId, boardGroup.mBoardName, getBoardGroupKey(boardGroup), boardGroup.mIfPhy,mblProtect);

	boardcontain.appendChild(ifboard);

  var woduboard = addBoard(boardGroup.mOduSlotId, boardGroup.mOduName, getBoardGroupKey(boardGroup), boardGroup.mOduPhy);
	boardcontain.appendChild(woduboard);

	fieldset.appendChild(boardcontain);

	boardcontain = document.createElement("div");
	boardcontain.className = "boardcontain";
	
	

  var board = addBoard(boardGroup.pSlotId, boardGroup.pBoardName, getBoardGroupKey(boardGroup), boardGroup.pIfPhy, pblProtect);

	boardcontain.appendChild(board);

    var poduboard = addBoard(boardGroup.pOduSlotId, "ODU", getBoardGroupKey(boardGroup), boardGroup.pOduPhy);
	boardcontain.appendChild(poduboard);
	
	fieldset.appendChild(boardcontain);

	var ifcontain = document.createElement("div");

	ifcontain.className = "ifgroupcontain";

	ifcontain.appendChild(fieldset);

	var contain = $("contain");

	contain.appendChild(ifcontain);
	if(singleobj.mSlotId == singleobj.mOduSlotId)
	{
		$("slot_" + singleobj.mBoardName + "_" + singleobj.mSlotId).style.width = "100%";
		$("slot_" + singleobj.mBoardName + "_" + singleobj.mSlotId).parentNode.style.width = "96%";
		woduboard.style.display = "none";
	}
	if(singleobj.pSlotId == singleobj.pOduSlotId)
	{
		$("slot_" + singleobj.mBoardName + "_" + singleobj.mSlotId).style.width = "100%";
		$("slot_" + singleobj.pBoardName + "_" + singleobj.pSlotId).parentNode.style.width = "96%";
		poduboard.style.display = "none";
	}
}

function hfClearSelState()
{
	if (lastselect != null)
	{
		var ele = $("slot" + lastselect);
		ele.className = ele.className.replace("SelStateOn", "SelStateOff");
	}
}

function hfSetSelState(eid)
{
	var ele = $("slot" + eid);
	ele.className = ele.className.replace("SelStateOff", "SelStateOn");
}

function handelclick(evt)
{
	var evt = evt ? evt : window.event;
	var element = evt.srcElement;
	var id = element.id;

	if (id.substr(0, 4) != "slot")
	{
		return;
	}

	boardon(id.substr(4, id.length), element);

}

function compareNum(str1, str2)
{
	var value1 = parseInt(str1);
	var value2 = parseInt(str2);
	return compare(value1, value2);
}

function compare(str1, str2)
{
	if (str1 > str2)
	{
		return 1;
	}
	if (str1 < str2)
	{
		return -1;
	}
	return 0;
}

function boardon(boardid, element)
{
	if(pageWaitFlag)
	{
		return;
	}
	hfClearSelState();
	hfSetSelState(boardid);
	lastselect = boardid;

	var friend = element.friendid;
	var boardgp = boardGroupList[friend];
	boardgp.neId = neidvalue;
	currentBoardGroup = boardgp;
	setPageWait();
	queryPeerNE(boardgp.mSlotId + "," + boardgp.mBoardName);
	queryIFLink();
	$("txtTxPower1").value = "";
	$("txtTxPower2").value = "";
}


/**
 * if/odu board group
 */
function BoardGroup()
{
	this.neId = null;
	this.protectType = null;
	
	this.mSlotId = null;
	this.mBoardName = null;
	this.mIfPhy = null;
	this.mOduSlotId = null;
	this.mOduPhy = null;
	this.mOduName = "ODU";
	this.convert = null;
	this.mRslList = null;
	this.mMseList = null;
	this.mQueryRslCount = 0;
	this.mRxPower = null;
	this.mTxPower = null;
	this.mTxRange = null;
	this.mBeTxPower = null;
	
	this.pSlotId = null;
	this.pBoardName = null;
	this.pIfPhy = null;
	this.pOduSlotId = null;
	this.pOduPhy = null;
	this.pOduName = "ODU";
	this.pRslList = null;
	this.pMseList = null;
	this.pRxPower = null;
}

/**
 *          
 */
function rdAutoOnClick()
{
	$("txtTxPower1").disabled = true;
	$("txtTxPower2").disabled = true;
}

/**
 *          
 */
function rdManualOnClick()
{
	$("txtTxPower1").disabled = false;
	$("txtTxPower2").disabled = false;
}

/**
 *           
 */
function setPageElementState(state)
{
	$("rdAuto").disabled = state;
	$("rdManual").disabled = state;
	var txFlag = true;
	if(!$("rdManual").disabled && $("rdManual").checked)
	{
		txFlag = false;
	}
	$("txtTxPower1").disabled = txFlag;
	$("txtTxPower2").disabled = txFlag;
	$("rdLocaltoRemote").disabled = state;
	$("rdRemotetoLocal").disabled = state;
	$("btnTest").disabled = state;
}

function createXMLparam(row, name, value)
{
	param = new tagElement("param");
	param.setAttribute("name", name);
	param.setAttribute("value", value);
	row.appendChild(param);
	return param;
}

function showErrorDialog(data,first)
{
	if(first == null && data.getSErrorCode() != 0 && data.getSErrorCode() != 1)
	{
		resumePageWait();
	}
	pageWaitFlag = false;
	document.body.style.cursor = "default";
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", data.getError(), errArr);
}

/**
 *          
 */
function startTest()
{
	if(!verifyInput())
	{
		return;
	}
	
	if (!confirm(RESOURCE["DANGER_ALARM"])) 
        {
            return;
        }

	setPageWait();
	
	$("txtResult").value = firstResultStr + getNewLine() + RESOURCE["starttest"] ;
	
	initTest();
	
	attemperTask();
}

function verifyInput()
{
	var result = true;
	if(rdManual.checked)
	{
		if($("txtTxPower1").value == "")
		{
			alert(RESOURCE["txpower1null"]);
			$("txtTxPower1").focus();
			result = false;
		}
		else if($("txtTxPower2").value == "")
		{
			alert(RESOURCE["txpower2null"]);
			$("txtTxPower2").focus();
			result = false;
		}
		else if(parseFloat($("txtTxPower1").value) <= parseFloat($("txtTxPower2").value))
		{
			alert(RESOURCE["manulerror"]);
			$("txtTxPower1").focus();
			result = false;
		}
	}
	
	return result;
}

/**
 *           
 */
function initTest()
{
	currentTaskIndex = STEP_QUERY_TX;
	currentBoardGroup.mRslList = [];
	currentBoardGroup.mMseList = [];
	currentBoardGroup.pRslList = [];
	currentBoardGroup.pMseList = [];
	currentBoardGroup.mRxPower = null;
	currentBoardGroup.mQueryRslCount = 0;
	remoteBoardGroup.mRslList = [];
	remoteBoardGroup.mMseList = [];
	remoteBoardGroup.pRslList = [];
	remoteBoardGroup.pMseList = [];
	remoteBoardGroup.mRxPower = null;
	remoteBoardGroup.mQueryRslCount = 0;
}

/**
 *   TSL RSL MSE  
 */
function queryMSE()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep3"];
	setWaitIntervalStart();
	var xmlstr = createQueryMSE();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_MSE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryMSEHandler, null, "inputdata=" + xmlstr);
}

/**
 *     TSL RSL MSE   XML
 */
function createQueryMSE()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	
	var row = new tagElement("row-params");
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mSlotId);
	bussiness.appendChild(row);
	
	if(neboard.protectType != null)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pSlotId);
		bussiness.appendChild(row);
	}

	di.getRoot().appendChild(bussiness);

	return di.toString();
}
	
/**
 *     MSE    65535,       ,      65535
 */
function getMSEShowValue(mse)
{
	if(parseFloat(mse) < 0)
	{
		mse = 65535;
	}
	
	return mse;
}

/**
 *   TSL RSL MSE       
 *             
 *@param doc      XML
 */
function queryMSEHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	setWaitIntervalEnd(data.getSErrorCode());
	
	if(rdRemotetoLocal.checked && neboard.mQueryRslCount >= 1 && data.getSErrorCode() == TIME_OUT)
	{
		currentTaskIndex = STEP_RESUME_TX;
		attemperTask();
		return;
	}
	if (data.getSErrorCode() == 0 && data.getDataRowLength() >= 1)
	{
		var txneboard = getTransNeBoardInfo();
		
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mMse = data.getDataRowParam(0,"mse");
		$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"if") + getMSEShowValue(mMse) + "dB";
		
		var pMse = null;
		var slotid2 = null;
		if(data.getDataRowLength() > 1)
		{
			slotid2 = data.getDataRowParam(1,"slotid");
			pMse = data.getDataRowParam(1,"mse");
			$("txtResult").value += " "+ getProtectFirst(neboard,slotid2,"if") + getMSEShowValue(pMse) + "dB";
		}
		if(neboard.mQueryRslCount == 1)
		{
			if(parseFloat(mMse) < LINK_BREAK_VALUE)
			{
				neboard.mMseList = null;
			}
			if(null != pMse && parseFloat(pMse) < LINK_BREAK_VALUE)
			{
				neboard.pMseList = null;
			}
			if(rdAuto.checked)
			{
				txneboard.mBeTxPower = parseFloat((txneboard.mBeTxPower - PER_TX_POWER).toFixed(1));
			}
			else
			{
				txneboard.mBeTxPower = parseFloat($("txtTxPower1").value);
			}
			
			currentTaskIndex = STEP_SET_TX;
		}
		else
		{
			if(null != neboard.mMseList)
			{
				neboard.mMseList[neboard.mMseList.length] = mMse;
			}
			if(data.getDataRowLength() > 1 && null != neboard.pMseList)
			{
				neboard.pMseList[neboard.pMseList.length] = pMse;
			}
			if(rdAuto.checked)
			{
				txneboard.mBeTxPower = parseFloat((txneboard.mBeTxPower - PER_TX_POWER).toFixed(1));
			}
			else
			{
				txneboard.mBeTxPower = parseFloat($("txtTxPower2").value);
			}
		}

		if((parseFloat(mMse) < LINK_BREAK_VALUE && null != neboard.mMseList) || (null != pMse && parseFloat(pMse) < LINK_BREAK_VALUE && null != neboard.pMseList))
		{
			if(null != neboard.mMseList)
			{
				neboard.mRslList.length = neboard.mRslList.length - 1;
				neboard.mMseList.length = neboard.mMseList.length - 1;
				if(parseFloat(mMse) < LINK_BREAK_VALUE)
				{
					$("txtResult").value += getNewLine() + getProtectFirst(neboard,slotid1,"if") +  RESOURCE["linkerror"];
				}
			}
			if(null != pMse && null != neboard.pMseList)
			{
				neboard.pRslList.length = neboard.pRslList.length - 1;
				neboard.pMseList.length = neboard.pMseList.length - 1;
				if(parseFloat(pMse) < LINK_BREAK_VALUE)
				{
					$("txtResult").value += getNewLine() + getProtectFirst(neboard,slotid2,"if") +  RESOURCE["linkerror"];
				}
			}
			
			currentTaskIndex = STEP_RESUME_TX;
		}
		else if(txneboard.mBeTxPower < txneboard.mTxRange.value1|| (rdManual.checked && neboard.mQueryRslCount > 2))
		{
			currentTaskIndex = STEP_RESUME_TX;
		}
		else
		{
			currentTaskIndex = STEP_SET_TX;
		}
		attemperTask();
	}
	showErrorDialog(data);
}

/**
 *         
 *@param first                   ,
 *                        
 */
function queryTXRange(first)
{
	if(first == null)
	{
		$("txtResult").value += getNewLine() + RESOURCE["query"] + getTransFirstTitle() + RESOURCE["teststep1"];
		setWaitIntervalStart();
	}
	var xmlstr = createQueryTXRange();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryTXRangeHandler, first, "inputdata=" + xmlstr);
}

/**
 *            XML
 */
function createQueryTXRange()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);
	
	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTRANGEOFPOWER");
	createXMLparam(row,"attrId","LOWPOWER");
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *         ,            
 *@param doc     XML  
 */
function queryTXRangeHandler(doc,first)
{
	var data = EncapsulateData(doc);
	if(first == null)
	{
		setWaitIntervalEnd(data.getSErrorCode());
	}
	if (data.getSErrorCode() == 0 && data.getDataRowLength() == 1)
	{
		var lowpower = data.getDataRowParam(0,"LOWPOWER");
		var heighpower = data.getDataRowParam(0,"W32BRD_ATTR_ACTRANGEOFPOWER");
		var neboard = getTransNeBoardInfo();

		textCheck($("txtTxPower1"),lowpower,heighpower);
		textCheck($("txtTxPower2"),lowpower,heighpower);
		if(first == null)
		{
			$("txtResult").value += " " + lowpower + "dBm" + "-" + heighpower + "dBm";
			if(rdAuto.checked && (neboard.mTxPower - PER_TX_POWER) < lowpower)
			{
				alert(RESOURCE["txlowerror"]);
				resumePageWait();
				return;
			}
			neboard.mTxRange = new Pair(lowpower,heighpower);
			
			currentTaskIndex = STEP_QUERY_RSL;
			attemperTask();
		}
	}
	showErrorDialog(data,first);
}

/**
 *       
 */
function queryTXPower()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getTransFirstTitle() + RESOURCE["teststep2"];
	setWaitIntervalStart();

	var xmlstr = createQueryTXPower();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryTXPowerHandler, null, "inputdata=" + xmlstr);
}

/**
 *          XML
 */
function createQueryTXPower()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);

	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32BRD_ATTR_TRANSMITPOWER");
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *            
 *             ,                 
 *@param doc      XML  
 */
function queryTXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0 && data.getDataRowLength() == 1)
	{
		var txpower = parseFloat(data.getDataRowParam(0,"W32BRD_ATTR_TRANSMITPOWER"));
		$("txtResult").value += " " + txpower + "dBm";
		var neboard = getTransNeBoardInfo();
		neboard.mTxPower = txpower;
		neboard.mBeTxPower = txpower;
		currentTaskIndex = STEP_QUERY_TX_RANGE;
		attemperTask();
	}
	showErrorDialog(data);
}

function queryRXPower()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep7"];
	setWaitIntervalStart();

	var xmlstr = createQueryRXPower();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_ODU_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryRXPowerHandler, null, "inputdata=" + xmlstr);
}

/**
 *          XML
 */
function createQueryRXPower()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	
	var row = new tagElement("row-params");
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);

	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTTRANSMITPOWER");
	createXMLparam(row,"attrId","W32BRD_ATTR_ACTRECEIVEPOWER");
	bussiness.appendChild(row);
	if(neboard.protectType != null)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pOduSlotId);
	
		createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
		createXMLparam(row,"attrId","W32BRD_ATTR_ACTTRANSMITPOWER");
		createXMLparam(row,"attrId","W32BRD_ATTR_ACTRECEIVEPOWER");
		bussiness.appendChild(row);
	}
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function getProtectFirst(neboard,slotid,flag)
{
	var first = "";
	if(neboard.protectType  != null)
	{
		var workflag = true;
		if(flag.toLowerCase() == "if")
		{
			workFlag = (neboard.mSlotId == slotid);
		}
		else
		{
			workFlag = (neboard.mOduSlotId == slotid);
		}
		if(neboard.protectType.toString() == "-1")
		{
			first = workFlag?"H:":"V:";
		}
		else
		{
			first = workFlag?RESOURCE["main"]:RESOURCE["back"];
		}
	}
	return first;
}

/**
 *            
 *             ,                 
 *@param doc      XML  
 */
function queryRXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	var neboard = getReceiveNeBoardInfo();
	setWaitIntervalEnd(data.getSErrorCode());
	if(rdRemotetoLocal.checked && neboard.mQueryRslCount >= 1 && data.getSErrorCode() == TIME_OUT)
	{
		currentTaskIndex = STEP_RESUME_TX;
		attemperTask();
		return;
	}
	if (data.getSErrorCode() == 0 && data.getDataRowLength() >= 1)
	{
		neboard.mQueryRslCount++;
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mRxPower = data.getDataRowParam(0,"W32BRD_ATTR_ACTRECEIVEPOWER");
		$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"odu") + mRxPower + "dBm";
		var pRxPower = null;
		if(data.getDataRowLength() > 1)
		{
			var slotid2 = data.getDataRowParam(1,"slotid");
			pRxPower = data.getDataRowParam(1,"W32BRD_ATTR_ACTRECEIVEPOWER");
			$("txtResult").value += " " + getProtectFirst(neboard,slotid2,"odu") + pRxPower + "dBm";
		}
		if(neboard.mQueryRslCount == 1)
		{
			neboard.mRxPower = mRxPower;
			neboard.pRxPower = pRxPower;
		}
		else
		{
			neboard.mRslList[neboard.mRslList.length] = mRxPower;
			if(data.getDataRowLength() > 1)
			{
				neboard.pRslList[neboard.pRslList.length] = pRxPower;
			}
		}
		currentTaskIndex = STEP_QUERY_MSE;
		attemperTask();
	}
	showErrorDialog(data);
}

/**
 *         
 */
function setTXPower()
{
	$("txtResult").value += getNewLine() + RESOURCE["set"] + getTransFirstTitle() + RESOURCE["teststep4"] + ":" + getTransNeBoardInfo().mBeTxPower + "dBm";
	setWaitIntervalStart();
	var xmlstr = createSetTXPower();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_SET_TXPOWER
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, setTXPowerHandler, null, "inputdata=" + xmlstr);
}

/**
 *         
 */
function resumeTXPower()
{
	$("txtResult").value += getNewLine() + RESOURCE["resume"] + getTransFirstTitle() + RESOURCE["teststep4"]+":" + getTransNeBoardInfo().mTxPower + "dBm";
	setWaitIntervalStart();
	var xmlstr = createResumeTXPower();
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_SET_TXPOWER
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, resumeTXPowerHandler, null, "inputdata=" + xmlstr);
}

/**
 *          XML
 *@param txpower        
 */
function createSetTXPower()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);

	createXMLparam(row,"txPower",Math.round(neboard.mBeTxPower * 10));
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *          XML
 *@param txpower        
 */
function createResumeTXPower()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var neboard = getTransNeBoardInfo();
	
	createXMLparam(row,"neid",neboard.neId);
	createXMLparam(row,"slotid",neboard.mOduSlotId);
	createXMLparam(row,"txPower",Math.round(neboard.mTxPower * 10));
	
	bussiness.appendChild(row);
	
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *            
 *             RSL MSE
 *@param doc      XML  
 */
function setTXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0)
	{
		currentTaskIndex = STEP_QUERY_RSL;
		attemperTask();
	}
	showErrorDialog(data);
}

/**
 *            
 *           FadeMargin 
 *@param doc      XML  
 */
function resumeTXPowerHandler(doc)
{
	var data = EncapsulateData(doc);
	setWaitIntervalEnd(data.getSErrorCode());
	if (data.getSErrorCode() == 0)
	{
		currentTaskIndex = STEP_QUERY_MARGIN;
		attemperTask();
	}
	showErrorDialog(data);
}

/**
 *   FadeMargin 
 */
function queryFadeMargin()
{
	$("txtResult").value += getNewLine() + RESOURCE["query"] + getReceiveFirstTitle() + RESOURCE["teststep6"];
	setWaitIntervalStart();
	var xmlstr = createQueryFadeMargin();
	if(null == xmlstr)
	{
		/**
		 *  xmlstr                        
		 * q00119080
		 * 2011-6-19
		 */
		setWaitIntervalEnd(2);
		resumePageWait();
		return;
	}
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_FADEMARGIN_QUERY_FADEMARGIN
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryFadeMarginHandler, null, "inputdata=" + xmlstr);
}

/**
 *   FadeMargin    XML
 */
function createQueryFadeMargin()
{	
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var neboard = getReceiveNeBoardInfo();
	var testmode = $("rdAuto").checked?0:1;
	var row = null;
	if(null != neboard.mMseList)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.mSlotId);
		createXMLparam(row,"testmode",testmode);
		createXMLparam(row,"rxPower",Math.round(neboard.mRxPower * 10));
		createXMLparam(row,"num",neboard.mRslList.length);
		createXMLparam(row,"rslmse",convertProperty(neboard.mRslList,neboard.mMseList));
		
		bussiness.appendChild(row);
	}
	if(neboard.protectType != null && null != neboard.pMseList)
	{
		row = new tagElement("row-params");
		createXMLparam(row,"neid",neboard.neId);
		createXMLparam(row,"slotid",neboard.pSlotId);
		createXMLparam(row,"testmode",testmode);
		createXMLparam(row,"rxPower",Math.round(neboard.pRxPower*10));
		createXMLparam(row,"num",neboard.pRslList.length);
		createXMLparam(row,"rslmse",convertProperty(neboard.pRslList,neboard.pMseList));
		bussiness.appendChild(row);
	}
	if(null == row)
	{
		return null;
	}
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *   FadeMargin        
 *@param doc      XML  
 */
function queryFadeMarginHandler(doc)
{
	var data = EncapsulateData(doc);
	
	setWaitIntervalEnd(data.getSErrorCode());
	if ((data.getSErrorCode() == 0 || data.getSErrorCode() == 1) && data.getDataRowLength() >= 1)
	{
		var neboard = getReceiveNeBoardInfo();
		var slotid1 = data.getDataRowParam(0,"slotid");
		var mfademargin = parseInt(data.getDataRowParam(0,"fademargin")) / 10;
		$("txtResult").value += " " + getProtectFirst(neboard,slotid1,"if") + RESOURCE["fademargintitle"] + ":" + mfademargin + "dB";
		if(data.getDataRowLength() > 1)
		{
			var slotid2 = data.getDataRowParam(1,"slotid");
			var pfademargin = parseInt(data.getDataRowParam(1,"fademargin")) / 10;
			$("txtResult").value += " "+ getProtectFirst(neboard,slotid2,"if") + RESOURCE["fademargintitle"] + ":" + pfademargin + "dB";
		}
		else if(data.getSErrorCode() == 1)
		{
			$("txtResult").value += " "+ getProtectFirst(neboard,data.getBErrParam(0,"slotid"),"if") + RESOURCE["result2"];
		}
		resumePageWait();
	}
	showErrorDialog(data);
}

/**
 *  RSL MSE     QX     
 */
function convertProperty(rsllist,mselist)
{
	var result = "";
	if(rsllist != null && mselist != null
		&& rsllist.length == mselist.length)
	{
		for(var i = 0,m = rsllist.length;i < m;i++)
		{
			var rsl = rsllist[i] * 10;
			var mse = mselist[i] * 10;
			if(rsl < 0)
			{
				rsl = "0000" + (INT_INVALID + rsl).toString(16);
			}
			else
			{
				rsl = "0000" + rsl.toString(16);
			}
			if(mse < 0)
			{
				mse = "0000" + (INT_INVALID + mse).toString(16);
			}
			else
			{
				mse = "0000" +  mse.toString(16);
			}
			result += rsl.substr(rsl.length - 4) + mse.substr(mse.length - 4);
		}
	}
	return result.toUpperCase();
}

/**
 *       
 */
function attemperTask()
{
	switch(currentTaskIndex)
	{
		case STEP_QUERY_TX:
			queryTXPower();
			break;
		case STEP_QUERY_TX_RANGE:
			queryTXRange();
			break;
		case STEP_QUERY_RSL:
			queryRXPower();
			break;
		case STEP_QUERY_MSE:
			queryMSE();
			break;
		case STEP_SET_TX:
			setTXPower();
			break;
		case STEP_RESUME_TX:
			resumeTXPower();
			break;
		case STEP_QUERY_MARGIN:
			queryFadeMargin();
			break;
		default:
			break;
	}
}

/**
 *     ID
 */
function queryIFLink()
{
	var xmlstr = createQueryIFLink();
	var urlreq = "../../../../neExlorerServlet?sfid=" + QUERY_IF_INTERFACE
			+ "&timeStamp=" + new Date().getTime() + "&nmUser="
			+ neobject["nmUser"];
	loadXMLdoc(urlreq, "POST", true, queryIFLinkHandler, null, "inputdata=" + xmlstr);
}

/**
 *     ID   XML
 */
function createQueryIFLink()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	
	createXMLparam(row,"neid",currentBoardGroup.neId);
	createXMLparam(row,"slotid",currentBoardGroup.mSlotId);

	createXMLparam(row,"srcObjType","ID_OBJECT_TYPE_NE_BOARD");
	createXMLparam(row,"attrId","W32PORT_ATTR_RADIOLINKID");
	createXMLparam(row,"attrId","W32PORT_ATTR_RECRADIOLINKID");
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

/**
 *     ID       
 *@param doc     XML  
 */
function queryIFLinkHandler(doc)
{
	var data = EncapsulateData(doc);
	if ((data.getSErrorCode() == 0 || data.getSErrorCode() == 1)&& data.getDataRowLength() == 1)
	{
		var linkid = data.getDataRowParam(0,"W32PORT_ATTR_RADIOLINKID");
		var reallinkid = data.getDataRowParam(0,"W32PORT_ATTR_RECRADIOLINKID");
		$("txtLinkId").value = reallinkid;
	}
}
