var ethpfmst;
var queuepfmst;

var winobj = getNeProperty(self);

var queueType = new Object();
queueType["costype_1"] = "CS7";
queueType["costype_2"] = "CS6";
queueType["costype_3"] = "EF";
queueType["costype_4"] = "AF4";
queueType["costype_5"] = "AF3";
queueType["costype_6"] = "AF2";
queueType["costype_7"] = "AF1";
queueType["costype_8"] = "BE";

var IntervalObject = null;
var IntervalTime = 15000;

var Last_Selected_RowIndex = -1;

var firstQueryFlag = true;
var QueryStepIndex = 0;


/**
 *      
 * 
 * @param  
 * @return  
 */
function init()
{
	initButton();
	initTable();
	$("autuRefresh").disabled = true;
	$("selIntervalTime").disabled = true;
	$("queryBtn").disabled = true;

	queryEthPfmInterval();
	IntervalObject = window.setInterval(queryEthPfmInterval,IntervalTime);
}

function queryEthPfmInterval()
{
	queryEthPfm(true);
}

function tabSelectHandler()
{
	var totalHeight = getComponetHeight($("tablecomponent"), 120);
	ethpfmst.setBodyHeight(totalHeight * 0.6 + "px");
	queuepfmst.setBodyHeight(totalHeight * 0.4 + "px");
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	ethpfmst = new SortTable();
	ethpfmst.setImage("../../../../images/");
	ethpfmst.setOnRowSelectHandler(rowSelectHandler);
	createTableHead(ethpfmst, window.tableconf[0]);
	$("ethpfmcontainer").appendChild(ethpfmst.getTable());

	queuepfmst = new SortTable();
	queuepfmst.setImage("../../../../images/");
	createTableHead(queuepfmst, window.tableconf[1]);
	$("queuepfmcontainer").appendChild(queuepfmst.getTable());

	var totalHeight = getComponetHeight($("tablecomponent"), 120);
	ethpfmst.setBodyHeight(totalHeight * 0.6 + "px");
	queuepfmst.setBodyHeight(totalHeight * 0.4 + "px");
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initButton()
{
	$("queuepfmTableTitle").appendChild(document.createTextNode(RESOURCE["queuepfmtitle"]));
	$("queryBtn").value = RESOURCE["querybutton"];
	$("queryBtn").disabled = true;
	$("autorefresh").innerHTML = RESOURCE["autorefresh"];
	$("selIntervalTime").options[0] = new Option("15" + RESOURCE["second"],"15000");
	$("selIntervalTime").options[1] = new Option("30" + RESOURCE["second"],"30000");
	$("selIntervalTime").options[2] = new Option("60" + RESOURCE["second"],"60000");
}


/**
 *             
 * 
 * @param rows:      
 * @return  
 */
function rowSelectHandler(rows)
{
	if (rows.length == 0)
	{
		Last_Selected_RowIndex = -1;
		queuepfmst.clearTableData();
	}
	else
	{
		Last_Selected_RowIndex = rows[0];
		queuepfmst.clearTableData();
		queryQueuePfm(Last_Selected_RowIndex);
	}
}


/**
 *       
 * 
 * @param  
 * @return  
 */
function queryEthPfm(bInterval)
{
	if(bInterval == false)
	{
		$("autuRefresh").disabled = true;
		$("selIntervalTime").disabled = true;
		$("queryBtn").disabled = true;
	}
	if(QueryStepIndex > 0)
	{
		return;
	}
	QueryStepIndex++;
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_RTN_ETH_PFM + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryEthpfmcallback, [bInterval], "inputdata="
			+ createQueryEthPfmXML(bInterval));
}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryEthPfmXML(bInterval)
{
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);
	if(bInterval == true && firstQueryFlag == false)
	{
		param = new tagElement("param");
		param.setAttribute("name", "isLogFlag");
		param.setAttribute("value", "0");
		row.appendChild(param);
	}

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             
 * 
 * @param doc:          
 * @return  
 */
function queryEthpfmcallback(doc,params)
{
	
	var data = EncapsulateData(doc);
	var lastSelectedAlarm = [];
	for(var i = 0,len = ethpfmst.getDataRowLength();i < len;i++)
	{
		if (ethpfmst.getRowSelFlag(i))
		{
			lastSelectedAlarm[lastSelectedAlarm.length] = ethpfmst.getCellStoreValue(i, "port","slotid") + "-" + ethpfmst.getCellStoreValue(i, "portid","portid");
		}
	}
	QueryStepIndex--;
	if(params[0] != true || firstQueryFlag)
	{
		showErrorDialog(data);
	}
	if(OPERATION_SUCCESS == data.getSErrorCode()
		|| OPERATION_PART_SUCCESS == data.getSErrorCode())
	{
		ethpfmst.clearTableData();
		createTableBody(ethpfmst, window.tableconf[0], data, RESOURCE);
		
		if(ethpfmst.getDataRowLength() > 0)
		{
			if(firstQueryFlag)
			{
				firstQueryFlag = false;
				singleClick(ethpfmst.getRow(0).element, true);
			}
			else
			{
				for(var j = 0; j < ethpfmst.getDataRowLength(); j++)
			    {
			    	var storevalue = ethpfmst.getCellStoreValue(j, "port","slotid") + "-" + ethpfmst.getCellStoreValue(j, "portid","portid");
			    	if(lastSelectedAlarm.contains(storevalue))
			    	{
			    		singleClick(ethpfmst.getRow(j).element, true);
			    	}
			    }
		    }
		    if(ethpfmst.getSelectedRows().length > 0)
		    {
		    	queryQueuePfm(ethpfmst.getSelectedRows()[0],params[0]);
		    	return;
		    }
	    }
	    
	    if(ethpfmst.getSelectedRows().length == 0)
	    {
	    	queuepfmst.clearTableData();
	    }
    }
	handleQueryEnd(data);
}

function handleQueryEnd(data)
{
	if($("autuRefresh").checked == false)
	{
		$("queryBtn").disabled = false;
		$("selIntervalTime").disabled = false;
		$("autuRefresh").disabled = false;
	}
	else
	{
		$("queryBtn").disabled = true;
		$("selIntervalTime").disabled = true;
		$("autuRefresh").disabled = false;
	}
}

/**
 *       
 * 
 * @param  
 * @return  
 */
function queryQueuePfm(rowIndex,bInterval)
{
	var xml = createQueryQueuePfmXML(rowIndex,bInterval);
	if(xml == null)
	{
		return;
	}
	QueryStepIndex++;
	var url = "../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_RTN_QUEUE_PFM + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryQueuepfmcallback, [bInterval], "inputdata="+ xml);
}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryQueuePfmXML(rowIndex,bInterval)
{
	if(rowIndex < 0 || rowIndex > (ethpfmst.getDataRowLength() - 1))
	{
		return null;
	}
	var root = new inputxml("datainterface");

	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);
	
	var slotid = ethpfmst.getCellStoreValue(rowIndex, "port", "slotid");
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);
	
	var portid = ethpfmst.getCellStoreValue(rowIndex, "portid", "portid");
	param = new tagElement("param");
	param.setAttribute("name", "portid");
	param.setAttribute("value", portid);
	row.appendChild(param);
	
	if(bInterval == true && firstQueryFlag == false)
	{
		param = new tagElement("param");
		param.setAttribute("name", "isLogFlag");
		param.setAttribute("value", "0");
		row.appendChild(param);
	}

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

function queryQueuepfmcallback(doc)
{
	var data = EncapsulateData(doc);
	var lastSelectedAlarm = [];
	for(var i = 0,len = queuepfmst.getDataRowLength();i < len;i++)
	{
		if (queuepfmst.getRowSelFlag(i))
		{
			lastSelectedAlarm[lastSelectedAlarm.length] = queuepfmst.getCellStoreValue(i, "queue","queue");
		}
	}
	QueryStepIndex--;
	queuepfmst.clearTableData();
	createTableBody(queuepfmst, window.tableconf[1], data, RESOURCE);
	for(var j = 0; j < queuepfmst.getDataRowLength(); j++)
    {
    	var storevalue = queuepfmst.getCellStoreValue(j, "queue","queue");
    	if(lastSelectedAlarm.contains(storevalue))
    	{
    		singleClick(queuepfmst.getRow(j).element, true);
    	}
    }
    handleQueryEnd();
}


/**
 *     Checkbox     
 *          ,        
 * @param check     
 */
function autoRefresh(check)
{
	if(check == false)
	{
		if(IntervalObject)
		{
			window.clearInterval(IntervalObject);
			IntervalObject = null;
		}
		$("queryBtn").disabled = false;
		$("selIntervalTime").disabled = false;
	}
	else
	{
		queryEthPfmInterval();
		IntervalObject = window.setInterval(queryEthPfmInterval,$("selIntervalTime").value);
		$("queryBtn").disabled = true;
		$("selIntervalTime").disabled = true;
	}
}


/**
 *       
 *               
 */
function showErrorDialog(/*Object*/data)
{
	var errArr = [];
	errArr[0] = "nename";
	openErrPage("../../../../page/", data.getError(), errArr); 
}
