var winurlobj = getNeProperty(self);

var ids = null;
var lightcycle = new Object();
lightcycle["0"] = RESOURCE["notCycle"];
lightcycle["1"] = RESOURCE["inCycle"];
lightcycle["2"] = RESOURCE["outCycle"];

var laserswitch = new Object();
laserswitch[0] = RESOURCE["close"];
laserswitch[1] = RESOURCE["open"];
laserswitch[2] = RESOURCE["als"];

var hasApplyRight = true;

var confirmStr1 = "";
var confirmStr2 = "";
var confirmStr3 = "";
var confirmStr4 = "";

var IF1A_BOARDTYPE = 1032;
var IF1B_BOARDTYPE = 1033;
var IFX_BOARDTYPE = 1175;

function pathShow(obj)
{
	return obj;
}

function initpage()
{
	st = new SortTable();
	st.setImage("../../../../images/");
	st.setBodyHeight("280");

	tc = window.tableconf[0];

	var attrArr = getNeProperty(self)["supportAttr"].split(",");

	filterAttrCol(tc, attrArr);

	ids = getIDs();

	createTableHead(st, tc);
	st.setOnCellEditHandler(cellEditHandler);
	document.getElementById("tablecomponent").appendChild(st.getTable());
	window.onresize = function()
	{
		st.setBodyHeight(getTableHeight($("tablecomponent"), st) + "px");
	}
	$("tablecomponent").oncontextmenu = popupMenuHandler;

	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];

	sendQueryInfo();
}

/**
 *           
 */
function changeTableHead(selectAttr)
{
	st.deleteHeadRow();
	st.element.colsArray.length = 0;
	newtc.colArray.length = 0;

	initTableHead(selectAttr);
	createTableHead(st, newtc);

	st.clearTableData();
	sendQueryInfo();
}

/**
 *    tableconf
 */
function initTableHead(selectAttr)
{
	var flag = false;
	var selectedItem;

	if (null == selectAttr)
	{
		return;
	}
	else
	{
		selectedItem = selectAttr;
	}
	for ( var i = 0; i < window.tableconf.length; i++)
	{
		for ( var j = 0; j < window.tableconf[i].colArray.length; j++)
		{
			if (window.tableconf[i].colArray[j].id != selectedItem)
			{
				continue;
			}

			newtc.colArray[0] = window.tableconf[i].colArray[0];
			newtc.colArray[0].width = "10%";
			newtc.colArray[1] = window.tableconf[i].colArray[j];
			newtc.colArray[1].width = "10%";
			flag = true;
			break;
		}

		if (flag)
		{
			break;
		}
	}
}

/**
 *               
 * 
 * @param  
 * @return  
 */
function cellEditHandler()
{
	if (hasApplyRight)
	{
		$("applybtn").disabled = false;
	}
}

function sendQueryInfo()
{

	$("querybtn").disabled = true;
	$("applybtn").disabled = true;

	var neid = winurlobj.neid;
	var slotid = winurlobj.slotid;

	var xmlstr = createGetXML(neid, slotid, tc);
	urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_GETSDHATTR;
	loadXMLdoc(urlreq, "POST", true, queryCallBack, null, "inputdata=" + xmlstr);
}

/**
 *          XML  
 * 
 * @param neid:  ID
 *            slotid:  ID tableconf:        
 * @return String:       XML  
 */

function createGetXML(neid, slotid, tableconf)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);
	param = new tagElement("param");
	param.setAttribute("name", "slotid");
	param.setAttribute("value", slotid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcObjType");
	param.setAttribute("value", "ID_OBJECT_TYPE_NE_BOARD");
	row.appendChild(param);

	var colid;
	var attrFlag = false;
	for ( var i = 1; i < tableconf.getColsLength(); i++)
	{
		colid = tableconf.getColId(i);
		param = new tagElement("param");
		param.setAttribute("name", "attrId");
		param.setAttribute("value", colid);
		row.appendChild(param);
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function queryCallBack(doc)
{
	$("querybtn").disabled = false;

	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 2)
	{
		showErrorDialog(tc, data);
		return;
	}
	createGenCfgTableBody(st, tc, data, RESOURCE);
	addListener();
	if (0 == data.getSErrorCode())
	{
		return;
	}
	showErrorDialog(tc, data);
}

function sendSetInfo()
{
	var neid = winurlobj.neid;
	var xmlStr = createSetXML(neid, st, tc);
	var alrmStr = "";
	if ("" != confirmStr1 && "" != confirmStr2)
	{
		alrmStr = confirmStr1 + "," + confirmStr2;
	}
	else
	{
		alrmStr = confirmStr1 + confirmStr2 + confirmStr3 + confirmStr4;
	}
	if ("" != alrmStr)
	{
		if(!confirm(RESOURCE["confirmSetFirst"]))
		{
			return;
		}
		if (!confirm(RESOURCE["confirmSet"] + alrmStr + "?"))
		{
			return;
		}
	}	
	
	if (null == xmlStr)
	{
		return;
	}
	
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;	
	urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_SETSDHATTR;
	loadXMLdoc(urlreq, "POST", true, setCallBack, null, "inputdata=" + xmlStr);
}

function setCallBack(doc)
{
	$("querybtn").disabled = false;

	var data = EncapsulateData(doc);
	initStr();
	if (data.getSErrorCode() != 0)
	{
		showErrorDialog(tc, data);
		return;
	}
	refreshTableState(st, tc, data);
	initStr();
}

function getIDs()
{
	var ids = new Array();
	for ( var i = 0, len = tc.getColsLength(); i < len; i++)
	{
		ids[ids.length] = tc.getColId(i);
	}
	return ids;
}

function createSetXML(neid, st, tc)
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var colid = null;
	var key = null;
	var colkeyarray = null;
	var cellModifyFlag = false;
	var portid = null;
	var index = 0;
	for ( var rowindex = 0, rowlen = st.getDataRowLength(); rowindex < rowlen; rowindex++)
	{
		if (!st.getModify(rowindex))
		{
			continue;
		}
		row = new tagElement("row-params");
		param = new tagElement("param");
		param.setAttribute("name", "neid");
		param.setAttribute("value", neid);
		row.appendChild(param);
		for ( var colindex = 0, collen = st.getColumnCount(); colindex < collen; colindex++)
		{
			colid = tc.getColId(colindex);
			cellModifyFlag = st.getCellModify(rowindex, colid);
			if(colid == "SDHPORT_ATTR_LASERSWITCH" && cellModifyFlag)
      {
			  confirmStr1 = RESOURCE[colid];
      }
      else if(colid == "PDHPATH_ATTR_LOOPBACK" && cellModifyFlag)
      {
      	confirmStr2 = RESOURCE[colid];
      }			
      else if(colid == "SDHVC4_ATTR_LOOPBACK" && cellModifyFlag)
      {
      	confirmStr3 = RESOURCE[colid];
      }
      else if(colid == "SDHVC4_ATTR_OPTICALLOOPBACK" && cellModifyFlag)
      {
      	confirmStr4 = RESOURCE[colid];
      }
			colkeyarray = tc.getColKeyArray(colindex);
			for ( var keyindex = 0, keylen = colkeyarray.length; keyindex < keylen; keyindex++)
			{
				param = new tagElement("param");

				key = colkeyarray[keyindex].name;

				if ("neid" == key)
				{
					continue;
				}

				if ("portname" == key)
				{
					param.setAttribute("name", "port")
					var portid = st.getCellStoreValue(rowindex, colid, key);
					index = portid.indexOf("(");
					param.setAttribute("value", portid.substring(0, index));
				}
				else
				{
					param.setAttribute("name", key);
					param.setAttribute("value", st.getCellStoreValue(rowindex,
							colid, key));
				}
				param.setAttribute("modifyFlag", cellModifyFlag);
				row.appendChild(param);
			}
		}
		bussiness.appendChild(row);
	}
	if (0 == bussiness.childNodes.length)
	{
		alert(RESOURCE["nochange"]);
		return;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function addListener()
{
	for ( var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if (ids.contains("SDHPORT_ATTR_LASERSWITCH"))
		{
			var laserSwith = st.getCellEdit(i, "SDHPORT_ATTR_LASERSWITCH");
			laserSwith.element["onchange"] = function()
			{
				confirmStr1 = RESOURCE["SDHPORT_ATTR_LASERSWITCH"];
			}
		}

		if (ids.contains("PDHPATH_ATTR_LOOPBACK"))
		{
			var opticalLoop = st.getCellEdit(i, "PDHPATH_ATTR_LOOPBACK");
			opticalLoop.element["onchange"] = function()
			{
				confirmStr2 = RESOURCE["PDHPATH_ATTR_LOOPBACK"];
			}
		}

		if (ids.contains("SDHVC4_ATTR_LOOPBACK"))
		{
			var isSupport = SpecialAttrMgr.isCPSupportByType(winurlobj.neid, winurlobj["boardType"], "TE_FUNC_RTN_DIGITALINTERFACE", "TE_ATTR_RTN_LOOPBACK_FILTERMODE");

			if ( winurlobj["boardType"] == IFX_BOARDTYPE  || 
				 winurlobj["boardType"] == IF1A_BOARDTYPE ||
				 winurlobj["boardType"] == IF1B_BOARDTYPE ||
				 isSupport )
			{
				var loopcell = st.getCell(i, "SDHVC4_ATTR_LOOPBACK");
				if (null != loopcell)
				{
					var filtMode = [ "2" ];
					modeFilter(filtMode, loopcell);
				}
			}
			var vc4Loop = st.getCellEdit(i, "SDHVC4_ATTR_LOOPBACK");
			vc4Loop.element["onchange"] = function()
			{
				confirmStr3 = RESOURCE["SDHVC4_ATTR_LOOPBACK"];
			}
		}
		if(ids.contains("SDHVC4_ATTR_OPTICALLOOPBACK"))
		{
			var opticalLoop = st.getCellEdit(i,"SDHVC4_ATTR_OPTICALLOOPBACK");
			opticalLoop.element["onchange"] = function()
		    {
			   confirmStr4 = RESOURCE["SDHVC4_ATTR_OPTICALLOOPBACK"];
		    }
		}
	}
}

function initStr()
{
	confirmStr1 = "";
	confirmStr2 = "";
	confirmStr3 = "";
   confirmStr4 = "";
}
function showErrorDialog(tc, data)
{
	var errArr = [];
	var errorObj = null;
	var tmpAttr = null;
	for ( var i = data.getBErrLength() - 1; i >= 0; i--)
	{
		errorObj = data.getError().rowErrors[i].errorObj;
		tmpAttr = errorObj["attrId"];

		errorObj["attrId"] = getAttrName(tc, tc.colArray[1].name);
		if (errorObj["attrId"] == tmpAttr)
		{
			data.getError().rowErrors.removeAt(i);
		}

		if (errorObj["port"] == "0" || errorObj["port"] == null)
		{

			errorObj["operationObj"] = errorObj["nename"] + "-"
					+ errorObj["slotid"] + "-" + errorObj["boardname"] + "-"
					+ errorObj["attrId"];
		}
		else
		{
			if (errorObj["path"] == "0" || errorObj["path"] == null)
			{
				errorObj["operationObj"] = errorObj["nename"] + "-"
						+ errorObj["slotid"] + "-" + errorObj["boardname"]
						+ "-" + errorObj["portname"] + "-" + errorObj["attrId"];
			}
			else
			{
				errorObj["operationObj"] = errorObj["nename"] + "-"
						+ errorObj["slotid"] + "-" + errorObj["boardname"]
						+ "-" + errorObj["portname"] + "-" + errorObj["path"]
						+ "-" + errorObj["attrId"];
			}
		}
	}
	errArr[0] = "operationObj";
	openErrPage("../../../../page/", data.getError(), errArr);
	errArr = null;
}

function modeFilter(array, ele)
{
	var modeArray = array;

	for ( var modeIndex = 0; modeIndex < modeArray.length; modeIndex++)
	{
		filter(modeArray[modeIndex], ele);
	}
}

function filter(index, ele)
{
	for ( var eleIndex = 0; eleIndex < ele.element.editElement.element.options.length; eleIndex++)
	{
		if (index == ele.element.editElement.element.options[eleIndex].value)
		{
			ele.element.editElement.element.options[eleIndex] = null;
		}
	}
}
