
var winurlobj = getNeProperty(self);
var nmUser = winurlobj.nmUser;
var neid = winurlobj.neid;
var slotid = winurlobj.slotid;
/**
 * 
 * TRANSU2000V1R7C00-4207 
 * OP201205160001:TD V1R5 DCR_RTN  SL91CQ1                WEBLCT
 * 
 */
var warningflag = false;
var btnRightArr = new Object();

var CLOCKMODE_SYS = 0;		//           
var CLOCKMODE_LINE = 2;		//           

var VALID_VALUE = 65535;
var INVALID_SUBSLOTID = 255;

var mtable;	//ctable  

var filetypeList = SpecialAttrMgr.getNEAttrListValue(neid, 
			"TE_FUNC_CFG_ETH_CLOKTRANS", "ETH_ATTR_SUPPORT_CLOCKTRANS");

var CLOCK_PORT1 = "5";
var CLOCK_PORT2 = "6";
var st;

/**
 *      
 * @return
 */
function init()
{
	if (filetypeList != null && filetypeList.length > 0)
	{
		CLOCK_PORT1 = filetypeList[0];
		CLOCK_PORT2 = filetypeList[1];
	}
	initWarningFlag();

	initTable();
	getPorts();
	queryClockTransInfor();
}

function initModeTable()
{
	st = new SortTable();
	st.isUsedForSelectList = true;
    st.setImage("../../../../images/");  
    createTableHead(st, window.tableconf[0]); 
	document.getElementById("tablecontainer1").appendChild(st.getTable());
	$("tablecontainer1").oncontextmenu = popupMenuHandler; 
	st.setOnCellEditHandler(cellEditHandler);
    st.setBodyHeight("200px");
	createTableBody(st, window.tableconf[0], new DataInterface(), RESOURCE);
}

function cellEditHandler(param)
{
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
		warningflag = true;
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function initWarningFlag()
{
	warningflag = false;
}

/**
 *      
 * @return
 */
function initTable()
{
	$("clockmode").innerText = RESOURCE["clockretimemode"];
	$("clockmodespan_sys").innerText = RESOURCE["clockmoderadio_sys"];
	$("clockmodespan_line").innerText = RESOURCE["clockmoderadio_line"];
	$("clockport").innerText = RESOURCE["lineclockport"];

	mtable = new MTable();
	mtable.addHead(RESOURCE["clocksource"], RESOURCE["port"], RESOURCE["timeslot"]);
	
	/*        Clock5 */
	var atom5_Port = new Atom("select");
	for( i = 0; i < 4; i++ )
	{
		var index = i+1;
		atom5_Port.element.options[atom5_Port.element.options.length] = new Option(index+"(Port-"+index+")", index);
	}
	atom5_Port.element.options[atom5_Port.element.options.length] = new Option("-", VALID_VALUE);

	var atom5_VC12 = new Atom("select");
	for( var i = 1; i < 64; i++ )
	{
		atom5_VC12.addOption("VC12-"+i, i);
	}
	atom5_VC12.element.options[atom5_VC12.element.options.length] = new Option("-", INVALID_SUBSLOTID);
	
	var resource1 = RESOURCE["clocksource5"];
	if (filetypeList != null && filetypeList.length > 0)
	{
		resource1 = RESOURCE["clocksource" + filetypeList[0]];
	}
	mtable.addAttrRow("clocksource5", resource1, atom5_Port, atom5_VC12);
	/*        Clock5 */
	
	
	
	/*        Clock6 */
	var atom6_Port = new Atom("select");
	for( i = 0; i < 4; i++ )
	{
		var index = i+1;
		atom6_Port.element.options[atom6_Port.element.options.length] = new Option(index+"(Port-"+index+")", index);
	}
	atom6_Port.element.options[atom6_Port.element.options.length] = new Option("-", VALID_VALUE);

	var atom6_VC12 = new Atom("select");
	for( var i = 1; i < 64; i++ )
	{
		atom6_VC12.addOption("VC12-"+i, i);
	}
	atom6_VC12.element.options[atom6_VC12.element.options.length] = new Option("-", INVALID_SUBSLOTID);
	
	var resource2 = RESOURCE["clocksource6"];
	if (filetypeList != null && filetypeList.length > 1)
	{
		resource2 = RESOURCE["clocksource" + filetypeList[1]];
	}
	mtable.addAttrRow("clocksource6", resource2, atom6_Port, atom6_VC12);
	/*        Clock6 */

	$("tablecontainer3").appendChild(mtable.getTable());

	$("querybtn").value = RESOURCE["querybutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_ETH_GET_CLOCKTRANSINFOR);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_ETH_SET_CLOCKTRANSINFOR);
    getRightInfo(winurlobj, btnRightArr);
	
	addListeners();
}

function queryClockTransInfor()
{
	LoadingProcess.removeWaitStatus();
	LoadingProcess.showWaitStatus("../../../../images/",RESOURCE["loadingtitle"]);
	
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_ETH_GET_CLOCKTRANSINFOR + "&nmUser="+ nmUser;

	var xmlstr = createQueryClockTransInforXML();
	initWarningFlag();
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;	
	loadXMLdoc(urlreq, "POST", true, queryClockTransInforCallback, null, "inputdata=" + xmlstr);	
}

/**
 *     XML
 * @return
 */
function createQueryClockTransInforXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null; 

    row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
    addParam(row, "clocksource", CLOCK_PORT1 );
    bussiness.appendChild(row);

    row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
    addParam(row, "clocksource", CLOCK_PORT2 );
    bussiness.appendChild(row);
    
    di.getRoot().appendChild(bussiness);

    return di.toString();
}

/**
 *           
 * @param doc
 * @return
 */
function queryClockTransInforCallback(doc)
{
	LoadingProcess.removeWaitStatus();
	
	var data = EncapsulateData(doc);
	
	$("querybtn").disabled = false;
	
    if( data.getSErrorCode() != OPERATION_SUCCESS )
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", data.getError(), errArr);
    }
    
	$("applybtn").disabled = true;
    
    if( data.getSErrorCode() != OPERATION_SUCCESS && data.getSErrorCode() != OPERATION_PART_SUCCESS )
    {
    	return;
    }
	if (data.getDataRowLength() >= 2) 
	{
		for (var i = 1; i >= 0; i--) 
		{
			if (i == 0 ) 
			{
				var t_slotid = data.getDataRowParam(i, "slotid");
				var t_clockmode = data.getDataRowParam(i, "clockmode");
				var t_port = data.getDataRowParam(i, "port");
				
				if (t_clockmode == CLOCKMODE_SYS) 
				{
					$("clockmoderadio_sys").checked = true;
					$("clockportselect").value = "1";
					$("clockportselect").disabled = true;
				}
				else if (t_clockmode == CLOCKMODE_LINE) 
				{
					$("clockmoderadio_line").checked = true;
					$("clockportselect").value = t_port;
					$("clockportselect").disabled = false;
				}
			}
			
			var t_clocksource = data.getDataRowParam(i, "clocksource");
			var t_sdhport = data.getDataRowParam(i, "sdhport");
			var t_lowpath = data.getDataRowParam(i, "lowpath");
			
			if (t_clocksource == CLOCK_PORT1) 
			{
				mtable.getAtom("clocksource5", 0).setValue(t_sdhport);
				mtable.getAtom("clocksource5", 1).setValue(t_lowpath);
			}
			if (t_clocksource == CLOCK_PORT2) 
			{
				mtable.getAtom("clocksource6", 0).setValue(t_sdhport);
				mtable.getAtom("clocksource6", 1).setValue(t_lowpath);
			}
			data.removeDataRowAt(i);
		}
	}
}

/**
 *       
 * @return
 */
function applyClockTransInfor()
{
	if(warningflag == true)
	{
		if (!confirm(RESOURCE["confmsg"])) 
	    {
	        return;
	    }
	}
	
	LoadingProcess.removeWaitStatus();
	LoadingProcess.showWaitStatus("../../../../images/",RESOURCE["loadingtitle"]);
	
	var urlreq = "../../../../neExlorerServlet?sfid=" + TECMDCODE_ETH_SET_CLOCKTRANSINFOR + "&nmUser="+ nmUser;

	var xmlstr = createApplyClockTransInforXML();
	
	$("querybtn").disabled = true;
	$("applybtn").disabled = true;
	
	loadXMLdoc(urlreq, "POST", true, applyClockTransInforCallback, null, "inputdata=" + xmlstr);	
}

/**
 *             XML
 * @param {Object} bussiness
 */
function appendApplySourceCfgXML(bussiness)
{
	var row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
    addParam(row, "clocksource", CLOCK_PORT1 );
    addParam(row, "sdhport", mtable.getAtom("clocksource5", 0).getValue() );
    addParam(row, "highpath",  mtable.getAtom("clocksource5", 0).getValue() == VALID_VALUE ? VALID_VALUE : "1" );
    addParam(row, "lowpath", mtable.getAtom("clocksource5", 1).getValue() );
    bussiness.appendChild(row);
	
    row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
    addParam(row, "clocksource", CLOCK_PORT2 );
    addParam(row, "sdhport", mtable.getAtom("clocksource6", 0).getValue() );
    addParam(row, "highpath", mtable.getAtom("clocksource6", 0).getValue() == VALID_VALUE ? VALID_VALUE : "1"  );
    addParam(row, "lowpath", mtable.getAtom("clocksource6", 1).getValue() );
	bussiness.appendChild(row);
}

/**
 *        XML
 * @return
 */
function createApplyClockTransInforXML()
{	
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = null; 

    row = new tagElement("row-params");
    addParam(row, "neid", neid );
    addParam(row, "slotid", slotid );
	var t_clockmodeValue = $("clockmoderadio_sys").checked == true ? CLOCKMODE_SYS : CLOCKMODE_LINE;
	var t_portValue = $("clockmoderadio_sys").checked == true ? VALID_VALUE : $("clockportselect").value;
	addParam(row, "clockmode", t_clockmodeValue);
	addParam(row, "port", t_portValue);
	bussiness.appendChild(row);

	appendApplySourceCfgXML(bussiness);

    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *            
 * @param doc
 * @return
 */
function applyClockTransInforCallback(doc)
{
	LoadingProcess.removeWaitStatus();

	var data = EncapsulateData(doc);
	
	$("querybtn").disabled = false;

    if( data.getSErrorCode() != OPERATION_SUCCESS )
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../page/", data.getError(), errArr);
    }
    else
    {
    	initWarningFlag();
    }
	$("applybtn").disabled = true;
}

/**
 *     
 * @param row
 * @param attriName
 * @param attriVal
 * @return
 */
function addParam(row, attriName, attriVal)
{
    var param = new tagElement("param");
    param.setAttribute("name", attriName);
    param.setAttribute("value", attriVal );
    row.appendChild(param);
}

/**
 *     
 * @return
 */
var lastIndex = 0;
function addListeners()
{
	$("clockmoderadio_sys").onclick = function()
	{
		$("clockportselect").disabled = true;
		lastIndex = $("clockportselect").selectedIndex;
		$("clockportselect").selectedIndex = 0;
		if (btnRightArr.applybtn.right)
		{
			warningflag = true;
			$("applybtn").disabled = false;
		}
	}
	$("clockmoderadio_line").onclick = function()
	{
		$("clockportselect").disabled = false;
		$("clockportselect").selectedIndex = lastIndex;
		if (btnRightArr.applybtn.right)
		{
			warningflag = true;
			$("applybtn").disabled = false;
		}
	}

	$("clockportselect").onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			warningflag = true;
			$("applybtn").disabled = false;
		}
	}

	
	mtable.getAtom("clocksource5",0).element.onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			$("applybtn").disabled = false;
		}
		
		if( mtable.getAtom("clocksource5", 0).getValue() == VALID_VALUE )
		{
			mtable.getAtom("clocksource5", 1).setValue(INVALID_SUBSLOTID);
		}
		else
		{
			if( mtable.getAtom("clocksource5", 1).getValue() == INVALID_SUBSLOTID )
			{
				mtable.getAtom("clocksource5", 1).setValue("1");	
			}
		}
	}
	
	mtable.getAtom("clocksource5",1).element.onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			$("applybtn").disabled = false;
		}
		
		if( mtable.getAtom("clocksource5", 1).getValue() == INVALID_SUBSLOTID )
		{
			mtable.getAtom("clocksource5", 0).setValue(VALID_VALUE);
		}
		else
		{
			if( mtable.getAtom("clocksource5", 0).getValue() == VALID_VALUE )
			{
				mtable.getAtom("clocksource5", 0).setValue("1");	
			}
		}
	}
	
	mtable.getAtom("clocksource6",0).element.onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			$("applybtn").disabled = false;
		}
		
		if( mtable.getAtom("clocksource6", 0).getValue() == VALID_VALUE )
		{
			mtable.getAtom("clocksource6", 1).setValue(INVALID_SUBSLOTID);
		}
		else
		{
			if( mtable.getAtom("clocksource6", 1).getValue() == INVALID_SUBSLOTID )
			{
				mtable.getAtom("clocksource6", 1).setValue("1");	
			}
		}
	}
	
	mtable.getAtom("clocksource6",1).element.onchange = function()
	{
		if (btnRightArr.applybtn.right)
		{
			$("applybtn").disabled = false;
		}
		
		if( mtable.getAtom("clocksource6", 1).getValue() == INVALID_SUBSLOTID )
		{
			mtable.getAtom("clocksource6", 0).setValue(VALID_VALUE);
		}
		else
		{
			if( mtable.getAtom("clocksource6", 0).getValue() == VALID_VALUE )
			{
				mtable.getAtom("clocksource6", 0).setValue("1");	
			}
		}
	}
}

/**
 *              
 * @return
 */
function getPorts()
{
    var xmlstr = createGetPortsXML();
    var urlreq ="../../../../neExlorerServlet?sfid="+TECMDCODE_NF_PTN_CES_GET_AVAILPORTTS+"&nmUser="+winurlobj["nmUser"];

    loadXMLdoc(urlreq, "POST", false, getPortsCallback, null, "inputdata="+xmlstr);
}

function createGetPortsXML()
{    
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","subslotid");
    param.setAttribute("value",INVALID_SUBSLOTID);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function getPortsCallback(doc)
{
    var data = EncapsulateData(doc);

    if (OPERATION_SUCCESS == data.getSErrorCode()) 
    {
    	$("clockportselect").options.length = 0;
		var portsource5 = mtable.getAtom("clocksource5", 0).element;
		var portsource6 = mtable.getAtom("clocksource6", 0).element;
		portsource5.options.length = 0;
		portsource6.options.length = 0;
        var t_slotid;
        var t_portid;
        var t_portName;
        for(var i = 0, len = data.getDataRowLength(); i < len; i ++)
		{
        	t_slotid = data.getDataRowParam(i ,"slotid" );
		    if( t_slotid != slotid )
		    {
		        continue;
		    }
		    t_portid = data.getDataRowParam(i , "portid");
		    t_portName = data.getDataRowParam(i , "portName");
		    $("clockportselect").options[$("clockportselect").options.length] = new Option(t_portName, t_portid);
			portsource5.options[i]= new Option(t_portName, t_portid);
			portsource6.options[i]= new Option(t_portName, t_portid);
		}
        portsource5.options[portsource5.options.length] = new Option("-", VALID_VALUE);
		portsource6.options[portsource6.options.length] = new Option("-", VALID_VALUE);
    }
}

/**
 *     
 * @param {Object} value
 */
function convertLowpath(value)
{
	return "VC12-" + value;
}

/**
 *     
 * @param {Object} value
 */
function convertClockMode(value)
{
	if(value == "0")
	{
		return RESOURCE["clockmoderadio_sys"];
	}
	else
	{
		return RESOURCE["clockmoderadio_slave"];
	}
}
