/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic_u2kv1r2c00;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEXpicQueryAttrBean
extends TENEExplorerBean {
    private int oduSlotGap = 20;
    private static final int E1CAP_INVALID = 255;
    private static final String ENABLE = "1";

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList operList = super.getOperation(neid, subFunc, inputData, memeryData);
        int slotId = 0;
        Operation oper = null;
        int neType = TENEListMgr.getInstance().getNE(neid).getNEType();
        int confValue = TESpecialAttrMgr.getInstance().getNEAttrIntValue(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_RELATIVE_ODUSLOT_OFFSET");
        if (confValue != -1) {
            this.oduSlotGap = confValue;
        }
        if (neType == 83) {
            this.oduSlotGap = 50;
        }
        int m = operList.size();
        for (int i = 0; i < m; ++i) {
            oper = (Operation)operList.get(i);
            if (!"NSCMD_CFG_GET_ODU_SRSL".equalsIgnoreCase(oper.getName()) && !"NSCMD_CFG_GET_ODU_RPOWER".equalsIgnoreCase(oper.getName())) continue;
            slotId = Integer.valueOf(oper.getInput().getPartValue("slotid"));
            oper.getInput().getPart("slotid").setValue(String.valueOf(slotId + this.oduSlotGap));
        }
        return operList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.addPreFilterProcess(operationList);
        this.handleMessage(neid, operationList, subfunc, subfunc.getFilterErrCodeList());
    }

    private void addPreFilterProcess(List<Operation> operationList) {
        int slotId = 0;
        int srPower = 0;
        Operation operation = null;
        String amStatus = this.getParamValueInOper(operationList, "NSCMD_CFG_GET_AM_PARAM", "amstate");
        int m = operationList.size();
        for (int i = 0; i < m; ++i) {
            int errCode;
            short value;
            operation = operationList.get(i);
            if ("NSCMD_CFG_GET_ODU_SRSL".equalsIgnoreCase(operation.getName())) {
                slotId = Integer.valueOf(operation.getInput().getPartValue("slotid"));
                operation.getInput().getPart("slotid").setValue(String.valueOf(slotId - this.oduSlotGap));
                operation.getOutput(0).getPart("slotid").setValue(String.valueOf(slotId - this.oduSlotGap));
                if (!operation.getOutput(0).getFault(0).getCode().equals("0")) continue;
                srPower = new BigInteger(operation.getOutput(0).getPartValue("W32BRD_ATTR_RECEIVEPOWER")).intValue();
                value = (short)srPower;
                operation.getOutput(0).getPart("W32BRD_ATTR_RECEIVEPOWER").setValue(Float.toString((float)value / 10.0f));
                continue;
            }
            if ("NSCMD_CFG_GET_ODU_RPOWER".equalsIgnoreCase(operation.getName())) {
                slotId = Integer.valueOf(operation.getInput().getPartValue("slotid"));
                operation.getInput().getPart("slotid").setValue(String.valueOf(slotId - this.oduSlotGap));
                operation.getOutput(0).getPart("slotid").setValue(String.valueOf(slotId - this.oduSlotGap));
                if (!operation.getOutput(0).getFault(0).getCode().equals("0")) continue;
                srPower = new BigInteger(operation.getOutput(0).getPartValue("W32BRD_ATTR_ACTRECEIVEPOWER")).intValue();
                value = (short)srPower;
                operation.getOutput(0).getPart("W32BRD_ATTR_ACTRECEIVEPOWER").setValue(Float.toString((float)value / 10.0f));
                continue;
            }
            if (!"NSCMD_RTN_CFG_GET_EVERYMOD_E1NUM".equals(operation.getName()) || 0 != (errCode = Integer.valueOf(operation.getOutput(0).getFault(0).getCode()).intValue())) continue;
            Output output = null;
            for (int j = operation.getOutputCount() - 1; j >= 0; --j) {
                output = operation.getOutput(j);
                int e1Cap = Integer.valueOf(output.getPartValue("e1cap"));
                if (255 != e1Cap) continue;
                operation.removeOutput(j);
            }
            output = (Output)operation.getOutput(0).clone();
            Output fullOutput = null;
            int outputCount = operation.getOutputCount();
            if (ENABLE.equals(amStatus)) {
                fullOutput = (Output)operation.getOutput(outputCount - 1).clone();
            } else {
                fullOutput = (Output)output.clone();
                fullOutput.getPart("e1cap").setValue(String.valueOf(255));
            }
            output.getPart("e1cap").setName("guaranteenum");
            fullOutput.getPart("e1cap").setName("fullnum");
            operation.clearOutput();
            operation.addOutput(output);
            operation.addOutput(fullOutput);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        ArrayList errorCodeList = this.getFilterErrorCodeList();
        filterErrorCodeList.addAll(errorCodeList);
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        this.refactor();
    }

    private void refactor() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        StringBuilder sb = new StringBuilder("");
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            String boardName = board.getBoardTypeName();
            if (boardType != 2080 && boardType != 2267 && !TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_XPICFILTER_NEEDPROCESSNAME")) continue;
            sb.append(slotId).append("-").append(boardName).append("-").append(ENABLE).append(";");
        }
        RowParams rowParams = null;
        if (sb.length() == 0) {
            return;
        }
        String bdRes = sb.substring(0, sb.length() - 1);
        int len2 = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len2; ++i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getRowErrorsCount() > 0) continue;
            rowParams.addParam("bdRes", bdRes);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(42752);
        list.add(37898);
        list.add(38737);
        list.add(1091634631);
        list.add(1090777617);
        return list;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private String getParamValueInOper(List<Operation> opers, String operName, String param) {
        String res = null;
        int len = opers.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = opers.get(i);
            if (!operName.equals(oper.getName())) continue;
            Output output = oper.getOutput(0);
            res = output.getPartValue(param);
        }
        return res;
    }
}

