/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic_u2kv1r2c00;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.rtn.xpic_u2kv1r2c00.TEAvailableRes;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetAvailableResWithE1
extends TENEExplorerBean {
    List<TEAvailableRes> availableResList = new ArrayList<TEAvailableRes>();

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        this.availableResList.clear();
        List<TEAvailableRes> res = this.getAllResource(neid);
        BussinessParams bps = inputData.getBussinessParams();
        int len = res.size();
        for (int i = 0; i < len; ++i) {
            RowParams vRowParams = new RowParams();
            vRowParams.addParam("neid", String.valueOf(neid));
            vRowParams.addParam("slotid", String.valueOf(res.get(i).getSlotID()));
            vRowParams.addParam("port", "1");
            bps.addRowParams(vRowParams);
        }
        return super.getOperation(neid, subFunc, inputData, memeryData);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.processAfterSendMessage(neid, operationList, subfunc);
        this.outputData = this.constructRtnData(this.availableResList);
    }

    private void processAfterSendMessage(int neid, List<Operation> operationList, SubFunc subfunc) {
        for (Operation oper : operationList) {
            Output[] outs;
            int slotid;
            Output out;
            TEAvailableRes res = null;
            if ("NSCMD_PTN_CFG_GET_IF_CHANNELSPACE".equals(oper.getName()) && (out = oper.getOutput(0)).getFault(0).getCode().equals("0")) {
                slotid = Integer.valueOf(out.getPartValue("slotid"));
                int bandwidth = Integer.valueOf(out.getPartValue("W32PORT_ATTR_CHANNELSPACE"));
                res = this.getRes(neid, slotid);
                if (null != res) {
                    res.setBandwidth(bandwidth);
                }
            }
            if ("NSCMD_PTN_CFG_GET_ACM_PARAM".equals(oper.getName()) && (out = oper.getOutput(0)).getFault(0).getCode().equals("0")) {
                slotid = Integer.valueOf(out.getPartValue("slotid"));
                int W32PORT_ATTR_ENSURECALMODE = Integer.valueOf(out.getPartValue("W32PORT_ATTR_ENSURECALMODE"));
                int W32PORT_ATTR_ALLCALMODE = Integer.valueOf(out.getPartValue("W32PORT_ATTR_ALLCALMODE"));
                int W32PORT_ATTR_MANUALMODE = Integer.valueOf(out.getPartValue("W32PORT_ATTR_MANUALMODE"));
                res = this.getRes(neid, slotid);
                if (null != res) {
                    res.setGucalmode(W32PORT_ATTR_ENSURECALMODE);
                    res.setFullcalmode(W32PORT_ATTR_ALLCALMODE);
                    res.setManucalmode(W32PORT_ATTR_MANUALMODE);
                }
            }
            if ("NSCMD_CFG_GET_HYBRID_CAPACITY_FORXPIC".equals(oper.getName()) && (out = oper.getOutput(0)).getFault(0).getCode().equals("0")) {
                slotid = Integer.valueOf(out.getPartValue("slotid"));
                int hybridnum = Integer.valueOf(out.getPartValue("hybridnum"));
                res = this.getRes(neid, slotid);
                if (null != res) {
                    res.setCure1num(hybridnum);
                }
            }
            if (!"NSCMD_RTN_CFG_GET_ALL_MAX_E1NUM_WITH_XPIC".equals(oper.getName()) || null == (outs = oper.getOutput())) continue;
            int len = outs.length;
            for (int i = 0; i < len; ++i) {
                Output out2 = outs[i];
                if (!out2.getFault(0).getCode().equals("0")) continue;
                int slotid2 = Integer.valueOf(out2.getPartValue("slotid"));
                int bandwidth_xpic = Integer.valueOf(out2.getPartValue("bandwidth_xpic"));
                int calmode_xpic = Integer.valueOf(out2.getPartValue("calmode_xpic"));
                int e1capacity_xpic = Integer.valueOf(out2.getPartValue("e1capacity_xpic"));
                res = this.getRes(neid, slotid2, bandwidth_xpic, calmode_xpic);
                if (null == res) continue;
                res.setMaxe1num(e1capacity_xpic);
            }
        }
    }

    private TEAvailableRes getRes(int neid, int slotid) {
        for (TEAvailableRes res : this.availableResList) {
            if (neid != res.getNeid() || slotid != res.getSlotID()) continue;
            return res;
        }
        return null;
    }

    private TEAvailableRes getRes(int neid, int slotid, int bandwidth, int calmode) {
        for (TEAvailableRes res : this.availableResList) {
            if (neid != res.getNeid() || slotid != res.getSlotID() || bandwidth != res.getBandwidth() || calmode != res.getGucalmode() && calmode != res.getManucalmode()) continue;
            return res;
        }
        return null;
    }

    private List<TEAvailableRes> getAllResource(int neid) {
        this.availableResList.clear();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEAvailableRes availableRes = null;
            TEBoard board = (TEBoard)boardList.get(i);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            String boardName = board.getBoardTypeName();
            if (1175 == boardType || 2080 == boardType || 2267 == boardType || 2475 == boardType || 2468 == boardType || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_SUPPORT_XPIC")) {
                availableRes = new TEAvailableRes(neid, slotId, boardType, boardName);
            }
            if (null == availableRes) continue;
            this.availableResList.add(availableRes);
        }
        return this.availableResList;
    }

    private Datainterface constructRtnData(List<TEAvailableRes> availableResList) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        Datainterface datainterface = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        int size = availableResList.size();
        for (int i = 0; i < size; ++i) {
            TEAvailableRes res = availableResList.get(i);
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("neId", String.valueOf(res.getNeid()));
            rParams.addParam(param);
            param = new Param("neName", mgr.getNE(res.getNeid()).getNEName());
            rParams.addParam(param);
            param = new Param("slotId", String.valueOf(res.getSlotID()));
            rParams.addParam(param);
            param = new Param("boardType", String.valueOf(res.getBoardType()));
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            if (-1 != res.getMaxe1num()) {
                param = new Param("curE1Num", String.valueOf(res.getCure1num()));
                rParams.addParam(param);
                param = new Param("maxE1Num", String.valueOf(res.getMaxe1num()));
                rParams.addParam(param);
            }
            bParams.addRowParams(rParams);
        }
        datainterface.setBussinessParams(bParams);
        datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return datainterface;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

