/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic_u2kv1r2c00;

import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.rtn.xpic_u2kv1r2c00.TEAvailableRes;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class TEGetAvailableRes
implements TENEMgrInterface {
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
    private TENEListMgr neListMgr = TENEListMgr.getInstance();
    private ArrayList availableResList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        return this.getAllResource(neid);
    }

    private Datainterface getAllResource(int neid) {
        TENE ne = this.neListMgr.getNE(neid);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEAvailableRes availableRes = null;
            TEBoard board = (TEBoard)boardList.get(i);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            String boardName = board.getBoardTypeName();
            if (1175 == boardType || 2080 == boardType || 2267 == boardType || 2475 == boardType || 2468 == boardType || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_BOARD_SUPPORT_XPIC")) {
                availableRes = new TEAvailableRes(neid, slotId, boardType, boardName);
            }
            if (null == availableRes) continue;
            this.availableResList.add(availableRes);
        }
        return this.constructRtnData();
    }

    private Datainterface constructRtnData() {
        Datainterface datainterface = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        int size = this.availableResList.size();
        for (int i = 0; i < size; ++i) {
            TEAvailableRes res = (TEAvailableRes)this.availableResList.get(i);
            RowParams rParams = new RowParams();
            Param param = null;
            param = new Param("neId", new Integer(res.getNeid()).toString());
            rParams.addParam(param);
            param = new Param("neName", this.mgr.getNE(res.getNeid()).getNEName());
            rParams.addParam(param);
            param = new Param("slotId", new Integer(res.getSlotID()).toString());
            rParams.addParam(param);
            param = new Param("boardType", new Integer(res.getBoardType()).toString());
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            bParams.addRowParams(rParams);
        }
        datainterface.setBussinessParams(bParams);
        datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return datainterface;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

