/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic_u2kv1r2c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEAddXPIC
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "rtn" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "xpic" + File.separator + "xpicres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static final int TIME_OUT = 60;

    public int sendMessage(int neid) {
        OperationResult result;
        int retCode = 0;
        int setBandwidthCode = this.setBandwidth(this.inputData);
        if (0 != setBandwidthCode) {
            return setBandwidthCode;
        }
        ArrayList<Operation> firstOperationList_rtn = new ArrayList<Operation>();
        firstOperationList_rtn.addAll(this.operationList.subList(0, 2));
        if (!this.isRTN600(neid)) {
            this.filterVertifyCommand(firstOperationList_rtn);
        }
        if (null != (result = TECommuNEMgr.getInstance().sendCommand(neid, firstOperationList_rtn, this.getTimeOut(), this.subfunc))) {
            retCode = result.retCode;
        }
        if (0 != retCode) {
            return retCode;
        }
        Operation rtnoperation = firstOperationList_rtn.get(0);
        Output output = rtnoperation.getOutput(0);
        int faultCode1 = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode1 == 0) {
            Operation temp;
            int faultCode2;
            if (this.isRTN600(neid) && (faultCode2 = Integer.parseInt((output = (rtnoperation = firstOperationList_rtn.get(1)).getOutput(0)).getFault(0).getCode())) != 0) {
                return faultCode2;
            }
            ArrayList<Operation> tmpOperationList = new ArrayList<Operation>();
            tmpOperationList.addAll(this.operationList.subList(2, this.operationList.size()));
            Operation operation1_rtn = null;
            Operation operation2_rtn = null;
            operation1_rtn = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_RADIO_LINKID");
            operation2_rtn = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_RADIO_LINKID");
            String hPolarBdid = this.inputData.getBussinessParams().getRowParams(0).getParam("hPolarBdid").getValue();
            String hPolarPortid = "1";
            String vPolarBdid = this.inputData.getBussinessParams().getRowParams(0).getParam("vPolarBdid").getValue();
            String vPolarPortid = "1";
            String W32PORT_ATTR_RADIOLINKIDh = this.inputData.getBussinessParams().getRowParams(0).getParam("W32PORT_ATTR_RADIOLINKIDh").getValue();
            operation1_rtn.getInput().getPart("slotid").setValue(hPolarBdid);
            operation1_rtn.getInput().getPart("port").setValue(hPolarPortid);
            operation1_rtn.getInput().getPart("W32PORT_ATTR_RADIOLINKID").setValue(W32PORT_ATTR_RADIOLINKIDh);
            String W32PORT_ATTR_RADIOLINKIDv = this.inputData.getBussinessParams().getRowParams(0).getParam("W32PORT_ATTR_RADIOLINKIDv").getValue();
            operation2_rtn.getInput().getPart("slotid").setValue(vPolarBdid);
            operation2_rtn.getInput().getPart("port").setValue(vPolarPortid);
            operation2_rtn.getInput().getPart("W32PORT_ATTR_RADIOLINKID").setValue(W32PORT_ATTR_RADIOLINKIDv);
            Operation verify = null;
            if (!tmpOperationList.isEmpty() && (temp = (Operation)tmpOperationList.get(tmpOperationList.size() - 1)).getName().equalsIgnoreCase("NSCMD_CFG_VERIFY")) {
                verify = tmpOperationList.remove(tmpOperationList.size() - 1);
            }
            tmpOperationList.add(operation1_rtn);
            tmpOperationList.add(operation2_rtn);
            if (verify != null) {
                tmpOperationList.add(verify);
            }
            if (!this.isRTN600(neid)) {
                this.filterVertifyCommand(tmpOperationList);
            }
            if (null != (result = TECommuNEMgr.getInstance().sendCommand(neid, tmpOperationList, this.getTimeOut(), this.subfunc))) {
                retCode = result.retCode;
            }
        } else if (faultCode1 != 0) {
            retCode = faultCode1;
        }
        return retCode;
    }

    private int setBandwidth(Datainterface inputData) {
        int guE1Num_v;
        int guE1Num_h;
        int retCode = 0;
        ArrayList<Operation> opers = new ArrayList<Operation>();
        RowParams rowParams = null;
        rowParams = inputData.getBussinessParams().getRowParams(0);
        int hPolarBdid = rowParams.getParam("hPolarBdid") == null ? -1 : Integer.parseInt(rowParams.getParam("hPolarBdid").getValue());
        int vPolarBdid = rowParams.getParam("vPolarBdid") == null ? -1 : Integer.parseInt(rowParams.getParam("vPolarBdid").getValue());
        int bandwidth = rowParams.getParam("bandWidth") == null ? -1 : Integer.parseInt(rowParams.getParam("bandWidth").getValue());
        String PolarPortid = "1";
        int n = guE1Num_h = rowParams.getParam("hPolarBdGue1num") == null || rowParams.getParam("hPolarBdGue1num").getValue() == null || rowParams.getParam("hPolarBdGue1num").getValue().isEmpty() ? -1 : Integer.parseInt(rowParams.getParam("hPolarBdGue1num").getValue());
        if (-1 != guE1Num_h && -1 != hPolarBdid) {
            Operation operation_h = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_HYBRID_CAPACITY_FORXPIC");
            operation_h.getInput().getPart("slotid").setValue(String.valueOf(hPolarBdid));
            operation_h.getInput().getPart("port").setValue(PolarPortid);
            operation_h.getInput().getPart("hybridnum").setValue(String.valueOf(guE1Num_h));
            opers.add(operation_h);
        }
        int n2 = guE1Num_v = rowParams.getParam("vPolarBdGue1num") == null ? -1 : Integer.parseInt(rowParams.getParam("vPolarBdGue1num").getValue());
        if (-1 != guE1Num_v && -1 != vPolarBdid) {
            Operation operation_v = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_HYBRID_CAPACITY_FORXPIC");
            operation_v.getInput().getPart("slotid").setValue(String.valueOf(vPolarBdid));
            operation_v.getInput().getPart("port").setValue(PolarPortid);
            operation_v.getInput().getPart("hybridnum").setValue(String.valueOf(guE1Num_v));
            opers.add(operation_v);
        }
        if (-1 != bandwidth && -1 != hPolarBdid && -1 != vPolarBdid) {
            Operation bandwidth_h = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_CFG_SET_IF_CHANNELSPACE");
            bandwidth_h.getInput().getPart("slotid").setValue(String.valueOf(hPolarBdid));
            bandwidth_h.getInput().getPart("port").setValue(PolarPortid);
            bandwidth_h.getInput().getPart("W32PORT_ATTR_CHANNELSPACE").setValue(String.valueOf(bandwidth));
            opers.add(bandwidth_h);
            Operation bandwidth_v = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PTN_CFG_SET_IF_CHANNELSPACE");
            bandwidth_v.getInput().getPart("slotid").setValue(String.valueOf(vPolarBdid));
            bandwidth_v.getInput().getPart("port").setValue(PolarPortid);
            bandwidth_v.getInput().getPart("W32PORT_ATTR_CHANNELSPACE").setValue(String.valueOf(bandwidth));
            opers.add(bandwidth_v);
        }
        if (!opers.isEmpty()) {
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neid, opers, this.getTimeOut(), this.subfunc);
            if (result.retCode == 0) {
                for (Operation oper : opers) {
                    Output output;
                    if (!"NSCMD_PTN_CFG_SET_IF_CHANNELSPACE".equals(oper.getName()) || oper.getOutputCount() <= 0 || (output = oper.getOutput(0)).getFault(0) == null) continue;
                    retCode = Integer.parseInt(output.getFault(0).getCode());
                    break;
                }
                return retCode;
            }
            return result.retCode;
        }
        return 0;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeAllLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        String des = "";
        RowParams rowParams = null;
        rowParams = this.inputData.getBussinessParams().getRowParams(0);
        int hPolarBdid = rowParams.getParam("hPolarBdid") == null ? -1 : Integer.parseInt(rowParams.getParam("hPolarBdid").getValue());
        int vPolarBdid = rowParams.getParam("vPolarBdid") == null ? -1 : Integer.parseInt(rowParams.getParam("vPolarBdid").getValue());
        int bandwidth = rowParams.getParam("bandwidth") == null ? -1 : Integer.parseInt(rowParams.getParam("bandwidth").getValue());
        long transmitFrequency = rowParams.getParam("transmitFrequency") == null ? -1L : Long.valueOf(rowParams.getParam("transmitFrequency").getValue());
        long trInterval = rowParams.getParam("trInterval") == null ? -1L : Long.valueOf(rowParams.getParam("trInterval").getValue());
        int transmitPower = rowParams.getParam("transmitPower") == null ? -1 : Integer.parseInt(rowParams.getParam("transmitPower").getValue());
        int maxTransmitPower = rowParams.getParam("maxTransmitPower") == null ? -1 : Integer.parseInt(rowParams.getParam("maxTransmitPower").getValue());
        int workStatus = rowParams.getParam("workStatus") == null ? -1 : Integer.parseInt(rowParams.getParam("workStatus").getValue());
        int atpcEnableStatus = rowParams.getParam("atpcEnableStatus") == null ? -1 : Integer.parseInt(rowParams.getParam("atpcEnableStatus").getValue());
        int atpcAutoEnable = rowParams.getParam("atpcAutoEnable") == null ? -1 : Integer.parseInt(rowParams.getParam("atpcAutoEnable").getValue());
        des = this.resourceUtil.getString("bandwidth") + ":" + this.resourceUtil.getString("bandwidth" + bandwidth) + ";" + this.resourceUtil.getString("pDH") + ":";
        des = des + hPolarBdid + "-" + this.getBoardName(hPolarBdid) + ";";
        des = des + this.resourceUtil.getString("pDV") + ":" + vPolarBdid + "-" + this.getBoardName(vPolarBdid) + ";";
        des = des + this.resourceUtil.getString("transmitPower") + ":" + String.valueOf(transmitPower / 10) + "dBm;";
        des = des + this.resourceUtil.getString("maxTransmitPower") + ":" + String.valueOf(maxTransmitPower / 10) + "dBm;";
        des = des + this.resourceUtil.getString("transmitFrequency") + ":" + String.valueOf(transmitFrequency / 1000L) + "MHz;";
        des = des + this.resourceUtil.getString("trInterval") + ":" + String.valueOf(trInterval / 1000L) + "MHz;";
        if (0 == workStatus) {
            des = des + this.resourceUtil.getString("workStatus") + ":" + this.resourceUtil.getString("sleep") + ";";
        } else if (1 == workStatus) {
            des = des + this.resourceUtil.getString("workStatus") + ":" + this.resourceUtil.getString("shoot") + ";";
        }
        if (0 == atpcEnableStatus) {
            des = des + this.resourceUtil.getString("atpcEnableStatus") + ":" + this.resourceUtil.getString("disable") + ";";
        } else if (1 == atpcEnableStatus) {
            des = des + this.resourceUtil.getString("atpcEnableStatus") + ":" + this.resourceUtil.getString("enable") + ";";
        }
        if (1 == atpcEnableStatus) {
            double atpcUpperThreshold = rowParams.getParam("atpcUpperThreshold") == null ? -1.0 : Double.valueOf(rowParams.getParam("atpcUpperThreshold").getValue());
            double atpcLowerThreshold = rowParams.getParam("atpcLowerThreshold") == null ? -1.0 : Double.valueOf(rowParams.getParam("atpcLowerThreshold").getValue());
            des = des + this.resourceUtil.getString("atpcUpperThreshold") + ":" + String.valueOf(atpcUpperThreshold / 10.0) + "dBm;";
            des = des + this.resourceUtil.getString("atpcLowerThreshold") + ":" + String.valueOf(atpcLowerThreshold / 10.0) + "dBm;";
        }
        if (0 == atpcAutoEnable) {
            des = des + this.resourceUtil.getString("atpcAutoEnable") + ":" + this.resourceUtil.getString("disable");
        } else if (1 == atpcEnableStatus) {
            des = des + this.resourceUtil.getString("atpcAutoEnable") + ":" + this.resourceUtil.getString("enable");
        }
        return des;
    }

    private String getBoardName(int slotid) {
        TEBoard board_rtn5 = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        if (board_rtn5 == null) {
            return "";
        }
        int boardtype = board_rtn5.getBoardType();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        return boardname;
    }

    public void distinctErrorCodeItemFilter(Datainterface output) {
        int Paramscount = output.getBussinessParams().getRowParamsCount();
        RowParams rowParams_rtn5 = output.getBussinessParams().getRowParams()[Paramscount - 1];
        RowErrors[] rowErrors = rowParams_rtn5.getRowErrors();
        int len = rowErrors.length;
        RowErrors tmp_rowerrors = null;
        RowErrors tmp_rowerrors_1 = null;
        for (int i = 0; i < len; ++i) {
            tmp_rowerrors = rowErrors[i];
            for (int j = len - 1; j > i; --j) {
                tmp_rowerrors_1 = rowErrors[j];
                if (!tmp_rowerrors.getErrorMessage().getErrorcode().equals(tmp_rowerrors_1.getErrorMessage().getErrorcode())) continue;
                rowParams_rtn5.removeRowErrors(rowErrors[j]);
                --len;
            }
        }
    }

    private void filterVertifyCommand(List<Operation> opers) {
        Iterator<Operation> iter = opers.iterator();
        while (iter.hasNext()) {
            Operation oper_rtn = iter.next();
            if (!"NSCMD_CFG_VERIFY".equalsIgnoreCase(oper_rtn.getName())) continue;
            iter.remove();
        }
    }

    private boolean isRTN600(int neid) {
        boolean isrtn600 = false;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        int netype_1 = neObj.getNEType();
        if (60 == netype_1 || 54 == netype_1 || 55 == netype_1 || TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_PACKETMICROWAVE_NE")) {
            isrtn600 = true;
        }
        return isrtn600;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)(neid + 0), (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        if (this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            try {
                this.distinctErrorCodeItemFilter(this.outputData);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("handleMessage fail!", (Throwable)e);
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38669);
        return list;
    }

    public int getTimeOut() {
        return 60;
    }
}

